/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;

public abstract class FastLoadedDiceRollerDiscreteSampler
implements SharedStateDiscreteSampler {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int MAX_BIASED_EXPONENT = 2046;
    private static final int MANTISSA_SIZE = 52;
    private static final long MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final int MAX_OFFSET = 10;
    private static final int NO_LABEL = Integer.MAX_VALUE;
    private static final String SAMPLER_NAME = "Fast Loaded Dice Roller";

    FastLoadedDiceRollerDiscreteSampler() {
    }

    @Override
    public abstract FastLoadedDiceRollerDiscreteSampler withUniformRandomProvider(UniformRandomProvider var1);

    public static FastLoadedDiceRollerDiscreteSampler of(UniformRandomProvider rng, long[] frequencies) {
        long m = FastLoadedDiceRollerDiscreteSampler.sum(frequencies);
        int[] indices = FastLoadedDiceRollerDiscreteSampler.indicesOfNonZero(frequencies);
        if (indices.length == 1) {
            return new FixedValueDiscreteSampler(FastLoadedDiceRollerDiscreteSampler.indexOfNonZero(frequencies));
        }
        return FastLoadedDiceRollerDiscreteSampler.createSampler(rng, frequencies, indices, m);
    }

    public static FastLoadedDiceRollerDiscreteSampler of(UniformRandomProvider rng, double[] weights) {
        return FastLoadedDiceRollerDiscreteSampler.of(rng, weights, 0);
    }

    public static FastLoadedDiceRollerDiscreteSampler of(UniformRandomProvider rng, double[] weights, int alpha) {
        int n = FastLoadedDiceRollerDiscreteSampler.checkWeightsNonZeroLength(weights);
        long[] frequencies = new long[n];
        int[] offsets = new int[n];
        FastLoadedDiceRollerDiscreteSampler.convertToIntegers(weights, frequencies, offsets, alpha);
        int[] indices = FastLoadedDiceRollerDiscreteSampler.indicesOfNonZero(frequencies);
        if (indices.length == 1) {
            return new FixedValueDiscreteSampler(FastLoadedDiceRollerDiscreteSampler.indexOfNonZero(frequencies));
        }
        BigInteger m = FastLoadedDiceRollerDiscreteSampler.sum(frequencies, offsets, indices);
        if (m.compareTo(MAX_LONG) <= 0) {
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                frequencies[n2] = frequencies[n2] << offsets[i];
            }
            return FastLoadedDiceRollerDiscreteSampler.createSampler(rng, frequencies, indices, m.longValue());
        }
        return FastLoadedDiceRollerDiscreteSampler.createSampler(rng, frequencies, offsets, indices, m);
    }

    private static long sum(long[] frequencies) {
        if (frequencies == null || frequencies.length == 0) {
            throw new IllegalArgumentException("frequencies must contain at least 1 value");
        }
        long m = 0L;
        long signFlag = 0L;
        for (long o : frequencies) {
            signFlag |= o | (m += o);
        }
        if (signFlag < 0L) {
            for (long o : frequencies) {
                if (o >= 0L) continue;
                throw new IllegalArgumentException("frequencies must contain positive values: " + o);
            }
            throw new IllegalArgumentException("Overflow when summing frequencies");
        }
        if (m == 0L) {
            throw new IllegalArgumentException("Sum of frequencies is zero");
        }
        return m;
    }

    private static void convertToIntegers(double[] weights, long[] values, int[] exponents, int alpha) {
        int maxExponent = Integer.MIN_VALUE;
        for (int i = 0; i < weights.length; ++i) {
            long mantissa;
            double weight = weights[i];
            if (weight == 0.0) continue;
            long bits = Double.doubleToRawLongBits(weight);
            int exp = (int)(bits >>> 52);
            if (exp > 2046) {
                throw new IllegalArgumentException("Invalid weight: " + weight);
            }
            if (exp == 0) {
                mantissa = (bits & 0xFFFFFFFFFFFFFL) << 1;
                int shift = Long.numberOfLeadingZeros(mantissa << 11);
                mantissa <<= shift;
                exp -= shift;
            } else {
                mantissa = bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            }
            values[i] = mantissa;
            exponents[i] = exp;
            maxExponent = Math.max(maxExponent, exp);
        }
        if (maxExponent == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Sum of weights is zero");
        }
        FastLoadedDiceRollerDiscreteSampler.filterWeights(values, exponents, alpha, maxExponent);
        FastLoadedDiceRollerDiscreteSampler.scaleWeights(values, exponents);
    }

    private static void filterWeights(long[] values, int[] exponents, int alpha, int maxExponent) {
        if (alpha > 0) {
            for (int i = 0; i < exponents.length; ++i) {
                if (maxExponent - exponents[i] <= alpha) continue;
                values[i] = 0L;
            }
        }
    }

    private static void scaleWeights(long[] values, int[] exponents) {
        int i;
        int minExponent = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < exponents.length; ++i2) {
            if (values[i2] == 0L) continue;
            minExponent = Math.min(minExponent, exponents[i2]);
        }
        int trailingZeros = 64;
        for (i = 0; i < values.length && trailingZeros != 0; ++i) {
            trailingZeros = Math.min(trailingZeros, Long.numberOfTrailingZeros(values[i]));
        }
        i = 0;
        while (i < exponents.length) {
            int n = i++;
            exponents[n] = exponents[n] - minExponent;
        }
        if (trailingZeros != 0) {
            i = 0;
            while (i < values.length) {
                int n = i++;
                values[n] = values[n] >>> trailingZeros;
            }
        }
    }

    private static BigInteger sum(long[] values, int[] exponents, int[] indices) {
        BigInteger m = BigInteger.ZERO;
        for (int i : indices) {
            m = m.add(FastLoadedDiceRollerDiscreteSampler.toBigInteger(values[i], exponents[i]));
        }
        return m;
    }

    private static BigInteger toBigInteger(long value, int offset) {
        if (offset <= 10) {
            return BigInteger.valueOf(value << offset);
        }
        return BigInteger.valueOf(value).shiftLeft(offset);
    }

    private static FastLoadedDiceRollerDiscreteSampler createSampler(UniformRandomProvider rng, long[] frequencies, int[] indices, long m) {
        int n = frequencies.length;
        int k = 64 - Long.numberOfLeadingZeros(m - 1L);
        long r = (1L << k) - m;
        int[] h = new int[k];
        int[] lH = new int[FastLoadedDiceRollerDiscreteSampler.checkArraySize(((long)n + 1L) * (long)k)];
        Arrays.fill(lH, Integer.MAX_VALUE);
        for (int j = 0; j < k; ++j) {
            int shift = k - 1 - j;
            long bitMask = 1L << shift;
            int d = 0;
            for (int i : indices) {
                if ((frequencies[i] & bitMask) == 0L) continue;
                int n2 = j;
                h[n2] = h[n2] + 1;
                lH[d * k + j] = i;
                ++d;
            }
            if ((r & bitMask) == 0L) continue;
            int n3 = j;
            h[n3] = h[n3] + 1;
            lH[d * k + j] = n;
        }
        return new FLDRSampler(rng, n, k, h, lH);
    }

    private static FastLoadedDiceRollerDiscreteSampler createSampler(UniformRandomProvider rng, long[] frequencies, int[] offsets, int[] indices, BigInteger m) {
        int n = frequencies.length;
        int k = m.subtract(BigInteger.ONE).bitLength();
        BigInteger r = BigInteger.ONE.shiftLeft(k).subtract(m);
        int[] h = new int[k];
        int[] lH = new int[FastLoadedDiceRollerDiscreteSampler.checkArraySize(((long)n + 1L) * (long)k)];
        Arrays.fill(lH, Integer.MAX_VALUE);
        for (int j = 0; j < k; ++j) {
            int shift = k - 1 - j;
            int d = 0;
            for (int i : indices) {
                if (!FastLoadedDiceRollerDiscreteSampler.testBit(frequencies[i], offsets[i], shift)) continue;
                int n2 = j;
                h[n2] = h[n2] + 1;
                lH[d * k + j] = i;
                ++d;
            }
            if (!r.testBit(shift)) continue;
            int n3 = j;
            h[n3] = h[n3] + 1;
            lH[d * k + j] = n;
        }
        return new FLDRSampler(rng, n, k, h, lH);
    }

    private static boolean testBit(long value, int offset, int n) {
        if (n < offset) {
            return false;
        }
        int bit = n - offset;
        return bit <= 52 && (value & 1L << bit) != 0L;
    }

    private static int checkWeightsNonZeroLength(double[] weights) {
        if (weights == null || weights.length == 0) {
            throw new IllegalArgumentException("weights must contain at least 1 value");
        }
        return weights.length;
    }

    private static int[] indicesOfNonZero(long[] values) {
        int n = 0;
        int[] indices = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0L) continue;
            indices[n++] = i;
        }
        return Arrays.copyOf(indices, n);
    }

    static int indexOfNonZero(long[] frequencies) {
        for (int i = 0; i < frequencies.length; ++i) {
            if (frequencies[i] == 0L) continue;
            return i;
        }
        throw new IllegalStateException("All frequencies are zero");
    }

    static int checkArraySize(long size) {
        if (size > 0x7FFFFFF7L) {
            throw new IllegalArgumentException("Unable to allocate array of size: " + size);
        }
        return (int)size;
    }

    private static final class FLDRSampler
    extends FastLoadedDiceRollerDiscreteSampler {
        private static final int EMPTY_BOOL_SOURCE = 1;
        private final UniformRandomProvider rng;
        private final int n;
        private final int k;
        private final int[] h;
        private final int[] lH;
        private int booleanSource = 1;

        FLDRSampler(UniformRandomProvider rng, int n, int k, int[] h, int[] lH) {
            this.rng = rng;
            this.n = n;
            this.k = k;
            this.h = h;
            this.lH = lH;
        }

        private FLDRSampler(UniformRandomProvider rng, FLDRSampler source) {
            this.rng = rng;
            this.n = source.n;
            this.k = source.k;
            this.h = source.h;
            this.lH = source.lH;
        }

        @Override
        public int sample() {
            int c = 0;
            int d = 0;
            while (true) {
                if ((d = (d << 1) + this.flip()) < this.h[c]) {
                    int z = this.lH[d * this.k + c];
                    if (z < this.n) {
                        return z;
                    }
                    d = 0;
                    c = 0;
                    continue;
                }
                d -= this.h[c];
                ++c;
            }
        }

        private int flip() {
            int bits = this.booleanSource;
            if (bits == 1) {
                bits = this.rng.nextInt();
                this.booleanSource = Integer.MIN_VALUE | bits >>> 1;
                return bits & 1;
            }
            this.booleanSource = bits >>> 1;
            return bits & 1;
        }

        public String toString() {
            return "Fast Loaded Dice Roller [" + this.rng.toString() + "]";
        }

        @Override
        public FastLoadedDiceRollerDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new FLDRSampler(rng, this);
        }
    }

    private static final class FixedValueDiscreteSampler
    extends FastLoadedDiceRollerDiscreteSampler {
        private final int sampleValue;

        FixedValueDiscreteSampler(int sampleValue) {
            this.sampleValue = sampleValue;
        }

        @Override
        public int sample() {
            return this.sampleValue;
        }

        @Override
        public FastLoadedDiceRollerDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return this;
        }

        public String toString() {
            return FastLoadedDiceRollerDiscreteSampler.SAMPLER_NAME;
        }
    }
}

