/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.clustering;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.clustering.DoublePoint;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import org.apache.commons.math3.ml.clustering.MultiKMeansPlusPlusClusterer;
import org.junit.Assert;
import org.junit.Test;

public class MultiKMeansPlusPlusClustererTest {
    @Test
    public void dimension2() {
        MultiKMeansPlusPlusClusterer transformer = new MultiKMeansPlusPlusClusterer(new KMeansPlusPlusClusterer(3, 10), 5);
        DoublePoint[] points = new DoublePoint[]{new DoublePoint(new int[]{-15, 3}), new DoublePoint(new int[]{-15, 4}), new DoublePoint(new int[]{-15, 5}), new DoublePoint(new int[]{-14, 3}), new DoublePoint(new int[]{-14, 5}), new DoublePoint(new int[]{-13, 3}), new DoublePoint(new int[]{-13, 4}), new DoublePoint(new int[]{-13, 5}), new DoublePoint(new int[]{-1, 0}), new DoublePoint(new int[]{-1, -1}), new DoublePoint(new int[]{0, -1}), new DoublePoint(new int[]{1, -1}), new DoublePoint(new int[]{1, -2}), new DoublePoint(new int[]{13, 3}), new DoublePoint(new int[]{13, 4}), new DoublePoint(new int[]{14, 4}), new DoublePoint(new int[]{14, 7}), new DoublePoint(new int[]{16, 5}), new DoublePoint(new int[]{16, 6}), new DoublePoint(new int[]{17, 4}), new DoublePoint(new int[]{17, 7})};
        List clusters = transformer.cluster(Arrays.asList(points));
        Assert.assertEquals((long)3L, (long)clusters.size());
        boolean cluster1Found = false;
        boolean cluster2Found = false;
        boolean cluster3Found = false;
        double epsilon = 1.0E-6;
        for (CentroidCluster cluster : clusters) {
            Clusterable center = cluster.getCenter();
            double[] point = center.getPoint();
            if (point[0] < 0.0) {
                cluster1Found = true;
                Assert.assertEquals((long)8L, (long)cluster.getPoints().size());
                Assert.assertEquals((double)-14.0, (double)point[0], (double)epsilon);
                Assert.assertEquals((double)4.0, (double)point[1], (double)epsilon);
                continue;
            }
            if (point[1] < 0.0) {
                cluster2Found = true;
                Assert.assertEquals((long)5L, (long)cluster.getPoints().size());
                Assert.assertEquals((double)0.0, (double)point[0], (double)epsilon);
                Assert.assertEquals((double)-1.0, (double)point[1], (double)epsilon);
                continue;
            }
            cluster3Found = true;
            Assert.assertEquals((long)8L, (long)cluster.getPoints().size());
            Assert.assertEquals((double)15.0, (double)point[0], (double)epsilon);
            Assert.assertEquals((double)5.0, (double)point[1], (double)epsilon);
        }
        Assert.assertTrue((boolean)cluster1Found);
        Assert.assertTrue((boolean)cluster2Found);
        Assert.assertTrue((boolean)cluster3Found);
    }
}

