/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.issues;

import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathNotFoundException;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.model.beans.BeanPropertyPointer;
import org.apache.commons.jxpath.ri.model.beans.NullPropertyPointer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JXPath172Test
extends AbstractJXPathTest {
    private JXPathContext getContext(String val, boolean lenient) {
        TestBean172 b = new TestBean172();
        b.setValue(val);
        TestBean172 target = b;
        JXPathContext context = JXPathContext.newContext(null, (Object)target);
        context.setLenient(lenient);
        return context;
    }

    @Test
    public void testIssue172_NestedPropertyUnexisting() {
        JXPathContext context = this.getContext(null, true);
        Object bRet = context.selectSingleNode("value.child");
        Assertions.assertNull((Object)bRet, (String)"not null!!");
        Pointer pointer = context.getPointer("value.child");
        Assertions.assertNotNull((Object)pointer);
        Assertions.assertEquals(NullPropertyPointer.class, (Object)pointer.getClass());
        Assertions.assertNull((Object)pointer.getValue());
    }

    @Test
    public void testIssue172_propertyDoesNotExist_NotLenient() {
        JXPathContext context = this.getContext(null, false);
        Assertions.assertThrows(JXPathNotFoundException.class, () -> context.selectSingleNode("unexisting"));
        Assertions.assertThrows(JXPathNotFoundException.class, () -> context.getPointer("unexisting"));
        Assertions.assertThrows(JXPathNotFoundException.class, () -> context.getPointer("value.unexisting"));
    }

    @Test
    public void testIssue172_propertyExistAndIsNotNull() {
        JXPathContext context = this.getContext("ciao", false);
        Object bRet = context.selectSingleNode("value");
        Assertions.assertNotNull((Object)bRet, (String)"null!!");
        Assertions.assertEquals((Object)"ciao", (Object)bRet, (String)("Is " + bRet.getClass()));
        Pointer pointer = context.getPointer("value");
        Assertions.assertNotNull((Object)pointer);
        Assertions.assertEquals(BeanPropertyPointer.class, (Object)pointer.getClass());
        Assertions.assertEquals((Object)"ciao", (Object)pointer.getValue());
    }

    @Test
    public void testIssue172_propertyExistAndIsNull() {
        JXPathContext context = this.getContext(null, false);
        Object bRet = context.selectSingleNode("value");
        Assertions.assertNull((Object)bRet, (String)"not null!!");
        Pointer pointer = context.getPointer("value");
        Assertions.assertNotNull((Object)pointer);
        Assertions.assertEquals(BeanPropertyPointer.class, (Object)pointer.getClass());
        Assertions.assertNull((Object)pointer.getValue());
    }

    @Test
    public void testIssue172_PropertyUnexisting() {
        JXPathContext context = this.getContext(null, true);
        Object bRet = context.selectSingleNode("unexisting");
        Assertions.assertNull((Object)bRet, (String)"not null!!");
        Pointer pointer = context.getPointer("unexisting");
        Assertions.assertNotNull((Object)pointer);
        Assertions.assertEquals(NullPropertyPointer.class, (Object)pointer.getClass());
        Assertions.assertNull((Object)pointer.getValue());
    }

    public static class TestBean172 {
        String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

