/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.rgbe;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.rgbe.AbstractRgbeTest;
import org.apache.commons.imaging.formats.rgbe.RgbeImageParser;
import org.apache.commons.imaging.formats.rgbe.RgbeImagingParameters;
import org.apache.commons.imaging.internal.Debug;
import org.apache.commons.imaging.test.TestResources;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RgbeReadTest
extends AbstractRgbeTest {
    @Test
    public void test() throws IOException, ImagingException {
        Debug.debug((String)"start");
        List<File> images = this.getRgbeImages();
        for (File imageFile : images) {
            Debug.debug((String)"imageFile", (Object)imageFile);
            ImageMetadata metadata = Imaging.getMetadata((File)imageFile);
            Assertions.assertNotNull((Object)metadata);
            ImageInfo imageInfo = Imaging.getImageInfo((File)imageFile);
            Assertions.assertNotNull((Object)imageInfo);
            BufferedImage image = Imaging.getBufferedImage((File)imageFile);
            Assertions.assertNotNull((Object)image);
        }
    }

    @Test
    public void testErrorDecompressingInvalidFile() {
        File inputFile = TestResources.resourceToFile("/IMAGING-219/timeout-9713502c9c371f1654b493650c16ab17c0444369.hdr");
        ByteSource byteSourceFile = ByteSource.file((File)inputFile);
        RgbeImagingParameters params = new RgbeImagingParameters();
        Assertions.assertThrows(ImagingException.class, () -> new RgbeImageParser().getBufferedImage(byteSourceFile, params));
    }
}

