/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.collections4.bloomfilter.AbstractBloomFilterTest;
import org.apache.commons.collections4.bloomfilter.BitMapExtractor;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.DefaultBloomFilterTest;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IncrementingHasher;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.apache.commons.collections4.bloomfilter.LayerManager;
import org.apache.commons.collections4.bloomfilter.LayeredBloomFilter;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.SimpleBloomFilter;
import org.apache.commons.collections4.bloomfilter.SparseBloomFilter;
import org.apache.commons.collections4.bloomfilter.TestingHashers;
import org.apache.commons.collections4.bloomfilter.WrappedBloomFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LayeredBloomFilterTest
extends AbstractBloomFilterTest<LayeredBloomFilter<?>> {
    private static final List<String> dbgInstrument = new ArrayList<String>();
    private final Predicate<BloomFilter> dbg = bf -> {
        TimestampedBloomFilter tbf = (TimestampedBloomFilter)((Object)bf);
        Instant ts = Instant.now();
        dbgInstrument.add(String.format("T:%s (Elapsed:%s)- EstN:%s (Card:%s)\n", tbf.timestamp, Duration.between(tbf.timestamp, ts), tbf.estimateN(), tbf.cardinality()));
        return true;
    };

    static LayeredBloomFilter<TimestampedBloomFilter<SimpleBloomFilter>> createTimedLayeredFilter(Shape shape, Duration duration, Duration quanta) {
        LayerManager.Builder builder = LayerManager.builder();
        Consumer cleanup = LayerManager.Cleanup.removeEmptyTarget().andThen(new CleanByTime(duration));
        LayerManager layerManager = builder.setSupplier(() -> new TimestampedBloomFilter<SimpleBloomFilter>(new SimpleBloomFilter(shape))).setCleanup(cleanup).setExtendCheck(new AdvanceOnTimeQuanta(quanta).or(LayerManager.ExtendCheck.advanceOnSaturation((double)shape.estimateMaxN()))).get();
        return new LayeredBloomFilter(shape, layerManager);
    }

    public static LayeredBloomFilter<SimpleBloomFilter> fixed(Shape shape, int maxDepth) {
        return LayeredBloomFilterTest.fixed(shape, maxDepth, () -> new SimpleBloomFilter(shape));
    }

    public static <T extends BloomFilter<T>> LayeredBloomFilter<T> fixed(Shape shape, int maxDepth, Supplier<T> supplier) {
        LayerManager.Builder builder = LayerManager.builder();
        builder.setExtendCheck(LayerManager.ExtendCheck.advanceOnPopulated()).setCleanup(LayerManager.Cleanup.onMaxSize((int)maxDepth)).setSupplier(supplier);
        return new LayeredBloomFilter(shape, builder.get());
    }

    @Override
    protected LayeredBloomFilter<SimpleBloomFilter> createEmptyFilter(Shape shape) {
        return LayeredBloomFilterTest.fixed(shape, 10);
    }

    protected BloomFilter makeFilter(Hasher h) {
        SparseBloomFilter bf = new SparseBloomFilter(this.getTestShape());
        bf.merge(h);
        return bf;
    }

    protected BloomFilter makeFilter(IndexExtractor p) {
        SparseBloomFilter bf = new SparseBloomFilter(this.getTestShape());
        bf.merge(p);
        return bf;
    }

    protected BloomFilter makeFilter(int ... values) {
        return this.makeFilter(IndexExtractor.fromIndexArray((int[])values));
    }

    private LayeredBloomFilter<SimpleBloomFilter> setupFindTest() {
        LayeredBloomFilter<SimpleBloomFilter> filter = LayeredBloomFilterTest.fixed(this.getTestShape(), 10);
        filter.merge(TestingHashers.FROM1);
        filter.merge(TestingHashers.FROM11);
        filter.merge((Hasher)new IncrementingHasher(11L, 2L));
        filter.merge((BloomFilter)TestingHashers.populateFromHashersFrom1AndFrom11(new SimpleBloomFilter(this.getTestShape())));
        return filter;
    }

    @Override
    @Test
    public void testCardinalityAndIsEmpty() {
        LayerManager layerManager = LayerManager.builder().setExtendCheck(LayerManager.ExtendCheck.neverAdvance()).setSupplier(() -> new SimpleBloomFilter(this.getTestShape())).get();
        this.testCardinalityAndIsEmpty((BloomFilter)new LayeredBloomFilter(this.getTestShape(), layerManager));
    }

    @Test
    public void testCleanup() {
        int[] sequence = new int[]{1};
        LayerManager layerManager = LayerManager.builder().setSupplier(() -> {
            int n = sequence[0];
            sequence[0] = n + 1;
            return new NumberedBloomFilter(this.getTestShape(), 3, n);
        }).setExtendCheck(LayerManager.ExtendCheck.neverAdvance()).setCleanup(ll -> ll.removeIf(f -> f.value-- == 0)).get();
        LayeredBloomFilter underTest = new LayeredBloomFilter(this.getTestShape(), layerManager);
        Assertions.assertEquals((int)1, (int)underTest.getDepth());
        underTest.merge(TestingHashers.randomHasher());
        underTest.cleanup();
        Assertions.assertEquals((int)1, (int)underTest.getDepth());
        underTest.next();
        Assertions.assertEquals((int)2, (int)underTest.getDepth());
        underTest.merge(TestingHashers.randomHasher());
        underTest.cleanup();
        NumberedBloomFilter f = (NumberedBloomFilter)underTest.get(0);
        Assertions.assertEquals((int)1, (int)f.sequence);
        Assertions.assertEquals((int)2, (int)underTest.getDepth());
        underTest.cleanup();
        Assertions.assertEquals((int)1, (int)underTest.getDepth());
        f = (NumberedBloomFilter)underTest.get(0);
        Assertions.assertEquals((int)2, (int)f.sequence);
        underTest.cleanup();
        underTest.cleanup();
        Assertions.assertEquals((int)1, (int)underTest.getDepth());
        f = (NumberedBloomFilter)underTest.get(0);
        Assertions.assertEquals((int)3, (int)f.sequence);
    }

    @Test
    public final void testEstimateUnionCrossTypes() {
        Object bf = this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        DefaultBloomFilterTest.SparseDefaultBloomFilter bf2 = new DefaultBloomFilterTest.SparseDefaultBloomFilter(this.getTestShape());
        bf2.merge(TestingHashers.FROM11);
        Assertions.assertEquals((int)2, (int)bf.estimateUnion((BloomFilter)bf2));
        Assertions.assertEquals((int)2, (int)bf2.estimateUnion((BloomFilter)bf));
    }

    @Test
    public void testExpiration() throws InterruptedException {
        int i;
        ArrayList lst = new ArrayList();
        Shape shape = Shape.fromNM((int)4, (int)64);
        LayeredBloomFilter<TimestampedBloomFilter<SimpleBloomFilter>> underTest = LayeredBloomFilterTest.createTimedLayeredFilter(shape, Duration.ofMillis(600L), Duration.ofMillis(150L));
        for (i = 0; i < 10; ++i) {
            underTest.merge(TestingHashers.randomHasher());
        }
        underTest.processBloomFilters(this.dbg.and(x -> lst.add(((TimestampedBloomFilter)((Object)x)).timestamp)));
        Assertions.assertTrue((underTest.getDepth() > 1 ? 1 : 0) != 0);
        Thread.sleep(300L);
        for (i = 0; i < 10; ++i) {
            underTest.merge(TestingHashers.randomHasher());
        }
        dbgInstrument.add("=== AFTER 300 milliseconds ====\n");
        underTest.processBloomFilters(this.dbg);
        Thread.sleep(150L);
        for (i = 0; i < 10; ++i) {
            underTest.merge(TestingHashers.randomHasher());
        }
        dbgInstrument.add("=== AFTER 450 milliseconds ====\n");
        underTest.processBloomFilters(this.dbg);
        Thread.sleep(200L);
        underTest.merge(TestingHashers.randomHasher());
        dbgInstrument.add("=== AFTER 600 milliseconds ====\n");
        Assertions.assertTrue((boolean)underTest.processBloomFilters(this.dbg.and(x -> !lst.contains(((TimestampedBloomFilter)((Object)x)).timestamp))), (String)("Found filter that should have been deleted: " + dbgInstrument.get(dbgInstrument.size() - 1)));
    }

    @Test
    public void testFindBitMapExtractor() {
        LayeredBloomFilter<SimpleBloomFilter> filter = this.setupFindTest();
        IndexExtractor indexExtractor = TestingHashers.FROM1.indices(this.getTestShape());
        BitMapExtractor bitMapExtractor = BitMapExtractor.fromIndexExtractor((IndexExtractor)indexExtractor, (int)this.getTestShape().getNumberOfBits());
        int[] expected = new int[]{0, 3};
        int[] result = filter.find(bitMapExtractor);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
        expected = new int[]{1, 3};
        indexExtractor = TestingHashers.FROM11.indices(this.getTestShape());
        bitMapExtractor = BitMapExtractor.fromIndexExtractor((IndexExtractor)indexExtractor, (int)this.getTestShape().getNumberOfBits());
        result = filter.find(bitMapExtractor);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
    }

    @Test
    public void testFindBloomFilter() {
        LayeredBloomFilter<SimpleBloomFilter> filter = this.setupFindTest();
        int[] expected = new int[]{0, 3};
        int[] result = filter.find(TestingHashers.FROM1);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
        expected = new int[]{1, 3};
        result = filter.find(TestingHashers.FROM11);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
    }

    @Test
    public void testFindIndexExtractor() {
        IndexExtractor indexExtractor = TestingHashers.FROM1.indices(this.getTestShape());
        LayeredBloomFilter<SimpleBloomFilter> filter = this.setupFindTest();
        int[] expected = new int[]{0, 3};
        int[] result = filter.find(indexExtractor);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
        expected = new int[]{1, 3};
        indexExtractor = TestingHashers.FROM11.indices(this.getTestShape());
        result = filter.find(indexExtractor);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
    }

    @Test
    public final void testGetLayer() {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.getTestShape());
        bf.merge(TestingHashers.FROM11);
        LayeredBloomFilter<SimpleBloomFilter> filter = LayeredBloomFilterTest.fixed(this.getTestShape(), 10);
        filter.merge(TestingHashers.FROM1);
        filter.merge(TestingHashers.FROM11);
        filter.merge((Hasher)new IncrementingHasher(11L, 2L));
        filter.merge((BloomFilter)TestingHashers.populateFromHashersFrom1AndFrom11(new SimpleBloomFilter(this.getTestShape())));
        Assertions.assertArrayEquals((long[])bf.asBitMapArray(), (long[])((SimpleBloomFilter)filter.get(1)).asBitMapArray());
    }

    @Test
    public void testMultipleFilters() {
        LayeredBloomFilter<SimpleBloomFilter> filter = LayeredBloomFilterTest.fixed(this.getTestShape(), 10);
        filter.merge(TestingHashers.FROM1);
        filter.merge(TestingHashers.FROM11);
        Assertions.assertEquals((int)2, (int)filter.getDepth());
        Assertions.assertTrue((boolean)filter.contains(this.makeFilter(TestingHashers.FROM1)));
        Assertions.assertTrue((boolean)filter.contains(this.makeFilter(TestingHashers.FROM11)));
        BloomFilter t1 = this.makeFilter(6, 7, 17, 18, 19);
        Assertions.assertFalse((boolean)filter.contains(t1));
        Assertions.assertFalse((boolean)filter.copy().contains(t1));
        Assertions.assertTrue((boolean)filter.flatten().contains(t1));
    }

    @Test
    public final void testNext() {
        LayerManager layerManager = LayerManager.builder().setSupplier(() -> new SimpleBloomFilter(this.getTestShape())).get();
        LayeredBloomFilter filter = new LayeredBloomFilter(this.getTestShape(), layerManager);
        filter.merge(TestingHashers.FROM1);
        filter.merge(TestingHashers.FROM11);
        Assertions.assertEquals((int)1, (int)filter.getDepth());
        filter.next();
        filter.merge((Hasher)new IncrementingHasher(11L, 2L));
        Assertions.assertEquals((int)2, (int)filter.getDepth());
        Assertions.assertTrue((boolean)((SimpleBloomFilter)filter.get(0)).contains(TestingHashers.FROM1));
        Assertions.assertTrue((boolean)((SimpleBloomFilter)filter.get(0)).contains(TestingHashers.FROM11));
        Assertions.assertFalse((boolean)((SimpleBloomFilter)filter.get(0)).contains((Hasher)new IncrementingHasher(11L, 2L)));
        Assertions.assertFalse((boolean)((SimpleBloomFilter)filter.get(1)).contains(TestingHashers.FROM1));
        Assertions.assertFalse((boolean)((SimpleBloomFilter)filter.get(1)).contains(TestingHashers.FROM11));
        Assertions.assertTrue((boolean)((SimpleBloomFilter)filter.get(1)).contains((Hasher)new IncrementingHasher(11L, 2L)));
    }

    static class CleanByTime<T extends TimestampedBloomFilter>
    implements Consumer<List<T>> {
        Duration elapsedTime;

        CleanByTime(Duration elapsedTime) {
            this.elapsedTime = elapsedTime;
        }

        @Override
        public void accept(List<T> t) {
            Instant min = Instant.now().minus(this.elapsedTime);
            Iterator<T> iter = t.iterator();
            while (iter.hasNext()) {
                TimestampedBloomFilter bf = (TimestampedBloomFilter)((Object)iter.next());
                if (bf.getTimestamp().isAfter(min) || bf.getTimestamp().equals(min)) {
                    return;
                }
                dbgInstrument.add(String.format("Removing old entry: T:%s (Aged: %s) \n", bf.getTimestamp(), Duration.between(bf.getTimestamp(), min)));
                iter.remove();
            }
        }
    }

    static class AdvanceOnTimeQuanta<T extends BloomFilter<T>>
    implements Predicate<LayerManager<TimestampedBloomFilter<T>>> {
        Duration quanta;

        AdvanceOnTimeQuanta(Duration quanta) {
            this.quanta = quanta;
        }

        @Override
        public boolean test(LayerManager<TimestampedBloomFilter<T>> layerManager) {
            return ((TimestampedBloomFilter)layerManager.last()).getTimestamp().plus(this.quanta).isBefore(Instant.now());
        }
    }

    static class NumberedBloomFilter
    extends WrappedBloomFilter<NumberedBloomFilter, SimpleBloomFilter> {
        int value;
        int sequence;

        NumberedBloomFilter(Shape shape, int value, int sequence) {
            super((BloomFilter)new SimpleBloomFilter(shape));
            this.value = value;
            this.sequence = sequence;
        }

        public NumberedBloomFilter copy() {
            return new NumberedBloomFilter(this.getShape(), this.value, this.sequence);
        }
    }

    public static class TimestampedBloomFilter<T extends BloomFilter<T>>
    extends WrappedBloomFilter<TimestampedBloomFilter<T>, T> {
        private final Instant timestamp;

        TimestampedBloomFilter(T bf) {
            this(bf, Instant.now());
        }

        TimestampedBloomFilter(T bf, Instant timestamp) {
            super(bf);
            this.timestamp = timestamp;
        }

        public TimestampedBloomFilter<T> copy() {
            return new TimestampedBloomFilter<BloomFilter>(this.getWrapped().copy(), this.timestamp);
        }

        public Instant getTimestamp() {
            return this.timestamp;
        }
    }
}

