/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.util.Set;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.bag.AbstractBagTest;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.bag.PredicatedBag;
import org.apache.commons.collections4.functors.TruePredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PredicatedBagTest<T>
extends AbstractBagTest<T> {
    protected Predicate<T> truePredicate = TruePredicate.truePredicate();

    protected Bag<T> decorateBag(HashBag<T> bag, Predicate<T> predicate) {
        return PredicatedBag.predicatedBag(bag, predicate);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    protected int getIterationBehaviour() {
        return 1;
    }

    @Override
    public Bag<T> makeObject() {
        return this.decorateBag(new HashBag(), this.truePredicate);
    }

    protected Bag<T> makeTestBag() {
        return this.decorateBag(new HashBag(), this.stringPredicate());
    }

    protected Predicate<T> stringPredicate() {
        return String.class::isInstance;
    }

    @Test
    public void testIllegalAdd() {
        Bag bag = this.makeTestBag();
        Integer i = 3;
        Assertions.assertThrows(IllegalArgumentException.class, () -> bag.add((Object)i));
        Assertions.assertFalse((boolean)bag.contains((Object)i), (String)"Collection shouldn't contain illegal element");
    }

    @Test
    public void testIllegalDecorate() {
        HashBag elements = new HashBag();
        elements.add((Object)"one");
        elements.add((Object)"two");
        elements.add((Object)3);
        elements.add((Object)"four");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.decorateBag(elements, this.stringPredicate()));
        Assertions.assertThrows(NullPointerException.class, () -> this.decorateBag(new HashBag(), null));
    }

    @Test
    public void testLegalAddRemove() {
        Bag<T> bag = this.makeTestBag();
        Assertions.assertEquals((int)0, (int)bag.size());
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "1"};
        for (int i = 0; i < els.length; ++i) {
            bag.add(els[i]);
            Assertions.assertEquals((int)(i + 1), (int)bag.size());
            Assertions.assertTrue((boolean)bag.contains(els[i]));
        }
        Set set = bag.uniqueSet();
        Assertions.assertTrue((boolean)set.contains(els[0]), (String)"Unique set contains the first element");
        Assertions.assertTrue((boolean)bag.remove(els[0]));
        set = bag.uniqueSet();
        Assertions.assertFalse((boolean)set.contains(els[0]), (String)"Unique set now does not contain the first element");
    }
}

