package org.apache.cayenne.testdo.testmap.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.exp.property.ListProperty;
import org.apache.cayenne.exp.property.NumericIdProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.SelfProperty;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.testmap.Exhibit;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;

/**
 * Class _Gallery was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _Gallery extends PersistentObject {

    private static final long serialVersionUID = 1L;

    public static final SelfProperty<Gallery> SELF = PropertyFactory.createSelf(Gallery.class);

    public static final NumericIdProperty<Integer> GALLERY_ID_PK_PROPERTY = PropertyFactory.createNumericId("GALLERY_ID", "Gallery", Integer.class);
    public static final String GALLERY_ID_PK_COLUMN = "GALLERY_ID";

    public static final StringProperty<String> GALLERY_NAME = PropertyFactory.createString("galleryName", String.class);
    public static final ListProperty<Exhibit> EXHIBIT_ARRAY = PropertyFactory.createList("exhibitArray", Exhibit.class);
    public static final ListProperty<Painting> PAINTING_ARRAY = PropertyFactory.createList("paintingArray", Painting.class);

    protected String galleryName;

    protected Object exhibitArray;
    protected Object paintingArray;

    public void setGalleryName(String galleryName) {
        beforePropertyWrite("galleryName", this.galleryName, galleryName);
        this.galleryName = galleryName;
    }

    public String getGalleryName() {
        beforePropertyRead("galleryName");
        return this.galleryName;
    }

    public void addToExhibitArray(Exhibit obj) {
        addToManyTarget("exhibitArray", obj, true);
    }

    public void removeFromExhibitArray(Exhibit obj) {
        removeToManyTarget("exhibitArray", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<Exhibit> getExhibitArray() {
        return (List<Exhibit>)readProperty("exhibitArray");
    }

    public void addToPaintingArray(Painting obj) {
        addToManyTarget("paintingArray", obj, true);
    }

    public void removeFromPaintingArray(Painting obj) {
        removeToManyTarget("paintingArray", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<Painting> getPaintingArray() {
        return (List<Painting>)readProperty("paintingArray");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "galleryName":
                return this.galleryName;
            case "exhibitArray":
                return this.exhibitArray;
            case "paintingArray":
                return this.paintingArray;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "galleryName":
                this.galleryName = (String)val;
                break;
            case "exhibitArray":
                this.exhibitArray = val;
                break;
            case "paintingArray":
                this.paintingArray = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.galleryName);
        out.writeObject(this.exhibitArray);
        out.writeObject(this.paintingArray);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.galleryName = (String)in.readObject();
        this.exhibitArray = in.readObject();
        this.paintingArray = in.readObject();
    }

}
