/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc.reader;

import java.sql.ResultSet;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.reader.BaseRowReader;
import org.apache.cayenne.access.jdbc.reader.DataRowPostProcessor;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.util.Util;

class FullRowReader
extends BaseRowReader<DataRow> {
    int mapCapacity;

    FullRowReader(RowDescriptor descriptor, QueryMetadata queryMetadata, DataRowPostProcessor postProcessor) {
        super(descriptor, queryMetadata, postProcessor);
        this.mapCapacity = (int)Math.ceil((double)descriptor.getWidth() / 0.75);
    }

    @Override
    public DataRow readRow(ResultSet resultSet) {
        try {
            DataRow dataRow = new DataRow(this.mapCapacity);
            int resultWidth = this.labels.length;
            for (int i = 0; i < resultWidth; ++i) {
                Object val = this.converters[i].materializeObject(resultSet, i + 1, this.types[i]);
                dataRow.put(this.labels[i], val);
            }
            this.postprocessRow(resultSet, dataRow);
            return dataRow;
        }
        catch (CayenneRuntimeException cex) {
            throw cex;
        }
        catch (Exception otherex) {
            throw new CayenneRuntimeException("Exception materializing column.", Util.unwindException(otherex), new Object[0]);
        }
    }

    void postprocessRow(ResultSet resultSet, DataRow dataRow) throws Exception {
        if (this.postProcessor != null) {
            this.postProcessor.postprocessRow(resultSet, dataRow);
        }
        dataRow.setEntityName(this.entityName);
    }
}

