/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc.reader;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.ClassDescriptor;

class DataRowPostProcessor {
    private EntityInheritanceTree inheritanceTree;
    private Map<String, Collection<ColumnOverride>> columnOverrides;
    private Collection<ColumnOverride> defaultOverrides;

    DataRowPostProcessor(ClassDescriptor classDescriptor, Map<String, Collection<ColumnOverride>> columnOverrides) {
        if (classDescriptor != null && classDescriptor.hasSubclasses()) {
            this.inheritanceTree = classDescriptor.getEntityInheritanceTree();
            this.columnOverrides = columnOverrides;
        } else {
            if (columnOverrides.size() != 1) {
                throw new IllegalArgumentException("No inheritance - there must be only one override set");
            }
            this.defaultOverrides = columnOverrides.values().iterator().next();
        }
    }

    void postprocessRow(ResultSet resultSet, DataRow row) throws Exception {
        Collection<ColumnOverride> overrides = this.getOverrides(row);
        if (overrides != null) {
            for (ColumnOverride override : overrides) {
                Object newValue = override.converter.materializeObject(resultSet, override.index, override.jdbcType);
                row.put(override.key, newValue);
            }
        }
    }

    private final Collection<ColumnOverride> getOverrides(DataRow row) {
        if (this.defaultOverrides != null) {
            return this.defaultOverrides;
        }
        ObjEntity entity = this.inheritanceTree.entityMatchingRow(row);
        return entity != null ? this.columnOverrides.get(entity.getName()) : null;
    }

    static final class ColumnOverride {
        int index;
        int jdbcType;
        String key;
        ExtendedType converter;

        ColumnOverride(int index, String key, ExtendedType converter, int jdbcType) {
            this.index = index;
            this.key = key;
            this.converter = converter;
            this.jdbcType = jdbcType;
        }
    }
}

