/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.frontbase;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.sqlbuilder.QuotingAppendable;
import org.apache.cayenne.access.sqlbuilder.sqltree.FunctionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.OpExpressionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.TextNode;
import org.apache.cayenne.access.translator.select.BaseSQLTreeProcessor;

public class FrontBaseSQLTreeProcessor
extends BaseSQLTreeProcessor {
    @Override
    protected void onFunctionNode(Node parent, FunctionNode child, int index) {
        switch (child.getFunctionName()) {
            case "CONCAT": {
                FrontBaseSQLTreeProcessor.replaceChild(parent, index, new OpExpressionNode("||"));
                break;
            }
            case "LOCATE": {
                FrontBaseSQLTreeProcessor.replaceChild(parent, index, new FunctionNode("POSITION", child.getAlias()){

                    @Override
                    public void appendChildrenSeparator(QuotingAppendable buffer, int childIdx) {
                        buffer.append(" IN ");
                    }
                });
                break;
            }
            case "LENGTH": {
                FrontBaseSQLTreeProcessor.replaceChild(parent, index, new FunctionNode("CHAR_LENGTH", child.getAlias()));
                break;
            }
            case "SUBSTRING": {
                FrontBaseSQLTreeProcessor.replaceChild(parent, index, new FunctionNode("SUBSTRING", child.getAlias()){

                    @Override
                    public void appendChildrenSeparator(QuotingAppendable buffer, int childIdx) {
                        if (childIdx == 0) {
                            buffer.append(" FROM ");
                        } else if (childIdx == 1) {
                            buffer.append(" FOR ");
                        }
                    }
                });
                break;
            }
            case "YEAR": 
            case "MONTH": 
            case "DAY": 
            case "DAY_OF_MONTH": 
            case "HOUR": 
            case "MINUTE": 
            case "SECOND": {
                ExtractFunctionNode functionReplacement = new ExtractFunctionNode(child.getAlias());
                String functionName = child.getFunctionName();
                if ("DAY_OF_MONTH".equals(functionName)) {
                    functionName = "DAY";
                }
                functionReplacement.addChild(new TextNode(functionName));
                FrontBaseSQLTreeProcessor.replaceChild(parent, index, functionReplacement);
                break;
            }
            case "DAY_OF_WEEK": 
            case "DAY_OF_YEAR": 
            case "WEEK": {
                throw new CayenneRuntimeException("Function %s() is unsupported in FrontBase.", child.getFunctionName());
            }
        }
    }

    private static class ExtractFunctionNode
    extends FunctionNode {
        public ExtractFunctionNode(String alias) {
            super("EXTRACT", alias, true);
        }

        @Override
        public void appendChildrenSeparator(QuotingAppendable buffer, int childIdx) {
            buffer.append(" FROM ");
        }

        @Override
        public Node copy() {
            return new ExtractFunctionNode(this.getAlias());
        }
    }
}

