/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.batch;

import java.util.List;
import org.apache.cayenne.access.sqlbuilder.ExpressionNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.NodeBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLGenerationVisitor;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.translator.batch.BatchTranslatorContext;
import org.apache.cayenne.access.translator.select.DefaultQuotingAppendable;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;

public abstract class BaseBatchTranslator<T extends BatchQuery> {
    protected final BatchTranslatorContext<T> context;
    protected DbAttributeBinding[] bindings;

    public BaseBatchTranslator(T query, DbAdapter adapter) {
        this.context = new BatchTranslatorContext<T>(query, adapter);
    }

    public DbAttributeBinding[] getBindings() {
        return this.bindings;
    }

    protected String doTranslate(NodeBuilder nodeBuilder) {
        Node node = nodeBuilder.build();
        node = this.context.getAdapter().getSqlTreeProcessor().process(node);
        SQLGenerationVisitor visitor = new SQLGenerationVisitor(new DefaultQuotingAppendable(this.context));
        node.visit(visitor);
        this.bindings = this.context.getBindings().toArray(new DbAttributeBinding[0]);
        return visitor.getSQLString();
    }

    protected abstract boolean isNullAttribute(DbAttribute var1);

    protected ExpressionNodeBuilder buildQualifier(List<DbAttribute> attributeList) {
        ExpressionNodeBuilder eq = null;
        for (DbAttribute attr : attributeList) {
            Integer value = this.isNullAttribute(attr) ? null : Integer.valueOf(1);
            ExpressionNodeBuilder next = SQLBuilder.column(attr.getName()).attribute(attr).eq(SQLBuilder.value(value).attribute(attr));
            if (eq == null) {
                eq = next;
                continue;
            }
            eq = eq.and(next);
        }
        return eq;
    }
}

