/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataDomainDeleteBucket;
import org.apache.cayenne.access.DataDomainFlattenedBucket;
import org.apache.cayenne.access.DataDomainFlushObserver;
import org.apache.cayenne.access.DataDomainIndirectDiffBuilder;
import org.apache.cayenne.access.DataDomainInsertBucket;
import org.apache.cayenne.access.DataDomainUpdateBucket;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.FlattenedArcKey;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.ObjectStoreGraphDiff;
import org.apache.cayenne.access.flush.DataDomainFlushAction;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.tx.BaseTransaction;

@Deprecated
public class LegacyDataDomainFlushAction
implements DataDomainFlushAction {
    private final DataDomain domain;
    private DataContext context;
    private Map<Object, ObjectDiff> changesByObjectId;
    private CompoundDiff resultDiff;
    private Collection<ObjectId> resultDeletedIds;
    private Map<ObjectId, DataRow> resultModifiedSnapshots;
    private Collection<ObjectId> resultIndirectlyModifiedIds;
    private DataDomainInsertBucket insertBucket;
    private DataDomainUpdateBucket updateBucket;
    private DataDomainDeleteBucket deleteBucket;
    private DataDomainFlattenedBucket flattenedBucket;
    private List<Query> queries;
    private JdbcEventLogger logger;

    public LegacyDataDomainFlushAction(DataDomain domain) {
        this.domain = domain;
    }

    DataDomain getDomain() {
        return this.domain;
    }

    DataContext getContext() {
        return this.context;
    }

    Collection<ObjectId> getResultDeletedIds() {
        return this.resultDeletedIds;
    }

    CompoundDiff getResultDiff() {
        return this.resultDiff;
    }

    Collection<ObjectId> getResultIndirectlyModifiedIds() {
        return this.resultIndirectlyModifiedIds;
    }

    Map<ObjectId, DataRow> getResultModifiedSnapshots() {
        return this.resultModifiedSnapshots;
    }

    public void setJdbcEventLogger(JdbcEventLogger logger) {
        this.logger = logger;
    }

    public JdbcEventLogger getJdbcEventLogger() {
        return this.logger;
    }

    ObjectDiff objectDiff(Object objectId) {
        return this.changesByObjectId.get(objectId);
    }

    void addFlattenedInsert(DbEntity flattenedEntity, FlattenedArcKey flattenedInsertInfo) {
        this.flattenedBucket.addInsertArcKey(flattenedEntity, flattenedInsertInfo);
    }

    void addFlattenedDelete(DbEntity flattenedEntity, FlattenedArcKey flattenedDeleteInfo) {
        this.flattenedBucket.addFlattenedDelete(flattenedEntity, flattenedDeleteInfo);
    }

    @Override
    public GraphDiff flush(DataContext context, GraphDiff changes) {
        if (changes == null) {
            return new CompoundDiff();
        }
        if (!(changes instanceof ObjectStoreGraphDiff)) {
            throw new IllegalArgumentException("Expected 'ObjectStoreGraphDiff', got: " + changes.getClass().getName());
        }
        this.context = context;
        this.changesByObjectId = ((ObjectStoreGraphDiff)changes).getChangesByObjectId();
        this.insertBucket = new DataDomainInsertBucket(this);
        this.deleteBucket = new DataDomainDeleteBucket(this);
        this.updateBucket = new DataDomainUpdateBucket(this);
        this.flattenedBucket = new DataDomainFlattenedBucket(this);
        this.queries = new ArrayList<Query>();
        this.resultIndirectlyModifiedIds = new HashSet<ObjectId>();
        this.preprocess(context, changes);
        if (this.queries.isEmpty()) {
            return new CompoundDiff();
        }
        this.resultDiff = new CompoundDiff();
        this.resultDeletedIds = new ArrayList<ObjectId>();
        this.resultModifiedSnapshots = new HashMap<ObjectId, DataRow>();
        this.runQueries();
        this.postprocess(context);
        return this.resultDiff;
    }

    private void preprocess(DataContext context, GraphDiff changes) {
        ObjectStore objectStore = context.getObjectStore();
        for (Object o : this.changesByObjectId.keySet()) {
            ObjectId id = (ObjectId)o;
            Persistent object = (Persistent)objectStore.getNode(id);
            ClassDescriptor descriptor = context.getEntityResolver().getClassDescriptor(id.getEntityName());
            switch (object.getPersistenceState()) {
                case 2: {
                    this.insertBucket.addDirtyObject(object, descriptor);
                    break;
                }
                case 4: {
                    this.updateBucket.addDirtyObject(object, descriptor);
                    break;
                }
                case 6: {
                    this.deleteBucket.addDirtyObject(object, descriptor);
                }
            }
        }
        new DataDomainIndirectDiffBuilder(this).processIndirectChanges(changes);
        this.insertBucket.appendQueries(this.queries);
        this.flattenedBucket.appendInserts(this.queries);
        this.updateBucket.appendQueries(this.queries);
        this.flattenedBucket.appendDeletes(this.queries);
        this.deleteBucket.appendQueries(this.queries);
    }

    private void runQueries() {
        DataDomainFlushObserver observer = new DataDomainFlushObserver(this.domain.getJdbcEventLogger());
        try {
            DataNode lastNode = null;
            DbEntity lastEntity = null;
            int rangeStart = 0;
            int len = this.queries.size();
            for (int i = 0; i < len; ++i) {
                DataNode node;
                BatchQuery query = (BatchQuery)this.queries.get(i);
                if (query.getDbEntity() == lastEntity || (node = this.domain.lookupDataNode((lastEntity = query.getDbEntity()).getDataMap())) == lastNode) continue;
                if (i - rangeStart > 0) {
                    lastNode.performQueries(this.queries.subList(rangeStart, i), observer);
                }
                rangeStart = i;
                lastNode = node;
            }
            lastNode.performQueries(this.queries.subList(rangeStart, len), observer);
        }
        catch (Throwable th) {
            BaseTransaction.getThreadTransaction().setRollbackOnly();
            throw new CayenneRuntimeException("Transaction was rolledback.", th, new Object[0]);
        }
    }

    private void postprocess(DataContext context) {
        this.deleteBucket.postprocess();
        this.updateBucket.postprocess();
        this.insertBucket.postprocess();
        if (!(this.resultDeletedIds.isEmpty() && this.resultModifiedSnapshots.isEmpty() && this.resultIndirectlyModifiedIds.isEmpty())) {
            context.getObjectStore().getDataRowCache().processSnapshotChanges(context.getObjectStore(), this.resultModifiedSnapshots, this.resultDeletedIds, Collections.emptyList(), this.resultIndirectlyModifiedIds);
        }
        context.getObjectStore().postprocessAfterCommit(this.resultDiff);
    }
}

