/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote.service;

import java.io.Serializable;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.remote.BaseConnection;
import org.apache.cayenne.remote.ClientMessage;
import org.apache.cayenne.remote.hessian.service.HessianUtil;
import org.apache.cayenne.remote.service.DispatchHelper;
import org.apache.cayenne.util.Util;

public class LocalConnection
extends BaseConnection {
    public static final int NO_SERIALIZATION = 0;
    public static final int JAVA_SERIALIZATION = 1;
    public static final int HESSIAN_SERIALIZATION = 2;
    protected DataChannel channel;
    protected int serializationPolicy;

    public LocalConnection(DataChannel handler) {
        this(handler, 0);
    }

    public LocalConnection(DataChannel handler, int serializationPolicy) {
        this.channel = handler;
        this.serializationPolicy = serializationPolicy == 1 || serializationPolicy == 2 ? serializationPolicy : 0;
    }

    public boolean isSerializingMessages() {
        return this.serializationPolicy == 1 || this.serializationPolicy == 2;
    }

    public DataChannel getChannel() {
        return this.channel;
    }

    @Override
    public EventBridge getServerEventBridge() {
        return null;
    }

    @Override
    protected void beforeSendMessage(ClientMessage message) {
    }

    @Override
    protected Object doSendMessage(ClientMessage message) throws CayenneRuntimeException {
        ClientMessage processedMessage;
        try {
            switch (this.serializationPolicy) {
                case 2: {
                    processedMessage = (ClientMessage)HessianUtil.cloneViaClientServerSerialization((Serializable)message, this.channel.getEntityResolver());
                    break;
                }
                case 1: {
                    processedMessage = (ClientMessage)Util.cloneViaSerialization((Serializable)message);
                    break;
                }
                default: {
                    processedMessage = message;
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error serializing message", (Throwable)ex, new Object[0]);
        }
        Serializable result = (Serializable)DispatchHelper.dispatch((DataChannel)this.channel, (ClientMessage)processedMessage);
        try {
            switch (this.serializationPolicy) {
                case 2: {
                    return HessianUtil.cloneViaServerClientSerialization(result, this.channel.getEntityResolver());
                }
                case 1: {
                    return Util.cloneViaSerialization((Serializable)result);
                }
            }
            return result;
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error deserializing result", (Throwable)ex, new Object[0]);
        }
    }
}

