/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote.service;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.remote.BootstrapMessage;
import org.apache.cayenne.remote.ClientMessage;
import org.apache.cayenne.remote.QueryMessage;
import org.apache.cayenne.remote.SyncMessage;

class DispatchHelper {
    DispatchHelper() {
    }

    static Object dispatch(DataChannel channel, ClientMessage message) {
        if (message instanceof QueryMessage) {
            return channel.onQuery(null, ((QueryMessage)message).getQuery());
        }
        if (message instanceof SyncMessage) {
            SyncMessage sync = (SyncMessage)message;
            return channel.onSync(null, sync.getSenderChanges(), sync.getType());
        }
        if (message instanceof BootstrapMessage) {
            return channel.getEntityResolver().getClientEntityResolver();
        }
        throw new CayenneRuntimeException("Message dispatch error. Unsupported message: %s", new Object[]{message});
    }
}

