/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.template;

import java.io.ByteArrayInputStream;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.cayenne.template.parser.SQLTemplateParser;

class TemplateParserPool {
    static final int INITIAL_POOL_SIZE = 4;
    static final int MAX_POOL_SIZE = 20;
    private ArrayBlockingQueue<SQLTemplateParser> parsers = new ArrayBlockingQueue(20);

    TemplateParserPool() {
        for (int i = 0; i < 4; ++i) {
            this.parsers.offer(this.createNewParser());
        }
    }

    SQLTemplateParser get() {
        SQLTemplateParser parser = this.parsers.poll();
        if (parser == null) {
            parser = this.createNewParser();
        }
        return parser;
    }

    void put(SQLTemplateParser parser) {
        parser.ReInit(new ByteArrayInputStream("\n".getBytes()));
        this.parsers.offer(parser);
    }

    SQLTemplateParser createNewParser() {
        return new SQLTemplateParser(new ByteArrayInputStream("\n".getBytes()));
    }
}

