/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.event.DataNodeEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CreateDataMapAction;
import org.apache.cayenne.modeler.action.CreateDbEntityAction;
import org.apache.cayenne.modeler.action.CreateEmbeddableAction;
import org.apache.cayenne.modeler.action.CreateNodeAction;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.CreateProcedureAction;
import org.apache.cayenne.modeler.action.CreateQueryAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class RemoveUndoableEdit
extends CayenneUndoableEdit {
    private DataMap map;
    private DbEntity dbEntity;
    private ObjEntity objEntity;
    private QueryDescriptor query;
    private Procedure procedure;
    private DataNodeDescriptor dataNode;
    private DataChannelDescriptor domain;
    private Embeddable embeddable;
    private Map<DbEntity, List<DbRelationship>> dbRelationshipMap = new HashMap<DbEntity, List<DbRelationship>>();
    private Map<ObjEntity, List<ObjRelationship>> objRelationshipMap = new HashMap<ObjEntity, List<ObjRelationship>>();
    private REMOVE_MODE mode;

    public RemoveUndoableEdit(Application application) {
        this.domain = (DataChannelDescriptor)application.getProject().getRootNode();
        this.mode = REMOVE_MODE.DOMAIN;
    }

    public RemoveUndoableEdit(Application application, DataNodeDescriptor node, DataMap map) {
        this.map = map;
        this.dataNode = node;
        this.mode = REMOVE_MODE.MAP_FROM_NODE;
    }

    public RemoveUndoableEdit(Application application, DataMap map) {
        this.domain = (DataChannelDescriptor)application.getProject().getRootNode();
        this.map = map;
        this.mode = REMOVE_MODE.MAP_FROM_DOMAIN;
    }

    public RemoveUndoableEdit(Application application, DataNodeDescriptor node) {
        this.domain = (DataChannelDescriptor)application.getProject().getRootNode();
        this.dataNode = node;
        this.mode = REMOVE_MODE.NODE;
    }

    public RemoveUndoableEdit(DataMap map, ObjEntity objEntity) {
        this.map = map;
        this.objEntity = objEntity;
        this.mode = REMOVE_MODE.OBJECT_ENTITY;
        for (ObjEntity ent : map.getObjEntities()) {
            for (Relationship relationship : new ArrayList<ObjRelationship>(ent.getRelationships())) {
                if (!this.objEntity.getName().equals(relationship.getTargetEntityName())) continue;
                ObjRelationship rel = (ObjRelationship)relationship;
                if (this.objRelationshipMap.get(rel.getSourceEntity()) == null) {
                    this.objRelationshipMap.put(rel.getSourceEntity(), new LinkedList());
                }
                this.objRelationshipMap.get(rel.getSourceEntity()).add(rel);
            }
        }
    }

    public RemoveUndoableEdit(DataMap map, DbEntity dbEntity) {
        this.map = map;
        this.dbEntity = dbEntity;
        this.mode = REMOVE_MODE.DB_ENTITY;
        for (ObjEntity objEnt : map.getObjEntities()) {
            block1: for (Relationship relationship : objEnt.getRelationships()) {
                for (DbRelationship dbRel : ((ObjRelationship)relationship).getDbRelationships()) {
                    if (dbRel.getTargetEntity() != dbEntity) continue;
                    if (this.dbRelationshipMap.get(dbRel.getSourceEntity()) == null) {
                        this.dbRelationshipMap.put(dbRel.getSourceEntity(), new LinkedList());
                    }
                    this.dbRelationshipMap.get(dbRel.getSourceEntity()).add(dbRel);
                    continue block1;
                }
            }
        }
    }

    public RemoveUndoableEdit(DataMap map, QueryDescriptor query) {
        this.map = map;
        this.query = query;
        this.mode = REMOVE_MODE.QUERY;
    }

    public RemoveUndoableEdit(DataMap map, Procedure procedure) {
        this.map = map;
        this.procedure = procedure;
        this.mode = REMOVE_MODE.PROCEDURE;
    }

    public RemoveUndoableEdit(DataMap map, Embeddable embeddable) {
        this.map = map;
        this.embeddable = embeddable;
        this.mode = REMOVE_MODE.EMBEDDABLE;
    }

    @Override
    public String getPresentationName() {
        switch (this.mode.ordinal()) {
            case 0: {
                return "Remove Object Entity";
            }
            case 1: {
                return "Remove Db Entity";
            }
            case 2: {
                return "Remove Query";
            }
            case 3: {
                return "Remove Procedure";
            }
            case 4: {
                return "Remove DataMap";
            }
            case 5: {
                return "Remove DataMap";
            }
            case 6: {
                return "Remove DataNode";
            }
            case 7: {
                return "Remove DataDomain";
            }
            case 8: {
                return "Remove Embeddable";
            }
        }
        return "Remove";
    }

    @Override
    public void redo() throws CannotRedoException {
        RemoveAction action = this.actionManager.getAction(RemoveAction.class);
        switch (this.mode.ordinal()) {
            case 0: {
                action.removeObjEntity(this.map, this.objEntity);
                break;
            }
            case 1: {
                action.removeDbEntity(this.map, this.dbEntity);
                break;
            }
            case 2: {
                action.removeQuery(this.map, this.query);
                break;
            }
            case 3: {
                action.removeProcedure(this.map, this.procedure);
                break;
            }
            case 4: {
                action.removeDataMapFromDataNode(this.dataNode, this.map);
                break;
            }
            case 5: {
                action.removeDataMap(this.map);
                break;
            }
            case 6: {
                action.removeDataNode(this.dataNode);
                break;
            }
            case 8: {
                action.removeEmbeddable(this.map, this.embeddable);
            }
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        CreateRelationshipAction relationshipAction = this.actionManager.getAction(CreateRelationshipAction.class);
        switch (this.mode.ordinal()) {
            case 0: {
                for (Map.Entry<ObjEntity, List<ObjRelationship>> entry : this.objRelationshipMap.entrySet()) {
                    ObjEntity objEntity = entry.getKey();
                    for (ObjRelationship rel : entry.getValue()) {
                        relationshipAction.createObjRelationship(objEntity, rel);
                    }
                }
                CreateObjEntityAction action = this.actionManager.getAction(CreateObjEntityAction.class);
                action.createObjEntity(this.map, this.objEntity);
                break;
            }
            case 1: {
                for (Map.Entry<DbEntity, List<DbRelationship>> entry : this.dbRelationshipMap.entrySet()) {
                    DbEntity dbEntity = entry.getKey();
                    for (DbRelationship rel : entry.getValue()) {
                        relationshipAction.createDbRelationship(dbEntity, rel);
                    }
                }
                CreateDbEntityAction action = this.actionManager.getAction(CreateDbEntityAction.class);
                action.createEntity(this.map, this.dbEntity);
                break;
            }
            case 2: {
                this.domain = (DataChannelDescriptor)Application.getInstance().getFrameController().getProjectController().getProject().getRootNode();
                CreateQueryAction action = this.actionManager.getAction(CreateQueryAction.class);
                action.createQuery(this.domain, this.map, this.query);
                break;
            }
            case 3: {
                CreateProcedureAction action = this.actionManager.getAction(CreateProcedureAction.class);
                action.createProcedure(this.map, this.procedure);
                break;
            }
            case 4: {
                this.dataNode.getDataMapNames().add(this.map.getName());
                DataNodeEvent e = new DataNodeEvent((Object)Application.getFrame(), this.dataNode);
                ProjectController controller = Application.getInstance().getFrameController().getProjectController();
                e.setDomain((DataChannelDescriptor)controller.getProject().getRootNode());
                controller.fireDataNodeEvent(e);
                break;
            }
            case 5: {
                CreateDataMapAction action = this.actionManager.getAction(CreateDataMapAction.class);
                action.createDataMap(this.map);
                break;
            }
            case 6: {
                CreateNodeAction action = this.actionManager.getAction(CreateNodeAction.class);
                action.createDataNode(this.dataNode);
                break;
            }
            case 8: {
                CreateEmbeddableAction action = this.actionManager.getAction(CreateEmbeddableAction.class);
                action.createEmbeddable(this.map, this.embeddable);
                break;
            }
        }
    }

    private static enum REMOVE_MODE {
        OBJECT_ENTITY,
        DB_ENTITY,
        QUERY,
        PROCEDURE,
        MAP_FROM_NODE,
        MAP_FROM_DOMAIN,
        NODE,
        DOMAIN,
        EMBEDDABLE;

    }
}

