/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.TypesMapping;

public class UtilDateType
implements ExtendedType<Date> {
    private final Calendar calendar;
    private final boolean useCalendar;

    public UtilDateType() {
        this(false);
    }

    public UtilDateType(boolean useCalendar) {
        this.useCalendar = useCalendar;
        this.calendar = this.useCalendar ? Calendar.getInstance() : null;
    }

    @Override
    public String getClassName() {
        return Date.class.getName();
    }

    @Override
    public Date materializeObject(ResultSet rs, int index, int type) throws Exception {
        Date val;
        switch (type) {
            case 93: {
                val = this.useCalendar ? rs.getTimestamp(index, this.calendar) : rs.getTimestamp(index);
                break;
            }
            case 91: {
                val = this.useCalendar ? rs.getDate(index, this.calendar) : rs.getDate(index);
                break;
            }
            case 92: {
                val = this.useCalendar ? rs.getTime(index, this.calendar) : rs.getTime(index);
                break;
            }
            default: {
                val = this.useCalendar ? rs.getTimestamp(index, this.calendar) : rs.getTimestamp(index);
            }
        }
        return val == null ? null : new Date(val.getTime());
    }

    @Override
    public Date materializeObject(CallableStatement cs, int index, int type) throws Exception {
        Date val;
        switch (type) {
            case 93: {
                val = this.useCalendar ? cs.getTimestamp(index, this.calendar) : cs.getTimestamp(index);
                break;
            }
            case 91: {
                val = this.useCalendar ? cs.getDate(index, this.calendar) : cs.getDate(index);
                break;
            }
            case 92: {
                val = this.useCalendar ? cs.getTime(index, this.calendar) : cs.getTime(index);
                break;
            }
            default: {
                val = this.useCalendar ? cs.getTimestamp(index, this.calendar) : cs.getTimestamp(index);
            }
        }
        return val == null ? null : new Date(val.getTime());
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Date value, int pos, int type, int scale) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else if (type == 91) {
            if (this.useCalendar) {
                statement.setDate(pos, new java.sql.Date(value.getTime()), this.calendar);
            } else {
                statement.setDate(pos, new java.sql.Date(value.getTime()));
            }
        } else if (type == 92) {
            Time time = new Time(value.getTime());
            if (this.useCalendar) {
                statement.setTime(pos, time, this.calendar);
            } else {
                statement.setTime(pos, time);
            }
        } else if (type == 93) {
            if (this.useCalendar) {
                statement.setTimestamp(pos, new Timestamp(value.getTime()), this.calendar);
            } else {
                statement.setTimestamp(pos, new Timestamp(value.getTime()));
            }
        } else {
            throw new IllegalArgumentException("Only DATE, TIME or TIMESTAMP can be mapped as '" + this.getClassName() + "', got " + TypesMapping.getSqlNameByType(type));
        }
    }

    @Override
    public String toString(Date value) {
        if (value == null) {
            return "NULL";
        }
        long time = value.getTime();
        return '\'' + new Timestamp(time).toString() + '\'';
    }
}

