/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataDomainDBDiffBuilder;
import org.apache.cayenne.access.DataDomainSyncBucket;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DbEntityClassDescriptor;
import org.apache.cayenne.access.LegacyDataDomainFlushAction;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.query.Query;

@Deprecated
class DataDomainInsertBucket
extends DataDomainSyncBucket {
    List<FlattenedInsert> flattenedInserts;

    DataDomainInsertBucket(LegacyDataDomainFlushAction parent) {
        super(parent);
    }

    @Override
    void appendQueriesInternal(Collection<Query> queries) {
        DataDomainDBDiffBuilder diffBuilder = new DataDomainDBDiffBuilder();
        EntitySorter sorter = this.parent.getDomain().getEntitySorter();
        sorter.sortDbEntities(this.dbEntities, false);
        for (DbEntity dbEntity : this.dbEntities) {
            Collection descriptors = (Collection)this.descriptorsByDbEntity.get(dbEntity);
            InsertBatchQuery batch = new InsertBatchQuery(dbEntity, 27);
            for (DbEntityClassDescriptor descriptor : descriptors) {
                diffBuilder.reset(descriptor);
                List objects = (List)this.objectsByDescriptor.get(descriptor.getClassDescriptor());
                if (objects.isEmpty()) continue;
                this.checkReadOnly(descriptor.getEntity());
                this.createPermIds(descriptor, objects);
                sorter.sortObjectsForEntity(descriptor.getEntity(), objects, false);
                for (Persistent o : objects) {
                    Map<String, Object> snapshot = diffBuilder.buildDBDiff(this.parent.objectDiff(o.getObjectId()));
                    if (snapshot == null) {
                        snapshot = new HashMap<String, Object>();
                    }
                    batch.add(snapshot, o.getObjectId());
                    if (descriptor.isMaster()) continue;
                    this.trackFlattenedInsert(descriptor, o);
                }
            }
            queries.add(batch);
        }
    }

    void createPermIds(DbEntityClassDescriptor descriptor, Collection<Persistent> objects) {
        if (objects.isEmpty()) {
            return;
        }
        ObjEntity objEntity = descriptor.getEntity();
        DbEntity entity = descriptor.getDbEntity();
        DataNode node = this.parent.getDomain().lookupDataNode(entity.getDataMap());
        boolean supportsGeneratedKeys = node.getAdapter().supportsGeneratedKeys();
        PkGenerator pkGenerator = node.getAdapter().getPkGenerator();
        for (Persistent object : objects) {
            ObjectId id = object.getObjectId();
            if (id == null || !id.isTemporary()) continue;
            Map<String, Object> idMap = id.getReplacementIdMap();
            boolean autoPkDone = false;
            for (DbAttribute dbAttr : entity.getPrimaryKeys()) {
                Class<?> javaClass;
                Object value;
                String dbAttrName = dbAttr.getName();
                if (idMap.containsKey(dbAttrName)) continue;
                ObjAttribute objAttr = objEntity.getAttributeForDbAttribute(dbAttr);
                if (!(objAttr == null || (value = descriptor.getClassDescriptor().getProperty(objAttr.getName()).readPropertyDirectly(object)) == null || (javaClass = objAttr.getJavaClass()).isPrimitive() && value instanceof Number && ((Number)value).intValue() == 0)) {
                    idMap.put(dbAttrName, value);
                    continue;
                }
                if (supportsGeneratedKeys && dbAttr.isGenerated() || this.isPropagated(dbAttr)) continue;
                if (autoPkDone) {
                    throw new CayenneRuntimeException("Primary Key autogeneration only works for a single attribute.", new Object[0]);
                }
                try {
                    Object pkValue = pkGenerator.generatePk(node, dbAttr);
                    idMap.put(dbAttrName, pkValue);
                    autoPkDone = true;
                }
                catch (Exception ex) {
                    throw new CayenneRuntimeException("Error generating PK: %s", (Throwable)ex, ex.getMessage());
                }
            }
        }
    }

    boolean isPropagated(DbAttribute attribute) {
        for (DbRelationship dbRel : attribute.getEntity().getRelationships()) {
            if (!dbRel.isToMasterPK()) continue;
            for (DbJoin join : dbRel.getJoins()) {
                if (!attribute.getName().equals(join.getSourceName())) continue;
                return true;
            }
        }
        return false;
    }

    void trackFlattenedInsert(DbEntityClassDescriptor descriptor, Persistent object) {
        if (this.flattenedInserts == null) {
            this.flattenedInserts = new LinkedList<FlattenedInsert>();
        }
        StringBuilder sb = new StringBuilder();
        for (DbRelationship rel : descriptor.getPathFromMaster()) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(rel.getName());
        }
        this.flattenedInserts.add(new FlattenedInsert(sb.toString(), object));
    }

    @Override
    void postprocess() {
        super.postprocess();
        if (this.flattenedInserts != null) {
            for (FlattenedInsert insert : this.flattenedInserts) {
                insert.register(this.parent.getContext().getObjectStore());
            }
        }
    }

    private static class FlattenedInsert {
        private final String path;
        private final Persistent object;

        private FlattenedInsert(String path, Persistent object) {
            this.path = path;
            this.object = object;
        }

        private void register(ObjectStore objectStore) {
            objectStore.markFlattenedPath(this.object.getObjectId(), this.path, ObjectId.of("tmp"));
        }
    }
}

