/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.di.Key;

class DIUtil {
    DIUtil() {
    }

    static Class<?> parameterClass(Type type) {
        ParameterizedType parameterizedType;
        Type[] parameters;
        if (type instanceof ParameterizedType && (parameters = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length == 1) {
            return DIUtil.typeToClass(parameters[0]);
        }
        return null;
    }

    static Class<?>[] allParametersClass(Type type) {
        Class[] arr = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] parameters = parameterizedType.getActualTypeArguments();
            arr = new Class[parameters.length];
            int i = 0;
            for (Type next : parameters) {
                arr[i++] = DIUtil.typeToClass(next);
            }
        }
        return arr;
    }

    static Key<?> getKeyForTypeAndGenericType(Class<?> type, Type genericType, String bindingName) {
        if (List.class.isAssignableFrom(type)) {
            Class<Object> objectClass = DIUtil.parameterClass(genericType);
            if (objectClass == null) {
                objectClass = Object.class;
            }
            return Key.getListOf(objectClass, bindingName);
        }
        if (Map.class.isAssignableFrom(type)) {
            Class<?>[] classes = DIUtil.allParametersClass(genericType);
            if (classes == null) {
                classes = new Class[]{Object.class, Object.class};
            }
            return Key.getMapOf(classes[0], classes[1], bindingName);
        }
        return Key.get(type, bindingName);
    }

    static Class<?> typeToClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return Object.class;
    }
}

