/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.util.Map;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.GossipDigestAck2;
import org.apache.cassandra.gms.GossipVerbHandler;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipDigestAck2VerbHandler
extends GossipVerbHandler<GossipDigestAck2> {
    public static final GossipDigestAck2VerbHandler instance = new GossipDigestAck2VerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(GossipDigestAck2VerbHandler.class);

    @Override
    public void doVerb(Message<GossipDigestAck2> message) {
        if (logger.isTraceEnabled()) {
            InetAddressAndPort from = message.from();
            logger.trace("Received a GossipDigestAck2Message from {}", (Object)from);
        }
        if (!Gossiper.instance.isEnabled()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Ignoring GossipDigestAck2Message because gossip is disabled");
            }
            return;
        }
        Map<InetAddressAndPort, EndpointState> remoteEpStateMap = ((GossipDigestAck2)message.payload).epStateMap;
        Gossiper.instance.notifyFailureDetector(remoteEpStateMap);
        Gossiper.instance.applyStateLocally(remoteEpStateMap);
        super.doVerb(message);
    }
}

