/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.statements.AuthenticationStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.messages.ResultMessage;

public class AddIdentityStatement
extends AuthenticationStatement {
    final String identity;
    final String role;
    final boolean ifNotExists;

    public AddIdentityStatement(String identity, String role, boolean ifNotExists) {
        this.role = role;
        this.identity = identity;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void authorize(ClientState state) {
        this.checkPermission(state, Permission.CREATE, state.getUser().getPrimaryRole());
    }

    @Override
    public void validate(ClientState state) {
        state.ensureNotAnonymous();
        if (!DatabaseDescriptor.getRoleManager().isExistingRole(RoleResource.role(this.role))) {
            throw new InvalidRequestException(String.format("Can not add identity for non-existent role '%s'", this.role));
        }
        if (!this.ifNotExists && DatabaseDescriptor.getRoleManager().isExistingIdentity(this.identity)) {
            throw new InvalidRequestException(String.format("%s already exists", this.identity));
        }
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.CREATE_IDENTITY);
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestExecutionException, RequestValidationException {
        if (!this.ifNotExists || !DatabaseDescriptor.getRoleManager().isExistingIdentity(this.identity)) {
            DatabaseDescriptor.getRoleManager().addIdentity(this.identity, this.role);
        }
        return null;
    }
}

