/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm.strategies;

import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandle;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.github.jamm.MemoryMeter;
import org.github.jamm.MemoryMeterStrategy;
import org.github.jamm.VM;
import org.github.jamm.strategies.DoesNotUseEmptySlotInSuperSpecStrategy;
import org.github.jamm.strategies.InstrumentationAndSpecStrategy;
import org.github.jamm.strategies.InstrumentationStrategy;
import org.github.jamm.strategies.MemoryLayoutBasedStrategy;
import org.github.jamm.strategies.PreJava15SpecStrategy;
import org.github.jamm.strategies.PreJava15UnsafeStrategy;
import org.github.jamm.strategies.SpecStrategy;
import org.github.jamm.strategies.UnsafeStrategy;
import org.github.jamm.utils.MethodHandleUtils;

public final class MemoryMeterStrategies {
    public static Instrumentation instrumentation;
    private static MemoryMeterStrategies instance;
    private final MemoryMeterStrategy instrumentationStrategy;
    private final MemoryMeterStrategy instrumentationAndSpecStrategy;
    private final MemoryMeterStrategy unsafeStrategy;
    private final MemoryMeterStrategy specStrategy;

    private MemoryMeterStrategies(MemoryMeterStrategy instrumentationStrategy, MemoryMeterStrategy instrumentationAndSpecStrategy, MemoryMeterStrategy unsafeStrategy, MemoryMeterStrategy specStrategy) {
        this.instrumentationStrategy = instrumentationStrategy;
        this.instrumentationAndSpecStrategy = instrumentationAndSpecStrategy;
        this.unsafeStrategy = unsafeStrategy;
        this.specStrategy = specStrategy;
    }

    public static synchronized MemoryMeterStrategies getInstance() {
        if (instance == null) {
            instance = MemoryMeterStrategies.createStrategies();
        }
        return instance;
    }

    private static MemoryMeterStrategies createStrategies() {
        Optional<MethodHandle> mayBeIsHiddenMH = MemoryMeterStrategies.mayBeIsHiddenMethodHandle();
        MemoryMeterStrategy instrumentationStrategy = MemoryMeterStrategies.createInstrumentationStrategy();
        MemoryMeterStrategy instrumentationAndSpecStrategy = MemoryMeterStrategies.createInstrumentationAndSpecStrategy();
        MemoryMeterStrategy specStrategy = MemoryMeterStrategies.createSpecStrategy(mayBeIsHiddenMH);
        MemoryMeterStrategy unsafeStrategy = MemoryMeterStrategies.createUnsafeStrategy(mayBeIsHiddenMH, (MemoryLayoutBasedStrategy)specStrategy);
        if (MemoryMeterStrategies.logInformationAtStartup()) {
            System.out.println("Jamm starting with: java.version='" + System.getProperty("java.version") + "', java.vendor='" + System.getProperty("java.vendor") + "', instrumentation=" + (instrumentationStrategy != null) + ", unsafe=" + (unsafeStrategy != null) + ", " + MemoryMeterStrategy.MEMORY_LAYOUT);
        }
        return new MemoryMeterStrategies(instrumentationStrategy, instrumentationAndSpecStrategy, unsafeStrategy, specStrategy);
    }

    private static boolean logInformationAtStartup() {
        return Boolean.parseBoolean(System.getProperty("org.github.jamm.strategies.LogInfoAtStartup", "false"));
    }

    private static MemoryMeterStrategy createSpecStrategy(Optional<MethodHandle> mayBeIsHiddenMH) {
        if (mayBeIsHiddenMH.isPresent() && !VM.useEmptySlotsInSuper()) {
            System.out.println("WARNING: Jamm is starting with the UseEmptySlotsInSupers JVM option disabled. The memory layout created when this option is enabled cannot always be reproduced accurately by the Specification or UNSAFE strategies. By consequence the measured sizes when these strategies are used might be off in some cases.");
        }
        return mayBeIsHiddenMH.isPresent() ? (VM.useEmptySlotsInSuper() ? new SpecStrategy() : new DoesNotUseEmptySlotInSuperSpecStrategy()) : new PreJava15SpecStrategy();
    }

    private static MemoryMeterStrategy createUnsafeStrategy(Optional<MethodHandle> mayBeIsHiddenMH, MemoryLayoutBasedStrategy specStrategy) {
        if (!VM.hasUnsafe()) {
            return null;
        }
        Optional<MethodHandle> mayBeIsRecordMH = MemoryMeterStrategies.mayBeIsRecordMethodHandle();
        return mayBeIsHiddenMH.isPresent() ? new UnsafeStrategy(mayBeIsRecordMH.get(), mayBeIsHiddenMH.get(), specStrategy) : new PreJava15UnsafeStrategy(mayBeIsRecordMH, specStrategy);
    }

    private static Optional<MethodHandle> mayBeIsHiddenMethodHandle() {
        return MethodHandleUtils.mayBeMethodHandle(Class.class, "isHidden");
    }

    private static Optional<MethodHandle> mayBeIsRecordMethodHandle() {
        return MethodHandleUtils.mayBeMethodHandle(Class.class, "isRecord");
    }

    private static MemoryMeterStrategy createInstrumentationStrategy() {
        return instrumentation != null ? new InstrumentationStrategy(instrumentation) : null;
    }

    private static MemoryMeterStrategy createInstrumentationAndSpecStrategy() {
        return instrumentation != null ? new InstrumentationAndSpecStrategy(instrumentation) : null;
    }

    public boolean hasInstrumentation() {
        return this.instrumentationStrategy != null;
    }

    public boolean hasUnsafe() {
        return this.unsafeStrategy != null;
    }

    /*
     * Unable to fully structure code
     */
    public MemoryMeterStrategy getStrategy(List<MemoryMeter.Guess> guessList) {
        block3: {
            if (guessList.isEmpty()) {
                throw new IllegalArgumentException("The guessList argument is empty");
            }
            MemoryMeter.Guess.checkOrder(guessList);
            guesses = new LinkedList<MemoryMeter.Guess>(guessList);
            do lbl-1000:
            // 3 sources

            {
                block4: {
                    if (!(guess = (MemoryMeter.Guess)guesses.poll()).requireInstrumentation()) break block4;
                    if (this.hasInstrumentation()) {
                        return guess == MemoryMeter.Guess.INSTRUMENTATION_AND_SPECIFICATION ? this.instrumentationAndSpecStrategy : this.instrumentationStrategy;
                    }
                    if (!guesses.isEmpty()) ** GOTO lbl-1000
                    throw new IllegalStateException("Instrumentation is not set; Jamm must be set as -javaagent");
                }
                if (!guess.requireUnsafe()) break block3;
                if (!this.hasUnsafe()) continue;
                return this.unsafeStrategy;
            } while (!guesses.isEmpty());
            throw new IllegalStateException("sun.misc.Unsafe could not be obtained. The SecurityManager must permit access to sun.misc.Unsafe");
        }
        return this.specStrategy;
    }
}

