/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import com.sun.jna.Native;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

public abstract class MemoryUtil {
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    protected static final Unsafe unsafe;
    private static final Class<?> DIRECT_BYTE_BUFFER_CLASS;
    private static final Class<?> RO_DIRECT_BYTE_BUFFER_CLASS;
    private static final long DIRECT_BYTE_BUFFER_ADDRESS_OFFSET;
    private static final long DIRECT_BYTE_BUFFER_CAPACITY_OFFSET;
    private static final long DIRECT_BYTE_BUFFER_LIMIT_OFFSET;
    private static final long DIRECT_BYTE_BUFFER_POSITION_OFFSET;
    private static final long DIRECT_BYTE_BUFFER_ATTACHMENT_OFFSET;
    protected static final Class<?> BYTE_BUFFER_CLASS;
    private static final long BYTE_ARRAY_BASE_OFFSET;

    public static int pageSize() {
        return unsafe.pageSize();
    }

    public static long getAddress(ByteBuffer buffer) {
        assert (buffer.getClass() == DIRECT_BYTE_BUFFER_CLASS);
        return unsafe.getLong(buffer, DIRECT_BYTE_BUFFER_ADDRESS_OFFSET);
    }

    public static long allocate(long size) {
        return Native.malloc((long)size);
    }

    public static void free(long peer) {
        Native.free((long)peer);
    }

    public static void setByte(long address, byte b) {
        unsafe.putByte(address, b);
    }

    public static void setByte(long address, int count, byte b) {
        unsafe.setMemory(address, count, b);
    }

    public static byte getByte(long address) {
        return unsafe.getByte(address);
    }

    public static ByteBuffer getByteBuffer(long address, int length) {
        return MemoryUtil.getByteBuffer(address, length, ByteOrder.nativeOrder());
    }

    public static ByteBuffer getByteBuffer(long address, int length, ByteOrder order) {
        ByteBuffer instance = MemoryUtil.getHollowDirectByteBuffer(order);
        MemoryUtil.setDirectByteBuffer(instance, address, length);
        return instance;
    }

    public static ByteBuffer getHollowDirectByteBuffer() {
        return MemoryUtil.getHollowDirectByteBuffer(ByteOrder.nativeOrder());
    }

    public static ByteBuffer getHollowDirectByteBuffer(ByteOrder order) {
        ByteBuffer instance;
        try {
            instance = (ByteBuffer)unsafe.allocateInstance(DIRECT_BYTE_BUFFER_CLASS);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        instance.order(order);
        return instance;
    }

    public static boolean isExactlyDirect(ByteBuffer buffer) {
        return buffer.getClass() == DIRECT_BYTE_BUFFER_CLASS;
    }

    public static Object getAttachment(ByteBuffer instance) {
        assert (instance.getClass() == DIRECT_BYTE_BUFFER_CLASS);
        return unsafe.getObject(instance, DIRECT_BYTE_BUFFER_ATTACHMENT_OFFSET);
    }

    public static void setAttachment(ByteBuffer instance, Object next) {
        assert (instance.getClass() == DIRECT_BYTE_BUFFER_CLASS);
        unsafe.putObject(instance, DIRECT_BYTE_BUFFER_ATTACHMENT_OFFSET, next);
    }

    public static ByteBuffer duplicateDirectByteBuffer(ByteBuffer source, ByteBuffer hollowBuffer) {
        assert (source.getClass() == DIRECT_BYTE_BUFFER_CLASS || source.getClass() == RO_DIRECT_BYTE_BUFFER_CLASS);
        unsafe.putLong(hollowBuffer, DIRECT_BYTE_BUFFER_ADDRESS_OFFSET, unsafe.getLong(source, DIRECT_BYTE_BUFFER_ADDRESS_OFFSET));
        unsafe.putInt(hollowBuffer, DIRECT_BYTE_BUFFER_POSITION_OFFSET, unsafe.getInt(source, DIRECT_BYTE_BUFFER_POSITION_OFFSET));
        unsafe.putInt(hollowBuffer, DIRECT_BYTE_BUFFER_LIMIT_OFFSET, unsafe.getInt(source, DIRECT_BYTE_BUFFER_LIMIT_OFFSET));
        unsafe.putInt(hollowBuffer, DIRECT_BYTE_BUFFER_CAPACITY_OFFSET, unsafe.getInt(source, DIRECT_BYTE_BUFFER_CAPACITY_OFFSET));
        return hollowBuffer;
    }

    public static ByteBuffer sliceDirectByteBuffer(ByteBuffer source, ByteBuffer hollowBuffer, int offset, int length) {
        assert (source.getClass() == DIRECT_BYTE_BUFFER_CLASS || source.getClass() == RO_DIRECT_BYTE_BUFFER_CLASS);
        MemoryUtil.setDirectByteBuffer(hollowBuffer, (long)offset + unsafe.getLong(source, DIRECT_BYTE_BUFFER_ADDRESS_OFFSET), length);
        return hollowBuffer;
    }

    public static void setDirectByteBuffer(ByteBuffer instance, long address, int length) {
        unsafe.putLong(instance, DIRECT_BYTE_BUFFER_ADDRESS_OFFSET, address);
        unsafe.putInt(instance, DIRECT_BYTE_BUFFER_POSITION_OFFSET, 0);
        unsafe.putInt(instance, DIRECT_BYTE_BUFFER_CAPACITY_OFFSET, length);
        unsafe.putInt(instance, DIRECT_BYTE_BUFFER_LIMIT_OFFSET, length);
    }

    public static void setByteBufferCapacity(ByteBuffer instance, int capacity) {
        unsafe.putInt(instance, DIRECT_BYTE_BUFFER_CAPACITY_OFFSET, capacity);
    }

    public static void setBytes(long address, ByteBuffer buffer) {
        int start = buffer.position();
        int count = buffer.limit() - start;
        if (count == 0) {
            return;
        }
        if (buffer.isDirect()) {
            MemoryUtil.setBytes(MemoryUtil.getAddress(buffer) + (long)start, address, count);
        } else {
            MemoryUtil.setBytes(address, buffer.array(), buffer.arrayOffset() + start, count);
        }
    }

    public static void setBytes(long address, byte[] buffer, int bufferOffset, int count) {
        assert (buffer != null);
        assert (bufferOffset >= 0 && count >= 0 && bufferOffset + count <= buffer.length);
        MemoryUtil.setBytes(buffer, bufferOffset, address, (long)count);
    }

    public static void setBytes(long src, long trg, long count) {
        while (count > 0L) {
            long size = count > 0x100000L ? 0x100000L : count;
            unsafe.copyMemory(src, trg, size);
            count -= size;
            src += size;
            trg += size;
        }
    }

    public static void setBytes(byte[] src, int offset, long trg, long count) {
        while (count > 0L) {
            long size = count > 0x100000L ? 0x100000L : count;
            unsafe.copyMemory(src, BYTE_ARRAY_BASE_OFFSET + (long)offset, null, trg, size);
            count -= size;
            offset = (int)((long)offset + size);
            trg += size;
        }
    }

    public static void getBytes(long address, byte[] buffer, int bufferOffset, int count) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (bufferOffset < 0 || count < 0 || count > buffer.length - bufferOffset) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        unsafe.copyMemory(null, address, buffer, BYTE_ARRAY_BASE_OFFSET + (long)bufferOffset, count);
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            Class<?> clazz = ByteBuffer.allocateDirect(0).getClass();
            DIRECT_BYTE_BUFFER_ADDRESS_OFFSET = unsafe.objectFieldOffset(Buffer.class.getDeclaredField("address"));
            DIRECT_BYTE_BUFFER_CAPACITY_OFFSET = unsafe.objectFieldOffset(Buffer.class.getDeclaredField("capacity"));
            DIRECT_BYTE_BUFFER_LIMIT_OFFSET = unsafe.objectFieldOffset(Buffer.class.getDeclaredField("limit"));
            DIRECT_BYTE_BUFFER_POSITION_OFFSET = unsafe.objectFieldOffset(Buffer.class.getDeclaredField("position"));
            DIRECT_BYTE_BUFFER_ATTACHMENT_OFFSET = unsafe.objectFieldOffset(clazz.getDeclaredField("att"));
            DIRECT_BYTE_BUFFER_CLASS = clazz;
            RO_DIRECT_BYTE_BUFFER_CLASS = ByteBuffer.allocateDirect(0).asReadOnlyBuffer().getClass();
            clazz = ByteBuffer.allocate(0).getClass();
            BYTE_BUFFER_CLASS = clazz;
            BYTE_ARRAY_BASE_OFFSET = unsafe.arrayBaseOffset(byte[].class);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

