/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.bti.RowIndexReader;
import org.apache.cassandra.io.sstable.format.bti.TrieIndexEntry;
import org.apache.cassandra.io.tries.ReverseValueIterator;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;

class RowIndexReverseIterator
extends ReverseValueIterator<RowIndexReverseIterator> {
    private long currentNode = -1L;
    private final Version version;

    public RowIndexReverseIterator(FileHandle file, long root, ByteComparable start, ByteComparable end, Version version) {
        super(file.instantiateRebufferer(null), root, start, end, true);
        this.version = version;
    }

    public RowIndexReverseIterator(FileHandle file, TrieIndexEntry entry, ByteComparable end, Version version) {
        this(file, entry.indexTrieRoot, ByteComparable.EMPTY, end, version);
    }

    public RowIndexReader.IndexInfo nextIndexInfo() throws IOException {
        if (this.currentNode == -1L) {
            this.currentNode = this.nextPayloadedNode();
            if (this.currentNode == -1L) {
                return null;
            }
        }
        this.go(this.currentNode);
        RowIndexReader.IndexInfo info = RowIndexReader.readPayload(this.buf, this.payloadPosition(), this.payloadFlags(), this.version);
        this.currentNode = -1L;
        return info;
    }

    public void dumpTrie(PrintStream out) throws IOException {
        this.dumpTrie(out, RowIndexReader::dumpRowIndexEntry, this.version);
    }
}

