/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.AbstractBTreePartition;
import org.apache.cassandra.db.partitions.BTreePartitionData;
import org.apache.cassandra.db.partitions.BTreePartitionUpdater;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.index.transactions.UpdateTransaction;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.Cloner;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.github.jamm.Unmetered;

public final class AtomicBTreePartition
extends AbstractBTreePartition {
    public static final long EMPTY_SIZE = ObjectSizes.measure(new AtomicBTreePartition(null, DatabaseDescriptor.getPartitioner().decorateKey(ByteBuffer.allocate(1)), null));
    private static final int TRACKER_NEVER_WASTED = 0;
    private static final int TRACKER_PESSIMISTIC_LOCKING = Integer.MAX_VALUE;
    private static final int ALLOCATION_GRANULARITY_BYTES = 1024;
    private static final long EXCESS_WASTE_BYTES = 0xA00000L;
    private static final int EXCESS_WASTE_OFFSET = 10240;
    private static final int CLOCK_SHIFT = 17;
    private static final AtomicIntegerFieldUpdater<AtomicBTreePartition> wasteTrackerUpdater = AtomicIntegerFieldUpdater.newUpdater(AtomicBTreePartition.class, "wasteTracker");
    private static final AtomicReferenceFieldUpdater<AtomicBTreePartition, BTreePartitionData> refUpdater = AtomicReferenceFieldUpdater.newUpdater(AtomicBTreePartition.class, BTreePartitionData.class, "ref");
    private volatile int wasteTracker = 0;
    @Unmetered
    private final MemtableAllocator allocator;
    private volatile BTreePartitionData ref;
    @Unmetered
    private final TableMetadataRef metadata;

    public AtomicBTreePartition(TableMetadataRef metadata, DecoratedKey partitionKey, MemtableAllocator allocator) {
        super(partitionKey);
        this.metadata = metadata;
        this.allocator = allocator;
        this.ref = BTreePartitionData.EMPTY;
    }

    @Override
    protected BTreePartitionData holder() {
        return this.ref;
    }

    @Override
    public TableMetadata metadata() {
        return this.metadata.get();
    }

    @Override
    protected boolean canHaveShadowedData() {
        return true;
    }

    public BTreePartitionUpdater addAll(PartitionUpdate update, Cloner cloner, OpOrder.Group writeOp, UpdateTransaction indexer) {
        return new Updater(this.allocator, cloner, writeOp, indexer).addAll(update);
    }

    @VisibleForTesting
    public void unsafeSetHolder(BTreePartitionData holder) {
        this.ref = holder;
    }

    @VisibleForTesting
    public BTreePartitionData unsafeGetHolder() {
        return this.ref;
    }

    @Override
    public DeletionInfo deletionInfo() {
        return this.allocator.ensureOnHeap().applyToDeletionInfo(super.deletionInfo());
    }

    @Override
    public Row staticRow() {
        return this.allocator.ensureOnHeap().applyToStatic(super.staticRow());
    }

    @Override
    public DecoratedKey partitionKey() {
        return this.allocator.ensureOnHeap().applyToPartitionKey(super.partitionKey());
    }

    @Override
    public Row getRow(Clustering<?> clustering) {
        return this.allocator.ensureOnHeap().applyToRow(super.getRow(clustering));
    }

    @Override
    public Row lastRow() {
        return this.allocator.ensureOnHeap().applyToRow(super.lastRow());
    }

    @Override
    public UnfilteredRowIterator unfilteredIterator(BTreePartitionData current, ColumnFilter selection, Slices slices, boolean reversed) {
        return this.allocator.ensureOnHeap().applyToPartition(super.unfilteredIterator(current, selection, slices, reversed));
    }

    @Override
    public Iterator<Row> iterator() {
        return this.allocator.ensureOnHeap().applyToPartition(super.iterator());
    }

    private boolean shouldLock(OpOrder.Group writeOp) {
        if (!this.useLock()) {
            return false;
        }
        return this.lockIfOldest(writeOp);
    }

    private boolean shouldLock(long addWaste, OpOrder.Group writeOp) {
        if (!this.updateWastedAllocationTracker(addWaste)) {
            return false;
        }
        return this.lockIfOldest(writeOp);
    }

    private boolean lockIfOldest(OpOrder.Group writeOp) {
        if (!writeOp.isOldestLiveGroup()) {
            Thread.yield();
            return writeOp.isOldestLiveGroup();
        }
        return true;
    }

    public boolean useLock() {
        return this.wasteTracker == Integer.MAX_VALUE;
    }

    private boolean updateWastedAllocationTracker(long wastedBytes) {
        if (wastedBytes < 0xA00000L) {
            int oldTrackerValue;
            int wastedAllocation = (int)(wastedBytes + 1024L - 1L) / 1024;
            while (Integer.MAX_VALUE != (oldTrackerValue = this.wasteTracker)) {
                int time = (int)(Clock.Global.nanoTime() >>> 17);
                int delta = oldTrackerValue - time;
                if (oldTrackerValue == 0 || delta >= 0 || delta < -10240) {
                    delta = -10240;
                }
                if ((delta += wastedAllocation) >= 0) break;
                if (!wasteTrackerUpdater.compareAndSet(this, oldTrackerValue, AtomicBTreePartition.avoidReservedValues(time + delta))) continue;
                return false;
            }
        }
        wasteTrackerUpdater.set(this, Integer.MAX_VALUE);
        return true;
    }

    private static int avoidReservedValues(int wasteTracker) {
        if (wasteTracker == 0 || wasteTracker == Integer.MAX_VALUE) {
            return wasteTracker + 1;
        }
        return wasteTracker;
    }

    class Updater
    extends BTreePartitionUpdater {
        BTreePartitionData current;

        public Updater(MemtableAllocator allocator, Cloner cloner, OpOrder.Group writeOp, UpdateTransaction indexer) {
            super(allocator, cloner, writeOp, indexer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Updater addAll(PartitionUpdate update) {
            try {
                boolean shouldLock = AtomicBTreePartition.this.shouldLock(this.writeOp);
                this.indexer.start();
                while (true) {
                    Updater updater;
                    if (shouldLock) {
                        updater = this;
                        synchronized (updater) {
                            block12: {
                                if (!this.tryUpdateData(update)) break block12;
                                Updater updater2 = this;
                                return updater2;
                            }
                        }
                    }
                    if (this.tryUpdateData(update)) {
                        updater = this;
                        return updater;
                    }
                    shouldLock = AtomicBTreePartition.this.shouldLock(this.heapSize, this.writeOp);
                }
            }
            finally {
                this.indexer.commit();
                this.reportAllocatedMemory();
            }
        }

        private boolean tryUpdateData(PartitionUpdate update) {
            this.current = AtomicBTreePartition.this.ref;
            this.dataSize = 0L;
            this.heapSize = 0L;
            BTreePartitionData result = this.makeMergedPartition(this.current, update);
            return refUpdater.compareAndSet(AtomicBTreePartition.this, this.current, result);
        }
    }
}

