/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.transport.ProtocolVersion;

public interface ReadQuery {
    public static final ReadQuery EMPTY = new ReadQuery(){

        @Override
        public ReadExecutionController executionController() {
            return ReadExecutionController.empty();
        }

        @Override
        public PartitionIterator execute(ConsistencyLevel consistency, ClientState clientState, long queryStartNanoTime) throws RequestExecutionException {
            return EmptyIterators.partition();
        }

        @Override
        public PartitionIterator executeInternal(ReadExecutionController controller) {
            return EmptyIterators.partition();
        }

        @Override
        public UnfilteredPartitionIterator executeLocally(ReadExecutionController executionController) {
            return EmptyIterators.unfilteredPartition(executionController.metaData(), false);
        }

        @Override
        public DataLimits limits() {
            return DataLimits.cqlLimits(0);
        }

        @Override
        public QueryPager getPager(PagingState state, ProtocolVersion protocolVersion) {
            return QueryPager.EMPTY;
        }

        @Override
        public boolean selectsKey(DecoratedKey key) {
            return false;
        }

        @Override
        public boolean selectsClustering(DecoratedKey key, Clustering clustering) {
            return false;
        }

        @Override
        public boolean selectsFullPartition() {
            return false;
        }
    };

    public ReadExecutionController executionController();

    public PartitionIterator execute(ConsistencyLevel var1, ClientState var2, long var3) throws RequestExecutionException;

    public PartitionIterator executeInternal(ReadExecutionController var1);

    public UnfilteredPartitionIterator executeLocally(ReadExecutionController var1);

    public QueryPager getPager(PagingState var1, ProtocolVersion var2);

    public DataLimits limits();

    public boolean selectsKey(DecoratedKey var1);

    public boolean selectsClustering(DecoratedKey var1, Clustering var2);

    public boolean selectsFullPartition();
}

