/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.CompletableFuture;
import org.apache.cassandra.batchlog.LegacyBatchlogMigrator;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.WriteResponse;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.io.util.FastByteArrayInputStream;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.tracing.Tracing;

public class MutationVerbHandler
implements IVerbHandler<Mutation> {
    private void reply(int id, InetAddress replyTo) {
        Tracing.trace("Enqueuing response to {}", (Object)replyTo);
        MessagingService.instance().sendReply(WriteResponse.createMessage(), id, replyTo);
    }

    private void failed() {
        Tracing.trace("Payload application resulted in WriteTimeout, not replying");
    }

    @Override
    public void doVerb(MessageIn<Mutation> message, int id) throws IOException {
        InetAddress replyTo;
        byte[] from = message.parameters.get("FWD_FRM");
        if (from == null) {
            replyTo = message.from;
            byte[] forwardBytes = message.parameters.get("FWD_TO");
            if (forwardBytes != null) {
                MutationVerbHandler.forwardToLocalNodes((Mutation)message.payload, message.verb, forwardBytes, message.from);
            }
        } else {
            replyTo = InetAddress.getByAddress(from);
        }
        try {
            if (message.version < 10 && LegacyBatchlogMigrator.isLegacyBatchlogMutation((Mutation)message.payload)) {
                LegacyBatchlogMigrator.handleLegacyMutation((Mutation)message.payload);
                this.reply(id, replyTo);
            } else {
                ((CompletableFuture)((Mutation)message.payload).applyFuture().thenAccept(o -> this.reply(id, replyTo))).exceptionally(wto -> {
                    this.failed();
                    return null;
                });
            }
        }
        catch (WriteTimeoutException wto2) {
            this.failed();
        }
    }

    private static void forwardToLocalNodes(Mutation mutation, MessagingService.Verb verb, byte[] forwardBytes, InetAddress from) throws IOException {
        try (DataInputStream in = new DataInputStream(new FastByteArrayInputStream(forwardBytes));){
            int size = in.readInt();
            MessageOut<Mutation> message = new MessageOut<Mutation>(verb, mutation, Mutation.serializer).withParameter("FWD_FRM", from.getAddress()).withParameter("CAL_BAC", MessagingService.ONE_BYTE);
            for (int i = 0; i < size; ++i) {
                InetAddress address = CompactEndpointSerializationHelper.deserialize(in);
                int id = in.readInt();
                Tracing.trace("Enqueuing forwarded write to {}", (Object)address);
                MessagingService.instance().sendOneWay(message, id, address);
            }
        }
    }
}

