/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	context "context"

	v1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
	camelv1 "github.com/apache/camel-k/v2/pkg/client/camel/applyconfiguration/camel/v1"
	typedcamelv1 "github.com/apache/camel-k/v2/pkg/client/camel/clientset/versioned/typed/camel/v1"
	autoscalingv1 "k8s.io/api/autoscaling/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	gentype "k8s.io/client-go/gentype"
	testing "k8s.io/client-go/testing"
)

// fakeIntegrations implements IntegrationInterface
type fakeIntegrations struct {
	*gentype.FakeClientWithListAndApply[*v1.Integration, *v1.IntegrationList, *camelv1.IntegrationApplyConfiguration]
	Fake *FakeCamelV1
}

func newFakeIntegrations(fake *FakeCamelV1, namespace string) typedcamelv1.IntegrationInterface {
	return &fakeIntegrations{
		gentype.NewFakeClientWithListAndApply[*v1.Integration, *v1.IntegrationList, *camelv1.IntegrationApplyConfiguration](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("integrations"),
			v1.SchemeGroupVersion.WithKind("Integration"),
			func() *v1.Integration { return &v1.Integration{} },
			func() *v1.IntegrationList { return &v1.IntegrationList{} },
			func(dst, src *v1.IntegrationList) { dst.ListMeta = src.ListMeta },
			func(list *v1.IntegrationList) []*v1.Integration { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.IntegrationList, items []*v1.Integration) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}

// GetScale takes name of the integration, and returns the corresponding scale object, and an error if there is any.
func (c *fakeIntegrations) GetScale(ctx context.Context, integrationName string, options metav1.GetOptions) (result *autoscalingv1.Scale, err error) {
	emptyResult := &autoscalingv1.Scale{}
	obj, err := c.Fake.
		Invokes(testing.NewGetSubresourceActionWithOptions(c.Resource(), c.Namespace(), "scale", integrationName, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*autoscalingv1.Scale), err
}

// UpdateScale takes the representation of a scale and updates it. Returns the server's representation of the scale, and an error, if there is any.
func (c *fakeIntegrations) UpdateScale(ctx context.Context, integrationName string, scale *autoscalingv1.Scale, opts metav1.UpdateOptions) (result *autoscalingv1.Scale, err error) {
	emptyResult := &autoscalingv1.Scale{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceActionWithOptions(c.Resource(), "scale", c.Namespace(), scale, opts), &autoscalingv1.Scale{})

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*autoscalingv1.Scale), err
}
