/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.apache.trevni.InputBuffer;
import org.apache.trevni.InputBytes;
import org.apache.trevni.OutputBuffer;
import org.apache.trevni.TestUtil;
import org.apache.trevni.ValueType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIOBuffers {
    private static final int COUNT = 1001;

    @Test
    void empty() throws Exception {
        OutputBuffer out = new OutputBuffer();
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        Assertions.assertEquals((long)0L, (long)in.tell());
        Assertions.assertEquals((long)0L, (long)in.length());
        out.close();
    }

    @Test
    void zero() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        out.writeInt(0);
        byte[] bytes = out.toByteArray();
        Assertions.assertEquals((int)1, (int)bytes.length);
        Assertions.assertEquals((int)0, (int)bytes[0]);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        Assertions.assertEquals((int)0, (int)in.readInt());
        out.close();
    }

    @Test
    void testBoolean() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        for (int i = 0; i < 1001; ++i) {
            out.writeValue(random.nextBoolean(), ValueType.BOOLEAN);
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        random = TestUtil.createRandom();
        for (int i = 0; i < 1001; ++i) {
            Assertions.assertEquals((Object)random.nextBoolean(), in.readValue(ValueType.BOOLEAN));
        }
        out.close();
    }

    @Test
    void testInt() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        for (int i = 0; i < 1001; ++i) {
            out.writeInt(random.nextInt());
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        random = TestUtil.createRandom();
        for (int i = 0; i < 1001; ++i) {
            Assertions.assertEquals((int)random.nextInt(), (int)in.readInt());
        }
        out.close();
    }

    @Test
    void testLong() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        for (int i = 0; i < 1001; ++i) {
            out.writeLong(random.nextLong());
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        random = TestUtil.createRandom();
        for (int i = 0; i < 1001; ++i) {
            Assertions.assertEquals((long)random.nextLong(), (long)in.readLong());
        }
        out.close();
    }

    @Test
    void fixed32() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        for (int i = 0; i < 1001; ++i) {
            out.writeFixed32(random.nextInt());
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        random = TestUtil.createRandom();
        for (int i = 0; i < 1001; ++i) {
            Assertions.assertEquals((int)random.nextInt(), (int)in.readFixed32());
        }
        out.close();
    }

    @Test
    void fixed64() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        for (int i = 0; i < 1001; ++i) {
            out.writeFixed64(random.nextLong());
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        random = TestUtil.createRandom();
        for (int i = 0; i < 1001; ++i) {
            Assertions.assertEquals((long)random.nextLong(), (long)in.readFixed64());
        }
        out.close();
    }

    @Test
    void testFloat() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        for (int i = 0; i < 1001; ++i) {
            out.writeFloat(random.nextFloat());
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        random = TestUtil.createRandom();
        for (int i = 0; i < 1001; ++i) {
            Assertions.assertEquals((float)random.nextFloat(), (float)in.readFloat(), (float)0.0f);
        }
        out.close();
    }

    @Test
    void testDouble() throws Exception {
        OutputBuffer out = new OutputBuffer();
        for (int i = 0; i < 1001; ++i) {
            out.writeDouble(Double.MIN_VALUE);
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        for (int i = 0; i < 1001; ++i) {
            Assertions.assertEquals((double)Double.MIN_VALUE, (double)in.readDouble(), (double)0.0);
        }
        out.close();
    }

    @Test
    void bytes() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        for (int i = 0; i < 1001; ++i) {
            out.writeBytes(TestUtil.randomBytes(random));
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        random = TestUtil.createRandom();
        for (int i = 0; i < 1001; ++i) {
            Assertions.assertEquals((Object)TestUtil.randomBytes(random), (Object)in.readBytes(null));
        }
        out.close();
    }

    @Test
    void string() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        for (int i = 0; i < 1001; ++i) {
            out.writeString(TestUtil.randomString(random));
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        random = TestUtil.createRandom();
        for (int i = 0; i < 1001; ++i) {
            Assertions.assertEquals((Object)TestUtil.randomString(random), (Object)in.readString());
        }
        out.close();
    }

    @Test
    void skipNull() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(null, ValueType.NULL);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.NULL);
        Assertions.assertEquals((long)sentinel, (long)in.readLong());
        out.close();
    }

    @Test
    void skipBoolean() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(false, ValueType.BOOLEAN);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.BOOLEAN);
        Assertions.assertEquals((long)sentinel, (long)in.readLong());
        out.close();
    }

    @Test
    void skipInt() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(Integer.MAX_VALUE, ValueType.INT);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.INT);
        Assertions.assertEquals((long)sentinel, (long)in.readLong());
        out.close();
    }

    @Test
    void skipLong() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(Long.MAX_VALUE, ValueType.LONG);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.LONG);
        Assertions.assertEquals((long)sentinel, (long)in.readLong());
        out.close();
    }

    @Test
    void skipFixed32() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(Integer.MAX_VALUE, ValueType.FIXED32);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.LONG);
        Assertions.assertEquals((long)sentinel, (long)in.readLong());
        out.close();
    }

    @Test
    void skipFixed64() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(Long.MAX_VALUE, ValueType.FIXED64);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.LONG);
        Assertions.assertEquals((long)sentinel, (long)in.readLong());
        out.close();
    }

    @Test
    void skipFloat() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(Float.valueOf(Float.MAX_VALUE), ValueType.FLOAT);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.FLOAT);
        Assertions.assertEquals((long)sentinel, (long)in.readLong());
        out.close();
    }

    @Test
    void skipDouble() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(Double.MAX_VALUE, ValueType.DOUBLE);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.DOUBLE);
        Assertions.assertEquals((long)sentinel, (long)in.readLong());
        out.close();
    }

    @Test
    void skipString() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue("trevni", ValueType.STRING);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.STRING);
        Assertions.assertEquals((long)sentinel, (long)in.readLong());
        out.close();
    }

    @Test
    void skipBytes() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue("trevni".getBytes(StandardCharsets.UTF_8), ValueType.BYTES);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.BYTES);
        Assertions.assertEquals((long)sentinel, (long)in.readLong());
        out.close();
    }

    @Test
    void initPos() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(Integer.MAX_VALUE, ValueType.INT);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.readInt();
        long pos = in.tell();
        in = new InputBuffer(new InputBytes(out.toByteArray()), pos);
        Assertions.assertEquals((long)sentinel, (long)in.readLong());
        out.close();
    }
}

