/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.idl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;

public final class IdlUtils {
    static final ObjectMapper MAPPER;
    private static final Function<Schema.Field, JsonNode> DEFAULT_VALUE;
    private static final Pattern NEWLINE_PATTERN;
    private static final String NEWLINE;
    private static final Set<String> KEYWORDS;
    private static final EnumSet<Schema.Type> NULLABLE_TYPES;

    static Field getField(Class<?> type, String name) {
        try {
            Field field = type.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Programmer error", e);
        }
    }

    static <T> T getFieldValue(Field field, Object owner) {
        try {
            return (T)field.get(owner);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Programmer error", e);
        }
    }

    private IdlUtils() {
    }

    public static <T> T uncheckExceptions(Callable<T> callable) {
        try {
            return Objects.requireNonNull(callable).call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AvroRuntimeException(e.getMessage(), e);
        }
    }

    public static void writeIdlSchema(Writer writer, Schema schema) throws IOException {
        IdlUtils.writeIdlSchemas(writer, schema.getNamespace(), Collections.singleton(schema));
    }

    public static void writeIdlSchemas(Writer writer, String namespace, Collection<Schema> schemas) throws IOException {
        if (schemas.isEmpty()) {
            throw new IllegalArgumentException("Cannot write 0 schemas");
        }
        if (namespace != null) {
            writer.append("namespace ");
            writer.append(namespace);
            writer.append(";");
            writer.append(NEWLINE);
            writer.append(NEWLINE);
        }
        HashSet<String> alreadyDeclared = new HashSet<String>(4);
        LinkedHashSet<Schema> toDeclare = new LinkedHashSet<Schema>();
        if (schemas.size() == 1) {
            Schema schema = schemas.iterator().next();
            writer.append("schema ");
            IdlUtils.writeFieldSchema(schema, writer, alreadyDeclared, toDeclare, namespace);
            writer.append(";");
            writer.append(NEWLINE);
            writer.append(NEWLINE);
        } else {
            toDeclare.addAll(schemas);
        }
        while (!toDeclare.isEmpty()) {
            if (!alreadyDeclared.isEmpty()) {
                writer.append(NEWLINE);
            }
            Iterator iterator = toDeclare.iterator();
            Schema s2 = (Schema)iterator.next();
            iterator.remove();
            IdlUtils.writeSchema(s2, false, writer, namespace, alreadyDeclared, toDeclare);
        }
    }

    public static void writeIdlProtocol(Writer writer, Protocol protocol) throws IOException {
        String protocolFullName = protocol.getName();
        int lastDotPos = protocolFullName.lastIndexOf(".");
        String protocolNameSpace = lastDotPos < 0 ? protocol.getNamespace() : (lastDotPos > 0 ? protocolFullName.substring(0, lastDotPos) : null);
        IdlUtils.writeIdlProtocol(writer, protocol, protocolNameSpace, protocolFullName.substring(lastDotPos + 1), protocol.getTypes(), protocol.getMessages().values());
    }

    public static void writeIdlProtocol(Writer writer, Schema schema) throws IOException {
        Schema emptyProperties = Schema.create(Schema.Type.NULL);
        IdlUtils.writeIdlProtocol(writer, emptyProperties, schema.getNamespace(), "Protocol", Collections.singletonList(schema), Collections.emptyList());
    }

    public static void writeIdlProtocol(Writer writer, JsonProperties properties, String protocolNameSpace, String protocolName, Collection<Schema> schemas, Collection<Protocol.Message> messages) throws IOException {
        if (protocolNameSpace != null) {
            writer.append("@namespace(\"").append(protocolNameSpace).append("\")").append(NEWLINE);
        }
        IdlUtils.writeJsonProperties(properties, Collections.singleton("namespace"), writer, "");
        writer.append("protocol ").append(Objects.requireNonNull(IdlUtils.safeName(protocolName))).append(" {").append(NEWLINE);
        HashSet<String> alreadyDeclared = new HashSet<String>(4);
        LinkedHashSet<Schema> toDeclare = new LinkedHashSet<Schema>(schemas);
        boolean first = true;
        while (!toDeclare.isEmpty()) {
            if (!first) {
                writer.append(NEWLINE);
            }
            Iterator iterator = toDeclare.iterator();
            Schema schema = (Schema)iterator.next();
            iterator.remove();
            IdlUtils.writeSchema(schema, true, writer, protocolNameSpace, alreadyDeclared, toDeclare);
            first = false;
        }
        if (!schemas.isEmpty() && !messages.isEmpty()) {
            writer.append(NEWLINE);
        }
        for (Protocol.Message message : messages) {
            IdlUtils.writeMessage(message, writer, protocolNameSpace, alreadyDeclared);
        }
        writer.append("}").append(NEWLINE);
    }

    private static String safeName(String name) {
        if (KEYWORDS.contains(name)) {
            return String.format("`%s`", name);
        }
        return name;
    }

    private static void writeSchema(Schema schema, boolean insideProtocol, Writer writer, String defaultNamespace, Set<String> alreadyDeclared, Set<Schema> toDeclare) throws IOException {
        Set<String> schemaAliases;
        String indent = insideProtocol ? "    " : "";
        Schema.Type type = schema.getType();
        IdlUtils.writeSchemaAttributes(indent, schema, writer);
        String namespace = schema.getNamespace();
        if (!Objects.equals(namespace, defaultNamespace)) {
            writer.append(indent).append("@namespace(\"").append(namespace).append("\")").append(NEWLINE);
        }
        if (!(schemaAliases = schema.getAliases()).isEmpty()) {
            writer.append(indent).append("@aliases(").append(MAPPER.writeValueAsString(schemaAliases)).append(")").append(NEWLINE);
        }
        String schemaName = IdlUtils.safeName(schema.getName());
        if (type == Schema.Type.RECORD) {
            String declarationType = schema.isError() ? "error" : "record";
            writer.append(indent).append("").append(declarationType).append(" ").append(schemaName).append(" {").append(NEWLINE);
            alreadyDeclared.add(schema.getFullName());
            for (Schema.Field field : schema.getFields()) {
                IdlUtils.writeField(schema.getNamespace(), field, writer, alreadyDeclared, toDeclare, insideProtocol ? FieldIndent.INSIDE_PROTOCOL : FieldIndent.TOPLEVEL_SCHEMA);
                writer.append(";").append(NEWLINE);
            }
            writer.append(indent).append("}").append(NEWLINE);
        } else if (type == Schema.Type.ENUM) {
            writer.append(indent).append("enum ").append(schemaName).append(" {").append(NEWLINE);
            alreadyDeclared.add(schema.getFullName());
            Iterator<String> i = schema.getEnumSymbols().iterator();
            if (i.hasNext()) {
                writer.append(indent).append("    ").append(i.next());
                while (i.hasNext()) {
                    writer.append(", ");
                    writer.append(i.next());
                }
            } else {
                throw new AvroRuntimeException("Enum schema must have at least a symbol " + String.valueOf(schema));
            }
            writer.append(NEWLINE).append(indent).append("}").append(NEWLINE);
        } else {
            writer.append(indent).append("fixed ").append(schemaName).append('(').append(Integer.toString(schema.getFixedSize())).append(");").append(NEWLINE);
            alreadyDeclared.add(schema.getFullName());
        }
    }

    private static void writeField(String namespace, Schema.Field field, Writer writer, Set<String> alreadyDeclared, Set<Schema> toDeclare, FieldIndent fieldIndent) throws IOException {
        Schema.Field.Order order;
        switch (fieldIndent.ordinal()) {
            case 1: {
                IdlUtils.writeDocumentation(writer, "    ", field.doc());
                writer.append("    ");
                break;
            }
            case 2: {
                IdlUtils.writeDocumentation(writer, "        ", field.doc());
                writer.append("        ");
            }
        }
        IdlUtils.writeFieldSchema(field.schema(), writer, alreadyDeclared, toDeclare, namespace);
        writer.append(' ');
        Set<String> fieldAliases = field.aliases();
        if (!fieldAliases.isEmpty()) {
            writer.append("@aliases(").append(MAPPER.writeValueAsString(fieldAliases)).append(") ");
        }
        if ((order = field.order()) != Schema.Field.Order.ASCENDING) {
            writer.append("@order(\"").append(order.name()).append("\") ");
        }
        IdlUtils.writeJsonProperties(field, writer, null);
        writer.append(field.name());
        JsonNode defaultValue = DEFAULT_VALUE.apply(field);
        if (defaultValue != null) {
            Object datum = field.defaultVal();
            writer.append(" = ").append(MAPPER.writeValueAsString(datum));
        }
    }

    private static void writeDocumentation(Writer writer, String indent, String doc) throws IOException {
        if (doc == null || doc.trim().isEmpty()) {
            return;
        }
        writer.append(IdlUtils.formatDocumentationComment(indent, doc));
    }

    private static String formatDocumentationComment(String indent, String doc) {
        assert (!doc.trim().isEmpty()) : "There must be documentation to format!";
        StringBuffer buffer = new StringBuffer();
        buffer.append(indent).append("/** ");
        boolean foundMatch = false;
        Matcher matcher = NEWLINE_PATTERN.matcher(doc);
        String newlinePlusIndent = NEWLINE + indent + " * ";
        while (matcher.find()) {
            if (!foundMatch) {
                buffer.append(newlinePlusIndent);
                foundMatch = true;
            }
            matcher.appendReplacement(buffer, newlinePlusIndent);
        }
        if (foundMatch) {
            matcher.appendTail(buffer);
            buffer.append(NEWLINE).append(indent).append(" */").append(NEWLINE);
        } else {
            buffer.append(doc).append(" */").append(NEWLINE);
        }
        return buffer.toString();
    }

    private static void writeFieldSchema(Schema schema, Writer writer, Set<String> alreadyDeclared, Set<Schema> toDeclare, String recordNameSpace) throws IOException {
        Schema.Type type = schema.getType();
        if (type == Schema.Type.RECORD || type == Schema.Type.ENUM || type == Schema.Type.FIXED) {
            if (Objects.equals(recordNameSpace, schema.getNamespace())) {
                writer.append(schema.getName());
            } else {
                writer.append(schema.getFullName());
            }
            if (!alreadyDeclared.contains(schema.getFullName())) {
                toDeclare.add(schema);
            }
        } else if (type == Schema.Type.ARRAY) {
            IdlUtils.writeJsonProperties(schema, writer, null);
            writer.append("array<");
            IdlUtils.writeFieldSchema(schema.getElementType(), writer, alreadyDeclared, toDeclare, recordNameSpace);
            writer.append('>');
        } else if (type == Schema.Type.MAP) {
            IdlUtils.writeJsonProperties(schema, writer, null);
            writer.append("map<");
            IdlUtils.writeFieldSchema(schema.getValueType(), writer, alreadyDeclared, toDeclare, recordNameSpace);
            writer.append('>');
        } else if (type == Schema.Type.UNION) {
            Schema schemaForNullableSyntax = IdlUtils.getNullableUnionType(schema);
            if (schemaForNullableSyntax != null) {
                IdlUtils.writeFieldSchema(schemaForNullableSyntax, writer, alreadyDeclared, toDeclare, recordNameSpace);
                writer.append('?');
            } else {
                writer.append("union{");
                List<Schema> types = schema.getTypes();
                Iterator<Schema> iterator = types.iterator();
                if (iterator.hasNext()) {
                    IdlUtils.writeFieldSchema(iterator.next(), writer, alreadyDeclared, toDeclare, recordNameSpace);
                    while (iterator.hasNext()) {
                        writer.append(", ");
                        IdlUtils.writeFieldSchema(iterator.next(), writer, alreadyDeclared, toDeclare, recordNameSpace);
                    }
                } else {
                    throw new AvroRuntimeException("Union schemas must have member types " + String.valueOf(schema));
                }
                writer.append('}');
            }
        } else {
            String typeName;
            Set<String> propertiesToSkip = new HashSet<String>();
            if (schema.getLogicalType() == null) {
                typeName = schema.getName();
            } else {
                String logicalName;
                switch (logicalName = schema.getLogicalType().getName()) {
                    case "date": 
                    case "time-millis": 
                    case "timestamp-millis": {
                        propertiesToSkip.add("logicalType");
                        typeName = logicalName.replace("-millis", "_ms");
                        break;
                    }
                    case "decimal": {
                        propertiesToSkip.addAll(Arrays.asList("logicalType", "precision", "scale"));
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)schema.getLogicalType();
                        typeName = String.format("decimal(%d,%d)", decimal.getPrecision(), decimal.getScale());
                        break;
                    }
                    default: {
                        propertiesToSkip = Collections.emptySet();
                        typeName = schema.getName();
                    }
                }
            }
            IdlUtils.writeJsonProperties(schema, propertiesToSkip, writer, null);
            writer.append(typeName);
        }
    }

    private static Schema getNullableUnionType(Schema unionSchema) {
        List<Schema> types = unionSchema.getTypes();
        if (unionSchema.isNullable() && types.size() == 2) {
            Schema nonNullSchema;
            Schema schema = nonNullSchema = !types.get(0).isNullable() ? types.get(0) : types.get(1);
            if (NULLABLE_TYPES.contains((Object)nonNullSchema.getType())) {
                return nonNullSchema;
            }
        }
        return null;
    }

    private static void writeSchemaAttributes(String indent, Schema schema, Writer writer) throws IOException {
        IdlUtils.writeDocumentation(writer, indent, schema.getDoc());
        IdlUtils.writeJsonProperties(schema, writer, indent);
    }

    private static void writeJsonProperties(JsonProperties props, Writer writer, String indent) throws IOException {
        IdlUtils.writeJsonProperties(props, Collections.emptySet(), writer, indent);
    }

    private static void writeJsonProperties(JsonProperties props, Set<String> propertiesToSkip, Writer writer, String indent) throws IOException {
        Map<String, Object> objectProps = props.getObjectProps();
        for (Map.Entry<String, Object> entry : objectProps.entrySet()) {
            if (propertiesToSkip.contains(entry.getKey())) continue;
            if (indent != null) {
                writer.append(indent);
            }
            writer.append('@').append(entry.getKey()).append('(');
            writer.append(MAPPER.writeValueAsString(entry.getValue())).append(')');
            writer.append(indent == null ? (char)' ' : '\n');
        }
    }

    private static void writeMessage(Protocol.Message message, Writer writer, String protocolNameSpace, Set<String> alreadyDeclared) throws IOException {
        IdlUtils.writeMessageAttributes(message, writer);
        Set<Schema> toDeclare = Collections.unmodifiableSet(new HashSet());
        writer.append("    ");
        IdlUtils.writeFieldSchema(message.getResponse(), writer, alreadyDeclared, toDeclare, protocolNameSpace);
        writer.append(' ');
        writer.append(message.getName());
        Schema request = message.getRequest();
        boolean indentParameters = request.getFields().stream().anyMatch(field -> field.doc() != null && !field.doc().trim().isEmpty());
        writer.append('(');
        if (indentParameters) {
            writer.append("\n");
        }
        boolean first = true;
        for (Schema.Field field2 : request.getFields()) {
            if (first) {
                first = false;
            } else if (indentParameters) {
                writer.append(",\n");
            } else {
                writer.append(", ");
            }
            IdlUtils.writeField(protocolNameSpace, field2, writer, alreadyDeclared, toDeclare, indentParameters ? FieldIndent.INSIDE_PROTOCOL : FieldIndent.NONE);
        }
        if (indentParameters) {
            writer.append("\n    ");
        }
        writer.append(')');
        if (message.isOneWay()) {
            writer.append(" oneway;\n");
        } else {
            first = true;
            for (Schema error : message.getErrors().getTypes()) {
                if (error.getType() == Schema.Type.STRING) continue;
                if (first) {
                    first = false;
                    writer.append(" throws ");
                } else {
                    writer.append(", ");
                }
                if (Objects.equals(protocolNameSpace, error.getNamespace())) {
                    writer.append(error.getName());
                    continue;
                }
                writer.append(error.getFullName());
            }
            writer.append(";\n");
        }
    }

    private static void writeMessageAttributes(Protocol.Message message, Writer writer) throws IOException {
        IdlUtils.writeDocumentation(writer, "    ", message.getDoc());
        IdlUtils.writeJsonProperties(message, writer, "    ");
    }

    static {
        NEWLINE_PATTERN = Pattern.compile("(?U)\\R");
        NEWLINE = System.lineSeparator();
        KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("array", "boolean", "bytes", "date", "decimal", "double", "enum", "error", "false", "fixed", "float", "idl", "import", "int", "local_timestamp_ms", "long", "map", "namespace", "null", "oneway", "protocol", "record", "schema", "string", "throws", "timestamp_ms", "time_ms", "true", "union", "uuid", "void")));
        NULLABLE_TYPES = EnumSet.complementOf(EnumSet.of(Schema.Type.ARRAY, Schema.Type.MAP, Schema.Type.UNION));
        SimpleModule module = new SimpleModule();
        module.addSerializer(new StdSerializer<JsonProperties.Null>(JsonProperties.Null.class){

            @Override
            public void serialize(JsonProperties.Null value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeNull();
            }
        });
        module.addSerializer(new StdSerializer<byte[]>(byte[].class){

            @Override
            public void serialize(byte[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                MAPPER.writeValueAsString(new String(value, StandardCharsets.ISO_8859_1));
            }
        });
        ObjectMapper jsonMapper = (ObjectMapper)IdlUtils.getFieldValue(IdlUtils.getField(Schema.class, "MAPPER"), null);
        MAPPER = jsonMapper.copy().registerModule(module).disable(DeserializationFeature.READ_ENUMS_USING_TO_STRING).disable(SerializationFeature.WRITE_ENUMS_USING_INDEX, SerializationFeature.WRITE_ENUMS_USING_TO_STRING).enable(SerializationFeature.INDENT_OUTPUT).setDefaultPrettyPrinter(new MinimalPrettyPrinter(){

            @Override
            public void writeObjectEntrySeparator(JsonGenerator jg) throws IOException {
                jg.writeRaw(',');
                jg.writeRaw(' ');
            }

            @Override
            public void writeArrayValueSeparator(JsonGenerator jg) throws IOException {
                jg.writeRaw(',');
                jg.writeRaw(' ');
            }
        });
        Field defaultValueField = IdlUtils.getField(Schema.Field.class, "defaultValue");
        DEFAULT_VALUE = field -> (JsonNode)IdlUtils.getFieldValue(defaultValueField, field);
    }

    private static enum FieldIndent {
        NONE,
        TOPLEVEL_SCHEMA,
        INSIDE_PROTOCOL;

    }
}

