/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Message;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.support.MonotonicClock;

public class DefaultMessageHistory
implements MessageHistory {
    private final String routeId;
    private final NamedNode node;
    private final String nodeId;
    private final MonotonicClock clock = new MonotonicClock();
    private final Message message;
    private boolean acceptDebugger;
    private boolean debugSkipOver;
    private long elapsed;

    public DefaultMessageHistory(String routeId, NamedNode node) {
        this(routeId, node, null);
    }

    public DefaultMessageHistory(String routeId, NamedNode node, Message message) {
        this.routeId = routeId;
        this.node = node;
        this.nodeId = node.getId();
        this.message = message;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public NamedNode getNode() {
        return this.node;
    }

    public long getTime() {
        return this.clock.getCreated();
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public void nodeProcessingDone() {
        this.nodeProcessingDone(0L);
    }

    public void nodeProcessingDone(long delta) {
        this.elapsed = this.clock.elapsed();
        if (delta > 0L) {
            this.elapsed -= delta;
        }
        if (this.elapsed < 0L) {
            this.elapsed = 0L;
        }
    }

    public Message getMessage() {
        return this.message;
    }

    public void setAcceptDebugger(boolean acceptDebugger) {
        this.acceptDebugger = acceptDebugger;
    }

    public boolean isAcceptDebugger() {
        return this.acceptDebugger;
    }

    public boolean isDebugSkipOver() {
        return this.debugSkipOver;
    }

    public void setDebugSkipOver(boolean debugSkipOver) {
        this.debugSkipOver = debugSkipOver;
    }

    public String toString() {
        return "DefaultMessageHistory[routeId=" + this.routeId + ", node=" + this.nodeId + "]";
    }
}

