/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.dynssl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.security.CachedSslCertifificateServiceImpl;
import org.parosproxy.paros.security.SslCertificateService;
import org.zaproxy.zap.extension.dynssl.DynSSLParam;
import org.zaproxy.zap.extension.dynssl.DynamicSSLPanel;
import org.zaproxy.zap.extension.dynssl.SslCertificateUtils;

public class ExtensionDynSSL
extends ExtensionAdaptor
implements CommandLineListener {
    public static final String EXTENSION_ID = "ExtensionDynSSL";
    private DynSSLParam params;
    private DynamicSSLPanel optionsPanel;
    private CommandLineArgument[] arguments = new CommandLineArgument[3];
    private static final int ARG_CERT_LOAD = 0;
    private static final int ARG_CERT_PUB_DUMP = 1;
    private static final int ARG_CERT_FULL_DUMP = 2;
    private final Logger logger = LogManager.getLogger(ExtensionDynSSL.class);

    public ExtensionDynSSL() {
        this.setName(EXTENSION_ID);
        this.setOrder(54);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("dynssl.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsPanel());
        }
        extensionHook.addCommandLine(this.getCommandLineArguments());
        extensionHook.addOptionsParamSet(this.getParams());
    }

    @Override
    public void start() {
        KeyStore rootca = this.getParams().getRootca();
        if (rootca == null) {
            try {
                this.createNewRootCa();
            }
            catch (Exception e) {
                this.logger.error("Failed to create new root CA certificate:", (Throwable)e);
            }
            return;
        }
        try {
            this.setRootCa(rootca);
        }
        catch (Exception e) {
            this.logger.error("Couldn't initialize Root CA", (Throwable)e);
        }
        if (this.isCertExpired(this.getRootCaCertificate())) {
            this.warnRootCaCertExpired();
        }
    }

    public void createNewRootCa() throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        this.logger.info("Creating new root CA certificate");
        KeyStore newrootca = SslCertificateUtils.createRootCA();
        this.setRootCa(newrootca);
        this.getParams().setRootca(newrootca);
        this.logger.info("New root CA certificate created");
    }

    private DynamicSSLPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new DynamicSSLPanel(this);
        }
        return this.optionsPanel;
    }

    public DynSSLParam getParams() {
        if (this.params == null) {
            this.params = new DynSSLParam();
        }
        return this.params;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("dynssl.desc");
    }

    public void setRootCa(KeyStore rootca) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        CachedSslCertifificateServiceImpl.getService().initializeRootCA(rootca);
    }

    public Certificate getRootCA() throws KeyStoreException {
        if (this.getParams().getRootca() == null) {
            return null;
        }
        return this.getParams().getRootca().getCertificate("owasp_zap_root_ca");
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    @Override
    public boolean supportsLowMemory() {
        return true;
    }

    public X509Certificate getRootCaCertificate() {
        try {
            return (X509Certificate)this.getRootCA();
        }
        catch (KeyStoreException e) {
            this.logger.error("Couldn't get ZAP's Root CA Certificate", (Throwable)e);
            return null;
        }
    }

    public void writeRootPubCaCertificateToFile(Path path) throws IOException, KeyStoreException {
        KeyStore ks = this.getParams().getRootca();
        if (ks != null) {
            Certificate cert = ks.getCertificate("owasp_zap_root_ca");
            try (BufferedWriter w = Files.newBufferedWriter(path, StandardCharsets.US_ASCII, new OpenOption[0]);
                 PemWriter pw = new PemWriter(w);){
                pw.writeObject(new JcaMiscPEMGenerator(cert));
                pw.flush();
            }
        }
    }

    public void writeRootFullCaCertificateToFile(Path path) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore ks = this.getParams().getRootca();
        if (ks != null) {
            Certificate cert = ks.getCertificate("owasp_zap_root_ca");
            try (BufferedWriter w = Files.newBufferedWriter(path, StandardCharsets.US_ASCII, new OpenOption[0]);
                 PemWriter pw = new PemWriter(w);){
                pw.writeObject(new JcaMiscPEMGenerator(cert));
                pw.flush();
                w.write("-----BEGIN PRIVATE KEY-----\n");
                Key key = ks.getKey("owasp_zap_root_ca", SslCertificateService.PASSPHRASE);
                PrivateKey pk = (PrivateKey)key;
                w.write(Base64.getMimeEncoder().encodeToString(pk.getEncoded()));
                w.write("\n-----END PRIVATE KEY-----\n");
            }
        }
    }

    private static void writeCert(String path, CertWriter writer) {
        File file = new File(path);
        if (file.exists() && !file.canWrite()) {
            CommandLine.error(Constant.messages.getString("dynssl.cmdline.error.nowrite", file.getAbsolutePath()));
        } else {
            try {
                writer.write(file.toPath());
                CommandLine.info(Constant.messages.getString("dynssl.cmdline.certdump.done", file.getAbsolutePath()));
            }
            catch (Exception e) {
                CommandLine.error(Constant.messages.getString("dynssl.cmdline.error.write", file.getAbsolutePath()), e);
            }
        }
    }

    public String importRootCaCertificate(File pemFile) {
        byte[] key;
        byte[] cert;
        String pem;
        try {
            pem = FileUtils.readFileToString(pemFile, StandardCharsets.US_ASCII);
        }
        catch (IOException e) {
            return Constant.messages.getString("dynssl.importpem.failedreadfile", e.getLocalizedMessage());
        }
        try {
            cert = SslCertificateUtils.extractCertificate(pem);
            if (cert.length == 0) {
                return Constant.messages.getString("dynssl.importpem.nocertsection", "-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----");
            }
        }
        catch (IllegalArgumentException e) {
            return Constant.messages.getString("dynssl.importpem.certnobase64");
        }
        try {
            key = SslCertificateUtils.extractPrivateKey(pem);
            if (key.length == 0) {
                return Constant.messages.getString("dynssl.importpem.noprivkeysection", "-----BEGIN PRIVATE KEY-----", "-----END PRIVATE KEY-----");
            }
        }
        catch (IllegalArgumentException e) {
            return Constant.messages.getString("dynssl.importpem.privkeynobase64");
        }
        try {
            KeyStore ks = SslCertificateUtils.pem2KeyStore(cert, key);
            this.setRootCa(ks);
            this.getParams().setRootca(ks);
            return null;
        }
        catch (Exception e) {
            return Constant.messages.getString("dynssl.importpem.failedkeystore", e.getLocalizedMessage());
        }
    }

    private boolean isCertExpired(X509Certificate cert) {
        return cert != null && cert.getNotAfter().before(new Date());
    }

    private void warnRootCaCertExpired() {
        X509Certificate cert = this.getRootCaCertificate();
        if (cert == null) {
            return;
        }
        String warnMsg = Constant.messages.getString("dynssl.warn.cert.expired", cert.getNotAfter().toString(), new Date().toString());
        if (this.hasView() && this.getView().showConfirmDialog(warnMsg) == 0) {
            try {
                this.createNewRootCa();
                Control.getSingleton().getMenuToolsControl().options(Constant.messages.getString("dynssl.options.name"));
            }
            catch (Exception e) {
                this.logger.error("Failed to create new root CA certificate:", (Throwable)e);
                this.getView().showWarningDialog(Constant.messages.getString("dynssl.warn.cert.failed", e.getMessage()));
            }
        }
        this.logger.warn(warnMsg);
    }

    @Override
    public void execute(CommandLineArgument[] args) {
        if (this.arguments[0].isEnabled()) {
            File file = new File(this.arguments[0].getArguments().firstElement());
            if (!file.canRead()) {
                CommandLine.error(Constant.messages.getString("dynssl.cmdline.error.noread", file.getAbsolutePath()));
            } else {
                String error = this.importRootCaCertificate(file);
                if (error == null) {
                    CommandLine.info(Constant.messages.getString("dynssl.cmdline.certload.done", file.getAbsolutePath()));
                } else {
                    CommandLine.error(error);
                }
            }
        }
        if (this.arguments[1].isEnabled()) {
            ExtensionDynSSL.writeCert(this.arguments[1].getArguments().firstElement(), this::writeRootPubCaCertificateToFile);
        }
        if (this.arguments[2].isEnabled()) {
            ExtensionDynSSL.writeCert(this.arguments[2].getArguments().firstElement(), this::writeRootFullCaCertificateToFile);
        }
    }

    private CommandLineArgument[] getCommandLineArguments() {
        this.arguments[0] = new CommandLineArgument("-certload", 1, null, "", "-certload <path>         " + Constant.messages.getString("dynssl.cmdline.certload"));
        this.arguments[1] = new CommandLineArgument("-certpubdump", 1, null, "", "-certpubdump <path>      " + Constant.messages.getString("dynssl.cmdline.certpubdump"));
        this.arguments[2] = new CommandLineArgument("-certfulldump", 1, null, "", "-certfulldump <path>     " + Constant.messages.getString("dynssl.cmdline.certfulldump"));
        return this.arguments;
    }

    @Override
    public boolean handleFile(File file) {
        return false;
    }

    @Override
    public List<String> getHandledExtensions() {
        return null;
    }

    private static interface CertWriter {
        public void write(Path var1) throws Exception;
    }
}

