/* hypertextview.c generated by valac 0.56.17, the Vala compiler
 * generated from hypertextview.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009-2010  Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009       Cornelius Hald <hald@icandy.de>
 *  Copyright (c) 2023       Arthur Demchenkov <spinal.by@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "libnotes.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <pango/pango.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	XNP_HYPERTEXT_VIEW_0_PROPERTY,
	XNP_HYPERTEXT_VIEW_FONT_PROPERTY,
	XNP_HYPERTEXT_VIEW_NUM_PROPERTIES
};
static GParamSpec* xnp_hypertext_view_properties[XNP_HYPERTEXT_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define __vala_PangoTabArray_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoTabArray_free (var), NULL)))

struct _XnpHypertextViewPrivate {
	GSList* checkboxes;
	GdkCursor* hand_cursor;
	GdkCursor* regular_cursor;
	gboolean cursor_over_checkbox;
	gboolean cursor_over_link;
	GtkTextTag* tag_bold;
	GtkTextTag* tag_italic;
	GtkTextTag* tag_strikethrough;
	GtkTextTag* tag_underline;
	GtkTextTag* tag_link;
	GRegex* regex_link;
	gchar* _font;
};

struct _Block4Data {
	int _ref_count_;
	XnpHypertextView* self;
	gchar* tag_name;
};

struct _Block5Data {
	int _ref_count_;
	XnpHypertextView* self;
	gchar* tags_text;
};

struct _Block6Data {
	int _ref_count_;
	XnpHypertextView* self;
	GtkTextIter start;
	GtkTextIter end;
};

struct _Block7Data {
	int _ref_count_;
	XnpHypertextView* self;
	GtkTextChildAnchor* anchor;
};

static gint XnpHypertextView_private_offset;
static gpointer xnp_hypertext_view_parent_class = NULL;
static gchar* xnp_hypertext_view_tag_char;
static gchar* xnp_hypertext_view_tag_char = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static void xnp_hypertext_view_style_updated_cb (XnpHypertextView* self,
                                          GtkWidget* hypertextview);
static void _xnp_hypertext_view_style_updated_cb_gtk_widget_style_updated (GtkWidget* _sender,
                                                                    gpointer self);
static void xnp_hypertext_view_populate_popup_cb (XnpHypertextView* self,
                                           GtkMenu* popup_menu);
static void _xnp_hypertext_view_populate_popup_cb_gtk_text_view_populate_popup (GtkTextView* _sender,
                                                                         GtkMenu* popup,
                                                                         gpointer self);
static gboolean xnp_hypertext_view_button_release_event_cb (XnpHypertextView* self,
                                                     GtkWidget* hypertextview,
                                                     GdkEventButton* event);
static gboolean _xnp_hypertext_view_button_release_event_cb_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                      GdkEventButton* event,
                                                                                      gpointer self);
static gboolean xnp_hypertext_view_motion_notify_event_cb (XnpHypertextView* self,
                                                    GtkWidget* hypertextview,
                                                    GdkEventMotion* event);
static gboolean _xnp_hypertext_view_motion_notify_event_cb_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                    GdkEventMotion* event,
                                                                                    gpointer self);
static void xnp_hypertext_view_state_flags_changed_cb (XnpHypertextView* self);
static void _xnp_hypertext_view_state_flags_changed_cb_gtk_widget_state_flags_changed (GtkWidget* _sender,
                                                                                GtkStateFlags previous_state_flags,
                                                                                gpointer self);
static void xnp_hypertext_view_insert_text_cb (XnpHypertextView* self,
                                        GtkTextBuffer* buffer,
                                        GtkTextIter* location,
                                        const gchar* text,
                                        gint len);
static void _xnp_hypertext_view_insert_text_cb_gtk_text_buffer_insert_text (GtkTextBuffer* _sender,
                                                                     GtkTextIter* pos,
                                                                     const gchar* new_text,
                                                                     gint new_text_length,
                                                                     gpointer self);
static void xnp_hypertext_view_delete_range_cb (XnpHypertextView* self,
                                         GtkTextBuffer* buffer,
                                         GtkTextIter* start,
                                         GtkTextIter* end);
static void _xnp_hypertext_view_delete_range_cb_gtk_text_buffer_delete_range (GtkTextBuffer* _sender,
                                                                       GtkTextIter* start,
                                                                       GtkTextIter* end,
                                                                       gpointer self);
static void xnp_hypertext_view_menu_add_text_formatting (XnpHypertextView* self,
                                                  GtkMenu* menu,
                                                  const gchar* tag_name,
                                                  const gchar* text);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda13_ (Block4Data* _data4_);
static void ___lambda13__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda7_ (XnpHypertextView* self);
static void ___lambda7__gtk_menu_item_activate (GtkMenuItem* _sender,
                                         gpointer self);
static void xnp_hypertext_view_auto_highlight_urls (XnpHypertextView* self,
                                             GtkTextIter* start,
                                             GtkTextIter* end);
static gboolean _gtk_text_iter_equal (const GtkTextIter * s1,
                               const GtkTextIter * s2);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda14_ (Block5Data* _data5_,
                   GtkTextTag* tag);
static void ____lambda14__gfunc (gconstpointer data,
                          gpointer self);
static void ___lambda15_ (Block5Data* _data5_,
                   GtkTextTag* tag);
static void ____lambda15__gfunc (gconstpointer data,
                          gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ______lambda16_ (Block6Data* _data6_,
                      const gchar* tag);
static void _______lambda16__gfunc (gconstpointer data,
                             gpointer self);
static gchar** xnp_hypertext_view_split_tags (XnpHypertextView* self,
                                       const gchar* tags,
                                       gint* result_length1);
static void xnp_hypertext_view_insert_checkbox_at_iter (XnpHypertextView* self,
                                                 GtkTextIter* iter,
                                                 gboolean checked);
static void __________lambda17_ (Block6Data* _data6_,
                          const gchar* tag);
static void ___________lambda17__gfunc (gconstpointer data,
                                 gpointer self);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void xnp_hypertext_view_extend_block (XnpHypertextView* self,
                                      GtkTextIter* start_iter,
                                      GtkTextIter* end_iter,
                                      gint max_len);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean __lambda8_ (XnpHypertextView* self);
static gboolean ___lambda8__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                    GdkEventCrossing* event,
                                                    gpointer self);
static gboolean __lambda9_ (XnpHypertextView* self);
static gboolean ___lambda9__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                    GdkEventCrossing* event,
                                                    gpointer self);
static void __lambda10_ (XnpHypertextView* self);
static void ___lambda10__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void __lambda11_ (Block7Data* _data7_);
static void ___lambda11__gtk_widget_destroy (GtkWidget* _sender,
                                      gpointer self);
static gint __lambda12_ (XnpHypertextView* self,
                  GtkTextChildAnchor* a,
                  GtkTextChildAnchor* b);
static gint ___lambda12__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static GObject * xnp_hypertext_view_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void _vala_PangoTabArray_free (PangoTabArray* self);
static void xnp_hypertext_view_finalize (GObject * obj);
static GType xnp_hypertext_view_get_type_once (void);
static void _vala_xnp_hypertext_view_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_xnp_hypertext_view_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
xnp_hypertext_view_get_instance_private (XnpHypertextView* self)
{
	return G_STRUCT_MEMBER_P (self, XnpHypertextView_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static void
_xnp_hypertext_view_style_updated_cb_gtk_widget_style_updated (GtkWidget* _sender,
                                                               gpointer self)
{
	xnp_hypertext_view_style_updated_cb ((XnpHypertextView*) self, _sender);
}

static void
_xnp_hypertext_view_populate_popup_cb_gtk_text_view_populate_popup (GtkTextView* _sender,
                                                                    GtkMenu* popup,
                                                                    gpointer self)
{
	xnp_hypertext_view_populate_popup_cb ((XnpHypertextView*) self, popup);
}

static gboolean
_xnp_hypertext_view_button_release_event_cb_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                             GdkEventButton* event,
                                                                             gpointer self)
{
	gboolean result;
	result = xnp_hypertext_view_button_release_event_cb ((XnpHypertextView*) self, _sender, event);
	return result;
}

static gboolean
_xnp_hypertext_view_motion_notify_event_cb_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                           GdkEventMotion* event,
                                                                           gpointer self)
{
	gboolean result;
	result = xnp_hypertext_view_motion_notify_event_cb ((XnpHypertextView*) self, _sender, event);
	return result;
}

static void
_xnp_hypertext_view_state_flags_changed_cb_gtk_widget_state_flags_changed (GtkWidget* _sender,
                                                                           GtkStateFlags previous_state_flags,
                                                                           gpointer self)
{
	xnp_hypertext_view_state_flags_changed_cb ((XnpHypertextView*) self);
}

static void
_xnp_hypertext_view_insert_text_cb_gtk_text_buffer_insert_text (GtkTextBuffer* _sender,
                                                                GtkTextIter* pos,
                                                                const gchar* new_text,
                                                                gint new_text_length,
                                                                gpointer self)
{
	xnp_hypertext_view_insert_text_cb ((XnpHypertextView*) self, _sender, pos, new_text, new_text_length);
}

static void
_xnp_hypertext_view_delete_range_cb_gtk_text_buffer_delete_range (GtkTextBuffer* _sender,
                                                                  GtkTextIter* start,
                                                                  GtkTextIter* end,
                                                                  gpointer self)
{
	xnp_hypertext_view_delete_range_cb ((XnpHypertextView*) self, _sender, start, end);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

XnpHypertextView*
xnp_hypertext_view_construct (GType object_type)
{
	XnpHypertextView * self = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkSourceBuffer* source_buffer = NULL;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkSourceBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkTextTag* _tmp9_;
	GtkTextTag* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextTag* _tmp13_;
	GtkTextTag* _tmp14_;
	GtkTextBuffer* _tmp15_;
	GtkTextBuffer* _tmp16_;
	GtkTextTag* _tmp17_;
	GtkTextTag* _tmp18_;
	GtkTextBuffer* _tmp19_;
	GtkTextBuffer* _tmp20_;
	GtkTextTag* _tmp21_;
	GtkTextTag* _tmp22_;
	GtkTextBuffer* _tmp23_;
	GtkTextBuffer* _tmp24_;
	GtkTextTag* _tmp25_;
	GtkTextTag* _tmp26_;
	self = (XnpHypertextView*) g_object_new (object_type, NULL);
	g_signal_connect_object ((GtkWidget*) self, "style-updated", (GCallback) _xnp_hypertext_view_style_updated_cb_gtk_widget_style_updated, self, 0);
	g_signal_connect_object ((GtkTextView*) self, "populate-popup", (GCallback) _xnp_hypertext_view_populate_popup_cb_gtk_text_view_populate_popup, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _xnp_hypertext_view_button_release_event_cb_gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _xnp_hypertext_view_motion_notify_event_cb_gtk_widget_motion_notify_event, self, G_CONNECT_AFTER);
	g_signal_connect_object ((GtkWidget*) self, "state-flags-changed", (GCallback) _xnp_hypertext_view_state_flags_changed_cb_gtk_widget_state_flags_changed, self, 0);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object (_tmp1_, "insert-text", (GCallback) _xnp_hypertext_view_insert_text_cb_gtk_text_buffer_insert_text, self, G_CONNECT_AFTER);
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp3_ = _tmp2_;
	g_signal_connect_object (_tmp3_, "delete-range", (GCallback) _xnp_hypertext_view_delete_range_cb_gtk_text_buffer_delete_range, self, G_CONNECT_AFTER);
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_source_buffer_get_type ()) ? ((GtkSourceBuffer*) _tmp5_) : NULL);
	source_buffer = _tmp6_;
	gtk_source_buffer_set_highlight_matching_brackets (source_buffer, FALSE);
	_tmp7_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = gtk_text_buffer_create_tag (_tmp8_, "b", "weight", PANGO_WEIGHT_BOLD, NULL, NULL);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (self->priv->tag_bold);
	self->priv->tag_bold = _tmp10_;
	_tmp11_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = gtk_text_buffer_create_tag (_tmp12_, "i", "style", PANGO_STYLE_ITALIC, NULL, NULL);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_g_object_unref0 (self->priv->tag_italic);
	self->priv->tag_italic = _tmp14_;
	_tmp15_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp16_ = _tmp15_;
	_tmp17_ = gtk_text_buffer_create_tag (_tmp16_, "s", "strikethrough", TRUE, NULL, NULL);
	_tmp18_ = _g_object_ref0 (_tmp17_);
	_g_object_unref0 (self->priv->tag_strikethrough);
	self->priv->tag_strikethrough = _tmp18_;
	_tmp19_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp20_ = _tmp19_;
	_tmp21_ = gtk_text_buffer_create_tag (_tmp20_, "u", "underline", PANGO_UNDERLINE_SINGLE, NULL, NULL);
	_tmp22_ = _g_object_ref0 (_tmp21_);
	_g_object_unref0 (self->priv->tag_underline);
	self->priv->tag_underline = _tmp22_;
	_tmp23_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp24_ = _tmp23_;
	_tmp25_ = gtk_text_buffer_create_tag (_tmp24_, "link", "foreground", "blue", "underline", PANGO_UNDERLINE_SINGLE, NULL, NULL);
	_tmp26_ = _g_object_ref0 (_tmp25_);
	_g_object_unref0 (self->priv->tag_link);
	self->priv->tag_link = _tmp26_;
	_g_object_unref0 (source_buffer);
	return self;
}

XnpHypertextView*
xnp_hypertext_view_new (void)
{
	return xnp_hypertext_view_construct (XNP_TYPE_HYPERTEXT_VIEW);
}

/**
 * style_updated_cb:
 *
 * Get the link color from the css.
 */
static void
xnp_hypertext_view_style_updated_cb (XnpHypertextView* self,
                                     GtkWidget* hypertextview)
{
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStateFlags state = 0U;
	GtkTextTag* _tmp2_;
	GdkRGBA _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (hypertextview != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	state = gtk_style_context_get_state (context);
	state &= ~GTK_STATE_FLAG_VISITED;
	state |= GTK_STATE_FLAG_LINK;
	gtk_style_context_save (context);
	gtk_style_context_set_state (context, state);
	gtk_style_context_remove_class (context, GTK_STYLE_CLASS_VIEW);
	_tmp2_ = self->priv->tag_link;
	gtk_style_context_get_color (context, state, &_tmp3_);
	g_object_set (_tmp2_, "foreground-rgba", &_tmp3_, NULL);
	gtk_style_context_restore (context);
	_g_object_unref0 (context);
}

/**
 * button_release_event_cb:
 *
 * Event to open links.
 */
static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
xnp_hypertext_view_button_release_event_cb (XnpHypertextView* self,
                                            GtkWidget* hypertextview,
                                            GdkEventButton* event)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter iter = {0};
	gchar* link = NULL;
	gint x = 0;
	gint y = 0;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkTextIter _tmp6_ = {0};
	GtkTextTag* _tmp7_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (hypertextview != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) GDK_BUTTON_PRIMARY)) {
		result = FALSE;
		_g_free0 (link);
		return result;
	}
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_selection_bounds (_tmp1_, &_tmp2_, &_tmp3_);
	start = _tmp2_;
	end = _tmp3_;
	if (gtk_text_iter_get_offset (&start) != gtk_text_iter_get_offset (&end)) {
		result = FALSE;
		_g_free0 (link);
		return result;
	}
	gtk_text_view_window_to_buffer_coords ((GtkTextView*) self, GTK_TEXT_WINDOW_WIDGET, (gint) event->x, (gint) event->y, &_tmp4_, &_tmp5_);
	x = _tmp4_;
	y = _tmp5_;
	gtk_text_view_get_iter_at_location ((GtkTextView*) self, &_tmp6_, x, y);
	iter = _tmp6_;
	_tmp7_ = self->priv->tag_link;
	if (gtk_text_iter_has_tag (&iter, _tmp7_)) {
		GtkTextIter _tmp8_;
		GtkTextIter _tmp9_;
		GtkTextTag* _tmp10_;
		GtkTextTag* _tmp12_;
		GtkTextIter _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gboolean _tmp18_;
		_tmp8_ = iter;
		end = _tmp8_;
		_tmp9_ = end;
		start = _tmp9_;
		_tmp10_ = self->priv->tag_link;
		if (!gtk_text_iter_starts_tag (&start, _tmp10_)) {
			GtkTextTag* _tmp11_;
			_tmp11_ = self->priv->tag_link;
			gtk_text_iter_backward_to_tag_toggle (&start, _tmp11_);
		}
		_tmp12_ = self->priv->tag_link;
		gtk_text_iter_forward_to_tag_toggle (&end, _tmp12_);
		_tmp13_ = end;
		_tmp14_ = gtk_text_iter_get_text (&start, &_tmp13_);
		_g_free0 (link);
		link = _tmp14_;
		_tmp15_ = link;
		_tmp16_ = string_slice (_tmp15_, (glong) 0, (glong) 2);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strcmp0 (_tmp17_, "~/") == 0;
		_g_free0 (_tmp17_);
		if (_tmp18_) {
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp19_ = g_get_home_dir ();
			_tmp20_ = link;
			_tmp21_ = string_substring (_tmp20_, (glong) 2, (glong) -1);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strdup_printf ("%s/%s", _tmp19_, _tmp22_);
			_g_free0 (link);
			link = _tmp23_;
			_g_free0 (_tmp22_);
		}
		{
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp24_ = link;
			_tmp25_ = g_strconcat ("exo-open ", _tmp24_, NULL);
			_tmp26_ = _tmp25_;
			g_spawn_command_line_async (_tmp26_, &_inner_error0_);
			_g_free0 (_tmp26_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			result = FALSE;
			_g_free0 (link);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp27_ = FALSE;
			_g_free0 (link);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp27_;
		}
		{
			const gchar* _tmp28_;
			_tmp28_ = link;
			g_app_info_launch_default_for_uri (_tmp28_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			result = FALSE;
			_g_free0 (link);
			return result;
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp29_;
			const gchar* _tmp30_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp29_ = e;
			_tmp30_ = _tmp29_->message;
			g_message ("hypertextview.vala:171: Unable to open link with default handler: %s", _tmp30_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp31_ = FALSE;
			_g_free0 (link);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp31_;
		}
		{
			const gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp32_ = link;
			_tmp33_ = g_strconcat ("xdg-open ", _tmp32_, NULL);
			_tmp34_ = _tmp33_;
			g_spawn_command_line_async (_tmp34_, &_inner_error0_);
			_g_free0 (_tmp34_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			result = FALSE;
			_g_free0 (link);
			return result;
		}
		goto __finally2;
		__catch2_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp35_ = FALSE;
			_g_free0 (link);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp35_;
		}
		{
			const gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			_tmp36_ = link;
			_tmp37_ = g_strconcat ("firefox ", _tmp36_, NULL);
			_tmp38_ = _tmp37_;
			g_spawn_command_line_async (_tmp38_, &_inner_error0_);
			_g_free0 (_tmp38_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
			result = FALSE;
			_g_free0 (link);
			return result;
		}
		goto __finally3;
		__catch3_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp39_ = FALSE;
			_g_free0 (link);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp39_;
		}
		g_message ("hypertextview.vala:186: Unable to find an appropriate fallback to open" \
" the link");
	}
	result = FALSE;
	_g_free0 (link);
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		XnpHypertextView* self;
		self = _data4_->self;
		_g_free0 (_data4_->tag_name);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda13_ (Block4Data* _data4_)
{
	XnpHypertextView* self;
	self = _data4_->self;
	xnp_hypertext_view_toggle_tag (self, _data4_->tag_name);
}

static void
___lambda13__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda13_ (self);
}

static void
xnp_hypertext_view_menu_add_text_formatting (XnpHypertextView* self,
                                             GtkMenu* menu,
                                             const gchar* tag_name,
                                             const gchar* text)
{
	Block4Data* _data4_;
	gchar* _tmp0_;
	GtkMenuItem* mi = NULL;
	GtkMenuItem* _tmp1_;
	GtkLabel* label = NULL;
	GtkWidget* _tmp2_;
	GtkLabel* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	g_return_if_fail (tag_name != NULL);
	g_return_if_fail (text != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = g_strdup (tag_name);
	_g_free0 (_data4_->tag_name);
	_data4_->tag_name = _tmp0_;
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("");
	g_object_ref_sink (_tmp1_);
	mi = _tmp1_;
	_tmp2_ = gtk_bin_get_child ((GtkBin*) mi);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp2_) : NULL);
	label = _tmp3_;
	_tmp4_ = g_strdup_printf ("<%s>%s</%s>", _data4_->tag_name, text, _data4_->tag_name);
	_tmp5_ = _tmp4_;
	gtk_label_set_markup (label, _tmp5_);
	_g_free0 (_tmp5_);
	gtk_menu_shell_insert ((GtkMenuShell*) menu, G_TYPE_CHECK_INSTANCE_TYPE (mi, gtk_widget_get_type ()) ? ((GtkWidget*) mi) : NULL, -1);
	g_signal_connect_data (mi, "activate", (GCallback) ___lambda13__gtk_menu_item_activate, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_g_object_unref0 (label);
	_g_object_unref0 (mi);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
__lambda7_ (XnpHypertextView* self)
{
	xnp_hypertext_view_insert_checkbox (self, FALSE);
}

static void
___lambda7__gtk_menu_item_activate (GtkMenuItem* _sender,
                                    gpointer self)
{
	__lambda7_ ((XnpHypertextView*) self);
}

static void
xnp_hypertext_view_populate_popup_cb (XnpHypertextView* self,
                                      GtkMenu* popup_menu)
{
	GtkMenuItem* mi = NULL;
	GtkMenuItem* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* _tmp2_;
	GtkSeparatorMenuItem* _tmp3_;
	GtkMenuItem* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (popup_menu != NULL);
	_tmp0_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Insert checkbox"));
	g_object_ref_sink (_tmp0_);
	mi = _tmp0_;
	_tmp1_ = mi;
	g_signal_connect_object (_tmp1_, "activate", (GCallback) ___lambda7__gtk_menu_item_activate, self, 0);
	_tmp2_ = mi;
	gtk_menu_shell_insert ((GtkMenuShell*) popup_menu, G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp2_) : NULL, -1);
	_tmp3_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (mi);
	mi = (GtkMenuItem*) _tmp3_;
	_tmp4_ = mi;
	gtk_menu_shell_insert ((GtkMenuShell*) popup_menu, G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp4_) : NULL, -1);
	xnp_hypertext_view_menu_add_text_formatting (self, popup_menu, "s", _ ("Strikethrough"));
	xnp_hypertext_view_menu_add_text_formatting (self, popup_menu, "u", _ ("Underline"));
	xnp_hypertext_view_menu_add_text_formatting (self, popup_menu, "i", _ ("Italic"));
	xnp_hypertext_view_menu_add_text_formatting (self, popup_menu, "b", _ ("Bold"));
	gtk_widget_show_all ((GtkWidget*) popup_menu);
	_g_object_unref0 (mi);
}

/**
 * motion_notify_event_cb:
 *
 * Event to update the cursor of the pointer.
 */
static gboolean
xnp_hypertext_view_motion_notify_event_cb (XnpHypertextView* self,
                                           GtkWidget* hypertextview,
                                           GdkEventMotion* event)
{
	GdkCursor* cursor = NULL;
	GtkTextIter iter = {0};
	GdkWindow* win = NULL;
	gint x = 0;
	gint y = 0;
	GdkWindow* _tmp8_;
	GdkWindow* _tmp9_;
	GdkWindow* _tmp10_;
	GdkCursor* _tmp11_;
	GdkCursor* _tmp12_;
	GdkCursor* _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (hypertextview != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	cursor = NULL;
	if (!self->priv->cursor_over_checkbox) {
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		GtkTextIter _tmp2_ = {0};
		GtkTextTag* _tmp3_;
		GdkCursor* _tmp4_ = NULL;
		GdkCursor* _tmp7_;
		gtk_text_view_window_to_buffer_coords ((GtkTextView*) self, GTK_TEXT_WINDOW_WIDGET, (gint) event->x, (gint) event->y, &_tmp0_, &_tmp1_);
		x = _tmp0_;
		y = _tmp1_;
		gtk_text_view_get_iter_at_location ((GtkTextView*) self, &_tmp2_, x, y);
		iter = _tmp2_;
		_tmp3_ = self->priv->tag_link;
		self->priv->cursor_over_link = gtk_text_iter_has_tag (&iter, _tmp3_);
		if (self->priv->cursor_over_link) {
			GdkCursor* _tmp5_;
			_tmp5_ = self->priv->hand_cursor;
			_tmp4_ = _tmp5_;
		} else {
			GdkCursor* _tmp6_;
			_tmp6_ = self->priv->regular_cursor;
			_tmp4_ = _tmp6_;
		}
		_tmp7_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (cursor);
		cursor = _tmp7_;
	}
	_tmp8_ = gtk_text_view_get_window ((GtkTextView*) self, GTK_TEXT_WINDOW_TEXT);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (win);
	win = _tmp9_;
	_tmp10_ = win;
	_tmp11_ = gdk_window_get_cursor (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = cursor;
	if (_tmp12_ != _tmp13_) {
		GdkWindow* _tmp14_;
		GdkCursor* _tmp15_;
		_tmp14_ = win;
		_tmp15_ = cursor;
		gdk_window_set_cursor (_tmp14_, _tmp15_);
	}
	result = FALSE;
	_g_object_unref0 (win);
	_g_object_unref0 (cursor);
	return result;
}

/**
 * state_flags_changed_cb:
 *
 * Fix mouse cursor behavior after clicking on a link.
 */
static void
xnp_hypertext_view_state_flags_changed_cb (XnpHypertextView* self)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (gtk_widget_get_realized ((GtkWidget*) self)) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = gtk_widget_get_sensitive ((GtkWidget*) self);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GdkWindow* win = NULL;
		GdkWindow* _tmp3_;
		GdkWindow* _tmp4_;
		GdkCursor* _tmp5_ = NULL;
		GdkWindow* _tmp8_;
		_tmp3_ = gtk_text_view_get_window ((GtkTextView*) self, GTK_TEXT_WINDOW_TEXT);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		win = _tmp4_;
		if (self->priv->cursor_over_link) {
			GdkCursor* _tmp6_;
			_tmp6_ = self->priv->hand_cursor;
			_tmp5_ = _tmp6_;
		} else {
			GdkCursor* _tmp7_;
			_tmp7_ = self->priv->regular_cursor;
			_tmp5_ = _tmp7_;
		}
		_tmp8_ = win;
		gdk_window_set_cursor (_tmp8_, _tmp5_);
		_g_object_unref0 (win);
	}
}

/**
 * insert_text_cb:
 *
 * Event to create and update existing tags within the buffer.
 */
static void
xnp_hypertext_view_insert_text_cb (XnpHypertextView* self,
                                   GtkTextBuffer* buffer,
                                   GtkTextIter* location,
                                   const gchar* text,
                                   gint len)
{
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp0_;
	GtkTextIter _tmp1_;
	GtkTextIter _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	g_return_if_fail (location != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = *location;
	end_iter = _tmp0_;
	gtk_text_iter_forward_chars (&end_iter, g_utf8_strlen (text, (gssize) -1));
	_tmp1_ = *location;
	_tmp2_ = end_iter;
	xnp_hypertext_view_auto_highlight_urls (self, &_tmp1_, &_tmp2_);
}

/**
 * delete_range_cb:
 *
 * Event to delete and update existing tags within the buffer.
 */
static void
xnp_hypertext_view_delete_range_cb (XnpHypertextView* self,
                                    GtkTextBuffer* buffer,
                                    GtkTextIter* start,
                                    GtkTextIter* end)
{
	GtkTextIter _tmp0_;
	GtkTextIter _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	_tmp0_ = *start;
	_tmp1_ = *end;
	xnp_hypertext_view_auto_highlight_urls (self, &_tmp0_, &_tmp1_);
}

void
xnp_hypertext_view_undo (XnpHypertextView* self)
{
	GtkSourceBuffer* buffer = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	GtkSourceBuffer* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_source_buffer_get_type ()) ? ((GtkSourceBuffer*) _tmp1_) : NULL);
	buffer = _tmp2_;
	_tmp3_ = buffer;
	g_object_get (_tmp3_, "can-undo", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		GtkSourceBuffer* _tmp6_;
		_tmp6_ = buffer;
		gtk_source_buffer_undo (_tmp6_);
	}
	_g_object_unref0 (buffer);
}

void
xnp_hypertext_view_redo (XnpHypertextView* self)
{
	GtkSourceBuffer* buffer = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	GtkSourceBuffer* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_source_buffer_get_type ()) ? ((GtkSourceBuffer*) _tmp1_) : NULL);
	buffer = _tmp2_;
	_tmp3_ = buffer;
	g_object_get (_tmp3_, "can-redo", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		GtkSourceBuffer* _tmp6_;
		_tmp6_ = buffer;
		gtk_source_buffer_redo (_tmp6_);
	}
	_g_object_unref0 (buffer);
}

/**
 * toggle_tag:
 *
 * Toggle appropriate tag on the selected text.
 */
static gboolean
_gtk_text_iter_equal (const GtkTextIter * s1,
                      const GtkTextIter * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return FALSE;
}

void
xnp_hypertext_view_toggle_tag (XnpHypertextView* self,
                               const gchar* tag_name)
{
	GtkTextTag* tag = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextTagTable* _tmp2_;
	GtkTextTag* _tmp3_;
	GtkTextTag* _tmp4_;
	GtkTextTag* _tmp5_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	GtkTextBuffer* _tmp10_;
	GtkTextBuffer* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GtkTextTag* _tmp16_;
	GtkTextBuffer* _tmp27_;
	GtkTextBuffer* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag_name != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_text_buffer_get_tag_table (_tmp1_);
	_tmp3_ = gtk_text_tag_table_lookup (_tmp2_, tag_name);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	tag = _tmp4_;
	_tmp5_ = tag;
	if (_tmp5_ == NULL) {
		g_warning ("hypertextview.vala:302: Tag not found: %s", tag_name);
		_g_object_unref0 (tag);
		return;
	}
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp7_ = _tmp6_;
	gtk_text_buffer_get_selection_bounds (_tmp7_, &_tmp8_, &_tmp9_);
	start = _tmp8_;
	end = _tmp9_;
	_tmp10_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = gtk_text_buffer_get_has_selection (_tmp11_);
	_tmp13_ = _tmp12_;
	if (!_tmp13_) {
		GtkTextIter _tmp14_;
		GtkTextIter _tmp15_;
		gtk_text_iter_set_line_offset (&start, 0);
		if (!gtk_text_iter_ends_line (&end)) {
			gtk_text_iter_forward_to_line_end (&end);
		}
		_tmp14_ = start;
		_tmp15_ = end;
		if (_gtk_text_iter_equal (&_tmp14_, &_tmp15_) == TRUE) {
			_g_object_unref0 (tag);
			return;
		}
	}
	_tmp16_ = tag;
	if (gtk_text_iter_has_tag (&start, _tmp16_)) {
		GtkTextBuffer* _tmp17_;
		GtkTextBuffer* _tmp18_;
		GtkTextTag* _tmp19_;
		GtkTextIter _tmp20_;
		GtkTextIter _tmp21_;
		_tmp17_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = tag;
		_tmp20_ = start;
		_tmp21_ = end;
		gtk_text_buffer_remove_tag (_tmp18_, _tmp19_, &_tmp20_, &_tmp21_);
	} else {
		GtkTextBuffer* _tmp22_;
		GtkTextBuffer* _tmp23_;
		GtkTextTag* _tmp24_;
		GtkTextIter _tmp25_;
		GtkTextIter _tmp26_;
		_tmp22_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp23_ = _tmp22_;
		_tmp24_ = tag;
		_tmp25_ = start;
		_tmp26_ = end;
		gtk_text_buffer_apply_tag (_tmp23_, _tmp24_, &_tmp25_, &_tmp26_);
	}
	_tmp27_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp28_ = _tmp27_;
	g_signal_emit_by_name (_tmp28_, "changed");
	_g_object_unref0 (tag);
}

/**
 * get_text_with_tags:
 *
 * Get text from buffer with tags embedded.
 */
static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		XnpHypertextView* self;
		self = _data5_->self;
		_g_free0 (_data5_->tags_text);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda14_ (Block5Data* _data5_,
              GtkTextTag* tag)
{
	XnpHypertextView* self;
	gboolean _tmp0_ = FALSE;
	GtkTextTag* _tmp1_;
	self = _data5_->self;
	g_return_if_fail (tag != NULL);
	_tmp1_ = self->priv->tag_link;
	if (tag != _tmp1_) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		g_object_get (tag, "name", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp5_ = _data5_->tags_text;
		g_object_get (tag, "name", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("</%s>", _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp5_, _tmp10_, NULL);
		_g_free0 (_data5_->tags_text);
		_data5_->tags_text = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
	}
}

static void
____lambda14__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda14_ (self, (GtkTextTag*) data);
}

static void
___lambda15_ (Block5Data* _data5_,
              GtkTextTag* tag)
{
	XnpHypertextView* self;
	gboolean _tmp0_ = FALSE;
	GtkTextTag* _tmp1_;
	self = _data5_->self;
	g_return_if_fail (tag != NULL);
	_tmp1_ = self->priv->tag_link;
	if (tag != _tmp1_) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		g_object_get (tag, "name", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp5_ = _data5_->tags_text;
		g_object_get (tag, "name", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("<%s>", _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp5_, _tmp10_, NULL);
		_g_free0 (_data5_->tags_text);
		_data5_->tags_text = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
	}
}

static void
____lambda15__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda15_ (self, (GtkTextTag*) data);
}

gchar*
xnp_hypertext_view_get_text_with_tags (XnpHypertextView* self)
{
	Block5Data* _data5_;
	GSList* cb_list_iter = NULL;
	GSList* _tmp0_;
	GtkTextIter cb_text_iter = {0};
	GSList* _tmp1_;
	GtkTextIter start = {0};
	GtkTextIter prev = {0};
	gchar* text = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextIter _tmp14_ = {0};
	GtkTextIter _tmp15_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = self->priv->checkboxes;
	cb_list_iter = _tmp0_;
	_tmp1_ = cb_list_iter;
	if (_tmp1_ != NULL) {
		GtkTextBuffer* _tmp2_;
		GtkTextBuffer* _tmp3_;
		GSList* _tmp4_;
		gconstpointer _tmp5_;
		GtkTextIter _tmp6_ = {0};
		_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = cb_list_iter;
		_tmp5_ = _tmp4_->data;
		gtk_text_buffer_get_iter_at_child_anchor (_tmp3_, &_tmp6_, (GtkTextChildAnchor*) _tmp5_);
		cb_text_iter = _tmp6_;
	} else {
		GtkTextBuffer* _tmp7_;
		GtkTextBuffer* _tmp8_;
		GtkTextIter _tmp9_ = {0};
		_tmp7_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp8_ = _tmp7_;
		gtk_text_buffer_get_end_iter (_tmp8_, &_tmp9_);
		cb_text_iter = _tmp9_;
	}
	_tmp10_ = g_strdup ("");
	text = _tmp10_;
	_tmp11_ = g_strdup ("");
	_data5_->tags_text = _tmp11_;
	_tmp12_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp13_ = _tmp12_;
	gtk_text_buffer_get_start_iter (_tmp13_, &_tmp14_);
	start = _tmp14_;
	_tmp15_ = start;
	prev = _tmp15_;
	while (TRUE) {
		GSList* tags = NULL;
		GSList* _tmp16_;
		GSList* _tmp17_;
		GSList* _tmp18_;
		GSList* _tmp19_;
		gboolean _tmp20_ = FALSE;
		GtkTextIter _tmp21_;
		const gchar* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		GtkTextIter _tmp58_;
		GtkTextIter _tmp59_;
		const gchar* _tmp61_;
		GtkTextBuffer* _tmp62_;
		GtkTextBuffer* _tmp63_;
		GtkTextIter _tmp64_;
		GtkTextIter _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		_tmp16_ = gtk_text_iter_get_toggled_tags (&start, FALSE);
		tags = _tmp16_;
		_tmp17_ = tags;
		g_slist_foreach (_tmp17_, ____lambda14__gfunc, _data5_);
		_tmp18_ = gtk_text_iter_get_toggled_tags (&start, TRUE);
		(tags == NULL) ? NULL : (tags = (g_slist_free (tags), NULL));
		tags = _tmp18_;
		_tmp19_ = tags;
		g_slist_foreach (_tmp19_, ____lambda15__gfunc, _data5_);
		_tmp21_ = cb_text_iter;
		if (gtk_text_iter_equal (&start, &_tmp21_)) {
			_tmp20_ = !gtk_text_iter_is_end (&start);
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			GtkCheckButton* checkbox = NULL;
			GSList* _tmp22_;
			gconstpointer _tmp23_;
			GList* _tmp24_;
			GList* _tmp25_;
			gconstpointer _tmp26_;
			GtkWidget* _tmp27_;
			GtkCheckButton* _tmp28_;
			GtkCheckButton* _tmp29_;
			const gchar* _tmp30_ = NULL;
			GtkCheckButton* _tmp31_;
			gboolean _tmp32_;
			gboolean _tmp33_;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			GSList* _tmp36_;
			GSList* _tmp37_;
			GSList* _tmp38_;
			_tmp22_ = cb_list_iter;
			_tmp23_ = _tmp22_->data;
			_tmp24_ = gtk_text_child_anchor_get_widgets ((GtkTextChildAnchor*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = _tmp25_->data;
			_tmp27_ = (GtkWidget*) _tmp26_;
			_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, gtk_check_button_get_type ()) ? ((GtkCheckButton*) _tmp27_) : NULL);
			_tmp29_ = _tmp28_;
			(_tmp25_ == NULL) ? NULL : (_tmp25_ = (g_list_free (_tmp25_), NULL));
			checkbox = _tmp29_;
			_tmp31_ = checkbox;
			_tmp32_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp31_);
			_tmp33_ = _tmp32_;
			if (_tmp33_) {
				_tmp30_ = "☑";
			} else {
				_tmp30_ = "☐";
			}
			_tmp34_ = _data5_->tags_text;
			_tmp35_ = g_strconcat (_tmp34_, _tmp30_, NULL);
			_g_free0 (_data5_->tags_text);
			_data5_->tags_text = _tmp35_;
			_tmp36_ = cb_list_iter;
			_tmp37_ = _tmp36_->next;
			cb_list_iter = _tmp37_;
			_tmp38_ = cb_list_iter;
			if (_tmp38_ != NULL) {
				GtkTextBuffer* _tmp39_;
				GtkTextBuffer* _tmp40_;
				GSList* _tmp41_;
				gconstpointer _tmp42_;
				GtkTextIter _tmp43_ = {0};
				_tmp39_ = gtk_text_view_get_buffer ((GtkTextView*) self);
				_tmp40_ = _tmp39_;
				_tmp41_ = cb_list_iter;
				_tmp42_ = _tmp41_->data;
				gtk_text_buffer_get_iter_at_child_anchor (_tmp40_, &_tmp43_, (GtkTextChildAnchor*) _tmp42_);
				cb_text_iter = _tmp43_;
			} else {
				GtkTextBuffer* _tmp44_;
				GtkTextBuffer* _tmp45_;
				GtkTextIter _tmp46_ = {0};
				_tmp44_ = gtk_text_view_get_buffer ((GtkTextView*) self);
				_tmp45_ = _tmp44_;
				gtk_text_buffer_get_end_iter (_tmp45_, &_tmp46_);
				cb_text_iter = _tmp46_;
			}
			gtk_text_iter_forward_char (&start);
			_g_object_unref0 (checkbox);
			(tags == NULL) ? NULL : (tags = (g_slist_free (tags), NULL));
			continue;
		}
		_tmp47_ = _data5_->tags_text;
		_tmp48_ = strlen (_tmp47_);
		_tmp49_ = _tmp48_;
		if (_tmp49_ > 0) {
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			const gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			_tmp50_ = text;
			_tmp51_ = xnp_hypertext_view_tag_char;
			_tmp52_ = _data5_->tags_text;
			_tmp53_ = xnp_hypertext_view_tag_char;
			_tmp54_ = g_strdup_printf ("%s%s%s", _tmp51_, _tmp52_, _tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = g_strconcat (_tmp50_, _tmp55_, NULL);
			_g_free0 (text);
			text = _tmp56_;
			_g_free0 (_tmp55_);
			_tmp57_ = g_strdup ("");
			_g_free0 (_data5_->tags_text);
			_data5_->tags_text = _tmp57_;
		}
		if (gtk_text_iter_is_end (&start)) {
			(tags == NULL) ? NULL : (tags = (g_slist_free (tags), NULL));
			break;
		}
		_tmp58_ = start;
		prev = _tmp58_;
		gtk_text_iter_forward_to_tag_toggle (&start, NULL);
		_tmp59_ = cb_text_iter;
		if (gtk_text_iter_compare (&start, &_tmp59_) >= 0) {
			GtkTextIter _tmp60_;
			_tmp60_ = cb_text_iter;
			start = _tmp60_;
		}
		_tmp61_ = text;
		_tmp62_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp63_ = _tmp62_;
		_tmp64_ = prev;
		_tmp65_ = start;
		_tmp66_ = gtk_text_buffer_get_text (_tmp63_, &_tmp64_, &_tmp65_, TRUE);
		_tmp67_ = _tmp66_;
		_tmp68_ = g_strconcat (_tmp61_, _tmp67_, NULL);
		_g_free0 (text);
		text = _tmp68_;
		_g_free0 (_tmp67_);
		(tags == NULL) ? NULL : (tags = (g_slist_free (tags), NULL));
	}
	result = text;
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

/**
 * set_text_with_tags:
 *
 * Load text to buffer and apply tags.
 */
static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		XnpHypertextView* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
______lambda16_ (Block6Data* _data6_,
                 const gchar* tag)
{
	XnpHypertextView* self;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_;
	GtkTextIter _tmp3_;
	self = _data6_->self;
	g_return_if_fail (tag != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _data6_->start;
	_tmp3_ = _data6_->end;
	gtk_text_buffer_apply_tag_by_name (_tmp1_, tag, &_tmp2_, &_tmp3_);
}

static void
_______lambda16__gfunc (gconstpointer data,
                        gpointer self)
{
	______lambda16_ (self, (const gchar*) data);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
__________lambda17_ (Block6Data* _data6_,
                     const gchar* tag)
{
	XnpHypertextView* self;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_;
	GtkTextIter _tmp3_;
	self = _data6_->self;
	g_return_if_fail (tag != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _data6_->start;
	_tmp3_ = _data6_->end;
	gtk_text_buffer_apply_tag_by_name (_tmp1_, tag, &_tmp2_, &_tmp3_);
}

static void
___________lambda17__gfunc (gconstpointer data,
                            gpointer self)
{
	__________lambda17_ (self, (const gchar*) data);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

void
xnp_hypertext_view_set_text_with_tags (XnpHypertextView* self,
                                       const gchar* text)
{
	Block6Data* _data6_;
	GList* tags = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_ = {0};
	gchar** tokens = NULL;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint tokens_length1;
	gint _tokens_size_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	tags = NULL;
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_object_set (_tmp1_, "text", "", NULL);
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp3_ = _tmp2_;
	gtk_text_buffer_get_bounds (_tmp3_, &_tmp4_, &_tmp5_);
	_data6_->start = _tmp4_;
	_data6_->end = _tmp5_;
	_tmp6_ = xnp_hypertext_view_tag_char;
	_tmp8_ = _tmp7_ = g_strsplit (text, _tmp6_, 0);
	tokens = _tmp8_;
	tokens_length1 = _vala_array_length (_tmp7_);
	_tokens_size_ = tokens_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = tokens;
				_tmp11__length1 = tokens_length1;
				_tmp12_ = _tmp11_[i];
				if (!(_tmp12_ != NULL)) {
					break;
				}
				if ((i % 2) == 0) {
					gint offset = 0;
					GtkTextBuffer* _tmp13_;
					GtkTextBuffer* _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					GtkTextBuffer* _tmp17_;
					GtkTextBuffer* _tmp18_;
					GtkTextIter _tmp19_ = {0};
					GList* _tmp20_;
					offset = gtk_text_iter_get_offset (&_data6_->end);
					_tmp13_ = gtk_text_view_get_buffer ((GtkTextView*) self);
					_tmp14_ = _tmp13_;
					_tmp15_ = tokens;
					_tmp15__length1 = tokens_length1;
					_tmp16_ = _tmp15_[i];
					gtk_text_buffer_insert (_tmp14_, &_data6_->end, _tmp16_, -1);
					_tmp17_ = gtk_text_view_get_buffer ((GtkTextView*) self);
					_tmp18_ = _tmp17_;
					gtk_text_buffer_get_iter_at_offset (_tmp18_, &_tmp19_, offset);
					_data6_->start = _tmp19_;
					_tmp20_ = tags;
					g_list_foreach (_tmp20_, _______lambda16__gfunc, _data6_);
				} else {
					gchar** tags_tokens = NULL;
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					gint _tmp23_ = 0;
					gchar** _tmp24_;
					gint tags_tokens_length1;
					gint _tags_tokens_size_;
					gchar** _tmp25_;
					gint _tmp25__length1;
					_tmp21_ = tokens;
					_tmp21__length1 = tokens_length1;
					_tmp22_ = _tmp21_[i];
					_tmp24_ = xnp_hypertext_view_split_tags (self, _tmp22_, &_tmp23_);
					tags_tokens = _tmp24_;
					tags_tokens_length1 = _tmp23_;
					_tags_tokens_size_ = tags_tokens_length1;
					_tmp25_ = tags_tokens;
					_tmp25__length1 = tags_tokens_length1;
					{
						gchar** tag_collection = NULL;
						gint tag_collection_length1 = 0;
						gint _tag_collection_size_ = 0;
						gint tag_it = 0;
						tag_collection = _tmp25_;
						tag_collection_length1 = _tmp25__length1;
						for (tag_it = 0; tag_it < tag_collection_length1; tag_it = tag_it + 1) {
							gchar* _tmp26_;
							gchar* tag = NULL;
							_tmp26_ = g_strdup (tag_collection[tag_it]);
							tag = _tmp26_;
							{
								const gchar* _tmp27_;
								_tmp27_ = tag;
								if (string_get (_tmp27_, (glong) 0) != '<') {
									gboolean _tmp28_ = FALSE;
									const gchar* _tmp29_;
									_tmp29_ = tag;
									if (g_strcmp0 (_tmp29_, "☐") == 0) {
										_tmp28_ = TRUE;
									} else {
										const gchar* _tmp30_;
										_tmp30_ = tag;
										_tmp28_ = g_strcmp0 (_tmp30_, "☑") == 0;
									}
									if (_tmp28_) {
										const gchar* _tmp31_;
										GtkTextIter _tmp32_;
										GList* _tmp33_;
										_tmp31_ = tag;
										xnp_hypertext_view_insert_checkbox_at_iter (self, &_data6_->end, g_strcmp0 (_tmp31_, "☑") == 0);
										_tmp32_ = _data6_->end;
										_data6_->start = _tmp32_;
										gtk_text_iter_backward_char (&_data6_->start);
										_tmp33_ = tags;
										g_list_foreach (_tmp33_, ___________lambda17__gfunc, _data6_);
									}
								} else {
									const gchar* _tmp34_;
									_tmp34_ = tag;
									if (string_get (_tmp34_, (glong) 1) != '/') {
										const gchar* _tmp35_;
										gchar* _tmp36_;
										_tmp35_ = tag;
										_tmp36_ = string_slice (_tmp35_, (glong) 1, (glong) -1);
										tags = g_list_prepend (tags, _tmp36_);
									} else {
										GList* element = NULL;
										GList* _tmp37_;
										const gchar* _tmp38_;
										gchar* _tmp39_;
										gchar* _tmp40_;
										GCompareFunc _tmp41_;
										GList* _tmp42_;
										GList* _tmp43_;
										GList* _tmp44_;
										_tmp37_ = tags;
										_tmp38_ = tag;
										_tmp39_ = string_slice (_tmp38_, (glong) 2, (glong) -1);
										_tmp40_ = _tmp39_;
										_tmp41_ = ((GCompareFunc) g_strcmp0);
										_tmp42_ = g_list_find_custom (_tmp37_, _tmp40_, _tmp41_);
										_tmp43_ = _tmp42_;
										_g_free0 (_tmp40_);
										element = _tmp43_;
										_tmp44_ = element;
										if (_tmp44_ != NULL) {
											GList* _tmp45_;
											_tmp45_ = element;
											tags = g_list_delete_link (tags, _tmp45_);
										}
									}
								}
								_g_free0 (tag);
							}
						}
					}
					tags_tokens = (_vala_array_free (tags_tokens, tags_tokens_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	(tags == NULL) ? NULL : (tags = (_g_list_free__g_free0_ (tags), NULL));
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
xnp_hypertext_view_split_tags (XnpHypertextView* self,
                               const gchar* tags,
                               gint* result_length1)
{
	GString* builder = NULL;
	GString* _tmp0_;
	gchar** _result_ = NULL;
	gchar** _tmp1_;
	gint _result__length1;
	gint __result__size_;
	gboolean tag = FALSE;
	gunichar c = 0U;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tags != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp1_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	tag = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gunichar _tmp3_ = 0U;
				gboolean _tmp4_;
				if (!_tmp2_) {
				}
				_tmp2_ = FALSE;
				_tmp4_ = string_get_next_char (tags, &i, &_tmp3_);
				c = _tmp3_;
				if (!_tmp4_) {
					break;
				}
				if (c == ((gunichar) '<')) {
					if (!tag) {
						GString* _tmp5_;
						_tmp5_ = builder;
						if (_tmp5_->len != ((gssize) 0)) {
							GString* _tmp6_;
							const gchar* _tmp7_;
							gchar* _tmp8_;
							GString* _tmp9_;
							_tmp6_ = builder;
							_tmp7_ = _tmp6_->str;
							_tmp8_ = g_strdup (_tmp7_);
							_vala_array_add4 (&_result_, &_result__length1, &__result__size_, _tmp8_);
							_tmp9_ = g_string_new ("<");
							_g_string_free0 (builder);
							builder = _tmp9_;
						} else {
							GString* _tmp10_;
							_tmp10_ = builder;
							g_string_append_c (_tmp10_, '<');
						}
						tag = TRUE;
					}
				} else {
					if (c == ((gunichar) '>')) {
						if (tag) {
							GString* _tmp11_;
							GString* _tmp12_;
							const gchar* _tmp13_;
							gchar* _tmp14_;
							GString* _tmp15_;
							tag = FALSE;
							_tmp11_ = builder;
							g_string_append_c (_tmp11_, '>');
							_tmp12_ = builder;
							_tmp13_ = _tmp12_->str;
							_tmp14_ = g_strdup (_tmp13_);
							_vala_array_add5 (&_result_, &_result__length1, &__result__size_, _tmp14_);
							_tmp15_ = g_string_new ("");
							_g_string_free0 (builder);
							builder = _tmp15_;
						}
					} else {
						if (tag) {
							GString* _tmp16_;
							_tmp16_ = builder;
							g_string_append_unichar (_tmp16_, c);
						} else {
							gboolean _tmp17_ = FALSE;
							if (c == ((gunichar) 0x2610)) {
								_tmp17_ = TRUE;
							} else {
								_tmp17_ = c == ((gunichar) 0x2611);
							}
							if (_tmp17_) {
								GString* _tmp18_;
								gchar* _tmp23_;
								_tmp18_ = builder;
								if (_tmp18_->len != ((gssize) 0)) {
									GString* _tmp19_;
									const gchar* _tmp20_;
									gchar* _tmp21_;
									GString* _tmp22_;
									_tmp19_ = builder;
									_tmp20_ = _tmp19_->str;
									_tmp21_ = g_strdup (_tmp20_);
									_vala_array_add6 (&_result_, &_result__length1, &__result__size_, _tmp21_);
									_tmp22_ = g_string_new ("");
									_g_string_free0 (builder);
									builder = _tmp22_;
								}
								_tmp23_ = g_unichar_to_string (c);
								_vala_array_add7 (&_result_, &_result__length1, &__result__size_, _tmp23_);
							} else {
							}
						}
					}
				}
			}
		}
	}
	_tmp24_ = _result_;
	_tmp24__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp24__length1;
	}
	result = _tmp24_;
	_g_string_free0 (builder);
	return result;
}

/**
 * update_tags:
 *
 * Goes through the entire document to search for untagged links and tag them.
 */
void
xnp_hypertext_view_update_tags (XnpHypertextView* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_;
	GtkTextIter _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_start_iter (_tmp1_, &_tmp2_);
	start = _tmp2_;
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp4_ = _tmp3_;
	gtk_text_buffer_get_end_iter (_tmp4_, &_tmp5_);
	end = _tmp5_;
	_tmp6_ = start;
	_tmp7_ = end;
	xnp_hypertext_view_auto_highlight_urls (self, &_tmp6_, &_tmp7_);
}

static void
xnp_hypertext_view_auto_highlight_urls (XnpHypertextView* self,
                                        GtkTextIter* start,
                                        GtkTextIter* end)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextTag* _tmp2_;
	GtkTextIter _tmp3_;
	GtkTextIter _tmp4_;
	gchar* str = NULL;
	GtkTextIter _tmp5_;
	gchar* _tmp6_;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp7_;
	const gchar* _tmp8_;
	GMatchInfo* _tmp9_ = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	xnp_hypertext_view_extend_block (self, start, end, 256);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->tag_link;
	_tmp3_ = *start;
	_tmp4_ = *end;
	gtk_text_buffer_remove_tag (_tmp1_, _tmp2_, &_tmp3_, &_tmp4_);
	_tmp5_ = *end;
	_tmp6_ = gtk_text_iter_get_slice (start, &_tmp5_);
	str = _tmp6_;
	_tmp7_ = self->priv->regex_link;
	_tmp8_ = str;
	g_regex_match (_tmp7_, _tmp8_, 0, &_tmp9_);
	_g_match_info_unref0 (match_info);
	match_info = _tmp9_;
	{
		while (TRUE) {
			GMatchInfo* _tmp10_;
			gint start_pos = 0;
			gint end_pos = 0;
			GMatchInfo* _tmp11_;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			GtkTextIter xstart = {0};
			GtkTextIter _tmp14_;
			const gchar* _tmp15_;
			GtkTextIter xend = {0};
			GtkTextIter _tmp16_;
			const gchar* _tmp17_;
			GtkTextBuffer* _tmp18_;
			GtkTextBuffer* _tmp19_;
			GtkTextTag* _tmp20_;
			GtkTextIter _tmp21_;
			GtkTextIter _tmp22_;
			GMatchInfo* _tmp23_;
			_tmp10_ = match_info;
			if (!g_match_info_matches (_tmp10_)) {
				break;
			}
			_tmp11_ = match_info;
			g_match_info_fetch_pos (_tmp11_, 0, &_tmp12_, &_tmp13_);
			start_pos = _tmp12_;
			end_pos = _tmp13_;
			_tmp14_ = *start;
			xstart = _tmp14_;
			_tmp15_ = str;
			gtk_text_iter_forward_chars (&xstart, g_utf8_strlen (_tmp15_, (gssize) start_pos));
			_tmp16_ = *start;
			xend = _tmp16_;
			_tmp17_ = str;
			gtk_text_iter_forward_chars (&xend, g_utf8_strlen (_tmp17_, (gssize) end_pos));
			_tmp18_ = gtk_text_view_get_buffer ((GtkTextView*) self);
			_tmp19_ = _tmp18_;
			_tmp20_ = self->priv->tag_link;
			_tmp21_ = xstart;
			_tmp22_ = xend;
			gtk_text_buffer_apply_tag (_tmp19_, _tmp20_, &_tmp21_, &_tmp22_);
			_tmp23_ = match_info;
			g_match_info_next (_tmp23_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				_g_match_info_unref0 (match_info);
				_g_free0 (str);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		g_warning ("hypertextview.vala:533: %s", _tmp25_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_match_info_unref0 (match_info);
		_g_free0 (str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_match_info_unref0 (match_info);
	_g_free0 (str);
}

static void
xnp_hypertext_view_extend_block (XnpHypertextView* self,
                                 GtkTextIter* start_iter,
                                 GtkTextIter* end_iter,
                                 gint max_len)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_iter != NULL);
	g_return_if_fail (end_iter != NULL);
	if ((gtk_text_iter_get_line_offset (start_iter) - max_len) > 0) {
		GtkTextTag* _tmp0_;
		gtk_text_iter_backward_chars (start_iter, max_len);
		_tmp0_ = self->priv->tag_link;
		if (gtk_text_iter_has_tag (start_iter, _tmp0_)) {
			GtkTextTag* _tmp1_;
			_tmp1_ = self->priv->tag_link;
			gtk_text_iter_backward_to_tag_toggle (start_iter, _tmp1_);
		}
	} else {
		gtk_text_iter_set_line_offset (start_iter, 0);
	}
	if (!gtk_text_iter_ends_line (end_iter)) {
		if ((gtk_text_iter_get_line_offset (end_iter) + max_len) < gtk_text_iter_get_chars_in_line (end_iter)) {
			GtkTextTag* _tmp2_;
			gtk_text_iter_forward_chars (end_iter, max_len);
			_tmp2_ = self->priv->tag_link;
			if (gtk_text_iter_has_tag (end_iter, _tmp2_)) {
				GtkTextTag* _tmp3_;
				_tmp3_ = self->priv->tag_link;
				gtk_text_iter_forward_to_tag_toggle (end_iter, _tmp3_);
			}
		} else {
			gtk_text_iter_forward_to_line_end (end_iter);
		}
	}
}

/**
 * insert_checkbox:
 *
 * Insert a checkbox in the text of the note. Can be useful
 * for writing a TODO list.
 *
 * This doesn't work well with the GtkSourceView Undo/Redo
 * manager, so we reset it to avoid breaking.
 */
void
xnp_hypertext_view_insert_checkbox (XnpHypertextView* self,
                                    gboolean checked)
{
	GtkTextIter iter = {0};
	GtkSourceBuffer* buffer = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_source_buffer_get_type ()) ? ((GtkSourceBuffer*) _tmp1_) : NULL);
	buffer = _tmp2_;
	gtk_source_buffer_begin_not_undoable_action (buffer);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) buffer, &_tmp3_, NULL);
	iter = _tmp3_;
	xnp_hypertext_view_insert_checkbox_at_iter (self, &iter, checked);
	gtk_source_buffer_end_not_undoable_action (buffer);
	_g_object_unref0 (buffer);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		XnpHypertextView* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->anchor);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gboolean
__lambda8_ (XnpHypertextView* self)
{
	gboolean result;
	self->priv->cursor_over_checkbox = TRUE;
	result = FALSE;
	return result;
}

static gboolean
___lambda8__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                           GdkEventCrossing* event,
                                           gpointer self)
{
	gboolean result;
	result = __lambda8_ ((XnpHypertextView*) self);
	return result;
}

static gboolean
__lambda9_ (XnpHypertextView* self)
{
	gboolean result;
	self->priv->cursor_over_checkbox = FALSE;
	result = FALSE;
	return result;
}

static gboolean
___lambda9__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                           GdkEventCrossing* event,
                                           gpointer self)
{
	gboolean result;
	result = __lambda9_ ((XnpHypertextView*) self);
	return result;
}

static void
__lambda10_ (XnpHypertextView* self)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name (_tmp1_, "changed");
}

static void
___lambda10__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda10_ ((XnpHypertextView*) self);
}

static GSList*
vala_g_slist_remove_full (GSList* self,
                          gconstpointer data,
                          GFreeFunc func)
{
	GSList* l = NULL;
	GSList* result;
	l = self;
	while (TRUE) {
		GSList* _tmp0_;
		GSList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GSList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GSList* _tmp3_;
			GSList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GSList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GSList* _tmp5_;
			gconstpointer _tmp6_;
			GSList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GSList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_slist_delete_link (self, (GSList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
__lambda11_ (Block7Data* _data7_)
{
	XnpHypertextView* self;
	GtkSourceBuffer* buffer = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	self = _data7_->self;
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_source_buffer_get_type ()) ? ((GtkSourceBuffer*) _tmp1_) : NULL);
	buffer = _tmp2_;
	gtk_source_buffer_begin_not_undoable_action (buffer);
	gtk_source_buffer_end_not_undoable_action (buffer);
	self->priv->checkboxes = vala_g_slist_remove_full (self->priv->checkboxes, _data7_->anchor, _g_object_unref0_);
	_g_object_unref0 (_data7_->anchor);
	_data7_->anchor = NULL;
	_g_object_unref0 (buffer);
}

static void
___lambda11__gtk_widget_destroy (GtkWidget* _sender,
                                 gpointer self)
{
	__lambda11_ (self);
}

static gint
__lambda12_ (XnpHypertextView* self,
             GtkTextChildAnchor* a,
             GtkTextChildAnchor* b)
{
	GtkTextIter a_iter = {0};
	GtkTextIter b_iter = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_iter_at_child_anchor (_tmp1_, &_tmp2_, a);
	a_iter = _tmp2_;
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp4_ = _tmp3_;
	gtk_text_buffer_get_iter_at_child_anchor (_tmp4_, &_tmp5_, b);
	b_iter = _tmp5_;
	_tmp6_ = b_iter;
	result = gtk_text_iter_compare (&a_iter, &_tmp6_);
	return result;
}

static gint
___lambda12__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda12_ ((XnpHypertextView*) self, (GtkTextChildAnchor*) a, (GtkTextChildAnchor*) b);
	return result;
}

static void
xnp_hypertext_view_insert_checkbox_at_iter (XnpHypertextView* self,
                                            GtkTextIter* iter,
                                            gboolean checked)
{
	Block7Data* _data7_;
	GtkTextMark* mark = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_;
	GtkTextMark* _tmp3_;
	GtkTextMark* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextIter _tmp7_;
	GtkTextChildAnchor* _tmp8_;
	GtkTextChildAnchor* _tmp9_;
	GtkCheckButton* checkbox = NULL;
	GtkCheckButton* _tmp10_;
	GtkTextChildAnchor* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextIter _tmp14_ = {0};
	GtkTextBuffer* _tmp15_;
	GtkTextBuffer* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = *iter;
	_tmp3_ = gtk_text_buffer_create_mark (_tmp1_, NULL, &_tmp2_, FALSE);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	mark = _tmp4_;
	_tmp5_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = *iter;
	_tmp8_ = gtk_text_buffer_create_child_anchor (_tmp6_, &_tmp7_);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_data7_->anchor = _tmp9_;
	_tmp10_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp10_);
	checkbox = _tmp10_;
	gtk_text_view_add_child_at_anchor ((GtkTextView*) self, (GtkWidget*) checkbox, _data7_->anchor);
	gtk_toggle_button_set_active ((GtkToggleButton*) checkbox, checked);
	gtk_widget_show ((GtkWidget*) checkbox);
	gtk_widget_set_focus_on_click ((GtkWidget*) checkbox, FALSE);
	g_signal_connect_object ((GtkWidget*) checkbox, "enter-notify-event", (GCallback) ___lambda8__gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) checkbox, "leave-notify-event", (GCallback) ___lambda9__gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object ((GtkToggleButton*) checkbox, "toggled", (GCallback) ___lambda10__gtk_toggle_button_toggled, self, 0);
	g_signal_connect_data ((GtkWidget*) checkbox, "destroy", (GCallback) ___lambda11__gtk_widget_destroy, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp11_ = _g_object_ref0 (_data7_->anchor);
	self->priv->checkboxes = g_slist_insert_sorted_with_data (self->priv->checkboxes, _tmp11_, ___lambda12__gcompare_data_func, self);
	_tmp12_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp13_ = _tmp12_;
	gtk_text_buffer_get_iter_at_mark (_tmp13_, &_tmp14_, mark);
	*iter = _tmp14_;
	_tmp15_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp16_ = _tmp15_;
	gtk_text_buffer_delete_mark (_tmp16_, mark);
	_g_object_unref0 (checkbox);
	_g_object_unref0 (mark);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

const gchar*
xnp_hypertext_view_get_font (XnpHypertextView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_font;
	result = _tmp0_;
	return result;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

void
xnp_hypertext_view_set_font (XnpHypertextView* self,
                             const gchar* value)
{
	gchar* _tmp0_;
	PangoFontDescription* font_descr = NULL;
	PangoFontDescription* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_font);
	self->priv->_font = _tmp0_;
	_tmp1_ = pango_font_description_from_string (value);
	font_descr = _tmp1_;
	gtk_widget_override_font ((GtkWidget*) self, font_descr);
	__vala_PangoFontDescription_free0 (font_descr);
	g_object_notify_by_pspec ((GObject *) self, xnp_hypertext_view_properties[XNP_HYPERTEXT_VIEW_FONT_PROPERTY]);
}

static void
_vala_PangoTabArray_free (PangoTabArray* self)
{
	g_boxed_free (pango_tab_array_get_type (), self);
}

static GObject *
xnp_hypertext_view_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	XnpHypertextView * self;
	PangoTabArray* _tmp0_;
	PangoTabArray* _tmp1_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (xnp_hypertext_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView);
	xnp_hypertext_view_set_font (self, "Sans 13");
	_tmp0_ = pango_tab_array_new_with_positions (1, TRUE, PANGO_TAB_LEFT, 12, NULL);
	_tmp1_ = _tmp0_;
	gtk_text_view_set_tabs ((GtkTextView*) self, _tmp1_);
	__vala_PangoTabArray_free0 (_tmp1_);
	{
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		_tmp3_ = g_regex_new ("((\\b((news|http|https|ftp|file|irc)://|mailto:|(www|ftp)\\." "|\\S*@\\S*\\.)|(?<=^|\\s)/\\S+/|(?<=^|\\s)~/\\S+)\\S*\\b/?)", G_REGEX_CASELESS | G_REGEX_OPTIMIZE, 0, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_regex_unref0 (self->priv->regex_link);
		self->priv->regex_link = _tmp4_;
		_g_regex_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_critical ("hypertextview.vala:68: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
xnp_hypertext_view_class_init (XnpHypertextViewClass * klass,
                               gpointer klass_data)
{
	gchar* _tmp0_;
	xnp_hypertext_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XnpHypertextView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_xnp_hypertext_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_xnp_hypertext_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = xnp_hypertext_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = xnp_hypertext_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_HYPERTEXT_VIEW_FONT_PROPERTY, xnp_hypertext_view_properties[XNP_HYPERTEXT_VIEW_FONT_PROPERTY] = g_param_spec_string ("font", "font", "font", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_unichar_to_string ((gunichar) 0x200b);
	xnp_hypertext_view_tag_char = _tmp0_;
}

static void
xnp_hypertext_view_instance_init (XnpHypertextView * self,
                                  gpointer klass)
{
	GdkDisplay* _tmp0_;
	GdkCursor* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkCursor* _tmp3_;
	self->priv = xnp_hypertext_view_get_instance_private (self);
	self->priv->checkboxes = NULL;
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_cursor_new_for_display (_tmp0_, GDK_HAND2);
	self->priv->hand_cursor = _tmp1_;
	_tmp2_ = gdk_display_get_default ();
	_tmp3_ = gdk_cursor_new_for_display (_tmp2_, GDK_XTERM);
	self->priv->regular_cursor = _tmp3_;
	self->priv->cursor_over_checkbox = FALSE;
	self->priv->cursor_over_link = FALSE;
}

static void
xnp_hypertext_view_finalize (GObject * obj)
{
	XnpHypertextView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView);
	(self->priv->checkboxes == NULL) ? NULL : (self->priv->checkboxes = (_g_slist_free__g_object_unref0_ (self->priv->checkboxes), NULL));
	_g_object_unref0 (self->priv->hand_cursor);
	_g_object_unref0 (self->priv->regular_cursor);
	_g_object_unref0 (self->priv->tag_bold);
	_g_object_unref0 (self->priv->tag_italic);
	_g_object_unref0 (self->priv->tag_strikethrough);
	_g_object_unref0 (self->priv->tag_underline);
	_g_object_unref0 (self->priv->tag_link);
	_g_regex_unref0 (self->priv->regex_link);
	_g_free0 (self->priv->_font);
	G_OBJECT_CLASS (xnp_hypertext_view_parent_class)->finalize (obj);
}

static GType
xnp_hypertext_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XnpHypertextViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_hypertext_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpHypertextView), 0, (GInstanceInitFunc) xnp_hypertext_view_instance_init, NULL };
	GType xnp_hypertext_view_type_id;
	xnp_hypertext_view_type_id = g_type_register_static (gtk_source_view_get_type (), "XnpHypertextView", &g_define_type_info, 0);
	XnpHypertextView_private_offset = g_type_add_instance_private (xnp_hypertext_view_type_id, sizeof (XnpHypertextViewPrivate));
	return xnp_hypertext_view_type_id;
}

GType
xnp_hypertext_view_get_type (void)
{
	static volatile gsize xnp_hypertext_view_type_id__once = 0;
	if (g_once_init_enter (&xnp_hypertext_view_type_id__once)) {
		GType xnp_hypertext_view_type_id;
		xnp_hypertext_view_type_id = xnp_hypertext_view_get_type_once ();
		g_once_init_leave (&xnp_hypertext_view_type_id__once, xnp_hypertext_view_type_id);
	}
	return xnp_hypertext_view_type_id__once;
}

static void
_vala_xnp_hypertext_view_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	XnpHypertextView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView);
	switch (property_id) {
		case XNP_HYPERTEXT_VIEW_FONT_PROPERTY:
		g_value_set_string (value, xnp_hypertext_view_get_font (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_xnp_hypertext_view_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	XnpHypertextView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView);
	switch (property_id) {
		case XNP_HYPERTEXT_VIEW_FONT_PROPERTY:
		xnp_hypertext_view_set_font (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

