// -*- c++ -*-

/*
 *  Author: Arvin Schnell
 */


#ifndef Sample_h
#define Sample_h


#include <stdio.h>

#include "pcm.h"


class Sample
{

public:

    Sample ();

    enum { SOUNDCARD, DISKFILE } source;

    int rate;
    unsigned int length;	// number of samples
    int resolution;
    const char* device;

    const char* filename;

    int32_t* buffer;
    int32_t dc[2];

    int frame_count;
    double frames_per_second;

    bool open ();
    bool shot ();
    bool close ();

    bool isopen () const { return pcm; }

private:

    void calc_dc ();

    void expand ();

    PCM* pcm;
    PCM* file;

};


extern Sample sample;


#endif
