The volk_modtool tool is installed along with VOLK as a way of helping
to construct, add to, and interogate the VOLK library or companion
libraries.

volk_modtool is installed into $prefix/bin.

VOLK modtool enables creating standalone (out-of-tree) VOLK modules
and provides a few tools for sharing VOLK kernels between VOLK
modules.  If you need to design or work with VOLK kernels away from
the canonical VOLK library, this is the tool.  If you need to tailor
your own VOLK library for whatever reason, this is the tool.

The canonical VOLK library installs a volk.h and a libvolk.so.  Your
own library will install volk_$name.h and libvolk_$name.so.  Ya Gronk?
Good.

There isn't a substantial difference between the canonical VOLK
module and any other VOLK module.  They're all peers.  Any module
created via VOLK modtool will come complete with a default
volk_modtool.cfg file associating the module with the base from which
it came, its distinctive $name and its destination (or path).  These
values (created from user input if VOLK modtool runs without a
user-supplied config file or a default config file) serve as default
values for some VOLK modtool actions.  It's more or less intended for
the user to change directories to the top level of a created VOLK
module and then run volk_modtool to take advantage of the values
stored in the default volk_modtool.cfg file.

Apart from creating new VOLK modules, VOLK modtool allows you to list
the names of kernels in other modules, list the names of kernels in
the current module, add kernels from another module into the current
module, and remove kernels from the current module.  When moving
kernels between modules, VOLK modtool does its best to keep the qa
and profiling code for those kernels intact.  If the base has a test
or a profiling call for some kernel, those calls will follow the
kernel when VOLK modtool adds that kernel.  If QA or profiling
requires a puppet kernel, the puppet kernel will follow the original
kernel when VOLK modtool adds that original kernel.  VOLK modtool
respects puppets.

======================================================================

Installing a new VOLK Library:

Run the command "volk_modtool -i". This will ask you three questions:

  name: // the name to give your VOLK library: volk_<name>
  destination: // directory new source tree is built under -- must exists.
               // It will create <directory>/volk_<name>
  base: // the directory containing the original VOLK source code

The name provided must be alphanumeric (and cannot start with a
number). No special characters including dashes and underscores are
allowed.

This will build a new skeleton directory in the destination provided
with the name volk_<name>. It will contain the necessary structure to
build:

  mkdir build
  cd build
  cmake -DCMAKE_INSTALL_PREFIX=/opt/volk ../
  make
  sudo make install

Right now, the library is empty and contains no kernels. Kernels can
be added from another VOLK library using the '-a' option. If not
specified, the kernel will be extracted from the base VOLK
directory. Using the '-b' allows us to specify another VOLK library to
use for this purpose.

  volk_modtool -a -n 32fc_x2_conjugate_dot_prod_32fc

This will put the code for the new kernel into
<destination>/volk_<name>/kernels/volk_<name>/

Other kernels must be added by hand. See the following webpages for
more information about creating VOLK kernels:
  https://www.gnuradio.org/doc/doxygen/volk_guide.html
  https://wiki.gnuradio.org/index.php/Volk


======================================================================

OPTIONS

Options for Adding and Removing Kernels:
  -a, --add_kernel
       Add kernel from existing VOLK module. Uses the base VOLK module
       unless -b is used. Use -n to specify the kernel name.
       Requires: -n.
       Optional: -b

  -A, --add_all_kernels
       Add all kernels from existing VOLK module. Uses the base VOLK
       module unless -b is used.
       Optional: -b

  -x, --remove_kernel
       Remove kernel from module.
       Required: -n.
       Optional: -b

Options for Listing Kernels:
  -l, --list
       Lists all kernels available in the base VOLK module.

  -k, --kernels
       Lists all kernels in this VOLK module.

  -r, --remote-list
       Lists all kernels in another VOLK module that is specified
       using the -b option.
