#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>

const char CR = 10;
const char LF = 13;
const int U2D = 0;
const int D2U = 1;
const int SUCCESS = 0;
const int FAILED = 1;

struct timeval times[2];
struct stat sbuf;

/* 
 * basename:
 * returns a pointer the the base name of a full path. ex:
 * basename("/usr/local/bin/tcsh") should return a pointer
 * to the tcsh part.
 */
char *basename(char *full_path) {
    int i;

    i = strlen(full_path);

    i--;

    while ( i > 0 ) {
	if (full_path[i] == '/')
	    return full_path+i+1;
	i--;
    }
    return full_path;
}


void dos2unix(FILE *from, FILE *to) {
  int chr;
  while ( (chr = fgetc(from)) && !feof(from) ) {
    if ( chr != LF )
      fputc(chr, to);
  }
}

void unix2dos(FILE *from, FILE *to) {
  int chr;
  while ( (chr = getc(from)) && !feof(from) ) {
    if ( chr == CR )
      putc(LF, to);
    putc(chr, to);
  }   
}

void usage(char *name) {
    printf("usage: %s [-p] [file ...]\n", basename(name));
    exit(1);
}

int main (int argc, char **argv) {

  FILE *inFile;
  FILE *outFile;
  int c;
  int mode;
  int sok;
  int retval = SUCCESS;
  int bflag, ch, fd;
  int preserve = 0;

  /* 
   * strip the leading path to determine our name, this fixes the
   * bug where if called as ./dos2unix it would go to the last else
   */

  if (strcmp((const char *)basename(argv[0]), "unix2dos") == 0)
    mode = U2D;
  else if (strcmp((const char *)basename(argv[0]), "dos2unix") == 0)
    mode = D2U;
  else {
    fprintf(stderr, "oops, you changed my name. defaulting to unix2dos\n");
    mode = U2D;
  }
  bflag = 0;
  while ((ch = getopt(argc, argv, "p")) != -1)
      switch (ch) {
      case 'p':
	  preserve = 1;
	  break;
      default:
	  usage(argv[0]);
	  break;
      }
  argc -= optind;
  argv += optind;
  if (!argc) { /* no parameters, so we go from stdin to stdout */
    if (mode == U2D)
      unix2dos(stdin, stdout);
    else 
      dos2unix(stdin, stdout);
  }
  else { /* process filenames one by one... */
    retval = SUCCESS;
    while (argc) { /* for all files */
      argc--;
      if (preserve) {
	  if ((sok = stat (argv[argc], &sbuf)) == 0) {
	      times[0].tv_sec = sbuf.st_atime;
	      times[0].tv_usec = 0;
	      times[1].tv_sec = sbuf.st_mtime;
	      times[1].tv_usec = 0;
	  }
      }
      inFile = fopen (argv[argc], "r");
      if (inFile == NULL) {
	perror((const char *)argv[argc]);
	retval = FAILED;
	continue;
      }
      outFile = tmpfile();
      if (outFile == NULL) {
	perror(NULL);
	if (inFile != NULL)
	  fclose(inFile);
	retval = FAILED;
	continue;
      }
      if (mode == U2D)
	unix2dos(inFile, outFile);
      else
	dos2unix(inFile, outFile);
      fclose(inFile);
      inFile = fopen(argv[argc], "w");
      if (inFile == NULL) {
	perror((const char *)argv[argc]);
	retval = FAILED;
	continue;
      }
      fseek(outFile, SEEK_SET, 0);
      while ( (c = fgetc(outFile)) && !feof(outFile) ) 
	fputc(c, inFile);
      fclose(inFile);
      fclose(outFile);
      if (preserve && !sok)
	  utimes(argv[argc], times);
    }
  }
  return retval;
}
