#include <signal.h>
#include "sig.h"
#include "wait.h"
#include "fork.h"
#include "buffer.h"
#include "strerr.h"
#include "exit.h"

char outbuf[512];
buffer bout;

char inbuf[512];
buffer bin;

int myread(int fd,char *buf,int len)
{
  buffer_flush(&bout);
  return buffer_unixread(fd,buf,len);
}

int main()
{
  int pid;
  int wstat;
  char ch;

  sig_ignore(sig_pipe);

  pid = fork();
  if (pid == -1) strerr_die2sys(111,"ipcconnect-io: fatal: ","unable to fork: ");

  if (!pid) {
    buffer_init(&bin,myread,0,inbuf,sizeof inbuf);
    buffer_init(&bout,buffer_unixwrite,7,outbuf,sizeof outbuf);

    while (buffer_get(&bin,&ch,1) == 1)
      buffer_put(&bout,&ch,1);
    _exit(0);
  }

  buffer_init(&bin,myread,6,inbuf,sizeof inbuf);
  buffer_init(&bout,buffer_unixwrite,1,outbuf,sizeof outbuf);

  while (buffer_get(&bin,&ch,1) == 1)
    buffer_put(&bout,&ch,1);

  kill(pid,sig_term);
  wait_pid(&wstat,pid);

  _exit(0);
}
