
#include <stdio.h>

#include "windows.h"
#include "Log.h"
#include "winnt.h"
#include "heap.h"
#include "RscData.h"
#include "stdarg.h"
#include "Resources.h"
#include "Module.h"
#include "Locale.h"

#define LOCALE_ENTRY(id,string)	{ id, string },

typedef struct {
	int id;
	char *string;
} LOCALE_ENTRY;

LOCALE_ENTRY locale_entries[] = {
LOCALE_ENTRY(LOCALE_ILANGUAGE, "0409")
LOCALE_ENTRY(LOCALE_SLANGUAGE, "English (United States)")
LOCALE_ENTRY(LOCALE_SENGLANGUAGE, "English")
LOCALE_ENTRY(LOCALE_SABBREVLANGNAME, "ENU")
LOCALE_ENTRY(LOCALE_SNATIVELANGNAME, "English")
LOCALE_ENTRY(LOCALE_ICOUNTRY, "1")
LOCALE_ENTRY(LOCALE_SCOUNTRY, "United States")
LOCALE_ENTRY(LOCALE_SENGCOUNTRY, "United States")
LOCALE_ENTRY(LOCALE_SABBREVCTRYNAME, "USA")
LOCALE_ENTRY(LOCALE_SNATIVECTRYNAME, "United States")
LOCALE_ENTRY(LOCALE_IDEFAULTLANGUAGE, "0409")
LOCALE_ENTRY(LOCALE_IDEFAULTCOUNTRY, "1")
LOCALE_ENTRY(LOCALE_IDEFAULTCODEPAGE, "437")
LOCALE_ENTRY(LOCALE_IDEFAULTANSICODEPAGE, "1252")
LOCALE_ENTRY(LOCALE_SLIST, ",")
LOCALE_ENTRY(LOCALE_IMEASURE, "1")
LOCALE_ENTRY(LOCALE_SDECIMAL, ".")
LOCALE_ENTRY(LOCALE_STHOUSAND, ",")
LOCALE_ENTRY(LOCALE_SGROUPING, "3;0")
LOCALE_ENTRY(LOCALE_IDIGITS, "2")
LOCALE_ENTRY(LOCALE_ILZERO, "1")
LOCALE_ENTRY(LOCALE_INEGNUMBER, "1")
LOCALE_ENTRY(LOCALE_SNATIVEDIGITS, "0123456789")
LOCALE_ENTRY(LOCALE_SCURRENCY, "$")
LOCALE_ENTRY(LOCALE_SINTLSYMBOL, "USD")
LOCALE_ENTRY(LOCALE_SMONDECIMALSEP, ".")
LOCALE_ENTRY(LOCALE_SMONTHOUSANDSEP, ",")
LOCALE_ENTRY(LOCALE_SMONGROUPING, "3;0")
LOCALE_ENTRY(LOCALE_ICURRDIGITS, "2")
LOCALE_ENTRY(LOCALE_IINTLCURRDIGITS, "2")
LOCALE_ENTRY(LOCALE_ICURRENCY, "0")
LOCALE_ENTRY(LOCALE_INEGCURR, "0")
LOCALE_ENTRY(LOCALE_SDATE, "/")
LOCALE_ENTRY(LOCALE_STIME, ":")
LOCALE_ENTRY(LOCALE_SSHORTDATE, "M/d/yy")
LOCALE_ENTRY(LOCALE_SLONGDATE, "dddd, MMMM dd, yyyy")
LOCALE_ENTRY(LOCALE_STIMEFORMAT, "h:mm:ss tt")
LOCALE_ENTRY(LOCALE_IDATE, "0")
LOCALE_ENTRY(LOCALE_ILDATE, "0")
LOCALE_ENTRY(LOCALE_ITIME, "0")
LOCALE_ENTRY(LOCALE_ITIMEMARKPOSN, "0")
LOCALE_ENTRY(LOCALE_ICENTURY, "0")
LOCALE_ENTRY(LOCALE_ITLZERO, "0")
LOCALE_ENTRY(LOCALE_IDAYLZERO, "0")
LOCALE_ENTRY(LOCALE_IMONLZERO, "0")
LOCALE_ENTRY(LOCALE_S1159, "AM")
LOCALE_ENTRY(LOCALE_S2359, "PM")
LOCALE_ENTRY(LOCALE_ICALENDARTYPE, "1")
LOCALE_ENTRY(LOCALE_IOPTIONALCALENDAR, "0")
LOCALE_ENTRY(LOCALE_IFIRSTDAYOFWEEK, "6")
LOCALE_ENTRY(LOCALE_IFIRSTWEEKOFYEAR, "0")
LOCALE_ENTRY(LOCALE_SDAYNAME1, "Monday")
LOCALE_ENTRY(LOCALE_SDAYNAME2, "Tuesday")
LOCALE_ENTRY(LOCALE_SDAYNAME3, "Wednesday")
LOCALE_ENTRY(LOCALE_SDAYNAME4, "Thursday")
LOCALE_ENTRY(LOCALE_SDAYNAME5, "Friday")
LOCALE_ENTRY(LOCALE_SDAYNAME6, "Saturday")
LOCALE_ENTRY(LOCALE_SDAYNAME7, "Sunday")
LOCALE_ENTRY(LOCALE_SABBREVDAYNAME1, "Mon")
LOCALE_ENTRY(LOCALE_SABBREVDAYNAME2, "Tue")
LOCALE_ENTRY(LOCALE_SABBREVDAYNAME3, "Wed")
LOCALE_ENTRY(LOCALE_SABBREVDAYNAME4, "Thu")
LOCALE_ENTRY(LOCALE_SABBREVDAYNAME5, "Fri")
LOCALE_ENTRY(LOCALE_SABBREVDAYNAME6, "Sat")
LOCALE_ENTRY(LOCALE_SABBREVDAYNAME7, "Sun")
LOCALE_ENTRY(LOCALE_SMONTHNAME1, "January")
LOCALE_ENTRY(LOCALE_SMONTHNAME2, "February")
LOCALE_ENTRY(LOCALE_SMONTHNAME3, "March")
LOCALE_ENTRY(LOCALE_SMONTHNAME4, "April")
LOCALE_ENTRY(LOCALE_SMONTHNAME5, "May")
LOCALE_ENTRY(LOCALE_SMONTHNAME6, "June")
LOCALE_ENTRY(LOCALE_SMONTHNAME7, "July")
LOCALE_ENTRY(LOCALE_SMONTHNAME8, "August")
LOCALE_ENTRY(LOCALE_SMONTHNAME9, "September")
LOCALE_ENTRY(LOCALE_SMONTHNAME10, "October")
LOCALE_ENTRY(LOCALE_SMONTHNAME11, "November")
LOCALE_ENTRY(LOCALE_SMONTHNAME12, "December")
LOCALE_ENTRY(LOCALE_SMONTHNAME13, "")
LOCALE_ENTRY(LOCALE_SABBREVMONTHNAME1, "Jan")
LOCALE_ENTRY(LOCALE_SABBREVMONTHNAME2, "Feb")
LOCALE_ENTRY(LOCALE_SABBREVMONTHNAME3, "Mar")
LOCALE_ENTRY(LOCALE_SABBREVMONTHNAME4, "Apr")
LOCALE_ENTRY(LOCALE_SABBREVMONTHNAME5, "May")
LOCALE_ENTRY(LOCALE_SABBREVMONTHNAME6, "Jun")
LOCALE_ENTRY(LOCALE_SABBREVMONTHNAME7, "Jul")
LOCALE_ENTRY(LOCALE_SABBREVMONTHNAME8, "Aug")
LOCALE_ENTRY(LOCALE_SABBREVMONTHNAME9, "Sep")
LOCALE_ENTRY(LOCALE_SABBREVMONTHNAME10, "Oct")
LOCALE_ENTRY(LOCALE_SABBREVMONTHNAME11, "Nov")
LOCALE_ENTRY(LOCALE_SABBREVMONTHNAME12, "Dec")
LOCALE_ENTRY(LOCALE_SABBREVMONTHNAME13, "")
LOCALE_ENTRY(LOCALE_SPOSITIVESIGN, "")
LOCALE_ENTRY(LOCALE_SNEGATIVESIGN, "-")
LOCALE_ENTRY(LOCALE_IPOSSIGNPOSN, "3")
LOCALE_ENTRY(LOCALE_INEGSIGNPOSN, "0")
LOCALE_ENTRY(LOCALE_IPOSSYMPRECEDES, "1")
LOCALE_ENTRY(LOCALE_IPOSSEPBYSPACE, "0")
LOCALE_ENTRY(LOCALE_INEGSYMPRECEDES, "1")
LOCALE_ENTRY(LOCALE_INEGSEPBYSPACE, "0")
LOCALE_ENTRY(0, "")
};

#ifdef TWIN_BIN32
static LOCALE_ENTRY *locale_system = locale_entries;

static char *
GetLocaleInfoPtr(LCID Locale,LCTYPE lcType)
{
	int n;
	LOCALE_ENTRY *locale;

	locale = locale_system;

	for(n=0;locale[n].id;n++) {
		if(locale[n].id == lcType) {
			return locale[n].string;
		}
	}
	return 0;
}

int
GetLocaleInfo(LCID Locale,LCTYPE lcType,LPSTR lpLCData,int cchData)
{
	char *p;
	logstr(LF_APICALL,"GetLocaleInfo(%x,%x,%p,%d)\n",
		Locale,lcType,lpLCData,cchData);

	if ((p = GetLocaleInfoPtr(Locale,lcType))) {

		if(cchData && lpLCData)
			lstrcpyn(lpLCData,p,cchData);

		logstr(LF_APIRET,"GetLocaleInfo returns int %d\n",
			lstrlen(p));
		return lstrlen(p);
	}
	// setlasterror...
	logstr(LF_APIRET,"GetLocaleInfo retunrs int %d\n",0);
	return 0;
}

int
GetLocaleInfoW(LCID Locale,LCTYPE lcType,LPWSTR lpLCData,int cchData)
{
	char *p;
	logstr(LF_LOG,"GetLocaleInfoW(%x,%x,%p,%d)\n",
		Locale,lcType,lpLCData,cchData);
	
	if ((p = GetLocaleInfoPtr(Locale,lcType))) {

		if(cchData && lpLCData) {
		    lstrcpynAtoW( lpLCData, p, cchData );
		}

		return lstrlen(p);
	}
	// setlasterror...
	return 0;
}
#endif

static LCID	UserLCID;
static LCID	SystemLCID;

extern char *GetTwinFilename();

LCID
GetUserDefaultLCID()
{
    	if ( !UserLCID )
		UserLCID = GetPrivateProfileInt("boot", "LCID",
					0x409, GetTwinFilename());
	APISTR((LF_API,"GetUserDefaultLCID()\n",UserLCID));
	return UserLCID;
}
LCID
GetSystemDefaultLCID()
{
    	if ( !SystemLCID )
		SystemLCID = GetPrivateProfileInt("boot", "LCID",
					0x409, GetTwinFilename());
	APISTR((LF_API,"GetSystemDefaultLCID()\n",SystemLCID));
	return SystemLCID;
}
