#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 816
#define LARGE_STATE_COUNT 6
#define SYMBOL_COUNT 207
#define ALIAS_COUNT 0
#define TOKEN_COUNT 88
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 1
#define MAX_ALIAS_SEQUENCE_LENGTH 18
#define PRODUCTION_ID_COUNT 2

enum {
  anon_sym_align = 1,
  anon_sym_EQ = 2,
  sym_align_offset_value = 3,
  anon_sym_LPAREN_AT = 4,
  anon_sym_RPAREN = 5,
  anon_sym_LPAREN = 6,
  anon_sym_block = 7,
  anon_sym_end = 8,
  anon_sym_if = 9,
  anon_sym_else = 10,
  anon_sym_loop = 11,
  anon_sym_LPAREN_SEMI = 12,
  anon_sym_SEMI_RPAREN = 13,
  sym_comment_block_inner = 14,
  aux_sym_comment_line_token1 = 15,
  sym_dec_float = 16,
  sym_dec_nat = 17,
  anon_sym_item = 18,
  anon_sym_func = 19,
  sym_escape_sequence = 20,
  anon_sym_export = 21,
  anon_sym_global = 22,
  anon_sym_memory = 23,
  anon_sym_table = 24,
  anon_sym_call_indirect = 25,
  anon_sym_inf = 26,
  anon_sym_local = 27,
  anon_sym_param = 28,
  anon_sym_result = 29,
  anon_sym_mut = 30,
  sym_hex_float = 31,
  sym_hex_nat = 32,
  sym_identifier = 33,
  sym_identifier_pattern = 34,
  anon_sym_then = 35,
  anon_sym_import = 36,
  anon_sym_br_table = 37,
  anon_sym_ref_DOTextern = 38,
  anon_sym_ref_DOTnull = 39,
  sym_op_nullary = 40,
  sym_op_index = 41,
  sym_op_index_opt = 42,
  sym_op_index_opt_offset_opt_align_opt = 43,
  sym_op_simd_offset_opt_align_opt = 44,
  aux_sym_op_const_token1 = 45,
  aux_sym_op_const_token2 = 46,
  anon_sym_func_DOTbind = 47,
  anon_sym_type = 48,
  anon_sym_let = 49,
  anon_sym_select = 50,
  anon_sym_v128_DOTconst = 51,
  anon_sym_f32x4 = 52,
  anon_sym_f64x2 = 53,
  anon_sym_i8x16 = 54,
  anon_sym_i16x8 = 55,
  anon_sym_i32x4 = 56,
  anon_sym_i64x2 = 57,
  anon_sym_DOTshuffle = 58,
  anon_sym_DOT = 59,
  anon_sym_extract_lane = 60,
  anon_sym__ = 61,
  aux_sym_op_simd_lane_token1 = 62,
  anon_sym_replace_lane = 63,
  anon_sym_table_DOTcopy = 64,
  anon_sym_table_DOTinit = 65,
  anon_sym_data = 66,
  anon_sym_module = 67,
  anon_sym_elem = 68,
  anon_sym_declare = 69,
  anon_sym_start = 70,
  sym_nan = 71,
  sym_num_type_f32 = 72,
  sym_num_type_f64 = 73,
  sym_num_type_i32 = 74,
  sym_num_type_i64 = 75,
  sym_num_type_v128 = 76,
  anon_sym_offset = 77,
  sym_ref_kind = 78,
  sym_ref_type_externref = 79,
  sym_ref_type_funcref = 80,
  anon_sym_ref = 81,
  anon_sym_null = 82,
  sym_reserved = 83,
  sym_share = 84,
  sym_sign = 85,
  anon_sym_DQUOTE = 86,
  aux_sym_string_token1 = 87,
  sym_ROOT = 88,
  sym_align_value = 89,
  sym_annotation = 90,
  sym_annotation_parens = 91,
  sym_annotation_part = 92,
  sym_block_block = 93,
  sym_block_if = 94,
  sym_block_loop = 95,
  sym_comment_block = 96,
  sym_comment_block_annot = 97,
  sym_comment_line = 98,
  sym_comment_line_annot = 99,
  sym_elem_expr = 100,
  sym_elem_expr_expr = 101,
  sym_elem_expr_item = 102,
  sym_elem_kind = 103,
  sym_elem_list = 104,
  sym_export = 105,
  sym_export_desc = 106,
  sym_export_desc_func = 107,
  sym_export_desc_global = 108,
  sym_export_desc_memory = 109,
  sym_export_desc_table = 110,
  sym_expr = 111,
  sym_expr1 = 112,
  sym_expr1_block = 113,
  sym_expr1_call = 114,
  sym_expr1_if = 115,
  sym_expr1_loop = 116,
  sym_expr1_plain = 117,
  sym_float = 118,
  sym_func_locals = 119,
  sym_func_locals_many = 120,
  sym_func_locals_one = 121,
  sym_func_type = 122,
  sym_func_type_params = 123,
  sym_func_type_params_many = 124,
  sym_func_type_params_one = 125,
  sym_func_type_results = 126,
  sym_global_type = 127,
  sym_global_type_imm = 128,
  sym_global_type_mut = 129,
  sym_if_block = 130,
  sym_import = 131,
  sym_import_desc = 132,
  sym_import_desc_func_type = 133,
  sym_import_desc_global_type = 134,
  sym_import_desc_memory_type = 135,
  sym_import_desc_table_type = 136,
  sym_import_desc_type_use = 137,
  sym_index = 138,
  sym_instr = 139,
  sym_instr_block = 140,
  sym_instr_call = 141,
  sym_instr_list = 142,
  sym_instr_list_call = 143,
  sym_instr_plain = 144,
  sym_op_const = 145,
  sym_op_func_bind = 146,
  sym_op_let = 147,
  sym_op_select = 148,
  sym_op_simd_const = 149,
  sym_op_simd_lane = 150,
  sym_op_table_copy = 151,
  sym_op_table_init = 152,
  sym_int = 153,
  sym_limits = 154,
  sym_memory_fields_data = 155,
  sym_memory_fields_type = 156,
  sym_memory_type = 157,
  sym_memory_use = 158,
  sym_module = 159,
  sym_module_field = 160,
  sym_module_field_data = 161,
  sym_module_field_elem = 162,
  sym_module_field_export = 163,
  sym_module_field_func = 164,
  sym_module_field_global = 165,
  sym_module_field_import = 166,
  sym_module_field_memory = 167,
  sym_module_field_start = 168,
  sym_module_field_table = 169,
  sym_module_field_type = 170,
  sym_name = 171,
  sym_nat = 172,
  sym_offset = 173,
  sym_offset_const_expr = 174,
  sym_offset_expr = 175,
  sym_offset_value = 176,
  sym_ref_type = 177,
  sym_ref_type_ref = 178,
  sym_string = 179,
  sym_table_fields_elem = 180,
  sym_table_fields_type = 181,
  sym_table_type = 182,
  sym_table_use = 183,
  sym_type_field = 184,
  sym_type_use = 185,
  sym_value_type = 186,
  sym_value_type_num_type = 187,
  sym_value_type_ref_type = 188,
  aux_sym_ROOT_repeat1 = 189,
  aux_sym_annotation_repeat1 = 190,
  aux_sym_block_block_repeat1 = 191,
  aux_sym_block_block_repeat2 = 192,
  aux_sym_comment_block_repeat1 = 193,
  aux_sym_comment_block_annot_repeat1 = 194,
  aux_sym_elem_expr_item_repeat1 = 195,
  aux_sym_elem_list_repeat1 = 196,
  aux_sym_elem_list_repeat2 = 197,
  aux_sym_expr1_call_repeat1 = 198,
  aux_sym_func_locals_many_repeat1 = 199,
  aux_sym_import_desc_func_type_repeat1 = 200,
  aux_sym_instr_list_repeat1 = 201,
  aux_sym_op_let_repeat1 = 202,
  aux_sym_op_let_repeat2 = 203,
  aux_sym_memory_fields_data_repeat1 = 204,
  aux_sym_module_field_func_repeat1 = 205,
  aux_sym_string_repeat1 = 206,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_align] = "align",
  [anon_sym_EQ] = "=",
  [sym_align_offset_value] = "align_offset_value",
  [anon_sym_LPAREN_AT] = "(@",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LPAREN] = "(",
  [anon_sym_block] = "block",
  [anon_sym_end] = "end",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_loop] = "loop",
  [anon_sym_LPAREN_SEMI] = "(;",
  [anon_sym_SEMI_RPAREN] = ";)",
  [sym_comment_block_inner] = "comment_block_inner",
  [aux_sym_comment_line_token1] = "comment_line_token1",
  [sym_dec_float] = "dec_float",
  [sym_dec_nat] = "dec_nat",
  [anon_sym_item] = "item",
  [anon_sym_func] = "func",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_export] = "export",
  [anon_sym_global] = "global",
  [anon_sym_memory] = "memory",
  [anon_sym_table] = "table",
  [anon_sym_call_indirect] = "call_indirect",
  [anon_sym_inf] = "inf",
  [anon_sym_local] = "local",
  [anon_sym_param] = "param",
  [anon_sym_result] = "result",
  [anon_sym_mut] = "mut",
  [sym_hex_float] = "hex_float",
  [sym_hex_nat] = "hex_nat",
  [sym_identifier] = "identifier",
  [sym_identifier_pattern] = "identifier_pattern",
  [anon_sym_then] = "then",
  [anon_sym_import] = "import",
  [anon_sym_br_table] = "br_table",
  [anon_sym_ref_DOTextern] = "ref.extern",
  [anon_sym_ref_DOTnull] = "ref.null",
  [sym_op_nullary] = "op_nullary",
  [sym_op_index] = "op_index",
  [sym_op_index_opt] = "op_index_opt",
  [sym_op_index_opt_offset_opt_align_opt] = "op_index_opt_offset_opt_align_opt",
  [sym_op_simd_offset_opt_align_opt] = "op_simd_offset_opt_align_opt",
  [aux_sym_op_const_token1] = "pat00",
  [aux_sym_op_const_token2] = "pat01",
  [anon_sym_func_DOTbind] = "func.bind",
  [anon_sym_type] = "type",
  [anon_sym_let] = "let",
  [anon_sym_select] = "select",
  [anon_sym_v128_DOTconst] = "v128.const",
  [anon_sym_f32x4] = "f32x4",
  [anon_sym_f64x2] = "f64x2",
  [anon_sym_i8x16] = "i8x16",
  [anon_sym_i16x8] = "i16x8",
  [anon_sym_i32x4] = "i32x4",
  [anon_sym_i64x2] = "i64x2",
  [anon_sym_DOTshuffle] = ".shuffle",
  [anon_sym_DOT] = ".",
  [anon_sym_extract_lane] = "extract_lane",
  [anon_sym__] = "_",
  [aux_sym_op_simd_lane_token1] = "op_simd_lane_token1",
  [anon_sym_replace_lane] = "replace_lane",
  [anon_sym_table_DOTcopy] = "table.copy",
  [anon_sym_table_DOTinit] = "table.init",
  [anon_sym_data] = "data",
  [anon_sym_module] = "module",
  [anon_sym_elem] = "elem",
  [anon_sym_declare] = "declare",
  [anon_sym_start] = "start",
  [sym_nan] = "nan",
  [sym_num_type_f32] = "num_type_f32",
  [sym_num_type_f64] = "num_type_f64",
  [sym_num_type_i32] = "num_type_i32",
  [sym_num_type_i64] = "num_type_i64",
  [sym_num_type_v128] = "num_type_v128",
  [anon_sym_offset] = "offset",
  [sym_ref_kind] = "ref_kind",
  [sym_ref_type_externref] = "ref_type_externref",
  [sym_ref_type_funcref] = "ref_type_funcref",
  [anon_sym_ref] = "ref",
  [anon_sym_null] = "null",
  [sym_reserved] = "reserved",
  [sym_share] = "share",
  [sym_sign] = "sign",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [sym_ROOT] = "ROOT",
  [sym_align_value] = "align_value",
  [sym_annotation] = "annotation",
  [sym_annotation_parens] = "annotation_parens",
  [sym_annotation_part] = "annotation_part",
  [sym_block_block] = "block_block",
  [sym_block_if] = "block_if",
  [sym_block_loop] = "block_loop",
  [sym_comment_block] = "comment_block",
  [sym_comment_block_annot] = "comment_block_annot",
  [sym_comment_line] = "comment_line",
  [sym_comment_line_annot] = "comment_line_annot",
  [sym_elem_expr] = "elem_expr",
  [sym_elem_expr_expr] = "elem_expr_expr",
  [sym_elem_expr_item] = "elem_expr_item",
  [sym_elem_kind] = "elem_kind",
  [sym_elem_list] = "elem_list",
  [sym_export] = "export",
  [sym_export_desc] = "export_desc",
  [sym_export_desc_func] = "export_desc_func",
  [sym_export_desc_global] = "export_desc_global",
  [sym_export_desc_memory] = "export_desc_memory",
  [sym_export_desc_table] = "export_desc_table",
  [sym_expr] = "expr",
  [sym_expr1] = "expr1",
  [sym_expr1_block] = "expr1_block",
  [sym_expr1_call] = "expr1_call",
  [sym_expr1_if] = "expr1_if",
  [sym_expr1_loop] = "expr1_loop",
  [sym_expr1_plain] = "expr1_plain",
  [sym_float] = "float",
  [sym_func_locals] = "func_locals",
  [sym_func_locals_many] = "func_locals_many",
  [sym_func_locals_one] = "func_locals_one",
  [sym_func_type] = "func_type",
  [sym_func_type_params] = "func_type_params",
  [sym_func_type_params_many] = "func_type_params_many",
  [sym_func_type_params_one] = "func_type_params_one",
  [sym_func_type_results] = "func_type_results",
  [sym_global_type] = "global_type",
  [sym_global_type_imm] = "global_type_imm",
  [sym_global_type_mut] = "global_type_mut",
  [sym_if_block] = "if_block",
  [sym_import] = "import",
  [sym_import_desc] = "import_desc",
  [sym_import_desc_func_type] = "import_desc_func_type",
  [sym_import_desc_global_type] = "import_desc_global_type",
  [sym_import_desc_memory_type] = "import_desc_memory_type",
  [sym_import_desc_table_type] = "import_desc_table_type",
  [sym_import_desc_type_use] = "import_desc_type_use",
  [sym_index] = "index",
  [sym_instr] = "instr",
  [sym_instr_block] = "instr_block",
  [sym_instr_call] = "instr_call",
  [sym_instr_list] = "instr_list",
  [sym_instr_list_call] = "instr_list_call",
  [sym_instr_plain] = "instr_plain",
  [sym_op_const] = "op_const",
  [sym_op_func_bind] = "op_func_bind",
  [sym_op_let] = "op_let",
  [sym_op_select] = "op_select",
  [sym_op_simd_const] = "op_simd_const",
  [sym_op_simd_lane] = "op_simd_lane",
  [sym_op_table_copy] = "op_table_copy",
  [sym_op_table_init] = "op_table_init",
  [sym_int] = "int",
  [sym_limits] = "limits",
  [sym_memory_fields_data] = "memory_fields_data",
  [sym_memory_fields_type] = "memory_fields_type",
  [sym_memory_type] = "memory_type",
  [sym_memory_use] = "memory_use",
  [sym_module] = "module",
  [sym_module_field] = "module_field",
  [sym_module_field_data] = "module_field_data",
  [sym_module_field_elem] = "module_field_elem",
  [sym_module_field_export] = "module_field_export",
  [sym_module_field_func] = "module_field_func",
  [sym_module_field_global] = "module_field_global",
  [sym_module_field_import] = "module_field_import",
  [sym_module_field_memory] = "module_field_memory",
  [sym_module_field_start] = "module_field_start",
  [sym_module_field_table] = "module_field_table",
  [sym_module_field_type] = "module_field_type",
  [sym_name] = "name",
  [sym_nat] = "nat",
  [sym_offset] = "offset",
  [sym_offset_const_expr] = "offset_const_expr",
  [sym_offset_expr] = "offset_expr",
  [sym_offset_value] = "offset_value",
  [sym_ref_type] = "ref_type",
  [sym_ref_type_ref] = "ref_type_ref",
  [sym_string] = "string",
  [sym_table_fields_elem] = "table_fields_elem",
  [sym_table_fields_type] = "table_fields_type",
  [sym_table_type] = "table_type",
  [sym_table_use] = "table_use",
  [sym_type_field] = "type_field",
  [sym_type_use] = "type_use",
  [sym_value_type] = "value_type",
  [sym_value_type_num_type] = "value_type_num_type",
  [sym_value_type_ref_type] = "value_type_ref_type",
  [aux_sym_ROOT_repeat1] = "ROOT_repeat1",
  [aux_sym_annotation_repeat1] = "annotation_repeat1",
  [aux_sym_block_block_repeat1] = "block_block_repeat1",
  [aux_sym_block_block_repeat2] = "block_block_repeat2",
  [aux_sym_comment_block_repeat1] = "comment_block_repeat1",
  [aux_sym_comment_block_annot_repeat1] = "comment_block_annot_repeat1",
  [aux_sym_elem_expr_item_repeat1] = "elem_expr_item_repeat1",
  [aux_sym_elem_list_repeat1] = "elem_list_repeat1",
  [aux_sym_elem_list_repeat2] = "elem_list_repeat2",
  [aux_sym_expr1_call_repeat1] = "expr1_call_repeat1",
  [aux_sym_func_locals_many_repeat1] = "func_locals_many_repeat1",
  [aux_sym_import_desc_func_type_repeat1] = "import_desc_func_type_repeat1",
  [aux_sym_instr_list_repeat1] = "instr_list_repeat1",
  [aux_sym_op_let_repeat1] = "op_let_repeat1",
  [aux_sym_op_let_repeat2] = "op_let_repeat2",
  [aux_sym_memory_fields_data_repeat1] = "memory_fields_data_repeat1",
  [aux_sym_module_field_func_repeat1] = "module_field_func_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_align] = anon_sym_align,
  [anon_sym_EQ] = anon_sym_EQ,
  [sym_align_offset_value] = sym_align_offset_value,
  [anon_sym_LPAREN_AT] = anon_sym_LPAREN_AT,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_block] = anon_sym_block,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_loop] = anon_sym_loop,
  [anon_sym_LPAREN_SEMI] = anon_sym_LPAREN_SEMI,
  [anon_sym_SEMI_RPAREN] = anon_sym_SEMI_RPAREN,
  [sym_comment_block_inner] = sym_comment_block_inner,
  [aux_sym_comment_line_token1] = aux_sym_comment_line_token1,
  [sym_dec_float] = sym_dec_float,
  [sym_dec_nat] = sym_dec_nat,
  [anon_sym_item] = anon_sym_item,
  [anon_sym_func] = anon_sym_func,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_memory] = anon_sym_memory,
  [anon_sym_table] = anon_sym_table,
  [anon_sym_call_indirect] = anon_sym_call_indirect,
  [anon_sym_inf] = anon_sym_inf,
  [anon_sym_local] = anon_sym_local,
  [anon_sym_param] = anon_sym_param,
  [anon_sym_result] = anon_sym_result,
  [anon_sym_mut] = anon_sym_mut,
  [sym_hex_float] = sym_hex_float,
  [sym_hex_nat] = sym_hex_nat,
  [sym_identifier] = sym_identifier,
  [sym_identifier_pattern] = sym_identifier_pattern,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_br_table] = anon_sym_br_table,
  [anon_sym_ref_DOTextern] = anon_sym_ref_DOTextern,
  [anon_sym_ref_DOTnull] = anon_sym_ref_DOTnull,
  [sym_op_nullary] = sym_op_nullary,
  [sym_op_index] = sym_op_index,
  [sym_op_index_opt] = sym_op_index_opt,
  [sym_op_index_opt_offset_opt_align_opt] = sym_op_index_opt_offset_opt_align_opt,
  [sym_op_simd_offset_opt_align_opt] = sym_op_simd_offset_opt_align_opt,
  [aux_sym_op_const_token1] = aux_sym_op_const_token1,
  [aux_sym_op_const_token2] = aux_sym_op_const_token2,
  [anon_sym_func_DOTbind] = anon_sym_func_DOTbind,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_select] = anon_sym_select,
  [anon_sym_v128_DOTconst] = anon_sym_v128_DOTconst,
  [anon_sym_f32x4] = anon_sym_f32x4,
  [anon_sym_f64x2] = anon_sym_f64x2,
  [anon_sym_i8x16] = anon_sym_i8x16,
  [anon_sym_i16x8] = anon_sym_i16x8,
  [anon_sym_i32x4] = anon_sym_i32x4,
  [anon_sym_i64x2] = anon_sym_i64x2,
  [anon_sym_DOTshuffle] = anon_sym_DOTshuffle,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_extract_lane] = anon_sym_extract_lane,
  [anon_sym__] = anon_sym__,
  [aux_sym_op_simd_lane_token1] = aux_sym_op_simd_lane_token1,
  [anon_sym_replace_lane] = anon_sym_replace_lane,
  [anon_sym_table_DOTcopy] = anon_sym_table_DOTcopy,
  [anon_sym_table_DOTinit] = anon_sym_table_DOTinit,
  [anon_sym_data] = anon_sym_data,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_elem] = anon_sym_elem,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_start] = anon_sym_start,
  [sym_nan] = sym_nan,
  [sym_num_type_f32] = sym_num_type_f32,
  [sym_num_type_f64] = sym_num_type_f64,
  [sym_num_type_i32] = sym_num_type_i32,
  [sym_num_type_i64] = sym_num_type_i64,
  [sym_num_type_v128] = sym_num_type_v128,
  [anon_sym_offset] = anon_sym_offset,
  [sym_ref_kind] = sym_ref_kind,
  [sym_ref_type_externref] = sym_ref_type_externref,
  [sym_ref_type_funcref] = sym_ref_type_funcref,
  [anon_sym_ref] = anon_sym_ref,
  [anon_sym_null] = anon_sym_null,
  [sym_reserved] = sym_reserved,
  [sym_share] = sym_share,
  [sym_sign] = sym_sign,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [sym_ROOT] = sym_ROOT,
  [sym_align_value] = sym_align_value,
  [sym_annotation] = sym_annotation,
  [sym_annotation_parens] = sym_annotation_parens,
  [sym_annotation_part] = sym_annotation_part,
  [sym_block_block] = sym_block_block,
  [sym_block_if] = sym_block_if,
  [sym_block_loop] = sym_block_loop,
  [sym_comment_block] = sym_comment_block,
  [sym_comment_block_annot] = sym_comment_block_annot,
  [sym_comment_line] = sym_comment_line,
  [sym_comment_line_annot] = sym_comment_line_annot,
  [sym_elem_expr] = sym_elem_expr,
  [sym_elem_expr_expr] = sym_elem_expr_expr,
  [sym_elem_expr_item] = sym_elem_expr_item,
  [sym_elem_kind] = sym_elem_kind,
  [sym_elem_list] = sym_elem_list,
  [sym_export] = sym_export,
  [sym_export_desc] = sym_export_desc,
  [sym_export_desc_func] = sym_export_desc_func,
  [sym_export_desc_global] = sym_export_desc_global,
  [sym_export_desc_memory] = sym_export_desc_memory,
  [sym_export_desc_table] = sym_export_desc_table,
  [sym_expr] = sym_expr,
  [sym_expr1] = sym_expr1,
  [sym_expr1_block] = sym_expr1_block,
  [sym_expr1_call] = sym_expr1_call,
  [sym_expr1_if] = sym_expr1_if,
  [sym_expr1_loop] = sym_expr1_loop,
  [sym_expr1_plain] = sym_expr1_plain,
  [sym_float] = sym_float,
  [sym_func_locals] = sym_func_locals,
  [sym_func_locals_many] = sym_func_locals_many,
  [sym_func_locals_one] = sym_func_locals_one,
  [sym_func_type] = sym_func_type,
  [sym_func_type_params] = sym_func_type_params,
  [sym_func_type_params_many] = sym_func_type_params_many,
  [sym_func_type_params_one] = sym_func_type_params_one,
  [sym_func_type_results] = sym_func_type_results,
  [sym_global_type] = sym_global_type,
  [sym_global_type_imm] = sym_global_type_imm,
  [sym_global_type_mut] = sym_global_type_mut,
  [sym_if_block] = sym_if_block,
  [sym_import] = sym_import,
  [sym_import_desc] = sym_import_desc,
  [sym_import_desc_func_type] = sym_import_desc_func_type,
  [sym_import_desc_global_type] = sym_import_desc_global_type,
  [sym_import_desc_memory_type] = sym_import_desc_memory_type,
  [sym_import_desc_table_type] = sym_import_desc_table_type,
  [sym_import_desc_type_use] = sym_import_desc_type_use,
  [sym_index] = sym_index,
  [sym_instr] = sym_instr,
  [sym_instr_block] = sym_instr_block,
  [sym_instr_call] = sym_instr_call,
  [sym_instr_list] = sym_instr_list,
  [sym_instr_list_call] = sym_instr_list_call,
  [sym_instr_plain] = sym_instr_plain,
  [sym_op_const] = sym_op_const,
  [sym_op_func_bind] = sym_op_func_bind,
  [sym_op_let] = sym_op_let,
  [sym_op_select] = sym_op_select,
  [sym_op_simd_const] = sym_op_simd_const,
  [sym_op_simd_lane] = sym_op_simd_lane,
  [sym_op_table_copy] = sym_op_table_copy,
  [sym_op_table_init] = sym_op_table_init,
  [sym_int] = sym_int,
  [sym_limits] = sym_limits,
  [sym_memory_fields_data] = sym_memory_fields_data,
  [sym_memory_fields_type] = sym_memory_fields_type,
  [sym_memory_type] = sym_memory_type,
  [sym_memory_use] = sym_memory_use,
  [sym_module] = sym_module,
  [sym_module_field] = sym_module_field,
  [sym_module_field_data] = sym_module_field_data,
  [sym_module_field_elem] = sym_module_field_elem,
  [sym_module_field_export] = sym_module_field_export,
  [sym_module_field_func] = sym_module_field_func,
  [sym_module_field_global] = sym_module_field_global,
  [sym_module_field_import] = sym_module_field_import,
  [sym_module_field_memory] = sym_module_field_memory,
  [sym_module_field_start] = sym_module_field_start,
  [sym_module_field_table] = sym_module_field_table,
  [sym_module_field_type] = sym_module_field_type,
  [sym_name] = sym_name,
  [sym_nat] = sym_nat,
  [sym_offset] = sym_offset,
  [sym_offset_const_expr] = sym_offset_const_expr,
  [sym_offset_expr] = sym_offset_expr,
  [sym_offset_value] = sym_offset_value,
  [sym_ref_type] = sym_ref_type,
  [sym_ref_type_ref] = sym_ref_type_ref,
  [sym_string] = sym_string,
  [sym_table_fields_elem] = sym_table_fields_elem,
  [sym_table_fields_type] = sym_table_fields_type,
  [sym_table_type] = sym_table_type,
  [sym_table_use] = sym_table_use,
  [sym_type_field] = sym_type_field,
  [sym_type_use] = sym_type_use,
  [sym_value_type] = sym_value_type,
  [sym_value_type_num_type] = sym_value_type_num_type,
  [sym_value_type_ref_type] = sym_value_type_ref_type,
  [aux_sym_ROOT_repeat1] = aux_sym_ROOT_repeat1,
  [aux_sym_annotation_repeat1] = aux_sym_annotation_repeat1,
  [aux_sym_block_block_repeat1] = aux_sym_block_block_repeat1,
  [aux_sym_block_block_repeat2] = aux_sym_block_block_repeat2,
  [aux_sym_comment_block_repeat1] = aux_sym_comment_block_repeat1,
  [aux_sym_comment_block_annot_repeat1] = aux_sym_comment_block_annot_repeat1,
  [aux_sym_elem_expr_item_repeat1] = aux_sym_elem_expr_item_repeat1,
  [aux_sym_elem_list_repeat1] = aux_sym_elem_list_repeat1,
  [aux_sym_elem_list_repeat2] = aux_sym_elem_list_repeat2,
  [aux_sym_expr1_call_repeat1] = aux_sym_expr1_call_repeat1,
  [aux_sym_func_locals_many_repeat1] = aux_sym_func_locals_many_repeat1,
  [aux_sym_import_desc_func_type_repeat1] = aux_sym_import_desc_func_type_repeat1,
  [aux_sym_instr_list_repeat1] = aux_sym_instr_list_repeat1,
  [aux_sym_op_let_repeat1] = aux_sym_op_let_repeat1,
  [aux_sym_op_let_repeat2] = aux_sym_op_let_repeat2,
  [aux_sym_memory_fields_data_repeat1] = aux_sym_memory_fields_data_repeat1,
  [aux_sym_module_field_func_repeat1] = aux_sym_module_field_func_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_align] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_align_offset_value] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_block] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_loop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_comment_block_inner] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_comment_line_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_dec_float] = {
    .visible = true,
    .named = true,
  },
  [sym_dec_nat] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_item] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_func] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_memory] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_table] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_call_indirect] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_param] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_result] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mut] = {
    .visible = true,
    .named = false,
  },
  [sym_hex_float] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_nat] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_br_table] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ref_DOTextern] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ref_DOTnull] = {
    .visible = true,
    .named = false,
  },
  [sym_op_nullary] = {
    .visible = true,
    .named = true,
  },
  [sym_op_index] = {
    .visible = true,
    .named = true,
  },
  [sym_op_index_opt] = {
    .visible = true,
    .named = true,
  },
  [sym_op_index_opt_offset_opt_align_opt] = {
    .visible = true,
    .named = true,
  },
  [sym_op_simd_offset_opt_align_opt] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_op_const_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_op_const_token2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_func_DOTbind] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_select] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_v128_DOTconst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_f32x4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_f64x2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i8x16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i16x8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i32x4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i64x2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTshuffle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extract_lane] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_op_simd_lane_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_replace_lane] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_table_DOTcopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_table_DOTinit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_data] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elem] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_start] = {
    .visible = true,
    .named = false,
  },
  [sym_nan] = {
    .visible = true,
    .named = true,
  },
  [sym_num_type_f32] = {
    .visible = true,
    .named = true,
  },
  [sym_num_type_f64] = {
    .visible = true,
    .named = true,
  },
  [sym_num_type_i32] = {
    .visible = true,
    .named = true,
  },
  [sym_num_type_i64] = {
    .visible = true,
    .named = true,
  },
  [sym_num_type_v128] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_offset] = {
    .visible = true,
    .named = false,
  },
  [sym_ref_kind] = {
    .visible = true,
    .named = true,
  },
  [sym_ref_type_externref] = {
    .visible = true,
    .named = true,
  },
  [sym_ref_type_funcref] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_null] = {
    .visible = true,
    .named = false,
  },
  [sym_reserved] = {
    .visible = true,
    .named = true,
  },
  [sym_share] = {
    .visible = true,
    .named = true,
  },
  [sym_sign] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_ROOT] = {
    .visible = true,
    .named = true,
  },
  [sym_align_value] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_parens] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_part] = {
    .visible = true,
    .named = true,
  },
  [sym_block_block] = {
    .visible = true,
    .named = true,
  },
  [sym_block_if] = {
    .visible = true,
    .named = true,
  },
  [sym_block_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_comment_block] = {
    .visible = true,
    .named = true,
  },
  [sym_comment_block_annot] = {
    .visible = true,
    .named = true,
  },
  [sym_comment_line] = {
    .visible = true,
    .named = true,
  },
  [sym_comment_line_annot] = {
    .visible = true,
    .named = true,
  },
  [sym_elem_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_elem_expr_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_elem_expr_item] = {
    .visible = true,
    .named = true,
  },
  [sym_elem_kind] = {
    .visible = true,
    .named = true,
  },
  [sym_elem_list] = {
    .visible = true,
    .named = true,
  },
  [sym_export] = {
    .visible = true,
    .named = true,
  },
  [sym_export_desc] = {
    .visible = true,
    .named = true,
  },
  [sym_export_desc_func] = {
    .visible = true,
    .named = true,
  },
  [sym_export_desc_global] = {
    .visible = true,
    .named = true,
  },
  [sym_export_desc_memory] = {
    .visible = true,
    .named = true,
  },
  [sym_export_desc_table] = {
    .visible = true,
    .named = true,
  },
  [sym_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_expr1] = {
    .visible = true,
    .named = true,
  },
  [sym_expr1_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expr1_call] = {
    .visible = true,
    .named = true,
  },
  [sym_expr1_if] = {
    .visible = true,
    .named = true,
  },
  [sym_expr1_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_expr1_plain] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_func_locals] = {
    .visible = true,
    .named = true,
  },
  [sym_func_locals_many] = {
    .visible = true,
    .named = true,
  },
  [sym_func_locals_one] = {
    .visible = true,
    .named = true,
  },
  [sym_func_type] = {
    .visible = true,
    .named = true,
  },
  [sym_func_type_params] = {
    .visible = true,
    .named = true,
  },
  [sym_func_type_params_many] = {
    .visible = true,
    .named = true,
  },
  [sym_func_type_params_one] = {
    .visible = true,
    .named = true,
  },
  [sym_func_type_results] = {
    .visible = true,
    .named = true,
  },
  [sym_global_type] = {
    .visible = true,
    .named = true,
  },
  [sym_global_type_imm] = {
    .visible = true,
    .named = true,
  },
  [sym_global_type_mut] = {
    .visible = true,
    .named = true,
  },
  [sym_if_block] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_desc] = {
    .visible = true,
    .named = true,
  },
  [sym_import_desc_func_type] = {
    .visible = true,
    .named = true,
  },
  [sym_import_desc_global_type] = {
    .visible = true,
    .named = true,
  },
  [sym_import_desc_memory_type] = {
    .visible = true,
    .named = true,
  },
  [sym_import_desc_table_type] = {
    .visible = true,
    .named = true,
  },
  [sym_import_desc_type_use] = {
    .visible = true,
    .named = true,
  },
  [sym_index] = {
    .visible = true,
    .named = true,
  },
  [sym_instr] = {
    .visible = true,
    .named = true,
  },
  [sym_instr_block] = {
    .visible = true,
    .named = true,
  },
  [sym_instr_call] = {
    .visible = true,
    .named = true,
  },
  [sym_instr_list] = {
    .visible = true,
    .named = true,
  },
  [sym_instr_list_call] = {
    .visible = true,
    .named = true,
  },
  [sym_instr_plain] = {
    .visible = true,
    .named = true,
  },
  [sym_op_const] = {
    .visible = true,
    .named = true,
  },
  [sym_op_func_bind] = {
    .visible = true,
    .named = true,
  },
  [sym_op_let] = {
    .visible = true,
    .named = true,
  },
  [sym_op_select] = {
    .visible = true,
    .named = true,
  },
  [sym_op_simd_const] = {
    .visible = true,
    .named = true,
  },
  [sym_op_simd_lane] = {
    .visible = true,
    .named = true,
  },
  [sym_op_table_copy] = {
    .visible = true,
    .named = true,
  },
  [sym_op_table_init] = {
    .visible = true,
    .named = true,
  },
  [sym_int] = {
    .visible = true,
    .named = true,
  },
  [sym_limits] = {
    .visible = true,
    .named = true,
  },
  [sym_memory_fields_data] = {
    .visible = true,
    .named = true,
  },
  [sym_memory_fields_type] = {
    .visible = true,
    .named = true,
  },
  [sym_memory_type] = {
    .visible = true,
    .named = true,
  },
  [sym_memory_use] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_module_field] = {
    .visible = true,
    .named = true,
  },
  [sym_module_field_data] = {
    .visible = true,
    .named = true,
  },
  [sym_module_field_elem] = {
    .visible = true,
    .named = true,
  },
  [sym_module_field_export] = {
    .visible = true,
    .named = true,
  },
  [sym_module_field_func] = {
    .visible = true,
    .named = true,
  },
  [sym_module_field_global] = {
    .visible = true,
    .named = true,
  },
  [sym_module_field_import] = {
    .visible = true,
    .named = true,
  },
  [sym_module_field_memory] = {
    .visible = true,
    .named = true,
  },
  [sym_module_field_start] = {
    .visible = true,
    .named = true,
  },
  [sym_module_field_table] = {
    .visible = true,
    .named = true,
  },
  [sym_module_field_type] = {
    .visible = true,
    .named = true,
  },
  [sym_name] = {
    .visible = true,
    .named = true,
  },
  [sym_nat] = {
    .visible = true,
    .named = true,
  },
  [sym_offset] = {
    .visible = true,
    .named = true,
  },
  [sym_offset_const_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_offset_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_offset_value] = {
    .visible = true,
    .named = true,
  },
  [sym_ref_type] = {
    .visible = true,
    .named = true,
  },
  [sym_ref_type_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_table_fields_elem] = {
    .visible = true,
    .named = true,
  },
  [sym_table_fields_type] = {
    .visible = true,
    .named = true,
  },
  [sym_table_type] = {
    .visible = true,
    .named = true,
  },
  [sym_table_use] = {
    .visible = true,
    .named = true,
  },
  [sym_type_field] = {
    .visible = true,
    .named = true,
  },
  [sym_type_use] = {
    .visible = true,
    .named = true,
  },
  [sym_value_type] = {
    .visible = true,
    .named = true,
  },
  [sym_value_type_num_type] = {
    .visible = true,
    .named = true,
  },
  [sym_value_type_ref_type] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_ROOT_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_block_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comment_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comment_block_annot_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_elem_expr_item_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_elem_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_elem_list_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expr1_call_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_func_locals_many_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_desc_func_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instr_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_op_let_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_op_let_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_memory_fields_data_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_field_func_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_identifier = 1,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_identifier] = "identifier",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_identifier, 2},
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < '\\'
    ? (c < '*'
      ? (c < '#'
        ? c == '!'
        : c <= '\'')
      : (c <= ':' || (c >= '<' && c <= 'Z')))
    : (c <= '\\' || (c < '|'
      ? (c < 'a'
        ? (c >= '^' && c <= '_')
        : c <= 'z')
      : (c <= '|' || c == '~'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(926);
      if (lookahead == '"') ADVANCE(1073);
      if (lookahead == '$') ADVANCE(924);
      if (lookahead == '(') ADVANCE(936);
      if (lookahead == ')') ADVANCE(935);
      if (lookahead == '.') ADVANCE(1032);
      if (lookahead == '0') ADVANCE(930);
      if (lookahead == ';') ADVANCE(17);
      if (lookahead == '=') ADVANCE(928);
      if (lookahead == '\\') ADVANCE(835);
      if (lookahead == '_') ADVANCE(1034);
      if (lookahead == 'a') ADVANCE(503);
      if (lookahead == 'b') ADVANCE(517);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 'd') ADVANCE(175);
      if (lookahead == 'e') ADVANCE(504);
      if (lookahead == 'f') ADVANCE(85);
      if (lookahead == 'g') ADVANCE(520);
      if (lookahead == 'i') ADVANCE(41);
      if (lookahead == 'l') ADVANCE(349);
      if (lookahead == 'm') ADVANCE(327);
      if (lookahead == 'n') ADVANCE(189);
      if (lookahead == 'o') ADVANCE(425);
      if (lookahead == 'p') ADVANCE(176);
      if (lookahead == 'r') ADVANCE(328);
      if (lookahead == 's') ADVANCE(1036);
      if (lookahead == 't') ADVANCE(177);
      if (lookahead == 'u') ADVANCE(1037);
      if (lookahead == 'v') ADVANCE(45);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(1072);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(925)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(932);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(8)
      if (lookahead == '"') ADVANCE(1073);
      if (lookahead == '(') ADVANCE(1076);
      if (lookahead == ';') ADVANCE(1077);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1075);
      if (lookahead != 0) ADVANCE(1078);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(1074);
      if (lookahead == '\r') ADVANCE(962);
      if (lookahead == 'u') ADVANCE(900);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(916);
      if (lookahead != 0) ADVANCE(963);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(1073);
      if (lookahead == '$') ADVANCE(924);
      if (lookahead == '(') ADVANCE(936);
      if (lookahead == ')') ADVANCE(935);
      if (lookahead == '0') ADVANCE(955);
      if (lookahead == ';') ADVANCE(144);
      if (lookahead == 'a') ADVANCE(503);
      if (lookahead == 'b') ADVANCE(517);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 'd') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(544);
      if (lookahead == 'f') ADVANCE(91);
      if (lookahead == 'g') ADVANCE(553);
      if (lookahead == 'i') ADVANCE(43);
      if (lookahead == 'l') ADVANCE(349);
      if (lookahead == 'm') ADVANCE(326);
      if (lookahead == 'n') ADVANCE(634);
      if (lookahead == 'o') ADVANCE(425);
      if (lookahead == 'p') ADVANCE(176);
      if (lookahead == 'r') ADVANCE(330);
      if (lookahead == 's') ADVANCE(357);
      if (lookahead == 't') ADVANCE(177);
      if (lookahead == 'u') ADVANCE(580);
      if (lookahead == 'v') ADVANCE(52);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(1072);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(956);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(1073);
      if (lookahead == '$') ADVANCE(924);
      if (lookahead == '(') ADVANCE(936);
      if (lookahead == ')') ADVANCE(935);
      if (lookahead == '0') ADVANCE(955);
      if (lookahead == ';') ADVANCE(144);
      if (lookahead == 'a') ADVANCE(503);
      if (lookahead == 'b') ADVANCE(517);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 'd') ADVANCE(227);
      if (lookahead == 'e') ADVANCE(545);
      if (lookahead == 'f') ADVANCE(92);
      if (lookahead == 'g') ADVANCE(553);
      if (lookahead == 'i') ADVANCE(42);
      if (lookahead == 'l') ADVANCE(350);
      if (lookahead == 'm') ADVANCE(395);
      if (lookahead == 'n') ADVANCE(634);
      if (lookahead == 'o') ADVANCE(425);
      if (lookahead == 'r') ADVANCE(347);
      if (lookahead == 's') ADVANCE(357);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(580);
      if (lookahead == 'v') ADVANCE(52);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(1072);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(956);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(1073);
      if (lookahead == '$') ADVANCE(924);
      if (lookahead == '(') ADVANCE(936);
      if (lookahead == ')') ADVANCE(935);
      if (lookahead == '0') ADVANCE(955);
      if (lookahead == ';') ADVANCE(144);
      if (lookahead == 'd') ADVANCE(237);
      if (lookahead == 'e') ADVANCE(550);
      if (lookahead == 'f') ADVANCE(94);
      if (lookahead == 'i') ADVANCE(95);
      if (lookahead == 'v') ADVANCE(50);
      if (lookahead == 's' ||
          lookahead == 'u') ADVANCE(1035);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(6)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(956);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(1073);
      if (lookahead == '$') ADVANCE(924);
      if (lookahead == '(') ADVANCE(936);
      if (lookahead == ')') ADVANCE(935);
      if (lookahead == '0') ADVANCE(955);
      if (lookahead == ';') ADVANCE(144);
      if (lookahead == 'd') ADVANCE(237);
      if (lookahead == 'e') ADVANCE(550);
      if (lookahead == 'f') ADVANCE(94);
      if (lookahead == 'i') ADVANCE(95);
      if (lookahead == 'v') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(6)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(956);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(1073);
      if (lookahead == '$') ADVANCE(1069);
      if (lookahead == '(') ADVANCE(936);
      if (lookahead == ')') ADVANCE(935);
      if (lookahead == ',') ADVANCE(1070);
      if (lookahead == ';') ADVANCE(1068);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(1067);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(7)
      if (('!' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= '~')) ADVANCE(1070);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(1073);
      if (lookahead == '(') ADVANCE(143);
      if (lookahead == ';') ADVANCE(144);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(8)
      END_STATE();
    case 9:
      if (lookahead == '$') ADVANCE(924);
      if (lookahead == '(') ADVANCE(143);
      if (lookahead == '0') ADVANCE(955);
      if (lookahead == ';') ADVANCE(144);
      if (lookahead == 'e') ADVANCE(885);
      if (lookahead == 'f') ADVANCE(854);
      if (lookahead == 'n') ADVANCE(844);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(956);
      END_STATE();
    case 10:
      if (lookahead == '(') ADVANCE(936);
      if (lookahead == ')') ADVANCE(935);
      if (lookahead == '0') ADVANCE(949);
      if (lookahead == ';') ADVANCE(144);
      if (lookahead == 'a') ADVANCE(780);
      if (lookahead == 'b') ADVANCE(517);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 'd') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(543);
      if (lookahead == 'f') ADVANCE(93);
      if (lookahead == 'g') ADVANCE(553);
      if (lookahead == 'i') ADVANCE(44);
      if (lookahead == 'l') ADVANCE(350);
      if (lookahead == 'm') ADVANCE(395);
      if (lookahead == 'n') ADVANCE(188);
      if (lookahead == 'r') ADVANCE(347);
      if (lookahead == 's') ADVANCE(356);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(624);
      if (lookahead == 'v') ADVANCE(52);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(1072);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(10)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(950);
      END_STATE();
    case 11:
      if (lookahead == '(') ADVANCE(936);
      if (lookahead == ')') ADVANCE(935);
      if (lookahead == '0') ADVANCE(955);
      if (lookahead == ';') ADVANCE(144);
      if (lookahead == 'a') ADVANCE(780);
      if (lookahead == 'b') ADVANCE(517);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 'd') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(546);
      if (lookahead == 'f') ADVANCE(86);
      if (lookahead == 'g') ADVANCE(553);
      if (lookahead == 'i') ADVANCE(40);
      if (lookahead == 'l') ADVANCE(350);
      if (lookahead == 'm') ADVANCE(395);
      if (lookahead == 'n') ADVANCE(634);
      if (lookahead == 'r') ADVANCE(347);
      if (lookahead == 's') ADVANCE(356);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(624);
      if (lookahead == 'v') ADVANCE(45);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(11)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(956);
      END_STATE();
    case 12:
      if (lookahead == '(') ADVANCE(143);
      if (lookahead == '0') ADVANCE(931);
      if (lookahead == ';') ADVANCE(144);
      if (lookahead == 'd') ADVANCE(236);
      if (lookahead == 'e') ADVANCE(551);
      if (lookahead == 'f') ADVANCE(98);
      if (lookahead == 'g') ADVANCE(556);
      if (lookahead == 'i') ADVANCE(56);
      if (lookahead == 'm') ADVANCE(406);
      if (lookahead == 's') ADVANCE(802);
      if (lookahead == 't') ADVANCE(243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(13)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(932);
      END_STATE();
    case 13:
      if (lookahead == '(') ADVANCE(143);
      if (lookahead == ';') ADVANCE(144);
      if (lookahead == 'd') ADVANCE(236);
      if (lookahead == 'e') ADVANCE(551);
      if (lookahead == 'f') ADVANCE(98);
      if (lookahead == 'g') ADVANCE(556);
      if (lookahead == 'i') ADVANCE(56);
      if (lookahead == 'm') ADVANCE(406);
      if (lookahead == 's') ADVANCE(802);
      if (lookahead == 't') ADVANCE(243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(13)
      END_STATE();
    case 14:
      if (lookahead == '(') ADVANCE(143);
      if (lookahead == ';') ADVANCE(144);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(14)
      END_STATE();
    case 15:
      if (lookahead == '(') ADVANCE(143);
      if (lookahead == ';') ADVANCE(144);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(14)
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          ('*' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(983);
      END_STATE();
    case 16:
      if (lookahead == '(') ADVANCE(946);
      if (lookahead == ';') ADVANCE(945);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(944);
      if (lookahead != 0) ADVANCE(947);
      END_STATE();
    case 17:
      if (lookahead == ')') ADVANCE(943);
      if (lookahead == ';') ADVANCE(948);
      END_STATE();
    case 18:
      if (lookahead == '.') ADVANCE(179);
      if (lookahead == 'x') ADVANCE(102);
      END_STATE();
    case 19:
      if (lookahead == '.') ADVANCE(180);
      if (lookahead == 'x') ADVANCE(61);
      END_STATE();
    case 20:
      if (lookahead == '.') ADVANCE(181);
      if (lookahead == 'x') ADVANCE(103);
      END_STATE();
    case 21:
      if (lookahead == '.') ADVANCE(244);
      if (lookahead == 'x') ADVANCE(62);
      END_STATE();
    case 22:
      if (lookahead == '.') ADVANCE(191);
      END_STATE();
    case 23:
      if (lookahead == '.') ADVANCE(210);
      END_STATE();
    case 24:
      if (lookahead == '.') ADVANCE(442);
      END_STATE();
    case 25:
      if (lookahead == '.') ADVANCE(284);
      END_STATE();
    case 26:
      if (lookahead == '.') ADVANCE(441);
      END_STATE();
    case 27:
      if (lookahead == '.') ADVANCE(221);
      END_STATE();
    case 28:
      if (lookahead == '.') ADVANCE(557);
      END_STATE();
    case 29:
      if (lookahead == '.') ADVANCE(621);
      END_STATE();
    case 30:
      if (lookahead == '.') ADVANCE(185);
      if (lookahead == '1') ADVANCE(125);
      if (lookahead == '3') ADVANCE(74);
      if (lookahead == '8') ADVANCE(37);
      END_STATE();
    case 31:
      if (lookahead == '.') ADVANCE(185);
      if (lookahead == '1') ADVANCE(125);
      if (lookahead == '8') ADVANCE(37);
      END_STATE();
    case 32:
      if (lookahead == '.') ADVANCE(321);
      END_STATE();
    case 33:
      if (lookahead == '.') ADVANCE(253);
      END_STATE();
    case 34:
      if (lookahead == '.') ADVANCE(253);
      if (lookahead == 'r') ADVANCE(375);
      END_STATE();
    case 35:
      if (lookahead == '.') ADVANCE(430);
      END_STATE();
    case 36:
      if (lookahead == '.') ADVANCE(558);
      END_STATE();
    case 37:
      if (lookahead == '.') ADVANCE(231);
      END_STATE();
    case 38:
      if (lookahead == '.') ADVANCE(555);
      END_STATE();
    case 39:
      if (lookahead == '0') ADVANCE(870);
      if (lookahead == 'a') ADVANCE(719);
      if (lookahead == 'c') ADVANCE(209);
      END_STATE();
    case 40:
      if (lookahead == '1') ADVANCE(122);
      if (lookahead == '3') ADVANCE(58);
      if (lookahead == '6') ADVANCE(100);
      if (lookahead == '8') ADVANCE(864);
      if (lookahead == 'f') ADVANCE(939);
      END_STATE();
    case 41:
      if (lookahead == '1') ADVANCE(122);
      if (lookahead == '3') ADVANCE(58);
      if (lookahead == '6') ADVANCE(100);
      if (lookahead == '8') ADVANCE(864);
      if (lookahead == 'f') ADVANCE(939);
      if (lookahead == 'm') ADVANCE(702);
      if (lookahead == 'n') ADVANCE(415);
      if (lookahead == 't') ADVANCE(364);
      END_STATE();
    case 42:
      if (lookahead == '1') ADVANCE(122);
      if (lookahead == '3') ADVANCE(73);
      if (lookahead == '6') ADVANCE(112);
      if (lookahead == '8') ADVANCE(864);
      if (lookahead == 'f') ADVANCE(939);
      END_STATE();
    case 43:
      if (lookahead == '1') ADVANCE(122);
      if (lookahead == '3') ADVANCE(73);
      if (lookahead == '6') ADVANCE(112);
      if (lookahead == '8') ADVANCE(864);
      if (lookahead == 'f') ADVANCE(939);
      if (lookahead == 'm') ADVANCE(702);
      if (lookahead == 't') ADVANCE(364);
      END_STATE();
    case 44:
      if (lookahead == '1') ADVANCE(122);
      if (lookahead == '3') ADVANCE(73);
      if (lookahead == '6') ADVANCE(112);
      if (lookahead == '8') ADVANCE(864);
      if (lookahead == 'f') ADVANCE(939);
      if (lookahead == 'n') ADVANCE(415);
      END_STATE();
    case 45:
      if (lookahead == '1') ADVANCE(60);
      if (lookahead == '3') ADVANCE(71);
      if (lookahead == '6') ADVANCE(111);
      if (lookahead == '8') ADVANCE(882);
      END_STATE();
    case 46:
      if (lookahead == '1') ADVANCE(118);
      END_STATE();
    case 47:
      if (lookahead == '1') ADVANCE(119);
      END_STATE();
    case 48:
      if (lookahead == '1') ADVANCE(123);
      END_STATE();
    case 49:
      if (lookahead == '1') ADVANCE(121);
      END_STATE();
    case 50:
      if (lookahead == '1') ADVANCE(77);
      END_STATE();
    case 51:
      if (lookahead == '1') ADVANCE(130);
      END_STATE();
    case 52:
      if (lookahead == '1') ADVANCE(76);
      if (lookahead == '3') ADVANCE(71);
      if (lookahead == '6') ADVANCE(111);
      if (lookahead == '8') ADVANCE(882);
      END_STATE();
    case 53:
      if (lookahead == '1') ADVANCE(128);
      if (lookahead == '3') ADVANCE(78);
      if (lookahead == '8') ADVANCE(149);
      if (lookahead == '_') ADVANCE(487);
      END_STATE();
    case 54:
      if (lookahead == '1') ADVANCE(128);
      if (lookahead == '8') ADVANCE(149);
      END_STATE();
    case 55:
      if (lookahead == '1') ADVANCE(131);
      END_STATE();
    case 56:
      if (lookahead == '1') ADVANCE(132);
      if (lookahead == '3') ADVANCE(84);
      if (lookahead == '6') ADVANCE(116);
      if (lookahead == '8') ADVANCE(888);
      if (lookahead == 'm') ADVANCE(702);
      END_STATE();
    case 57:
      if (lookahead == '2') ADVANCE(1052);
      END_STATE();
    case 58:
      if (lookahead == '2') ADVANCE(1056);
      END_STATE();
    case 59:
      if (lookahead == '2') ADVANCE(989);
      END_STATE();
    case 60:
      if (lookahead == '2') ADVANCE(133);
      if (lookahead == '6') ADVANCE(868);
      END_STATE();
    case 61:
      if (lookahead == '2') ADVANCE(1022);
      END_STATE();
    case 62:
      if (lookahead == '2') ADVANCE(1030);
      END_STATE();
    case 63:
      if (lookahead == '2') ADVANCE(38);
      END_STATE();
    case 64:
      if (lookahead == '2') ADVANCE(1005);
      END_STATE();
    case 65:
      if (lookahead == '2') ADVANCE(18);
      END_STATE();
    case 66:
      if (lookahead == '2') ADVANCE(1051);
      END_STATE();
    case 67:
      if (lookahead == '2') ADVANCE(1055);
      END_STATE();
    case 68:
      if (lookahead == '2') ADVANCE(1021);
      END_STATE();
    case 69:
      if (lookahead == '2') ADVANCE(1029);
      END_STATE();
    case 70:
      if (lookahead == '2') ADVANCE(145);
      END_STATE();
    case 71:
      if (lookahead == '2') ADVANCE(872);
      END_STATE();
    case 72:
      if (lookahead == '2') ADVANCE(158);
      END_STATE();
    case 73:
      if (lookahead == '2') ADVANCE(20);
      END_STATE();
    case 74:
      if (lookahead == '2') ADVANCE(37);
      END_STATE();
    case 75:
      if (lookahead == '2') ADVANCE(148);
      END_STATE();
    case 76:
      if (lookahead == '2') ADVANCE(139);
      if (lookahead == '6') ADVANCE(868);
      END_STATE();
    case 77:
      if (lookahead == '2') ADVANCE(136);
      END_STATE();
    case 78:
      if (lookahead == '2') ADVANCE(149);
      END_STATE();
    case 79:
      if (lookahead == '2') ADVANCE(150);
      END_STATE();
    case 80:
      if (lookahead == '2') ADVANCE(152);
      END_STATE();
    case 81:
      if (lookahead == '2') ADVANCE(884);
      END_STATE();
    case 82:
      if (lookahead == '2') ADVANCE(874);
      END_STATE();
    case 83:
      if (lookahead == '2') ADVANCE(877);
      END_STATE();
    case 84:
      if (lookahead == '2') ADVANCE(878);
      END_STATE();
    case 85:
      if (lookahead == '3') ADVANCE(57);
      if (lookahead == '6') ADVANCE(99);
      if (lookahead == 'u') ADVANCE(591);
      END_STATE();
    case 86:
      if (lookahead == '3') ADVANCE(57);
      if (lookahead == '6') ADVANCE(99);
      if (lookahead == 'u') ADVANCE(606);
      END_STATE();
    case 87:
      if (lookahead == '3') ADVANCE(70);
      END_STATE();
    case 88:
      if (lookahead == '3') ADVANCE(70);
      if (lookahead == '6') ADVANCE(109);
      END_STATE();
    case 89:
      if (lookahead == '3') ADVANCE(59);
      END_STATE();
    case 90:
      if (lookahead == '3') ADVANCE(59);
      if (lookahead == '6') ADVANCE(101);
      END_STATE();
    case 91:
      if (lookahead == '3') ADVANCE(65);
      if (lookahead == '6') ADVANCE(110);
      if (lookahead == 'u') ADVANCE(606);
      END_STATE();
    case 92:
      if (lookahead == '3') ADVANCE(65);
      if (lookahead == '6') ADVANCE(110);
      if (lookahead == 'u') ADVANCE(608);
      END_STATE();
    case 93:
      if (lookahead == '3') ADVANCE(65);
      if (lookahead == '6') ADVANCE(110);
      if (lookahead == 'u') ADVANCE(609);
      END_STATE();
    case 94:
      if (lookahead == '3') ADVANCE(66);
      if (lookahead == '6') ADVANCE(105);
      if (lookahead == 'u') ADVANCE(610);
      END_STATE();
    case 95:
      if (lookahead == '3') ADVANCE(67);
      if (lookahead == '6') ADVANCE(106);
      if (lookahead == 'm') ADVANCE(702);
      END_STATE();
    case 96:
      if (lookahead == '3') ADVANCE(81);
      END_STATE();
    case 97:
      if (lookahead == '3') ADVANCE(82);
      END_STATE();
    case 98:
      if (lookahead == '3') ADVANCE(83);
      if (lookahead == '6') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(611);
      END_STATE();
    case 99:
      if (lookahead == '4') ADVANCE(1054);
      END_STATE();
    case 100:
      if (lookahead == '4') ADVANCE(1058);
      END_STATE();
    case 101:
      if (lookahead == '4') ADVANCE(989);
      END_STATE();
    case 102:
      if (lookahead == '4') ADVANCE(1020);
      END_STATE();
    case 103:
      if (lookahead == '4') ADVANCE(1028);
      END_STATE();
    case 104:
      if (lookahead == '4') ADVANCE(38);
      END_STATE();
    case 105:
      if (lookahead == '4') ADVANCE(1053);
      END_STATE();
    case 106:
      if (lookahead == '4') ADVANCE(1057);
      END_STATE();
    case 107:
      if (lookahead == '4') ADVANCE(1019);
      END_STATE();
    case 108:
      if (lookahead == '4') ADVANCE(1027);
      END_STATE();
    case 109:
      if (lookahead == '4') ADVANCE(145);
      END_STATE();
    case 110:
      if (lookahead == '4') ADVANCE(19);
      END_STATE();
    case 111:
      if (lookahead == '4') ADVANCE(871);
      END_STATE();
    case 112:
      if (lookahead == '4') ADVANCE(21);
      END_STATE();
    case 113:
      if (lookahead == '4') ADVANCE(155);
      END_STATE();
    case 114:
      if (lookahead == '4') ADVANCE(150);
      END_STATE();
    case 115:
      if (lookahead == '4') ADVANCE(880);
      END_STATE();
    case 116:
      if (lookahead == '4') ADVANCE(881);
      END_STATE();
    case 117:
      if (lookahead == '6') ADVANCE(989);
      END_STATE();
    case 118:
      if (lookahead == '6') ADVANCE(1024);
      END_STATE();
    case 119:
      if (lookahead == '6') ADVANCE(38);
      END_STATE();
    case 120:
      if (lookahead == '6') ADVANCE(1005);
      END_STATE();
    case 121:
      if (lookahead == '6') ADVANCE(1023);
      END_STATE();
    case 122:
      if (lookahead == '6') ADVANCE(866);
      END_STATE();
    case 123:
      if (lookahead == '6') ADVANCE(145);
      END_STATE();
    case 124:
      if (lookahead == '6') ADVANCE(157);
      END_STATE();
    case 125:
      if (lookahead == '6') ADVANCE(37);
      END_STATE();
    case 126:
      if (lookahead == '6') ADVANCE(148);
      END_STATE();
    case 127:
      if (lookahead == '6') ADVANCE(101);
      END_STATE();
    case 128:
      if (lookahead == '6') ADVANCE(149);
      END_STATE();
    case 129:
      if (lookahead == '6') ADVANCE(152);
      END_STATE();
    case 130:
      if (lookahead == '6') ADVANCE(883);
      END_STATE();
    case 131:
      if (lookahead == '6') ADVANCE(873);
      END_STATE();
    case 132:
      if (lookahead == '6') ADVANCE(875);
      END_STATE();
    case 133:
      if (lookahead == '8') ADVANCE(1060);
      END_STATE();
    case 134:
      if (lookahead == '8') ADVANCE(1026);
      END_STATE();
    case 135:
      if (lookahead == '8') ADVANCE(38);
      END_STATE();
    case 136:
      if (lookahead == '8') ADVANCE(1059);
      END_STATE();
    case 137:
      if (lookahead == '8') ADVANCE(1025);
      END_STATE();
    case 138:
      if (lookahead == '8') ADVANCE(145);
      END_STATE();
    case 139:
      if (lookahead == '8') ADVANCE(23);
      END_STATE();
    case 140:
      if (lookahead == '8') ADVANCE(150);
      END_STATE();
    case 141:
      if (lookahead == '8') ADVANCE(869);
      END_STATE();
    case 142:
      if (lookahead == '8') ADVANCE(887);
      END_STATE();
    case 143:
      if (lookahead == ';') ADVANCE(942);
      if (lookahead == '@') ADVANCE(934);
      END_STATE();
    case 144:
      if (lookahead == ';') ADVANCE(948);
      END_STATE();
    case 145:
      if (lookahead == '_') ADVANCE(907);
      END_STATE();
    case 146:
      if (lookahead == '_') ADVANCE(422);
      END_STATE();
    case 147:
      if (lookahead == '_') ADVANCE(454);
      END_STATE();
    case 148:
      if (lookahead == '_') ADVANCE(908);
      END_STATE();
    case 149:
      if (lookahead == '_') ADVANCE(764);
      END_STATE();
    case 150:
      if (lookahead == '_') ADVANCE(909);
      END_STATE();
    case 151:
      if (lookahead == '_') ADVANCE(428);
      END_STATE();
    case 152:
      if (lookahead == '_') ADVANCE(836);
      END_STATE();
    case 153:
      if (lookahead == '_') ADVANCE(431);
      END_STATE();
    case 154:
      if (lookahead == '_') ADVANCE(625);
      END_STATE();
    case 155:
      if (lookahead == '_') ADVANCE(768);
      END_STATE();
    case 156:
      if (lookahead == '_') ADVANCE(768);
      if (lookahead == 'x') ADVANCE(140);
      END_STATE();
    case 157:
      if (lookahead == '_') ADVANCE(768);
      if (lookahead == 'x') ADVANCE(114);
      END_STATE();
    case 158:
      if (lookahead == '_') ADVANCE(768);
      if (lookahead == 'x') ADVANCE(79);
      END_STATE();
    case 159:
      if (lookahead == '_') ADVANCE(421);
      END_STATE();
    case 160:
      if (lookahead == '_') ADVANCE(468);
      END_STATE();
    case 161:
      if (lookahead == '_') ADVANCE(461);
      END_STATE();
    case 162:
      if (lookahead == '_') ADVANCE(488);
      END_STATE();
    case 163:
      if (lookahead == '_') ADVANCE(469);
      END_STATE();
    case 164:
      if (lookahead == '_') ADVANCE(604);
      END_STATE();
    case 165:
      if (lookahead == '_') ADVANCE(809);
      END_STATE();
    case 166:
      if (lookahead == '_') ADVANCE(549);
      END_STATE();
    case 167:
      if (lookahead == '_') ADVANCE(433);
      END_STATE();
    case 168:
      if (lookahead == '_') ADVANCE(495);
      END_STATE();
    case 169:
      if (lookahead == '_') ADVANCE(730);
      END_STATE();
    case 170:
      if (lookahead == '_') ADVANCE(777);
      END_STATE();
    case 171:
      if (lookahead == '_') ADVANCE(491);
      END_STATE();
    case 172:
      if (lookahead == '_') ADVANCE(552);
      END_STATE();
    case 173:
      if (lookahead == '_') ADVANCE(457);
      END_STATE();
    case 174:
      if (lookahead == '_') ADVANCE(627);
      END_STATE();
    case 175:
      if (lookahead == 'a') ADVANCE(804);
      if (lookahead == 'e') ADVANCE(275);
      if (lookahead == 'r') ADVANCE(634);
      END_STATE();
    case 176:
      if (lookahead == 'a') ADVANCE(715);
      END_STATE();
    case 177:
      if (lookahead == 'a') ADVANCE(252);
      if (lookahead == 'h') ADVANCE(363);
      if (lookahead == 'y') ADVANCE(693);
      END_STATE();
    case 178:
      if (lookahead == 'a') ADVANCE(1042);
      END_STATE();
    case 179:
      if (lookahead == 'a') ADVANCE(248);
      if (lookahead == 'c') ADVANCE(367);
      if (lookahead == 'd') ADVANCE(391);
      if (lookahead == 'e') ADVANCE(705);
      if (lookahead == 'f') ADVANCE(527);
      if (lookahead == 'g') ADVANCE(904);
      if (lookahead == 'l') ADVANCE(645);
      if (lookahead == 'm') ADVANCE(200);
      if (lookahead == 'n') ADVANCE(335);
      if (lookahead == 'r') ADVANCE(368);
      if (lookahead == 's') ADVANCE(708);
      if (lookahead == 't') ADVANCE(753);
      END_STATE();
    case 180:
      if (lookahead == 'a') ADVANCE(248);
      if (lookahead == 'c') ADVANCE(367);
      if (lookahead == 'd') ADVANCE(460);
      if (lookahead == 'e') ADVANCE(705);
      if (lookahead == 'f') ADVANCE(527);
      if (lookahead == 'g') ADVANCE(904);
      if (lookahead == 'l') ADVANCE(645);
      if (lookahead == 'm') ADVANCE(200);
      if (lookahead == 'n') ADVANCE(335);
      if (lookahead == 'p') ADVANCE(749);
      if (lookahead == 'r') ADVANCE(414);
      if (lookahead == 's') ADVANCE(708);
      if (lookahead == 't') ADVANCE(753);
      END_STATE();
    case 181:
      if (lookahead == 'a') ADVANCE(317);
      if (lookahead == 'c') ADVANCE(646);
      if (lookahead == 'd') ADVANCE(462);
      if (lookahead == 'e') ADVANCE(706);
      if (lookahead == 'g') ADVANCE(905);
      if (lookahead == 'l') ADVANCE(647);
      if (lookahead == 'm') ADVANCE(840);
      if (lookahead == 'n') ADVANCE(329);
      if (lookahead == 'o') ADVANCE(709);
      if (lookahead == 'p') ADVANCE(638);
      if (lookahead == 'r') ADVANCE(336);
      if (lookahead == 's') ADVANCE(448);
      if (lookahead == 't') ADVANCE(759);
      if (lookahead == 'w') ADVANCE(727);
      if (lookahead == 'x') ADVANCE(643);
      END_STATE();
    case 182:
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == 'b') ADVANCE(482);
      if (lookahead == 'e') ADVANCE(704);
      if (lookahead == 'g') ADVANCE(905);
      if (lookahead == 'l') ADVANCE(652);
      if (lookahead == 'm') ADVANCE(203);
      if (lookahead == 'n') ADVANCE(208);
      if (lookahead == 's') ADVANCE(446);
      if (lookahead == 'w') ADVANCE(474);
      END_STATE();
    case 183:
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == 'b') ADVANCE(482);
      if (lookahead == 'e') ADVANCE(704);
      if (lookahead == 'g') ADVANCE(905);
      if (lookahead == 'l') ADVANCE(654);
      if (lookahead == 'm') ADVANCE(203);
      if (lookahead == 'n') ADVANCE(342);
      if (lookahead == 's') ADVANCE(446);
      if (lookahead == 't') ADVANCE(763);
      if (lookahead == 'w') ADVANCE(500);
      END_STATE();
    case 184:
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == 'b') ADVANCE(482);
      if (lookahead == 'e') ADVANCE(704);
      if (lookahead == 'm') ADVANCE(203);
      if (lookahead == 'n') ADVANCE(245);
      if (lookahead == 's') ADVANCE(447);
      if (lookahead == 'g' ||
          lookahead == 'l') ADVANCE(905);
      END_STATE();
    case 185:
      if (lookahead == 'a') ADVANCE(316);
      if (lookahead == 'c') ADVANCE(569);
      if (lookahead == 'o') ADVANCE(709);
      if (lookahead == 's') ADVANCE(837);
      if (lookahead == 'x') ADVANCE(277);
      END_STATE();
    case 186:
      if (lookahead == 'a') ADVANCE(1041);
      END_STATE();
    case 187:
      if (lookahead == 'a') ADVANCE(519);
      END_STATE();
    case 188:
      if (lookahead == 'a') ADVANCE(581);
      if (lookahead == 'o') ADVANCE(683);
      END_STATE();
    case 189:
      if (lookahead == 'a') ADVANCE(581);
      if (lookahead == 'o') ADVANCE(683);
      if (lookahead == 'u') ADVANCE(522);
      END_STATE();
    case 190:
      if (lookahead == 'a') ADVANCE(725);
      END_STATE();
    case 191:
      if (lookahead == 'a') ADVANCE(775);
      if (lookahead == 'e') ADVANCE(876);
      if (lookahead == 'f') ADVANCE(843);
      if (lookahead == 'i') ADVANCE(779);
      if (lookahead == 'n') ADVANCE(847);
      END_STATE();
    case 192:
      if (lookahead == 'a') ADVANCE(713);
      END_STATE();
    case 193:
      if (lookahead == 'a') ADVANCE(561);
      END_STATE();
    case 194:
      if (lookahead == 'a') ADVANCE(286);
      END_STATE();
    case 195:
      if (lookahead == 'a') ADVANCE(686);
      END_STATE();
    case 196:
      if (lookahead == 'a') ADVANCE(32);
      END_STATE();
    case 197:
      if (lookahead == 'a') ADVANCE(290);
      END_STATE();
    case 198:
      if (lookahead == 'a') ADVANCE(300);
      END_STATE();
    case 199:
      if (lookahead == 'a') ADVANCE(865);
      if (lookahead == 'i') ADVANCE(582);
      END_STATE();
    case 200:
      if (lookahead == 'a') ADVANCE(865);
      if (lookahead == 'i') ADVANCE(582);
      if (lookahead == 'u') ADVANCE(506);
      END_STATE();
    case 201:
      if (lookahead == 'a') ADVANCE(510);
      END_STATE();
    case 202:
      if (lookahead == 'a') ADVANCE(301);
      END_STATE();
    case 203:
      if (lookahead == 'a') ADVANCE(867);
      if (lookahead == 'i') ADVANCE(590);
      if (lookahead == 'u') ADVANCE(506);
      END_STATE();
    case 204:
      if (lookahead == 'a') ADVANCE(766);
      END_STATE();
    case 205:
      if (lookahead == 'a') ADVANCE(302);
      END_STATE();
    case 206:
      if (lookahead == 'a') ADVANCE(511);
      END_STATE();
    case 207:
      if (lookahead == 'a') ADVANCE(315);
      if (lookahead == 'l') ADVANCE(663);
      if (lookahead == 'm') ADVANCE(840);
      if (lookahead == 'n') ADVANCE(360);
      if (lookahead == 's') ADVANCE(445);
      END_STATE();
    case 208:
      if (lookahead == 'a') ADVANCE(752);
      if (lookahead == 'e') ADVANCE(998);
      END_STATE();
    case 209:
      if (lookahead == 'a') ADVANCE(617);
      END_STATE();
    case 210:
      if (lookahead == 'a') ADVANCE(597);
      if (lookahead == 'b') ADVANCE(480);
      if (lookahead == 'c') ADVANCE(662);
      if (lookahead == 'l') ADVANCE(651);
      if (lookahead == 'n') ADVANCE(650);
      if (lookahead == 'o') ADVANCE(709);
      if (lookahead == 's') ADVANCE(831);
      if (lookahead == 'x') ADVANCE(643);
      END_STATE();
    case 211:
      if (lookahead == 'a') ADVANCE(305);
      END_STATE();
    case 212:
      if (lookahead == 'a') ADVANCE(314);
      END_STATE();
    case 213:
      if (lookahead == 'a') ADVANCE(515);
      END_STATE();
    case 214:
      if (lookahead == 'a') ADVANCE(312);
      END_STATE();
    case 215:
      if (lookahead == 'a') ADVANCE(525);
      END_STATE();
    case 216:
      if (lookahead == 'a') ADVANCE(528);
      END_STATE();
    case 217:
      if (lookahead == 'a') ADVANCE(308);
      END_STATE();
    case 218:
      if (lookahead == 'a') ADVANCE(516);
      END_STATE();
    case 219:
      if (lookahead == 'a') ADVANCE(319);
      END_STATE();
    case 220:
      if (lookahead == 'a') ADVANCE(309);
      END_STATE();
    case 221:
      if (lookahead == 'a') ADVANCE(830);
      if (lookahead == 'c') ADVANCE(644);
      if (lookahead == 'f') ADVANCE(493);
      if (lookahead == 'g') ADVANCE(733);
      if (lookahead == 'i') ADVANCE(622);
      if (lookahead == 's') ADVANCE(463);
      END_STATE();
    case 222:
      if (lookahead == 'a') ADVANCE(310);
      END_STATE();
    case 223:
      if (lookahead == 'a') ADVANCE(613);
      END_STATE();
    case 224:
      if (lookahead == 'a') ADVANCE(793);
      END_STATE();
    case 225:
      if (lookahead == 'a') ADVANCE(799);
      END_STATE();
    case 226:
      if (lookahead == 'a') ADVANCE(810);
      END_STATE();
    case 227:
      if (lookahead == 'a') ADVANCE(812);
      if (lookahead == 'e') ADVANCE(275);
      if (lookahead == 'r') ADVANCE(634);
      END_STATE();
    case 228:
      if (lookahead == 'a') ADVANCE(812);
      if (lookahead == 'r') ADVANCE(634);
      END_STATE();
    case 229:
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 'c') ADVANCE(393);
      if (lookahead == 'd') ADVANCE(460);
      if (lookahead == 'e') ADVANCE(704);
      if (lookahead == 'f') ADVANCE(548);
      if (lookahead == 'g') ADVANCE(904);
      if (lookahead == 'l') ADVANCE(904);
      if (lookahead == 'm') ADVANCE(200);
      if (lookahead == 'n') ADVANCE(351);
      if (lookahead == 'p') ADVANCE(562);
      if (lookahead == 's') ADVANCE(697);
      if (lookahead == 't') ADVANCE(761);
      END_STATE();
    case 230:
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 'c') ADVANCE(392);
      if (lookahead == 'd') ADVANCE(460);
      if (lookahead == 'e') ADVANCE(704);
      if (lookahead == 'f') ADVANCE(548);
      if (lookahead == 'g') ADVANCE(904);
      if (lookahead == 'l') ADVANCE(904);
      if (lookahead == 'm') ADVANCE(200);
      if (lookahead == 'n') ADVANCE(351);
      if (lookahead == 'p') ADVANCE(562);
      if (lookahead == 's') ADVANCE(697);
      if (lookahead == 't') ADVANCE(761);
      END_STATE();
    case 231:
      if (lookahead == 'a') ADVANCE(323);
      if (lookahead == 'c') ADVANCE(579);
      if (lookahead == 'o') ADVANCE(731);
      if (lookahead == 's') ADVANCE(838);
      if (lookahead == 'x') ADVANCE(293);
      END_STATE();
    case 232:
      if (lookahead == 'a') ADVANCE(732);
      END_STATE();
    case 233:
      if (lookahead == 'a') ADVANCE(280);
      END_STATE();
    case 234:
      if (lookahead == 'a') ADVANCE(614);
      END_STATE();
    case 235:
      if (lookahead == 'a') ADVANCE(821);
      END_STATE();
    case 236:
      if (lookahead == 'a') ADVANCE(813);
      END_STATE();
    case 237:
      if (lookahead == 'a') ADVANCE(813);
      if (lookahead == 'e') ADVANCE(275);
      END_STATE();
    case 238:
      if (lookahead == 'a') ADVANCE(485);
      END_STATE();
    case 239:
      if (lookahead == 'a') ADVANCE(537);
      END_STATE();
    case 240:
      if (lookahead == 'a') ADVANCE(256);
      END_STATE();
    case 241:
      if (lookahead == 'a') ADVANCE(257);
      END_STATE();
    case 242:
      if (lookahead == 'a') ADVANCE(259);
      END_STATE();
    case 243:
      if (lookahead == 'a') ADVANCE(260);
      if (lookahead == 'y') ADVANCE(693);
      END_STATE();
    case 244:
      if (lookahead == 'a') ADVANCE(318);
      if (lookahead == 'c') ADVANCE(646);
      if (lookahead == 'd') ADVANCE(462);
      if (lookahead == 'e') ADVANCE(707);
      if (lookahead == 'g') ADVANCE(905);
      if (lookahead == 'l') ADVANCE(649);
      if (lookahead == 'm') ADVANCE(840);
      if (lookahead == 'n') ADVANCE(329);
      if (lookahead == 'o') ADVANCE(709);
      if (lookahead == 'p') ADVANCE(638);
      if (lookahead == 'r') ADVANCE(413);
      if (lookahead == 's') ADVANCE(449);
      if (lookahead == 't') ADVANCE(759);
      if (lookahead == 'x') ADVANCE(643);
      END_STATE();
    case 245:
      if (lookahead == 'a') ADVANCE(758);
      if (lookahead == 'e') ADVANCE(998);
      END_STATE();
    case 246:
      if (lookahead == 'b') ADVANCE(989);
      END_STATE();
    case 247:
      if (lookahead == 'b') ADVANCE(994);
      END_STATE();
    case 248:
      if (lookahead == 'b') ADVANCE(764);
      if (lookahead == 'd') ADVANCE(298);
      END_STATE();
    case 249:
      if (lookahead == 'b') ADVANCE(765);
      if (lookahead == 'd') ADVANCE(298);
      END_STATE();
    case 250:
      if (lookahead == 'b') ADVANCE(765);
      if (lookahead == 'd') ADVANCE(313);
      if (lookahead == 'l') ADVANCE(521);
      if (lookahead == 'n') ADVANCE(894);
      if (lookahead == 'v') ADVANCE(439);
      END_STATE();
    case 251:
      if (lookahead == 'b') ADVANCE(152);
      END_STATE();
    case 252:
      if (lookahead == 'b') ADVANCE(530);
      END_STATE();
    case 253:
      if (lookahead == 'b') ADVANCE(479);
      END_STATE();
    case 254:
      if (lookahead == 'b') ADVANCE(206);
      END_STATE();
    case 255:
      if (lookahead == 'b') ADVANCE(215);
      END_STATE();
    case 256:
      if (lookahead == 'b') ADVANCE(540);
      END_STATE();
    case 257:
      if (lookahead == 'b') ADVANCE(534);
      END_STATE();
    case 258:
      if (lookahead == 'b') ADVANCE(218);
      END_STATE();
    case 259:
      if (lookahead == 'b') ADVANCE(541);
      END_STATE();
    case 260:
      if (lookahead == 'b') ADVANCE(542);
      END_STATE();
    case 261:
      if (lookahead == 'c') ADVANCE(989);
      END_STATE();
    case 262:
      if (lookahead == 'c') ADVANCE(501);
      END_STATE();
    case 263:
      if (lookahead == 'c') ADVANCE(959);
      END_STATE();
    case 264:
      if (lookahead == 'c') ADVANCE(1001);
      END_STATE();
    case 265:
      if (lookahead == 'c') ADVANCE(1062);
      END_STATE();
    case 266:
      if (lookahead == 'c') ADVANCE(1010);
      END_STATE();
    case 267:
      if (lookahead == 'c') ADVANCE(1048);
      END_STATE();
    case 268:
      if (lookahead == 'c') ADVANCE(34);
      END_STATE();
    case 269:
      if (lookahead == 'c') ADVANCE(960);
      END_STATE();
    case 270:
      if (lookahead == 'c') ADVANCE(961);
      END_STATE();
    case 271:
      if (lookahead == 'c') ADVANCE(958);
      END_STATE();
    case 272:
      if (lookahead == 'c') ADVANCE(35);
      END_STATE();
    case 273:
      if (lookahead == 'c') ADVANCE(28);
      END_STATE();
    case 274:
      if (lookahead == 'c') ADVANCE(29);
      END_STATE();
    case 275:
      if (lookahead == 'c') ADVANCE(547);
      END_STATE();
    case 276:
      if (lookahead == 'c') ADVANCE(451);
      END_STATE();
    case 277:
      if (lookahead == 'c') ADVANCE(451);
      if (lookahead == 'o') ADVANCE(709);
      END_STATE();
    case 278:
      if (lookahead == 'c') ADVANCE(146);
      END_STATE();
    case 279:
      if (lookahead == 'c') ADVANCE(790);
      END_STATE();
    case 280:
      if (lookahead == 'c') ADVANCE(801);
      END_STATE();
    case 281:
      if (lookahead == 'c') ADVANCE(170);
      END_STATE();
    case 282:
      if (lookahead == 'c') ADVANCE(33);
      END_STATE();
    case 283:
      if (lookahead == 'c') ADVANCE(329);
      END_STATE();
    case 284:
      if (lookahead == 'c') ADVANCE(642);
      if (lookahead == 'f') ADVANCE(492);
      if (lookahead == 'g') ADVANCE(385);
      if (lookahead == 'i') ADVANCE(620);
      if (lookahead == 's') ADVANCE(384);
      END_STATE();
    case 285:
      if (lookahead == 'c') ADVANCE(783);
      END_STATE();
    case 286:
      if (lookahead == 'c') ADVANCE(411);
      END_STATE();
    case 287:
      if (lookahead == 'c') ADVANCE(602);
      END_STATE();
    case 288:
      if (lookahead == 'c') ADVANCE(798);
      END_STATE();
    case 289:
      if (lookahead == 'c') ADVANCE(201);
      if (lookahead == 'o') ADVANCE(684);
      END_STATE();
    case 290:
      if (lookahead == 'c') ADVANCE(458);
      END_STATE();
    case 291:
      if (lookahead == 'c') ADVANCE(36);
      END_STATE();
    case 292:
      if (lookahead == 'c') ADVANCE(452);
      END_STATE();
    case 293:
      if (lookahead == 'c') ADVANCE(452);
      if (lookahead == 'o') ADVANCE(731);
      END_STATE();
    case 294:
      if (lookahead == 'c') ADVANCE(213);
      END_STATE();
    case 295:
      if (lookahead == 'c') ADVANCE(216);
      if (lookahead == 'o') ADVANCE(684);
      END_STATE();
    case 296:
      if (lookahead == 'c') ADVANCE(239);
      END_STATE();
    case 297:
      if (lookahead == 'd') ADVANCE(938);
      END_STATE();
    case 298:
      if (lookahead == 'd') ADVANCE(989);
      END_STATE();
    case 299:
      if (lookahead == 'd') ADVANCE(1071);
      END_STATE();
    case 300:
      if (lookahead == 'd') ADVANCE(1005);
      END_STATE();
    case 301:
      if (lookahead == 'd') ADVANCE(1007);
      END_STATE();
    case 302:
      if (lookahead == 'd') ADVANCE(1006);
      END_STATE();
    case 303:
      if (lookahead == 'd') ADVANCE(999);
      END_STATE();
    case 304:
      if (lookahead == 'd') ADVANCE(1014);
      END_STATE();
    case 305:
      if (lookahead == 'd') ADVANCE(1011);
      END_STATE();
    case 306:
      if (lookahead == 'd') ADVANCE(54);
      END_STATE();
    case 307:
      if (lookahead == 'd') ADVANCE(53);
      END_STATE();
    case 308:
      if (lookahead == 'd') ADVANCE(96);
      END_STATE();
    case 309:
      if (lookahead == 'd') ADVANCE(993);
      END_STATE();
    case 310:
      if (lookahead == 'd') ADVANCE(992);
      END_STATE();
    case 311:
      if (lookahead == 'd') ADVANCE(848);
      END_STATE();
    case 312:
      if (lookahead == 'd') ADVANCE(51);
      END_STATE();
    case 313:
      if (lookahead == 'd') ADVANCE(994);
      END_STATE();
    case 314:
      if (lookahead == 'd') ADVANCE(141);
      END_STATE();
    case 315:
      if (lookahead == 'd') ADVANCE(298);
      END_STATE();
    case 316:
      if (lookahead == 'd') ADVANCE(298);
      if (lookahead == 'n') ADVANCE(298);
      END_STATE();
    case 317:
      if (lookahead == 'd') ADVANCE(298);
      if (lookahead == 'n') ADVANCE(298);
      if (lookahead == 't') ADVANCE(659);
      END_STATE();
    case 318:
      if (lookahead == 'd') ADVANCE(298);
      if (lookahead == 'n') ADVANCE(298);
      if (lookahead == 't') ADVANCE(664);
      END_STATE();
    case 319:
      if (lookahead == 'd') ADVANCE(155);
      END_STATE();
    case 320:
      if (lookahead == 'd') ADVANCE(494);
      END_STATE();
    case 321:
      if (lookahead == 'd') ADVANCE(728);
      END_STATE();
    case 322:
      if (lookahead == 'd') ADVANCE(152);
      END_STATE();
    case 323:
      if (lookahead == 'd') ADVANCE(322);
      if (lookahead == 'n') ADVANCE(322);
      END_STATE();
    case 324:
      if (lookahead == 'd') ADVANCE(386);
      END_STATE();
    case 325:
      if (lookahead == 'd') ADVANCE(412);
      END_STATE();
    case 326:
      if (lookahead == 'e') ADVANCE(567);
      END_STATE();
    case 327:
      if (lookahead == 'e') ADVANCE(567);
      if (lookahead == 'o') ADVANCE(311);
      if (lookahead == 'u') ADVANCE(782);
      END_STATE();
    case 328:
      if (lookahead == 'e') ADVANCE(418);
      END_STATE();
    case 329:
      if (lookahead == 'e') ADVANCE(989);
      END_STATE();
    case 330:
      if (lookahead == 'e') ADVANCE(419);
      END_STATE();
    case 331:
      if (lookahead == 'e') ADVANCE(940);
      END_STATE();
    case 332:
      if (lookahead == 'e') ADVANCE(1015);
      END_STATE();
    case 333:
      if (lookahead == 'e') ADVANCE(1001);
      END_STATE();
    case 334:
      if (lookahead == 'e') ADVANCE(970);
      END_STATE();
    case 335:
      if (lookahead == 'e') ADVANCE(996);
      END_STATE();
    case 336:
      if (lookahead == 'e') ADVANCE(498);
      if (lookahead == 'o') ADVANCE(791);
      END_STATE();
    case 337:
      if (lookahead == 'e') ADVANCE(1043);
      END_STATE();
    case 338:
      if (lookahead == 'e') ADVANCE(1046);
      END_STATE();
    case 339:
      if (lookahead == 'e') ADVANCE(1031);
      END_STATE();
    case 340:
      if (lookahead == 'e') ADVANCE(986);
      END_STATE();
    case 341:
      if (lookahead == 'e') ADVANCE(1005);
      END_STATE();
    case 342:
      if (lookahead == 'e') ADVANCE(998);
      END_STATE();
    case 343:
      if (lookahead == 'e') ADVANCE(1010);
      END_STATE();
    case 344:
      if (lookahead == 'e') ADVANCE(1004);
      END_STATE();
    case 345:
      if (lookahead == 'e') ADVANCE(1033);
      END_STATE();
    case 346:
      if (lookahead == 'e') ADVANCE(1038);
      END_STATE();
    case 347:
      if (lookahead == 'e') ADVANCE(429);
      END_STATE();
    case 348:
      if (lookahead == 'e') ADVANCE(969);
      END_STATE();
    case 349:
      if (lookahead == 'e') ADVANCE(781);
      if (lookahead == 'o') ADVANCE(289);
      END_STATE();
    case 350:
      if (lookahead == 'e') ADVANCE(781);
      if (lookahead == 'o') ADVANCE(295);
      END_STATE();
    case 351:
      if (lookahead == 'e') ADVANCE(997);
      END_STATE();
    case 352:
      if (lookahead == 'e') ADVANCE(1009);
      END_STATE();
    case 353:
      if (lookahead == 'e') ADVANCE(1008);
      END_STATE();
    case 354:
      if (lookahead == 'e') ADVANCE(991);
      END_STATE();
    case 355:
      if (lookahead == 'e') ADVANCE(990);
      END_STATE();
    case 356:
      if (lookahead == 'e') ADVANCE(523);
      END_STATE();
    case 357:
      if (lookahead == 'e') ADVANCE(523);
      if (lookahead == 'h') ADVANCE(190);
      END_STATE();
    case 358:
      if (lookahead == 'e') ADVANCE(523);
      if (lookahead == 'h') ADVANCE(190);
      if (lookahead == 't') ADVANCE(192);
      END_STATE();
    case 359:
      if (lookahead == 'e') ADVANCE(559);
      if (lookahead == 's') ADVANCE(331);
      END_STATE();
    case 360:
      if (lookahead == 'e') ADVANCE(435);
      END_STATE();
    case 361:
      if (lookahead == 'e') ADVANCE(279);
      END_STATE();
    case 362:
      if (lookahead == 'e') ADVANCE(299);
      END_STATE();
    case 363:
      if (lookahead == 'e') ADVANCE(583);
      END_STATE();
    case 364:
      if (lookahead == 'e') ADVANCE(560);
      END_STATE();
    case 365:
      if (lookahead == 'e') ADVANCE(720);
      END_STATE();
    case 366:
      if (lookahead == 'e') ADVANCE(720);
      if (lookahead == 'r') ADVANCE(233);
      END_STATE();
    case 367:
      if (lookahead == 'e') ADVANCE(471);
      if (lookahead == 'o') ADVANCE(588);
      END_STATE();
    case 368:
      if (lookahead == 'e') ADVANCE(476);
      END_STATE();
    case 369:
      if (lookahead == 'e') ADVANCE(416);
      END_STATE();
    case 370:
      if (lookahead == 'e') ADVANCE(788);
      END_STATE();
    case 371:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 372:
      if (lookahead == 'e') ADVANCE(197);
      END_STATE();
    case 373:
      if (lookahead == 'e') ADVANCE(153);
      END_STATE();
    case 374:
      if (lookahead == 'e') ADVANCE(25);
      END_STATE();
    case 375:
      if (lookahead == 'e') ADVANCE(423);
      END_STATE();
    case 376:
      if (lookahead == 'e') ADVANCE(568);
      END_STATE();
    case 377:
      if (lookahead == 'e') ADVANCE(568);
      if (lookahead == 's') ADVANCE(331);
      END_STATE();
    case 378:
      if (lookahead == 'e') ADVANCE(424);
      END_STATE();
    case 379:
      if (lookahead == 'e') ADVANCE(563);
      END_STATE();
    case 380:
      if (lookahead == 'e') ADVANCE(726);
      END_STATE();
    case 381:
      if (lookahead == 'e') ADVANCE(605);
      END_STATE();
    case 382:
      if (lookahead == 'e') ADVANCE(784);
      END_STATE();
    case 383:
      if (lookahead == 'e') ADVANCE(607);
      END_STATE();
    case 384:
      if (lookahead == 'e') ADVANCE(795);
      if (lookahead == 'i') ADVANCE(898);
      END_STATE();
    case 385:
      if (lookahead == 'e') ADVANCE(795);
      if (lookahead == 'r') ADVANCE(632);
      END_STATE();
    case 386:
      if (lookahead == 'e') ADVANCE(598);
      END_STATE();
    case 387:
      if (lookahead == 'e') ADVANCE(826);
      END_STATE();
    case 388:
      if (lookahead == 'e') ADVANCE(333);
      END_STATE();
    case 389:
      if (lookahead == 'e') ADVANCE(807);
      END_STATE();
    case 390:
      if (lookahead == 'e') ADVANCE(806);
      END_STATE();
    case 391:
      if (lookahead == 'e') ADVANCE(573);
      if (lookahead == 'i') ADVANCE(855);
      END_STATE();
    case 392:
      if (lookahead == 'e') ADVANCE(475);
      END_STATE();
    case 393:
      if (lookahead == 'e') ADVANCE(475);
      if (lookahead == 'o') ADVANCE(592);
      END_STATE();
    case 394:
      if (lookahead == 'e') ADVANCE(803);
      END_STATE();
    case 395:
      if (lookahead == 'e') ADVANCE(575);
      END_STATE();
    case 396:
      if (lookahead == 'e') ADVANCE(288);
      END_STATE();
    case 397:
      if (lookahead == 'e') ADVANCE(735);
      END_STATE();
    case 398:
      if (lookahead == 'e') ADVANCE(769);
      END_STATE();
    case 399:
      if (lookahead == 'e') ADVANCE(285);
      END_STATE();
    case 400:
      if (lookahead == 'e') ADVANCE(737);
      END_STATE();
    case 401:
      if (lookahead == 'e') ADVANCE(773);
      END_STATE();
    case 402:
      if (lookahead == 'e') ADVANCE(616);
      END_STATE();
    case 403:
      if (lookahead == 'e') ADVANCE(736);
      END_STATE();
    case 404:
      if (lookahead == 'e') ADVANCE(554);
      END_STATE();
    case 405:
      if (lookahead == 'e') ADVANCE(754);
      END_STATE();
    case 406:
      if (lookahead == 'e') ADVANCE(577);
      if (lookahead == 'o') ADVANCE(311);
      END_STATE();
    case 407:
      if (lookahead == 'e') ADVANCE(756);
      END_STATE();
    case 408:
      if (lookahead == 'e') ADVANCE(760);
      END_STATE();
    case 409:
      if (lookahead == 'e') ADVANCE(825);
      END_STATE();
    case 410:
      if (lookahead == 'e') ADVANCE(762);
      END_STATE();
    case 411:
      if (lookahead == 'e') ADVANCE(172);
      END_STATE();
    case 412:
      if (lookahead == 'e') ADVANCE(630);
      END_STATE();
    case 413:
      if (lookahead == 'e') ADVANCE(499);
      if (lookahead == 'o') ADVANCE(791);
      END_STATE();
    case 414:
      if (lookahead == 'e') ADVANCE(497);
      END_STATE();
    case 415:
      if (lookahead == 'f') ADVANCE(972);
      END_STATE();
    case 416:
      if (lookahead == 'f') ADVANCE(989);
      END_STATE();
    case 417:
      if (lookahead == 'f') ADVANCE(767);
      END_STATE();
    case 418:
      if (lookahead == 'f') ADVANCE(1065);
      if (lookahead == 'p') ADVANCE(526);
      if (lookahead == 's') ADVANCE(839);
      if (lookahead == 't') ADVANCE(845);
      END_STATE();
    case 419:
      if (lookahead == 'f') ADVANCE(1065);
      if (lookahead == 's') ADVANCE(839);
      if (lookahead == 't') ADVANCE(845);
      END_STATE();
    case 420:
      if (lookahead == 'f') ADVANCE(1001);
      END_STATE();
    case 421:
      if (lookahead == 'f') ADVANCE(88);
      END_STATE();
    case 422:
      if (lookahead == 'f') ADVANCE(88);
      if (lookahead == 's') ADVANCE(226);
      END_STATE();
    case 423:
      if (lookahead == 'f') ADVANCE(1064);
      END_STATE();
    case 424:
      if (lookahead == 'f') ADVANCE(1063);
      END_STATE();
    case 425:
      if (lookahead == 'f') ADVANCE(417);
      END_STATE();
    case 426:
      if (lookahead == 'f') ADVANCE(432);
      END_STATE();
    case 427:
      if (lookahead == 'f') ADVANCE(889);
      END_STATE();
    case 428:
      if (lookahead == 'f') ADVANCE(127);
      END_STATE();
    case 429:
      if (lookahead == 'f') ADVANCE(22);
      if (lookahead == 't') ADVANCE(845);
      END_STATE();
    case 430:
      if (lookahead == 'f') ADVANCE(402);
      END_STATE();
    case 431:
      if (lookahead == 'f') ADVANCE(89);
      END_STATE();
    case 432:
      if (lookahead == 'f') ADVANCE(539);
      END_STATE();
    case 433:
      if (lookahead == 'f') ADVANCE(97);
      END_STATE();
    case 434:
      if (lookahead == 'g') ADVANCE(989);
      END_STATE();
    case 435:
      if (lookahead == 'g') ADVANCE(1010);
      END_STATE();
    case 436:
      if (lookahead == 'g') ADVANCE(456);
      END_STATE();
    case 437:
      if (lookahead == 'g') ADVANCE(584);
      END_STATE();
    case 438:
      if (lookahead == 'g') ADVANCE(582);
      END_STATE();
    case 439:
      if (lookahead == 'g') ADVANCE(712);
      END_STATE();
    case 440:
      if (lookahead == 'g') ADVANCE(152);
      END_STATE();
    case 441:
      if (lookahead == 'g') ADVANCE(382);
      if (lookahead == 's') ADVANCE(382);
      END_STATE();
    case 442:
      if (lookahead == 'g') ADVANCE(382);
      if (lookahead == 's') ADVANCE(382);
      if (lookahead == 't') ADVANCE(388);
      END_STATE();
    case 443:
      if (lookahead == 'g') ADVANCE(455);
      END_STATE();
    case 444:
      if (lookahead == 'h') ADVANCE(842);
      END_STATE();
    case 445:
      if (lookahead == 'h') ADVANCE(507);
      if (lookahead == 'p') ADVANCE(538);
      if (lookahead == 'u') ADVANCE(246);
      END_STATE();
    case 446:
      if (lookahead == 'h') ADVANCE(507);
      if (lookahead == 'p') ADVANCE(538);
      if (lookahead == 'u') ADVANCE(247);
      END_STATE();
    case 447:
      if (lookahead == 'h') ADVANCE(507);
      if (lookahead == 'p') ADVANCE(538);
      if (lookahead == 'u') ADVANCE(247);
      if (lookahead == 'w') ADVANCE(464);
      END_STATE();
    case 448:
      if (lookahead == 'h') ADVANCE(507);
      if (lookahead == 't') ADVANCE(671);
      if (lookahead == 'u') ADVANCE(246);
      END_STATE();
    case 449:
      if (lookahead == 'h') ADVANCE(507);
      if (lookahead == 't') ADVANCE(673);
      if (lookahead == 'u') ADVANCE(246);
      END_STATE();
    case 450:
      if (lookahead == 'h') ADVANCE(190);
      END_STATE();
    case 451:
      if (lookahead == 'h') ADVANCE(434);
      END_STATE();
    case 452:
      if (lookahead == 'h') ADVANCE(440);
      END_STATE();
    case 453:
      if (lookahead == 'h') ADVANCE(571);
      END_STATE();
    case 454:
      if (lookahead == 'h') ADVANCE(466);
      if (lookahead == 'l') ADVANCE(681);
      END_STATE();
    case 455:
      if (lookahead == 'h') ADVANCE(162);
      END_STATE();
    case 456:
      if (lookahead == 'h') ADVANCE(163);
      END_STATE();
    case 457:
      if (lookahead == 'h') ADVANCE(496);
      if (lookahead == 'l') ADVANCE(678);
      END_STATE();
    case 458:
      if (lookahead == 'h') ADVANCE(241);
      END_STATE();
    case 459:
      if (lookahead == 'i') ADVANCE(437);
      END_STATE();
    case 460:
      if (lookahead == 'i') ADVANCE(855);
      END_STATE();
    case 461:
      if (lookahead == 'i') ADVANCE(88);
      END_STATE();
    case 462:
      if (lookahead == 'i') ADVANCE(856);
      END_STATE();
    case 463:
      if (lookahead == 'i') ADVANCE(898);
      END_STATE();
    case 464:
      if (lookahead == 'i') ADVANCE(897);
      END_STATE();
    case 465:
      if (lookahead == 'i') ADVANCE(420);
      if (lookahead == 'o') ADVANCE(585);
      if (lookahead == 't') ADVANCE(240);
      END_STATE();
    case 466:
      if (lookahead == 'i') ADVANCE(436);
      END_STATE();
    case 467:
      if (lookahead == 'i') ADVANCE(272);
      END_STATE();
    case 468:
      if (lookahead == 'i') ADVANCE(127);
      END_STATE();
    case 469:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 470:
      if (lookahead == 'i') ADVANCE(594);
      if (lookahead == 'r') ADVANCE(369);
      END_STATE();
    case 471:
      if (lookahead == 'i') ADVANCE(506);
      END_STATE();
    case 472:
      if (lookahead == 'i') ADVANCE(427);
      END_STATE();
    case 473:
      if (lookahead == 'i') ADVANCE(273);
      END_STATE();
    case 474:
      if (lookahead == 'i') ADVANCE(324);
      END_STATE();
    case 475:
      if (lookahead == 'i') ADVANCE(513);
      END_STATE();
    case 476:
      if (lookahead == 'i') ADVANCE(618);
      END_STATE();
    case 477:
      if (lookahead == 'i') ADVANCE(800);
      END_STATE();
    case 478:
      if (lookahead == 'i') ADVANCE(274);
      END_STATE();
    case 479:
      if (lookahead == 'i') ADVANCE(600);
      END_STATE();
    case 480:
      if (lookahead == 'i') ADVANCE(817);
      END_STATE();
    case 481:
      if (lookahead == 'i') ADVANCE(267);
      END_STATE();
    case 482:
      if (lookahead == 'i') ADVANCE(805);
      END_STATE();
    case 483:
      if (lookahead == 'i') ADVANCE(784);
      END_STATE();
    case 484:
      if (lookahead == 'i') ADVANCE(796);
      END_STATE();
    case 485:
      if (lookahead == 'i') ADVANCE(818);
      END_STATE();
    case 486:
      if (lookahead == 'i') ADVANCE(438);
      END_STATE();
    case 487:
      if (lookahead == 'i') ADVANCE(87);
      END_STATE();
    case 488:
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 489:
      if (lookahead == 'i') ADVANCE(294);
      END_STATE();
    case 490:
      if (lookahead == 'i') ADVANCE(291);
      END_STATE();
    case 491:
      if (lookahead == 'i') ADVANCE(89);
      END_STATE();
    case 492:
      if (lookahead == 'i') ADVANCE(535);
      END_STATE();
    case 493:
      if (lookahead == 'i') ADVANCE(529);
      END_STATE();
    case 494:
      if (lookahead == 'i') ADVANCE(750);
      END_STATE();
    case 495:
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 496:
      if (lookahead == 'i') ADVANCE(443);
      END_STATE();
    case 497:
      if (lookahead == 'i') ADVANCE(626);
      END_STATE();
    case 498:
      if (lookahead == 'i') ADVANCE(628);
      if (lookahead == 'm') ADVANCE(145);
      END_STATE();
    case 499:
      if (lookahead == 'i') ADVANCE(629);
      if (lookahead == 'm') ADVANCE(145);
      END_STATE();
    case 500:
      if (lookahead == 'i') ADVANCE(325);
      END_STATE();
    case 501:
      if (lookahead == 'k') ADVANCE(937);
      END_STATE();
    case 502:
      if (lookahead == 'k') ADVANCE(1010);
      END_STATE();
    case 503:
      if (lookahead == 'l') ADVANCE(459);
      if (lookahead == 't') ADVANCE(635);
      END_STATE();
    case 504:
      if (lookahead == 'l') ADVANCE(359);
      if (lookahead == 'n') ADVANCE(297);
      if (lookahead == 'x') ADVANCE(689);
      END_STATE();
    case 505:
      if (lookahead == 'l') ADVANCE(359);
      if (lookahead == 'n') ADVANCE(297);
      if (lookahead == 'x') ADVANCE(690);
      END_STATE();
    case 506:
      if (lookahead == 'l') ADVANCE(989);
      END_STATE();
    case 507:
      if (lookahead == 'l') ADVANCE(989);
      if (lookahead == 'r') ADVANCE(145);
      END_STATE();
    case 508:
      if (lookahead == 'l') ADVANCE(1066);
      END_STATE();
    case 509:
      if (lookahead == 'l') ADVANCE(1001);
      END_STATE();
    case 510:
      if (lookahead == 'l') ADVANCE(973);
      END_STATE();
    case 511:
      if (lookahead == 'l') ADVANCE(966);
      END_STATE();
    case 512:
      if (lookahead == 'l') ADVANCE(988);
      END_STATE();
    case 513:
      if (lookahead == 'l') ADVANCE(1010);
      END_STATE();
    case 514:
      if (lookahead == 'l') ADVANCE(1004);
      END_STATE();
    case 515:
      if (lookahead == 'l') ADVANCE(1048);
      END_STATE();
    case 516:
      if (lookahead == 'l') ADVANCE(965);
      END_STATE();
    case 517:
      if (lookahead == 'l') ADVANCE(633);
      if (lookahead == 'r') ADVANCE(1002);
      END_STATE();
    case 518:
      if (lookahead == 'l') ADVANCE(1003);
      END_STATE();
    case 519:
      if (lookahead == 'l') ADVANCE(518);
      END_STATE();
    case 520:
      if (lookahead == 'l') ADVANCE(636);
      END_STATE();
    case 521:
      if (lookahead == 'l') ADVANCE(165);
      END_STATE();
    case 522:
      if (lookahead == 'l') ADVANCE(508);
      END_STATE();
    case 523:
      if (lookahead == 'l') ADVANCE(361);
      END_STATE();
    case 524:
      if (lookahead == 'l') ADVANCE(789);
      END_STATE();
    case 525:
      if (lookahead == 'l') ADVANCE(26);
      END_STATE();
    case 526:
      if (lookahead == 'l') ADVANCE(194);
      END_STATE();
    case 527:
      if (lookahead == 'l') ADVANCE(641);
      END_STATE();
    case 528:
      if (lookahead == 'l') ADVANCE(24);
      END_STATE();
    case 529:
      if (lookahead == 'l') ADVANCE(506);
      END_STATE();
    case 530:
      if (lookahead == 'l') ADVANCE(334);
      END_STATE();
    case 531:
      if (lookahead == 'l') ADVANCE(512);
      END_STATE();
    case 532:
      if (lookahead == 'l') ADVANCE(509);
      END_STATE();
    case 533:
      if (lookahead == 'l') ADVANCE(169);
      END_STATE();
    case 534:
      if (lookahead == 'l') ADVANCE(329);
      END_STATE();
    case 535:
      if (lookahead == 'l') ADVANCE(514);
      END_STATE();
    case 536:
      if (lookahead == 'l') ADVANCE(337);
      END_STATE();
    case 537:
      if (lookahead == 'l') ADVANCE(533);
      END_STATE();
    case 538:
      if (lookahead == 'l') ADVANCE(224);
      END_STATE();
    case 539:
      if (lookahead == 'l') ADVANCE(339);
      END_STATE();
    case 540:
      if (lookahead == 'l') ADVANCE(340);
      END_STATE();
    case 541:
      if (lookahead == 'l') ADVANCE(374);
      END_STATE();
    case 542:
      if (lookahead == 'l') ADVANCE(348);
      END_STATE();
    case 543:
      if (lookahead == 'l') ADVANCE(377);
      if (lookahead == 'n') ADVANCE(297);
      END_STATE();
    case 544:
      if (lookahead == 'l') ADVANCE(377);
      if (lookahead == 'n') ADVANCE(297);
      if (lookahead == 'x') ADVANCE(691);
      END_STATE();
    case 545:
      if (lookahead == 'l') ADVANCE(377);
      if (lookahead == 'n') ADVANCE(297);
      if (lookahead == 'x') ADVANCE(828);
      END_STATE();
    case 546:
      if (lookahead == 'l') ADVANCE(376);
      if (lookahead == 'x') ADVANCE(828);
      END_STATE();
    case 547:
      if (lookahead == 'l') ADVANCE(232);
      END_STATE();
    case 548:
      if (lookahead == 'l') ADVANCE(661);
      END_STATE();
    case 549:
      if (lookahead == 'l') ADVANCE(223);
      END_STATE();
    case 550:
      if (lookahead == 'l') ADVANCE(379);
      if (lookahead == 'x') ADVANCE(691);
      END_STATE();
    case 551:
      if (lookahead == 'l') ADVANCE(379);
      if (lookahead == 'x') ADVANCE(688);
      END_STATE();
    case 552:
      if (lookahead == 'l') ADVANCE(234);
      END_STATE();
    case 553:
      if (lookahead == 'l') ADVANCE(677);
      END_STATE();
    case 554:
      if (lookahead == 'l') ADVANCE(399);
      END_STATE();
    case 555:
      if (lookahead == 'l') ADVANCE(666);
      END_STATE();
    case 556:
      if (lookahead == 'l') ADVANCE(680);
      END_STATE();
    case 557:
      if (lookahead == 'l') ADVANCE(670);
      if (lookahead == 'r') ADVANCE(565);
      if (lookahead == 's') ADVANCE(833);
      END_STATE();
    case 558:
      if (lookahead == 'l') ADVANCE(672);
      if (lookahead == 'r') ADVANCE(566);
      if (lookahead == 's') ADVANCE(834);
      END_STATE();
    case 559:
      if (lookahead == 'm') ADVANCE(1045);
      END_STATE();
    case 560:
      if (lookahead == 'm') ADVANCE(957);
      END_STATE();
    case 561:
      if (lookahead == 'm') ADVANCE(974);
      END_STATE();
    case 562:
      if (lookahead == 'm') ADVANCE(199);
      END_STATE();
    case 563:
      if (lookahead == 'm') ADVANCE(1044);
      END_STATE();
    case 564:
      if (lookahead == 'm') ADVANCE(467);
      END_STATE();
    case 565:
      if (lookahead == 'm') ADVANCE(859);
      END_STATE();
    case 566:
      if (lookahead == 'm') ADVANCE(860);
      END_STATE();
    case 567:
      if (lookahead == 'm') ADVANCE(639);
      END_STATE();
    case 568:
      if (lookahead == 'm') ADVANCE(32);
      END_STATE();
    case 569:
      if (lookahead == 'm') ADVANCE(695);
      END_STATE();
    case 570:
      if (lookahead == 'm') ADVANCE(204);
      END_STATE();
    case 571:
      if (lookahead == 'm') ADVANCE(387);
      END_STATE();
    case 572:
      if (lookahead == 'm') ADVANCE(473);
      END_STATE();
    case 573:
      if (lookahead == 'm') ADVANCE(656);
      END_STATE();
    case 574:
      if (lookahead == 'm') ADVANCE(490);
      END_STATE();
    case 575:
      if (lookahead == 'm') ADVANCE(653);
      END_STATE();
    case 576:
      if (lookahead == 'm') ADVANCE(667);
      END_STATE();
    case 577:
      if (lookahead == 'm') ADVANCE(655);
      END_STATE();
    case 578:
      if (lookahead == 'm') ADVANCE(478);
      END_STATE();
    case 579:
      if (lookahead == 'm') ADVANCE(703);
      END_STATE();
    case 580:
      if (lookahead == 'n') ADVANCE(723);
      END_STATE();
    case 581:
      if (lookahead == 'n') ADVANCE(1049);
      END_STATE();
    case 582:
      if (lookahead == 'n') ADVANCE(989);
      END_STATE();
    case 583:
      if (lookahead == 'n') ADVANCE(984);
      END_STATE();
    case 584:
      if (lookahead == 'n') ADVANCE(927);
      END_STATE();
    case 585:
      if (lookahead == 'n') ADVANCE(154);
      END_STATE();
    case 586:
      if (lookahead == 'n') ADVANCE(1062);
      END_STATE();
    case 587:
      if (lookahead == 'n') ADVANCE(995);
      END_STATE();
    case 588:
      if (lookahead == 'n') ADVANCE(770);
      if (lookahead == 'p') ADVANCE(893);
      END_STATE();
    case 589:
      if (lookahead == 'n') ADVANCE(987);
      END_STATE();
    case 590:
      if (lookahead == 'n') ADVANCE(145);
      END_STATE();
    case 591:
      if (lookahead == 'n') ADVANCE(263);
      END_STATE();
    case 592:
      if (lookahead == 'n') ADVANCE(857);
      END_STATE();
    case 593:
      if (lookahead == 'n') ADVANCE(771);
      END_STATE();
    case 594:
      if (lookahead == 'n') ADVANCE(320);
      END_STATE();
    case 595:
      if (lookahead == 'n') ADVANCE(264);
      END_STATE();
    case 596:
      if (lookahead == 'n') ADVANCE(261);
      END_STATE();
    case 597:
      if (lookahead == 'n') ADVANCE(303);
      END_STATE();
    case 598:
      if (lookahead == 'n') ADVANCE(147);
      END_STATE();
    case 599:
      if (lookahead == 'n') ADVANCE(278);
      END_STATE();
    case 600:
      if (lookahead == 'n') ADVANCE(304);
      END_STATE();
    case 601:
      if (lookahead == 'n') ADVANCE(266);
      END_STATE();
    case 602:
      if (lookahead == 'n') ADVANCE(783);
      END_STATE();
    case 603:
      if (lookahead == 'n') ADVANCE(281);
      END_STATE();
    case 604:
      if (lookahead == 'n') ADVANCE(682);
      END_STATE();
    case 605:
      if (lookahead == 'n') ADVANCE(306);
      END_STATE();
    case 606:
      if (lookahead == 'n') ADVANCE(268);
      END_STATE();
    case 607:
      if (lookahead == 'n') ADVANCE(307);
      END_STATE();
    case 608:
      if (lookahead == 'n') ADVANCE(269);
      END_STATE();
    case 609:
      if (lookahead == 'n') ADVANCE(282);
      END_STATE();
    case 610:
      if (lookahead == 'n') ADVANCE(270);
      END_STATE();
    case 611:
      if (lookahead == 'n') ADVANCE(271);
      END_STATE();
    case 612:
      if (lookahead == 'n') ADVANCE(265);
      END_STATE();
    case 613:
      if (lookahead == 'n') ADVANCE(345);
      END_STATE();
    case 614:
      if (lookahead == 'n') ADVANCE(346);
      END_STATE();
    case 615:
      if (lookahead == 'n') ADVANCE(772);
      END_STATE();
    case 616:
      if (lookahead == 'n') ADVANCE(283);
      END_STATE();
    case 617:
      if (lookahead == 'n') ADVANCE(657);
      END_STATE();
    case 618:
      if (lookahead == 'n') ADVANCE(815);
      END_STATE();
    case 619:
      if (lookahead == 'n') ADVANCE(489);
      END_STATE();
    case 620:
      if (lookahead == 'n') ADVANCE(484);
      END_STATE();
    case 621:
      if (lookahead == 'n') ADVANCE(658);
      if (lookahead == 'w') ADVANCE(238);
      END_STATE();
    case 622:
      if (lookahead == 'n') ADVANCE(483);
      END_STATE();
    case 623:
      if (lookahead == 'n') ADVANCE(748);
      END_STATE();
    case 624:
      if (lookahead == 'n') ADVANCE(722);
      END_STATE();
    case 625:
      if (lookahead == 'n') ADVANCE(850);
      END_STATE();
    case 626:
      if (lookahead == 'n') ADVANCE(827);
      END_STATE();
    case 627:
      if (lookahead == 'n') ADVANCE(852);
      END_STATE();
    case 628:
      if (lookahead == 'n') ADVANCE(829);
      END_STATE();
    case 629:
      if (lookahead == 'n') ADVANCE(832);
      END_STATE();
    case 630:
      if (lookahead == 'n') ADVANCE(173);
      END_STATE();
    case 631:
      if (lookahead == 'n') ADVANCE(174);
      END_STATE();
    case 632:
      if (lookahead == 'o') ADVANCE(858);
      END_STATE();
    case 633:
      if (lookahead == 'o') ADVANCE(262);
      END_STATE();
    case 634:
      if (lookahead == 'o') ADVANCE(683);
      END_STATE();
    case 635:
      if (lookahead == 'o') ADVANCE(564);
      END_STATE();
    case 636:
      if (lookahead == 'o') ADVANCE(254);
      END_STATE();
    case 637:
      if (lookahead == 'o') ADVANCE(861);
      END_STATE();
    case 638:
      if (lookahead == 'o') ADVANCE(694);
      END_STATE();
    case 639:
      if (lookahead == 'o') ADVANCE(710);
      END_STATE();
    case 640:
      if (lookahead == 'o') ADVANCE(685);
      END_STATE();
    case 641:
      if (lookahead == 'o') ADVANCE(643);
      END_STATE();
    case 642:
      if (lookahead == 'o') ADVANCE(687);
      END_STATE();
    case 643:
      if (lookahead == 'o') ADVANCE(709);
      END_STATE();
    case 644:
      if (lookahead == 'o') ADVANCE(692);
      END_STATE();
    case 645:
      if (lookahead == 'o') ADVANCE(198);
      if (lookahead == 'e' ||
          lookahead == 't') ADVANCE(989);
      END_STATE();
    case 646:
      if (lookahead == 'o') ADVANCE(593);
      if (lookahead == 'l' ||
          lookahead == 't') ADVANCE(896);
      END_STATE();
    case 647:
      if (lookahead == 'o') ADVANCE(202);
      if (lookahead == 'e' ||
          lookahead == 't') ADVANCE(145);
      END_STATE();
    case 648:
      if (lookahead == 'o') ADVANCE(711);
      END_STATE();
    case 649:
      if (lookahead == 'o') ADVANCE(205);
      if (lookahead == 'e' ||
          lookahead == 't') ADVANCE(145);
      END_STATE();
    case 650:
      if (lookahead == 'o') ADVANCE(783);
      END_STATE();
    case 651:
      if (lookahead == 'o') ADVANCE(211);
      END_STATE();
    case 652:
      if (lookahead == 'o') ADVANCE(212);
      if (lookahead == 'e' ||
          lookahead == 't') ADVANCE(145);
      END_STATE();
    case 653:
      if (lookahead == 'o') ADVANCE(718);
      END_STATE();
    case 654:
      if (lookahead == 'o') ADVANCE(214);
      if (lookahead == 'e' ||
          lookahead == 't') ADVANCE(145);
      END_STATE();
    case 655:
      if (lookahead == 'o') ADVANCE(721);
      END_STATE();
    case 656:
      if (lookahead == 'o') ADVANCE(814);
      END_STATE();
    case 657:
      if (lookahead == 'o') ADVANCE(619);
      END_STATE();
    case 658:
      if (lookahead == 'o') ADVANCE(811);
      END_STATE();
    case 659:
      if (lookahead == 'o') ADVANCE(572);
      END_STATE();
    case 660:
      if (lookahead == 'o') ADVANCE(714);
      END_STATE();
    case 661:
      if (lookahead == 'o') ADVANCE(648);
      END_STATE();
    case 662:
      if (lookahead == 'o') ADVANCE(615);
      END_STATE();
    case 663:
      if (lookahead == 'o') ADVANCE(217);
      END_STATE();
    case 664:
      if (lookahead == 'o') ADVANCE(574);
      END_STATE();
    case 665:
      if (lookahead == 'o') ADVANCE(716);
      END_STATE();
    case 666:
      if (lookahead == 'o') ADVANCE(219);
      END_STATE();
    case 667:
      if (lookahead == 'o') ADVANCE(816);
      END_STATE();
    case 668:
      if (lookahead == 'o') ADVANCE(578);
      END_STATE();
    case 669:
      if (lookahead == 'o') ADVANCE(739);
      END_STATE();
    case 670:
      if (lookahead == 'o') ADVANCE(220);
      END_STATE();
    case 671:
      if (lookahead == 'o') ADVANCE(740);
      END_STATE();
    case 672:
      if (lookahead == 'o') ADVANCE(222);
      END_STATE();
    case 673:
      if (lookahead == 'o') ADVANCE(741);
      END_STATE();
    case 674:
      if (lookahead == 'o') ADVANCE(742);
      END_STATE();
    case 675:
      if (lookahead == 'o') ADVANCE(746);
      END_STATE();
    case 676:
      if (lookahead == 'o') ADVANCE(747);
      END_STATE();
    case 677:
      if (lookahead == 'o') ADVANCE(255);
      END_STATE();
    case 678:
      if (lookahead == 'o') ADVANCE(862);
      END_STATE();
    case 679:
      if (lookahead == 'o') ADVANCE(576);
      END_STATE();
    case 680:
      if (lookahead == 'o') ADVANCE(258);
      END_STATE();
    case 681:
      if (lookahead == 'o') ADVANCE(863);
      END_STATE();
    case 682:
      if (lookahead == 'o') ADVANCE(631);
      END_STATE();
    case 683:
      if (lookahead == 'p') ADVANCE(989);
      END_STATE();
    case 684:
      if (lookahead == 'p') ADVANCE(941);
      END_STATE();
    case 685:
      if (lookahead == 'p') ADVANCE(1001);
      END_STATE();
    case 686:
      if (lookahead == 'p') ADVANCE(160);
      END_STATE();
    case 687:
      if (lookahead == 'p') ADVANCE(891);
      END_STATE();
    case 688:
      if (lookahead == 'p') ADVANCE(660);
      END_STATE();
    case 689:
      if (lookahead == 'p') ADVANCE(660);
      if (lookahead == 't') ADVANCE(366);
      END_STATE();
    case 690:
      if (lookahead == 'p') ADVANCE(660);
      if (lookahead == 't') ADVANCE(365);
      END_STATE();
    case 691:
      if (lookahead == 'p') ADVANCE(660);
      if (lookahead == 't') ADVANCE(400);
      END_STATE();
    case 692:
      if (lookahead == 'p') ADVANCE(889);
      END_STATE();
    case 693:
      if (lookahead == 'p') ADVANCE(332);
      END_STATE();
    case 694:
      if (lookahead == 'p') ADVANCE(287);
      END_STATE();
    case 695:
      if (lookahead == 'p') ADVANCE(879);
      END_STATE();
    case 696:
      if (lookahead == 'p') ADVANCE(538);
      END_STATE();
    case 697:
      if (lookahead == 'p') ADVANCE(538);
      if (lookahead == 'q') ADVANCE(729);
      if (lookahead == 'u') ADVANCE(246);
      END_STATE();
    case 698:
      if (lookahead == 'p') ADVANCE(743);
      END_STATE();
    case 699:
      if (lookahead == 'p') ADVANCE(751);
      END_STATE();
    case 700:
      if (lookahead == 'p') ADVANCE(744);
      END_STATE();
    case 701:
      if (lookahead == 'p') ADVANCE(745);
      END_STATE();
    case 702:
      if (lookahead == 'p') ADVANCE(665);
      END_STATE();
    case 703:
      if (lookahead == 'p') ADVANCE(886);
      END_STATE();
    case 704:
      if (lookahead == 'q') ADVANCE(989);
      END_STATE();
    case 705:
      if (lookahead == 'q') ADVANCE(1000);
      END_STATE();
    case 706:
      if (lookahead == 'q') ADVANCE(1000);
      if (lookahead == 'x') ADVANCE(819);
      END_STATE();
    case 707:
      if (lookahead == 'q') ADVANCE(1000);
      if (lookahead == 'x') ADVANCE(823);
      END_STATE();
    case 708:
      if (lookahead == 'q') ADVANCE(729);
      if (lookahead == 't') ADVANCE(669);
      if (lookahead == 'u') ADVANCE(246);
      END_STATE();
    case 709:
      if (lookahead == 'r') ADVANCE(989);
      END_STATE();
    case 710:
      if (lookahead == 'r') ADVANCE(890);
      END_STATE();
    case 711:
      if (lookahead == 'r') ADVANCE(1010);
      END_STATE();
    case 712:
      if (lookahead == 'r') ADVANCE(145);
      END_STATE();
    case 713:
      if (lookahead == 'r') ADVANCE(785);
      END_STATE();
    case 714:
      if (lookahead == 'r') ADVANCE(786);
      END_STATE();
    case 715:
      if (lookahead == 'r') ADVANCE(193);
      END_STATE();
    case 716:
      if (lookahead == 'r') ADVANCE(787);
      END_STATE();
    case 717:
      if (lookahead == 'r') ADVANCE(841);
      END_STATE();
    case 718:
      if (lookahead == 'r') ADVANCE(895);
      END_STATE();
    case 719:
      if (lookahead == 'r') ADVANCE(477);
      END_STATE();
    case 720:
      if (lookahead == 'r') ADVANCE(586);
      END_STATE();
    case 721:
      if (lookahead == 'r') ADVANCE(892);
      END_STATE();
    case 722:
      if (lookahead == 'r') ADVANCE(372);
      END_STATE();
    case 723:
      if (lookahead == 'r') ADVANCE(372);
      if (lookahead == 's') ADVANCE(450);
      END_STATE();
    case 724:
      if (lookahead == 'r') ADVANCE(587);
      END_STATE();
    case 725:
      if (lookahead == 'r') ADVANCE(362);
      END_STATE();
    case 726:
      if (lookahead == 'r') ADVANCE(698);
      END_STATE();
    case 727:
      if (lookahead == 'r') ADVANCE(195);
      END_STATE();
    case 728:
      if (lookahead == 'r') ADVANCE(640);
      END_STATE();
    case 729:
      if (lookahead == 'r') ADVANCE(783);
      END_STATE();
    case 730:
      if (lookahead == 'r') ADVANCE(369);
      END_STATE();
    case 731:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 732:
      if (lookahead == 'r') ADVANCE(338);
      END_STATE();
    case 733:
      if (lookahead == 'r') ADVANCE(632);
      END_STATE();
    case 734:
      if (lookahead == 'r') ADVANCE(637);
      END_STATE();
    case 735:
      if (lookahead == 'r') ADVANCE(589);
      END_STATE();
    case 736:
      if (lookahead == 'r') ADVANCE(820);
      END_STATE();
    case 737:
      if (lookahead == 'r') ADVANCE(623);
      END_STATE();
    case 738:
      if (lookahead == 'r') ADVANCE(398);
      END_STATE();
    case 739:
      if (lookahead == 'r') ADVANCE(341);
      END_STATE();
    case 740:
      if (lookahead == 'r') ADVANCE(352);
      END_STATE();
    case 741:
      if (lookahead == 'r') ADVANCE(353);
      END_STATE();
    case 742:
      if (lookahead == 'r') ADVANCE(343);
      END_STATE();
    case 743:
      if (lookahead == 'r') ADVANCE(409);
      END_STATE();
    case 744:
      if (lookahead == 'r') ADVANCE(389);
      END_STATE();
    case 745:
      if (lookahead == 'r') ADVANCE(390);
      END_STATE();
    case 746:
      if (lookahead == 'r') ADVANCE(354);
      END_STATE();
    case 747:
      if (lookahead == 'r') ADVANCE(355);
      END_STATE();
    case 748:
      if (lookahead == 'r') ADVANCE(378);
      END_STATE();
    case 749:
      if (lookahead == 'r') ADVANCE(679);
      END_STATE();
    case 750:
      if (lookahead == 'r') ADVANCE(396);
      END_STATE();
    case 751:
      if (lookahead == 'r') ADVANCE(394);
      END_STATE();
    case 752:
      if (lookahead == 'r') ADVANCE(734);
      END_STATE();
    case 753:
      if (lookahead == 'r') ADVANCE(846);
      END_STATE();
    case 754:
      if (lookahead == 'r') ADVANCE(699);
      END_STATE();
    case 755:
      if (lookahead == 'r') ADVANCE(678);
      END_STATE();
    case 756:
      if (lookahead == 'r') ADVANCE(824);
      END_STATE();
    case 757:
      if (lookahead == 'r') ADVANCE(401);
      END_STATE();
    case 758:
      if (lookahead == 'r') ADVANCE(755);
      END_STATE();
    case 759:
      if (lookahead == 'r') ADVANCE(849);
      END_STATE();
    case 760:
      if (lookahead == 'r') ADVANCE(700);
      END_STATE();
    case 761:
      if (lookahead == 'r') ADVANCE(851);
      END_STATE();
    case 762:
      if (lookahead == 'r') ADVANCE(701);
      END_STATE();
    case 763:
      if (lookahead == 'r') ADVANCE(853);
      END_STATE();
    case 764:
      if (lookahead == 's') ADVANCE(989);
      END_STATE();
    case 765:
      if (lookahead == 's') ADVANCE(1010);
      END_STATE();
    case 766:
      if (lookahead == 's') ADVANCE(502);
      END_STATE();
    case 767:
      if (lookahead == 's') ADVANCE(370);
      END_STATE();
    case 768:
      if (lookahead == 's') ADVANCE(696);
      END_STATE();
    case 769:
      if (lookahead == 's') ADVANCE(783);
      END_STATE();
    case 770:
      if (lookahead == 's') ADVANCE(792);
      if (lookahead == 'v') ADVANCE(403);
      END_STATE();
    case 771:
      if (lookahead == 's') ADVANCE(794);
      END_STATE();
    case 772:
      if (lookahead == 's') ADVANCE(797);
      END_STATE();
    case 773:
      if (lookahead == 's') ADVANCE(793);
      END_STATE();
    case 774:
      if (lookahead == 's') ADVANCE(404);
      END_STATE();
    case 775:
      if (lookahead == 's') ADVANCE(164);
      END_STATE();
    case 776:
      if (lookahead == 's') ADVANCE(225);
      END_STATE();
    case 777:
      if (lookahead == 's') ADVANCE(235);
      END_STATE();
    case 778:
      if (lookahead == 's') ADVANCE(486);
      END_STATE();
    case 779:
      if (lookahead == 's') ADVANCE(174);
      END_STATE();
    case 780:
      if (lookahead == 't') ADVANCE(635);
      END_STATE();
    case 781:
      if (lookahead == 't') ADVANCE(1016);
      END_STATE();
    case 782:
      if (lookahead == 't') ADVANCE(976);
      END_STATE();
    case 783:
      if (lookahead == 't') ADVANCE(989);
      END_STATE();
    case 784:
      if (lookahead == 't') ADVANCE(1001);
      END_STATE();
    case 785:
      if (lookahead == 't') ADVANCE(1047);
      END_STATE();
    case 786:
      if (lookahead == 't') ADVANCE(964);
      END_STATE();
    case 787:
      if (lookahead == 't') ADVANCE(985);
      END_STATE();
    case 788:
      if (lookahead == 't') ADVANCE(1061);
      END_STATE();
    case 789:
      if (lookahead == 't') ADVANCE(975);
      END_STATE();
    case 790:
      if (lookahead == 't') ADVANCE(1017);
      END_STATE();
    case 791:
      if (lookahead == 't') ADVANCE(906);
      END_STATE();
    case 792:
      if (lookahead == 't') ADVANCE(1012);
      END_STATE();
    case 793:
      if (lookahead == 't') ADVANCE(1010);
      END_STATE();
    case 794:
      if (lookahead == 't') ADVANCE(1013);
      END_STATE();
    case 795:
      if (lookahead == 't') ADVANCE(1004);
      END_STATE();
    case 796:
      if (lookahead == 't') ADVANCE(1040);
      END_STATE();
    case 797:
      if (lookahead == 't') ADVANCE(1018);
      END_STATE();
    case 798:
      if (lookahead == 't') ADVANCE(971);
      END_STATE();
    case 799:
      if (lookahead == 't') ADVANCE(145);
      END_STATE();
    case 800:
      if (lookahead == 't') ADVANCE(453);
      END_STATE();
    case 801:
      if (lookahead == 't') ADVANCE(166);
      END_STATE();
    case 802:
      if (lookahead == 't') ADVANCE(192);
      END_STATE();
    case 803:
      if (lookahead == 't') ADVANCE(160);
      END_STATE();
    case 804:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 805:
      if (lookahead == 't') ADVANCE(570);
      END_STATE();
    case 806:
      if (lookahead == 't') ADVANCE(151);
      END_STATE();
    case 807:
      if (lookahead == 't') ADVANCE(153);
      END_STATE();
    case 808:
      if (lookahead == 't') ADVANCE(365);
      END_STATE();
    case 809:
      if (lookahead == 't') ADVANCE(717);
      END_STATE();
    case 810:
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 811:
      if (lookahead == 't') ADVANCE(472);
      END_STATE();
    case 812:
      if (lookahead == 't') ADVANCE(196);
      END_STATE();
    case 813:
      if (lookahead == 't') ADVANCE(186);
      END_STATE();
    case 814:
      if (lookahead == 't') ADVANCE(371);
      END_STATE();
    case 815:
      if (lookahead == 't') ADVANCE(380);
      END_STATE();
    case 816:
      if (lookahead == 't') ADVANCE(373);
      END_STATE();
    case 817:
      if (lookahead == 't') ADVANCE(774);
      END_STATE();
    case 818:
      if (lookahead == 't') ADVANCE(90);
      END_STATE();
    case 819:
      if (lookahead == 't') ADVANCE(381);
      END_STATE();
    case 820:
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 821:
      if (lookahead == 't') ADVANCE(167);
      END_STATE();
    case 822:
      if (lookahead == 't') ADVANCE(397);
      END_STATE();
    case 823:
      if (lookahead == 't') ADVANCE(383);
      END_STATE();
    case 824:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 825:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 826:
      if (lookahead == 't') ADVANCE(481);
      END_STATE();
    case 827:
      if (lookahead == 't') ADVANCE(405);
      END_STATE();
    case 828:
      if (lookahead == 't') ADVANCE(400);
      END_STATE();
    case 829:
      if (lookahead == 't') ADVANCE(408);
      END_STATE();
    case 830:
      if (lookahead == 't') ADVANCE(668);
      END_STATE();
    case 831:
      if (lookahead == 't') ADVANCE(674);
      END_STATE();
    case 832:
      if (lookahead == 't') ADVANCE(410);
      END_STATE();
    case 833:
      if (lookahead == 't') ADVANCE(675);
      END_STATE();
    case 834:
      if (lookahead == 't') ADVANCE(676);
      END_STATE();
    case 835:
      if (lookahead == 'u') ADVANCE(900);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(916);
      if (lookahead != 0) ADVANCE(963);
      END_STATE();
    case 836:
      if (lookahead == 'u') ADVANCE(989);
      END_STATE();
    case 837:
      if (lookahead == 'u') ADVANCE(246);
      END_STATE();
    case 838:
      if (lookahead == 'u') ADVANCE(251);
      END_STATE();
    case 839:
      if (lookahead == 'u') ADVANCE(524);
      END_STATE();
    case 840:
      if (lookahead == 'u') ADVANCE(506);
      END_STATE();
    case 841:
      if (lookahead == 'u') ADVANCE(343);
      END_STATE();
    case 842:
      if (lookahead == 'u') ADVANCE(426);
      END_STATE();
    case 843:
      if (lookahead == 'u') ADVANCE(595);
      END_STATE();
    case 844:
      if (lookahead == 'u') ADVANCE(522);
      END_STATE();
    case 845:
      if (lookahead == 'u') ADVANCE(724);
      END_STATE();
    case 846:
      if (lookahead == 'u') ADVANCE(596);
      END_STATE();
    case 847:
      if (lookahead == 'u') ADVANCE(531);
      END_STATE();
    case 848:
      if (lookahead == 'u') ADVANCE(536);
      END_STATE();
    case 849:
      if (lookahead == 'u') ADVANCE(599);
      END_STATE();
    case 850:
      if (lookahead == 'u') ADVANCE(532);
      END_STATE();
    case 851:
      if (lookahead == 'u') ADVANCE(601);
      END_STATE();
    case 852:
      if (lookahead == 'u') ADVANCE(529);
      END_STATE();
    case 853:
      if (lookahead == 'u') ADVANCE(603);
      END_STATE();
    case 854:
      if (lookahead == 'u') ADVANCE(612);
      END_STATE();
    case 855:
      if (lookahead == 'v') ADVANCE(989);
      END_STATE();
    case 856:
      if (lookahead == 'v') ADVANCE(145);
      END_STATE();
    case 857:
      if (lookahead == 'v') ADVANCE(407);
      END_STATE();
    case 858:
      if (lookahead == 'w') ADVANCE(1004);
      END_STATE();
    case 859:
      if (lookahead == 'w') ADVANCE(31);
      END_STATE();
    case 860:
      if (lookahead == 'w') ADVANCE(30);
      END_STATE();
    case 861:
      if (lookahead == 'w') ADVANCE(168);
      END_STATE();
    case 862:
      if (lookahead == 'w') ADVANCE(162);
      END_STATE();
    case 863:
      if (lookahead == 'w') ADVANCE(163);
      END_STATE();
    case 864:
      if (lookahead == 'x') ADVANCE(46);
      END_STATE();
    case 865:
      if (lookahead == 'x') ADVANCE(989);
      END_STATE();
    case 866:
      if (lookahead == 'x') ADVANCE(134);
      END_STATE();
    case 867:
      if (lookahead == 'x') ADVANCE(145);
      END_STATE();
    case 868:
      if (lookahead == 'x') ADVANCE(135);
      END_STATE();
    case 869:
      if (lookahead == 'x') ADVANCE(140);
      END_STATE();
    case 870:
      if (lookahead == 'x') ADVANCE(921);
      END_STATE();
    case 871:
      if (lookahead == 'x') ADVANCE(63);
      END_STATE();
    case 872:
      if (lookahead == 'x') ADVANCE(104);
      END_STATE();
    case 873:
      if (lookahead == 'x') ADVANCE(138);
      END_STATE();
    case 874:
      if (lookahead == 'x') ADVANCE(109);
      END_STATE();
    case 875:
      if (lookahead == 'x') ADVANCE(137);
      END_STATE();
    case 876:
      if (lookahead == 'x') ADVANCE(822);
      END_STATE();
    case 877:
      if (lookahead == 'x') ADVANCE(107);
      END_STATE();
    case 878:
      if (lookahead == 'x') ADVANCE(108);
      END_STATE();
    case 879:
      if (lookahead == 'x') ADVANCE(276);
      END_STATE();
    case 880:
      if (lookahead == 'x') ADVANCE(68);
      END_STATE();
    case 881:
      if (lookahead == 'x') ADVANCE(69);
      END_STATE();
    case 882:
      if (lookahead == 'x') ADVANCE(47);
      END_STATE();
    case 883:
      if (lookahead == 'x') ADVANCE(114);
      END_STATE();
    case 884:
      if (lookahead == 'x') ADVANCE(79);
      END_STATE();
    case 885:
      if (lookahead == 'x') ADVANCE(808);
      END_STATE();
    case 886:
      if (lookahead == 'x') ADVANCE(292);
      END_STATE();
    case 887:
      if (lookahead == 'x') ADVANCE(48);
      END_STATE();
    case 888:
      if (lookahead == 'x') ADVANCE(49);
      END_STATE();
    case 889:
      if (lookahead == 'y') ADVANCE(989);
      END_STATE();
    case 890:
      if (lookahead == 'y') ADVANCE(968);
      END_STATE();
    case 891:
      if (lookahead == 'y') ADVANCE(1039);
      END_STATE();
    case 892:
      if (lookahead == 'y') ADVANCE(967);
      END_STATE();
    case 893:
      if (lookahead == 'y') ADVANCE(778);
      END_STATE();
    case 894:
      if (lookahead == 'y') ADVANCE(165);
      END_STATE();
    case 895:
      if (lookahead == 'y') ADVANCE(27);
      END_STATE();
    case 896:
      if (lookahead == 'z') ADVANCE(989);
      END_STATE();
    case 897:
      if (lookahead == 'z') ADVANCE(899);
      END_STATE();
    case 898:
      if (lookahead == 'z') ADVANCE(344);
      END_STATE();
    case 899:
      if (lookahead == 'z') ADVANCE(534);
      END_STATE();
    case 900:
      if (lookahead == '{') ADVANCE(918);
      END_STATE();
    case 901:
      if (lookahead == '}') ADVANCE(963);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(901);
      END_STATE();
    case 902:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(912);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(978);
      END_STATE();
    case 903:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(915);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(951);
      END_STATE();
    case 904:
      if (lookahead == 'e' ||
          lookahead == 't') ADVANCE(989);
      END_STATE();
    case 905:
      if (lookahead == 'e' ||
          lookahead == 't') ADVANCE(145);
      END_STATE();
    case 906:
      if (lookahead == 'l' ||
          lookahead == 'r') ADVANCE(989);
      END_STATE();
    case 907:
      if (lookahead == 's' ||
          lookahead == 'u') ADVANCE(989);
      END_STATE();
    case 908:
      if (lookahead == 's' ||
          lookahead == 'u') ADVANCE(1005);
      END_STATE();
    case 909:
      if (lookahead == 's' ||
          lookahead == 'u') ADVANCE(1010);
      END_STATE();
    case 910:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(932);
      END_STATE();
    case 911:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(956);
      END_STATE();
    case 912:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(978);
      END_STATE();
    case 913:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(950);
      END_STATE();
    case 914:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(952);
      END_STATE();
    case 915:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(951);
      END_STATE();
    case 916:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(963);
      END_STATE();
    case 917:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(929);
      END_STATE();
    case 918:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(901);
      END_STATE();
    case 919:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(977);
      END_STATE();
    case 920:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(979);
      END_STATE();
    case 921:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1050);
      END_STATE();
    case 922:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(981);
      END_STATE();
    case 923:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(933);
      END_STATE();
    case 924:
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(982);
      END_STATE();
    case 925:
      if (eof) ADVANCE(926);
      if (lookahead == '"') ADVANCE(1073);
      if (lookahead == '$') ADVANCE(924);
      if (lookahead == '(') ADVANCE(936);
      if (lookahead == ')') ADVANCE(935);
      if (lookahead == '0') ADVANCE(954);
      if (lookahead == ';') ADVANCE(17);
      if (lookahead == 'a') ADVANCE(503);
      if (lookahead == 'b') ADVANCE(517);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 'd') ADVANCE(175);
      if (lookahead == 'e') ADVANCE(505);
      if (lookahead == 'f') ADVANCE(85);
      if (lookahead == 'g') ADVANCE(520);
      if (lookahead == 'i') ADVANCE(41);
      if (lookahead == 'l') ADVANCE(349);
      if (lookahead == 'm') ADVANCE(327);
      if (lookahead == 'n') ADVANCE(189);
      if (lookahead == 'o') ADVANCE(425);
      if (lookahead == 'p') ADVANCE(176);
      if (lookahead == 'r') ADVANCE(330);
      if (lookahead == 's') ADVANCE(358);
      if (lookahead == 't') ADVANCE(177);
      if (lookahead == 'u') ADVANCE(580);
      if (lookahead == 'v') ADVANCE(45);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(1072);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(925)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(956);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(anon_sym_align);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(sym_align_offset_value);
      if (lookahead == '.') ADVANCE(980);
      if (lookahead == '_') ADVANCE(917);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(929);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(sym_align_offset_value);
      if (lookahead == '_') ADVANCE(910);
      if (lookahead == 'x') ADVANCE(917);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(932);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(sym_align_offset_value);
      if (lookahead == '_') ADVANCE(910);
      if (lookahead == 'x') ADVANCE(923);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(932);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(sym_align_offset_value);
      if (lookahead == '_') ADVANCE(910);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(932);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(sym_align_offset_value);
      if (lookahead == '_') ADVANCE(923);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(933);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(anon_sym_LPAREN_AT);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == ';') ADVANCE(942);
      if (lookahead == '@') ADVANCE(934);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(anon_sym_block);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(anon_sym_loop);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(anon_sym_LPAREN_SEMI);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(anon_sym_SEMI_RPAREN);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(sym_comment_block_inner);
      if (lookahead == '(') ADVANCE(946);
      if (lookahead == ';') ADVANCE(945);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(944);
      if (lookahead != 0) ADVANCE(947);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(sym_comment_block_inner);
      if (lookahead == ')') ADVANCE(943);
      if (lookahead == ';') ADVANCE(948);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(sym_comment_block_inner);
      if (lookahead == ';') ADVANCE(942);
      if (lookahead == '@') ADVANCE(934);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(sym_comment_block_inner);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ';') ADVANCE(947);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(aux_sym_comment_line_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(948);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(sym_dec_float);
      if (lookahead == '.') ADVANCE(953);
      if (lookahead == '_') ADVANCE(913);
      if (lookahead == 'x') ADVANCE(919);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(903);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(950);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(sym_dec_float);
      if (lookahead == '.') ADVANCE(953);
      if (lookahead == '_') ADVANCE(913);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(903);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(950);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(sym_dec_float);
      if (lookahead == '_') ADVANCE(915);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(951);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(sym_dec_float);
      if (lookahead == '_') ADVANCE(914);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(903);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(952);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(sym_dec_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(903);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(952);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(sym_dec_nat);
      if (lookahead == '_') ADVANCE(911);
      if (lookahead == 'x') ADVANCE(919);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(956);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(sym_dec_nat);
      if (lookahead == '_') ADVANCE(911);
      if (lookahead == 'x') ADVANCE(922);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(956);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(sym_dec_nat);
      if (lookahead == '_') ADVANCE(911);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(956);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(anon_sym_item);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(anon_sym_func);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(anon_sym_func);
      if (lookahead == '.') ADVANCE(253);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(anon_sym_func);
      if (lookahead == '.') ADVANCE(253);
      if (lookahead == 'r') ADVANCE(375);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(anon_sym_func);
      if (lookahead == 'r') ADVANCE(375);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(1074);
      if (lookahead == '\\') ADVANCE(835);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(835);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(anon_sym_global);
      if (lookahead == '.') ADVANCE(441);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(anon_sym_memory);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(anon_sym_memory);
      if (lookahead == '.') ADVANCE(221);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(anon_sym_table);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(anon_sym_table);
      if (lookahead == '.') ADVANCE(284);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(anon_sym_call_indirect);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(anon_sym_inf);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(anon_sym_local);
      if (lookahead == '.') ADVANCE(442);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(anon_sym_param);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(anon_sym_result);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(anon_sym_mut);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(sym_hex_float);
      if (lookahead == '.') ADVANCE(980);
      if (lookahead == '_') ADVANCE(919);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(977);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(sym_hex_float);
      if (lookahead == '_') ADVANCE(912);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(978);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(sym_hex_float);
      if (lookahead == '_') ADVANCE(920);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(979);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(sym_hex_float);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(902);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(979);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(sym_hex_nat);
      if (lookahead == '_') ADVANCE(922);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(981);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(982);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(sym_identifier_pattern);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(983);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(anon_sym_br_table);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(anon_sym_ref_DOTextern);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(anon_sym_ref_DOTnull);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(sym_op_nullary);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(sym_op_nullary);
      if (lookahead == '1') ADVANCE(117);
      if (lookahead == '3') ADVANCE(59);
      if (lookahead == '8') ADVANCE(989);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(sym_op_nullary);
      if (lookahead == '1') ADVANCE(117);
      if (lookahead == '8') ADVANCE(989);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(sym_op_nullary);
      if (lookahead == '1') ADVANCE(129);
      if (lookahead == '3') ADVANCE(80);
      if (lookahead == '8') ADVANCE(152);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(sym_op_nullary);
      if (lookahead == '1') ADVANCE(129);
      if (lookahead == '8') ADVANCE(152);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(sym_op_nullary);
      if (lookahead == '_') ADVANCE(776);
      END_STATE();
    case 995:
      ACCEPT_TOKEN(sym_op_nullary);
      if (lookahead == '_') ADVANCE(296);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(sym_op_nullary);
      if (lookahead == 'a') ADVANCE(738);
      if (lookahead == 'g') ADVANCE(989);
      END_STATE();
    case 997:
      ACCEPT_TOKEN(sym_op_nullary);
      if (lookahead == 'a') ADVANCE(757);
      if (lookahead == 'g') ADVANCE(1010);
      END_STATE();
    case 998:
      ACCEPT_TOKEN(sym_op_nullary);
      if (lookahead == 'g') ADVANCE(1010);
      END_STATE();
    case 999:
      ACCEPT_TOKEN(sym_op_nullary);
      if (lookahead == 'n') ADVANCE(650);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(sym_op_nullary);
      if (lookahead == 'z') ADVANCE(989);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(sym_op_index);
      END_STATE();
    case 1002:
      ACCEPT_TOKEN(sym_op_index);
      if (lookahead == '_') ADVANCE(465);
      END_STATE();
    case 1003:
      ACCEPT_TOKEN(sym_op_index);
      if (lookahead == '_') ADVANCE(470);
      END_STATE();
    case 1004:
      ACCEPT_TOKEN(sym_op_index_opt);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(sym_op_index_opt_offset_opt_align_opt);
      END_STATE();
    case 1006:
      ACCEPT_TOKEN(sym_op_index_opt_offset_opt_align_opt);
      if (lookahead == '1') ADVANCE(126);
      if (lookahead == '3') ADVANCE(75);
      if (lookahead == '8') ADVANCE(148);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(sym_op_index_opt_offset_opt_align_opt);
      if (lookahead == '1') ADVANCE(126);
      if (lookahead == '8') ADVANCE(148);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(sym_op_index_opt_offset_opt_align_opt);
      if (lookahead == '1') ADVANCE(120);
      if (lookahead == '3') ADVANCE(64);
      if (lookahead == '8') ADVANCE(1005);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(sym_op_index_opt_offset_opt_align_opt);
      if (lookahead == '1') ADVANCE(120);
      if (lookahead == '8') ADVANCE(1005);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(sym_op_simd_offset_opt_align_opt);
      END_STATE();
    case 1011:
      ACCEPT_TOKEN(sym_op_simd_offset_opt_align_opt);
      if (lookahead == '1') ADVANCE(124);
      if (lookahead == '3') ADVANCE(72);
      if (lookahead == '6') ADVANCE(113);
      if (lookahead == '8') ADVANCE(156);
      END_STATE();
    case 1012:
      ACCEPT_TOKEN(aux_sym_op_const_token1);
      END_STATE();
    case 1013:
      ACCEPT_TOKEN(aux_sym_op_const_token2);
      END_STATE();
    case 1014:
      ACCEPT_TOKEN(anon_sym_func_DOTbind);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 1016:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 1017:
      ACCEPT_TOKEN(anon_sym_select);
      END_STATE();
    case 1018:
      ACCEPT_TOKEN(anon_sym_v128_DOTconst);
      END_STATE();
    case 1019:
      ACCEPT_TOKEN(anon_sym_f32x4);
      END_STATE();
    case 1020:
      ACCEPT_TOKEN(anon_sym_f32x4);
      if (lookahead == '.') ADVANCE(229);
      END_STATE();
    case 1021:
      ACCEPT_TOKEN(anon_sym_f64x2);
      END_STATE();
    case 1022:
      ACCEPT_TOKEN(anon_sym_f64x2);
      if (lookahead == '.') ADVANCE(230);
      END_STATE();
    case 1023:
      ACCEPT_TOKEN(anon_sym_i8x16);
      END_STATE();
    case 1024:
      ACCEPT_TOKEN(anon_sym_i8x16);
      if (lookahead == '.') ADVANCE(184);
      END_STATE();
    case 1025:
      ACCEPT_TOKEN(anon_sym_i16x8);
      END_STATE();
    case 1026:
      ACCEPT_TOKEN(anon_sym_i16x8);
      if (lookahead == '.') ADVANCE(182);
      END_STATE();
    case 1027:
      ACCEPT_TOKEN(anon_sym_i32x4);
      END_STATE();
    case 1028:
      ACCEPT_TOKEN(anon_sym_i32x4);
      if (lookahead == '.') ADVANCE(183);
      END_STATE();
    case 1029:
      ACCEPT_TOKEN(anon_sym_i64x2);
      END_STATE();
    case 1030:
      ACCEPT_TOKEN(anon_sym_i64x2);
      if (lookahead == '.') ADVANCE(207);
      END_STATE();
    case 1031:
      ACCEPT_TOKEN(anon_sym_DOTshuffle);
      END_STATE();
    case 1032:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == 's') ADVANCE(444);
      END_STATE();
    case 1033:
      ACCEPT_TOKEN(anon_sym_extract_lane);
      END_STATE();
    case 1034:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 1035:
      ACCEPT_TOKEN(aux_sym_op_simd_lane_token1);
      END_STATE();
    case 1036:
      ACCEPT_TOKEN(aux_sym_op_simd_lane_token1);
      if (lookahead == 'e') ADVANCE(523);
      if (lookahead == 'h') ADVANCE(190);
      if (lookahead == 't') ADVANCE(192);
      END_STATE();
    case 1037:
      ACCEPT_TOKEN(aux_sym_op_simd_lane_token1);
      if (lookahead == 'n') ADVANCE(723);
      END_STATE();
    case 1038:
      ACCEPT_TOKEN(anon_sym_replace_lane);
      END_STATE();
    case 1039:
      ACCEPT_TOKEN(anon_sym_table_DOTcopy);
      END_STATE();
    case 1040:
      ACCEPT_TOKEN(anon_sym_table_DOTinit);
      END_STATE();
    case 1041:
      ACCEPT_TOKEN(anon_sym_data);
      END_STATE();
    case 1042:
      ACCEPT_TOKEN(anon_sym_data);
      if (lookahead == '.') ADVANCE(321);
      END_STATE();
    case 1043:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 1044:
      ACCEPT_TOKEN(anon_sym_elem);
      END_STATE();
    case 1045:
      ACCEPT_TOKEN(anon_sym_elem);
      if (lookahead == '.') ADVANCE(321);
      END_STATE();
    case 1046:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 1047:
      ACCEPT_TOKEN(anon_sym_start);
      END_STATE();
    case 1048:
      ACCEPT_TOKEN(sym_nan);
      END_STATE();
    case 1049:
      ACCEPT_TOKEN(sym_nan);
      if (lookahead == ':') ADVANCE(39);
      END_STATE();
    case 1050:
      ACCEPT_TOKEN(sym_nan);
      if (lookahead == '_') ADVANCE(921);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1050);
      END_STATE();
    case 1051:
      ACCEPT_TOKEN(sym_num_type_f32);
      END_STATE();
    case 1052:
      ACCEPT_TOKEN(sym_num_type_f32);
      if (lookahead == '.') ADVANCE(179);
      if (lookahead == 'x') ADVANCE(102);
      END_STATE();
    case 1053:
      ACCEPT_TOKEN(sym_num_type_f64);
      END_STATE();
    case 1054:
      ACCEPT_TOKEN(sym_num_type_f64);
      if (lookahead == '.') ADVANCE(180);
      if (lookahead == 'x') ADVANCE(61);
      END_STATE();
    case 1055:
      ACCEPT_TOKEN(sym_num_type_i32);
      END_STATE();
    case 1056:
      ACCEPT_TOKEN(sym_num_type_i32);
      if (lookahead == '.') ADVANCE(181);
      if (lookahead == 'x') ADVANCE(103);
      END_STATE();
    case 1057:
      ACCEPT_TOKEN(sym_num_type_i64);
      END_STATE();
    case 1058:
      ACCEPT_TOKEN(sym_num_type_i64);
      if (lookahead == '.') ADVANCE(244);
      if (lookahead == 'x') ADVANCE(62);
      END_STATE();
    case 1059:
      ACCEPT_TOKEN(sym_num_type_v128);
      END_STATE();
    case 1060:
      ACCEPT_TOKEN(sym_num_type_v128);
      if (lookahead == '.') ADVANCE(210);
      END_STATE();
    case 1061:
      ACCEPT_TOKEN(anon_sym_offset);
      END_STATE();
    case 1062:
      ACCEPT_TOKEN(sym_ref_kind);
      END_STATE();
    case 1063:
      ACCEPT_TOKEN(sym_ref_type_externref);
      END_STATE();
    case 1064:
      ACCEPT_TOKEN(sym_ref_type_funcref);
      END_STATE();
    case 1065:
      ACCEPT_TOKEN(anon_sym_ref);
      if (lookahead == '.') ADVANCE(191);
      END_STATE();
    case 1066:
      ACCEPT_TOKEN(anon_sym_null);
      END_STATE();
    case 1067:
      ACCEPT_TOKEN(sym_reserved);
      END_STATE();
    case 1068:
      ACCEPT_TOKEN(sym_reserved);
      if (lookahead == ';') ADVANCE(948);
      END_STATE();
    case 1069:
      ACCEPT_TOKEN(sym_reserved);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(982);
      END_STATE();
    case 1070:
      ACCEPT_TOKEN(sym_reserved);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(1070);
      END_STATE();
    case 1071:
      ACCEPT_TOKEN(sym_share);
      END_STATE();
    case 1072:
      ACCEPT_TOKEN(sym_sign);
      END_STATE();
    case 1073:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 1074:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 1075:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '(') ADVANCE(1076);
      if (lookahead == ';') ADVANCE(1077);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1075);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1078);
      END_STATE();
    case 1076:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == ';') ADVANCE(1078);
      if (lookahead == '@') ADVANCE(1078);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1078);
      END_STATE();
    case 1077:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == ';') ADVANCE(1078);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1078);
      END_STATE();
    case 1078:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1078);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 3},
  [3] = {.lex_state = 3},
  [4] = {.lex_state = 3},
  [5] = {.lex_state = 3},
  [6] = {.lex_state = 3},
  [7] = {.lex_state = 3},
  [8] = {.lex_state = 3},
  [9] = {.lex_state = 3},
  [10] = {.lex_state = 3},
  [11] = {.lex_state = 3},
  [12] = {.lex_state = 3},
  [13] = {.lex_state = 3},
  [14] = {.lex_state = 3},
  [15] = {.lex_state = 3},
  [16] = {.lex_state = 3},
  [17] = {.lex_state = 3},
  [18] = {.lex_state = 3},
  [19] = {.lex_state = 3},
  [20] = {.lex_state = 3},
  [21] = {.lex_state = 3},
  [22] = {.lex_state = 3},
  [23] = {.lex_state = 3},
  [24] = {.lex_state = 3},
  [25] = {.lex_state = 3},
  [26] = {.lex_state = 3},
  [27] = {.lex_state = 3},
  [28] = {.lex_state = 3},
  [29] = {.lex_state = 3},
  [30] = {.lex_state = 3},
  [31] = {.lex_state = 3},
  [32] = {.lex_state = 3},
  [33] = {.lex_state = 3},
  [34] = {.lex_state = 3},
  [35] = {.lex_state = 3},
  [36] = {.lex_state = 3},
  [37] = {.lex_state = 3},
  [38] = {.lex_state = 3},
  [39] = {.lex_state = 3},
  [40] = {.lex_state = 3},
  [41] = {.lex_state = 3},
  [42] = {.lex_state = 3},
  [43] = {.lex_state = 3},
  [44] = {.lex_state = 3},
  [45] = {.lex_state = 3},
  [46] = {.lex_state = 3},
  [47] = {.lex_state = 3},
  [48] = {.lex_state = 3},
  [49] = {.lex_state = 3},
  [50] = {.lex_state = 3},
  [51] = {.lex_state = 3},
  [52] = {.lex_state = 3},
  [53] = {.lex_state = 3},
  [54] = {.lex_state = 3},
  [55] = {.lex_state = 3},
  [56] = {.lex_state = 3},
  [57] = {.lex_state = 3},
  [58] = {.lex_state = 3},
  [59] = {.lex_state = 3},
  [60] = {.lex_state = 3},
  [61] = {.lex_state = 3},
  [62] = {.lex_state = 3},
  [63] = {.lex_state = 3},
  [64] = {.lex_state = 3},
  [65] = {.lex_state = 3},
  [66] = {.lex_state = 3},
  [67] = {.lex_state = 3},
  [68] = {.lex_state = 3},
  [69] = {.lex_state = 3},
  [70] = {.lex_state = 3},
  [71] = {.lex_state = 3},
  [72] = {.lex_state = 3},
  [73] = {.lex_state = 3},
  [74] = {.lex_state = 3},
  [75] = {.lex_state = 3},
  [76] = {.lex_state = 3},
  [77] = {.lex_state = 3},
  [78] = {.lex_state = 3},
  [79] = {.lex_state = 3},
  [80] = {.lex_state = 3},
  [81] = {.lex_state = 3},
  [82] = {.lex_state = 3},
  [83] = {.lex_state = 3},
  [84] = {.lex_state = 3},
  [85] = {.lex_state = 3},
  [86] = {.lex_state = 3},
  [87] = {.lex_state = 3},
  [88] = {.lex_state = 3},
  [89] = {.lex_state = 3},
  [90] = {.lex_state = 3},
  [91] = {.lex_state = 3},
  [92] = {.lex_state = 3},
  [93] = {.lex_state = 3},
  [94] = {.lex_state = 3},
  [95] = {.lex_state = 3},
  [96] = {.lex_state = 3},
  [97] = {.lex_state = 3},
  [98] = {.lex_state = 3},
  [99] = {.lex_state = 3},
  [100] = {.lex_state = 3},
  [101] = {.lex_state = 3},
  [102] = {.lex_state = 3},
  [103] = {.lex_state = 3},
  [104] = {.lex_state = 3},
  [105] = {.lex_state = 3},
  [106] = {.lex_state = 3},
  [107] = {.lex_state = 3},
  [108] = {.lex_state = 3},
  [109] = {.lex_state = 3},
  [110] = {.lex_state = 3},
  [111] = {.lex_state = 3},
  [112] = {.lex_state = 3},
  [113] = {.lex_state = 3},
  [114] = {.lex_state = 3},
  [115] = {.lex_state = 3},
  [116] = {.lex_state = 3},
  [117] = {.lex_state = 3},
  [118] = {.lex_state = 3},
  [119] = {.lex_state = 3},
  [120] = {.lex_state = 3},
  [121] = {.lex_state = 3},
  [122] = {.lex_state = 3},
  [123] = {.lex_state = 3},
  [124] = {.lex_state = 3},
  [125] = {.lex_state = 3},
  [126] = {.lex_state = 3},
  [127] = {.lex_state = 3},
  [128] = {.lex_state = 3},
  [129] = {.lex_state = 3},
  [130] = {.lex_state = 3},
  [131] = {.lex_state = 3},
  [132] = {.lex_state = 3},
  [133] = {.lex_state = 3},
  [134] = {.lex_state = 3},
  [135] = {.lex_state = 3},
  [136] = {.lex_state = 3},
  [137] = {.lex_state = 3},
  [138] = {.lex_state = 3},
  [139] = {.lex_state = 3},
  [140] = {.lex_state = 3},
  [141] = {.lex_state = 3},
  [142] = {.lex_state = 3},
  [143] = {.lex_state = 3},
  [144] = {.lex_state = 3},
  [145] = {.lex_state = 3},
  [146] = {.lex_state = 3},
  [147] = {.lex_state = 3},
  [148] = {.lex_state = 3},
  [149] = {.lex_state = 3},
  [150] = {.lex_state = 3},
  [151] = {.lex_state = 3},
  [152] = {.lex_state = 3},
  [153] = {.lex_state = 3},
  [154] = {.lex_state = 3},
  [155] = {.lex_state = 3},
  [156] = {.lex_state = 3},
  [157] = {.lex_state = 3},
  [158] = {.lex_state = 3},
  [159] = {.lex_state = 3},
  [160] = {.lex_state = 3},
  [161] = {.lex_state = 3},
  [162] = {.lex_state = 3},
  [163] = {.lex_state = 3},
  [164] = {.lex_state = 3},
  [165] = {.lex_state = 3},
  [166] = {.lex_state = 3},
  [167] = {.lex_state = 3},
  [168] = {.lex_state = 3},
  [169] = {.lex_state = 3},
  [170] = {.lex_state = 3},
  [171] = {.lex_state = 3},
  [172] = {.lex_state = 3},
  [173] = {.lex_state = 3},
  [174] = {.lex_state = 3},
  [175] = {.lex_state = 3},
  [176] = {.lex_state = 3},
  [177] = {.lex_state = 3},
  [178] = {.lex_state = 4},
  [179] = {.lex_state = 3},
  [180] = {.lex_state = 3},
  [181] = {.lex_state = 3},
  [182] = {.lex_state = 3},
  [183] = {.lex_state = 3},
  [184] = {.lex_state = 3},
  [185] = {.lex_state = 4},
  [186] = {.lex_state = 11},
  [187] = {.lex_state = 3},
  [188] = {.lex_state = 11},
  [189] = {.lex_state = 11},
  [190] = {.lex_state = 4},
  [191] = {.lex_state = 11},
  [192] = {.lex_state = 3},
  [193] = {.lex_state = 3},
  [194] = {.lex_state = 3},
  [195] = {.lex_state = 3},
  [196] = {.lex_state = 3},
  [197] = {.lex_state = 3},
  [198] = {.lex_state = 11},
  [199] = {.lex_state = 11},
  [200] = {.lex_state = 3},
  [201] = {.lex_state = 10},
  [202] = {.lex_state = 11},
  [203] = {.lex_state = 10},
  [204] = {.lex_state = 11},
  [205] = {.lex_state = 11},
  [206] = {.lex_state = 11},
  [207] = {.lex_state = 3},
  [208] = {.lex_state = 3},
  [209] = {.lex_state = 3},
  [210] = {.lex_state = 3},
  [211] = {.lex_state = 3},
  [212] = {.lex_state = 3},
  [213] = {.lex_state = 3},
  [214] = {.lex_state = 3},
  [215] = {.lex_state = 3},
  [216] = {.lex_state = 3},
  [217] = {.lex_state = 3},
  [218] = {.lex_state = 3},
  [219] = {.lex_state = 3},
  [220] = {.lex_state = 3},
  [221] = {.lex_state = 3},
  [222] = {.lex_state = 3},
  [223] = {.lex_state = 3},
  [224] = {.lex_state = 3},
  [225] = {.lex_state = 3},
  [226] = {.lex_state = 3},
  [227] = {.lex_state = 3},
  [228] = {.lex_state = 3},
  [229] = {.lex_state = 3},
  [230] = {.lex_state = 3},
  [231] = {.lex_state = 3},
  [232] = {.lex_state = 3},
  [233] = {.lex_state = 3},
  [234] = {.lex_state = 3},
  [235] = {.lex_state = 3},
  [236] = {.lex_state = 3},
  [237] = {.lex_state = 3},
  [238] = {.lex_state = 3},
  [239] = {.lex_state = 3},
  [240] = {.lex_state = 3},
  [241] = {.lex_state = 3},
  [242] = {.lex_state = 3},
  [243] = {.lex_state = 3},
  [244] = {.lex_state = 3},
  [245] = {.lex_state = 3},
  [246] = {.lex_state = 3},
  [247] = {.lex_state = 3},
  [248] = {.lex_state = 3},
  [249] = {.lex_state = 3},
  [250] = {.lex_state = 3},
  [251] = {.lex_state = 3},
  [252] = {.lex_state = 3},
  [253] = {.lex_state = 3},
  [254] = {.lex_state = 3},
  [255] = {.lex_state = 3},
  [256] = {.lex_state = 3},
  [257] = {.lex_state = 3},
  [258] = {.lex_state = 3},
  [259] = {.lex_state = 3},
  [260] = {.lex_state = 3},
  [261] = {.lex_state = 3},
  [262] = {.lex_state = 3},
  [263] = {.lex_state = 3},
  [264] = {.lex_state = 3},
  [265] = {.lex_state = 3},
  [266] = {.lex_state = 3},
  [267] = {.lex_state = 3},
  [268] = {.lex_state = 3},
  [269] = {.lex_state = 3},
  [270] = {.lex_state = 3},
  [271] = {.lex_state = 3},
  [272] = {.lex_state = 3},
  [273] = {.lex_state = 3},
  [274] = {.lex_state = 3},
  [275] = {.lex_state = 3},
  [276] = {.lex_state = 3},
  [277] = {.lex_state = 3},
  [278] = {.lex_state = 3},
  [279] = {.lex_state = 3},
  [280] = {.lex_state = 3},
  [281] = {.lex_state = 3},
  [282] = {.lex_state = 3},
  [283] = {.lex_state = 3},
  [284] = {.lex_state = 3},
  [285] = {.lex_state = 3},
  [286] = {.lex_state = 3},
  [287] = {.lex_state = 3},
  [288] = {.lex_state = 3},
  [289] = {.lex_state = 3},
  [290] = {.lex_state = 3},
  [291] = {.lex_state = 3},
  [292] = {.lex_state = 3},
  [293] = {.lex_state = 3},
  [294] = {.lex_state = 3},
  [295] = {.lex_state = 3},
  [296] = {.lex_state = 3},
  [297] = {.lex_state = 3},
  [298] = {.lex_state = 3},
  [299] = {.lex_state = 3},
  [300] = {.lex_state = 3},
  [301] = {.lex_state = 3},
  [302] = {.lex_state = 3},
  [303] = {.lex_state = 3},
  [304] = {.lex_state = 3},
  [305] = {.lex_state = 3},
  [306] = {.lex_state = 3},
  [307] = {.lex_state = 3},
  [308] = {.lex_state = 3},
  [309] = {.lex_state = 3},
  [310] = {.lex_state = 3},
  [311] = {.lex_state = 3},
  [312] = {.lex_state = 5},
  [313] = {.lex_state = 5},
  [314] = {.lex_state = 5},
  [315] = {.lex_state = 5},
  [316] = {.lex_state = 5},
  [317] = {.lex_state = 5},
  [318] = {.lex_state = 5},
  [319] = {.lex_state = 5},
  [320] = {.lex_state = 5},
  [321] = {.lex_state = 5},
  [322] = {.lex_state = 5},
  [323] = {.lex_state = 3},
  [324] = {.lex_state = 5},
  [325] = {.lex_state = 5},
  [326] = {.lex_state = 0},
  [327] = {.lex_state = 3},
  [328] = {.lex_state = 5},
  [329] = {.lex_state = 3},
  [330] = {.lex_state = 3},
  [331] = {.lex_state = 5},
  [332] = {.lex_state = 5},
  [333] = {.lex_state = 5},
  [334] = {.lex_state = 5},
  [335] = {.lex_state = 5},
  [336] = {.lex_state = 3},
  [337] = {.lex_state = 5},
  [338] = {.lex_state = 5},
  [339] = {.lex_state = 5},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 3},
  [344] = {.lex_state = 5},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 5},
  [348] = {.lex_state = 5},
  [349] = {.lex_state = 5},
  [350] = {.lex_state = 3},
  [351] = {.lex_state = 3},
  [352] = {.lex_state = 12},
  [353] = {.lex_state = 7},
  [354] = {.lex_state = 3},
  [355] = {.lex_state = 3},
  [356] = {.lex_state = 7},
  [357] = {.lex_state = 7},
  [358] = {.lex_state = 3},
  [359] = {.lex_state = 7},
  [360] = {.lex_state = 7},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 12},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 5},
  [368] = {.lex_state = 5},
  [369] = {.lex_state = 5},
  [370] = {.lex_state = 5},
  [371] = {.lex_state = 5},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 5},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 5},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 3},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 3},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 3},
  [394] = {.lex_state = 3},
  [395] = {.lex_state = 0},
  [396] = {.lex_state = 3},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 3},
  [399] = {.lex_state = 9},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 3},
  [402] = {.lex_state = 10},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 10},
  [406] = {.lex_state = 10},
  [407] = {.lex_state = 10},
  [408] = {.lex_state = 9},
  [409] = {.lex_state = 3},
  [410] = {.lex_state = 10},
  [411] = {.lex_state = 10},
  [412] = {.lex_state = 10},
  [413] = {.lex_state = 10},
  [414] = {.lex_state = 10},
  [415] = {.lex_state = 10},
  [416] = {.lex_state = 10},
  [417] = {.lex_state = 0},
  [418] = {.lex_state = 10},
  [419] = {.lex_state = 10},
  [420] = {.lex_state = 10},
  [421] = {.lex_state = 10},
  [422] = {.lex_state = 10},
  [423] = {.lex_state = 10},
  [424] = {.lex_state = 10},
  [425] = {.lex_state = 10},
  [426] = {.lex_state = 0},
  [427] = {.lex_state = 12},
  [428] = {.lex_state = 10},
  [429] = {.lex_state = 9},
  [430] = {.lex_state = 3},
  [431] = {.lex_state = 10},
  [432] = {.lex_state = 10},
  [433] = {.lex_state = 10},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 7},
  [436] = {.lex_state = 7},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 3},
  [439] = {.lex_state = 3},
  [440] = {.lex_state = 3},
  [441] = {.lex_state = 3},
  [442] = {.lex_state = 3},
  [443] = {.lex_state = 7},
  [444] = {.lex_state = 7},
  [445] = {.lex_state = 7},
  [446] = {.lex_state = 0},
  [447] = {.lex_state = 3},
  [448] = {.lex_state = 3},
  [449] = {.lex_state = 3},
  [450] = {.lex_state = 3},
  [451] = {.lex_state = 3},
  [452] = {.lex_state = 3},
  [453] = {.lex_state = 0},
  [454] = {.lex_state = 3},
  [455] = {.lex_state = 3},
  [456] = {.lex_state = 3},
  [457] = {.lex_state = 3},
  [458] = {.lex_state = 3},
  [459] = {.lex_state = 3},
  [460] = {.lex_state = 3},
  [461] = {.lex_state = 7},
  [462] = {.lex_state = 3},
  [463] = {.lex_state = 3},
  [464] = {.lex_state = 3},
  [465] = {.lex_state = 3},
  [466] = {.lex_state = 3},
  [467] = {.lex_state = 3},
  [468] = {.lex_state = 3},
  [469] = {.lex_state = 7},
  [470] = {.lex_state = 3},
  [471] = {.lex_state = 3},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 3},
  [474] = {.lex_state = 3},
  [475] = {.lex_state = 3},
  [476] = {.lex_state = 3},
  [477] = {.lex_state = 3},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 3},
  [480] = {.lex_state = 3},
  [481] = {.lex_state = 3},
  [482] = {.lex_state = 3},
  [483] = {.lex_state = 3},
  [484] = {.lex_state = 3},
  [485] = {.lex_state = 3},
  [486] = {.lex_state = 3},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 3},
  [489] = {.lex_state = 3},
  [490] = {.lex_state = 3},
  [491] = {.lex_state = 3},
  [492] = {.lex_state = 3},
  [493] = {.lex_state = 3},
  [494] = {.lex_state = 3},
  [495] = {.lex_state = 3},
  [496] = {.lex_state = 3},
  [497] = {.lex_state = 7},
  [498] = {.lex_state = 3},
  [499] = {.lex_state = 3},
  [500] = {.lex_state = 3},
  [501] = {.lex_state = 7},
  [502] = {.lex_state = 0},
  [503] = {.lex_state = 0},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 16},
  [506] = {.lex_state = 1},
  [507] = {.lex_state = 16},
  [508] = {.lex_state = 1},
  [509] = {.lex_state = 1},
  [510] = {.lex_state = 16},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 0},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 0},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 16},
  [519] = {.lex_state = 3},
  [520] = {.lex_state = 1},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 16},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 1},
  [527] = {.lex_state = 12},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 12},
  [530] = {.lex_state = 0},
  [531] = {.lex_state = 3},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 3},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 10},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 0},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 0},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 16},
  [548] = {.lex_state = 3},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 3},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 16},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 16},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 16},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 1},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 16},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 5},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 0},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 16},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 0},
  [617] = {.lex_state = 16},
  [618] = {.lex_state = 0},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 16},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 16},
  [623] = {.lex_state = 0},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 16},
  [626] = {.lex_state = 0},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 16},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 15},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 5},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 12},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 12},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 12},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 0},
  [798] = {.lex_state = 5},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 0},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0},
  [811] = {(TSStateId)(-1)},
  [812] = {(TSStateId)(-1)},
  [813] = {(TSStateId)(-1)},
  [814] = {(TSStateId)(-1)},
  [815] = {(TSStateId)(-1)},
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_annotation] = STATE(0),
    [sym_comment_block] = STATE(0),
    [sym_comment_line] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_align] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [sym_align_offset_value] = ACTIONS(1),
    [anon_sym_LPAREN_AT] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_block] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_loop] = ACTIONS(1),
    [anon_sym_LPAREN_SEMI] = ACTIONS(5),
    [anon_sym_SEMI_RPAREN] = ACTIONS(1),
    [aux_sym_comment_line_token1] = ACTIONS(7),
    [sym_dec_nat] = ACTIONS(1),
    [anon_sym_item] = ACTIONS(1),
    [anon_sym_func] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_memory] = ACTIONS(1),
    [anon_sym_table] = ACTIONS(1),
    [anon_sym_call_indirect] = ACTIONS(1),
    [anon_sym_inf] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_param] = ACTIONS(1),
    [anon_sym_result] = ACTIONS(1),
    [anon_sym_mut] = ACTIONS(1),
    [sym_hex_float] = ACTIONS(1),
    [sym_hex_nat] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_br_table] = ACTIONS(1),
    [anon_sym_ref_DOTextern] = ACTIONS(1),
    [anon_sym_ref_DOTnull] = ACTIONS(1),
    [sym_op_nullary] = ACTIONS(1),
    [sym_op_index] = ACTIONS(1),
    [sym_op_index_opt] = ACTIONS(1),
    [sym_op_index_opt_offset_opt_align_opt] = ACTIONS(1),
    [sym_op_simd_offset_opt_align_opt] = ACTIONS(1),
    [aux_sym_op_const_token1] = ACTIONS(1),
    [aux_sym_op_const_token2] = ACTIONS(1),
    [anon_sym_func_DOTbind] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_select] = ACTIONS(1),
    [anon_sym_v128_DOTconst] = ACTIONS(1),
    [anon_sym_f32x4] = ACTIONS(1),
    [anon_sym_f64x2] = ACTIONS(1),
    [anon_sym_i8x16] = ACTIONS(1),
    [anon_sym_i16x8] = ACTIONS(1),
    [anon_sym_i32x4] = ACTIONS(1),
    [anon_sym_i64x2] = ACTIONS(1),
    [anon_sym_DOTshuffle] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_extract_lane] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [aux_sym_op_simd_lane_token1] = ACTIONS(1),
    [anon_sym_replace_lane] = ACTIONS(1),
    [anon_sym_table_DOTcopy] = ACTIONS(1),
    [anon_sym_table_DOTinit] = ACTIONS(1),
    [anon_sym_data] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_elem] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_start] = ACTIONS(1),
    [sym_nan] = ACTIONS(1),
    [sym_num_type_f32] = ACTIONS(1),
    [sym_num_type_f64] = ACTIONS(1),
    [sym_num_type_i32] = ACTIONS(1),
    [sym_num_type_i64] = ACTIONS(1),
    [sym_num_type_v128] = ACTIONS(1),
    [anon_sym_offset] = ACTIONS(1),
    [sym_ref_kind] = ACTIONS(1),
    [anon_sym_ref] = ACTIONS(1),
    [anon_sym_null] = ACTIONS(1),
    [sym_share] = ACTIONS(1),
    [sym_sign] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
  },
  [1] = {
    [sym_ROOT] = STATE(756),
    [sym_annotation] = STATE(1),
    [sym_comment_block] = STATE(1),
    [sym_comment_line] = STATE(1),
    [sym_module] = STATE(746),
    [sym_module_field] = STATE(538),
    [sym_module_field_data] = STATE(577),
    [sym_module_field_elem] = STATE(577),
    [sym_module_field_export] = STATE(577),
    [sym_module_field_func] = STATE(577),
    [sym_module_field_global] = STATE(577),
    [sym_module_field_import] = STATE(577),
    [sym_module_field_memory] = STATE(577),
    [sym_module_field_start] = STATE(577),
    [sym_module_field_table] = STATE(577),
    [sym_module_field_type] = STATE(577),
    [aux_sym_ROOT_repeat1] = STATE(342),
    [ts_builtin_sym_end] = ACTIONS(9),
    [anon_sym_LPAREN_AT] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_LPAREN_SEMI] = ACTIONS(5),
    [aux_sym_comment_line_token1] = ACTIONS(7),
  },
  [2] = {
    [sym_annotation] = STATE(2),
    [sym_block_block] = STATE(288),
    [sym_block_if] = STATE(288),
    [sym_block_loop] = STATE(288),
    [sym_comment_block] = STATE(2),
    [sym_comment_line] = STATE(2),
    [sym_export] = STATE(191),
    [sym_expr] = STATE(302),
    [sym_func_locals] = STATE(296),
    [sym_func_locals_many] = STATE(289),
    [sym_func_locals_one] = STATE(289),
    [sym_func_type_params] = STATE(284),
    [sym_func_type_params_many] = STATE(252),
    [sym_func_type_params_one] = STATE(252),
    [sym_func_type_results] = STATE(254),
    [sym_import] = STATE(8),
    [sym_instr] = STATE(261),
    [sym_instr_block] = STATE(302),
    [sym_instr_call] = STATE(302),
    [sym_instr_list] = STATE(653),
    [sym_instr_list_call] = STATE(261),
    [sym_instr_plain] = STATE(302),
    [sym_op_const] = STATE(262),
    [sym_op_func_bind] = STATE(262),
    [sym_op_let] = STATE(262),
    [sym_op_select] = STATE(262),
    [sym_op_simd_const] = STATE(262),
    [sym_op_simd_lane] = STATE(262),
    [sym_op_table_copy] = STATE(262),
    [sym_op_table_init] = STATE(262),
    [sym_type_use] = STATE(18),
    [aux_sym_block_block_repeat2] = STATE(33),
    [aux_sym_instr_list_repeat1] = STATE(106),
    [aux_sym_op_let_repeat1] = STATE(19),
    [aux_sym_op_let_repeat2] = STATE(79),
    [aux_sym_module_field_func_repeat1] = STATE(4),
    [anon_sym_LPAREN_AT] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_block] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_loop] = ACTIONS(21),
    [anon_sym_LPAREN_SEMI] = ACTIONS(5),
    [aux_sym_comment_line_token1] = ACTIONS(7),
    [anon_sym_call_indirect] = ACTIONS(23),
    [sym_identifier] = ACTIONS(25),
    [anon_sym_br_table] = ACTIONS(27),
    [anon_sym_ref_DOTextern] = ACTIONS(29),
    [anon_sym_ref_DOTnull] = ACTIONS(31),
    [sym_op_nullary] = ACTIONS(33),
    [sym_op_index] = ACTIONS(35),
    [sym_op_index_opt] = ACTIONS(37),
    [sym_op_index_opt_offset_opt_align_opt] = ACTIONS(39),
    [sym_op_simd_offset_opt_align_opt] = ACTIONS(41),
    [aux_sym_op_const_token1] = ACTIONS(43),
    [aux_sym_op_const_token2] = ACTIONS(45),
    [anon_sym_func_DOTbind] = ACTIONS(47),
    [anon_sym_let] = ACTIONS(49),
    [anon_sym_select] = ACTIONS(51),
    [anon_sym_v128_DOTconst] = ACTIONS(53),
    [anon_sym_f32x4] = ACTIONS(55),
    [anon_sym_f64x2] = ACTIONS(55),
    [anon_sym_i8x16] = ACTIONS(57),
    [anon_sym_i16x8] = ACTIONS(59),
    [anon_sym_i32x4] = ACTIONS(55),
    [anon_sym_i64x2] = ACTIONS(55),
    [anon_sym_table_DOTcopy] = ACTIONS(61),
    [anon_sym_table_DOTinit] = ACTIONS(63),
  },
  [3] = {
    [sym_annotation] = STATE(3),
    [sym_block_block] = STATE(288),
    [sym_block_if] = STATE(288),
    [sym_block_loop] = STATE(288),
    [sym_comment_block] = STATE(3),
    [sym_comment_line] = STATE(3),
    [sym_export] = STATE(191),
    [sym_expr] = STATE(302),
    [sym_func_locals] = STATE(296),
    [sym_func_locals_many] = STATE(289),
    [sym_func_locals_one] = STATE(289),
    [sym_func_type_params] = STATE(284),
    [sym_func_type_params_many] = STATE(252),
    [sym_func_type_params_one] = STATE(252),
    [sym_func_type_results] = STATE(254),
    [sym_import] = STATE(9),
    [sym_instr] = STATE(261),
    [sym_instr_block] = STATE(302),
    [sym_instr_call] = STATE(302),
    [sym_instr_list] = STATE(709),
    [sym_instr_list_call] = STATE(261),
    [sym_instr_plain] = STATE(302),
    [sym_op_const] = STATE(262),
    [sym_op_func_bind] = STATE(262),
    [sym_op_let] = STATE(262),
    [sym_op_select] = STATE(262),
    [sym_op_simd_const] = STATE(262),
    [sym_op_simd_lane] = STATE(262),
    [sym_op_table_copy] = STATE(262),
    [sym_op_table_init] = STATE(262),
    [sym_type_use] = STATE(23),
    [aux_sym_block_block_repeat2] = STATE(29),
    [aux_sym_instr_list_repeat1] = STATE(106),
    [aux_sym_op_let_repeat1] = STATE(21),
    [aux_sym_op_let_repeat2] = STATE(81),
    [aux_sym_module_field_func_repeat1] = STATE(186),
    [anon_sym_LPAREN_AT] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_block] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_loop] = ACTIONS(21),
    [anon_sym_LPAREN_SEMI] = ACTIONS(5),
    [aux_sym_comment_line_token1] = ACTIONS(7),
    [anon_sym_call_indirect] = ACTIONS(23),
    [anon_sym_br_table] = ACTIONS(27),
    [anon_sym_ref_DOTextern] = ACTIONS(29),
    [anon_sym_ref_DOTnull] = ACTIONS(31),
    [sym_op_nullary] = ACTIONS(33),
    [sym_op_index] = ACTIONS(35),
    [sym_op_index_opt] = ACTIONS(37),
    [sym_op_index_opt_offset_opt_align_opt] = ACTIONS(39),
    [sym_op_simd_offset_opt_align_opt] = ACTIONS(41),
    [aux_sym_op_const_token1] = ACTIONS(43),
    [aux_sym_op_const_token2] = ACTIONS(45),
    [anon_sym_func_DOTbind] = ACTIONS(47),
    [anon_sym_let] = ACTIONS(49),
    [anon_sym_select] = ACTIONS(51),
    [anon_sym_v128_DOTconst] = ACTIONS(53),
    [anon_sym_f32x4] = ACTIONS(55),
    [anon_sym_f64x2] = ACTIONS(55),
    [anon_sym_i8x16] = ACTIONS(57),
    [anon_sym_i16x8] = ACTIONS(59),
    [anon_sym_i32x4] = ACTIONS(55),
    [anon_sym_i64x2] = ACTIONS(55),
    [anon_sym_table_DOTcopy] = ACTIONS(61),
    [anon_sym_table_DOTinit] = ACTIONS(63),
  },
  [4] = {
    [sym_annotation] = STATE(4),
    [sym_block_block] = STATE(288),
    [sym_block_if] = STATE(288),
    [sym_block_loop] = STATE(288),
    [sym_comment_block] = STATE(4),
    [sym_comment_line] = STATE(4),
    [sym_export] = STATE(191),
    [sym_expr] = STATE(302),
    [sym_func_locals] = STATE(296),
    [sym_func_locals_many] = STATE(289),
    [sym_func_locals_one] = STATE(289),
    [sym_func_type_params] = STATE(284),
    [sym_func_type_params_many] = STATE(252),
    [sym_func_type_params_one] = STATE(252),
    [sym_func_type_results] = STATE(254),
    [sym_import] = STATE(6),
    [sym_instr] = STATE(261),
    [sym_instr_block] = STATE(302),
    [sym_instr_call] = STATE(302),
    [sym_instr_list] = STATE(743),
    [sym_instr_list_call] = STATE(261),
    [sym_instr_plain] = STATE(302),
    [sym_op_const] = STATE(262),
    [sym_op_func_bind] = STATE(262),
    [sym_op_let] = STATE(262),
    [sym_op_select] = STATE(262),
    [sym_op_simd_const] = STATE(262),
    [sym_op_simd_lane] = STATE(262),
    [sym_op_table_copy] = STATE(262),
    [sym_op_table_init] = STATE(262),
    [sym_type_use] = STATE(14),
    [aux_sym_block_block_repeat2] = STATE(38),
    [aux_sym_instr_list_repeat1] = STATE(106),
    [aux_sym_op_let_repeat1] = STATE(16),
    [aux_sym_op_let_repeat2] = STATE(74),
    [aux_sym_module_field_func_repeat1] = STATE(186),
    [anon_sym_LPAREN_AT] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(67),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_block] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_loop] = ACTIONS(21),
    [anon_sym_LPAREN_SEMI] = ACTIONS(5),
    [aux_sym_comment_line_token1] = ACTIONS(7),
    [anon_sym_call_indirect] = ACTIONS(23),
    [anon_sym_br_table] = ACTIONS(27),
    [anon_sym_ref_DOTextern] = ACTIONS(29),
    [anon_sym_ref_DOTnull] = ACTIONS(31),
    [sym_op_nullary] = ACTIONS(33),
    [sym_op_index] = ACTIONS(35),
    [sym_op_index_opt] = ACTIONS(37),
    [sym_op_index_opt_offset_opt_align_opt] = ACTIONS(39),
    [sym_op_simd_offset_opt_align_opt] = ACTIONS(41),
    [aux_sym_op_const_token1] = ACTIONS(43),
    [aux_sym_op_const_token2] = ACTIONS(45),
    [anon_sym_func_DOTbind] = ACTIONS(47),
    [anon_sym_let] = ACTIONS(49),
    [anon_sym_select] = ACTIONS(51),
    [anon_sym_v128_DOTconst] = ACTIONS(53),
    [anon_sym_f32x4] = ACTIONS(55),
    [anon_sym_f64x2] = ACTIONS(55),
    [anon_sym_i8x16] = ACTIONS(57),
    [anon_sym_i16x8] = ACTIONS(59),
    [anon_sym_i32x4] = ACTIONS(55),
    [anon_sym_i64x2] = ACTIONS(55),
    [anon_sym_table_DOTcopy] = ACTIONS(61),
    [anon_sym_table_DOTinit] = ACTIONS(63),
  },
  [5] = {
    [sym_annotation] = STATE(5),
    [sym_block_block] = STATE(288),
    [sym_block_if] = STATE(288),
    [sym_block_loop] = STATE(288),
    [sym_comment_block] = STATE(5),
    [sym_comment_line] = STATE(5),
    [sym_export] = STATE(191),
    [sym_expr] = STATE(302),
    [sym_func_locals] = STATE(296),
    [sym_func_locals_many] = STATE(289),
    [sym_func_locals_one] = STATE(289),
    [sym_func_type_params] = STATE(284),
    [sym_func_type_params_many] = STATE(252),
    [sym_func_type_params_one] = STATE(252),
    [sym_func_type_results] = STATE(254),
    [sym_import] = STATE(7),
    [sym_instr] = STATE(261),
    [sym_instr_block] = STATE(302),
    [sym_instr_call] = STATE(302),
    [sym_instr_list] = STATE(772),
    [sym_instr_list_call] = STATE(261),
    [sym_instr_plain] = STATE(302),
    [sym_op_const] = STATE(262),
    [sym_op_func_bind] = STATE(262),
    [sym_op_let] = STATE(262),
    [sym_op_select] = STATE(262),
    [sym_op_simd_const] = STATE(262),
    [sym_op_simd_lane] = STATE(262),
    [sym_op_table_copy] = STATE(262),
    [sym_op_table_init] = STATE(262),
    [sym_type_use] = STATE(11),
    [aux_sym_block_block_repeat2] = STATE(39),
    [aux_sym_instr_list_repeat1] = STATE(106),
    [aux_sym_op_let_repeat1] = STATE(13),
    [aux_sym_op_let_repeat2] = STATE(67),
    [aux_sym_module_field_func_repeat1] = STATE(3),
    [anon_sym_LPAREN_AT] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_block] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_loop] = ACTIONS(21),
    [anon_sym_LPAREN_SEMI] = ACTIONS(5),
    [aux_sym_comment_line_token1] = ACTIONS(7),
    [anon_sym_call_indirect] = ACTIONS(23),
    [anon_sym_br_table] = ACTIONS(27),
    [anon_sym_ref_DOTextern] = ACTIONS(29),
    [anon_sym_ref_DOTnull] = ACTIONS(31),
    [sym_op_nullary] = ACTIONS(33),
    [sym_op_index] = ACTIONS(35),
    [sym_op_index_opt] = ACTIONS(37),
    [sym_op_index_opt_offset_opt_align_opt] = ACTIONS(39),
    [sym_op_simd_offset_opt_align_opt] = ACTIONS(41),
    [aux_sym_op_const_token1] = ACTIONS(43),
    [aux_sym_op_const_token2] = ACTIONS(45),
    [anon_sym_func_DOTbind] = ACTIONS(47),
    [anon_sym_let] = ACTIONS(49),
    [anon_sym_select] = ACTIONS(51),
    [anon_sym_v128_DOTconst] = ACTIONS(53),
    [anon_sym_f32x4] = ACTIONS(55),
    [anon_sym_f64x2] = ACTIONS(55),
    [anon_sym_i8x16] = ACTIONS(57),
    [anon_sym_i16x8] = ACTIONS(59),
    [anon_sym_i32x4] = ACTIONS(55),
    [anon_sym_i64x2] = ACTIONS(55),
    [anon_sym_table_DOTcopy] = ACTIONS(61),
    [anon_sym_table_DOTinit] = ACTIONS(63),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 44,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(71), 1,
      anon_sym_RPAREN,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    STATE(12), 1,
      aux_sym_op_let_repeat1,
    STATE(22), 1,
      sym_type_use,
    STATE(25), 1,
      aux_sym_block_block_repeat2,
    STATE(70), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(725), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(6), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [153] = 44,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(65), 1,
      anon_sym_RPAREN,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    STATE(21), 1,
      aux_sym_op_let_repeat1,
    STATE(23), 1,
      sym_type_use,
    STATE(29), 1,
      aux_sym_block_block_repeat2,
    STATE(81), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(709), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(7), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [306] = 44,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(67), 1,
      anon_sym_RPAREN,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    STATE(14), 1,
      sym_type_use,
    STATE(16), 1,
      aux_sym_op_let_repeat1,
    STATE(38), 1,
      aux_sym_block_block_repeat2,
    STATE(74), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(743), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(8), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [459] = 44,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_RPAREN,
    STATE(10), 1,
      aux_sym_op_let_repeat1,
    STATE(15), 1,
      sym_type_use,
    STATE(34), 1,
      aux_sym_block_block_repeat2,
    STATE(53), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(803), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(9), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [612] = 43,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(77), 1,
      anon_sym_RPAREN,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    STATE(36), 1,
      aux_sym_block_block_repeat2,
    STATE(56), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(210), 1,
      aux_sym_op_let_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(678), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(10), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [762] = 43,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(65), 1,
      anon_sym_RPAREN,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    STATE(21), 1,
      aux_sym_op_let_repeat1,
    STATE(29), 1,
      aux_sym_block_block_repeat2,
    STATE(81), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(709), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(11), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [912] = 43,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_RPAREN,
    STATE(31), 1,
      aux_sym_block_block_repeat2,
    STATE(52), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(210), 1,
      aux_sym_op_let_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(795), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(12), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [1062] = 43,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(65), 1,
      anon_sym_RPAREN,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    STATE(29), 1,
      aux_sym_block_block_repeat2,
    STATE(81), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(210), 1,
      aux_sym_op_let_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(709), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(13), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [1212] = 43,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(71), 1,
      anon_sym_RPAREN,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    STATE(12), 1,
      aux_sym_op_let_repeat1,
    STATE(25), 1,
      aux_sym_block_block_repeat2,
    STATE(70), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(725), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(14), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [1362] = 43,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(77), 1,
      anon_sym_RPAREN,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    STATE(17), 1,
      aux_sym_op_let_repeat1,
    STATE(36), 1,
      aux_sym_block_block_repeat2,
    STATE(56), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(678), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(15), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [1512] = 43,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(71), 1,
      anon_sym_RPAREN,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    STATE(25), 1,
      aux_sym_block_block_repeat2,
    STATE(70), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(210), 1,
      aux_sym_op_let_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(725), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(16), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [1662] = 43,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_RPAREN,
    STATE(37), 1,
      aux_sym_block_block_repeat2,
    STATE(73), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(210), 1,
      aux_sym_op_let_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(681), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(17), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [1812] = 43,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(67), 1,
      anon_sym_RPAREN,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    STATE(16), 1,
      aux_sym_op_let_repeat1,
    STATE(38), 1,
      aux_sym_block_block_repeat2,
    STATE(74), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(743), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(18), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [1962] = 43,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(67), 1,
      anon_sym_RPAREN,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    STATE(38), 1,
      aux_sym_block_block_repeat2,
    STATE(74), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(210), 1,
      aux_sym_op_let_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(743), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(19), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [2112] = 43,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_RPAREN,
    STATE(30), 1,
      aux_sym_block_block_repeat2,
    STATE(68), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(210), 1,
      aux_sym_op_let_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(668), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(20), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [2262] = 43,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(75), 1,
      anon_sym_RPAREN,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    STATE(34), 1,
      aux_sym_block_block_repeat2,
    STATE(53), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(210), 1,
      aux_sym_op_let_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(803), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(21), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [2412] = 43,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_RPAREN,
    STATE(20), 1,
      aux_sym_op_let_repeat1,
    STATE(31), 1,
      aux_sym_block_block_repeat2,
    STATE(52), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(795), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(22), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [2562] = 43,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(75), 1,
      anon_sym_RPAREN,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    STATE(10), 1,
      aux_sym_op_let_repeat1,
    STATE(34), 1,
      aux_sym_block_block_repeat2,
    STATE(53), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(803), 1,
      sym_instr_list,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(23), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [2712] = 42,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(87), 1,
      anon_sym_LPAREN,
    ACTIONS(89), 1,
      anon_sym_end,
    ACTIONS(91), 1,
      anon_sym_else,
    ACTIONS(93), 1,
      sym_identifier,
    STATE(44), 1,
      aux_sym_block_block_repeat1,
    STATE(45), 1,
      sym_type_use,
    STATE(88), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(630), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(24), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [2857] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(81), 1,
      anon_sym_RPAREN,
    ACTIONS(95), 1,
      anon_sym_LPAREN,
    STATE(52), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(296), 1,
      sym_func_locals,
    STATE(795), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(25), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [2997] = 41,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(87), 1,
      anon_sym_LPAREN,
    ACTIONS(97), 1,
      anon_sym_end,
    ACTIONS(99), 1,
      sym_identifier,
    STATE(54), 1,
      sym_type_use,
    STATE(55), 1,
      aux_sym_block_block_repeat1,
    STATE(93), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(792), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(26), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [3139] = 41,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(87), 1,
      anon_sym_LPAREN,
    ACTIONS(101), 1,
      anon_sym_RPAREN,
    ACTIONS(103), 1,
      sym_identifier,
    STATE(49), 1,
      aux_sym_block_block_repeat1,
    STATE(78), 1,
      sym_type_use,
    STATE(100), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(671), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(27), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [3281] = 41,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(87), 1,
      anon_sym_LPAREN,
    ACTIONS(105), 1,
      anon_sym_end,
    ACTIONS(107), 1,
      anon_sym_else,
    STATE(42), 1,
      aux_sym_block_block_repeat1,
    STATE(47), 1,
      sym_type_use,
    STATE(87), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(618), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(28), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [3423] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(75), 1,
      anon_sym_RPAREN,
    ACTIONS(95), 1,
      anon_sym_LPAREN,
    STATE(53), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(296), 1,
      sym_func_locals,
    STATE(803), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(29), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [3563] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(95), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(296), 1,
      sym_func_locals,
    STATE(690), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(30), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [3703] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(85), 1,
      anon_sym_RPAREN,
    ACTIONS(95), 1,
      anon_sym_LPAREN,
    STATE(68), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(296), 1,
      sym_func_locals,
    STATE(668), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(31), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [3843] = 41,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(87), 1,
      anon_sym_LPAREN,
    ACTIONS(111), 1,
      anon_sym_RPAREN,
    ACTIONS(113), 1,
      sym_identifier,
    STATE(76), 1,
      sym_type_use,
    STATE(77), 1,
      aux_sym_block_block_repeat1,
    STATE(104), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(666), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(32), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [3985] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(67), 1,
      anon_sym_RPAREN,
    ACTIONS(95), 1,
      anon_sym_LPAREN,
    STATE(74), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(296), 1,
      sym_func_locals,
    STATE(743), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(33), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [4125] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(77), 1,
      anon_sym_RPAREN,
    ACTIONS(95), 1,
      anon_sym_LPAREN,
    STATE(56), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(296), 1,
      sym_func_locals,
    STATE(678), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(34), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [4265] = 41,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(87), 1,
      anon_sym_LPAREN,
    ACTIONS(115), 1,
      anon_sym_end,
    ACTIONS(117), 1,
      sym_identifier,
    STATE(59), 1,
      sym_type_use,
    STATE(60), 1,
      aux_sym_block_block_repeat1,
    STATE(99), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(782), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(35), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [4407] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(83), 1,
      anon_sym_RPAREN,
    ACTIONS(95), 1,
      anon_sym_LPAREN,
    STATE(73), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(296), 1,
      sym_func_locals,
    STATE(681), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(36), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [4547] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(95), 1,
      anon_sym_LPAREN,
    ACTIONS(119), 1,
      anon_sym_RPAREN,
    STATE(66), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(296), 1,
      sym_func_locals,
    STATE(723), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(37), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [4687] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(71), 1,
      anon_sym_RPAREN,
    ACTIONS(95), 1,
      anon_sym_LPAREN,
    STATE(70), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(296), 1,
      sym_func_locals,
    STATE(725), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(38), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [4827] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(65), 1,
      anon_sym_RPAREN,
    ACTIONS(95), 1,
      anon_sym_LPAREN,
    STATE(81), 1,
      aux_sym_op_let_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(296), 1,
      sym_func_locals,
    STATE(709), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(39), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [4967] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(123), 1,
      anon_sym_end,
    ACTIONS(125), 1,
      anon_sym_else,
    STATE(83), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(616), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(40), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [5106] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(87), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_end,
    STATE(58), 1,
      sym_type_use,
    STATE(61), 1,
      aux_sym_block_block_repeat1,
    STATE(94), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(705), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(41), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [5245] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_end,
    ACTIONS(131), 1,
      anon_sym_else,
    STATE(85), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(628), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(42), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [5384] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(87), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_RPAREN,
    STATE(50), 1,
      aux_sym_block_block_repeat1,
    STATE(69), 1,
      sym_type_use,
    STATE(91), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(676), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(43), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [5523] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(105), 1,
      anon_sym_end,
    ACTIONS(107), 1,
      anon_sym_else,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    STATE(87), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(618), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(44), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [5662] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(105), 1,
      anon_sym_end,
    ACTIONS(107), 1,
      anon_sym_else,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    STATE(42), 1,
      aux_sym_block_block_repeat1,
    STATE(87), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(618), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(45), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [5801] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(87), 1,
      anon_sym_LPAREN,
    ACTIONS(135), 1,
      anon_sym_RPAREN,
    STATE(64), 1,
      aux_sym_block_block_repeat1,
    STATE(65), 1,
      sym_type_use,
    STATE(96), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(721), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(46), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [5940] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_end,
    ACTIONS(131), 1,
      anon_sym_else,
    STATE(40), 1,
      aux_sym_block_block_repeat1,
    STATE(85), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(628), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(47), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [6079] = 40,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(87), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_end,
    STATE(63), 1,
      aux_sym_block_block_repeat1,
    STATE(80), 1,
      sym_type_use,
    STATE(97), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(680), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(48), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [6218] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(135), 1,
      anon_sym_RPAREN,
    STATE(96), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(721), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(49), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [6354] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
    STATE(89), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(739), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(50), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [6490] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(87), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    STATE(82), 1,
      aux_sym_block_block_repeat1,
    STATE(84), 1,
      sym_type_use,
    STATE(116), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(271), 1,
      sym_instr,
    STATE(295), 1,
      sym_func_type_params_many,
    ACTIONS(141), 3,
      anon_sym_RPAREN,
      anon_sym_end,
      anon_sym_else,
    STATE(51), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [6624] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(85), 1,
      anon_sym_RPAREN,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(212), 1,
      aux_sym_op_let_repeat2,
    STATE(296), 1,
      sym_func_locals,
    STATE(668), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(52), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [6758] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(77), 1,
      anon_sym_RPAREN,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(212), 1,
      aux_sym_op_let_repeat2,
    STATE(296), 1,
      sym_func_locals,
    STATE(678), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(53), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [6892] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_end,
    STATE(63), 1,
      aux_sym_block_block_repeat1,
    STATE(97), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(680), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(54), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [7028] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_end,
    STATE(97), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(680), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(55), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [7164] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(83), 1,
      anon_sym_RPAREN,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(212), 1,
      aux_sym_op_let_repeat2,
    STATE(296), 1,
      sym_func_locals,
    STATE(681), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(56), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [7298] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(147), 1,
      anon_sym_end,
    STATE(95), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(654), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(57), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [7434] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_end,
    STATE(57), 1,
      aux_sym_block_block_repeat1,
    STATE(92), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(804), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(58), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [7570] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_end,
    STATE(61), 1,
      aux_sym_block_block_repeat1,
    STATE(94), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(705), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(59), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [7706] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      anon_sym_end,
    STATE(94), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(705), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(60), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [7842] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_end,
    STATE(92), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(804), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(61), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [7978] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(151), 1,
      anon_sym_end,
    STATE(90), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(707), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(62), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [8114] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(153), 1,
      anon_sym_end,
    STATE(103), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(809), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(63), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [8250] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(155), 1,
      anon_sym_RPAREN,
    STATE(98), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(722), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(64), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [8386] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(155), 1,
      anon_sym_RPAREN,
    STATE(75), 1,
      aux_sym_block_block_repeat1,
    STATE(98), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(722), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(65), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [8522] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(212), 1,
      aux_sym_op_let_repeat2,
    STATE(296), 1,
      sym_func_locals,
    STATE(749), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(66), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [8656] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(65), 1,
      anon_sym_RPAREN,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(212), 1,
      aux_sym_op_let_repeat2,
    STATE(296), 1,
      sym_func_locals,
    STATE(709), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(67), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [8790] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(109), 1,
      anon_sym_RPAREN,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(212), 1,
      aux_sym_op_let_repeat2,
    STATE(296), 1,
      sym_func_locals,
    STATE(690), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(68), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [8924] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
    STATE(72), 1,
      aux_sym_block_block_repeat1,
    STATE(89), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(739), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(69), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [9060] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(81), 1,
      anon_sym_RPAREN,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(212), 1,
      aux_sym_op_let_repeat2,
    STATE(296), 1,
      sym_func_locals,
    STATE(795), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(70), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [9194] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(212), 1,
      aux_sym_op_let_repeat2,
    STATE(296), 1,
      sym_func_locals,
    STATE(729), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(71), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [9328] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(161), 1,
      anon_sym_RPAREN,
    STATE(101), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(655), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(72), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [9464] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(119), 1,
      anon_sym_RPAREN,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(212), 1,
      aux_sym_op_let_repeat2,
    STATE(296), 1,
      sym_func_locals,
    STATE(723), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(73), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [9598] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(71), 1,
      anon_sym_RPAREN,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(212), 1,
      aux_sym_op_let_repeat2,
    STATE(296), 1,
      sym_func_locals,
    STATE(725), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(74), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [9732] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_RPAREN,
    STATE(102), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(664), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(75), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [9868] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_RPAREN,
    STATE(50), 1,
      aux_sym_block_block_repeat1,
    STATE(91), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(676), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(76), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [10004] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_RPAREN,
    STATE(91), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(676), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(77), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [10140] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(135), 1,
      anon_sym_RPAREN,
    STATE(64), 1,
      aux_sym_block_block_repeat1,
    STATE(96), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(721), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(78), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [10276] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(67), 1,
      anon_sym_RPAREN,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(212), 1,
      aux_sym_op_let_repeat2,
    STATE(296), 1,
      sym_func_locals,
    STATE(743), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(79), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [10410] = 39,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(153), 1,
      anon_sym_end,
    STATE(62), 1,
      aux_sym_block_block_repeat1,
    STATE(103), 1,
      aux_sym_block_block_repeat2,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(809), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(80), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [10546] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(75), 1,
      anon_sym_RPAREN,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(212), 1,
      aux_sym_op_let_repeat2,
    STATE(296), 1,
      sym_func_locals,
    STATE(803), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(81), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [10680] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    STATE(107), 1,
      aux_sym_block_block_repeat2,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(293), 1,
      sym_instr,
    STATE(295), 1,
      sym_func_type_params_many,
    ACTIONS(165), 3,
      anon_sym_RPAREN,
      anon_sym_end,
      anon_sym_else,
    STATE(82), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [10811] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    ACTIONS(169), 1,
      anon_sym_end,
    ACTIONS(171), 1,
      anon_sym_else,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(615), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(83), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [10944] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    STATE(86), 1,
      aux_sym_block_block_repeat1,
    STATE(107), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(293), 1,
      sym_instr,
    STATE(295), 1,
      sym_func_type_params_many,
    ACTIONS(165), 3,
      anon_sym_RPAREN,
      anon_sym_end,
      anon_sym_else,
    STATE(84), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [11075] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(123), 1,
      anon_sym_end,
    ACTIONS(125), 1,
      anon_sym_else,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(616), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(85), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [11208] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    STATE(113), 1,
      aux_sym_block_block_repeat2,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(270), 1,
      sym_instr,
    STATE(295), 1,
      sym_func_type_params_many,
    ACTIONS(173), 3,
      anon_sym_RPAREN,
      anon_sym_end,
      anon_sym_else,
    STATE(86), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [11339] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(129), 1,
      anon_sym_end,
    ACTIONS(131), 1,
      anon_sym_else,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(628), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(87), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [11472] = 38,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(105), 1,
      anon_sym_end,
    ACTIONS(107), 1,
      anon_sym_else,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(618), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(88), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [11605] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(161), 1,
      anon_sym_RPAREN,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(655), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(89), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [11735] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    ACTIONS(175), 1,
      anon_sym_end,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(670), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(90), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [11865] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(739), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(91), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [11995] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(147), 1,
      anon_sym_end,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(654), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(92), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [12125] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(137), 1,
      anon_sym_end,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(680), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(93), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [12255] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(149), 1,
      anon_sym_end,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(804), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(94), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [12385] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    ACTIONS(177), 1,
      anon_sym_end,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(679), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(95), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [12515] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(155), 1,
      anon_sym_RPAREN,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(722), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(96), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [12645] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(153), 1,
      anon_sym_end,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(809), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(97), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [12775] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(163), 1,
      anon_sym_RPAREN,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(664), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(98), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [12905] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(127), 1,
      anon_sym_end,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(705), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(99), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [13035] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(135), 1,
      anon_sym_RPAREN,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(721), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(100), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [13165] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    ACTIONS(179), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(704), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(101), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [13295] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(711), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(102), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [13425] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(151), 1,
      anon_sym_end,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(707), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(103), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [13555] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(133), 1,
      anon_sym_RPAREN,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(676), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(104), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [13685] = 36,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(105), 1,
      anon_sym_end,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(185), 1,
      sym_identifier,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(692), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(105), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [13812] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    STATE(109), 1,
      aux_sym_instr_list_repeat1,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    ACTIONS(187), 3,
      anon_sym_RPAREN,
      anon_sym_end,
      anon_sym_else,
    STATE(106), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [13935] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(270), 1,
      sym_instr,
    ACTIONS(173), 3,
      anon_sym_RPAREN,
      anon_sym_end,
      anon_sym_else,
    STATE(107), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [14060] = 36,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(123), 1,
      anon_sym_end,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      sym_identifier,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(696), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(108), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [14187] = 33,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(196), 1,
      anon_sym_block,
    ACTIONS(199), 1,
      anon_sym_if,
    ACTIONS(202), 1,
      anon_sym_loop,
    ACTIONS(205), 1,
      anon_sym_call_indirect,
    ACTIONS(208), 1,
      anon_sym_br_table,
    ACTIONS(211), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(214), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(217), 1,
      sym_op_nullary,
    ACTIONS(220), 1,
      sym_op_index,
    ACTIONS(223), 1,
      sym_op_index_opt,
    ACTIONS(226), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(229), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(232), 1,
      aux_sym_op_const_token1,
    ACTIONS(235), 1,
      aux_sym_op_const_token2,
    ACTIONS(238), 1,
      anon_sym_func_DOTbind,
    ACTIONS(241), 1,
      anon_sym_let,
    ACTIONS(244), 1,
      anon_sym_select,
    ACTIONS(247), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(253), 1,
      anon_sym_i8x16,
    ACTIONS(256), 1,
      anon_sym_i16x8,
    ACTIONS(259), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(262), 1,
      anon_sym_table_DOTinit,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    ACTIONS(191), 3,
      anon_sym_RPAREN,
      anon_sym_end,
      anon_sym_else,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(250), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(109), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_instr_list_repeat1,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [14308] = 36,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(169), 1,
      anon_sym_end,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(265), 1,
      sym_identifier,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(673), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(110), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [14435] = 36,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(267), 1,
      anon_sym_end,
    ACTIONS(269), 1,
      sym_identifier,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(717), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(111), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [14562] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(87), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    STATE(123), 1,
      aux_sym_block_block_repeat1,
    STATE(134), 1,
      sym_type_use,
    STATE(139), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(271), 1,
      sym_instr,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(112), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [14691] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(272), 1,
      sym_instr,
    ACTIONS(271), 3,
      anon_sym_RPAREN,
      anon_sym_end,
      anon_sym_else,
    STATE(113), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [14816] = 36,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      anon_sym_end,
    ACTIONS(275), 1,
      sym_identifier,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(745), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(114), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [14943] = 36,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(129), 1,
      anon_sym_end,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(277), 1,
      sym_identifier,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(806), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(115), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [15070] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(293), 1,
      sym_instr,
    ACTIONS(165), 3,
      anon_sym_RPAREN,
      anon_sym_end,
      anon_sym_else,
    STATE(116), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [15195] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(736), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(117), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [15319] = 37,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(287), 1,
      anon_sym_export,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(291), 1,
      anon_sym_local,
    ACTIONS(293), 1,
      anon_sym_param,
    ACTIONS(295), 1,
      anon_sym_result,
    ACTIONS(297), 1,
      anon_sym_import,
    ACTIONS(299), 1,
      anon_sym_type,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(118), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [15447] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(301), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(790), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(119), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [15571] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(303), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(740), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(120), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [15695] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(305), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(645), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(121), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [15819] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      anon_sym_end,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(745), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(122), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [15943] = 36,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    STATE(158), 1,
      aux_sym_block_block_repeat2,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(293), 1,
      sym_instr,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(123), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [16069] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(659), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(124), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [16193] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(267), 1,
      anon_sym_end,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(717), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(125), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [16317] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(123), 1,
      anon_sym_end,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(696), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(126), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [16441] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(309), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(755), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(127), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [16565] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(311), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(708), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(128), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [16689] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(313), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(759), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(129), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [16813] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(315), 1,
      anon_sym_end,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(762), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(130), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [16937] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(317), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(768), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(131), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [17061] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(169), 1,
      anon_sym_end,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(673), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(132), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [17185] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(129), 1,
      anon_sym_end,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(806), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(133), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [17309] = 36,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    STATE(135), 1,
      aux_sym_block_block_repeat1,
    STATE(158), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(293), 1,
      sym_instr,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(134), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [17435] = 36,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    STATE(138), 1,
      aux_sym_block_block_repeat2,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(270), 1,
      sym_instr,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(135), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [17561] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(319), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(778), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(136), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [17685] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(23), 1,
      anon_sym_call_indirect,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      aux_sym_instr_list_repeat1,
    STATE(785), 1,
      sym_instr_list,
    STATE(261), 2,
      sym_instr,
      sym_instr_list_call,
    STATE(137), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [17809] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(272), 1,
      sym_instr,
    STATE(138), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [17929] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(293), 1,
      sym_instr,
    STATE(139), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [18049] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_RPAREN,
    STATE(144), 1,
      aux_sym_elem_expr_item_repeat1,
    STATE(311), 1,
      sym_instr,
    STATE(140), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [18169] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(325), 1,
      anon_sym_RPAREN,
    STATE(153), 1,
      aux_sym_elem_expr_item_repeat1,
    STATE(311), 1,
      sym_instr,
    STATE(141), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [18289] = 20,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(329), 1,
      anon_sym_LPAREN,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(182), 1,
      sym_index,
    STATE(184), 1,
      aux_sym_op_let_repeat1,
    STATE(185), 1,
      sym_nat,
    STATE(195), 1,
      aux_sym_block_block_repeat2,
    STATE(211), 1,
      aux_sym_op_let_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(142), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(338), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(327), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [18381] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(340), 1,
      anon_sym_RPAREN,
    STATE(159), 1,
      aux_sym_elem_expr_item_repeat1,
    STATE(311), 1,
      sym_instr,
    STATE(143), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [18501] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(342), 1,
      anon_sym_RPAREN,
    STATE(153), 1,
      aux_sym_elem_expr_item_repeat1,
    STATE(311), 1,
      sym_instr,
    STATE(144), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [18621] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(340), 1,
      anon_sym_RPAREN,
    STATE(153), 1,
      aux_sym_elem_expr_item_repeat1,
    STATE(311), 1,
      sym_instr,
    STATE(145), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [18741] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(342), 1,
      anon_sym_RPAREN,
    STATE(155), 1,
      aux_sym_elem_expr_item_repeat1,
    STATE(311), 1,
      sym_instr,
    STATE(146), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [18861] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_RPAREN,
    STATE(153), 1,
      aux_sym_elem_expr_item_repeat1,
    STATE(311), 1,
      sym_instr,
    STATE(147), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [18981] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(291), 1,
      anon_sym_local,
    ACTIONS(293), 1,
      anon_sym_param,
    ACTIONS(295), 1,
      anon_sym_result,
    ACTIONS(299), 1,
      anon_sym_type,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(148), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [19103] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(346), 1,
      anon_sym_RPAREN,
    STATE(153), 1,
      aux_sym_elem_expr_item_repeat1,
    STATE(311), 1,
      sym_instr,
    STATE(149), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [19223] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(348), 1,
      anon_sym_RPAREN,
    STATE(149), 1,
      aux_sym_elem_expr_item_repeat1,
    STATE(311), 1,
      sym_instr,
    STATE(150), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [19343] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(350), 1,
      anon_sym_RPAREN,
    STATE(141), 1,
      aux_sym_elem_expr_item_repeat1,
    STATE(311), 1,
      sym_instr,
    STATE(151), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [19463] = 35,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(295), 1,
      anon_sym_result,
    ACTIONS(299), 1,
      anon_sym_type,
    ACTIONS(352), 1,
      anon_sym_param,
    ACTIONS(354), 1,
      anon_sym_then,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(152), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [19585] = 33,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(356), 1,
      anon_sym_RPAREN,
    ACTIONS(358), 1,
      anon_sym_LPAREN,
    ACTIONS(361), 1,
      anon_sym_block,
    ACTIONS(364), 1,
      anon_sym_if,
    ACTIONS(367), 1,
      anon_sym_loop,
    ACTIONS(370), 1,
      anon_sym_call_indirect,
    ACTIONS(373), 1,
      anon_sym_br_table,
    ACTIONS(376), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(379), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(382), 1,
      sym_op_nullary,
    ACTIONS(385), 1,
      sym_op_index,
    ACTIONS(388), 1,
      sym_op_index_opt,
    ACTIONS(391), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(394), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(397), 1,
      aux_sym_op_const_token1,
    ACTIONS(400), 1,
      aux_sym_op_const_token2,
    ACTIONS(403), 1,
      anon_sym_func_DOTbind,
    ACTIONS(406), 1,
      anon_sym_let,
    ACTIONS(409), 1,
      anon_sym_select,
    ACTIONS(412), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(418), 1,
      anon_sym_i8x16,
    ACTIONS(421), 1,
      anon_sym_i16x8,
    ACTIONS(424), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(427), 1,
      anon_sym_table_DOTinit,
    STATE(311), 1,
      sym_instr,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(415), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(153), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_elem_expr_item_repeat1,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [19703] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      anon_sym_RPAREN,
    STATE(153), 1,
      aux_sym_elem_expr_item_repeat1,
    STATE(311), 1,
      sym_instr,
    STATE(154), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [19823] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(432), 1,
      anon_sym_RPAREN,
    STATE(153), 1,
      aux_sym_elem_expr_item_repeat1,
    STATE(311), 1,
      sym_instr,
    STATE(155), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [19943] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(434), 1,
      anon_sym_RPAREN,
    STATE(147), 1,
      aux_sym_elem_expr_item_repeat1,
    STATE(311), 1,
      sym_instr,
    STATE(156), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [20063] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(432), 1,
      anon_sym_RPAREN,
    STATE(154), 1,
      aux_sym_elem_expr_item_repeat1,
    STATE(311), 1,
      sym_instr,
    STATE(157), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [20183] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(270), 1,
      sym_instr,
    STATE(158), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [20303] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(434), 1,
      anon_sym_RPAREN,
    STATE(153), 1,
      aux_sym_elem_expr_item_repeat1,
    STATE(311), 1,
      sym_instr,
    STATE(159), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [20423] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(17), 1,
      anon_sym_block,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_loop,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(143), 1,
      anon_sym_call_indirect,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(436), 1,
      anon_sym_RPAREN,
    STATE(145), 1,
      aux_sym_elem_expr_item_repeat1,
    STATE(311), 1,
      sym_instr,
    STATE(160), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(288), 3,
      sym_block_block,
      sym_block_if,
      sym_block_loop,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(302), 4,
      sym_expr,
      sym_instr_block,
      sym_instr_call,
      sym_instr_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [20543] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(295), 1,
      anon_sym_result,
    ACTIONS(299), 1,
      anon_sym_type,
    ACTIONS(352), 1,
      anon_sym_param,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(161), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [20662] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(295), 1,
      anon_sym_result,
    ACTIONS(352), 1,
      anon_sym_param,
    ACTIONS(438), 1,
      anon_sym_then,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(162), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [20781] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(291), 1,
      anon_sym_local,
    ACTIONS(293), 1,
      anon_sym_param,
    ACTIONS(295), 1,
      anon_sym_result,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(163), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [20900] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(440), 1,
      anon_sym_table,
    ACTIONS(442), 1,
      anon_sym_offset,
    ACTIONS(444), 1,
      anon_sym_ref,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(164), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [21019] = 34,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(295), 1,
      anon_sym_result,
    ACTIONS(352), 1,
      anon_sym_param,
    ACTIONS(446), 1,
      anon_sym_then,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(165), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [21138] = 33,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(295), 1,
      anon_sym_result,
    ACTIONS(438), 1,
      anon_sym_then,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(166), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [21254] = 33,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(295), 1,
      anon_sym_result,
    ACTIONS(448), 1,
      anon_sym_then,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(167), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [21370] = 33,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(295), 1,
      anon_sym_result,
    ACTIONS(352), 1,
      anon_sym_param,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(168), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [21486] = 33,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(291), 1,
      anon_sym_local,
    ACTIONS(295), 1,
      anon_sym_result,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(169), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [21602] = 33,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(442), 1,
      anon_sym_offset,
    ACTIONS(450), 1,
      anon_sym_memory,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(170), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [21718] = 33,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(295), 1,
      anon_sym_result,
    ACTIONS(446), 1,
      anon_sym_then,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(171), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [21834] = 32,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(442), 1,
      anon_sym_offset,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(172), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [21947] = 32,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(452), 1,
      anon_sym_item,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(173), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [22060] = 32,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(446), 1,
      anon_sym_then,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(174), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [22173] = 32,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(448), 1,
      anon_sym_then,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(175), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [22286] = 32,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(438), 1,
      anon_sym_then,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(176), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [22399] = 32,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(454), 1,
      anon_sym_then,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(177), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [22512] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(178), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(458), 12,
      anon_sym_LPAREN,
      sym_dec_nat,
      anon_sym_func,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(456), 30,
      anon_sym_align,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      sym_hex_nat,
      sym_identifier,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      anon_sym_declare,
      anon_sym_offset,
      sym_ref_type_externref,
      sym_ref_type_funcref,
      sym_share,
      sym_sign,
      anon_sym_DQUOTE,
  [22573] = 32,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(295), 1,
      anon_sym_result,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(179), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [22686] = 32,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    ACTIONS(291), 1,
      anon_sym_local,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(180), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [22799] = 31,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(27), 1,
      anon_sym_br_table,
    ACTIONS(29), 1,
      anon_sym_ref_DOTextern,
    ACTIONS(31), 1,
      anon_sym_ref_DOTnull,
    ACTIONS(33), 1,
      sym_op_nullary,
    ACTIONS(35), 1,
      sym_op_index,
    ACTIONS(37), 1,
      sym_op_index_opt,
    ACTIONS(39), 1,
      sym_op_index_opt_offset_opt_align_opt,
    ACTIONS(41), 1,
      sym_op_simd_offset_opt_align_opt,
    ACTIONS(43), 1,
      aux_sym_op_const_token1,
    ACTIONS(45), 1,
      aux_sym_op_const_token2,
    ACTIONS(47), 1,
      anon_sym_func_DOTbind,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_select,
    ACTIONS(53), 1,
      anon_sym_v128_DOTconst,
    ACTIONS(57), 1,
      anon_sym_i8x16,
    ACTIONS(59), 1,
      anon_sym_i16x8,
    ACTIONS(61), 1,
      anon_sym_table_DOTcopy,
    ACTIONS(63), 1,
      anon_sym_table_DOTinit,
    ACTIONS(281), 1,
      anon_sym_block,
    ACTIONS(283), 1,
      anon_sym_if,
    ACTIONS(285), 1,
      anon_sym_loop,
    ACTIONS(289), 1,
      anon_sym_call_indirect,
    STATE(536), 1,
      sym_instr_plain,
    STATE(797), 1,
      sym_expr1,
    STATE(181), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(55), 4,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i32x4,
      anon_sym_i64x2,
    STATE(796), 5,
      sym_expr1_block,
      sym_expr1_call,
      sym_expr1_if,
      sym_expr1_loop,
      sym_expr1_plain,
    STATE(262), 8,
      sym_op_const,
      sym_op_func_bind,
      sym_op_let,
      sym_op_select,
      sym_op_simd_const,
      sym_op_simd_lane,
      sym_op_table_copy,
      sym_op_table_init,
  [22909] = 15,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(462), 1,
      anon_sym_LPAREN,
    STATE(183), 1,
      aux_sym_op_let_repeat1,
    STATE(193), 1,
      aux_sym_block_block_repeat2,
    STATE(213), 1,
      aux_sym_op_let_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(182), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(465), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(460), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [22986] = 15,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(469), 1,
      anon_sym_LPAREN,
    STATE(194), 1,
      aux_sym_block_block_repeat2,
    STATE(210), 1,
      aux_sym_op_let_repeat1,
    STATE(214), 1,
      aux_sym_op_let_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(183), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(472), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(467), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [23063] = 15,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(462), 1,
      anon_sym_LPAREN,
    STATE(193), 1,
      aux_sym_block_block_repeat2,
    STATE(210), 1,
      aux_sym_op_let_repeat1,
    STATE(213), 1,
      aux_sym_op_let_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(284), 1,
      sym_func_type_params,
    STATE(296), 1,
      sym_func_locals,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(184), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(465), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(460), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [23140] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(185), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(476), 12,
      anon_sym_LPAREN,
      sym_dec_nat,
      anon_sym_func,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(474), 28,
      anon_sym_align,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      sym_hex_nat,
      sym_identifier,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      anon_sym_declare,
      anon_sym_offset,
      sym_ref_type_externref,
      sym_ref_type_funcref,
      anon_sym_DQUOTE,
  [23199] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(480), 1,
      anon_sym_LPAREN,
    STATE(191), 1,
      sym_export,
    STATE(186), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_module_field_func_repeat1,
    ACTIONS(483), 15,
      sym_dec_nat,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
    ACTIONS(478), 21,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_call_indirect,
      sym_hex_nat,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      sym_ref_type_externref,
      sym_ref_type_funcref,
  [23261] = 15,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(485), 1,
      anon_sym_align,
    ACTIONS(491), 1,
      anon_sym_offset,
    STATE(185), 1,
      sym_nat,
    STATE(216), 1,
      sym_index,
    STATE(225), 1,
      sym_offset_value,
    STATE(301), 1,
      sym_align_value,
    STATE(187), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(489), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(487), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [23337] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(188), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(495), 16,
      anon_sym_LPAREN,
      sym_dec_nat,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
    ACTIONS(493), 21,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_call_indirect,
      sym_hex_nat,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      sym_ref_type_externref,
      sym_ref_type_funcref,
  [23393] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(189), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(499), 16,
      anon_sym_LPAREN,
      sym_dec_nat,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
    ACTIONS(497), 21,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_call_indirect,
      sym_hex_nat,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      sym_ref_type_externref,
      sym_ref_type_funcref,
  [23449] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(190), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(503), 12,
      anon_sym_LPAREN,
      sym_dec_nat,
      anon_sym_func,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(501), 25,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      sym_hex_nat,
      sym_identifier,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      sym_ref_type_externref,
      sym_ref_type_funcref,
      anon_sym_DQUOTE,
  [23505] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(191), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(507), 16,
      anon_sym_LPAREN,
      sym_dec_nat,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
    ACTIONS(505), 21,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_call_indirect,
      sym_hex_nat,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      sym_ref_type_externref,
      sym_ref_type_funcref,
  [23561] = 12,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(197), 1,
      aux_sym_elem_list_repeat1,
    STATE(217), 1,
      sym_index,
    STATE(192), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(511), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(509), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [23628] = 12,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(513), 1,
      anon_sym_LPAREN,
    STATE(214), 1,
      aux_sym_op_let_repeat2,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(296), 1,
      sym_func_locals,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(193), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(472), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(467), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [23695] = 12,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(518), 1,
      anon_sym_LPAREN,
    STATE(215), 1,
      aux_sym_op_let_repeat2,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(296), 1,
      sym_func_locals,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(194), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(521), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(516), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [23762] = 12,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(523), 1,
      anon_sym_LPAREN,
    STATE(213), 1,
      aux_sym_op_let_repeat2,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(296), 1,
      sym_func_locals,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(195), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(465), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(460), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [23829] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(530), 1,
      sym_dec_nat,
    ACTIONS(533), 1,
      sym_hex_nat,
    ACTIONS(536), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(217), 1,
      sym_index,
    STATE(196), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_elem_list_repeat1,
    ACTIONS(528), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(526), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [23894] = 12,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(196), 1,
      aux_sym_elem_list_repeat1,
    STATE(217), 1,
      sym_index,
    STATE(197), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(541), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(539), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [23961] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(198), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(545), 15,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
    ACTIONS(543), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      sym_ref_type_externref,
      sym_ref_type_funcref,
  [24015] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(199), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(549), 15,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
    ACTIONS(547), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      sym_ref_type_externref,
      sym_ref_type_funcref,
  [24069] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(268), 1,
      sym_index,
    STATE(200), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(553), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(551), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [24133] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(201), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(557), 11,
      anon_sym_LPAREN,
      sym_dec_float,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(555), 24,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_inf,
      sym_hex_float,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      sym_nan,
      sym_sign,
  [24187] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(202), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(561), 15,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
    ACTIONS(559), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      sym_ref_type_externref,
      sym_ref_type_funcref,
  [24241] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(203), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(565), 11,
      anon_sym_LPAREN,
      sym_dec_float,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(563), 24,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_inf,
      sym_hex_float,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      sym_nan,
      sym_sign,
  [24295] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(204), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(569), 15,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
    ACTIONS(567), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      sym_ref_type_externref,
      sym_ref_type_funcref,
  [24349] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(205), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(573), 15,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
    ACTIONS(571), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      sym_ref_type_externref,
      sym_ref_type_funcref,
  [24403] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(206), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(577), 15,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
    ACTIONS(575), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      sym_ref_type_externref,
      sym_ref_type_funcref,
  [24457] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(462), 1,
      sym_index,
    STATE(207), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(581), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(579), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [24521] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(301), 1,
      sym_index,
    STATE(208), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(489), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(487), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [24585] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(485), 1,
      anon_sym_align,
    ACTIONS(491), 1,
      anon_sym_offset,
    STATE(225), 1,
      sym_offset_value,
    STATE(301), 1,
      sym_align_value,
    STATE(209), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(489), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(487), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [24646] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(585), 1,
      anon_sym_LPAREN,
    STATE(284), 1,
      sym_func_type_params,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(210), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_op_let_repeat1,
    ACTIONS(588), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(583), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [24705] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(590), 1,
      anon_sym_LPAREN,
    STATE(212), 1,
      aux_sym_op_let_repeat2,
    STATE(296), 1,
      sym_func_locals,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(211), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(465), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(460), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [24766] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(595), 1,
      anon_sym_LPAREN,
    STATE(296), 1,
      sym_func_locals,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(212), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_op_let_repeat2,
    ACTIONS(598), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(593), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [24825] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(600), 1,
      anon_sym_LPAREN,
    STATE(212), 1,
      aux_sym_op_let_repeat2,
    STATE(296), 1,
      sym_func_locals,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(213), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(472), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(467), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [24886] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(603), 1,
      anon_sym_LPAREN,
    STATE(212), 1,
      aux_sym_op_let_repeat2,
    STATE(296), 1,
      sym_func_locals,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(214), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(521), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(516), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [24947] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(608), 1,
      anon_sym_LPAREN,
    STATE(212), 1,
      aux_sym_op_let_repeat2,
    STATE(296), 1,
      sym_func_locals,
    STATE(289), 2,
      sym_func_locals_many,
      sym_func_locals_one,
    STATE(215), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(611), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(606), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25008] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(485), 1,
      anon_sym_align,
    ACTIONS(491), 1,
      anon_sym_offset,
    STATE(221), 1,
      sym_offset_value,
    STATE(278), 1,
      sym_align_value,
    STATE(216), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(511), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(509), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25069] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(217), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(615), 11,
      anon_sym_LPAREN,
      sym_dec_nat,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(613), 22,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      sym_hex_nat,
      sym_identifier,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25121] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(218), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(619), 11,
      anon_sym_LPAREN,
      sym_dec_nat,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(617), 22,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      sym_hex_nat,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      sym_sign,
  [25173] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(219), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(623), 11,
      anon_sym_LPAREN,
      sym_dec_nat,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(621), 22,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      sym_hex_nat,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
      sym_sign,
  [25225] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(627), 1,
      anon_sym_LPAREN,
    STATE(224), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(220), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(630), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(625), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25282] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(485), 1,
      anon_sym_align,
    STATE(264), 1,
      sym_align_value,
    STATE(221), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(541), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(539), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25337] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(634), 1,
      anon_sym_LPAREN,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(222), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_block_block_repeat1,
    ACTIONS(637), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(632), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25392] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(254), 1,
      sym_func_type_results,
    STATE(223), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_block_block_repeat2,
    ACTIONS(644), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(639), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25447] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(648), 1,
      anon_sym_LPAREN,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(224), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(651), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(646), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25504] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(485), 1,
      anon_sym_align,
    STATE(278), 1,
      sym_align_value,
    STATE(225), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(511), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(509), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25559] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(657), 1,
      sym_identifier,
    STATE(226), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(655), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(653), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25611] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(663), 1,
      sym_identifier,
    STATE(227), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(661), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(659), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25663] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(669), 1,
      sym_identifier,
    STATE(228), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(667), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(665), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25715] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(675), 1,
      sym_identifier,
    STATE(229), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(673), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(671), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25767] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(681), 1,
      sym_identifier,
    STATE(230), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(679), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(677), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25819] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(687), 1,
      sym_identifier,
    STATE(231), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(685), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(683), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25871] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(693), 1,
      sym_identifier,
    STATE(232), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(691), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(689), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25923] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(233), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(697), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(695), 21,
      anon_sym_align,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [25973] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(703), 1,
      sym_identifier,
    STATE(234), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(701), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(699), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26025] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(709), 1,
      sym_identifier,
    STATE(235), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(707), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(705), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26077] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(715), 1,
      sym_identifier,
    STATE(236), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(713), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(711), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26129] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(721), 1,
      sym_identifier,
    STATE(237), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(719), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(717), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26181] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(727), 1,
      sym_identifier,
    STATE(238), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(725), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(723), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26233] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(733), 1,
      sym_identifier,
    STATE(239), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(731), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(729), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26285] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(739), 1,
      sym_identifier,
    STATE(240), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(737), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(735), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26337] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(745), 1,
      sym_identifier,
    STATE(241), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(743), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(741), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26389] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(751), 1,
      sym_identifier,
    STATE(242), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(749), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(747), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26441] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(757), 1,
      sym_identifier,
    STATE(243), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(755), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(753), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26493] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(763), 1,
      sym_identifier,
    STATE(244), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(761), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(759), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26545] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(769), 1,
      sym_identifier,
    STATE(245), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(767), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(765), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26597] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(775), 1,
      sym_identifier,
    STATE(246), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(773), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(771), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26649] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(781), 1,
      sym_identifier,
    STATE(247), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(779), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(777), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26701] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(248), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(667), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(665), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26750] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(249), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(785), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(783), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26799] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(250), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(789), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(787), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26848] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(251), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(737), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(735), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26897] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(252), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(793), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(791), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26946] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(253), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(779), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(777), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [26995] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(254), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(797), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(795), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27044] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(255), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(801), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(799), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27093] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(256), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(805), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(803), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27142] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(257), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(761), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(759), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27191] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(258), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(809), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(807), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27240] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(259), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(673), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(671), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27289] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(260), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(767), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(765), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27338] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(261), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(813), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(811), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27387] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(262), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(489), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(487), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27436] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(263), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(817), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(815), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27485] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(264), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(821), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(819), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27534] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(265), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(825), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(823), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27583] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(266), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(829), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(827), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27632] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(267), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(833), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(831), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27681] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(268), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(837), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(835), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27730] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(269), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(841), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(839), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27779] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(270), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(845), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(843), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27828] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(271), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(849), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(847), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27877] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(272), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(853), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(851), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27926] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(273), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(691), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(689), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [27975] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(274), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(857), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(855), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28024] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(275), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(719), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(717), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28073] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(276), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(861), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(859), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28122] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(277), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(725), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(723), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28171] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(278), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(541), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(539), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28220] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(279), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(865), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(863), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28269] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(280), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(679), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(677), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28318] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(281), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(869), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(867), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28367] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(282), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(873), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(871), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28416] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(283), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(877), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(875), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28465] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(284), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(881), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(879), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28514] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(285), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(701), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(699), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28563] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(286), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(885), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(883), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28612] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(287), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(889), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(887), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28661] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(288), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(893), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(891), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28710] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(289), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(897), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(895), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28759] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(290), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(655), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(653), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28808] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(291), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(901), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(899), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28857] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(292), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(905), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(903), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28906] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(293), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(909), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(907), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [28955] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(294), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(707), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(705), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29004] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(295), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(913), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(911), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29053] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(296), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(917), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(915), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29102] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(297), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(921), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(919), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29151] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(298), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(743), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(741), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29200] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(299), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(755), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(753), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29249] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(300), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(925), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(923), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29298] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(301), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(511), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(509), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29347] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(302), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(929), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(927), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29396] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(933), 1,
      anon_sym_LPAREN,
    STATE(303), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(935), 9,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(931), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29447] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(304), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(731), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(729), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29496] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(305), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(773), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(771), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29545] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(306), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(685), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(683), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29594] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(307), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(939), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(937), 20,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_end,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29643] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(308), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(943), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(941), 18,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29690] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(309), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(947), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(945), 18,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29737] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(310), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(951), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(949), 18,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29784] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    STATE(311), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(955), 10,
      anon_sym_LPAREN,
      sym_op_nullary,
      sym_op_index,
      sym_op_index_opt,
      anon_sym_f32x4,
      anon_sym_f64x2,
      anon_sym_i8x16,
      anon_sym_i16x8,
      anon_sym_i32x4,
      anon_sym_i64x2,
    ACTIONS(953), 18,
      anon_sym_RPAREN,
      anon_sym_block,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_call_indirect,
      anon_sym_br_table,
      anon_sym_ref_DOTextern,
      anon_sym_ref_DOTnull,
      sym_op_index_opt_offset_opt_align_opt,
      sym_op_simd_offset_opt_align_opt,
      aux_sym_op_const_token1,
      aux_sym_op_const_token2,
      anon_sym_func_DOTbind,
      anon_sym_let,
      anon_sym_select,
      anon_sym_v128_DOTconst,
      anon_sym_table_DOTcopy,
      anon_sym_table_DOTinit,
  [29831] = 17,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(957), 1,
      anon_sym_LPAREN,
    ACTIONS(959), 1,
      sym_identifier,
    STATE(160), 1,
      sym_global_type,
    STATE(191), 1,
      sym_export,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(308), 1,
      sym_value_type,
    STATE(314), 1,
      aux_sym_module_field_func_repeat1,
    STATE(318), 1,
      sym_import,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(309), 2,
      sym_global_type_imm,
      sym_global_type_mut,
    STATE(312), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [29892] = 21,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(965), 1,
      anon_sym_LPAREN,
    ACTIONS(967), 1,
      anon_sym_func,
    ACTIONS(969), 1,
      anon_sym_declare,
    STATE(185), 1,
      sym_nat,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(332), 1,
      sym_offset,
    STATE(344), 1,
      sym_index,
    STATE(368), 1,
      sym_expr,
    STATE(392), 1,
      sym_ref_type,
    STATE(401), 1,
      sym_elem_kind,
    STATE(487), 1,
      sym_table_use,
    STATE(791), 1,
      sym_elem_list,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(367), 2,
      sym_offset_const_expr,
      sym_offset_expr,
    STATE(313), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [29960] = 16,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(957), 1,
      anon_sym_LPAREN,
    STATE(143), 1,
      sym_global_type,
    STATE(186), 1,
      aux_sym_module_field_func_repeat1,
    STATE(191), 1,
      sym_export,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(308), 1,
      sym_value_type,
    STATE(324), 1,
      sym_import,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(309), 2,
      sym_global_type_imm,
      sym_global_type_mut,
    STATE(314), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [30018] = 16,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(957), 1,
      anon_sym_LPAREN,
    STATE(140), 1,
      sym_global_type,
    STATE(191), 1,
      sym_export,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(308), 1,
      sym_value_type,
    STATE(316), 1,
      aux_sym_module_field_func_repeat1,
    STATE(325), 1,
      sym_import,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(309), 2,
      sym_global_type_imm,
      sym_global_type_mut,
    STATE(315), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [30076] = 16,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(957), 1,
      anon_sym_LPAREN,
    STATE(146), 1,
      sym_global_type,
    STATE(186), 1,
      aux_sym_module_field_func_repeat1,
    STATE(191), 1,
      sym_export,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(308), 1,
      sym_value_type,
    STATE(320), 1,
      sym_import,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(309), 2,
      sym_global_type_imm,
      sym_global_type_mut,
    STATE(316), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [30134] = 14,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(971), 1,
      anon_sym_LPAREN,
    ACTIONS(973), 1,
      sym_identifier,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(308), 1,
      sym_value_type,
    STATE(647), 1,
      sym_global_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(309), 2,
      sym_global_type_imm,
      sym_global_type_mut,
    STATE(317), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [30186] = 13,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(971), 1,
      anon_sym_LPAREN,
    STATE(143), 1,
      sym_global_type,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(308), 1,
      sym_value_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(309), 2,
      sym_global_type_imm,
      sym_global_type_mut,
    STATE(318), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [30235] = 13,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(971), 1,
      anon_sym_LPAREN,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(308), 1,
      sym_value_type,
    STATE(698), 1,
      sym_global_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(309), 2,
      sym_global_type_imm,
      sym_global_type_mut,
    STATE(319), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [30284] = 13,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(971), 1,
      anon_sym_LPAREN,
    STATE(157), 1,
      sym_global_type,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(308), 1,
      sym_value_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(309), 2,
      sym_global_type_imm,
      sym_global_type_mut,
    STATE(320), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [30333] = 14,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(975), 1,
      anon_sym_RPAREN,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
    ACTIONS(979), 1,
      sym_identifier,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(337), 1,
      aux_sym_func_locals_many_repeat1,
    STATE(369), 1,
      sym_value_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(321), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [30384] = 14,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
    ACTIONS(981), 1,
      anon_sym_RPAREN,
    ACTIONS(983), 1,
      sym_identifier,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(334), 1,
      aux_sym_func_locals_many_repeat1,
    STATE(369), 1,
      sym_value_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(322), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [30435] = 18,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(985), 1,
      anon_sym_LPAREN,
    ACTIONS(987), 1,
      sym_identifier,
    STATE(191), 1,
      sym_export,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(330), 1,
      aux_sym_module_field_func_repeat1,
    STATE(384), 1,
      sym_nat,
    STATE(439), 1,
      sym_import,
    STATE(440), 1,
      sym_limits,
    STATE(667), 1,
      sym_ref_type,
    STATE(724), 1,
      sym_table_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(787), 2,
      sym_table_fields_elem,
      sym_table_fields_type,
    STATE(323), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [30494] = 13,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(971), 1,
      anon_sym_LPAREN,
    STATE(156), 1,
      sym_global_type,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(308), 1,
      sym_value_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(309), 2,
      sym_global_type_imm,
      sym_global_type_mut,
    STATE(324), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [30543] = 13,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(971), 1,
      anon_sym_LPAREN,
    STATE(146), 1,
      sym_global_type,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(308), 1,
      sym_value_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(309), 2,
      sym_global_type_imm,
      sym_global_type_mut,
    STATE(325), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [30592] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(989), 1,
      anon_sym_RPAREN,
    ACTIONS(991), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym_identifier,
    STATE(346), 1,
      aux_sym_ROOT_repeat1,
    STATE(538), 1,
      sym_module_field,
    STATE(326), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(577), 10,
      sym_module_field_data,
      sym_module_field_elem,
      sym_module_field_export,
      sym_module_field_func,
      sym_module_field_global,
      sym_module_field_import,
      sym_module_field_memory,
      sym_module_field_start,
      sym_module_field_table,
      sym_module_field_type,
  [30634] = 18,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(995), 1,
      anon_sym_RPAREN,
    ACTIONS(997), 1,
      anon_sym_LPAREN,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    STATE(185), 1,
      sym_nat,
    STATE(361), 1,
      sym_index,
    STATE(368), 1,
      sym_expr,
    STATE(478), 1,
      sym_memory_use,
    STATE(533), 1,
      aux_sym_memory_fields_data_repeat1,
    STATE(535), 1,
      sym_offset,
    STATE(637), 1,
      sym_string,
    STATE(367), 2,
      sym_offset_const_expr,
      sym_offset_expr,
    STATE(327), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [30692] = 12,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1001), 1,
      anon_sym_RPAREN,
    ACTIONS(1003), 1,
      anon_sym_LPAREN,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(369), 1,
      sym_value_type,
    ACTIONS(1009), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(328), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_func_locals_many_repeat1,
    ACTIONS(1006), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [30738] = 17,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(985), 1,
      anon_sym_LPAREN,
    STATE(186), 1,
      aux_sym_module_field_func_repeat1,
    STATE(191), 1,
      sym_export,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(384), 1,
      sym_nat,
    STATE(439), 1,
      sym_import,
    STATE(440), 1,
      sym_limits,
    STATE(667), 1,
      sym_ref_type,
    STATE(724), 1,
      sym_table_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(764), 2,
      sym_table_fields_elem,
      sym_table_fields_type,
    STATE(329), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [30794] = 17,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(985), 1,
      anon_sym_LPAREN,
    STATE(186), 1,
      aux_sym_module_field_func_repeat1,
    STATE(191), 1,
      sym_export,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(384), 1,
      sym_nat,
    STATE(439), 1,
      sym_import,
    STATE(440), 1,
      sym_limits,
    STATE(667), 1,
      sym_ref_type,
    STATE(724), 1,
      sym_table_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(716), 2,
      sym_table_fields_elem,
      sym_table_fields_type,
    STATE(330), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [30850] = 18,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(967), 1,
      anon_sym_func,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
    ACTIONS(1012), 1,
      anon_sym_RPAREN,
    STATE(185), 1,
      sym_nat,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(217), 1,
      sym_index,
    STATE(392), 1,
      sym_ref_type,
    STATE(394), 1,
      aux_sym_elem_list_repeat1,
    STATE(401), 1,
      sym_elem_kind,
    STATE(688), 1,
      sym_elem_list,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(331), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [30908] = 18,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(967), 1,
      anon_sym_func,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
    ACTIONS(1014), 1,
      anon_sym_RPAREN,
    STATE(185), 1,
      sym_nat,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(217), 1,
      sym_index,
    STATE(388), 1,
      aux_sym_elem_list_repeat1,
    STATE(392), 1,
      sym_ref_type,
    STATE(401), 1,
      sym_elem_kind,
    STATE(656), 1,
      sym_elem_list,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(332), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [30966] = 13,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(975), 1,
      anon_sym_RPAREN,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(337), 1,
      aux_sym_func_locals_many_repeat1,
    STATE(369), 1,
      sym_value_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(333), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [31014] = 13,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
    ACTIONS(1016), 1,
      anon_sym_RPAREN,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(328), 1,
      aux_sym_func_locals_many_repeat1,
    STATE(369), 1,
      sym_value_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(334), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [31062] = 18,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(967), 1,
      anon_sym_func,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
    ACTIONS(1018), 1,
      anon_sym_RPAREN,
    STATE(185), 1,
      sym_nat,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(217), 1,
      sym_index,
    STATE(392), 1,
      sym_ref_type,
    STATE(393), 1,
      aux_sym_elem_list_repeat1,
    STATE(401), 1,
      sym_elem_kind,
    STATE(747), 1,
      sym_elem_list,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(335), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [31120] = 17,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(985), 1,
      anon_sym_LPAREN,
    STATE(191), 1,
      sym_export,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(329), 1,
      aux_sym_module_field_func_repeat1,
    STATE(384), 1,
      sym_nat,
    STATE(439), 1,
      sym_import,
    STATE(440), 1,
      sym_limits,
    STATE(667), 1,
      sym_ref_type,
    STATE(724), 1,
      sym_table_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(686), 2,
      sym_table_fields_elem,
      sym_table_fields_type,
    STATE(336), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [31176] = 13,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
    ACTIONS(1020), 1,
      anon_sym_RPAREN,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(328), 1,
      aux_sym_func_locals_many_repeat1,
    STATE(369), 1,
      sym_value_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(337), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [31224] = 13,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
    ACTIONS(1022), 1,
      anon_sym_RPAREN,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(339), 1,
      aux_sym_func_locals_many_repeat1,
    STATE(369), 1,
      sym_value_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(338), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [31272] = 13,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
    ACTIONS(1024), 1,
      anon_sym_RPAREN,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(328), 1,
      aux_sym_func_locals_many_repeat1,
    STATE(369), 1,
      sym_value_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(339), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [31320] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1028), 1,
      anon_sym_LPAREN,
    STATE(538), 1,
      sym_module_field,
    ACTIONS(1026), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(340), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_ROOT_repeat1,
    STATE(577), 10,
      sym_module_field_data,
      sym_module_field_elem,
      sym_module_field_export,
      sym_module_field_func,
      sym_module_field_global,
      sym_module_field_import,
      sym_module_field_memory,
      sym_module_field_start,
      sym_module_field_table,
      sym_module_field_type,
  [31358] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(991), 1,
      anon_sym_LPAREN,
    ACTIONS(1031), 1,
      anon_sym_RPAREN,
    STATE(340), 1,
      aux_sym_ROOT_repeat1,
    STATE(538), 1,
      sym_module_field,
    STATE(341), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(577), 10,
      sym_module_field_data,
      sym_module_field_elem,
      sym_module_field_export,
      sym_module_field_func,
      sym_module_field_global,
      sym_module_field_import,
      sym_module_field_memory,
      sym_module_field_start,
      sym_module_field_table,
      sym_module_field_type,
  [31397] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(991), 1,
      anon_sym_LPAREN,
    ACTIONS(1033), 1,
      ts_builtin_sym_end,
    STATE(340), 1,
      aux_sym_ROOT_repeat1,
    STATE(538), 1,
      sym_module_field,
    STATE(342), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(577), 10,
      sym_module_field_data,
      sym_module_field_elem,
      sym_module_field_export,
      sym_module_field_func,
      sym_module_field_global,
      sym_module_field_import,
      sym_module_field_memory,
      sym_module_field_start,
      sym_module_field_table,
      sym_module_field_type,
  [31436] = 18,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(87), 1,
      anon_sym_LPAREN,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(1035), 1,
      anon_sym_RPAREN,
    STATE(185), 1,
      sym_nat,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(366), 1,
      sym_index,
    STATE(374), 1,
      aux_sym_block_block_repeat1,
    STATE(379), 1,
      sym_type_use,
    STATE(426), 1,
      aux_sym_block_block_repeat2,
    STATE(516), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(343), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [31493] = 16,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(965), 1,
      anon_sym_LPAREN,
    ACTIONS(967), 1,
      anon_sym_func,
    ACTIONS(1037), 1,
      anon_sym_declare,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(331), 1,
      sym_offset,
    STATE(368), 1,
      sym_expr,
    STATE(392), 1,
      sym_ref_type,
    STATE(401), 1,
      sym_elem_kind,
    STATE(446), 1,
      sym_table_use,
    STATE(656), 1,
      sym_elem_list,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(367), 2,
      sym_offset_const_expr,
      sym_offset_expr,
    STATE(344), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [31546] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(991), 1,
      anon_sym_LPAREN,
    ACTIONS(1039), 1,
      anon_sym_RPAREN,
    STATE(341), 1,
      aux_sym_ROOT_repeat1,
    STATE(538), 1,
      sym_module_field,
    STATE(345), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(577), 10,
      sym_module_field_data,
      sym_module_field_elem,
      sym_module_field_export,
      sym_module_field_func,
      sym_module_field_global,
      sym_module_field_import,
      sym_module_field_memory,
      sym_module_field_start,
      sym_module_field_table,
      sym_module_field_type,
  [31585] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(991), 1,
      anon_sym_LPAREN,
    ACTIONS(1041), 1,
      anon_sym_RPAREN,
    STATE(340), 1,
      aux_sym_ROOT_repeat1,
    STATE(538), 1,
      sym_module_field,
    STATE(346), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(577), 10,
      sym_module_field_data,
      sym_module_field_elem,
      sym_module_field_export,
      sym_module_field_func,
      sym_module_field_global,
      sym_module_field_import,
      sym_module_field_memory,
      sym_module_field_start,
      sym_module_field_table,
      sym_module_field_type,
  [31624] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(800), 1,
      sym_value_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(347), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [31666] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(779), 1,
      sym_value_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(348), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [31708] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(202), 1,
      sym_ref_type,
    STATE(741), 1,
      sym_value_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(199), 2,
      sym_value_type_num_type,
      sym_value_type_ref_type,
    STATE(349), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(961), 5,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
  [31750] = 15,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1043), 1,
      anon_sym_LPAREN,
    ACTIONS(1045), 1,
      sym_identifier,
    STATE(191), 1,
      sym_export,
    STATE(358), 1,
      aux_sym_module_field_func_repeat1,
    STATE(384), 1,
      sym_nat,
    STATE(463), 1,
      sym_import,
    STATE(682), 1,
      sym_memory_type,
    STATE(691), 1,
      sym_limits,
    STATE(689), 2,
      sym_memory_fields_data,
      sym_memory_fields_type,
    STATE(350), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [31799] = 15,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(1047), 1,
      anon_sym_RPAREN,
    ACTIONS(1049), 1,
      anon_sym_LPAREN,
    STATE(185), 1,
      sym_nat,
    STATE(217), 1,
      sym_index,
    STATE(395), 1,
      sym_elem_expr,
    STATE(396), 1,
      aux_sym_elem_list_repeat1,
    STATE(640), 1,
      sym_expr,
    STATE(613), 2,
      sym_elem_expr_expr,
      sym_elem_expr_item,
    STATE(351), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [31848] = 15,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1051), 1,
      anon_sym_func,
    ACTIONS(1053), 1,
      anon_sym_export,
    ACTIONS(1055), 1,
      anon_sym_global,
    ACTIONS(1057), 1,
      anon_sym_memory,
    ACTIONS(1059), 1,
      anon_sym_table,
    ACTIONS(1061), 1,
      anon_sym_import,
    ACTIONS(1063), 1,
      anon_sym_type,
    ACTIONS(1065), 1,
      anon_sym_data,
    ACTIONS(1067), 1,
      anon_sym_module,
    ACTIONS(1069), 1,
      anon_sym_elem,
    ACTIONS(1071), 1,
      anon_sym_start,
    STATE(352), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [31896] = 12,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1073), 1,
      anon_sym_RPAREN,
    ACTIONS(1075), 1,
      anon_sym_LPAREN,
    ACTIONS(1077), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1079), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1081), 1,
      sym_identifier,
    ACTIONS(1083), 1,
      sym_reserved,
    ACTIONS(1085), 1,
      anon_sym_DQUOTE,
    STATE(357), 1,
      aux_sym_annotation_repeat1,
    STATE(469), 1,
      sym_annotation_part,
    STATE(353), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(436), 4,
      sym_annotation_parens,
      sym_comment_block_annot,
      sym_comment_line_annot,
      sym_string,
  [31938] = 14,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1043), 1,
      anon_sym_LPAREN,
    STATE(186), 1,
      aux_sym_module_field_func_repeat1,
    STATE(191), 1,
      sym_export,
    STATE(384), 1,
      sym_nat,
    STATE(463), 1,
      sym_import,
    STATE(682), 1,
      sym_memory_type,
    STATE(691), 1,
      sym_limits,
    STATE(758), 2,
      sym_memory_fields_data,
      sym_memory_fields_type,
    STATE(354), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [31984] = 14,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1043), 1,
      anon_sym_LPAREN,
    STATE(191), 1,
      sym_export,
    STATE(354), 1,
      aux_sym_module_field_func_repeat1,
    STATE(384), 1,
      sym_nat,
    STATE(463), 1,
      sym_import,
    STATE(682), 1,
      sym_memory_type,
    STATE(691), 1,
      sym_limits,
    STATE(713), 2,
      sym_memory_fields_data,
      sym_memory_fields_type,
    STATE(355), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [32030] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1087), 1,
      anon_sym_RPAREN,
    ACTIONS(1089), 1,
      anon_sym_LPAREN,
    ACTIONS(1092), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1095), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1098), 1,
      sym_identifier,
    ACTIONS(1101), 1,
      sym_reserved,
    ACTIONS(1104), 1,
      anon_sym_DQUOTE,
    STATE(469), 1,
      sym_annotation_part,
    STATE(356), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_annotation_repeat1,
    STATE(436), 4,
      sym_annotation_parens,
      sym_comment_block_annot,
      sym_comment_line_annot,
      sym_string,
  [32070] = 12,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1075), 1,
      anon_sym_LPAREN,
    ACTIONS(1077), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1079), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1081), 1,
      sym_identifier,
    ACTIONS(1083), 1,
      sym_reserved,
    ACTIONS(1085), 1,
      anon_sym_DQUOTE,
    ACTIONS(1107), 1,
      anon_sym_RPAREN,
    STATE(356), 1,
      aux_sym_annotation_repeat1,
    STATE(469), 1,
      sym_annotation_part,
    STATE(357), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(436), 4,
      sym_annotation_parens,
      sym_comment_block_annot,
      sym_comment_line_annot,
      sym_string,
  [32112] = 14,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1043), 1,
      anon_sym_LPAREN,
    STATE(186), 1,
      aux_sym_module_field_func_repeat1,
    STATE(191), 1,
      sym_export,
    STATE(384), 1,
      sym_nat,
    STATE(463), 1,
      sym_import,
    STATE(682), 1,
      sym_memory_type,
    STATE(691), 1,
      sym_limits,
    STATE(687), 2,
      sym_memory_fields_data,
      sym_memory_fields_type,
    STATE(358), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [32158] = 12,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1075), 1,
      anon_sym_LPAREN,
    ACTIONS(1077), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1079), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1081), 1,
      sym_identifier,
    ACTIONS(1083), 1,
      sym_reserved,
    ACTIONS(1085), 1,
      anon_sym_DQUOTE,
    ACTIONS(1109), 1,
      anon_sym_RPAREN,
    STATE(356), 1,
      aux_sym_annotation_repeat1,
    STATE(469), 1,
      sym_annotation_part,
    STATE(359), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(436), 4,
      sym_annotation_parens,
      sym_comment_block_annot,
      sym_comment_line_annot,
      sym_string,
  [32200] = 12,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1075), 1,
      anon_sym_LPAREN,
    ACTIONS(1077), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1079), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1081), 1,
      sym_identifier,
    ACTIONS(1083), 1,
      sym_reserved,
    ACTIONS(1085), 1,
      anon_sym_DQUOTE,
    ACTIONS(1111), 1,
      anon_sym_RPAREN,
    STATE(359), 1,
      aux_sym_annotation_repeat1,
    STATE(469), 1,
      sym_annotation_part,
    STATE(360), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(436), 4,
      sym_annotation_parens,
      sym_comment_block_annot,
      sym_comment_line_annot,
      sym_string,
  [32242] = 13,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(997), 1,
      anon_sym_LPAREN,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_RPAREN,
    STATE(368), 1,
      sym_expr,
    STATE(453), 1,
      sym_memory_use,
    STATE(514), 1,
      aux_sym_memory_fields_data_repeat1,
    STATE(515), 1,
      sym_offset,
    STATE(637), 1,
      sym_string,
    STATE(367), 2,
      sym_offset_const_expr,
      sym_offset_expr,
    STATE(361), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [32285] = 12,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1115), 1,
      anon_sym_RPAREN,
    ACTIONS(1117), 1,
      anon_sym_LPAREN,
    ACTIONS(1119), 1,
      sym_identifier,
    STATE(381), 1,
      aux_sym_import_desc_func_type_repeat1,
    STATE(643), 1,
      sym_func_type,
    STATE(652), 1,
      sym_type_use,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(644), 2,
      sym_func_type_params,
      sym_func_type_results,
    STATE(362), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [32326] = 14,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1121), 1,
      anon_sym_LPAREN,
    ACTIONS(1123), 1,
      sym_identifier,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(389), 1,
      sym_type_use,
    STATE(400), 1,
      aux_sym_block_block_repeat1,
    STATE(437), 1,
      aux_sym_block_block_repeat2,
    STATE(590), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(669), 1,
      sym_if_block,
    STATE(363), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [32371] = 14,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1051), 1,
      anon_sym_func,
    ACTIONS(1053), 1,
      anon_sym_export,
    ACTIONS(1055), 1,
      anon_sym_global,
    ACTIONS(1057), 1,
      anon_sym_memory,
    ACTIONS(1059), 1,
      anon_sym_table,
    ACTIONS(1061), 1,
      anon_sym_import,
    ACTIONS(1063), 1,
      anon_sym_type,
    ACTIONS(1065), 1,
      anon_sym_data,
    ACTIONS(1069), 1,
      anon_sym_elem,
    ACTIONS(1071), 1,
      anon_sym_start,
    STATE(364), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [32416] = 13,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1121), 1,
      anon_sym_LPAREN,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(389), 1,
      sym_type_use,
    STATE(400), 1,
      aux_sym_block_block_repeat1,
    STATE(437), 1,
      aux_sym_block_block_repeat2,
    STATE(590), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(718), 1,
      sym_if_block,
    STATE(365), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [32458] = 13,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(87), 1,
      anon_sym_LPAREN,
    ACTIONS(1125), 1,
      anon_sym_RPAREN,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(375), 1,
      aux_sym_block_block_repeat1,
    STATE(380), 1,
      sym_type_use,
    STATE(417), 1,
      aux_sym_block_block_repeat2,
    STATE(511), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(366), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [32500] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1129), 3,
      anon_sym_LPAREN,
      sym_dec_nat,
      anon_sym_func,
    STATE(367), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(1127), 6,
      anon_sym_RPAREN,
      sym_hex_nat,
      sym_identifier,
      sym_ref_type_externref,
      sym_ref_type_funcref,
      anon_sym_DQUOTE,
  [32528] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1133), 3,
      anon_sym_LPAREN,
      sym_dec_nat,
      anon_sym_func,
    STATE(368), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(1131), 6,
      anon_sym_RPAREN,
      sym_hex_nat,
      sym_identifier,
      sym_ref_type_externref,
      sym_ref_type_funcref,
      anon_sym_DQUOTE,
  [32556] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1137), 1,
      anon_sym_LPAREN,
    STATE(369), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(1135), 8,
      anon_sym_RPAREN,
      sym_num_type_f32,
      sym_num_type_f64,
      sym_num_type_i32,
      sym_num_type_i64,
      sym_num_type_v128,
      sym_ref_type_externref,
      sym_ref_type_funcref,
  [32584] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1141), 3,
      anon_sym_LPAREN,
      sym_dec_nat,
      anon_sym_func,
    STATE(370), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(1139), 6,
      anon_sym_RPAREN,
      sym_hex_nat,
      sym_identifier,
      sym_ref_type_externref,
      sym_ref_type_funcref,
      anon_sym_DQUOTE,
  [32612] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1145), 3,
      anon_sym_LPAREN,
      sym_dec_nat,
      anon_sym_func,
    STATE(371), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(1143), 6,
      anon_sym_RPAREN,
      sym_hex_nat,
      sym_identifier,
      sym_ref_type_externref,
      sym_ref_type_funcref,
      anon_sym_DQUOTE,
  [32640] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1117), 1,
      anon_sym_LPAREN,
    ACTIONS(1147), 1,
      anon_sym_RPAREN,
    STATE(382), 1,
      aux_sym_import_desc_func_type_repeat1,
    STATE(643), 1,
      sym_func_type,
    STATE(695), 1,
      sym_type_use,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(644), 2,
      sym_func_type_params,
      sym_func_type_results,
    STATE(372), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [32678] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(967), 1,
      anon_sym_func,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(392), 1,
      sym_ref_type,
    STATE(401), 1,
      sym_elem_kind,
    STATE(656), 1,
      sym_elem_list,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(373), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [32715] = 12,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(1125), 1,
      anon_sym_RPAREN,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(417), 1,
      aux_sym_block_block_repeat2,
    STATE(511), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(374), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [32754] = 12,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(1149), 1,
      anon_sym_RPAREN,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(404), 1,
      aux_sym_block_block_repeat2,
    STATE(524), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(375), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [32793] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(967), 1,
      anon_sym_func,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(392), 1,
      sym_ref_type,
    STATE(401), 1,
      sym_elem_kind,
    STATE(688), 1,
      sym_elem_list,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(376), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [32830] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1151), 1,
      anon_sym_RPAREN,
    ACTIONS(1153), 1,
      anon_sym_LPAREN,
    STATE(643), 1,
      sym_func_type,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(644), 2,
      sym_func_type_params,
      sym_func_type_results,
    STATE(377), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_import_desc_func_type_repeat1,
  [32863] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1156), 1,
      anon_sym_RPAREN,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    STATE(377), 1,
      aux_sym_import_desc_func_type_repeat1,
    STATE(643), 1,
      sym_func_type,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(644), 2,
      sym_func_type_params,
      sym_func_type_results,
    STATE(378), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [32898] = 12,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(1125), 1,
      anon_sym_RPAREN,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(375), 1,
      aux_sym_block_block_repeat1,
    STATE(417), 1,
      aux_sym_block_block_repeat2,
    STATE(511), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(379), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [32937] = 12,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(1149), 1,
      anon_sym_RPAREN,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(383), 1,
      aux_sym_block_block_repeat1,
    STATE(404), 1,
      aux_sym_block_block_repeat2,
    STATE(524), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(380), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [32976] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1147), 1,
      anon_sym_RPAREN,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    STATE(377), 1,
      aux_sym_import_desc_func_type_repeat1,
    STATE(643), 1,
      sym_func_type,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(644), 2,
      sym_func_type_params,
      sym_func_type_results,
    STATE(381), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33011] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1160), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      aux_sym_import_desc_func_type_repeat1,
    STATE(643), 1,
      sym_func_type,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(644), 2,
      sym_func_type_params,
      sym_func_type_results,
    STATE(382), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33046] = 12,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(121), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      anon_sym_RPAREN,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(434), 1,
      aux_sym_block_block_repeat2,
    STATE(513), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(383), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33085] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1166), 1,
      anon_sym_LPAREN,
    ACTIONS(1168), 1,
      sym_share,
    STATE(456), 1,
      sym_nat,
    ACTIONS(1164), 3,
      anon_sym_RPAREN,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(384), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33120] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1170), 1,
      anon_sym_RPAREN,
    STATE(378), 1,
      aux_sym_import_desc_func_type_repeat1,
    STATE(643), 1,
      sym_func_type,
    STATE(252), 2,
      sym_func_type_params_many,
      sym_func_type_params_one,
    STATE(644), 2,
      sym_func_type_params,
      sym_func_type_results,
    STATE(385), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33155] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1049), 1,
      anon_sym_LPAREN,
    ACTIONS(1172), 1,
      anon_sym_RPAREN,
    STATE(397), 1,
      aux_sym_elem_list_repeat2,
    STATE(640), 1,
      sym_expr,
    STATE(642), 1,
      sym_elem_expr,
    STATE(613), 2,
      sym_elem_expr_expr,
      sym_elem_expr_item,
    STATE(386), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33189] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1174), 1,
      anon_sym_LPAREN,
    STATE(773), 1,
      sym_import_desc,
    STATE(387), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(786), 5,
      sym_import_desc_func_type,
      sym_import_desc_global_type,
      sym_import_desc_memory_type,
      sym_import_desc_table_type,
      sym_import_desc_type_use,
  [33217] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(1012), 1,
      anon_sym_RPAREN,
    STATE(185), 1,
      sym_nat,
    STATE(196), 1,
      aux_sym_elem_list_repeat1,
    STATE(217), 1,
      sym_index,
    STATE(388), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33253] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1176), 1,
      anon_sym_LPAREN,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(391), 1,
      aux_sym_block_block_repeat1,
    STATE(472), 1,
      aux_sym_block_block_repeat2,
    STATE(549), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(389), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33289] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1049), 1,
      anon_sym_LPAREN,
    ACTIONS(1178), 1,
      anon_sym_RPAREN,
    STATE(397), 1,
      aux_sym_elem_list_repeat2,
    STATE(640), 1,
      sym_expr,
    STATE(642), 1,
      sym_elem_expr,
    STATE(613), 2,
      sym_elem_expr_expr,
      sym_elem_expr_item,
    STATE(390), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33323] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1180), 1,
      anon_sym_LPAREN,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(502), 1,
      aux_sym_block_block_repeat2,
    STATE(585), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(391), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33359] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1049), 1,
      anon_sym_LPAREN,
    ACTIONS(1182), 1,
      anon_sym_RPAREN,
    STATE(390), 1,
      aux_sym_elem_list_repeat2,
    STATE(640), 1,
      sym_expr,
    STATE(642), 1,
      sym_elem_expr,
    STATE(613), 2,
      sym_elem_expr_expr,
      sym_elem_expr_item,
    STATE(392), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33393] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(1184), 1,
      anon_sym_RPAREN,
    STATE(185), 1,
      sym_nat,
    STATE(196), 1,
      aux_sym_elem_list_repeat1,
    STATE(217), 1,
      sym_index,
    STATE(393), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33429] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(1018), 1,
      anon_sym_RPAREN,
    STATE(185), 1,
      sym_nat,
    STATE(196), 1,
      aux_sym_elem_list_repeat1,
    STATE(217), 1,
      sym_index,
    STATE(394), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33465] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1049), 1,
      anon_sym_LPAREN,
    ACTIONS(1186), 1,
      anon_sym_RPAREN,
    STATE(386), 1,
      aux_sym_elem_list_repeat2,
    STATE(640), 1,
      sym_expr,
    STATE(642), 1,
      sym_elem_expr,
    STATE(613), 2,
      sym_elem_expr_expr,
      sym_elem_expr_item,
    STATE(395), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33499] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(1186), 1,
      anon_sym_RPAREN,
    STATE(185), 1,
      sym_nat,
    STATE(196), 1,
      aux_sym_elem_list_repeat1,
    STATE(217), 1,
      sym_index,
    STATE(396), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33535] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1188), 1,
      anon_sym_RPAREN,
    ACTIONS(1190), 1,
      anon_sym_LPAREN,
    STATE(640), 1,
      sym_expr,
    STATE(642), 1,
      sym_elem_expr,
    STATE(613), 2,
      sym_elem_expr_expr,
      sym_elem_expr_item,
    STATE(397), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_elem_list_repeat2,
  [33567] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(1178), 1,
      anon_sym_RPAREN,
    STATE(185), 1,
      sym_nat,
    STATE(196), 1,
      aux_sym_elem_list_repeat1,
    STATE(217), 1,
      sym_index,
    STATE(398), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33603] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(1193), 1,
      sym_ref_kind,
    ACTIONS(1195), 1,
      anon_sym_null,
    STATE(185), 1,
      sym_nat,
    STATE(744), 1,
      sym_index,
    STATE(399), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33639] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1176), 1,
      anon_sym_LPAREN,
    STATE(222), 1,
      aux_sym_block_block_repeat1,
    STATE(254), 1,
      sym_func_type_results,
    STATE(295), 1,
      sym_func_type_params_many,
    STATE(472), 1,
      aux_sym_block_block_repeat2,
    STATE(549), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(400), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33675] = 11,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(1182), 1,
      anon_sym_RPAREN,
    STATE(185), 1,
      sym_nat,
    STATE(217), 1,
      sym_index,
    STATE(398), 1,
      aux_sym_elem_list_repeat1,
    STATE(401), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33711] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(266), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(402), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33740] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1203), 1,
      anon_sym_LPAREN,
    STATE(720), 1,
      sym_export_desc,
    STATE(403), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    STATE(719), 4,
      sym_export_desc_func,
      sym_export_desc_global,
      sym_export_desc_memory,
      sym_export_desc_table,
  [33767] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      anon_sym_RPAREN,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(513), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(404), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33800] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(431), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(405), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33829] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(281), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(406), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33858] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(432), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(407), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33887] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(1205), 1,
      sym_ref_kind,
    STATE(185), 1,
      sym_nat,
    STATE(771), 1,
      sym_index,
    STATE(408), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33920] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1207), 1,
      sym_identifier,
    STATE(384), 1,
      sym_nat,
    STATE(440), 1,
      sym_limits,
    STATE(651), 1,
      sym_table_type,
    STATE(409), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33953] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(274), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(410), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [33982] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(410), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(411), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34011] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(307), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(412), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34040] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(411), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(413), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34069] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(413), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(414), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34098] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(414), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(415), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34127] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(415), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(416), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34156] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    ACTIONS(1149), 1,
      anon_sym_RPAREN,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(524), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(417), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34189] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(416), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(418), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34218] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(418), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(419), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34247] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(419), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(420), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34276] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(420), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(421), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34305] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(405), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(422), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34334] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(406), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(423), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34363] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(407), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(424), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34392] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(421), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(425), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34421] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    ACTIONS(1125), 1,
      anon_sym_RPAREN,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(511), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(426), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34454] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1209), 1,
      anon_sym_f32x4,
    ACTIONS(1211), 1,
      anon_sym_f64x2,
    ACTIONS(1213), 1,
      anon_sym_i8x16,
    ACTIONS(1215), 1,
      anon_sym_i16x8,
    ACTIONS(1217), 1,
      anon_sym_i32x4,
    ACTIONS(1219), 1,
      anon_sym_i64x2,
    STATE(427), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34487] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(425), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(428), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34516] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    ACTIONS(1221), 1,
      sym_ref_kind,
    STATE(185), 1,
      sym_nat,
    STATE(301), 1,
      sym_index,
    STATE(429), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34549] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1223), 1,
      sym_identifier,
    STATE(384), 1,
      sym_nat,
    STATE(649), 1,
      sym_memory_type,
    STATE(691), 1,
      sym_limits,
    STATE(430), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34582] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(402), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(431), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34611] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(433), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(432), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34640] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1197), 1,
      sym_dec_float,
    ACTIONS(1201), 1,
      sym_sign,
    STATE(428), 1,
      sym_float,
    ACTIONS(1199), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(433), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34669] = 10,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(167), 1,
      anon_sym_LPAREN,
    ACTIONS(1225), 1,
      anon_sym_RPAREN,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(523), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(434), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34702] = 4,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1229), 2,
      anon_sym_LPAREN,
      sym_reserved,
    STATE(435), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(1227), 5,
      anon_sym_RPAREN,
      anon_sym_LPAREN_SEMI,
      aux_sym_comment_line_token1,
      sym_identifier,
      anon_sym_DQUOTE,
  [34722] = 4,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1233), 2,
      anon_sym_LPAREN,
      sym_reserved,
    STATE(436), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(1231), 5,
      anon_sym_RPAREN,
      anon_sym_LPAREN_SEMI,
      aux_sym_comment_line_token1,
      sym_identifier,
      anon_sym_DQUOTE,
  [34742] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1235), 1,
      anon_sym_LPAREN,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(549), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(437), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34772] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(266), 1,
      sym_int,
    STATE(438), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34802] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    STATE(384), 1,
      sym_nat,
    STATE(440), 1,
      sym_limits,
    STATE(685), 1,
      sym_table_type,
    STATE(439), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34832] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
    STATE(198), 1,
      sym_ref_type_ref,
    STATE(683), 1,
      sym_ref_type,
    ACTIONS(963), 2,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(440), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34860] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(263), 1,
      sym_int,
    STATE(441), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34890] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(794), 1,
      sym_index,
    STATE(442), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [34920] = 4,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1241), 2,
      anon_sym_LPAREN,
      sym_reserved,
    STATE(443), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(1239), 5,
      anon_sym_RPAREN,
      anon_sym_LPAREN_SEMI,
      aux_sym_comment_line_token1,
      sym_identifier,
      anon_sym_DQUOTE,
  [34940] = 4,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1245), 2,
      anon_sym_LPAREN,
      sym_reserved,
    STATE(444), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(1243), 5,
      anon_sym_RPAREN,
      anon_sym_LPAREN_SEMI,
      aux_sym_comment_line_token1,
      sym_identifier,
      anon_sym_DQUOTE,
  [34960] = 4,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1249), 2,
      anon_sym_LPAREN,
      sym_reserved,
    STATE(445), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(1247), 5,
      anon_sym_RPAREN,
      anon_sym_LPAREN_SEMI,
      aux_sym_comment_line_token1,
      sym_identifier,
      anon_sym_DQUOTE,
  [34980] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1251), 1,
      anon_sym_LPAREN,
    STATE(335), 1,
      sym_offset,
    STATE(368), 1,
      sym_expr,
    STATE(367), 2,
      sym_offset_const_expr,
      sym_offset_expr,
    STATE(446), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35008] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    STATE(384), 1,
      sym_nat,
    STATE(691), 1,
      sym_limits,
    STATE(700), 1,
      sym_memory_type,
    STATE(447), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35038] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(438), 1,
      sym_int,
    STATE(448), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35068] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(468), 1,
      sym_int,
    STATE(449), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35098] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    STATE(384), 1,
      sym_nat,
    STATE(440), 1,
      sym_limits,
    STATE(702), 1,
      sym_table_type,
    STATE(450), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35128] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(459), 1,
      sym_int,
    STATE(451), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35158] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(737), 1,
      sym_index,
    STATE(452), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35188] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1251), 1,
      anon_sym_LPAREN,
    STATE(368), 1,
      sym_expr,
    STATE(530), 1,
      sym_offset,
    STATE(367), 2,
      sym_offset_const_expr,
      sym_offset_expr,
    STATE(453), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35216] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(458), 1,
      sym_int,
    STATE(454), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35246] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(460), 1,
      sym_int,
    STATE(455), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35276] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1255), 1,
      anon_sym_LPAREN,
    ACTIONS(1257), 1,
      sym_share,
    ACTIONS(1253), 3,
      anon_sym_RPAREN,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(456), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35302] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(802), 1,
      sym_index,
    STATE(457), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35332] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(470), 1,
      sym_int,
    STATE(458), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35362] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(454), 1,
      sym_int,
    STATE(459), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35392] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(471), 1,
      sym_int,
    STATE(460), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35422] = 4,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1261), 2,
      anon_sym_LPAREN,
      sym_reserved,
    STATE(461), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(1259), 5,
      anon_sym_RPAREN,
      anon_sym_LPAREN_SEMI,
      aux_sym_comment_line_token1,
      sym_identifier,
      anon_sym_DQUOTE,
  [35442] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(269), 1,
      sym_index,
    STATE(462), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35472] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    STATE(384), 1,
      sym_nat,
    STATE(691), 1,
      sym_limits,
    STATE(710), 1,
      sym_memory_type,
    STATE(463), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35502] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(492), 1,
      sym_int,
    STATE(464), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35532] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(495), 1,
      sym_int,
    STATE(465), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35562] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(498), 1,
      sym_int,
    STATE(466), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35592] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(499), 1,
      sym_int,
    STATE(467), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35622] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(455), 1,
      sym_int,
    STATE(468), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35652] = 4,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1265), 2,
      anon_sym_LPAREN,
      sym_reserved,
    STATE(469), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(1263), 5,
      anon_sym_RPAREN,
      anon_sym_LPAREN_SEMI,
      aux_sym_comment_line_token1,
      sym_identifier,
      anon_sym_DQUOTE,
  [35672] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(474), 1,
      sym_int,
    STATE(470), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35702] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(475), 1,
      sym_int,
    STATE(471), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35732] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1267), 1,
      anon_sym_LPAREN,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(585), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(472), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35762] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(799), 1,
      sym_index,
    STATE(473), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35792] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(479), 1,
      sym_int,
    STATE(474), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35822] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(286), 1,
      sym_int,
    STATE(475), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35852] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(249), 1,
      sym_int,
    STATE(476), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35882] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(301), 1,
      sym_index,
    STATE(477), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35912] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1251), 1,
      anon_sym_LPAREN,
    STATE(368), 1,
      sym_expr,
    STATE(515), 1,
      sym_offset,
    STATE(367), 2,
      sym_offset_const_expr,
      sym_offset_expr,
    STATE(478), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35940] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(482), 1,
      sym_int,
    STATE(479), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [35970] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(200), 1,
      sym_index,
    STATE(480), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36000] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(774), 1,
      sym_index,
    STATE(481), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36030] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(485), 1,
      sym_int,
    STATE(482), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36060] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(775), 1,
      sym_index,
    STATE(483), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36090] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(776), 1,
      sym_index,
    STATE(484), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36120] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(488), 1,
      sym_int,
    STATE(485), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36150] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(783), 1,
      sym_index,
    STATE(486), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36180] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1251), 1,
      anon_sym_LPAREN,
    STATE(331), 1,
      sym_offset,
    STATE(368), 1,
      sym_expr,
    STATE(367), 2,
      sym_offset_const_expr,
      sym_offset_expr,
    STATE(487), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36208] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(491), 1,
      sym_int,
    STATE(488), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36238] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(307), 1,
      sym_int,
    STATE(489), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36268] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(192), 1,
      sym_index,
    STATE(490), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36298] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(493), 1,
      sym_int,
    STATE(491), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36328] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(281), 1,
      sym_int,
    STATE(492), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36358] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(496), 1,
      sym_int,
    STATE(493), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36388] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(336), 1,
      sym_identifier,
    STATE(185), 1,
      sym_nat,
    STATE(674), 1,
      sym_index,
    STATE(494), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36418] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(448), 1,
      sym_int,
    STATE(495), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36448] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(500), 1,
      sym_int,
    STATE(496), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36478] = 4,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1271), 2,
      anon_sym_LPAREN,
      sym_reserved,
    STATE(497), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(1269), 5,
      anon_sym_RPAREN,
      anon_sym_LPAREN_SEMI,
      aux_sym_comment_line_token1,
      sym_identifier,
      anon_sym_DQUOTE,
  [36498] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(449), 1,
      sym_int,
    STATE(498), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36528] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(451), 1,
      sym_int,
    STATE(499), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36558] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    ACTIONS(1237), 1,
      sym_sign,
    STATE(218), 1,
      sym_nat,
    STATE(250), 1,
      sym_int,
    STATE(500), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36588] = 4,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1275), 2,
      anon_sym_LPAREN,
      sym_reserved,
    STATE(501), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
    ACTIONS(1273), 5,
      anon_sym_RPAREN,
      anon_sym_LPAREN_SEMI,
      aux_sym_comment_line_token1,
      sym_identifier,
      anon_sym_DQUOTE,
  [36608] = 9,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1277), 1,
      anon_sym_LPAREN,
    STATE(223), 1,
      aux_sym_block_block_repeat2,
    STATE(254), 1,
      sym_func_type_results,
    STATE(571), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(502), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36638] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1279), 1,
      anon_sym_RPAREN,
    ACTIONS(1281), 1,
      anon_sym_LPAREN,
    STATE(626), 1,
      sym_expr,
    STATE(503), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_expr1_call_repeat1,
  [36663] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    ACTIONS(1284), 1,
      anon_sym_RPAREN,
    STATE(512), 1,
      aux_sym_memory_fields_data_repeat1,
    STATE(637), 1,
      sym_string,
    STATE(504), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36690] = 7,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1288), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1291), 1,
      anon_sym_SEMI_RPAREN,
    ACTIONS(1293), 1,
      sym_comment_block_inner,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    STATE(629), 1,
      sym_comment_block_annot,
    STATE(505), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_comment_block_annot_repeat1,
  [36715] = 8,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1298), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1300), 1,
      sym_escape_sequence,
    ACTIONS(1302), 1,
      anon_sym_DQUOTE,
    ACTIONS(1304), 1,
      aux_sym_string_token1,
    STATE(509), 1,
      aux_sym_string_repeat1,
    STATE(506), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36742] = 8,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1306), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1308), 1,
      anon_sym_SEMI_RPAREN,
    ACTIONS(1310), 1,
      sym_comment_block_inner,
    STATE(505), 1,
      aux_sym_comment_block_annot_repeat1,
    STATE(629), 1,
      sym_comment_block_annot,
    STATE(507), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36769] = 8,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1298), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1300), 1,
      sym_escape_sequence,
    ACTIONS(1304), 1,
      aux_sym_string_token1,
    ACTIONS(1312), 1,
      anon_sym_DQUOTE,
    STATE(506), 1,
      aux_sym_string_repeat1,
    STATE(508), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36796] = 7,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1298), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1314), 1,
      sym_escape_sequence,
    ACTIONS(1317), 1,
      anon_sym_DQUOTE,
    ACTIONS(1319), 1,
      aux_sym_string_token1,
    STATE(509), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_string_repeat1,
  [36821] = 8,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1306), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1310), 1,
      sym_comment_block_inner,
    ACTIONS(1322), 1,
      anon_sym_SEMI_RPAREN,
    STATE(507), 1,
      aux_sym_comment_block_annot_repeat1,
    STATE(629), 1,
      sym_comment_block_annot,
    STATE(510), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36848] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(1149), 1,
      anon_sym_RPAREN,
    STATE(503), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(511), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36875] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1324), 1,
      anon_sym_RPAREN,
    ACTIONS(1326), 1,
      anon_sym_DQUOTE,
    STATE(637), 1,
      sym_string,
    STATE(512), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_memory_fields_data_repeat1,
  [36900] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(1225), 1,
      anon_sym_RPAREN,
    STATE(503), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(513), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36927] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    ACTIONS(1329), 1,
      anon_sym_RPAREN,
    STATE(512), 1,
      aux_sym_memory_fields_data_repeat1,
    STATE(637), 1,
      sym_string,
    STATE(514), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36954] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    ACTIONS(1329), 1,
      anon_sym_RPAREN,
    STATE(528), 1,
      aux_sym_memory_fields_data_repeat1,
    STATE(637), 1,
      sym_string,
    STATE(515), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [36981] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(1125), 1,
      anon_sym_RPAREN,
    STATE(503), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(516), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37008] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(1331), 1,
      anon_sym_RPAREN,
    STATE(503), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(517), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37035] = 8,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1306), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1310), 1,
      sym_comment_block_inner,
    ACTIONS(1333), 1,
      anon_sym_SEMI_RPAREN,
    STATE(522), 1,
      aux_sym_comment_block_annot_repeat1,
    STATE(629), 1,
      sym_comment_block_annot,
    STATE(518), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37062] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1255), 1,
      anon_sym_LPAREN,
    ACTIONS(1253), 3,
      anon_sym_RPAREN,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(519), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37085] = 8,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1298), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1300), 1,
      sym_escape_sequence,
    ACTIONS(1304), 1,
      aux_sym_string_token1,
    ACTIONS(1335), 1,
      anon_sym_DQUOTE,
    STATE(526), 1,
      aux_sym_string_repeat1,
    STATE(520), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37112] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(287), 1,
      anon_sym_export,
    ACTIONS(297), 1,
      anon_sym_import,
    ACTIONS(1337), 1,
      anon_sym_mut,
    ACTIONS(1339), 1,
      anon_sym_ref,
    STATE(521), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37139] = 8,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1306), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1310), 1,
      sym_comment_block_inner,
    ACTIONS(1341), 1,
      anon_sym_SEMI_RPAREN,
    STATE(505), 1,
      aux_sym_comment_block_annot_repeat1,
    STATE(629), 1,
      sym_comment_block_annot,
    STATE(522), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37166] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(1343), 1,
      anon_sym_RPAREN,
    STATE(503), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(523), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37193] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(1162), 1,
      anon_sym_RPAREN,
    STATE(503), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(524), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37220] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    ACTIONS(1345), 1,
      anon_sym_RPAREN,
    STATE(504), 1,
      aux_sym_memory_fields_data_repeat1,
    STATE(637), 1,
      sym_string,
    STATE(525), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37247] = 8,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1298), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1300), 1,
      sym_escape_sequence,
    ACTIONS(1304), 1,
      aux_sym_string_token1,
    ACTIONS(1347), 1,
      anon_sym_DQUOTE,
    STATE(509), 1,
      aux_sym_string_repeat1,
    STATE(526), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37274] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1349), 1,
      anon_sym_func,
    ACTIONS(1351), 1,
      anon_sym_global,
    ACTIONS(1353), 1,
      anon_sym_memory,
    ACTIONS(1355), 1,
      anon_sym_table,
    STATE(527), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37301] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    ACTIONS(1357), 1,
      anon_sym_RPAREN,
    STATE(512), 1,
      aux_sym_memory_fields_data_repeat1,
    STATE(637), 1,
      sym_string,
    STATE(528), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37328] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1359), 1,
      anon_sym_func,
    ACTIONS(1361), 1,
      anon_sym_global,
    ACTIONS(1363), 1,
      anon_sym_memory,
    ACTIONS(1365), 1,
      anon_sym_table,
    STATE(529), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37355] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    ACTIONS(1357), 1,
      anon_sym_RPAREN,
    STATE(532), 1,
      aux_sym_memory_fields_data_repeat1,
    STATE(637), 1,
      sym_string,
    STATE(530), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37382] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1369), 1,
      sym_dec_nat,
    ACTIONS(1367), 3,
      anon_sym_RPAREN,
      sym_hex_nat,
      sym_identifier,
    STATE(531), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37405] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    ACTIONS(1371), 1,
      anon_sym_RPAREN,
    STATE(512), 1,
      aux_sym_memory_fields_data_repeat1,
    STATE(637), 1,
      sym_string,
    STATE(532), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37432] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_RPAREN,
    STATE(512), 1,
      aux_sym_memory_fields_data_repeat1,
    STATE(637), 1,
      sym_string,
    STATE(533), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37459] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1375), 1,
      anon_sym_LPAREN,
    ACTIONS(1373), 3,
      anon_sym_RPAREN,
      sym_ref_type_externref,
      sym_ref_type_funcref,
    STATE(534), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37482] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      aux_sym_memory_fields_data_repeat1,
    STATE(637), 1,
      sym_string,
    STATE(535), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37509] = 8,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(183), 1,
      anon_sym_LPAREN,
    ACTIONS(1377), 1,
      anon_sym_RPAREN,
    STATE(517), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(536), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37536] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1379), 1,
      sym_dec_float,
    ACTIONS(1381), 3,
      anon_sym_inf,
      sym_hex_float,
      sym_nan,
    STATE(537), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37559] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1385), 1,
      anon_sym_LPAREN,
    ACTIONS(1383), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(538), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37581] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1389), 1,
      anon_sym_LPAREN,
    ACTIONS(1387), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(539), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37603] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    STATE(596), 1,
      sym_string,
    STATE(604), 1,
      sym_name,
    STATE(540), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37627] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1393), 1,
      anon_sym_LPAREN,
    ACTIONS(1391), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(541), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37649] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1397), 1,
      anon_sym_LPAREN,
    ACTIONS(1395), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(542), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37671] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1401), 1,
      anon_sym_LPAREN,
    ACTIONS(1399), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(543), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37693] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1405), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(544), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37715] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1409), 1,
      anon_sym_LPAREN,
    ACTIONS(1407), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(545), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37737] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(293), 1,
      anon_sym_param,
    ACTIONS(295), 1,
      anon_sym_result,
    ACTIONS(299), 1,
      anon_sym_type,
    STATE(546), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37761] = 7,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1411), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1413), 1,
      anon_sym_SEMI_RPAREN,
    ACTIONS(1415), 1,
      sym_comment_block_inner,
    STATE(599), 1,
      aux_sym_comment_block_repeat1,
    STATE(547), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37785] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    STATE(301), 1,
      sym_nat,
    STATE(548), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37809] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1417), 1,
      anon_sym_LPAREN,
    STATE(503), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(549), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37833] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1421), 1,
      anon_sym_LPAREN,
    ACTIONS(1419), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(550), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37855] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1425), 1,
      anon_sym_LPAREN,
    ACTIONS(1423), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(551), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37877] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1429), 1,
      anon_sym_LPAREN,
    ACTIONS(1427), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(552), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37899] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1433), 1,
      anon_sym_LPAREN,
    ACTIONS(1431), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(553), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37921] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1437), 1,
      anon_sym_LPAREN,
    ACTIONS(1435), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(554), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37943] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1441), 1,
      anon_sym_LPAREN,
    ACTIONS(1439), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(555), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37965] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1445), 1,
      anon_sym_LPAREN,
    ACTIONS(1443), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(556), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [37987] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(332), 1,
      sym_dec_nat,
    ACTIONS(334), 1,
      sym_hex_nat,
    STATE(219), 1,
      sym_nat,
    STATE(557), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38011] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1449), 1,
      anon_sym_LPAREN,
    ACTIONS(1447), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(558), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38033] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1453), 1,
      anon_sym_LPAREN,
    ACTIONS(1451), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(559), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38055] = 7,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1411), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1415), 1,
      sym_comment_block_inner,
    ACTIONS(1455), 1,
      anon_sym_SEMI_RPAREN,
    STATE(582), 1,
      aux_sym_comment_block_repeat1,
    STATE(560), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38079] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1459), 1,
      anon_sym_LPAREN,
    ACTIONS(1457), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(561), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38101] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1463), 1,
      anon_sym_LPAREN,
    ACTIONS(1461), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(562), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38123] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1467), 1,
      anon_sym_LPAREN,
    ACTIONS(1465), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(563), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38145] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(293), 1,
      anon_sym_param,
    ACTIONS(295), 1,
      anon_sym_result,
    ACTIONS(1469), 1,
      anon_sym_local,
    STATE(564), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38169] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1473), 1,
      anon_sym_LPAREN,
    ACTIONS(1471), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(565), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38191] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1477), 1,
      anon_sym_LPAREN,
    ACTIONS(1475), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(566), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38213] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1481), 1,
      anon_sym_LPAREN,
    ACTIONS(1479), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(567), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38235] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1485), 1,
      anon_sym_LPAREN,
    ACTIONS(1483), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(568), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38257] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1489), 1,
      anon_sym_LPAREN,
    ACTIONS(1487), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(569), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38279] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1493), 1,
      anon_sym_LPAREN,
    ACTIONS(1491), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(570), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38301] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1495), 1,
      anon_sym_LPAREN,
    STATE(503), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(571), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38325] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1499), 1,
      anon_sym_LPAREN,
    ACTIONS(1497), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(572), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38347] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1503), 1,
      anon_sym_LPAREN,
    ACTIONS(1501), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(573), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38369] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1507), 1,
      anon_sym_LPAREN,
    ACTIONS(1505), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(574), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38391] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1509), 1,
      anon_sym_LPAREN,
    ACTIONS(1511), 1,
      sym_identifier,
    STATE(742), 1,
      sym_type_field,
    STATE(575), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38415] = 7,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1411), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1415), 1,
      sym_comment_block_inner,
    ACTIONS(1513), 1,
      anon_sym_SEMI_RPAREN,
    STATE(560), 1,
      aux_sym_comment_block_repeat1,
    STATE(576), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38439] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1517), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(577), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38461] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1521), 1,
      anon_sym_LPAREN,
    ACTIONS(1519), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(578), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38483] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1525), 1,
      anon_sym_LPAREN,
    ACTIONS(1523), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(579), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38505] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1241), 1,
      anon_sym_LPAREN,
    ACTIONS(1239), 2,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
    STATE(580), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38527] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1529), 1,
      anon_sym_LPAREN,
    ACTIONS(1527), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(581), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38549] = 6,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1531), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1534), 1,
      anon_sym_SEMI_RPAREN,
    ACTIONS(1536), 1,
      sym_comment_block_inner,
    STATE(582), 4,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
      aux_sym_comment_block_repeat1,
  [38571] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1541), 1,
      anon_sym_LPAREN,
    ACTIONS(1539), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(583), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38593] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    STATE(387), 1,
      sym_name,
    STATE(596), 1,
      sym_string,
    STATE(584), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38617] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1543), 1,
      anon_sym_LPAREN,
    STATE(503), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(585), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38641] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1547), 1,
      anon_sym_LPAREN,
    ACTIONS(1545), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(586), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38663] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1551), 1,
      anon_sym_LPAREN,
    ACTIONS(1549), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(587), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38685] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1555), 1,
      anon_sym_LPAREN,
    ACTIONS(1553), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(588), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38707] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1559), 1,
      anon_sym_LPAREN,
    ACTIONS(1557), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(589), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38729] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1561), 1,
      anon_sym_LPAREN,
    STATE(503), 1,
      aux_sym_expr1_call_repeat1,
    STATE(626), 1,
      sym_expr,
    STATE(590), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38753] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    STATE(596), 1,
      sym_string,
    STATE(672), 1,
      sym_name,
    STATE(591), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38777] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1275), 1,
      anon_sym_LPAREN,
    ACTIONS(1273), 2,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
    STATE(592), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38799] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1565), 1,
      anon_sym_LPAREN,
    ACTIONS(1563), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(593), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38821] = 6,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1298), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1569), 1,
      aux_sym_string_token1,
    ACTIONS(1567), 2,
      sym_escape_sequence,
      anon_sym_DQUOTE,
    STATE(594), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38843] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(287), 1,
      anon_sym_export,
    ACTIONS(297), 1,
      anon_sym_import,
    ACTIONS(1339), 1,
      anon_sym_ref,
    STATE(595), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38867] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1573), 1,
      anon_sym_LPAREN,
    ACTIONS(1571), 2,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
    STATE(596), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38889] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1577), 1,
      anon_sym_LPAREN,
    ACTIONS(1575), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(597), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38911] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1581), 1,
      anon_sym_LPAREN,
    ACTIONS(1579), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(598), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38933] = 7,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1411), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(1415), 1,
      sym_comment_block_inner,
    ACTIONS(1583), 1,
      anon_sym_SEMI_RPAREN,
    STATE(582), 1,
      aux_sym_comment_block_repeat1,
    STATE(599), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38957] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1587), 1,
      anon_sym_LPAREN,
    ACTIONS(1585), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(600), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [38979] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1591), 1,
      anon_sym_LPAREN,
    ACTIONS(1589), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(601), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39001] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(287), 1,
      anon_sym_export,
    ACTIONS(297), 1,
      anon_sym_import,
    ACTIONS(1593), 1,
      anon_sym_data,
    STATE(602), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39025] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1597), 1,
      anon_sym_LPAREN,
    ACTIONS(1595), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(603), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39047] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    STATE(596), 1,
      sym_string,
    STATE(810), 1,
      sym_name,
    STATE(604), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39071] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1601), 1,
      anon_sym_LPAREN,
    ACTIONS(1599), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(605), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39093] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    STATE(584), 1,
      sym_name,
    STATE(596), 1,
      sym_string,
    STATE(606), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39117] = 7,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(999), 1,
      anon_sym_DQUOTE,
    STATE(403), 1,
      sym_name,
    STATE(596), 1,
      sym_string,
    STATE(607), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39141] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1605), 1,
      anon_sym_LPAREN,
    ACTIONS(1603), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(608), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39163] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1609), 1,
      anon_sym_LPAREN,
    ACTIONS(1607), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(609), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39185] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1613), 1,
      anon_sym_LPAREN,
    ACTIONS(1611), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(610), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39207] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1617), 1,
      anon_sym_LPAREN,
    ACTIONS(1615), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(611), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39229] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1619), 1,
      anon_sym_RPAREN,
    ACTIONS(1621), 1,
      anon_sym_LPAREN,
    STATE(612), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39250] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1623), 1,
      anon_sym_RPAREN,
    ACTIONS(1625), 1,
      anon_sym_LPAREN,
    STATE(613), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39271] = 4,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1627), 3,
      anon_sym_LPAREN_SEMI,
      anon_sym_SEMI_RPAREN,
      sym_comment_block_inner,
    STATE(614), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39288] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(267), 1,
      anon_sym_end,
    ACTIONS(1629), 1,
      anon_sym_else,
    STATE(615), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39309] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(169), 1,
      anon_sym_end,
    ACTIONS(171), 1,
      anon_sym_else,
    STATE(616), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39330] = 4,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1631), 3,
      anon_sym_LPAREN_SEMI,
      anon_sym_SEMI_RPAREN,
      sym_comment_block_inner,
    STATE(617), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39347] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(129), 1,
      anon_sym_end,
    ACTIONS(131), 1,
      anon_sym_else,
    STATE(618), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39368] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1633), 1,
      anon_sym_DOTshuffle,
    ACTIONS(1635), 1,
      anon_sym_DOT,
    STATE(619), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39389] = 4,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1229), 3,
      anon_sym_LPAREN_SEMI,
      anon_sym_SEMI_RPAREN,
      sym_comment_block_inner,
    STATE(620), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39406] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1637), 1,
      anon_sym_RPAREN,
    ACTIONS(1639), 1,
      anon_sym_LPAREN,
    STATE(621), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39427] = 4,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1641), 3,
      anon_sym_LPAREN_SEMI,
      anon_sym_SEMI_RPAREN,
      sym_comment_block_inner,
    STATE(622), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39444] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(295), 1,
      anon_sym_result,
    ACTIONS(1469), 1,
      anon_sym_local,
    STATE(623), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39465] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1337), 1,
      anon_sym_mut,
    ACTIONS(1339), 1,
      anon_sym_ref,
    STATE(624), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39486] = 4,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1245), 3,
      anon_sym_LPAREN_SEMI,
      anon_sym_SEMI_RPAREN,
      sym_comment_block_inner,
    STATE(625), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39503] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1643), 1,
      anon_sym_RPAREN,
    ACTIONS(1645), 1,
      anon_sym_LPAREN,
    STATE(626), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39524] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1509), 1,
      anon_sym_LPAREN,
    STATE(675), 1,
      sym_type_field,
    STATE(627), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39545] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(123), 1,
      anon_sym_end,
    ACTIONS(125), 1,
      anon_sym_else,
    STATE(628), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39566] = 4,
    ACTIONS(1286), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(1296), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1647), 3,
      anon_sym_LPAREN_SEMI,
      anon_sym_SEMI_RPAREN,
      sym_comment_block_inner,
    STATE(629), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39583] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(105), 1,
      anon_sym_end,
    ACTIONS(107), 1,
      anon_sym_else,
    STATE(630), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39604] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1649), 1,
      anon_sym_extract_lane,
    ACTIONS(1651), 1,
      anon_sym_replace_lane,
    STATE(631), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39625] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1653), 1,
      anon_sym_RPAREN,
    ACTIONS(1655), 1,
      anon_sym_LPAREN,
    STATE(632), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39646] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1657), 1,
      anon_sym_RPAREN,
    ACTIONS(1659), 1,
      anon_sym_LPAREN,
    STATE(633), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39667] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1651), 2,
      anon_sym_extract_lane,
      anon_sym_replace_lane,
    STATE(634), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39686] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1661), 1,
      anon_sym_RPAREN,
    ACTIONS(1663), 1,
      anon_sym_LPAREN,
    STATE(635), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39707] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1665), 1,
      anon_sym_RPAREN,
    ACTIONS(1667), 1,
      anon_sym_LPAREN,
    STATE(636), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39728] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1669), 2,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
    STATE(637), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39747] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1671), 1,
      anon_sym_RPAREN,
    ACTIONS(1673), 1,
      anon_sym_LPAREN,
    STATE(638), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39768] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(293), 1,
      anon_sym_param,
    ACTIONS(295), 1,
      anon_sym_result,
    STATE(639), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39789] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1675), 1,
      anon_sym_RPAREN,
    ACTIONS(1677), 1,
      anon_sym_LPAREN,
    STATE(640), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39810] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1679), 1,
      anon_sym_RPAREN,
    ACTIONS(1681), 1,
      anon_sym_LPAREN,
    STATE(641), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39831] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1683), 1,
      anon_sym_RPAREN,
    ACTIONS(1685), 1,
      anon_sym_LPAREN,
    STATE(642), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39852] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1687), 1,
      anon_sym_RPAREN,
    ACTIONS(1689), 1,
      anon_sym_LPAREN,
    STATE(643), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39873] = 6,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1691), 1,
      anon_sym_RPAREN,
    ACTIONS(1693), 1,
      anon_sym_LPAREN,
    STATE(644), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39894] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(307), 1,
      anon_sym_RPAREN,
    STATE(645), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39912] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1695), 1,
      anon_sym_RPAREN,
    STATE(646), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39930] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1697), 1,
      anon_sym_RPAREN,
    STATE(647), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39948] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1699), 1,
      anon_sym_RPAREN,
    STATE(648), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39966] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1701), 1,
      anon_sym_RPAREN,
    STATE(649), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [39984] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1703), 1,
      anon_sym_RPAREN,
    STATE(650), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40002] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1705), 1,
      anon_sym_RPAREN,
    STATE(651), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40020] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1707), 1,
      anon_sym_RPAREN,
    STATE(652), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40038] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(67), 1,
      anon_sym_RPAREN,
    STATE(653), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40056] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(177), 1,
      anon_sym_end,
    STATE(654), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40074] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(179), 1,
      anon_sym_RPAREN,
    STATE(655), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40092] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1012), 1,
      anon_sym_RPAREN,
    STATE(656), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40110] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1709), 1,
      anon_sym_else,
    STATE(657), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40128] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1711), 1,
      anon_sym_RPAREN,
    STATE(658), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40146] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(311), 1,
      anon_sym_RPAREN,
    STATE(659), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40164] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1713), 1,
      sym_identifier_pattern,
    STATE(660), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40182] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1715), 1,
      ts_builtin_sym_end,
    STATE(661), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40200] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1717), 1,
      anon_sym_RPAREN,
    STATE(662), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40218] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1719), 1,
      ts_builtin_sym_end,
    STATE(663), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40236] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(181), 1,
      anon_sym_RPAREN,
    STATE(664), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40254] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1721), 1,
      anon_sym_RPAREN,
    STATE(665), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40272] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(133), 1,
      anon_sym_RPAREN,
    STATE(666), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40290] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1723), 1,
      anon_sym_LPAREN,
    STATE(667), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40308] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(109), 1,
      anon_sym_RPAREN,
    STATE(668), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40326] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1725), 1,
      anon_sym_RPAREN,
    STATE(669), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40344] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1727), 1,
      anon_sym_end,
    STATE(670), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40362] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(135), 1,
      anon_sym_RPAREN,
    STATE(671), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40380] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1729), 1,
      anon_sym_RPAREN,
    STATE(672), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40398] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(267), 1,
      anon_sym_end,
    STATE(673), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40416] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1731), 1,
      anon_sym_RPAREN,
    STATE(674), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40434] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1733), 1,
      anon_sym_RPAREN,
    STATE(675), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40452] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
    STATE(676), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40470] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1735), 1,
      anon_sym_elem,
    STATE(677), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40488] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(83), 1,
      anon_sym_RPAREN,
    STATE(678), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40506] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1737), 1,
      anon_sym_end,
    STATE(679), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40524] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(153), 1,
      anon_sym_end,
    STATE(680), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40542] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(119), 1,
      anon_sym_RPAREN,
    STATE(681), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40560] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1739), 1,
      anon_sym_RPAREN,
    STATE(682), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40578] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1741), 1,
      anon_sym_RPAREN,
    STATE(683), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40596] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1339), 1,
      anon_sym_ref,
    STATE(684), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40614] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1743), 1,
      anon_sym_RPAREN,
    STATE(685), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40632] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1745), 1,
      anon_sym_RPAREN,
    STATE(686), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40650] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1747), 1,
      anon_sym_RPAREN,
    STATE(687), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40668] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1018), 1,
      anon_sym_RPAREN,
    STATE(688), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40686] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1749), 1,
      anon_sym_RPAREN,
    STATE(689), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40704] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
    STATE(690), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40722] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1751), 1,
      anon_sym_RPAREN,
    STATE(691), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40740] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(129), 1,
      anon_sym_end,
    STATE(692), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40758] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1753), 1,
      anon_sym_RPAREN,
    STATE(693), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40776] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1755), 1,
      anon_sym_RPAREN,
    STATE(694), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40794] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1757), 1,
      anon_sym_RPAREN,
    STATE(695), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40812] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(169), 1,
      anon_sym_end,
    STATE(696), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40830] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1759), 1,
      anon_sym_RPAREN,
    STATE(697), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40848] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1761), 1,
      anon_sym_RPAREN,
    STATE(698), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40866] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1763), 1,
      anon_sym_RPAREN,
    STATE(699), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40884] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1765), 1,
      anon_sym_RPAREN,
    STATE(700), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40902] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1767), 1,
      anon_sym_RPAREN,
    STATE(701), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40920] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1769), 1,
      anon_sym_RPAREN,
    STATE(702), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40938] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1771), 1,
      anon_sym_RPAREN,
    STATE(703), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40956] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1773), 1,
      anon_sym_RPAREN,
    STATE(704), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40974] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(149), 1,
      anon_sym_end,
    STATE(705), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [40992] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1775), 1,
      anon_sym_else,
    STATE(706), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41010] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(175), 1,
      anon_sym_end,
    STATE(707), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41028] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(303), 1,
      anon_sym_RPAREN,
    STATE(708), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41046] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(75), 1,
      anon_sym_RPAREN,
    STATE(709), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41064] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1777), 1,
      anon_sym_RPAREN,
    STATE(710), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41082] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1779), 1,
      anon_sym_RPAREN,
    STATE(711), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41100] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1781), 1,
      sym_align_offset_value,
    STATE(712), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41118] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1783), 1,
      anon_sym_RPAREN,
    STATE(713), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41136] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1785), 1,
      sym_align_offset_value,
    STATE(714), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41154] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1469), 1,
      anon_sym_local,
    STATE(715), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41172] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1787), 1,
      anon_sym_RPAREN,
    STATE(716), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41190] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(273), 1,
      anon_sym_end,
    STATE(717), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41208] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1789), 1,
      anon_sym_RPAREN,
    STATE(718), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41226] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1791), 1,
      anon_sym_RPAREN,
    STATE(719), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41244] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1793), 1,
      anon_sym_RPAREN,
    STATE(720), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41262] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(155), 1,
      anon_sym_RPAREN,
    STATE(721), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41280] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(163), 1,
      anon_sym_RPAREN,
    STATE(722), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41298] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(157), 1,
      anon_sym_RPAREN,
    STATE(723), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41316] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1795), 1,
      anon_sym_RPAREN,
    STATE(724), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41334] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(81), 1,
      anon_sym_RPAREN,
    STATE(725), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41352] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1797), 1,
      anon_sym_func,
    STATE(726), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41370] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(293), 1,
      anon_sym_param,
    STATE(727), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41388] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(287), 1,
      anon_sym_export,
    STATE(728), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41406] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1799), 1,
      anon_sym_RPAREN,
    STATE(729), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41424] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1801), 1,
      anon_sym_RPAREN,
    STATE(730), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41442] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1803), 1,
      anon_sym_RPAREN,
    STATE(731), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41460] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1805), 1,
      anon_sym_RPAREN,
    STATE(732), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41478] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1807), 1,
      anon_sym_RPAREN,
    STATE(733), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41496] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1809), 1,
      anon_sym_RPAREN,
    STATE(734), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41514] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1679), 1,
      anon_sym_RPAREN,
    STATE(735), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41532] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(309), 1,
      anon_sym_RPAREN,
    STATE(736), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41550] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1811), 1,
      anon_sym_RPAREN,
    STATE(737), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41568] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1813), 1,
      anon_sym_else,
    STATE(738), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41586] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(161), 1,
      anon_sym_RPAREN,
    STATE(739), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41604] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(313), 1,
      anon_sym_RPAREN,
    STATE(740), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41622] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1815), 1,
      anon_sym_RPAREN,
    STATE(741), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41640] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1817), 1,
      anon_sym_RPAREN,
    STATE(742), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41658] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(71), 1,
      anon_sym_RPAREN,
    STATE(743), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41676] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1819), 1,
      anon_sym_RPAREN,
    STATE(744), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41694] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(315), 1,
      anon_sym_end,
    STATE(745), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41712] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1033), 1,
      ts_builtin_sym_end,
    STATE(746), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41730] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1184), 1,
      anon_sym_RPAREN,
    STATE(747), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41748] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1821), 1,
      anon_sym_LPAREN,
    STATE(748), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41766] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1823), 1,
      anon_sym_RPAREN,
    STATE(749), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41784] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1825), 1,
      anon_sym_LPAREN,
    STATE(750), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41802] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(295), 1,
      anon_sym_result,
    STATE(751), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41820] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1827), 1,
      anon_sym_RPAREN,
    STATE(752), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41838] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1829), 1,
      anon_sym_RPAREN,
    STATE(753), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41856] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1661), 1,
      anon_sym_RPAREN,
    STATE(754), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41874] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(317), 1,
      anon_sym_RPAREN,
    STATE(755), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41892] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1831), 1,
      ts_builtin_sym_end,
    STATE(756), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41910] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1833), 1,
      anon_sym_else,
    STATE(757), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41928] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1835), 1,
      anon_sym_RPAREN,
    STATE(758), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41946] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1837), 1,
      anon_sym_RPAREN,
    STATE(759), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41964] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1839), 1,
      anon_sym_type,
    STATE(760), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [41982] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1841), 1,
      anon_sym_RPAREN,
    STATE(761), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42000] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1843), 1,
      anon_sym_end,
    STATE(762), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42018] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1845), 1,
      anon_sym_RPAREN,
    STATE(763), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42036] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1847), 1,
      anon_sym_RPAREN,
    STATE(764), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42054] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1849), 1,
      anon_sym_EQ,
    STATE(765), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42072] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1851), 1,
      anon_sym_EQ,
    STATE(766), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42090] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1665), 1,
      anon_sym_RPAREN,
    STATE(767), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42108] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(319), 1,
      anon_sym_RPAREN,
    STATE(768), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42126] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1853), 1,
      anon_sym__,
    STATE(769), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42144] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1855), 1,
      anon_sym_else,
    STATE(770), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42162] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1857), 1,
      anon_sym_RPAREN,
    STATE(771), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42180] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(65), 1,
      anon_sym_RPAREN,
    STATE(772), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42198] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1859), 1,
      anon_sym_RPAREN,
    STATE(773), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42216] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1861), 1,
      anon_sym_RPAREN,
    STATE(774), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42234] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1863), 1,
      anon_sym_RPAREN,
    STATE(775), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42252] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1865), 1,
      anon_sym_RPAREN,
    STATE(776), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42270] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1867), 1,
      anon_sym_RPAREN,
    STATE(777), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42288] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(321), 1,
      anon_sym_RPAREN,
    STATE(778), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42306] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1869), 1,
      anon_sym_RPAREN,
    STATE(779), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42324] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1871), 1,
      anon_sym_else,
    STATE(780), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42342] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1873), 1,
      ts_builtin_sym_end,
    STATE(781), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42360] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(127), 1,
      anon_sym_end,
    STATE(782), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42378] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1875), 1,
      anon_sym_RPAREN,
    STATE(783), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42396] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1877), 1,
      anon_sym_RPAREN,
    STATE(784), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42414] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(301), 1,
      anon_sym_RPAREN,
    STATE(785), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42432] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1879), 1,
      anon_sym_RPAREN,
    STATE(786), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42450] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1881), 1,
      anon_sym_RPAREN,
    STATE(787), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42468] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1883), 1,
      anon_sym_RPAREN,
    STATE(788), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42486] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1885), 1,
      anon_sym_RPAREN,
    STATE(789), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42504] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1887), 1,
      anon_sym_RPAREN,
    STATE(790), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42522] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1014), 1,
      anon_sym_RPAREN,
    STATE(791), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42540] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(137), 1,
      anon_sym_end,
    STATE(792), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42558] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1889), 1,
      anon_sym_RPAREN,
    STATE(793), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42576] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1891), 1,
      anon_sym_RPAREN,
    STATE(794), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42594] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(85), 1,
      anon_sym_RPAREN,
    STATE(795), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42612] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1893), 1,
      anon_sym_RPAREN,
    STATE(796), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42630] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1895), 1,
      anon_sym_RPAREN,
    STATE(797), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42648] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1897), 1,
      aux_sym_op_simd_lane_token1,
    STATE(798), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42666] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1899), 1,
      anon_sym_RPAREN,
    STATE(799), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42684] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1901), 1,
      anon_sym_RPAREN,
    STATE(800), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42702] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1903), 1,
      ts_builtin_sym_end,
    STATE(801), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42720] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1905), 1,
      anon_sym_RPAREN,
    STATE(802), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42738] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(77), 1,
      anon_sym_RPAREN,
    STATE(803), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42756] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(147), 1,
      anon_sym_end,
    STATE(804), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42774] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1907), 1,
      anon_sym_DOT,
    STATE(805), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42792] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(123), 1,
      anon_sym_end,
    STATE(806), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42810] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(352), 1,
      anon_sym_param,
    STATE(807), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42828] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1909), 1,
      anon_sym_DOT,
    STATE(808), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42846] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(151), 1,
      anon_sym_end,
    STATE(809), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42864] = 5,
    ACTIONS(3), 1,
      anon_sym_LPAREN_AT,
    ACTIONS(5), 1,
      anon_sym_LPAREN_SEMI,
    ACTIONS(7), 1,
      aux_sym_comment_line_token1,
    ACTIONS(1911), 1,
      anon_sym_RPAREN,
    STATE(810), 3,
      sym_annotation,
      sym_comment_block,
      sym_comment_line,
  [42882] = 1,
    ACTIONS(1913), 1,
      ts_builtin_sym_end,
  [42886] = 1,
    ACTIONS(1915), 1,
      ts_builtin_sym_end,
  [42890] = 1,
    ACTIONS(1917), 1,
      ts_builtin_sym_end,
  [42894] = 1,
    ACTIONS(1919), 1,
      ts_builtin_sym_end,
  [42898] = 1,
    ACTIONS(1921), 1,
      ts_builtin_sym_end,
};

static uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(6)] = 0,
  [SMALL_STATE(7)] = 153,
  [SMALL_STATE(8)] = 306,
  [SMALL_STATE(9)] = 459,
  [SMALL_STATE(10)] = 612,
  [SMALL_STATE(11)] = 762,
  [SMALL_STATE(12)] = 912,
  [SMALL_STATE(13)] = 1062,
  [SMALL_STATE(14)] = 1212,
  [SMALL_STATE(15)] = 1362,
  [SMALL_STATE(16)] = 1512,
  [SMALL_STATE(17)] = 1662,
  [SMALL_STATE(18)] = 1812,
  [SMALL_STATE(19)] = 1962,
  [SMALL_STATE(20)] = 2112,
  [SMALL_STATE(21)] = 2262,
  [SMALL_STATE(22)] = 2412,
  [SMALL_STATE(23)] = 2562,
  [SMALL_STATE(24)] = 2712,
  [SMALL_STATE(25)] = 2857,
  [SMALL_STATE(26)] = 2997,
  [SMALL_STATE(27)] = 3139,
  [SMALL_STATE(28)] = 3281,
  [SMALL_STATE(29)] = 3423,
  [SMALL_STATE(30)] = 3563,
  [SMALL_STATE(31)] = 3703,
  [SMALL_STATE(32)] = 3843,
  [SMALL_STATE(33)] = 3985,
  [SMALL_STATE(34)] = 4125,
  [SMALL_STATE(35)] = 4265,
  [SMALL_STATE(36)] = 4407,
  [SMALL_STATE(37)] = 4547,
  [SMALL_STATE(38)] = 4687,
  [SMALL_STATE(39)] = 4827,
  [SMALL_STATE(40)] = 4967,
  [SMALL_STATE(41)] = 5106,
  [SMALL_STATE(42)] = 5245,
  [SMALL_STATE(43)] = 5384,
  [SMALL_STATE(44)] = 5523,
  [SMALL_STATE(45)] = 5662,
  [SMALL_STATE(46)] = 5801,
  [SMALL_STATE(47)] = 5940,
  [SMALL_STATE(48)] = 6079,
  [SMALL_STATE(49)] = 6218,
  [SMALL_STATE(50)] = 6354,
  [SMALL_STATE(51)] = 6490,
  [SMALL_STATE(52)] = 6624,
  [SMALL_STATE(53)] = 6758,
  [SMALL_STATE(54)] = 6892,
  [SMALL_STATE(55)] = 7028,
  [SMALL_STATE(56)] = 7164,
  [SMALL_STATE(57)] = 7298,
  [SMALL_STATE(58)] = 7434,
  [SMALL_STATE(59)] = 7570,
  [SMALL_STATE(60)] = 7706,
  [SMALL_STATE(61)] = 7842,
  [SMALL_STATE(62)] = 7978,
  [SMALL_STATE(63)] = 8114,
  [SMALL_STATE(64)] = 8250,
  [SMALL_STATE(65)] = 8386,
  [SMALL_STATE(66)] = 8522,
  [SMALL_STATE(67)] = 8656,
  [SMALL_STATE(68)] = 8790,
  [SMALL_STATE(69)] = 8924,
  [SMALL_STATE(70)] = 9060,
  [SMALL_STATE(71)] = 9194,
  [SMALL_STATE(72)] = 9328,
  [SMALL_STATE(73)] = 9464,
  [SMALL_STATE(74)] = 9598,
  [SMALL_STATE(75)] = 9732,
  [SMALL_STATE(76)] = 9868,
  [SMALL_STATE(77)] = 10004,
  [SMALL_STATE(78)] = 10140,
  [SMALL_STATE(79)] = 10276,
  [SMALL_STATE(80)] = 10410,
  [SMALL_STATE(81)] = 10546,
  [SMALL_STATE(82)] = 10680,
  [SMALL_STATE(83)] = 10811,
  [SMALL_STATE(84)] = 10944,
  [SMALL_STATE(85)] = 11075,
  [SMALL_STATE(86)] = 11208,
  [SMALL_STATE(87)] = 11339,
  [SMALL_STATE(88)] = 11472,
  [SMALL_STATE(89)] = 11605,
  [SMALL_STATE(90)] = 11735,
  [SMALL_STATE(91)] = 11865,
  [SMALL_STATE(92)] = 11995,
  [SMALL_STATE(93)] = 12125,
  [SMALL_STATE(94)] = 12255,
  [SMALL_STATE(95)] = 12385,
  [SMALL_STATE(96)] = 12515,
  [SMALL_STATE(97)] = 12645,
  [SMALL_STATE(98)] = 12775,
  [SMALL_STATE(99)] = 12905,
  [SMALL_STATE(100)] = 13035,
  [SMALL_STATE(101)] = 13165,
  [SMALL_STATE(102)] = 13295,
  [SMALL_STATE(103)] = 13425,
  [SMALL_STATE(104)] = 13555,
  [SMALL_STATE(105)] = 13685,
  [SMALL_STATE(106)] = 13812,
  [SMALL_STATE(107)] = 13935,
  [SMALL_STATE(108)] = 14060,
  [SMALL_STATE(109)] = 14187,
  [SMALL_STATE(110)] = 14308,
  [SMALL_STATE(111)] = 14435,
  [SMALL_STATE(112)] = 14562,
  [SMALL_STATE(113)] = 14691,
  [SMALL_STATE(114)] = 14816,
  [SMALL_STATE(115)] = 14943,
  [SMALL_STATE(116)] = 15070,
  [SMALL_STATE(117)] = 15195,
  [SMALL_STATE(118)] = 15319,
  [SMALL_STATE(119)] = 15447,
  [SMALL_STATE(120)] = 15571,
  [SMALL_STATE(121)] = 15695,
  [SMALL_STATE(122)] = 15819,
  [SMALL_STATE(123)] = 15943,
  [SMALL_STATE(124)] = 16069,
  [SMALL_STATE(125)] = 16193,
  [SMALL_STATE(126)] = 16317,
  [SMALL_STATE(127)] = 16441,
  [SMALL_STATE(128)] = 16565,
  [SMALL_STATE(129)] = 16689,
  [SMALL_STATE(130)] = 16813,
  [SMALL_STATE(131)] = 16937,
  [SMALL_STATE(132)] = 17061,
  [SMALL_STATE(133)] = 17185,
  [SMALL_STATE(134)] = 17309,
  [SMALL_STATE(135)] = 17435,
  [SMALL_STATE(136)] = 17561,
  [SMALL_STATE(137)] = 17685,
  [SMALL_STATE(138)] = 17809,
  [SMALL_STATE(139)] = 17929,
  [SMALL_STATE(140)] = 18049,
  [SMALL_STATE(141)] = 18169,
  [SMALL_STATE(142)] = 18289,
  [SMALL_STATE(143)] = 18381,
  [SMALL_STATE(144)] = 18501,
  [SMALL_STATE(145)] = 18621,
  [SMALL_STATE(146)] = 18741,
  [SMALL_STATE(147)] = 18861,
  [SMALL_STATE(148)] = 18981,
  [SMALL_STATE(149)] = 19103,
  [SMALL_STATE(150)] = 19223,
  [SMALL_STATE(151)] = 19343,
  [SMALL_STATE(152)] = 19463,
  [SMALL_STATE(153)] = 19585,
  [SMALL_STATE(154)] = 19703,
  [SMALL_STATE(155)] = 19823,
  [SMALL_STATE(156)] = 19943,
  [SMALL_STATE(157)] = 20063,
  [SMALL_STATE(158)] = 20183,
  [SMALL_STATE(159)] = 20303,
  [SMALL_STATE(160)] = 20423,
  [SMALL_STATE(161)] = 20543,
  [SMALL_STATE(162)] = 20662,
  [SMALL_STATE(163)] = 20781,
  [SMALL_STATE(164)] = 20900,
  [SMALL_STATE(165)] = 21019,
  [SMALL_STATE(166)] = 21138,
  [SMALL_STATE(167)] = 21254,
  [SMALL_STATE(168)] = 21370,
  [SMALL_STATE(169)] = 21486,
  [SMALL_STATE(170)] = 21602,
  [SMALL_STATE(171)] = 21718,
  [SMALL_STATE(172)] = 21834,
  [SMALL_STATE(173)] = 21947,
  [SMALL_STATE(174)] = 22060,
  [SMALL_STATE(175)] = 22173,
  [SMALL_STATE(176)] = 22286,
  [SMALL_STATE(177)] = 22399,
  [SMALL_STATE(178)] = 22512,
  [SMALL_STATE(179)] = 22573,
  [SMALL_STATE(180)] = 22686,
  [SMALL_STATE(181)] = 22799,
  [SMALL_STATE(182)] = 22909,
  [SMALL_STATE(183)] = 22986,
  [SMALL_STATE(184)] = 23063,
  [SMALL_STATE(185)] = 23140,
  [SMALL_STATE(186)] = 23199,
  [SMALL_STATE(187)] = 23261,
  [SMALL_STATE(188)] = 23337,
  [SMALL_STATE(189)] = 23393,
  [SMALL_STATE(190)] = 23449,
  [SMALL_STATE(191)] = 23505,
  [SMALL_STATE(192)] = 23561,
  [SMALL_STATE(193)] = 23628,
  [SMALL_STATE(194)] = 23695,
  [SMALL_STATE(195)] = 23762,
  [SMALL_STATE(196)] = 23829,
  [SMALL_STATE(197)] = 23894,
  [SMALL_STATE(198)] = 23961,
  [SMALL_STATE(199)] = 24015,
  [SMALL_STATE(200)] = 24069,
  [SMALL_STATE(201)] = 24133,
  [SMALL_STATE(202)] = 24187,
  [SMALL_STATE(203)] = 24241,
  [SMALL_STATE(204)] = 24295,
  [SMALL_STATE(205)] = 24349,
  [SMALL_STATE(206)] = 24403,
  [SMALL_STATE(207)] = 24457,
  [SMALL_STATE(208)] = 24521,
  [SMALL_STATE(209)] = 24585,
  [SMALL_STATE(210)] = 24646,
  [SMALL_STATE(211)] = 24705,
  [SMALL_STATE(212)] = 24766,
  [SMALL_STATE(213)] = 24825,
  [SMALL_STATE(214)] = 24886,
  [SMALL_STATE(215)] = 24947,
  [SMALL_STATE(216)] = 25008,
  [SMALL_STATE(217)] = 25069,
  [SMALL_STATE(218)] = 25121,
  [SMALL_STATE(219)] = 25173,
  [SMALL_STATE(220)] = 25225,
  [SMALL_STATE(221)] = 25282,
  [SMALL_STATE(222)] = 25337,
  [SMALL_STATE(223)] = 25392,
  [SMALL_STATE(224)] = 25447,
  [SMALL_STATE(225)] = 25504,
  [SMALL_STATE(226)] = 25559,
  [SMALL_STATE(227)] = 25611,
  [SMALL_STATE(228)] = 25663,
  [SMALL_STATE(229)] = 25715,
  [SMALL_STATE(230)] = 25767,
  [SMALL_STATE(231)] = 25819,
  [SMALL_STATE(232)] = 25871,
  [SMALL_STATE(233)] = 25923,
  [SMALL_STATE(234)] = 25973,
  [SMALL_STATE(235)] = 26025,
  [SMALL_STATE(236)] = 26077,
  [SMALL_STATE(237)] = 26129,
  [SMALL_STATE(238)] = 26181,
  [SMALL_STATE(239)] = 26233,
  [SMALL_STATE(240)] = 26285,
  [SMALL_STATE(241)] = 26337,
  [SMALL_STATE(242)] = 26389,
  [SMALL_STATE(243)] = 26441,
  [SMALL_STATE(244)] = 26493,
  [SMALL_STATE(245)] = 26545,
  [SMALL_STATE(246)] = 26597,
  [SMALL_STATE(247)] = 26649,
  [SMALL_STATE(248)] = 26701,
  [SMALL_STATE(249)] = 26750,
  [SMALL_STATE(250)] = 26799,
  [SMALL_STATE(251)] = 26848,
  [SMALL_STATE(252)] = 26897,
  [SMALL_STATE(253)] = 26946,
  [SMALL_STATE(254)] = 26995,
  [SMALL_STATE(255)] = 27044,
  [SMALL_STATE(256)] = 27093,
  [SMALL_STATE(257)] = 27142,
  [SMALL_STATE(258)] = 27191,
  [SMALL_STATE(259)] = 27240,
  [SMALL_STATE(260)] = 27289,
  [SMALL_STATE(261)] = 27338,
  [SMALL_STATE(262)] = 27387,
  [SMALL_STATE(263)] = 27436,
  [SMALL_STATE(264)] = 27485,
  [SMALL_STATE(265)] = 27534,
  [SMALL_STATE(266)] = 27583,
  [SMALL_STATE(267)] = 27632,
  [SMALL_STATE(268)] = 27681,
  [SMALL_STATE(269)] = 27730,
  [SMALL_STATE(270)] = 27779,
  [SMALL_STATE(271)] = 27828,
  [SMALL_STATE(272)] = 27877,
  [SMALL_STATE(273)] = 27926,
  [SMALL_STATE(274)] = 27975,
  [SMALL_STATE(275)] = 28024,
  [SMALL_STATE(276)] = 28073,
  [SMALL_STATE(277)] = 28122,
  [SMALL_STATE(278)] = 28171,
  [SMALL_STATE(279)] = 28220,
  [SMALL_STATE(280)] = 28269,
  [SMALL_STATE(281)] = 28318,
  [SMALL_STATE(282)] = 28367,
  [SMALL_STATE(283)] = 28416,
  [SMALL_STATE(284)] = 28465,
  [SMALL_STATE(285)] = 28514,
  [SMALL_STATE(286)] = 28563,
  [SMALL_STATE(287)] = 28612,
  [SMALL_STATE(288)] = 28661,
  [SMALL_STATE(289)] = 28710,
  [SMALL_STATE(290)] = 28759,
  [SMALL_STATE(291)] = 28808,
  [SMALL_STATE(292)] = 28857,
  [SMALL_STATE(293)] = 28906,
  [SMALL_STATE(294)] = 28955,
  [SMALL_STATE(295)] = 29004,
  [SMALL_STATE(296)] = 29053,
  [SMALL_STATE(297)] = 29102,
  [SMALL_STATE(298)] = 29151,
  [SMALL_STATE(299)] = 29200,
  [SMALL_STATE(300)] = 29249,
  [SMALL_STATE(301)] = 29298,
  [SMALL_STATE(302)] = 29347,
  [SMALL_STATE(303)] = 29396,
  [SMALL_STATE(304)] = 29447,
  [SMALL_STATE(305)] = 29496,
  [SMALL_STATE(306)] = 29545,
  [SMALL_STATE(307)] = 29594,
  [SMALL_STATE(308)] = 29643,
  [SMALL_STATE(309)] = 29690,
  [SMALL_STATE(310)] = 29737,
  [SMALL_STATE(311)] = 29784,
  [SMALL_STATE(312)] = 29831,
  [SMALL_STATE(313)] = 29892,
  [SMALL_STATE(314)] = 29960,
  [SMALL_STATE(315)] = 30018,
  [SMALL_STATE(316)] = 30076,
  [SMALL_STATE(317)] = 30134,
  [SMALL_STATE(318)] = 30186,
  [SMALL_STATE(319)] = 30235,
  [SMALL_STATE(320)] = 30284,
  [SMALL_STATE(321)] = 30333,
  [SMALL_STATE(322)] = 30384,
  [SMALL_STATE(323)] = 30435,
  [SMALL_STATE(324)] = 30494,
  [SMALL_STATE(325)] = 30543,
  [SMALL_STATE(326)] = 30592,
  [SMALL_STATE(327)] = 30634,
  [SMALL_STATE(328)] = 30692,
  [SMALL_STATE(329)] = 30738,
  [SMALL_STATE(330)] = 30794,
  [SMALL_STATE(331)] = 30850,
  [SMALL_STATE(332)] = 30908,
  [SMALL_STATE(333)] = 30966,
  [SMALL_STATE(334)] = 31014,
  [SMALL_STATE(335)] = 31062,
  [SMALL_STATE(336)] = 31120,
  [SMALL_STATE(337)] = 31176,
  [SMALL_STATE(338)] = 31224,
  [SMALL_STATE(339)] = 31272,
  [SMALL_STATE(340)] = 31320,
  [SMALL_STATE(341)] = 31358,
  [SMALL_STATE(342)] = 31397,
  [SMALL_STATE(343)] = 31436,
  [SMALL_STATE(344)] = 31493,
  [SMALL_STATE(345)] = 31546,
  [SMALL_STATE(346)] = 31585,
  [SMALL_STATE(347)] = 31624,
  [SMALL_STATE(348)] = 31666,
  [SMALL_STATE(349)] = 31708,
  [SMALL_STATE(350)] = 31750,
  [SMALL_STATE(351)] = 31799,
  [SMALL_STATE(352)] = 31848,
  [SMALL_STATE(353)] = 31896,
  [SMALL_STATE(354)] = 31938,
  [SMALL_STATE(355)] = 31984,
  [SMALL_STATE(356)] = 32030,
  [SMALL_STATE(357)] = 32070,
  [SMALL_STATE(358)] = 32112,
  [SMALL_STATE(359)] = 32158,
  [SMALL_STATE(360)] = 32200,
  [SMALL_STATE(361)] = 32242,
  [SMALL_STATE(362)] = 32285,
  [SMALL_STATE(363)] = 32326,
  [SMALL_STATE(364)] = 32371,
  [SMALL_STATE(365)] = 32416,
  [SMALL_STATE(366)] = 32458,
  [SMALL_STATE(367)] = 32500,
  [SMALL_STATE(368)] = 32528,
  [SMALL_STATE(369)] = 32556,
  [SMALL_STATE(370)] = 32584,
  [SMALL_STATE(371)] = 32612,
  [SMALL_STATE(372)] = 32640,
  [SMALL_STATE(373)] = 32678,
  [SMALL_STATE(374)] = 32715,
  [SMALL_STATE(375)] = 32754,
  [SMALL_STATE(376)] = 32793,
  [SMALL_STATE(377)] = 32830,
  [SMALL_STATE(378)] = 32863,
  [SMALL_STATE(379)] = 32898,
  [SMALL_STATE(380)] = 32937,
  [SMALL_STATE(381)] = 32976,
  [SMALL_STATE(382)] = 33011,
  [SMALL_STATE(383)] = 33046,
  [SMALL_STATE(384)] = 33085,
  [SMALL_STATE(385)] = 33120,
  [SMALL_STATE(386)] = 33155,
  [SMALL_STATE(387)] = 33189,
  [SMALL_STATE(388)] = 33217,
  [SMALL_STATE(389)] = 33253,
  [SMALL_STATE(390)] = 33289,
  [SMALL_STATE(391)] = 33323,
  [SMALL_STATE(392)] = 33359,
  [SMALL_STATE(393)] = 33393,
  [SMALL_STATE(394)] = 33429,
  [SMALL_STATE(395)] = 33465,
  [SMALL_STATE(396)] = 33499,
  [SMALL_STATE(397)] = 33535,
  [SMALL_STATE(398)] = 33567,
  [SMALL_STATE(399)] = 33603,
  [SMALL_STATE(400)] = 33639,
  [SMALL_STATE(401)] = 33675,
  [SMALL_STATE(402)] = 33711,
  [SMALL_STATE(403)] = 33740,
  [SMALL_STATE(404)] = 33767,
  [SMALL_STATE(405)] = 33800,
  [SMALL_STATE(406)] = 33829,
  [SMALL_STATE(407)] = 33858,
  [SMALL_STATE(408)] = 33887,
  [SMALL_STATE(409)] = 33920,
  [SMALL_STATE(410)] = 33953,
  [SMALL_STATE(411)] = 33982,
  [SMALL_STATE(412)] = 34011,
  [SMALL_STATE(413)] = 34040,
  [SMALL_STATE(414)] = 34069,
  [SMALL_STATE(415)] = 34098,
  [SMALL_STATE(416)] = 34127,
  [SMALL_STATE(417)] = 34156,
  [SMALL_STATE(418)] = 34189,
  [SMALL_STATE(419)] = 34218,
  [SMALL_STATE(420)] = 34247,
  [SMALL_STATE(421)] = 34276,
  [SMALL_STATE(422)] = 34305,
  [SMALL_STATE(423)] = 34334,
  [SMALL_STATE(424)] = 34363,
  [SMALL_STATE(425)] = 34392,
  [SMALL_STATE(426)] = 34421,
  [SMALL_STATE(427)] = 34454,
  [SMALL_STATE(428)] = 34487,
  [SMALL_STATE(429)] = 34516,
  [SMALL_STATE(430)] = 34549,
  [SMALL_STATE(431)] = 34582,
  [SMALL_STATE(432)] = 34611,
  [SMALL_STATE(433)] = 34640,
  [SMALL_STATE(434)] = 34669,
  [SMALL_STATE(435)] = 34702,
  [SMALL_STATE(436)] = 34722,
  [SMALL_STATE(437)] = 34742,
  [SMALL_STATE(438)] = 34772,
  [SMALL_STATE(439)] = 34802,
  [SMALL_STATE(440)] = 34832,
  [SMALL_STATE(441)] = 34860,
  [SMALL_STATE(442)] = 34890,
  [SMALL_STATE(443)] = 34920,
  [SMALL_STATE(444)] = 34940,
  [SMALL_STATE(445)] = 34960,
  [SMALL_STATE(446)] = 34980,
  [SMALL_STATE(447)] = 35008,
  [SMALL_STATE(448)] = 35038,
  [SMALL_STATE(449)] = 35068,
  [SMALL_STATE(450)] = 35098,
  [SMALL_STATE(451)] = 35128,
  [SMALL_STATE(452)] = 35158,
  [SMALL_STATE(453)] = 35188,
  [SMALL_STATE(454)] = 35216,
  [SMALL_STATE(455)] = 35246,
  [SMALL_STATE(456)] = 35276,
  [SMALL_STATE(457)] = 35302,
  [SMALL_STATE(458)] = 35332,
  [SMALL_STATE(459)] = 35362,
  [SMALL_STATE(460)] = 35392,
  [SMALL_STATE(461)] = 35422,
  [SMALL_STATE(462)] = 35442,
  [SMALL_STATE(463)] = 35472,
  [SMALL_STATE(464)] = 35502,
  [SMALL_STATE(465)] = 35532,
  [SMALL_STATE(466)] = 35562,
  [SMALL_STATE(467)] = 35592,
  [SMALL_STATE(468)] = 35622,
  [SMALL_STATE(469)] = 35652,
  [SMALL_STATE(470)] = 35672,
  [SMALL_STATE(471)] = 35702,
  [SMALL_STATE(472)] = 35732,
  [SMALL_STATE(473)] = 35762,
  [SMALL_STATE(474)] = 35792,
  [SMALL_STATE(475)] = 35822,
  [SMALL_STATE(476)] = 35852,
  [SMALL_STATE(477)] = 35882,
  [SMALL_STATE(478)] = 35912,
  [SMALL_STATE(479)] = 35940,
  [SMALL_STATE(480)] = 35970,
  [SMALL_STATE(481)] = 36000,
  [SMALL_STATE(482)] = 36030,
  [SMALL_STATE(483)] = 36060,
  [SMALL_STATE(484)] = 36090,
  [SMALL_STATE(485)] = 36120,
  [SMALL_STATE(486)] = 36150,
  [SMALL_STATE(487)] = 36180,
  [SMALL_STATE(488)] = 36208,
  [SMALL_STATE(489)] = 36238,
  [SMALL_STATE(490)] = 36268,
  [SMALL_STATE(491)] = 36298,
  [SMALL_STATE(492)] = 36328,
  [SMALL_STATE(493)] = 36358,
  [SMALL_STATE(494)] = 36388,
  [SMALL_STATE(495)] = 36418,
  [SMALL_STATE(496)] = 36448,
  [SMALL_STATE(497)] = 36478,
  [SMALL_STATE(498)] = 36498,
  [SMALL_STATE(499)] = 36528,
  [SMALL_STATE(500)] = 36558,
  [SMALL_STATE(501)] = 36588,
  [SMALL_STATE(502)] = 36608,
  [SMALL_STATE(503)] = 36638,
  [SMALL_STATE(504)] = 36663,
  [SMALL_STATE(505)] = 36690,
  [SMALL_STATE(506)] = 36715,
  [SMALL_STATE(507)] = 36742,
  [SMALL_STATE(508)] = 36769,
  [SMALL_STATE(509)] = 36796,
  [SMALL_STATE(510)] = 36821,
  [SMALL_STATE(511)] = 36848,
  [SMALL_STATE(512)] = 36875,
  [SMALL_STATE(513)] = 36900,
  [SMALL_STATE(514)] = 36927,
  [SMALL_STATE(515)] = 36954,
  [SMALL_STATE(516)] = 36981,
  [SMALL_STATE(517)] = 37008,
  [SMALL_STATE(518)] = 37035,
  [SMALL_STATE(519)] = 37062,
  [SMALL_STATE(520)] = 37085,
  [SMALL_STATE(521)] = 37112,
  [SMALL_STATE(522)] = 37139,
  [SMALL_STATE(523)] = 37166,
  [SMALL_STATE(524)] = 37193,
  [SMALL_STATE(525)] = 37220,
  [SMALL_STATE(526)] = 37247,
  [SMALL_STATE(527)] = 37274,
  [SMALL_STATE(528)] = 37301,
  [SMALL_STATE(529)] = 37328,
  [SMALL_STATE(530)] = 37355,
  [SMALL_STATE(531)] = 37382,
  [SMALL_STATE(532)] = 37405,
  [SMALL_STATE(533)] = 37432,
  [SMALL_STATE(534)] = 37459,
  [SMALL_STATE(535)] = 37482,
  [SMALL_STATE(536)] = 37509,
  [SMALL_STATE(537)] = 37536,
  [SMALL_STATE(538)] = 37559,
  [SMALL_STATE(539)] = 37581,
  [SMALL_STATE(540)] = 37603,
  [SMALL_STATE(541)] = 37627,
  [SMALL_STATE(542)] = 37649,
  [SMALL_STATE(543)] = 37671,
  [SMALL_STATE(544)] = 37693,
  [SMALL_STATE(545)] = 37715,
  [SMALL_STATE(546)] = 37737,
  [SMALL_STATE(547)] = 37761,
  [SMALL_STATE(548)] = 37785,
  [SMALL_STATE(549)] = 37809,
  [SMALL_STATE(550)] = 37833,
  [SMALL_STATE(551)] = 37855,
  [SMALL_STATE(552)] = 37877,
  [SMALL_STATE(553)] = 37899,
  [SMALL_STATE(554)] = 37921,
  [SMALL_STATE(555)] = 37943,
  [SMALL_STATE(556)] = 37965,
  [SMALL_STATE(557)] = 37987,
  [SMALL_STATE(558)] = 38011,
  [SMALL_STATE(559)] = 38033,
  [SMALL_STATE(560)] = 38055,
  [SMALL_STATE(561)] = 38079,
  [SMALL_STATE(562)] = 38101,
  [SMALL_STATE(563)] = 38123,
  [SMALL_STATE(564)] = 38145,
  [SMALL_STATE(565)] = 38169,
  [SMALL_STATE(566)] = 38191,
  [SMALL_STATE(567)] = 38213,
  [SMALL_STATE(568)] = 38235,
  [SMALL_STATE(569)] = 38257,
  [SMALL_STATE(570)] = 38279,
  [SMALL_STATE(571)] = 38301,
  [SMALL_STATE(572)] = 38325,
  [SMALL_STATE(573)] = 38347,
  [SMALL_STATE(574)] = 38369,
  [SMALL_STATE(575)] = 38391,
  [SMALL_STATE(576)] = 38415,
  [SMALL_STATE(577)] = 38439,
  [SMALL_STATE(578)] = 38461,
  [SMALL_STATE(579)] = 38483,
  [SMALL_STATE(580)] = 38505,
  [SMALL_STATE(581)] = 38527,
  [SMALL_STATE(582)] = 38549,
  [SMALL_STATE(583)] = 38571,
  [SMALL_STATE(584)] = 38593,
  [SMALL_STATE(585)] = 38617,
  [SMALL_STATE(586)] = 38641,
  [SMALL_STATE(587)] = 38663,
  [SMALL_STATE(588)] = 38685,
  [SMALL_STATE(589)] = 38707,
  [SMALL_STATE(590)] = 38729,
  [SMALL_STATE(591)] = 38753,
  [SMALL_STATE(592)] = 38777,
  [SMALL_STATE(593)] = 38799,
  [SMALL_STATE(594)] = 38821,
  [SMALL_STATE(595)] = 38843,
  [SMALL_STATE(596)] = 38867,
  [SMALL_STATE(597)] = 38889,
  [SMALL_STATE(598)] = 38911,
  [SMALL_STATE(599)] = 38933,
  [SMALL_STATE(600)] = 38957,
  [SMALL_STATE(601)] = 38979,
  [SMALL_STATE(602)] = 39001,
  [SMALL_STATE(603)] = 39025,
  [SMALL_STATE(604)] = 39047,
  [SMALL_STATE(605)] = 39071,
  [SMALL_STATE(606)] = 39093,
  [SMALL_STATE(607)] = 39117,
  [SMALL_STATE(608)] = 39141,
  [SMALL_STATE(609)] = 39163,
  [SMALL_STATE(610)] = 39185,
  [SMALL_STATE(611)] = 39207,
  [SMALL_STATE(612)] = 39229,
  [SMALL_STATE(613)] = 39250,
  [SMALL_STATE(614)] = 39271,
  [SMALL_STATE(615)] = 39288,
  [SMALL_STATE(616)] = 39309,
  [SMALL_STATE(617)] = 39330,
  [SMALL_STATE(618)] = 39347,
  [SMALL_STATE(619)] = 39368,
  [SMALL_STATE(620)] = 39389,
  [SMALL_STATE(621)] = 39406,
  [SMALL_STATE(622)] = 39427,
  [SMALL_STATE(623)] = 39444,
  [SMALL_STATE(624)] = 39465,
  [SMALL_STATE(625)] = 39486,
  [SMALL_STATE(626)] = 39503,
  [SMALL_STATE(627)] = 39524,
  [SMALL_STATE(628)] = 39545,
  [SMALL_STATE(629)] = 39566,
  [SMALL_STATE(630)] = 39583,
  [SMALL_STATE(631)] = 39604,
  [SMALL_STATE(632)] = 39625,
  [SMALL_STATE(633)] = 39646,
  [SMALL_STATE(634)] = 39667,
  [SMALL_STATE(635)] = 39686,
  [SMALL_STATE(636)] = 39707,
  [SMALL_STATE(637)] = 39728,
  [SMALL_STATE(638)] = 39747,
  [SMALL_STATE(639)] = 39768,
  [SMALL_STATE(640)] = 39789,
  [SMALL_STATE(641)] = 39810,
  [SMALL_STATE(642)] = 39831,
  [SMALL_STATE(643)] = 39852,
  [SMALL_STATE(644)] = 39873,
  [SMALL_STATE(645)] = 39894,
  [SMALL_STATE(646)] = 39912,
  [SMALL_STATE(647)] = 39930,
  [SMALL_STATE(648)] = 39948,
  [SMALL_STATE(649)] = 39966,
  [SMALL_STATE(650)] = 39984,
  [SMALL_STATE(651)] = 40002,
  [SMALL_STATE(652)] = 40020,
  [SMALL_STATE(653)] = 40038,
  [SMALL_STATE(654)] = 40056,
  [SMALL_STATE(655)] = 40074,
  [SMALL_STATE(656)] = 40092,
  [SMALL_STATE(657)] = 40110,
  [SMALL_STATE(658)] = 40128,
  [SMALL_STATE(659)] = 40146,
  [SMALL_STATE(660)] = 40164,
  [SMALL_STATE(661)] = 40182,
  [SMALL_STATE(662)] = 40200,
  [SMALL_STATE(663)] = 40218,
  [SMALL_STATE(664)] = 40236,
  [SMALL_STATE(665)] = 40254,
  [SMALL_STATE(666)] = 40272,
  [SMALL_STATE(667)] = 40290,
  [SMALL_STATE(668)] = 40308,
  [SMALL_STATE(669)] = 40326,
  [SMALL_STATE(670)] = 40344,
  [SMALL_STATE(671)] = 40362,
  [SMALL_STATE(672)] = 40380,
  [SMALL_STATE(673)] = 40398,
  [SMALL_STATE(674)] = 40416,
  [SMALL_STATE(675)] = 40434,
  [SMALL_STATE(676)] = 40452,
  [SMALL_STATE(677)] = 40470,
  [SMALL_STATE(678)] = 40488,
  [SMALL_STATE(679)] = 40506,
  [SMALL_STATE(680)] = 40524,
  [SMALL_STATE(681)] = 40542,
  [SMALL_STATE(682)] = 40560,
  [SMALL_STATE(683)] = 40578,
  [SMALL_STATE(684)] = 40596,
  [SMALL_STATE(685)] = 40614,
  [SMALL_STATE(686)] = 40632,
  [SMALL_STATE(687)] = 40650,
  [SMALL_STATE(688)] = 40668,
  [SMALL_STATE(689)] = 40686,
  [SMALL_STATE(690)] = 40704,
  [SMALL_STATE(691)] = 40722,
  [SMALL_STATE(692)] = 40740,
  [SMALL_STATE(693)] = 40758,
  [SMALL_STATE(694)] = 40776,
  [SMALL_STATE(695)] = 40794,
  [SMALL_STATE(696)] = 40812,
  [SMALL_STATE(697)] = 40830,
  [SMALL_STATE(698)] = 40848,
  [SMALL_STATE(699)] = 40866,
  [SMALL_STATE(700)] = 40884,
  [SMALL_STATE(701)] = 40902,
  [SMALL_STATE(702)] = 40920,
  [SMALL_STATE(703)] = 40938,
  [SMALL_STATE(704)] = 40956,
  [SMALL_STATE(705)] = 40974,
  [SMALL_STATE(706)] = 40992,
  [SMALL_STATE(707)] = 41010,
  [SMALL_STATE(708)] = 41028,
  [SMALL_STATE(709)] = 41046,
  [SMALL_STATE(710)] = 41064,
  [SMALL_STATE(711)] = 41082,
  [SMALL_STATE(712)] = 41100,
  [SMALL_STATE(713)] = 41118,
  [SMALL_STATE(714)] = 41136,
  [SMALL_STATE(715)] = 41154,
  [SMALL_STATE(716)] = 41172,
  [SMALL_STATE(717)] = 41190,
  [SMALL_STATE(718)] = 41208,
  [SMALL_STATE(719)] = 41226,
  [SMALL_STATE(720)] = 41244,
  [SMALL_STATE(721)] = 41262,
  [SMALL_STATE(722)] = 41280,
  [SMALL_STATE(723)] = 41298,
  [SMALL_STATE(724)] = 41316,
  [SMALL_STATE(725)] = 41334,
  [SMALL_STATE(726)] = 41352,
  [SMALL_STATE(727)] = 41370,
  [SMALL_STATE(728)] = 41388,
  [SMALL_STATE(729)] = 41406,
  [SMALL_STATE(730)] = 41424,
  [SMALL_STATE(731)] = 41442,
  [SMALL_STATE(732)] = 41460,
  [SMALL_STATE(733)] = 41478,
  [SMALL_STATE(734)] = 41496,
  [SMALL_STATE(735)] = 41514,
  [SMALL_STATE(736)] = 41532,
  [SMALL_STATE(737)] = 41550,
  [SMALL_STATE(738)] = 41568,
  [SMALL_STATE(739)] = 41586,
  [SMALL_STATE(740)] = 41604,
  [SMALL_STATE(741)] = 41622,
  [SMALL_STATE(742)] = 41640,
  [SMALL_STATE(743)] = 41658,
  [SMALL_STATE(744)] = 41676,
  [SMALL_STATE(745)] = 41694,
  [SMALL_STATE(746)] = 41712,
  [SMALL_STATE(747)] = 41730,
  [SMALL_STATE(748)] = 41748,
  [SMALL_STATE(749)] = 41766,
  [SMALL_STATE(750)] = 41784,
  [SMALL_STATE(751)] = 41802,
  [SMALL_STATE(752)] = 41820,
  [SMALL_STATE(753)] = 41838,
  [SMALL_STATE(754)] = 41856,
  [SMALL_STATE(755)] = 41874,
  [SMALL_STATE(756)] = 41892,
  [SMALL_STATE(757)] = 41910,
  [SMALL_STATE(758)] = 41928,
  [SMALL_STATE(759)] = 41946,
  [SMALL_STATE(760)] = 41964,
  [SMALL_STATE(761)] = 41982,
  [SMALL_STATE(762)] = 42000,
  [SMALL_STATE(763)] = 42018,
  [SMALL_STATE(764)] = 42036,
  [SMALL_STATE(765)] = 42054,
  [SMALL_STATE(766)] = 42072,
  [SMALL_STATE(767)] = 42090,
  [SMALL_STATE(768)] = 42108,
  [SMALL_STATE(769)] = 42126,
  [SMALL_STATE(770)] = 42144,
  [SMALL_STATE(771)] = 42162,
  [SMALL_STATE(772)] = 42180,
  [SMALL_STATE(773)] = 42198,
  [SMALL_STATE(774)] = 42216,
  [SMALL_STATE(775)] = 42234,
  [SMALL_STATE(776)] = 42252,
  [SMALL_STATE(777)] = 42270,
  [SMALL_STATE(778)] = 42288,
  [SMALL_STATE(779)] = 42306,
  [SMALL_STATE(780)] = 42324,
  [SMALL_STATE(781)] = 42342,
  [SMALL_STATE(782)] = 42360,
  [SMALL_STATE(783)] = 42378,
  [SMALL_STATE(784)] = 42396,
  [SMALL_STATE(785)] = 42414,
  [SMALL_STATE(786)] = 42432,
  [SMALL_STATE(787)] = 42450,
  [SMALL_STATE(788)] = 42468,
  [SMALL_STATE(789)] = 42486,
  [SMALL_STATE(790)] = 42504,
  [SMALL_STATE(791)] = 42522,
  [SMALL_STATE(792)] = 42540,
  [SMALL_STATE(793)] = 42558,
  [SMALL_STATE(794)] = 42576,
  [SMALL_STATE(795)] = 42594,
  [SMALL_STATE(796)] = 42612,
  [SMALL_STATE(797)] = 42630,
  [SMALL_STATE(798)] = 42648,
  [SMALL_STATE(799)] = 42666,
  [SMALL_STATE(800)] = 42684,
  [SMALL_STATE(801)] = 42702,
  [SMALL_STATE(802)] = 42720,
  [SMALL_STATE(803)] = 42738,
  [SMALL_STATE(804)] = 42756,
  [SMALL_STATE(805)] = 42774,
  [SMALL_STATE(806)] = 42792,
  [SMALL_STATE(807)] = 42810,
  [SMALL_STATE(808)] = 42828,
  [SMALL_STATE(809)] = 42846,
  [SMALL_STATE(810)] = 42864,
  [SMALL_STATE(811)] = 42882,
  [SMALL_STATE(812)] = 42886,
  [SMALL_STATE(813)] = 42890,
  [SMALL_STATE(814)] = 42894,
  [SMALL_STATE(815)] = 42898,
};

static TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(660),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(812),
  [9] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ROOT, 0),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(352),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(262),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(477),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(805),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(619),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(808),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(600),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(148),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(609),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(611),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(161),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [95] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [101] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr1_loop, 1),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
  [111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr1_block, 1),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [121] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [133] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr1_block, 2),
  [135] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr1_loop, 2),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [139] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr1_block, 3),
  [141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instr_list_call, 1),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [145] = {.entry = {.count = 1, .reusable = false}}, SHIFT(180),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [155] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr1_loop, 3),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr1_block, 4),
  [163] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr1_loop, 4),
  [165] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instr_list_call, 2),
  [167] = {.entry = {.count = 1, .reusable = false}}, SHIFT(179),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instr_list_call, 3),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [179] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr1_block, 5),
  [181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr1_loop, 5),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [187] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instr_list, 1),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2),
  [193] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(181),
  [196] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(26),
  [199] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(24),
  [202] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(35),
  [205] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(51),
  [208] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(490),
  [211] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(548),
  [214] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(429),
  [217] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(262),
  [220] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(477),
  [223] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(208),
  [226] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(187),
  [229] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(209),
  [232] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(412),
  [235] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(489),
  [238] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(303),
  [241] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(142),
  [244] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(220),
  [247] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(427),
  [250] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(805),
  [253] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(619),
  [256] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(808),
  [259] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(207),
  [262] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 2), SHIFT_REPEAT(480),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instr_list_call, 4),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(735),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(591),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [291] = {.entry = {.count = 1, .reusable = false}}, SHIFT(322),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(789),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(641),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(612),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(632),
  [309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(754),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(621),
  [313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(635),
  [315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(767),
  [319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(777),
  [321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(784),
  [323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(633),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_let, 1),
  [329] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_op_let, 1), SHIFT(564),
  [332] = {.entry = {.count = 1, .reusable = false}}, SHIFT(178),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [338] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_let, 1),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(553),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(638),
  [352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [356] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2),
  [358] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(181),
  [361] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(26),
  [364] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(24),
  [367] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(35),
  [370] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(112),
  [373] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(490),
  [376] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(548),
  [379] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(429),
  [382] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(262),
  [385] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(477),
  [388] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(208),
  [391] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(187),
  [394] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(209),
  [397] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(412),
  [400] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(489),
  [403] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(303),
  [406] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(142),
  [409] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(220),
  [412] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(427),
  [415] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(805),
  [418] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(619),
  [421] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(808),
  [424] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(207),
  [427] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 2), SHIFT_REPEAT(480),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(603),
  [432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(555),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [440] = {.entry = {.count = 1, .reusable = false}}, SHIFT(452),
  [442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [444] = {.entry = {.count = 1, .reusable = false}}, SHIFT(399),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [450] = {.entry = {.count = 1, .reusable = false}}, SHIFT(473),
  [452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [456] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nat, 1),
  [458] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nat, 1),
  [460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_let, 2),
  [462] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_op_let, 2), SHIFT(564),
  [465] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_let, 2),
  [467] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_let, 3),
  [469] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_op_let, 3), SHIFT(564),
  [472] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_let, 3),
  [474] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_index, 1),
  [476] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_index, 1),
  [478] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_field_func_repeat1, 2),
  [480] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_module_field_func_repeat1, 2), SHIFT_REPEAT(728),
  [483] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_module_field_func_repeat1, 2),
  [485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(766),
  [487] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instr_plain, 1),
  [489] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instr_plain, 1),
  [491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(765),
  [493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_export, 4),
  [495] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_export, 4),
  [497] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 5),
  [499] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import, 5),
  [501] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 3),
  [503] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 3),
  [505] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_field_func_repeat1, 1),
  [507] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_module_field_func_repeat1, 1),
  [509] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instr_plain, 2),
  [511] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instr_plain, 2),
  [513] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_op_let, 3), SHIFT(623),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_let, 4),
  [518] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_op_let, 4), SHIFT(623),
  [521] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_let, 4),
  [523] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_op_let, 2), SHIFT(623),
  [526] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_elem_list_repeat1, 2),
  [528] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_elem_list_repeat1, 2),
  [530] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_elem_list_repeat1, 2), SHIFT_REPEAT(178),
  [533] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_list_repeat1, 2), SHIFT_REPEAT(178),
  [536] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_elem_list_repeat1, 2), SHIFT_REPEAT(185),
  [539] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instr_plain, 3),
  [541] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instr_plain, 3),
  [543] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ref_type, 1),
  [545] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ref_type, 1),
  [547] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_type, 1),
  [549] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_type, 1),
  [551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_table_init, 2),
  [553] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_table_init, 2),
  [555] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float, 2),
  [557] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_float, 2),
  [559] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_type_ref_type, 1),
  [561] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_type_ref_type, 1),
  [563] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float, 1),
  [565] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_float, 1),
  [567] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ref_type_ref, 4),
  [569] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ref_type_ref, 4),
  [571] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ref_type_ref, 5),
  [573] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ref_type_ref, 5),
  [575] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_type_num_type, 1),
  [577] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_type_num_type, 1),
  [579] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_table_copy, 1),
  [581] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_table_copy, 1),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_op_let_repeat1, 2),
  [585] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_op_let_repeat1, 2), SHIFT_REPEAT(727),
  [588] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_op_let_repeat1, 2),
  [590] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_op_let, 2), SHIFT(715),
  [593] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_op_let_repeat2, 2),
  [595] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_op_let_repeat2, 2), SHIFT_REPEAT(715),
  [598] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_op_let_repeat2, 2),
  [600] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_op_let, 3), SHIFT(715),
  [603] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_op_let, 4), SHIFT(715),
  [606] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_let, 5),
  [608] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_op_let, 5), SHIFT(715),
  [611] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_let, 5),
  [613] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_elem_list_repeat1, 1),
  [615] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_elem_list_repeat1, 1),
  [617] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_int, 1),
  [619] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_int, 1),
  [621] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_int, 2),
  [623] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_int, 2),
  [625] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_select, 1),
  [627] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_op_select, 1), SHIFT(751),
  [630] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_select, 1),
  [632] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_block_block_repeat1, 2),
  [634] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_block_repeat1, 2), SHIFT_REPEAT(807),
  [637] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_block_block_repeat1, 2),
  [639] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_block_block_repeat2, 2),
  [641] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_block_repeat2, 2), SHIFT_REPEAT(751),
  [644] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_block_block_repeat2, 2),
  [646] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_select, 2),
  [648] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_op_select, 2), SHIFT(751),
  [651] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_select, 2),
  [653] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_block, 5),
  [655] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_block, 5),
  [657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_block, 2),
  [661] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_block, 2),
  [663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [665] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_loop, 6),
  [667] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_loop, 6),
  [669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [671] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_if, 10),
  [673] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_if, 10),
  [675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [677] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_block, 6),
  [679] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_block, 6),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [683] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_if, 9),
  [685] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_if, 9),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [689] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_block, 3),
  [691] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_block, 3),
  [693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [695] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_offset_value, 3),
  [697] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_offset_value, 3),
  [699] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_block, 4),
  [701] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_block, 4),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [705] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_loop, 5),
  [707] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_loop, 5),
  [709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [711] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_loop, 2),
  [713] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_loop, 2),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [717] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_if, 6),
  [719] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_if, 6),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [723] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_if, 8),
  [725] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_if, 8),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [729] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_loop, 4),
  [731] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_loop, 4),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [735] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_loop, 7),
  [737] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_loop, 7),
  [739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [741] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_if, 3),
  [743] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_if, 3),
  [745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [747] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_if, 2),
  [749] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_if, 2),
  [751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [753] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_if, 5),
  [755] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_if, 5),
  [757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_if, 7),
  [761] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_if, 7),
  [763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [765] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_block, 7),
  [767] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_block, 7),
  [769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [771] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_loop, 3),
  [773] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_loop, 3),
  [775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [777] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_if, 4),
  [779] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_if, 4),
  [781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [783] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_simd_lane, 4),
  [785] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_simd_lane, 4),
  [787] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_simd_const, 18),
  [789] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_simd_const, 18),
  [791] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_func_type_params, 1),
  [793] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_func_type_params, 1),
  [795] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_block_block_repeat2, 1),
  [797] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_block_block_repeat2, 1),
  [799] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_func_bind, 5),
  [801] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_func_bind, 5),
  [803] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_func_locals_many, 3),
  [805] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_func_locals_many, 3),
  [807] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_func_type_params_many, 3),
  [809] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_func_type_params_many, 3),
  [811] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_instr_list_repeat1, 1),
  [813] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_instr_list_repeat1, 1),
  [815] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_simd_lane, 6),
  [817] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_simd_lane, 6),
  [819] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instr_plain, 4),
  [821] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instr_plain, 4),
  [823] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_align_value, 3),
  [825] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_align_value, 3),
  [827] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_simd_const, 6),
  [829] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_simd_const, 6),
  [831] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_func_type_results, 3),
  [833] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_func_type_results, 3),
  [835] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_table_init, 3),
  [837] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_table_init, 3),
  [839] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_table_copy, 3),
  [841] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_table_copy, 3),
  [843] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instr_call, 4),
  [845] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instr_call, 4),
  [847] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instr_call, 2),
  [849] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instr_call, 2),
  [851] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instr_call, 5),
  [853] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instr_call, 5),
  [855] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_simd_lane, 18),
  [857] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_simd_lane, 18),
  [859] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_block, 8),
  [861] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_block, 8),
  [863] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_func_locals_one, 5),
  [865] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_func_locals_one, 5),
  [867] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_simd_const, 4),
  [869] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_simd_const, 4),
  [871] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_loop, 8),
  [873] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_loop, 8),
  [875] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_func_type_params_one, 5),
  [877] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_func_type_params_one, 5),
  [879] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_op_let_repeat1, 1),
  [881] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_op_let_repeat1, 1),
  [883] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_simd_const, 10),
  [885] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_simd_const, 10),
  [887] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_use, 4),
  [889] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_use, 4),
  [891] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instr_block, 1),
  [893] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instr_block, 1),
  [895] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_func_locals, 1),
  [897] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_func_locals, 1),
  [899] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_func_type_results, 4),
  [901] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_func_type_results, 4),
  [903] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_func_type_params_many, 4),
  [905] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_func_type_params_many, 4),
  [907] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instr_call, 3),
  [909] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instr_call, 3),
  [911] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_block_block_repeat1, 1),
  [913] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_block_block_repeat1, 1),
  [915] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_op_let_repeat2, 1),
  [917] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_op_let_repeat2, 1),
  [919] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_if, 11),
  [921] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_if, 11),
  [923] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_func_locals_many, 4),
  [925] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_func_locals_many, 4),
  [927] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instr, 1),
  [929] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instr, 1),
  [931] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_func_bind, 1),
  [933] = {.entry = {.count = 1, .reusable = false}}, SHIFT(760),
  [935] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_func_bind, 1),
  [937] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_const, 2),
  [939] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_const, 2),
  [941] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_type_imm, 1),
  [943] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_global_type_imm, 1),
  [945] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_type, 1),
  [947] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_global_type, 1),
  [949] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_type_mut, 4),
  [951] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_global_type_mut, 4),
  [953] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_elem_expr_item_repeat1, 1),
  [955] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_elem_expr_item_repeat1, 1),
  [957] = {.entry = {.count = 1, .reusable = false}}, SHIFT(521),
  [959] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [963] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [965] = {.entry = {.count = 1, .reusable = false}}, SHIFT(164),
  [967] = {.entry = {.count = 1, .reusable = false}}, SHIFT(531),
  [969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [971] = {.entry = {.count = 1, .reusable = false}}, SHIFT(624),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [977] = {.entry = {.count = 1, .reusable = false}}, SHIFT(684),
  [979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [985] = {.entry = {.count = 1, .reusable = false}}, SHIFT(595),
  [987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(781),
  [991] = {.entry = {.count = 1, .reusable = false}}, SHIFT(364),
  [993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [997] = {.entry = {.count = 1, .reusable = false}}, SHIFT(170),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [1001] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_func_locals_many_repeat1, 2),
  [1003] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_func_locals_many_repeat1, 2), SHIFT_REPEAT(684),
  [1006] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_func_locals_many_repeat1, 2), SHIFT_REPEAT(206),
  [1009] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_func_locals_many_repeat1, 2), SHIFT_REPEAT(198),
  [1012] = {.entry = {.count = 1, .reusable = true}}, SHIFT(588),
  [1014] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1016] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [1018] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [1020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [1022] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [1024] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [1026] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_ROOT_repeat1, 2),
  [1028] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_ROOT_repeat1, 2), SHIFT_REPEAT(364),
  [1031] = {.entry = {.count = 1, .reusable = true}}, SHIFT(801),
  [1033] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ROOT, 1),
  [1035] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr1_call, 1),
  [1037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [1039] = {.entry = {.count = 1, .reusable = true}}, SHIFT(663),
  [1041] = {.entry = {.count = 1, .reusable = true}}, SHIFT(661),
  [1043] = {.entry = {.count = 1, .reusable = false}}, SHIFT(602),
  [1045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [1047] = {.entry = {.count = 1, .reusable = true}}, SHIFT(761),
  [1049] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [1051] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [1053] = {.entry = {.count = 1, .reusable = true}}, SHIFT(607),
  [1055] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [1057] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [1059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [1061] = {.entry = {.count = 1, .reusable = true}}, SHIFT(606),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [1069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1071] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [1073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(815),
  [1075] = {.entry = {.count = 1, .reusable = false}}, SHIFT(360),
  [1077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [1081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1083] = {.entry = {.count = 1, .reusable = false}}, SHIFT(436),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [1087] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 2),
  [1089] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_annotation_repeat1, 2), SHIFT_REPEAT(360),
  [1092] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 2), SHIFT_REPEAT(518),
  [1095] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 2), SHIFT_REPEAT(461),
  [1098] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 2), SHIFT_REPEAT(436),
  [1101] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_annotation_repeat1, 2), SHIFT_REPEAT(436),
  [1104] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 2), SHIFT_REPEAT(520),
  [1107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(811),
  [1109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [1113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [1115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(730),
  [1117] = {.entry = {.count = 1, .reusable = false}}, SHIFT(546),
  [1119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [1121] = {.entry = {.count = 1, .reusable = false}}, SHIFT(152),
  [1123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [1125] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr1_call, 2),
  [1127] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_offset, 1),
  [1129] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_offset, 1),
  [1131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_offset_expr, 1),
  [1133] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_offset_expr, 1),
  [1135] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_func_locals_many_repeat1, 1),
  [1137] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_func_locals_many_repeat1, 1),
  [1139] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_offset_const_expr, 4),
  [1141] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_offset_const_expr, 4),
  [1143] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_offset_const_expr, 3),
  [1145] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_offset_const_expr, 3),
  [1147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(694),
  [1149] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr1_call, 3),
  [1151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_desc_func_type_repeat1, 2),
  [1153] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_import_desc_func_type_repeat1, 2), SHIFT_REPEAT(639),
  [1156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(752),
  [1158] = {.entry = {.count = 1, .reusable = false}}, SHIFT(639),
  [1160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(731),
  [1162] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr1_call, 4),
  [1164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_limits, 1),
  [1166] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_limits, 1),
  [1168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [1170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(788),
  [1172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(693),
  [1174] = {.entry = {.count = 1, .reusable = false}}, SHIFT(529),
  [1176] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [1178] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elem_list, 2),
  [1180] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [1182] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elem_list, 1),
  [1184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [1186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(650),
  [1188] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_elem_list_repeat2, 2),
  [1190] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_elem_list_repeat2, 2), SHIFT_REPEAT(173),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(744),
  [1195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [1197] = {.entry = {.count = 1, .reusable = false}}, SHIFT(203),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [1203] = {.entry = {.count = 1, .reusable = false}}, SHIFT(527),
  [1205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(771),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [1213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [1215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [1219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [1221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [1223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [1225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr1_call, 5),
  [1227] = {.ent