/* tn5250 -- an implentation of the 5250 telnet protocol.
 * Copyright (C) 1997 Michael Madore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef SESSION_H
#define SESSION_H

//
// The Session class should be the "master class" which drives all of the
// now-modular elements.
//
class Session {
protected:
   Terminal *term;
   Stream5250 *strm;
   DisplayBuffer disp_buf;
   DisplayBuffer *saved_bufs [256];
   FormatTable table;
   Record inpacket;
   int pending_insert;
   int cur_command;
   int cur_opcode;
   int invited;
   int inhibited;

public:
   Session ();
   virtual ~Session ();

   // Get/Set Terminal object.
   Terminal *terminal (void) const;
   Terminal *terminal (Terminal *newterminal);

   // Get/Set Stream object.
   Stream5250 *stream (void) const;
   Stream5250 *stream (Stream5250 *newstream);

   // Run the main loop.
   void MainLoop (void);

private:

   // 5250 Aid Codes
   enum aid_t {
      AID_F1 =		0x31,
      AID_F2 =		0x32,
      AID_F3 =		0x33,
      AID_F4 =		0x34,
      AID_F5 =		0x35,
      AID_F6 =		0x36,
      AID_F7 =		0x37,
      AID_F8 =		0x38,
      AID_F9 =		0x39,
      AID_F10 =		0x3A,
      AID_F11 =		0x3B,
      AID_F12 =		0x3C,
      AID_F13 =		0xB1,
      AID_F14 =		0xB2,
      AID_F15 =		0xB3,
      AID_F16 =		0xB4,
      AID_F17 =		0xB5,
      AID_F18 =		0xB6,
      AID_F19 =		0xB7,
      AID_F20 =		0xB8,
      AID_F21 =		0xB9,
      AID_F22 =		0xBA,
      AID_F23 =		0xBB,
      AID_F24 =		0xBC,
      AID_CLEAR	=	0xBD,
      AID_ENTER =	0xF1,
      AID_PGUP =	0xF4,
      AID_PGDN =	0xF5
   };

/* Control Character definitions (Byte two) */
   enum ctrl_char_t {
      CTL_MESSAGE_OFF = 0x40,
      CTL_MESSAGE_ON = 0x80
   };

   void HandleKey (void);
   void HandleReceive (void);
   void Invite (void);
   void CancelInvite (void);
   void SendFields (int cur_command, int aidcode);
   void ProcessStream (void);
   void WriteErrorCode (void);
   void WriteToDisplay (void);
   void ClearUnit (void);
   void ClearFormatTable (void);
   void ReadImmediate (void);

   void SystemRequest (void);
   void Attention (void);
   void OutputOnly (void);
   void SaveScreen (void);
   void RestoreScreen (void);
   void MessageOn (void);
   void MessageOff (void);
   void Roll (void);
   void StartOfField (void);
   void StartOfHeader (void);
   void SetBufferAddress (void);
   void RepeatToAddress (void);
   void InsertCursor (void);
   void WriteStructuredField (void);
   void ReadScreenImmediate (void);
   void ReadInputFields (void);
   void ReadMDTFields (void);
   void Display_FFW (int field_number);
};

#endif /* SESSION_H */
