/* tn5250 -- an implentation of the 5250 telnet protocol.
 * Copyright (C) 1997 Michael Madore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef INPACKET5250
#define INPACKET5250

#include <stdio.h>
#include "codes5250.h"

class Record: public Buffer {
public:
   
   enum flow_t {
      DISPLAY = 0x00,
      STARTUP = 0x90,
      SERVERO = 0x11,
      CLIENTO = 0x12
   };

   enum flags_t {
      H_NONE	        = 0,
      H_ERR	        = 0x80,
      H_ATN	        = 0x40,
      H_PRINTER_READY   = 0x20,
      H_FIRST_OF_CHAIN  = 0x10,
      H_LAST_OF_CHAIN   = 0x08,
      H_SRQ	        = 0x04,
      H_TRQ	        = 0x02,
      H_HLP	        = 0x01
   };

   enum opcode_t {
      NO_OP	     = 0,
      INVITE	     = 1,
      OUTPUT_ONLY    = 2,
      PUT_GET	     = 3,
      SAVE_SCR	     = 4,
      RESTORE_SCR    = 5,
      READ_IMMED     = 6,
      READ_SCR	     = 8,
      CANCEL_INVITE  = 10,
      MESSAGE_ON     = 11,
      MESSAGE_OFF    = 12,
      PRINT_COMPLETE = 1,
      CLEAR          = 2
   };

private:
   unsigned char flowtype[2];
   unsigned char flags;
   unsigned char opcode;
   int cur_pos;
   int header_length;
            
public:
   Record ();
   void Init();
   unsigned char GetByte();
   void UnGetByte();
   void SetFlowType(unsigned char byte1, unsigned char byte2);
   void SetFlags(unsigned char flags);
   void SetOpcode(unsigned char opcode);
   void SetHeaderLength(int hlength);
   unsigned char GetOpcode();
   int GetFlowType();
   int IsChainEnd();
   int SysRequest();
   int Attention();
   void Dump();
};

#endif
