#include "bufferpool.h"
#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>

BufferPool::BufferPool ()
{
   int curbuffer;

   for(curbuffer = 0; curbuffer < MAX_BUFFERS; curbuffer++) {
      freelist[curbuffer] = 1;
      buffersizes[curbuffer] = 0;
   }
}

BufferPool::~BufferPool ()
{
   int curbuffer;

   for(curbuffer = 0; curbuffer < MAX_BUFFERS; curbuffer++)
   {
      if(!freelist[curbuffer]) 
         free(buffers[curbuffer]);
      
   }
}

int BufferPool::SetBuffer(void * data, int size)
{
   int curbuffer;
   int buffnum;

   buffnum = -1;
   for(curbuffer = 0; curbuffer < MAX_BUFFERS; curbuffer++)
   {
      if(freelist[curbuffer]) {
         buffnum = curbuffer;
         break;
      }
   }

   if(buffnum >= 0)
   {
      buffersizes[buffnum] = size;
      freelist[buffnum] = 0;
      buffers[buffnum] = (void *) malloc(size);
      memcpy(buffers[buffnum], data, size);
   }

   return(buffnum);
}

void BufferPool::GetBuffer(void * data, int buffernum)
{
   
   if(!freelist[buffernum])
   {
      memcpy(data, buffers[buffernum], buffersizes[buffernum]);
      free(buffers[buffernum]); 
      freelist[buffernum] = 1;
      buffersizes[buffernum] = 0;
         
   }
}
