package job

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CompileMode enumerates the values for compile mode.
type CompileMode string

const (
	// Full ...
	Full CompileMode = "Full"
	// Semantic ...
	Semantic CompileMode = "Semantic"
	// SingleBox ...
	SingleBox CompileMode = "SingleBox"
)

// PossibleCompileModeValues returns an array of possible values for the CompileMode const type.
func PossibleCompileModeValues() []CompileMode {
	return []CompileMode{Full, Semantic, SingleBox}
}

// ResourceType enumerates the values for resource type.
type ResourceType string

const (
	// JobManagerResource ...
	JobManagerResource ResourceType = "JobManagerResource"
	// JobManagerResourceInUserFolder ...
	JobManagerResourceInUserFolder ResourceType = "JobManagerResourceInUserFolder"
	// StatisticsResource ...
	StatisticsResource ResourceType = "StatisticsResource"
	// StatisticsResourceInUserFolder ...
	StatisticsResourceInUserFolder ResourceType = "StatisticsResourceInUserFolder"
	// VertexResource ...
	VertexResource ResourceType = "VertexResource"
	// VertexResourceInUserFolder ...
	VertexResourceInUserFolder ResourceType = "VertexResourceInUserFolder"
)

// PossibleResourceTypeValues returns an array of possible values for the ResourceType const type.
func PossibleResourceTypeValues() []ResourceType {
	return []ResourceType{JobManagerResource, JobManagerResourceInUserFolder, StatisticsResource, StatisticsResourceInUserFolder, VertexResource, VertexResourceInUserFolder}
}

// Result enumerates the values for result.
type Result string

const (
	// Cancelled ...
	Cancelled Result = "Cancelled"
	// Failed ...
	Failed Result = "Failed"
	// None ...
	None Result = "None"
	// Succeeded ...
	Succeeded Result = "Succeeded"
)

// PossibleResultValues returns an array of possible values for the Result const type.
func PossibleResultValues() []Result {
	return []Result{Cancelled, Failed, None, Succeeded}
}

// SeverityTypes enumerates the values for severity types.
type SeverityTypes string

const (
	// Deprecated ...
	Deprecated SeverityTypes = "Deprecated"
	// Error ...
	Error SeverityTypes = "Error"
	// Info ...
	Info SeverityTypes = "Info"
	// SevereWarning ...
	SevereWarning SeverityTypes = "SevereWarning"
	// UserWarning ...
	UserWarning SeverityTypes = "UserWarning"
	// Warning ...
	Warning SeverityTypes = "Warning"
)

// PossibleSeverityTypesValues returns an array of possible values for the SeverityTypes const type.
func PossibleSeverityTypesValues() []SeverityTypes {
	return []SeverityTypes{Deprecated, Error, Info, SevereWarning, UserWarning, Warning}
}

// State enumerates the values for state.
type State string

const (
	// StateAccepted ...
	StateAccepted State = "Accepted"
	// StateCompiling ...
	StateCompiling State = "Compiling"
	// StateEnded ...
	StateEnded State = "Ended"
	// StateFinalizing ...
	StateFinalizing State = "Finalizing"
	// StateNew ...
	StateNew State = "New"
	// StatePaused ...
	StatePaused State = "Paused"
	// StateQueued ...
	StateQueued State = "Queued"
	// StateRunning ...
	StateRunning State = "Running"
	// StateScheduling ...
	StateScheduling State = "Scheduling"
	// StateStarting ...
	StateStarting State = "Starting"
	// StateWaitingForCapacity ...
	StateWaitingForCapacity State = "WaitingForCapacity"
	// StateYielded ...
	StateYielded State = "Yielded"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateAccepted, StateCompiling, StateEnded, StateFinalizing, StateNew, StatePaused, StateQueued, StateRunning, StateScheduling, StateStarting, StateWaitingForCapacity, StateYielded}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeHive ...
	TypeHive Type = "Hive"
	// TypeJobProperties ...
	TypeJobProperties Type = "JobProperties"
	// TypeScope ...
	TypeScope Type = "Scope"
	// TypeUSQL ...
	TypeUSQL Type = "USql"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeHive, TypeJobProperties, TypeScope, TypeUSQL}
}

// TypeBasicCreateJobProperties enumerates the values for type basic create job properties.
type TypeBasicCreateJobProperties string

const (
	// TypeBasicCreateJobPropertiesTypeCreateJobProperties ...
	TypeBasicCreateJobPropertiesTypeCreateJobProperties TypeBasicCreateJobProperties = "CreateJobProperties"
	// TypeBasicCreateJobPropertiesTypeScope ...
	TypeBasicCreateJobPropertiesTypeScope TypeBasicCreateJobProperties = "Scope"
	// TypeBasicCreateJobPropertiesTypeUSQL ...
	TypeBasicCreateJobPropertiesTypeUSQL TypeBasicCreateJobProperties = "USql"
)

// PossibleTypeBasicCreateJobPropertiesValues returns an array of possible values for the TypeBasicCreateJobProperties const type.
func PossibleTypeBasicCreateJobPropertiesValues() []TypeBasicCreateJobProperties {
	return []TypeBasicCreateJobProperties{TypeBasicCreateJobPropertiesTypeCreateJobProperties, TypeBasicCreateJobPropertiesTypeScope, TypeBasicCreateJobPropertiesTypeUSQL}
}

// TypeEnum enumerates the values for type enum.
type TypeEnum string

const (
	// Hive ...
	Hive TypeEnum = "Hive"
	// Scope ...
	Scope TypeEnum = "Scope"
	// USQL ...
	USQL TypeEnum = "USql"
)

// PossibleTypeEnumValues returns an array of possible values for the TypeEnum const type.
func PossibleTypeEnumValues() []TypeEnum {
	return []TypeEnum{Hive, Scope, USQL}
}
