/*-
 * This file contains the interface for the user interface of tcd.
 */

#ifndef TCD_USER_INTERFACE_H
#define TCD_USER_INTERFACE_H

#include "tcd.h"

/**
 * Initializes the user interface. This procedure must be called
 * once at startup.
 */
extern void tcd_ui_init(void);

/**
 * Cleanly shuts down the user interface.
 */
extern void tcd_ui_shutdown(void);

/**
 * Updates the whole user interface using the state information.
 */
extern void tcd_ui_update(struct tcd_state *state);

/**
 * Asks the user to input a track to jump to.
 */
extern int get_i_track(void);

/**
 * Reads a key from the user. If /delay/ is positive, the timeout
 * is set to /delay/ deciseconds. If it is negative, input is blocking.
 */
extern int tcd_ui_readkey(int delay);

#endif
