'''
This file contains the residuals for testing GLM.

All residuals were obtained with Stata.

The residuals are column ordered as

Pearson, Deviance, Working, Anscombe, and Response Residuals
'''


import numpy as np

# TODO: wrap super-long lines.  maybe put these in csv files?
lbw = [-.67369007, -.86512534, -.06703079, -.93506245, -.31217507, -.38301082, -.52323205, -.01427243, -.55879206, -.12793027, -.68788286, -.88025592, -.07003063, -.95205459, -.32119762, -.96932399, -1.1510657, -.12098923, -1.2626094, -.48442686, -1.017216, -1.1919416, -.12709645, -1.3106868, -.50853393, -.56992387, -.75002865, -.04537362, -.80685236, -.24517662, -.38236113, -.52240243, -.01419429, -.5578939, -.12755193, -.70541551, -.89874491, -.07371959, -.97286469, -.33226988, -.53129095, -.70516948, -.03779124, -.75734471, -.22013309, -.59687896, -.78068461, -.05087588, -.84082824, -.26268069, -.72944938, -.92372831, -.07872676, -1.0010676, -.34729955, -.48089188, -.64503581, -.02865125, -.6913447, -.18782188, -1.7509231, -1.6748694, -.13984667, -1.9107428, -.75404181, -1.0993874, -1.2588746, -.13558784, -1.3901949, -.54723527, -.73406378, -.9284774, -.0796795, -1.0064397, -.35016393, -.73406378, -.9284774, -.0796795, -1.0064397, -.35016393, -.91970083, -1.1071944, -.11376204, -1.2113902, -.45824406, -.58253395, -.76443611, -.04792993, -.8228052, -.25336683, -.87010277, -1.0617464, -.10565948, -1.1587271, -.43087357, -.55091811, -.72809506, -.04159148, -.78261562, -.23284101, -.50228984, -.67078749, -.03241138, -.71955949, -.20146616, -.56681231, -.74645574, -.04474827, -.80290024, -.24315597, -.16739043, -.23509228, -.00072263, -.24969795, -.02725586, -.53429779, -.70869969, -.03836573, -.76123202, -.22207692, -.81310524, -1.0074762, -.09536044, -1.0963421, -.39800383, -.24319644, -.339003, -.00294417, -.36060255, -.05584178, -.62985338, -.81746346, -.05776093, -.88175202, -.28403447, -.27289888, -.37902784, -.00447115, -.403468, -.06931188, -.73980785, -.9343678, -.08086098, -1.0131078, -.35371946, -.79896487, -.99366645, -.09266053, -1.0805507, -.3896279, -.79896487, -.99366645, -.09266053, -1.0805507, -.3896279, -.95715693, -1.140454, -.11930111, -1.2501848, -.47812002, -1.2258645, -1.3545388, -.14405247, -1.5056478, -.60043853, -.27739012, -.38504179, -.00474005, -.40991694, -.07144772, -.65459114, -.84453257, -.06298676, -.91198968, -.29995988, -.46709275, -.62825848, -.02633193, -.67300059, -.17910031, -.54303849, -.71892471, -.04005189, -.77249964, -.22773411, -.54176628, -.71743989, -.03980502, -.77086265, -.22691015, -.25756493, -.35841857, -.00362961, -.38138453, -.06221253, -.55956791, -.73810992, -.04330137, -.79367479, -.2384528, -.69600671, -.88885063, -.07174285, -.96172188, -.32633864, -.23256318, -.32457262, -.00249768, -.34516994, -.05131047, -.64757466, -.83690034, -.06150185, -.90345369, -.2954536, -.28195528, -.39114407, -.00502406, -.41646289, -.07364416, -1.1570243, -1.3035317, -.14010172, -1.443813, -.57241299, -1.1570243, -1.3035317, -.14010172, -1.443813, -.57241299, -.30030789, -.41556527, -.00627721, -.44268348, -.08272435, -.55114605, -.72835967, -.04163627, -.78290767, -.23298882, -.3806923, -.52027022, -.01399469, -.5555858, -.12658158, -1.1987876, -1.33477, -.1426768, -1.4816055, -.58967487, -.94149929, -1.12666, -.11704805, -1.2340685, -.46989562, -.53813037, -.71318989, -.03910216, -.76617855, -.22455631, -.55398245, -.73164922, -.04219494, -.78653899, -.2348285, -.6479873, -.83735019, -.06158914, -.90395657, -.29571887, -.62689671, -.81419816, -.0571388, -.87811137, -.28212464, -.67810985, -.86985289, -.06796584, -.94036802, -.31499013, -1.4692211, -1.5166623, -.14786328, -1.7067836, -.68340511, -.40499087, -.55113968, -.01705699, -.58904006, -.14090647, -.67731506, -.86900381, -.06779774, -.93941488, -.31448425, -.62489302, -.81198168, -.0567176, -.87564093, -.28082972, -.62489302, -.81198168, -.0567176, -.87564093, -.28082972, -.57609901, -.75709845, -.04662119, -.81467722, -.24918728, -.60844593, -.79367679, -.0532758, -.85526404, -.27018297, -.29839126, -.41302333, -.00613785, -.43995243, -.08175784, -1.3570687, -1.4452542, -.14780947, -1.6172873, -.64808999, -.78708367, -.98195509, -.0903525, -1.0671844, -.38252574, -.5858308, -.76818375, -.04860366, -.82695911, -.25550797, -.31665807, -.43716753, -.00754852, -.46591063, -.09113411, -.82908669, -1.0229172, -.09834616, -1.1140383, -.40736693, -.69616804, -.88902083, -.07177681, -.96191342, -.32644055, -1.0915205, -1.2526359, -.13488154, -1.3827415, -.54367425, -.64853308, -.837945, -.0617046, -.90462156, -.29606968, -.94223393, -1.1273107, -.11715578, -1.2348278, -.47028421, -.816023, -1.0103085, -.09591088, -1.0995849, -.39972155, -.57856847, -.75991792, -.04712242, -.81779956, -.25079125, -.32734654, -.45120803, -.00846067, -.48102477, -.09678472, -.31077092, -.42940642, -.00707363, -.45756203, -.08807264, -.61538501, -.80142385, -.05472422, -.86388252, -.27467837, -1.1456594, -1.2948703, -.13930185, -1.4333765, -.5675742, -.21863111, -.30558898, -.00198616, -.32488425, -.045619, -.34650082, -.47620326, -.01025864, -.50796716, -.10719293, -.22518959, -.31453605, -.00221689, -.33444271, -.04826292, -.56093617, -.73968913, -.04357365, -.79541979, -.23934092, -.56471813, -.74404709, -.04432868, -.80023684, -.24179618, -.5589041, -.73734327, -.04316945, -.79282776, -.23802197, -.98405074, -1.1637857, -.12295866, -1.2775329, -.49196179, -.67623178, -.86784578, -.06756859, -.9381151, -.31379451, -.34443674, -.47352019, -.01005474, -.50507281, -.10605469, -.20538064, -.28745723, -.00157184, -.30552538, -.04047396, -.36261354, -.49705954, -.01193509, -.53048488, -.11620849, -.33216574, -.45751709, -.00889321, -.48782091, -.09937016, -.52834459, -.70170398, -.03723117, -.75353006, -.21822964, -.65107472, -.84071206, -.06224241, -.90771574, -.29770265, -2.2838855, -1.9116213, -.11327561, -2.2332026, -.83912829, -.57856847, -.75991792, -.04712242, -.81779956, -.25079125, -.30573921, -.4227577, -.00668307, -.45041336, -.08548557, -.26475363, -.36809496, -.0040096, -.39174994, -.06550308, -.50724876, -.67670909, -.03330933, -.72605772, -.2046457, -.50724876, -.67670909, -.03330933, -.72605772, -.2046457, -.29708892, -.41129496, -.00604429, -.43809571, -.08110349, -.39538836, -.53898588, -.01580695, -.57585866, -.13519643, -.95811737, -1.141295, -.11943637, -1.2511687, -.47862055, -.79777479, -.99249783, -.09243093, -1.0792158, -.38891913, -.4007824, -.54582043, -.01650278, -.58326946, -.1383964, -.59547213, -.77909775, -.05058538, -.83906658, -.26176764, -.67961214, -.87145655, -.06828352, -.9421685, -.31594589, -.35903387, -.49243968, -.01154966, -.52549403, -.11418612, -.25982794, -.36146745, -.00374651, -.38464992, -.06324112, -.63086237, -.8185763, -.0579734, -.88299313, -.28468594, -.52587777, -.6987977, -.03676448, -.75033205, -.21663702, -.19948442, -.27936589, -.00140862, -.29689136, -.03827107, -.61183026, -.7974596, -.05398148, -.85947135, -.27237604, -.50385167, -.67265442, -.03269316, -.72160779, -.20246694, -.48499858, -.65000311, -.02935791, -.69678155, -.19042999, -.42040434, -.57052211, -.01917023, -.61008878, -.15019447, -.48053382, -.64460216, -.02858999, -.69087017, -.18759474, -.37464721, -.51253189, -.01328506, -.54721232, -.12308435, -.49531764, -.66243224, -.03116534, -.71039719, -.19700616, -.36160926, -.49576422, -.01182621, -.52908537, -.11564002, -.75971278, -.95459728, -.08491171, -1.0360505, -.36595033, -.29016492, -.40209055, -.00556233, -.42821114, -.07765727, -.40546611, -.55173962, -.01712019, -.58969106, -.14119063, -.39648646, -.54037876, -.01594727, -.57736865, -.13584627, -.35179057, -.48306766, -.01079245, -.51537461, -.11012759, -.33522775, -.46151868, -.00917494, -.49213296, -.10102472, -.33337344, -.45909602, -.00900368, -.48952221, -.10002166, -.28349954, -.39320584, -.00512259, -.41867509, -.07439288, -.62237174, -.80918847, -.05618813, -.87252863, -.27919958, -.37781929, -.51659535, -.01365481, -.55160868, -.12491598, -.26957183, -.37456618, -.00427859, -.39868504, -.06774594, .61566918, .80174036, .05478366, .86423481, .27486236, 2.1552118, 1.8605156, .11994504, 2.1616254, .82285014, .6958925, .88873013, .07171881, .96158626, .32626648, .48936001, .65526554, .03011636, .70254431, .19320564, .94341916, 1.1283597, .11732917, 1.2360523, .47091059, 2.317558, 1.9244575, .11155378, 2.2513666, .84304062, 1.0055755, 1.1821359, .12569111, 1.2991214, .50277997, 1.1758629, 1.3177365, .14133315, 1.4609684, .58029986, .77665994, .97159873, .08829985, 1.0553839, .37624776, .92862761, 1.1152029, .11512854, 1.2207114, .46304378, 1.7104194, 1.6537851, .14148619, 1.8830756, .74525762, .51347062, .68411403, .03444926, .73418924, .20864293, 1.7302647, 1.6641798, .14069739, 1.8966961, .7496129, 1.7159282, 1.656683, .14127016, 1.886869, .74647663, 1.4097427, 1.4794559, .14814617, 1.659967, .66525789, 2.0442483, 1.8136166, .12572138, 2.0969416, .80691071, 1.7479484, 1.6733383, .13997094, 1.9087284, .75341056, 1.7094805, 1.6532902, .14152278, 1.8824281, .74504908, 1.4965596, 1.5332827, .14752494, 1.7278315, .69132856, 1.1936562, 1.330981, .14239054, 1.4770087, .58759741, .82652693, 1.0204559, .09787281, 1.1112146, .40587474, 2.2245013, 1.8884508, .11633994, 2.2006058, .83188774, 1.0349547, 1.206727, .12914052, 1.3281647, .51717209, 1.3170894, 1.4184715, .14713645, 1.5840959, .63433244, 3.1267629, 2.1805419, .07637108, 2.631322, .90720675, .57215628, .7525877, .04582366, .809684, .24662647, .86627248, 1.0581685, .10499903, 1.1545978, .42871115, .94218582, 1.1272681, .11714873, 1.2347781, .47025877, 1.1156811, 1.2716852, .13698079, 1.405528, .55451496, .53496988, .70948787, .03849454, .76210013, .22251157, 1.4497097, 1.5046175, .14802749, 1.6915825, .6775918, 1.2233611, 1.3527267, .14393463, 1.5034398, .59945723, 1.545073, 1.5620618, .14664053, 1.7644793, .70477532, 2.020635, 1.803272, .12694042, 2.0827983, .80326447, .59611095, .7798185, .05071725, .83986668, .26218226, .85655928, 1.0490513, .1033029, 1.144086, .42319688, 1.1157473, 1.2717369, .13698625, 1.40559, .55454427, 1.5187563, 1.5465618, .1471632, 1.7447092, .69757645, 1.2580261, 1.3775399, .14540261, 1.5337471, .61279777, 2.2387897, 1.8940894, .11559989, 2.2085158, .83367096, 1.4987735, 1.5346157, .14749226, 1.7295233, .69195908, .87949714, 1.0704799, .10725881, 1.1688167, .43614806, .81628943, 1.0105668, .09596102, 1.0998807, .39987821, 1.0340841, 1.2060057, .12904294, 1.327311, .51675179, 1.7490122, 1.6738861, .13992657, 1.9094491, .75363655, 1.6803635, 1.6378022, .14262258, 1.8622063, .73846784, 1.8051113, 1.7022925, .13748913, 1.9469661, .7651715, 1.5637979, 1.5729326, .14621078, 1.7783904, .70976331, 1.1993095, 1.3351545, .14270545, 1.4820722, .58988546, 1.3197815, 1.4202979, .1471939, 1.5863531, .63527917, .71898726, .91290406, .07655565, .98883657, .34077931, 1.5103554, 1.5415584, .14730892, 1.7383434, .69523097, 3.0022063, 2.1465826, .08091665, 2.5788383, .90013225, .64440768, .83344364, .06083212, .89959036, .29341668, 1.5019795, 1.5365427, .14744358, 1.7319699, .69286925, 1.3305489, 1.4275696, .1474058, 1.5953487, .63903614, .90521582, 1.094089, .11148405, 1.1961638, .45037299, .6236701, .81062745, .05646071, .87413186, .28003914, .71234937, .90599551, .07517106, .9810397, .3366244]  # noqa:E501

lbw_resids = np.array(lbw).astype(float).reshape(-1, 5)

cpunish = [.29883413, .29637762, 62.478695, .29638095, 1.7736344, .280627, .27622019, 6.5853375, .27623151, .80342558, 4.0930531, 2.9777878, 6.1503069, 3.0157174, 4.6881034, .16338859, .16114971, 1.1563983, .16115474, .31370176, .63595872, .59618385, 1.9109264, .59656954, .91769973, .9059739, .8066189, .99577089, .80822353, .9349684, .0532905, .0529548, .14244545, .05295515, .07395759, -.26830664, -.2766384, -1.0082872, -.27668319, -.41714051, -.62341484, -.68349824, -1.5652763, -.68459104, -.84732188, -1.1015655, -1.2743561, -5.3400286, -1.279951, -1.8643241, -1.2006618, -1.4021282, -6.6206839, -1.40923, -2.1211989, -1.2797534, -1.505173, -7.8054171, -1.5136295, -2.3382067, -.960585, -1.0954134, -3.8587164, -1.0992211, -1.5269969, .10846917, .10649195, .0921891, .10649783, .1027458, .02088367, .02081086, .02023963, .0208109, .02066675, .63647875, .56713011, .24880139, .56824372, .4653791, -.69597083, -.77000601, -1.9377178, -.77151335, -.97909358]  # noqa:E501

cpunish_resids = np.array(cpunish).astype(float).reshape(-1, 5)

scotvote = [.04317472, .04256856, -8338.93, .04256786, 2.4956853, -.01827077, -.01838325, 2762.4019, -.01838319, -.97334528, .05609817, .05508221, -7252.03, .05508069, 2.8365188, -.02280193, -.02297758, 4525.3102, -.02297747, -1.3300374, -.02505649, -.02526888, 8767.023, -.02526873, -1.7656214, -.1421743, -.14953291, 26174.801, -.14950069, -8.0880132, -.01973673, -.01986809, 5888.0406, -.01986801, -1.318784, .06763015, .06616299, -19473.553, .06616036, 4.4658962, .0202078, .02007327, -3928.3996, .02007319, 1.1706255, -.00841611, -.00843983, 2127.7741, -.00843983, -.53216875, -.04429363, -.04496504, 6971.3512, -.04496419, -2.3914787, .01158536, .01154092, -2667.3324, .01154091, .71006619, .05538677, .05439602, -15077.849, .05439455, 3.5896364, .09018494, .08760809, -23064.91, .087602, 5.7245313, .06595122, .06455471, -14747.68, .06455226, 4.0030388, .00220373, .00220212, -923.58004, .00220212, .16491647, .09775671, .09474141, -17697.14, .09473373, 5.5300885, -.0669005, -.06845346, 24989.253, -.06845044, -4.8180428, .05194846, .05107522, -13846.987, .05107401, 3.3432347, .01298505, .01292927, -1828.3796, .01292925, .67554021, .02257874, .02241101, -5988.3279, .02241091, 1.4506691, .01474752, .01467564, -5311.9833, .01467562, 1.0492967, .03640993, .03597719, -3483.054, .03597677, 1.665201, -.06613827, -.06765534, 10963.702, -.06765242, -3.633186, -.05046726, -.05134215, 15165.308, -.05134088, -3.3803129, -.02546479, -.02568421, 3585.6787, -.02568405, -1.3248006, -.08159133, -.08392239, 14470.556, -.08391679, -4.5841388, -.0330796, -.03345156, 6495.2667, -.03345121, -1.9226747, .00327289, .00326933, -1001.1863, .00326933, .22052594, -.02631155, -.02654593, 5824.1466, -.02654575, -1.5916286, .01183737, .01179098, -4763.0477, .01179097, .87390689, -.03325649, -.03363248, 11219.87, -.03363212, -2.3151557]  # noqa:E501

scotvote_resids = np.array(scotvote).astype(float).reshape(-1, 5)

star98 = [-1.3375372, -1.3342565, -3674.3805, -1.3343393, -18.732624, .97808463, .99272841, 197.05157, .99291658, 5.7338226, 4.2825696, 4.29447, 7304.117, 4.2983582, 51.167264, .20665475, .20689409, 283.85261, .20689456, 2.2971775, -3.4397844, -3.7418743, -184.10712, -3.7732602, -12.963164, -8.8955127, -8.7070478, -94493.01, -8.7156529, -195.54523, 1.3093612, 1.3040684, 6904.5348, 1.3041169, 22.790356, -2.3354095, -2.3171211, -6891.6853, -2.3175198, -33.497868, -4.9509734, -4.9716533, -7444.4706, -4.9782445, -56.720276, -4.3896461, -4.3936251, -19119.121, -4.3958412, -71.687315, 2.6246727, 2.6002292, 33800.262, 2.6004266, 61.52101, 1.0381778, 1.0655404, 147.40536, 1.0658131, 5.4160865, -5.371452, -5.4255371, -8735.5422, -5.433774, -63.167122, -7.5162302, -7.6600055, -16610.436, -7.6793193, -97.902488, -4.3246609, -4.217551, -1806.9456, -4.2260371, -32.330796, .71999176, .72316703, 1710.1519, .7231808, 9.6064571, .83376421, .83436314, 761.12734, .83440607, 8.0881266, .41765273, .41667589, 28.903009, .41670531, 1.7147122, -.97120884, -.97003594, -4270.4621, -.97005936, -15.911094, -.78556304, -.78233445, -114.9327, -.78245171, -4.1393793, .4683723, .46647357, 82.954347, .46649502, 2.6303115, -3.16957, -3.1551738, -3676.7765, -3.1571205, -33.303456, -.38920026, -.38921763, -264.25346, -.38922293, -3.4207576, -1.0390527, -1.0501682, -142.6529, -1.0504701, -5.3602524, -.49574502, -.50267378, -24.102686, -.50273464, -1.80937, -2.2481933, -2.4896172, -69.551199, -2.5023778, -7.0576042, -1.3995564, -1.4016203, -7695.0826, -1.4016817, -24.701957, -.76201728, -.76276852, -248.87895, -.76283364, -5.2477435, -5.8106439, -5.7357935, -3949.2359, -5.7521318, -51.088192, -1.820624, -1.8167933, -25414.833, -1.816864, -43.837178, -2.7775306, -2.8101272, -5091.1243, -2.8111605, -33.992033, -3.1071576, -3.1348341, -28006.635, -3.1353206, -64.66399, 11.837296, 12.808605, 52779.155, 12.870791, 194.83, -3.9656907, -3.9744174, -4008.7749, -3.9787813, -39.800004, -4.5046818, -4.5023142, -3336.6423, -4.5100703, -40.757978, -.38346895, -.38304692, -125.48142, -.38305507, -2.6424896, 5.6273411, 5.681476, 71231.288, 5.6838456, 131.14722, -1.5145537, -1.5377442, -638.15567, -1.5381844, -11.35443, 2.2753821, 2.2209277, 373.39831, 2.2231916, 12.457389, -4.8882434, -4.9340401, -177334.75, -4.9347866, -161.82036, -1.4349869, -1.4382502, -490.99346, -1.438675, -10.03669, -.96129188, -.96925001, -1132.2858, -.96930259, -10.152092, -.59602753, -.61535222, -10.219633, -.61556693, -1.5369367, -1.6921098, -1.7682293, -209.62528, -1.7697022, -8.4352944, -2.065882, -2.0983974, -2413.6559, -2.0989602, -21.758492, 1.706241, 1.6722477, 619.3497, 1.6727942, 12.171354, -2.2661248, -2.4109784, -229.55882, -2.4155989, -10.563809, 1.813806, 1.7981115, 2640.4014, 1.7984068, 20.556565, 2.8637417, 2.7708527, 953.89903, 2.7734059, 19.851349, -1.8653504, -1.9698798, -174.47052, -1.9724197, -8.4673524, 3.0149566, 2.8208287, 242.43232, 2.82676, 13.013203, .45187706, .45323648, 89.545212, .45325533, 2.6344764, 2.7424901, 2.5741674, 100.25966, 2.5823554, 9.102041, .80475572, .80568002, 162.81099, .8057857, 4.7242981, -1.7931126, -1.8014064, -550.80513, -1.8023078, -12.098672, .41003106, .4090133, 40.285464, .40903525, 1.8920269, -8.1724325, -8.1912034, -1099.8395, -8.3432365, -41.880384, .33393717, .33561525, 16.178174, .33563459, 1.2173618, -4.2543897, -4.4474257, -2759.1931, -4.4560182, -36.825802, -3.0294284, -3.1254693, -2652.9286, -3.1277555, -28.983377, 2.6466251, 2.5383754, 209.60581, 2.5434964, 11.365696, -.53150465, -.53394445, -574.22139, -.53395369, -5.4537827, -4.5786254, -4.9826244, -850.48142, -5.0141021, -26.124321, .6145684, .61269984, 172.28365, .61273633, 4.0221801, -3.0290547, -3.4019779, -93.787279, -3.4386297, -9.5115812, 3.4030858, 3.4990013, 870.1726, 3.5068227, 21.599833, -1.814412, -1.8483025, -1673.4079, -1.8487382, -17.661376, -4.9709195, -5.139411, -1528.4106, -5.1619673, -33.550925, -2.8711722, -2.8576622, -758.19886, -2.8615509, -18.420463, -1.3502232, -1.3640438, -478.67408, -1.3643946, -9.5561658, -4.3706639, -4.4505896, -1448.8143, -4.4640268, -30.248407, -3.367544, -3.3462251, -2374.7355, -3.3494443, -29.974177, -1.8700967, -1.9265107, -533.05459, -1.9276199, -12.307408, -5.8411431, -5.7888752, -6974.89, -5.8005435, -61.969456, -3.0671616, -3.3185696, -465.64228, -3.3281753, -16.362208, .33866907, .33869449, 36.748824, .33870635, 1.6153433, .00332937, .0033292, .68084286, .0033292, .01961509, -2.1948692, -2.3506102, -201.54464, -2.3551288, -9.9021502, 1.2513472, 1.2525696, 331.50739, 1.2529014, 8.0367961, .2431842, .2423829, 57.23407, .24238525, 1.5014416, 2.3344863, 2.3363314, 519.08023, 2.3387547, 14.142919, 2.9247512, 2.9590047, 454.57521, 2.965438, 15.72514, -2.0556046, -2.0645602, -122.36309, -2.0686323, -8.026198, -3.6416917, -3.8107525, -127.30076, -3.8522025, -11.907277, -2.3465563, -2.3399588, -18062.323, -2.3401837, -46.331731, 3.1328605, 3.2237462, 4682.5244, 3.2254621, 35.819599, 2.6706612, 2.6160849, 4114.3045, 2.6168714, 30.844519, 2.3338673, 2.2998076, 5737.2307, 2.300211, 31.498137, 4.7426743, 4.4878081, 2137.1449, 4.4958392, 36.36025, -2.7264016, -2.7602159, -7855.6752, -2.7609288, -38.796069, -.25073542, -.24982419, -109.74435, -.24982577, -1.9037263, -1.8471557, -1.8428066, -5142.1808, -1.8430239, -25.984725, -2.15461, -2.1580564, -8379.8765, -2.1583395, -33.883764, -3.232046, -3.2299069, -4022.416, -3.2319278, -34.76541, 4.3258916, 4.4036403, 5374.9301, 4.4089414, 46.505897, 2.3506664, 2.3436886, 8472.7811, 2.3440641, 36.041483, -3.0103866, -3.0330376, -2827.8239, -3.0350909, -29.48259, 3.8880208, 3.8515615, 20380.935, 3.8528134, 67.539901, .30206136, .30102793, 111.56376, .30103128, 2.1672275, -.47552074, -.47774865, -535.52925, -.47775487, -4.947366, -1.2969297, -1.2873699, -448.58874, -1.2876585, -9.1038917, 5.4016685, 5.4129828, 75706.187, 5.4148884, 130.23541, -3.5207455, -3.4746651, -5392.0206, -3.4767282, -40.582638, 6.437813, 6.0694683, 9426.0253, 6.0779522, 73.102984, 2.9362577, 3.0932929, 995.57798, 3.0975282, 20.474872, 4.2903354, 4.4294349, 8449.8125, 4.4332812, 53.778645, 5.1739607, 5.1278401, 217916.35, 5.1285599, 180.01638, .04642506, .04642284, 27682.162, .04642284, 3.9075241, -4.2469413, -4.4455028, -6600.8666, -4.4499328, -49.194645, 3.5858353, 3.4955032, 2596.2005, 3.4987392, 32.198796, .74407075, .74065699, 3880.9731, .74066495, 12.903961, -4.087085, -4.1499899, -22604.866, -4.1515694, -72.278605, 4.9820244, 5.2840996, 5480.4086, 5.2940433, 51.429016, -1.4564105, -1.474377, -3103.33, -1.4744978, -18.741249, 2.7224042, 2.6837853, 10471.442, 2.6842648, 42.655062, 11.319421, 10.709754, 60422.779, 10.731002, 197.82585, 3.265598, 3.5595753, 597.22517, 3.5699894, 18.53622, -.9650115, -.96312035, -2380.073, -.96315384, -13.038223, 2.164339, 2.2153405, 1004.0559, 2.2165899, 16.754681, -.56780325, -.56618426, -454.15837, -.56619838, -5.2706926, -4.3053348, -4.2507666, -30890.39, -4.252092, -83.038422, -1.0564439, -1.0620748, -1721.3294, -1.0621333, -12.431369, -2.7316132, -2.7880892, -10933.338, -2.7886254, -43.370763, -1.5756134, -1.5805061, -12197.933, -1.5805756, -31.169406, 3.4853323, 3.4765582, 18127.864, 3.4775218, 60.387216, -3.0310116, -2.9837067, -9935.8247, -2.9844447, -45.025621, 5.4190658, 5.3833057, 3745.6544, 5.3969484, 47.913605, .836042, .83757213, 275.67062, .83765787, 5.7758454, 3.1916149, 3.3119053, 1458.2745, 3.3162779, 24.582162, -.13107013, -.13101089, -163.9307, -.13101103, -1.4121774, -.02167956, -.0216849, -4.2146913, -.0216849, -.12559013, 5.7062833, 5.5425845, 17395.771, 5.5473779, 82.74024, 3.9674132, 4.0510658, 5756.4774, 4.0547538, 44.914913, 1.0082364, 1.0081202, 580.6423, 1.0082229, 8.3883747, -.1607903, -.16067812, -7.4258153, -.16068035, -.57688327, -2.1794238, -2.168514, -892.76271, -2.1697763, -16.18601, 2.4158395, 2.3602945, 63.041821, 2.3699707, 7.1656397, .88352525, .8834159, 284.48156, .8835178, 6.0556954, 1.4023926, 1.4004412, 1876.6768, 1.4005975, 15.454071, -2.6481201, -2.6598485, -739.97358, -2.6629483, -17.312662, -.04596256, -.04598842, -1.0216786, -.04598851, -.12923324, -4.8706759, -4.9160841, -1506.657, -4.9347237, -32.940558, -.14989449, -.15037145, -4.8188818, -.15037368, -.47662029, -.70456375, -.70836868, -629.50443, -.70839399, -6.7859886, -2.9238357, -3.0439268, -353.87052, -3.0525781, -14.462724, -1.3816671, -1.416089, -245.24501, -1.4166886, -7.7648965, -2.6389059, -2.6411431, -299.06009, -2.6466421, -12.770329, 1.6796181, 1.6292513, 50.990814, 1.6319631, 5.2396749, -4.6907555, -4.0071153, -50.243176, -4.0598436, -10.340008, -2.4520787, -2.4202063, -255.88275, -2.424463, -11.544362, -.56336474, -.55902069, -125.96524, -.55905011, -3.4193484, -1.5439833, -1.5530797, -3645.9363, -1.5532245, -20.560393, -.35769835, -.35628075, -66.699031, -.3562898, -2.0435462, -5.8985411, -6.0079377, -4913.6259, -6.0258256, -55.500526, 4.7314097, 4.4310616, 685.04579, 4.4478122, 24.844689, -.83919065, -.84650215, -46.818948, -.84679291, -3.2066211, -.03089159, -.03089176, -160.02828, -.03089177, -.53451397, .88361004, .88295033, 130.47124, .8831211, 4.6703062, 2.3335326, 2.3548024, 2642.7267, 2.3556438, 24.323534, 4.4071647, 4.4439502, 69380.031, 4.444919, 110.45474, 3.2787794, 3.2745315, 66934.736, 3.2748563, 89.610449, 1.6362845, 1.6715687, 384.84329, 1.6724119, 10.10029, 6.3093651, 6.3182562, 32186.911, 6.3242009, 108.61343, 3.611326, 3.6092834, 40001.62, 3.6099395, 80.501442, 5.2158338, 5.266765, 49709.38, 5.2690472, 110.58476, 2.1901909, 2.1664396, 22261.835, 2.166564, 47.443309, -.52967183, -.52891298, -6096.2169, -.5289149, -11.958904, 1.7552088, 1.7533111, 7659.1081, 1.7534507, 28.682165, 9.3002312, 9.6458876, 70515.872, 9.6628501, 182.70824, -1.6751411, -1.6596802, -2489.8995, -1.6599057, -19.117372, .15967588, .15973638, 131.71812, .1597367, 1.4975272, -6.7038594, -6.8116189, -2053.7136, -6.8628644, -45.192173, 3.2862183, 3.307876, 3814.1386, 3.3101871, 34.535289, -3.5011058, -3.4842254, -2091.8209, -3.4883111, -29.487977, -5.918473, -6.0585339, -22523.518, -6.065055, -92.402812, -5.6222517, -5.9653862, -3338.7985, -5.9887053, -47.257447, -3.5602535, -3.6713991, -1269.7128, -3.6786167, -25.247736, -.92430902, -.9254755, -10749.074, -.92548614, -20.941212, -5.2384521, -5.3357226, -29922.325, -5.3390592, -93.641227, 3.9600059, 3.9203361, 15722.094, 3.9219252, 62.704786, -6.5203802, -6.6896631, -28737.546, -6.6976513, -106.90512, -6.2106413, -6.3132951, -73040.278, -6.3167014, -141.2359, -.20342402, -.2036375, -744.52393, -.20363773, -3.134929, 3.0717208, 2.997104, 1083.974, 3.0004496, 21.706716, -2.578223, -2.5895842, -34704.883, -2.589796, -61.330595, 2.1154631, 2.0707695, 913.4727, 2.0717072, 15.989522, -4.4212059, -4.6762251, -5267.8305, -4.6824606, -46.871022, -6.0308154, -6.1288048, -22200.014, -6.1357161, -93.118315, 2.0010941, 2.0050502, 8179.9494, 2.0052698, 31.995965, -4.7215135, -4.7224521, -10299.541, -4.7268107, -61.234115, -.61478931, -.61724539, -936.8533, -.61725705, -7.0747006, -1.7242039, -1.7260096, -31850.535, -1.7260607, -45.578987, 4.2597077, 4.2708827, 15752.019, 4.2731622, 65.871661, .13878808, .13874551, 110.47553, .13874572, 1.2862443, .06198083, .0619749, 17.679469, .06197494, .40800109, -.51497256, -.5153046, -11904.695, -.51530576, -14.669956, -5.0832571, -5.0614461, -115983.47, -5.0625443, -144.17615, 4.8631068, 4.9376385, 4604.7975, 4.9466392, 47.754326, .41687368, .41579762, 354.31543, .41580291, 3.9488109, 1.5740145, 1.5668996, 233.56283, 1.5678388, 8.3331091, -1.0156158, -1.0212038, -1092.6454, -1.0212729, -10.406692, 2.7223636, 2.7077122, 1547.9597, 2.7096859, 22.553674, -1.7144195, -1.7151036, -21079.76, -1.7151695, -39.570052, -1.1877669, -1.1941703, -5141.3335, -1.1942127, -19.357357, -9.1433754, -9.5217086, -84411.705, -9.5357864, -191.8103, -2.4873675, -2.4944945, -5322.7872, -2.4951476, -32.053319, -.52446998, -.52526652, -67.958396, -.52530591, -2.6539626, 2.3976154, 2.3905626, 12988.353, 2.3908659, 42.108622, 2.1940034, 2.1651172, 9681.0591, 2.1653379, 35.98591, -6.109209, -6.0299691, -7699.0563, -6.0425009, -65.988636, 3.8079023, 3.7502112, 44419.258, 3.7508204, 86.360332, -1.8819326, -1.8918879, -6906.1083, -1.8920842, -29.027781, -5.8802911, -5.9010268, -11508.862, -5.910263, -73.554629, .3642416, .36357882, 103.13817, .36358642, 2.3918439, -.1875515, -.18754808, -248.0582, -.18754846, -2.0587245, -3.2885067, -3.3249747, -12471.058, -3.3260255, -51.282232, -3.4245938, -3.5766289, -292.02275, -3.5949103, -15.073413, 1.6999336, 1.6998475, 5830.6976, 1.6999974, 25.636662, 2.7145418, 2.692024, 7781.6473, 2.6926642, 38.561584, 2.3688876, 2.4300853, 676.72969, 2.4324331, 15.601561, 8.4394979, 8.3138999, 61224.725, 8.3239664, 163.37541, 4.634536, 4.6071471, 7022.4616, 4.6122045, 53.231327, .9590249, .97735056, 38.64247, .97790484, 3.2878214, -2.041165, -2.0676384, -416.51119, -2.0694518, -12.016951, 7.3712772, 7.5493285, 83124.524, 7.5553493, 165.29951, 1.0943632, 1.095498, 1564.5913, 1.0955701, 12.328435, 15.712534, 15.419989, 1246536, 15.432621, 675.14817, .75482542, .7538249, 6187.394, .75383208, 15.219496, 1.5411183, 1.5461771, 2717.0765, 1.5463534, 18.617639, .05192873, .05191976, 257.80525, .05191977, .88586806, 6.9659606, 6.7887171, 14554.668, 6.8007292, 89.054275, -1.3180532, -1.3173208, -35718.803, -1.3173384, -39.59019, 3.1417625, 3.1357097, 1099.7541, 3.140007, 22.14186, -2.2540263, -2.2575945, -4491.5963, -2.2581012, -28.364354, -3.6364072, -3.6980171, -1193.2561, -3.7057156, -25.08185, -8.9597209, -9.0798549, -92417.588, -9.0911537, -195.03589, 1.3128072, 1.3119967, 6846.1057, 1.3120487, 22.765744, 5.0951244, 5.2515277, 1418.9377, 5.277164, 33.272924, -6.6168923, -6.7651375, -71965.581, -6.7695384, -146.60349, 1.4743967, 1.4749183, 3777.6522, 1.4750374, 20.175155, .88203319, .88612343, 873.71372, .88617114, 8.7925127, 10.232282, 10.227907, 24708.303, 10.269468, 137.27643, 2.4994204, 2.522306, 4996.1112, 2.52301, 31.484991, -.33601015, -.33565892, -94.016495, -.33566501, -2.1977061, 1.2014409, 1.201799, 1306.5399, 1.2019131, 12.354993, -.1917435, -.19167108, -12.795383, -.19167405, -.7777348, -1.1541729, -1.1510202, -841.79482, -1.1511491, -10.389213, -3.3155305, -3.322033, -7755.1242, -3.3234863, -44.011375, 1.638263, 1.6289084, 699.83365, 1.6294247, 12.338263, -2.3074323, -2.3163968, -5852.6398, -2.3168634, -31.468056, -2.9464432, -2.9898088, -4559.9816, -2.9912043, -34.081582, .64340142, .64392566, 1516.8902, .64393612, 8.5632652, 1.8216221, 1.8737544, 1093.3062, 1.8743269, 15.365716, -4.1484683, -4.1550817, -54011.578, -4.1559855, -97.59348, -2.0098146, -2.0067011, -6797.1668, -2.0069487, -30.168008, -3.0886434, -3.0641784, -6766.3444, -3.0653206, -40.114053, 3.1034238, 3.0604395, 12317.888, 3.0611532, 49.136717, -4.2798863, -4.165237, -2660.4643, -4.1713732, -36.526436, -2.7642694, -2.7673322, -601.62921, -2.7714243, -16.627612, -4.1354083, -4.150768, -3169.2294, -4.1567748, -37.843982, 2.085076, 2.110033, 337.53611, 2.1122867, 11.363741, 4.0312289, 4.1372091, 3906.6743, 4.1424073, 39.892756, -.2784614, -.27871515, -124.55464, -.27871771, -2.1295931, .91847241, .91775794, 6536.0012, .91777237, 17.666402, -6.5936505, -6.4164512, -4117.1251, -6.4394331, -56.3571, -3.7873428, -3.7775824, -15933.885, -3.7790071, -61.140686, -3.1255338, -3.1497479, -17261.446, -3.1504428, -55.246977, -.88895885, -.88950053, -146.0698, -.88966377, -4.8690165, 2.8107448, 2.8179615, 2663.2443, 2.8195846, 27.606919, -3.4316528, -3.4093229, -6258.9413, -3.4111217, -41.927843, .32348352, .32327145, 142.66038, .32327548, 2.4622713, 2.4586408, 2.4836465, 1053.3637, 2.4855562, 18.534868, -2.0863466, -2.1097879, -3798.3528, -2.1102179, -25.475501, 1.347211, 1.3375771, 207.73027, 1.3381379, 7.2242097, 1.2748403, 1.2586908, 390.71981, 1.2589676, 8.5952597, 4.663177, 4.6237577, 10949.742, 4.6275274, 61.980617, -1.0236763, -1.0387965, -129.94316, -1.0390997, -5.1446941, .65592571, .64964267, 88.122068, .64970828, 3.3594228, -2.8938186, -2.9083096, -7662.4106, -2.9092097, -40.034648, -.69787881, -.70020831, -245.99605, -.70025591, -4.929801, .91412968, .90636729, 27.986161, .90687785, 2.8596946, -.23737615, -.2370982, -8.2266245, -.23710685, -.77392452, 9.7240867, 8.4710294, 1709.1431, 8.5511321, 54.470164, 5.1143944, 4.797313, 1780.4902, 4.8086774, 35.978469, -1.3933966, -1.4279007, -342.37443, -1.428383, -8.7273744, -6.1643948, -6.2380461, -53226.802, -6.2421242, -126.46502, -1.1072716, -1.133251, -137.57627, -1.1336345, -5.5252331, 2.9131647, 2.6591858, 117.336, 2.6660231, 9.9858979, -.703409, -.69788492, -30.466814, -.69806848, -2.4702882, -1.3796104, -1.4028155, -502.94299, -1.4031774, -9.8554675, 3.4481209, 3.4947658, 2211.4348, 3.4988676, 29.735805, -5.1424068, -5.0932624, -28852.779, -5.0960527, -91.377689, 1.1658373, 1.1641565, 5674.2865, 1.1641943, 19.757366, 7.2585799, 7.4634011, 40841.836, 7.4728428, 129.10296, -.29489292, -.29380271, -90.475766, -.2938062, -1.9889338, 2.1286688, 2.1307039, 3118.6032, 2.1312262, 24.176426, 6.4743187, 6.7041785, 10245.251, 6.7206537, 75.44612, -.18655471, -.1872321, -8.1187575, -.18723562, -.65619663, -1.7840986, -1.807568, -1161.9624, -1.8081095, -15.464763, -3.9600761, -4.0954915, -885.68765, -4.109497, -24.037865, -2.3068248, -2.3243811, -3915.5288, -2.3249968, -27.517346, -7.0204058, -7.1839731, -15774.818, -7.1997808, -91.952371, 3.1544948, 3.0861172, 655.79074, 3.091473, 18.687088]  # noqa:E501

star98_resids = np.array(star98).astype(float).reshape(-1, 5)

invgauss = [.21946682, .19838235, -.13116093, .19804544, .2329114, -.68724239, -1.20786, .29727304, -1.1461406, -.6548399, -.02508381, -.02537231, .00493116, -.02537176, -.01837619, .13333854, .12526482, -.06542915, .12518341, .13250661, -.1828634, -.20290189, .11601121, -.20253671, -.19796778, -.18576541, -.20700925, .14184774, -.20660529, -.21392459, -.01680541, -.01694517, .00684574, -.01694497, -.01569578, .01580889, .01566406, -.0337669, .01566384, .02565121, .40499508, .3419356, -.19304143, .3403085, .39859025, .04500324, .04404018, -.01918807, .04403675, .04267593, -.35003226, -.43573938, .19717053, -.43227509, -.36421909, -.44886321, -.59409509, .14983417, -.58638517, -.3923042, .35983219, .3103634, -.12058593, .30923487, .3149021, .61634589, .48829837, -.21846474, .48391242, .54956633, -.19586429, -.21798637, .08445516, -.21757089, -.18643276, -.67768345, -1.0811333, .12589839, -1.0427999, -.4871933, -.43106322, -.55561146, .10528459, -.54969041, -.3394889, .27120489, .24173716, -.08854081, .24120493, .23528243, -.05090118, -.0522168, .02073681, -.05221113, -.04754183, .38145175, .32775094, -.09872406, .32649672, .30627443, -.06122628, -.06313667, .02402832, -.06312674, -.05647762, -.27729954, -.32438509, .10631392, -.3230591, -.25380849, -.17498754, -.19254711, .083475, -.19225397, -.17226626, -.04475333, -.04570496, .01064837, -.04570159, -.03493987, 2.1079261, 1.2436278, -.36382129, 1.1877369, 1.4786871, -.59050542, -.85032246, .09040464, -.83176757, -.3980059, -.27481622, -.32238792, .13093539, -.32102242, -.27043148, -.32072485, -.38688683, .12794677, -.38462801, -.29746887, -.49304951, -.6674332, .11797934, -.65734004, -.38566096, .06418319, .06232442, -.01895976, .06231545, .05385613, -.15233039, -.16429293, .03637778, -.16413654, -.11907294, .14306921, .13431256, -.04142349, .1342233, .11924944, .50771239, .41922154, -.11900574, .41666974, .39440688, -.33686723, -.4055089, .07946929, -.40319374, -.26225008, -.12603683, -.13365709, .01972519, -.13358036, -.08557535, -.28690375, -.33635948, .09007555, -.3349458, -.24568, -.38061163, -.49506721, .36307402, -.48940939, -.47205916, -.61802926, -.99345317, .28705958, -.95710777, -.60303156, .33500504, .29312132, -.0745651, .29225169, .25579345, .09993473, .09567799, -.02142368, .09564778, .0753562, -.77390406, -1.5092293, .24944552, -1.4025957, -.66853885, -.56372333, -.81484888, .13961703, -.79670113, -.4460328, -.58464894, -.89675035, .25143829, -.86997468, -.55601168, -.79699816, -1.5367111, .18308007, -1.4316205, -.61498129, 1.2612303, .8616029, -.25955307, .84110028, .93817023, .16274853, .15026277, -.14167113, .15010333, .19578609, -.43961546, -.5730583, .12125264, -.56640134, -.36054187, .11414296, .10838846, -.03769438, .10834013, .09940349, .234557, .21059654, -.14686052, .21018955, .25281953, -.58416576, -.89122107, .23552975, -.86525941, -.5437292, .25647739, .23192464, -.03632729, .23153369, .1684433, -.45074863, -.58662315, .09520965, -.57989069, -.33821532, .19326576, .17842124, -.03625637, .17823145, .13939313, .56053862, .45568773, -.12652518, .45244681, .43000418, -.19469865, -.21453127, .03993593, -.2141952, -.14466825, -.19716704, -.21788899, .04601467, -.21752674, -.15294373, -.43999815, -.58606522, .20411479, -.57811493, -.42914302, .01566139, .01554434, -.00569429, .01554419, .01408348, -.2383123, -.26955511, .05428065, -.26887452, -.18336762, -.64722983, -.99421314, .113679, -.96432537, -.45667696, -.19029977, -.21185782, .10882145, -.21145172, -.19900944, .52360533, .42760203, -.17110953, .42469226, .45439907, .53511334, .43209168, -.26125299, .42881606, .53087744, .06765918, .06581012, -.00721243, .0658017, .04041926, -.33830509, -.4080903, .08346023, -.40570789, -.26732662, .25358176, .2261832, -.14274032, .2256911, .26379764, .64897923, .50000076, -.52550319, .49437774, .76211817, -.40741312, -.51148167, .07673901, -.50709672, -.2942425, -.36424337, -.45859178, .20539539, -.45456159, -.37914151, .03219191, .03166734, -.02244757, .03166592, .03596645, .09131316, .08775474, -.01880635, .08773163, .06794128, .09544249, .09147182, -.02468448, .0914443, .07661477, -.26565384, -.30975165, .12756023, -.30853737, -.26209526, -.67698377, -1.2354946, .45589181, -1.1640047, -.74762319, -.5849103, -.89192114, .2316015, -.86599792, -.54114872, -.41648676, -.52673306, .08059767, -.52192252, -.30351836, .60186248, .4774551, -.247836, .47321483, .56415222, -.48771891, -.68555533, .27302358, -.67248587, -.5064343, -.23870823, -.27432787, .13922256, -.27344544, -.25128012, -.46352127, -.61110291, .10542772, -.60338992, -.3564851, -.15315845, -.16768992, .15638745, -.16746051, -.19431423, -.11028172, -.11661361, .03746978, -.11655305, -.09695557, -.09766739, -.10260147, .03416514, -.10255995, -.08670367, -.25865969, -.3031103, .20195439, -.30184354, -.30008683, -.29530742, -.35636228, .25145118, -.35427322, -.3526502, -.43655156, -.59436743, .35324208, -.58503774, -.51253616, -.0260924, -.02641737, .00727071, -.0264167, -.02147229, -.68007447, -1.2304932, .41095371, -1.1612362, -.72440028, -.55540409, -.806563, .16968559, -.78815111, -.47130029, .08496324, .08153547, -.0466319, .08151243, .08764458, .25291318, .2275826, -.06526919, .22716071, .20287431, -.3459101, -.43509049, .30138239, -.43129855, -.41625371, -.17190125, -.1890793, .09316763, -.18879372, -.17658387, -.20852324, -.23414686, .09714721, -.23362349, -.20366813, .59134795, .48223124, -.06984852, .47890327, .36555927, -.25589175, -.30711218, .63498647, -.30541476, -.43648469, -.03186028, -.03232117, .005511, -.03232006, -.02236591, -.25594521, -.28948219, .03054559, -.28875201, -.158766, -.51359911, -.70176826, .10370339, -.69049933, -.37962706, .19992662, .18358969, -.05191884, .18336752, .16070599, -.03252799, -.03304344, .01041198, -.03304208, -.02803448, .87784986, .65610395, -.17025957, .64692494, .6402172, .25557659, .22823559, -.12059263, .22774936, .25068651, -.31197284, -.37536793, .1441638, -.37323551, -.30388314, -.49409432, -.69358795, .24006401, -.68046772, -.48939432, .29230454, .26153551, -.03469097, .26099704, .18098358, -.43107557, -.55170049, .08647818, -.54614283, -.31794191, 1.1243036, .79861683, -.16621181, .78325509, .74900784, .94243785, .66779165, -.7453546, .6547638, 1.098077, -.00547659, -.00548998, .0009586, -.00548998, -.00385978, -.48125962, -.64802831, .12750168, -.63856528, -.38943494, .08075752, .07765921, -.04328822, .0776394, .08265236, -.01733649, -.01747477, .003682, -.01747458, -.01303203, .37106276, .31699846, -.18163582, .31569208, .36844733, .08082038, .0777816, -.03548928, .07776256, .0773968, .04414503, .04321061, -.02021886, .04320732, .04287296, .29116544, .25845228, -.07178838, .25784145, .23003183, .28895977, .2544519, -.1475, .25376729, .29095931, -.17460846, -.18979305, .02755812, -.18957327, -.11888764, -.2784603, -.3217463, .05463276, -.32062952, -.20386214, -.48120414, -.65896058, .18281081, -.64823028, -.43910009, .43919416, .36448122, -.28435028, .3623776, .47870238, .29138147, .25700789, -.12079888, .25633418, .27374041, -.62673306, -1.0166031, .28405348, -.9780172, -.6065479, -.38350618, -.48318203, .13895444, -.47891006, -.34446813, -.15554825, -.16871708, .05613268, -.16853152, -.13952714, -.5004515, -.69034345, .15487883, -.67857984, -.42649638, .01693351, .01677943, -.01832247, .0167792, .02190295, -.2479185, -.28563098, .1182882, -.28467869, -.24407863, 2.2482611, 1.2402532, -1.3060192, 1.1700227, 2.3635113, .20602966, .18306043, -1.0509977, .18263483, .44685205, .58486763, .47239982, -.12643067, .46882798, .44224799, -.22978171, -.26822207, .43025548, -.2671554, -.35683089, -.04893299, -.05008781, .01291673, -.05008327, -.03954838, -.31992822, -.38629891, .13558557, -.38402033, -.30277234, .23281539, .21056172, -.07755681, .21020792, .20334075, -.40389696, -.50231576, .06081306, -.49835653, -.27072146, -.4149099, -.53505755, .14485935, -.52933329, -.36809624, -.19484302, -.21478077, .04112692, -.21444139, -.14616452, -.59354453, -.92007961, .2558687, -.89126164, -.56491693, -.22649251, -.25446097, .05203575, -.25388691, -.17477522, .11308923, .10712155, -.06333083, .1070691, .11744356, 2.1570618, 1.2739476, -.29396154, 1.2169135, 1.3985625, -.36661502, -.45229019, .100595, -.44898252, -.30015274, -.13090653, -.14049298, .06964604, -.14037609, -.13364407, 1.034831, .73728361, -.28908361, .72334743, .85230971, .01234337, .01225937, -.01630469, .01225927, .01706357, -.02041978, -.02062125, .00657333, -.02062092, -.01763217, .25698133, .23093649, -.06508868, .23049756, .20485482, -.18856169, -.21000433, .12057066, -.20959888, -.20467251, -.61349066, -.96438489, .23401299, -.93226802, -.56056842, -.13403576, -.14335573, .03787054, -.14324782, -.11081307, -.28087233, -.32981483, .11523373, -.32840075, -.26295161, -.22715035, -.25568596, .0578659, -.25509017, -.18142335, -.10101297, -.10622081, .03092045, -.10617609, -.08577157, -.54132787, -.75073436, .09183236, -.73751806, -.37755669, 2.2315997, 1.2410837, -1.1229495, 1.1726349, 2.236356, -.25446228, -.29017245, .05324106, -.28934008, -.19033026, 1.3392881, .8691534, -.84530931, .84265167, 1.447431, -.14885417, -.16179664, .098637, -.16160935, -.16350484, -.181369, -.19915316, .05233794, -.19886303, -.15100486, -.31967023, -.39613132, .35022326, -.3931111, -.41520234, -.24715716, -.28116998, .05816391, -.28039245, -.19225457, 1.4170507, .91116127, -.71593757, .88220543, 1.421975, -.07102628, -.07327601, .00833581, -.07326414, -.04381323, .09590878, .09172196, -.03769426, .09169151, .08851306, -.39687496, -.49270953, .06599145, -.48888849, -.27496348, .03874853, .03795295, -.04323879, .03795023, .05063739, -.44362887, -.57774381, .11003445, -.57107979, -.35118241, -.37567437, -.4721807, .15220406, -.46809172, -.3502352, -.80446806, -1.7538868, .34012519, -1.5881386, -.76072695, -.31456215, -.37615399, .10474692, -.37415682, -.27470173, 1.4262995, .92384058, -.54235857, .89542537, 1.3019051, -.07533168, -.07813108, .02041389, -.07811374, -.06141913, -.25107743, -.28541588, .04897872, -.28463574, -.18346403, -.23182627, -.25881558, .02763425, -.25829316, -.14374773, -.55699071, -.79988016, .13780416, -.7826818, -.44055089, -.60340691, -.87652356, .08783114, -.85648447, -.39991377, -.59608332, -.88509811, .13627737, -.86245829, -.45922187, .16977873, .1570718, -.0786399, .15691349, .16550578, -.42714799, -.58248304, .4346435, -.57324717, -.54130243, -.07064828, -.07297453, .01213357, -.07296177, -.04947745, -.45992196, -.62723585, .2410807, -.61728428, -.46721873, .63399242, .50020189, -.21266542, .49554878, .55500684, -.5474725, -.83875274, .41875875, -.81384186, -.63082104, -.73538742, -1.3490981, .24474851, -1.269732, -.6420874, -.16915226, -.18683668, .15054797, -.18652915, -.20499983, -.46165077, -.62756406, .21855899, -.61781118, -.45332389, -.2516681, -.29165745, .14377037, -.29060301, -.26309863, 1.1349967, .77223199, -.69151736, .75346989, 1.2122925, -.07717557, -.08009098, .01934847, -.08007263, -.06131199, -.19818136, -.22060833, .07801391, -.22018631, -.18299641, .94335083, .66547504, -.86786046, .65216005, 1.1559582, 1.2301549, .84702958, -.24236003, .82768642, .90185533, -.52846413, -.74437682, .14929506, -.73001422, -.4368867, .00926399, .00922251, -.00363285, .00922248, .00854328, -.2320652, -.26378555, .09157412, -.26306529, -.21445734, -.61930279, -.98844461, .26019757, -.95333125, -.58440389, -.29300103, -.34646666, .11354046, -.34484973, -.26913673, -.63014989, -1.0083751, .23337426, -.97216438, -.57015144, .20438505, .18552944, -.15192759, .18524006, .2332679, .21299143, .19454797, -.0567153, .19428223, .172644, .32055523, .28060605, -.10244481, .27977921, .2761268, .35875689, .30637082, -.24389494, .30510224, .39744566, -.04853752, -.04991749, .06914812, -.04991095, -.06881057, -.01334856, -.01343572, .0050181, -.01343563, -.01213797, -.14104088, -.15198247, .06106202, -.15184115, -.13443027, 1.2296562, .8493208, -.21855297, .83024186, .87106662, -.0963121, -.10139637, .05513227, -.10135166, -.10075483, -.62115306, -.91519607, .08714316, -.89268037, -.40664945, .14955772, .14007855, -.04106003, .1399785, .12246791, .11541852, .10981708, -.02383052, .1097718, .08594847, -.30922027, -.36994709, .12261091, -.36797216, -.28621892, -.22920988, -.26126886, .11985453, -.26052408, -.23265749, -.4513332, -.58769819, .09554269, -.58092621, -.3389019, .47641919, .39138423, -.26324856, .38887407, .4925589, .89197557, .65519863, -.29946105, .64492007, .78107383, 1.8294421, 1.1029936, -.61660499, 1.0572978, 1.6040754, -.05912358, -.06104126, .04432384, -.06103089, -.06767002, .89695457, .66603428, -.18647887, .65629947, .66947368, -.54183869, -.81568954, .35721411, -.79337711, -.5941547, -.51559503, -.75180669, .3284956, -.7342743, -.55897493, .80389009, .6029852, -.29722955, .5947539, .72695095, -.15169744, -.16470762, .07603953, -.16452191, -.15182454, -.03221923, -.03273869, .01307928, -.0327373, -.03005717, .38336443, .32796541, -.12744674, .32663763, .33460117, -.34412063, -.41857653, .10036856, -.41591208, -.28752991, -.42144896, -.54963099, .17197579, -.54322411, -.39384841, -.39443481, -.5054271, .18219352, -.50028514, -.38415321, .55944951, .45919047, -.07643799, .45621914, .36303934, 1.500497, .95328728, -.65308846, .92136018, 1.4327071, -.08420238, -.08775548, .02464356, -.0877305, -.0704359, 1.187384, .80804761, -.4785498, .78843669, 1.1050447, -.00053604, -.00053618, .00021674, -.00053618, -.00049941, .74469897, .5666345, -.30080407, .5596433, .6935723, -.62972476, -1.0104427, .24209007, -.9737469, -.57690306, -.41289899, -.56940561, .71719622, -.55972, -.62534336, -.23785253, -.26611685, .02630208, -.26555848, -.14383962, -.25942357, -.29728791, .0608765, -.29637023, -.20160416, .77751978, .5882403, -.27139008, .58067893, .68973503, .50988209, .41425932, -.27861761, .41129613, .52520158, .47834714, .39842639, -.11605974, .39621571, .37589451, -.31169033, -.36764786, .06178849, -.36598262, -.22897852, -.50561712, -.71680521, .23888637, -.70245612, -.49615987, .07689107, .07409474, -.03850472, .0740778, .07693051, -.68130941, -1.198946, .32210533, -1.1374172, -.66871166, -.37679723, -.48160687, .24461181, -.47680598, -.41106226, -.05865463, -.06050934, .0379785, -.06049957, -.06393286, -.10330301, -.10876277, .0317849, -.1087147, -.08786695, -.02583652, -.02617324, .01174462, -.02617251, -.02502912, -.34649878, -.43728814, .32933222, -.43336602, -.42922916, -.04844241, -.04961063, .01689242, -.04960594, -.04295936, .47898364, .38890618, -.47525159, .38610723, .60191011, -.22712013, -.2526591, .02497461, -.25218155, -.13709239, 1.2311459, .82439862, -.61134541, .80270725, 1.228321, .55495383, .45373311, -.10086472, .45068091, .39606001, .0672676, .06540267, -.00864428, .06539406, .04276846, -.29326405, -.34657704, .1098119, -.34497071, -.26631708, -.64305896, -1.0798608, .33211549, -1.0329773, -.65004023, .95204054, .69087213, -.28404316, .67917358, .80150901, -.01583657, -.01596697, .01008165, -.01596679, -.01716437, -.17308181, -.19085442, .10896987, -.19055084, -.18690163, .23851663, .21641591, -.04621634, .21607525, .17389522, -.24236265, -.27736187, .09702571, -.27652257, -.22505193, -.32758453, -.39962436, .16585724, -.39700471, -.32895543, -.10080331, -.1064483, .06253581, -.10639565, -.10831853, -.57352885, -.8450014, .16488262, -.82421587, -.47691224, -.39773343, -.49071245, .05253993, -.48712159, -.25521208, .91120002, .66483476, -.32773333, .65395074, .81644327, 1.7449753, 1.0830833, -.39014084, 1.0430876, 1.3343712, -.45729182, -.60007962, .10469619, -.59275748, -.35246493, -.29580673, -.35005361, .10891897, -.34840495, -.26712624, -.31002337, -.37474369, .18190652, -.37250797, -.32700599, .18654161, .16983522, -.23194817, .1695863, .25273038, .91688764, .68605732, -.11477754, .67653306, .57788273, -.01737575, -.01751493, .00375574, -.01751474, -.01313825, -.33514683, -.40624829, .1086914, -.40375278, -.29011163, .05586841, .05451575, -.01074254, .05451029, .04062779, -.30097629, -.37288715, .56313912, -.37004973, -.46727236, -.06435532, -.06635487, .01555102, -.06634452, -.05050324, 1.683168, 1.047478, -.48188034, 1.0092125, 1.397681, -.51668519, -.69861335, .07909412, -.68812903, -.3482374, -.3657535, -.45711543, .15771009, -.45334944, -.34814125, -.48537817, -.62511791, .03986077, -.61849789, -.26581452, .00862779, .0085919, -.00329303, .00859188, .00788512, -.09503767, -.09982766, .04167813, -.09978744, -.09097246, .34723869, .2989993, -.18031461, .29788735, .35164602, -.46695991, -.61665162, .10343267, -.60877636, -.35597184, -.6871968, -1.1533617, .19424251, -1.1033873, -.56821432, -.46411708, -.65869919, .4833767, -.64543078, -.59273004, .70606231, .53756757, -.4486713, .53096464, .76480042, -.1556854, -.16978277, .09499918, -.16957033, -.16637263, -.66226392, -1.106026, .24847245, -1.0589874, -.60180641, -.23801501, -.2678183, .03885581, -.26719805, -.16389469, .04557001, .04440477, -.09133413, .04439981, .07238921, -.13911314, -.15088159, .13631851, -.15071588, -.17408996, 1.4387663, .91624473, -.85058109, .88587159, 1.5213953, -.43092071, -.57464196, .247748, -.56678388, -.45145205, .5834262, .47102589, -.13195491, .46744966, .4478602, -.8064445, -1.732115, .31001814, -1.5742397, -.73879173, -.05975525, -.06163017, .03062133, -.06162037, -.060247, .71311673, .54503254, -.35108538, .53852405, .70944924, -.28330589, -.33648226, .18082704, -.33482854, -.30732757, 2.9488587, 1.4905628, -1.324286, 1.3809095, 2.8451592, .34215535, .29829967, -.08280641, .29736632, .2686459, -.71592919, -1.2115151, .15170411, -1.1573919, -.53776083, .26341899, .23734718, -.04160406, .23691803, .17939897, -.05988568, -.06166873, .01917075, -.06165989, -.0516145, .16575998, .15401103, -.05504816, .15387239, .14462523, -.2465342, -.28298038, .10048665, -.28208579, -.23030193, .12586652, .1184744, -.07679535, .11840209, .13450191, .43413164, .3614944, -.25643955, .35948236, .45893653, -.52625753, -.75904535, .23348343, -.74233574, -.50570149, -.14582805, -.15667334, .0332696, -.15653905, -.11226729, -.22907482, -.26222842, .15482408, -.26143162, -.25328399, 1.7668508, 1.06039, -.92693076, 1.0156843, 1.7953909, -.38041178, -.48183652, .17407242, -.47737956, -.36933683, .34341296, .29508741, -.22770138, .29395921, .37729091, -.61407417, -1.0983528, .84764951, -1.0388203, -.8614485, -.2614967, -.30345824, .1135654, -.30234096, -.24949939, .34180776, .30303645, -.02205434, .3023056, .17272796, -.21350013, -.23815688, .05022845, -.23768342, -.16605757, -.59242453, -.9486729, .38552786, -.91450675, -.64682074, .00673239, .00671055, -.00252798, .00671053, .00611947, -.18127834, -.20054203, .09815037, -.20020155, -.18615353, -.34896946, -.42871336, .12887359, -.42570187, -.31544448, .08732154, .08409452, -.01621272, .08407465, .06276385, .6832916, .53295434, -.19975321, .52750902, .57136282, .9849395, .70606212, -.34240244, .6931893, .87256004, .30984234, .27086184, -.14914363, .27004744, .30594175, -.48199152, -.65029366, .1315505, -.64067268, -.39391311, -.02940279, -.0297881, .00438273, -.02978726, -.01964191, 1.2810312, .87739896, -.20992257, .85679861, .88322127, .40334006, .33972436, -.23154519, .3380619, .42234708, .33373729, .29244946, -.06847789, .29160111, .24800662, .85773527, .62214992, -.66591624, .61158506, .99323507, -.27468661, -.32545858, .20809911, -.32390347, -.31549446, 1.098823, .76927863, -.33563801, .75321846, .93236407, -.12836792, -.13758065, .06917673, -.13747056, -.13161367, -.58997764, -.87334667, .14130656, -.85134695, -.46162339, -.25807961, -.29852855, .10648919, -.29747642, -.24207372, -.07161748, -.07431661, .03448991, -.07429966, -.07072724, -.68686562, -1.1449784, .18213472, -1.0966257, -.55597521, 1.0381346, .73468237, -.35969612, .7202469, .91866611, -.35002969, -.43067728, .13277318, -.42760686, -.31923956, -.09843121, -.10336873, .03025306, -.10332747, -.08369284, -.2136089, -.24242867, .16133335, -.24178269, -.24509302, -.14422786, -.15540111, .05049805, -.15525701, -.12807596, -.23448965, -.26958699, .16418619, -.26871486, -.26234412, -.43457455, -.57663471, .20609226, -.56901747, -.42697923, .08298978, .07996368, -.02144022, .0799453, .06659416, -.39977868, -.50144619, .08679864, -.49718097, -.30273367, -.13581469, -.14577451, .05247304, -.1456529, -.12462922, -.64910803, -1.1625603, .54974883, -1.0992702, -.77376561, -.62123103, -1.0200733, .34793076, -.97942937, -.64517327, -.29854263, -.3501201, .06657682, -.34864249, -.22809823, -.47160741, -.64448325, .20578781, -.6341249, -.45068208, .20952869, .1925899, -.03197042, .192362, .14106582, -.23112507, -.27006012, .43147481, -.26897224, -.35855836, .20444175, .18740119, -.05319557, .18716482, .16444281, -.20074735, -.22195347, .04144814, -.22158087, -.14948981, -.24836117, -.2923441, .3454659, -.2910528, -.34930183, .60977539, .48693719, -.16141134, .4828544, .49328882, .03950956, .03876269, -.01720066, .03876034, .03772766, 1.0726371, .75963628, -.26993955, .74477062, .85323247, -.32400804, -.39286452, .14409017, -.39044371, -.31159607, .00748171, .00745607, -.00178383, .00745605, .00584514, -.22912932, -.26145243, .12801995, -.26069511, -.2377696, -.24334288, -.27329276, .02858448, -.27268006, -.15015249, .98857169, .70159971, -.47998489, .68803709, .97894426, -.256986, -.29198901, .0394474, -.29119699, -.17336275, 1.1512684, .79469328, -.37803586, .77678348, 1.0007034, 1.3369505, .9007234, -.258813, .87772621, .9744261, -.03528889, -.03584243, .00496118, -.03584098, -.02311871, -.51846139, -.75303337, .29505226, -.73582911, -.54131982, -.36417282, -.44940308, .10714898, -.44610779, -.30517178, .43107619, .36539202, -.09131403, .36373302, .32376149, -.66455363, -1.036643, .11220702, -1.0032585, -.46277515, -.43139516, -.56290179, .14466203, -.55631411, -.37761134, -.0166183, -.01675004, .00489267, -.01674987, -.01392888, -.20746924, -.23084471, .05229881, -.23040676, -.16512383, .17001751, .15829983, -.03393058, .15816537, .12518036, -.40028781, -.48875604, .03449272, -.48552314, -.22275837, -.28769553, -.33586097, .07163674, -.33452343, -.22803981, .01172257, .01166066, -.00246261, .01166061, .00877992, -.16326594, -.17786135, .05868567, -.1776442, -.14625737, -.13097163, -.14039217, .05998306, -.14027934, -.12719529, -.05808555, -.0596823, .01229087, -.05967498, -.04360968, -.37410184, -.47392831, .20004904, -.46953796, -.38257394, -.34349912, -.42429369, .17668618, -.4211545, -.34675916, -.01492567, -.01503391, .00523041, -.01503377, -.01325799, .29068996, .25753057, -.08563828, .25690199, .24369839, -.332227, -.40395491, .13108667, -.40139353, -.30701019, -.40595735, -.51559944, .11220129, -.51072004, -.33316769, -.61518924, -.9272341, .13160628, -.90172302, -.46356221, .14075706, .13276657, -.0224764, .13269102, .09621269, -.48528515, -.67101151, .20765385, -.65941019, -.46073866, -.05503443, -.05643122, .00948432, -.05642531, -.03858647, 1.750071, 1.0774354, -.48320668, 1.0363146, 1.4357917, 1.4174127, .91338448, -.6681414, .88463772, 1.3898364, -.38540542, -.48559742, .13375997, -.48130239, -.34124314, -.56868899, -.78925933, .06278987, -.77530311, -.34373446, .34710641, .29833116, -.20567282, .29719408, .36731956, .07638697, .07404525, -.00804917, .07403329, .04545761, -.56149623, -.87177074, .40701726, -.84427383, -.63549505, -.24999416, -.28689392, .08886123, -.2859896, -.22311769, -.23430048, -.26493238, .06090427, -.26426693, -.18839731, .78760525, .61138863, -.07971736, .60490119, .46245203, -.29943973, -.35798383, .1537833, -.35608827, -.30212454, 1.5718706, .99354646, -.52506383, .95953593, 1.3741218, -.10596756, -.11224654, .06689919, -.11218458, -.11453342, -.54909035, -.76884924, .09845905, -.75451782, -.39011359, -.32609736, -.39539043, .1367698, -.39295453, -.30754235, -.15012378, -.1619647, .04234255, -.16180922, -.12404197, -.39565971, -.50809383, .18877217, -.50283487, -.38952668, -.57553404, -.86613075, .21942925, -.84247579, -.52580193, .12683929, .1198912, -.03643842, .11982781, .10544655, .02270402, .022484, -.00311723, .02248365, .01475712, -.24123189, -.27379475, .0612082, -.2730645, -.19241386, .21800662, .19905626, -.04898011, .19878217, .16697946, -.60306868, -.92619133, .19955451, -.89837386, -.52554314, .41430026, .35401909, -.07404215, .35256447, .29402199, -.13443697, -.14357866, .03083635, -.14347514, -.10368362, .14783533, .13784002, -.08570558, .1377275, .15530968, -.29406624, -.35009529, .14884304, -.34832685, -.29526793, -.57288525, -.86310269, .23129864, -.83940462, -.53347342, .50213207, .4154233, -.11637213, .41294565, .38860194, .63428636, .49900067, -.24276877, .49424647, .58022689, .08921615, .085661, -.02803146, .08563739, .07641657, -.58928721, -.91068237, .26052254, -.8825479, -.56560049, .04359302, .04262897, -.03360468, .04262541, .05036025, -.19631908, -.21918695, .10491377, -.21874408, -.2007224, .2626382, .23384393, -.12598651, .23331921, .25903391, -.03942293, -.04011796, .00570469, -.04011591, -.02607673, .02482358, .02453316, -.00854861, .02453259, .02192224, .25193872, .22580348, -.09755285, .2253527, .23135911, -.48866528, -.68518697, .25676136, -.67231132, -.49681444, -.37802814, -.47936239, .18933894, -.4748858, -.3782446, -.34102701, -.4160608, .12063284, -.41333092, -.30387224, 1.7724731, 1.034292, -1.968235, .98591764, 2.3125373, -.36586314, -.44618456, .06774468, -.44326864, -.26273273, .12187065, .11574187, -.02178408, .11569052, .08649463, -.31911072, -.37837669, .0648449, -.37655279, -.23637209, -.27682526, -.3188125, .04792746, -.31775533, -.19439061, -.64054568, -1.0224526, .1989004, -.98611584, -.54649805, .03933659, .03869117, -.00481294, .0386894, .02460431, -.33307454, -.40186308, .09530847, -.39951192, -.27653373, .09703165, .0931105, -.01637223, .0930841, .06755459, .8318686, .61155395, -.50656838, .602011, .88836719, -.21584148, -.24218836, .07010333, -.24165377, -.18693021, -.4291746, -.58532861, .4197218, -.57603933, -.53672668, .69636682, .54924672, -.10184715, .54412435, .4622586, -.001548, -.00154914, .00048186, -.00154914, -.00132179, -.08304844, -.08639793, .01876542, -.08637542, -.06373095, -.35078789, -.43258938, .14120095, -.42943789, -.32632644, .06817824, .06586494, -.05215659, .06585186, .07856159, -.13281122, -.14139016, .02233949, -.14129787, -.09236858, -.63619981, -1.0325971, .25367231, -.99330654, -.58997015, -.42647757, -.55722192, .16400666, -.55063623, -.39074607, -.51893985, -.73844766, .2072769, -.72335158, -.48150963, -.16373659, -.17750708, .03532237, -.17731432, -.12372489, .54251637, .43383208, -.38354983, .43023926, .60891849, -.50161375, -.7221246, .33194245, -.70639005, -.55073654, -.15861102, -.17244583, .06087459, -.17224499, -.14522596, -.16836261, -.18502635, .10210102, -.18475196, -.17954933, 1.4866833, .95698828, -.47154365, .92672422, 1.2774079, 1.2911355, .88861684, -.16713676, .86827564, .82290279, -.09839541, -.10358873, .04638835, -.10354307, -.09648568, -.09096955, -.09470469, .01053519, -.09467913, -.05586694, -.49810824, -.67926422, .12716917, -.66849219, -.39812529, 1.6610055, 1.0605991, -.24860647, 1.0258457, 1.1111214, -.16366309, -.17883711, .07673274, -.178603, -.16019073, .6569265, .51131516, -.30129419, .5060029, .63829009, 1.0982562, .76135435, -.47545138, .74458407, 1.0467617, -.51409591, -.71837177, .16042185, -.7051421, -.43933312, -.1187299, -.12597206, .03420609, -.12589849, -.09879869, .45654377, .38446577, -.08691705, .38258035, .33090242, -.28488554, -.33901862, .18828181, -.33731459, -.31265093, .21830474, .19756622, -.1216919, .19723853, .22636329, .33133138, .28878174, -.10937445, .28787446, .28850743, .08039078, .07735885, -.03813546, .07733979, .07899334, -.02966155, -.03009056, .00975126, -.03008952, -.02579246, -.32653548, -.39441319, .11670383, -.39207824, -.2919613, -.33337953, -.4151742, .29501499, -.41186149, -.40325892, -.49720072, -.70191556, .25332848, -.68819645, -.50033302, -.09483072, -.09969709, .04929172, -.09965549, -.09606548, -.2383112, -.26735905, .03140062, -.2667705, -.15278675, .17384791, .16100567, -.0570078, .16084775, .15104317, -.29885783, -.34988492, .06073773, -.34844004, -.22138046, -.48540272, -.66641093, .17968785, -.65538423, -.43912117, -.19823386, -.21968728, .05525572, -.21930114, -.16315021, -.30018563, -.35623518, .10974338, -.35450114, -.27043488, -.56089125, -.85613782, .32826685, -.83114068, -.59111428, -.42403669, -.58488574, .58203682, -.57492417, -.59373927, -.2883768, -.34128525, .13392627, -.33967655, -.28136633, -.51613294, -.7059601, .10185868, -.69454947, -.37860272, .65757961, .50757101, -.43543632, .50194344, .72213286, 1.1870079, .82628202, -.22119967, .80848295, .8542282, .27860199, .24704089, -.11164627, .24644671, .25879004, -.24053122, -.27385251, .07592384, -.27308575, -.20634013, -.16078607, -.17692895, .16496248, -.17665932, -.20431677, -.32128487, -.38526072, .09923591, -.38315146, -.27362754, -.2883748, -.33796112, .08496367, -.33654718, -.24176455, .64638334, .50812646, -.216429, .50325443, .56551212, -.19898496, -.22156649, .07717696, -.22114037, -.18283221, .15496505, .14454288, -.05577738, .14442617, .13888389, .00633671, .0063181, -.00166539, .00631809, .00511397, -.4739938, -.66681795, .34836642, -.65404427, -.53893601, .36246502, .31161843, -.14269332, .31043506, .33469966, -.22925888, -.26072451, .10405145, -.26000712, -.22197811, .4886355, .39530087, -.49041548, .3923561, .61638879, .2447423, .22157177, -.04705109, .22120688, .17796691, .45818104, .37993539, -.21221618, .37772388, .44664338, -.32099268, -.38539684, .10526541, -.3832575, -.27889153, -.12972388, -.1380267, .02500792, -.1379382, -.09441677, -.31683287, -.37357803, .05330802, -.37189334, -.22037433, 1.4682062, .96749296, -.25056919, .94000071, 1.0260706, -.07950166, -.08302061, .05841841, -.08299466, -.09038799, -.06855711, -.07085819, .01818478, -.07084532, -.05549847, -.21092744, -.23694868, .09130626, -.2364151, -.20103217, -.61472947, -.96513955, .22680609, -.93316874, -.55550025, .4952139, .40151315, -.39233881, .39858411, .57733201, .05935325, .05752996, -.06177101, .05752063, .07578232, .28816721, .25615663, -.06903522, .25556563, .22549138, -.06973866, -.07231299, .03575098, -.07229716, -.07032154, .76735159, .58759668, -.17989453, .58067771, .59613632, .0214232, .02120572, -.00758547, .02120535, .01909533, -.59843416, -.92357982, .22634383, -.89521849, -.54526857, .38819962, .32571873, -.39803505, .32405296, .49319709, -.19707937, -.21731471, .03854351, -.21696909, -.14413006, -.40534384, -.51980512, .14965248, -.51448429, -.36637038, .75387704, .56679094, -.45130491, .55917749, .8005105, -.50903893, -.73255746, .29339799, -.71662576, -.53373995, -.4447331, -.59350981, .19587434, -.58535142, -.42631978, -.56118785, -.82137873, .1770618, -.80184537, -.48134573, .05405625, .05269526, -.02015385, .05268955, .04901849, .5064457, .41581461, -.16660501, .41313237, .44048178, -.41284779, -.55286364, .38436762, -.54508282, -.50790861, -.29817206, -.34948804, .06544106, -.34802351, -.226606, .29133822, .25698419, -.12039233, .25631115, .27340592, .11252154, .10660969, -.06318201, .10655795, .11695845, -.13277124, -.14234073, .05467631, -.14222589, -.12445501, -.55454265, -.79811435, .14813201, -.78074838, -.44996936, 1.3072545, .89034916, -.21571659, .86883081, .90339553, 1.0007486, .71681392, -.31062265, .70368218, .8536982, -.16159869, -.17579135, .0553703, -.17558389, -.14247134, -.07081385, -.07343344, .03221049, -.07341729, -.06861535, -.16043381, -.1744756, .05708551, -.17427105, -.14323503, -.51880592, -.72619974, .15403705, -.71269002, -.4360688, -.38869728, -.48193385, .07466007, -.47824067, -.28256202, .0204857, .02029921, -.00401082, .02029892, .01498723, -.67349836, -1.0435125, .0925214, -1.0108993, -.43783966, 1.1593064, .803795, -.30685635, .78610388, .93782224, .39465662, .33338519, -.22956766, .33180876, .41507492, -.35065788, -.42865261, .10374909, -.42578449, -.29439279, -.11717109, -.12449126, .04628912, -.1244151, -.10832199, -.08785581, -.09195866, .04124202, -.09192674, -.08602743, -.58266706, -.93449817, .44822709, -.90062578, -.67265083, .02376894, .02349106, -.01201546, .02349052, .02385595, -.67355988, -1.0792605, .13905122, -1.0402924, -.50155559, .71359203, .53745127, -.6508134, .53032017, .87189093, -.43603228, -.5650238, .11086531, -.55874855, -.34803344, .20930669, .19143418, -.05646736, .19118023, .17039803, -.35727676, -.44590583, .18199924, -.44227724, -.35950343, 1.6753869, 1.0630095, -.2812032, 1.0272074, 1.1643767, .4908936, .40681268, -.12660653, .4044293, .3936893, -.14652734, -.15811187, .05238908, -.1579594, -.13102959, .31785778, .27544281, -.23317764, .27450336, .36118319, -.27537691, -.32558569, .18544645, -.32406848, -.30411267, -.48698873, -.6811047, .25166251, -.66849482, -.49237438, .29298545, .25481961, -.34254518, .25399422, .38887795, .00874662, .0087142, -.00103607, .00871418, .00541211, .78880147, .57458812, -1.1066426, .56508469, 1.1125621, -.2651808, -.31172182, .19198616, -.31036754, -.30000467, -.07367286, -.07638552, .02255351, -.07636888, -.06255851, -.68976582, -1.1810856, .2285198, -1.1260085, -.60133857, -.44284919, -.59496177, .23586881, -.58640379, -.45227655, 1.1574275, .80210806, -.31606556, .78440858, .94608814, -.45541674, -.59502664, .09697116, -.58799469, -.34263378, -.09223334, -.09669847, .03780678, -.09666246, -.08632273, -.0124833, -.01256213, .00636916, -.01256204, -.01256773, 1.4158797, .92342387, -.46411344, .89589567, 1.229992, .97228034, .70692751, -.2229686, .69509957, .74981174, -.34006705, -.42291708, .24050992, -.41958476, -.3817368, -.26819996, -.30448753, .02667655, -.30367188, -.15656416, -.26398234, -.30512656, .08536277, -.30406224, -.22828782, -.55825751, -.82607513, .21860396, -.80530605, -.51457939, -.16766537, -.18511605, .15606077, -.18481393, -.20625453, -.01272429, -.01280849, .00828946, -.0128084, -.01389764, .3518566, .29863266, -.42628281, .29729802, .47259205, .5556532, .45481888, -.09389467, .45179348, .38704327, -.37533789, -.47597869, .20081775, -.47153154, -.38390665, -.2823153, -.33137866, .10855139, -.32996482, -.25864936, -.44365506, -.59286463, .20595612, -.58464003, -.43281123, -.19042374, -.21159373, .09372189, -.21120235, -.18942519, -.46299754, -.59724988, .06074254, -.59084525, -.29641041, -.34330638, -.42155001, .14437466, -.41860282, -.3240621, -.36794163, -.45993492, .15125125, -.45613947, -.34469021, -.25669541, -.29799002, .13410812, -.29688775, -.26047963, .15008009, .14024978, -.05537051, .14014256, .13561828, -.30648333, -.37209994, .23626267, -.36977611, -.35406223, -.05142546, -.05292612, .0545165, -.05291883, -.066065, -.03417275, -.03472592, .00845988, -.03472443, -.02703449, -.11575649, -.1223337, .02332548, -.12227146, -.08550347, .60106468, .48320686, -.12932211, .4793917, .45378319, -.4304812, -.55710014, .1186265, -.55097481, -.35294473, -.08322226, -.08720463, .07806581, -.08717289, -.10264157, -.23064543, -.26357348, .13260161, -.26279277, -.24163296, .21330742, .19475851, -.05853626, .19449012, .17464479, -.57475093, -.93020323, .55395287, -.89521359, -.71529863, .87328648, .66049213, -.10854342, .65198361, .5490969, -.22979168, -.26014119, .07675841, -.25947518, -.20088223, .28003539, .24793189, -.12181976, .24732031, .26733625, -.55613717, -.87231013, .49950373, -.8435344, -.67604799, -.29221015, -.34113387, .06326927, -.3397752, -.22107407, -.23656182, -.27398163, .22836836, -.27299935, -.29456767, -.19604252, -.21782828, .07403688, -.21742568, -.17853618, -.60083484, -.94430253, .27580695, -.91288147, -.58395826, -.00547621, -.00549046, .00166924, -.00549045, -.0046434, -.0213368, -.02153555, .00277666, -.02153524, -.01362293, .12983826, .12254873, -.03846697, .12248057, .10905388, .31152157, .27198549, -.15725302, .27115229, .31251323, -.24926324, -.28712409, .11206531, -.28616946, -.24058722, -.44366991, -.58611229, .15714355, -.57860731, -.39550214, -.27923967, -.3282771, .12752518, -.32684934, -.27093185, .29608578, .26082062, -.11793087, .26012283, .27447168, .23601646, .21220039, -.1228077, .21180075, .23917368, -.08213268, -.08616873, .10838062, -.08613569, -.11350227, .00044752, .00044743, -.0001309, .00044743, .00037429, 1.4203149, .94835746, -.21382878, .92305453, .95196682, -.09720393, -.10232543, .05039981, -.10228048, -.09838801, .06584662, .06388567, -.0200944, .06387594, .0558544, .41548604, .34920225, -.20852496, .34745044, .41600668, 1.0305757, .73735664, -.25589049, .72375941, .81610862, .00590486, .00588968, -.00088055, .00588967, .00394519, -.46055261, -.63089786, .26150477, -.62060224, -.48049555, .10013784, .09518753, -.0887687, .09514677, .12119799, .93052524, .68548374, -.19069824, .67492748, .69121158, .02028512, .02010138, -.00414368, .02010111, .01505187, 1.8098205, 1.0718835, -1.1072545, 1.0243916, 1.9357509, .8189776, .59083974, -1.1819009, .58047062, 1.1660532, -.46953787, -.63012622, .14410389, -.62112897, -.39903928, -.21602006, -.24713774, .23918854, -.24639336, -.28156986, -.03863364, -.0393815, .01520532, -.03937909, -.0356713, -.04683537, -.04784446, .00830017, -.04784083, -.03314527, 1.3220231, .88728977, -.32077514, .8642057, 1.0388901, -.24859345, -.28562577, .09940402, -.28470988, -.23074791, -.29160799, -.34358073, .10003715, -.34204517, -.25719551, -.25501821, -.29229893, .07063503, -.29139397, -.20944219, -.29785083, -.35675225, .17350525, -.3548235, -.31341041, -.0198085, -.02000469, .0086732, -.02000437, -.01895123, .09321496, .08888984, -.08523493, .08885641, .11399162, -.20218426, -.22416563, .04888082, -.22376818, -.15869176, -.73340024, -1.2432168, .12718219, -1.1873251, -.51528337, -.05938582, -.06107651, .0139319, -.06106849, -.04614614, -.27714991, -.32583833, .13577607, -.32442021, -.27527128, 1.819109, 1.1065563, -.50113102, 1.0622646, 1.4913042, .13080335, .1234575, -.03635812, .12338879, .10755313, -.24344208, -.28111843, .15508732, -.28015061, -.26391609, -.02966079, -.03009801, .01152855, -.03009694, -.0272724, -.06254188, -.06450144, .02100664, -.06449121, -.05477421, -.43209991, -.55131104, .07773608, -.54589413, -.30733144, .40490703, .34078423, -.23531005, .33910179, .42572292, -.41954719, -.53913051, .1203157, -.53352059, -.34858175, -.3628394, -.45381439, .17222083, -.4500505, -.35660015, -.38457428, -.49468597, .24817228, -.4894975, -.4187112, .03240107, .03191414, -.01011152, .03191292, .02768992, -.41006257, -.52671335, .1427386, -.52125149, -.36343262, -.67063163, -1.041895, .09911552, -1.0089364, -.4467315, -.12851451, -.13757402, .05927542, -.13746768, -.12510356, -.3719938, -.45990369, .09630487, -.45647218, -.29871009, -.40347027, -.50311655, .0668771, -.49905461, -.27923949, -.19335674, -.21772217, .21485219, -.21721188, -.25232647, .07437463, .07189301, -.02219004, .07187921, .06261512, -.03557874, -.03622088, .01592149, -.03621895, -.03428716, .20918056, .19145159, -.05255341, .19120155, .16629959, .27805743, .2480225, -.06810202, .2474832, .21918947, .18468983, .16511164, -1.4715482, .16476661, .4647615, -.2575353, -.29550811, .06952078, -.29457847, -.20970368, .01467121, .01457715, -.00238058, .01457705, .01008204, -.41285416, -.51797618, .06762362, -.5135607, -.28460373, .35563681, .3062542, -.14814418, .30511644, .33463858, -.25857056, -.2980628, .08700149, -.29706156, -.22658871, 2.3143122, 1.2965813, -.6925129, 1.2267849, 1.9502962, 1.2885501, .83343651, -1.2770734, .8076381, 1.6186371, -.12692213, -.13723212, .20535844, -.13709271, -.18773233, .26923237, .23674265, -.29097175, .23609135, .34810623, -.1644801, -.17959486, .06874828, -.17936372, -.15494332, -.12573299, -.13397529, .03906078, -.13388531, -.10728931, .32052335, .27885662, -.1631772, .27795737, .32245536, 1.2204833, .84285618, -.23326903, .82390706, .88576173, -.24900477, -.28478904, .07541898, -.28393504, -.21068907, -.40704517, -.51038658, .07434913, -.50605829, -.29098037, .21943066, .20003196, -.05533431, .19974663, .17466519, -.45510119, -.58233022, .05571458, -.57647363, -.28471145, -.81117623, -1.520445, .13085642, -1.4248404, -.55635477, -.77218206, -1.5102336, .25867285, -1.4026493, -.67567847, -.5463344, -.74681291, .06381628, -.73478848, -.33648021, -.01488634, -.01499325, .0049014, -.01499312, -.01295115, -.39951562, -.5232236, .29350692, -.51693138, -.45419111, -.59765957, -.94833892, .32290001, -.9154673, -.61329384, -.31116488, -.36913016, .08102167, -.36734095, -.25034415, -.55419425, -.77405012, .08721173, -.7598334, -.37697248, .06660237, .0644445, -.04062329, .06443285, .07116418, .37840857, .32086525, -.25307749, .31941476, .41693513, -.01836144, -.01852658, .00675922, -.01852633, -.01657983, .8405879, .62836978, -.23908668, .61958976, .69649374, -.09265738, -.09706769, .03161807, -.09703272, -.08157839, -.20843404, -.23371337, .08828977, -.23320372, -.19722376, -.22152769, -.24561922, .02358758, -.24518348, -.13228881, -.00989398, -.0099387, .00206509, -.00993866, -.00739441, .34746868, .29703509, -.29418024, .29582103, .41415058, -.48286069, -.64976738, .12240594, -.6403194, -.38502778, -.06895623, -.07133693, .02209925, -.07132323, -.05945452, .16298072, .14999578, -.20560011, .1498236, .22187512, .24080838, .22023406, -.01850433, .21994155, .12898786, -.51551132, -.72856997, .19351423, -.71423974, -.46853256, .21480614, .19587928, -.06340083, .19560181, .18019364, .08752845, .08406782, -.03029766, .08404503, .07743058, .30806368, .27219212, -.06720695, .27149809, .23365499, .94688487, .68427465, -.34730971, .67238853, .85397881, -.43233564, -.569952, .18376994, -.56276164, -.4095581, -.53267009, -.7582047, .16905304, -.7426797, -.4577797, .04102751, .0401968, -.02405138, .040194, .04326202, -.56663295, -.80273476, .09480533, -.78673008, -.39338893, -.37045646, -.48178134, .44890056, -.47628198, -.49760511, -.10084367, -.10569215, .01747511, -.10565331, -.07083518, .04704931, .04606637, -.0107544, .04606295, .0362444, .32137416, .27952841, -.16267221, .27862382, .32269216, -.31983522, -.38614446, .13531918, -.38386942, -.30251528, .17817824, .16448048, -.07009303, .1643052, .16448945, -.1103941, -.11668311, .03483861, -.11662343, -.0946951, -.00013749, -.0001375, .00007475, -.0001375, -.00014138, -.13713359, -.14713003, .04626945, -.1470087, -.12028293, -.47766001, -.68544176, .46513064, -.67076398, -.5965052, -.40203327, -.50607888, .09272902, -.50163829, -.3106394, -.28636274, -.33857538, .13562985, -.33699759, -.2812372, .18113612, .16722005, -.06103794, .16704209, .15881079, .43928596, .36876772, -.14358666, .36689253, .38125269, -.49480076, -.68495104, .18182103, -.67302608, -.44652414, -.34704893, -.41596757, .05255445, -.41370144, -.23306316, -.21356853, -.24021161, .0899185, -.23965917, -.20167459, -.03935419, -.04006861, .00747542, -.04006645, -.02850247, .92015694, .68409902, -.14473168, .6741813, .62580515, .51444621, .42340162, -.12858296, .42073645, .40828597, -.25471088, -.29339574, .09420566, -.29242042, -.2303566, -.13162226, -.14058773, .03703192, -.14048603, -.10866465, 1.5256867, .97351753, -.50109969, .941521, 1.3262588, -.25711545, -.29990523, .16870733, -.29872397, -.28149678, -.57010669, -.84199052, .17948291, -.82102463, -.48863937, -.2481663, -.27941, .02898028, -.27875625, -.15282911, -.39585463, -.49543135, .08761031, -.49129838, -.30168396, .26396598, .23625542, -.07620485, .23577178, .2198043, .20345859, .18405327, -.22285928, .18374541, .26424347, -.63319563, -1.0172999, .23504772, -.98016198, -.57335106, .09770997, .09358417, -.02358854, .09355515, .07665425, .97657256, .70907665, -.22678578, .69711179, .75628407, .62465015, .49899984, -.13068314, .49482956, .46720529, .90636958, .66285383, -.31254602, .65216034, .80078919, .4695421, .39186196, -.11990305, .38973403, .37532121, .40342544, .34071291, -.19540737, .33909737, .3991773, .13367782, .12613466, -.03201812, .12606377, .10459594, -.40380903, -.51029971, .10080706, -.50567009, -.32034971, -.0388306, -.0395016, .00540108, -.03949967, -.02534854, -.66782547, -1.0553002, .12645645, -1.019358, -.48316891, .31847072, .27670872, -.18917586, .27579959, .3372963, .07277888, .07021524, -.04413034, .07020019, .07761149, .46503517, .38825082, -.1265806, .38615148, .37971368, -.42325907, -.5547309, .18842624, -.54802331, -.40718769, .26700903, .23807593, -.09743584, .23755477, .24039949, -.51371982, -.70883681, .12629997, -.69673812, -.40547302, -.11243706, -.11977953, .09256012, -.11969968, -.13276725, -.28640328, -.33759131, .11782752, -.33607475, -.26837635, .27297517, .24431756, -.05828916, .24381737, .20556761, -.82425343, -1.4558008, .07241172, -1.3801574, -.46165774, .23197297, .21044408, -.05870715, .2101117, .18486949, .98806998, .70637739, -.36917964, .6932897, .89663231, .23381589, .21149227, -.07404639, .21113776, .20079858, -.33833613, -.40485254, .06012981, -.40268701, -.2396655, .68204589, .52634513, -.3281514, .52049998, .67335458, 1.5731096, 1.0056366, -.37080283, .97284989, 1.2243258, -.45257303, -.60588142, .18307374, -.59737163, -.42170731, .01959294, .01939979, -.0118505, .01939947, .02087638, .67430133, .52815406, -.18288737, .52293729, .5499298, -.49980304, -.70102851, .21568603, -.68783051, -.47586445, -.03464258, -.035257, .01690984, -.03525518, -.03436608, .80105849, .59930949, -.3399519, .59098201, .75844712, -.10945449, -.11524755, .02024744, -.11519648, -.07857585, .19586527, .18014534, -.05092761, .17993536, .15750683, -.59356161, -.84972679, .07853711, -.83176759, -.38107651, -.26176648, -.30059589, .06376126, -.29963959, -.20597048, -.52670437, -.7444074, .16303326, -.72976361, -.44889698, -.25229583, -.28607887, .04027129, -.28532731, -.17243096, -.54254012, -.79819515, .2514942, -.77870402, -.5290222, -.54033162, -.76807782, .14728081, -.75246839, -.44139998, -.56976056, -.84612526, .1959766, -.824468, -.50296719, .17571897, .1618744, -.10052461, .16169285, .18378634, -.01966618, -.01984563, .0044382, -.01984536, -.01508547, -.46794437, -.64572302, .2668698, -.63469658, -.48892167, .90744845, .66879756, -.22886194, .65852951, .72235247, -.19712819, -.22030293, .10889611, -.21984998, -.20378863, 1.3898858, .91141256, -.45367215, .88491521, 1.2057116, .27466983, .24204683, -.20858318, .24140311, .31572604, -.66945557, -1.0585014, .12489742, -1.0223593, -.48195777, -.0883628, -.09218563, .02068614, -.09215807, -.06861454, .25378339, .22880327, -.05290206, .22839435, .18958748, -.33129648, -.39813119, .08484429, -.39589913, -.26507092, -.6846758, -1.1753391, .24822923, -1.1200304, -.61510741, .51773831, .42045386, -.25244933, .41743344, .51342255, -.36495, -.44294497, .05775645, -.44018761, -.24871334, -.27098725, -.31689904, .12582319, -.31560895, -.26438053, .2238209, .20271648, -.09220094, .20238547, .20982418, -.3300101, -.39369167, .06458042, -.39165629, -.24139509, .23984243, .21485965, -.1510369, .21442699, .25901308, -.58287734, -.86283572, .15567784, -.84110082, -.47293745, .61384652, .48385407, -.28790581, .47931763, .60089696, -.48279673, -.65891216, .1660104, -.6484094, -.42615211, -.29051501, -.34520187, .15087778, -.34349632, -.29421455, -.35458256, -.45526794, .45161194, -.45056198, -.4842579, -.40514188, -.52326343, .18270347, -.51759809, -.39143863, .28227816, .25174487, -.0612721, .25119586, .21373835, -.0049285, -.0049399, .00134475, -.00493989, -.00402749, -.41690016, -.54134562, .16759997, -.53523816, -.38766449, .16950891, .15707999, -.06473905, .15692828, .15495078, -.01036676, -.01041726, .0027779, -.01041722, -.00842062, -.30324818, -.36382787, .16105665, -.3618242, -.30941048, .15392032, .14362663, -.05565588, .14351201, .13815851, -.29522033, -.37007469, .96310443, -.36694351, -.55165213, .05217972, .05099639, -.010079, .05099192, .03800293, -.55561286, -.79246508, .12499179, -.77605455, -.42574742, .0664843, .06432465, -.04222881, .06431296, .0720044, -.46157157, -.62567311, .20595031, -.61612713, -.4443824, -.01948926, -.01968341, .0103965, -.01968309, -.01991449, .04701158, .04605471, -.0084959, .04605146, .03348752, -.33983184, -.42133979, .21858269, -.41811148, -.36959376, -.42373944, -.55543162, .18732468, -.54870924, -.40670008, -.26879735, -.31220996, .0954347, -.31104661, -.23980712, -.16985211, -.18538364, .0511324, -.1851473, -.14342428, -.76538156, -1.4801955, .25816143, -1.3780855, -.6712626, -.20615384, -.23331385, .17956462, -.2327193, -.24805304, -.66010257, -1.0703162, .18677226, -1.0297548, -.54599468, -.46155485, -.6202997, .17067579, -.61135728, -.41739719, -.34629564, -.4234232, .11569795, -.42058323, -.30274936, 1.9389514, 1.1104311, -1.5930197, 1.0549485, 2.2880297, -.21333669, -.242139, .16379957, -.24149298, -.24612626, -.10510642, -.11071165, .02982542, -.11066186, -.08702119, -.6117049, -.89174243, .08338052, -.87097166, -.39663666, .31011561, .27181763, -.120844, .27103209, .28538695, -.36212946, -.46228943, .32447926, -.45772692, -.43986042, .15267489, .14266294, -.04883894, .14255362, .13155594, -.71536372, -1.2602705, .22012304, -1.1953498, -.60848485, -.69349745, -1.2647863, .37401124, -1.1917575, -.71121591, -.20114185, -.22287933, .048648, -.22248863, -.15789437, .00818593, .00815596, -.00158002, .00815594, .00596041, -.27911439, -.31827421, .02536087, -.31736167, -.15809551, -.06383529, -.06626514, .09420362, -.06624972, -.09156716, .29710195, .26185165, -.11004677, .26115681, .26882693, .06272224, .06087881, -.02618575, .06086978, .05906263, .28103164, .25195927, -.03951707, .25145921, .18412315, .32293377, .28161776, -.12886881, .28074006, .29954926, -.04032292, -.04122905, .03967449, -.04122566, -.0505299, .55452718, .45644487, -.07007543, .45357528, .35060153, -.57105625, -.87833166, .31484532, -.85177237, -.58996784, -.47576149, -.66833331, .32920971, -.65563788, -.53018455, -.31204797, -.37164481, .09411346, -.36975933, -.26365832, -.71218064, -1.169247, .11644927, -1.1226855, -.49066193, -.47393724, -.63823842, .14448975, -.62891155, -.40188602, .85134458, .61467274, -.84160252, .60393653, 1.0685198, .2930939, .25736519, -.16470283, .25664173, .30472976, -.28096243, -.32780374, .08403295, -.32650837, -.23673295, .17636294, .16247957, -.09677612, .16229766, .18191602, -.55304167, -.79089422, .13581671, -.77427408, -.43634798, .29560585, .2614625, -.0856697, .2608072, .24646831, .71711943, .55042914, -.27892472, .544061, .65952814, .45420572, .37979882, -.13932181, .37778024, .3859385, -.21270616, -.23893976, .08520051, -.23840197, -.19755018, -.32082581, -.38921207, .15911656, -.38680062, -.31995924, .14448218, .13517863, -.06333295, .13507888, .13828107, -.54260781, -.83635851, .48731543, -.81082247, -.65958496, -.38975271, -.48967674, .11197595, -.4854512, -.32402437, .37023932, .3182899, -.12073292, .31708058, .32107532, -.18500597, -.20527146, .1053769, -.20490228, -.19321861, -.55421986, -.81212618, .19929405, -.79269647, -.49654983, -.67388566, -1.107452, .18308313, -1.0631829, -.54989982, -.55371898, -.78864307, .12530861, -.77244018, -.42513798, -.79523549, -1.5748272, .22103194, -1.4586535, -.65387116, -.03865596, -.03944844, .02498407, -.03944573, -.04210904, .47907012, .39687889, -.15691782, .39454529, .4160704, .27169184, .24131765, -.11841986, .24075329, .25953898, .95433089, .67386839, -.76430692, .66045863, 1.1166025, -.16884494, -.18472779, .06701134, -.18447918, -.15633329, -.58048226, -.90027987, .30768568, -.87201929, -.59188645, .09702386, .09255906, -.05712252, .09252484, .1024546, -.09443758, -.09917476, .04213729, -.09913517, -.09092056, .1002742, .0954982, -.06121954, .0954603, .10717648, .46457249, .38602337, -.16876349, .383825, .41764295, -.52327451, -.73053254, .1368673, -.71715104, -.42162817, -.17938365, -.19985912, .18494243, -.1994705, -.22832007, .0704082, .06802469, -.03945309, .06801125, .07313397, .46637499, .39102241, -.09593579, .38900583, .34686492, 2.2831696, 1.2679097, -.97165757, 1.1976462, 2.1637472, .16763493, .15594166, -.04285017, .15580586, .13404085, .38504135, .33230165, -.06731415, .33110289, .27125872, -.03192792, -.03249649, .03365936, -.03249481, -.04094105, .40354763, .34531342, -.08321158, .34391962, .30037777, -.25298261, -.29074769, .08774405, -.28981173, -.22394584, -.29640711, -.35472974, .17429654, -.35282939, -.31287102, -.25858823, -.29943226, .11084943, -.29836165, -.24565579, 1.6440042, 1.0388676, -.36960944, 1.0032659, 1.2594849, .01411087, .01401799, -.00412915, .01401789, .01180319, -.29628554, -.35629179, .21293068, -.35428001, -.33437185, -.44348277, -.58416217, .14689832, -.57683638, -.38660438, -.49725279, -.69591546, .21562404, -.68298171, -.4741989, .40373151, .34334675, -.12464552, .34184937, .34379322, -.32419631, -.39015905, .10692326, -.38793747, -.28221024, -.2352134, -.26889074, .11577911, -.26808997, -.23398864, .22479707, .2035298, -.09219838, .20319513, .21043188, -.37924183, -.46888179, .0826318, -.46538209, -.28752121, .04450384, .04354595, -.0221385, .04354251, .0444281, -.26490466, -.30975349, .15010926, -.30849416, -.27618848, -.24704163, -.28358762, .09933805, -.28268997, -.22973578, .0313423, .03087196, -.01301685, .03087078, .02946225, .16039389, .14846934, -.11584567, .14832176, .1813128, .39469993, .34213706, -.04033536, .34097517, .23249663, .00097178, .00097136, -.00017334, .00097136, .00068922, -.73712058, -1.3740473, .27048396, -1.2890906, -.66488959, .04697925, .04595206, -.01661782, .04594831, .0418606, 1.0069131, .70432784, -.69585313, .68955374, 1.1216151, -.19507028, -.2158063, .05472894, -.21543967, -.1608952, -.5307784, -.74514525, .1355714, -.73104293, -.42430177, -.38706565, -.4910044, .15845866, -.48640487, -.36210824, .50030571, .40543876, -.37112231, .40246703, .57060993, .45510098, .37989814, -.15183835, .37784045, .39768787, .18191051, .1664679, -.16334546, .16624975, .22111467, .43450774, .36581801, -.13111312, .36401887, .36718962, -.43012689, -.58741161, .42400243, -.57800973, -.5393415, .41487081, .35305325, -.09603176, .35152603, .32093978, -.48219771, -.63422421, .07253155, -.62635458, -.32309909, -.2116386, -.23718223, .07532369, -.23666973, -.18896605, -.20662098, -.23126894, .08351743, -.23078014, -.19247987, .10914574, .10398608, -.02889256, .10394545, .08829644, -.79287517, -1.4584816, .13679515, -1.3719497, -.55612204, -.38544108, -.5007257, .31775297, -.4950568, -.45534986, .85446108, .62898569, -.38836301, .61925316, .82772132, -.23429899, -.26513387, .0639893, -.26445959, -.19152526, -.61137671, -.92184413, .13907551, -.89643443, -.47021825, -.44567629, -.61384907, .37975934, -.60348654, -.53234418, -.33107748, -.40075158, .11352917, -.39832555, -.29196598, -.05769032, -.05933543, .01781526, -.05932762, -.04912954, .48038593, .3914733, -.38220613, .38875341, .56083624, 1.5607517, .97473808, -.79440657, .93964577, 1.57005, -.46211161, -.61760459, .14906972, -.60902956, -.39930467, -.16693896, -.18823996, .7643983, -.18778827, -.34926498, -.02861234, -.02902708, .01326052, -.02902608, -.02789754, -.44776451, -.56447321, .04096984, -.55945726, -.25421307, .71796375, .54719255, -.37553979, .54052169, .72883686, -.3381459, -.41177679, .12047936, -.40912526, -.30203015, .28135613, .24837388, -.14928807, .24773149, .28698285, -.07450749, -.0774421, .03656232, -.07742284, -.07404366, .22981909, .20861652, -.05946391, .20829112, .18450943, .21651875, .19623524, -.11233909, .19591916, .2192051, .35450331, .30766748, -.08719146, .30664031, .27984325, -.28768706, -.33654921, .07936459, -.33517283, -.23595679, -.21308212, -.24374959, .26516187, -.24301661, -.28876532, -.22045538, -.25038035, .13113803, -.24970553, -.23359669, -.35033088, -.42664505, .09100318, -.42389582, -.28163144, .40066749, .33973627, -.16029453, .3382003, .37196804, -.53478631, -.750588, .12707463, -.73640291, -.41733339, 1.5182092, .98331944, -.32964134, .95306749, 1.1496835, .12071306, .11451876, -.0286122, .11446581, .09412318, -.5278798, -.72723082, .0984675, -.71493766, -.38001231, -.15113552, -.1647059, .11267369, -.16450312, -.17266138, .43814029, .3651026, -.22810829, .36308682, .44408471, .22195374, .20053065, -.12584989, .20018673, .23145643, -.08587505, -.09002097, .06542431, -.08998762, -.09881762, -.4150392, -.52973121, .1083907, -.52451128, -.3342464, -.18745209, -.21157255, .32214316, -.21105678, -.28289145, .3139836, .27330586, -.18531653, .27243091, .33183284, -.55439278, -.78393005, .10918544, -.76846502, -.40639025, -.17200928, -.1904243, .15818232, -.1900964, -.21074821, .1193529, .11320535, -.03249434, .11315261, .09746183, .8489274, .63186865, -.26325452, .62277833, .72396179, -.7463687, -1.4410382, .31228717, -1.3421037, -.70333731, .16040263, .1498098, -.03528531, .14969332, .12199695, -.13309942, -.14242628, .04265966, -.14231745, -.11476247, -.33564918, -.41114434, .15851291, -.40833741, -.3293229, -.57516097, -.82379133, .10189629, -.80633307, -.40699498, 1.9283559, 1.0953586, -2.0707035, 1.0390683, 2.487945, -.50510217, -.72836955, .32299386, -.71235445, -.5482697, -.07564846, -.07868182, .03768843, -.07866156, -.07555782, -.45992691, -.63164958, .27849917, -.62117591, -.490242, -.08926896, -.09371519, .06229344, -.0936783, -.0997603, .40149657, .33357001, -.54631879, .33166777, .5605486, .31817766, .28187554, -.0416558, .28118725, .20355493, .0714031, .0690895, -.02329649, .06907701, .06193244, .01487609, .0147739, -.00399054, .01477378, .01208778, -.64250012, -.99031771, .12607992, -.96008254, -.47040737, -.44938868, -.61231852, .28473992, -.60265935, -.48630366, -.02857917, -.02899295, .01324853, -.02899195, -.02786756, -.32723235, -.38792416, .05253607, -.38605889, -.22407841, -.23049008, -.26139683, .08387148, -.2607083, -.20732401, .02034739, .02014464, -.00965928, .02014431, .0199985, .16228071, .15160581, -.03091546, .15148889, .11764672, -.44013133, -.57620864, .1340597, -.56929752, -.37310489, -.67392705, -1.1627933, .29520191, -1.1070738, -.64484942, .12211996, .11635374, -.01163097, .11630838, .07026512, .73267565, .57461918, -.08861483, .56900298, .45651317, .20424855, .18696722, -.06249721, .18672391, .17340816, -.47129773, -.62648378, .11234339, -.61810387, -.36817651, -.29860653, -.35164583, .08079693, -.35008403, -.24333682, -.21556065, -.24278656, .09161459, -.24221506, -.20419473, -.51458917, -.73255356, .22330137, -.71754403, -.4908486, -.10226342, -.10752412, .02751104, -.10747904, -.08317495, -.40297264, -.51423312, .13650671, -.5091737, -.35392538, .14037235, .12878312, -.97673804, .12862389, .33764248, .25369103, .22958608, -.03666321, .22920511, .16773495, -.18176296, -.1998888, .05867076, -.19958808, -.15709203, 2.6324636, 1.4174223, -.68768306, 1.330773, 2.1202205, .58834522, .47112941, -.18710233, .46727544, .50596975, .03624121, .03565592, -.00801153, .03565435, .02760898, -.41267811, -.56402326, .60021257, -.55495088, -.58909587, .19496184, .17785134, -.13216935, .17760148, .21578438, -.41292923, -.5134589, .05065796, -.50941832, -.25850939, -.14911381, -.16095503, .04718856, -.16079849, -.12802678, -.65109408, -1.0373099, .17069642, -1.0007378, -.52502579, -.3148101, -.37004318, .04855218, -.3684365, -.21270548, -.47336597, -.7393653, 1.7208247, -.71541858, -.91703708, -.67644548, -1.0496617, .09109062, -1.0166348, -.43684069, -.08417269, -.08763556, .01993774, -.08761182, -.06561696, .53337724, .44236198, -.06233408, .43979156, .32855507, -.22685081, -.2545495, .04718868, -.25398732, -.16934907, -.44340949, -.56335271, .05592508, -.55800675, -.28016606, -.05488186, -.05637341, .0175327, -.05636666, -.04726926, 2.4118393, 1.3067879, -1.1813467, 1.2284419, 2.3953447, -.27912404, -.32391867, .06743894, -.32272583, -.21903411, -.16399678, -.1790167, .06855064, -.17878778, -.15449131, .3684578, .31069431, -.44509544, .30919378, .49440883, -.20177726, -.22252927, .0323358, -.22217424, -.13808697, -.24144046, -.27291117, .04683885, -.27222954, -.17609706, .08488658, .08138022, -.05886781, .08135609, .09466628, -.41163198, -.53121895, .1574401, -.52550326, -.37646203, -.27044505, -.31588476, .12050904, -.31461843, -.26025708, .54361565, .44949553, -.06363569, .44679912, .33504634, -.07609006, -.07890912, .01836399, -.07889172, -.05968762, -.42941341, -.55344993, .10837757, -.54755483, -.34190612, -.29898625, -.36363006, .30759952, -.36131838, -.38028223, -.5437877, -.77611569, .15019369, -.75998426, -.44618347, .29246074, .25673817, -.17125863, .25601341, .30827564, -.44169266, -.6107842, .44160929, -.60021904, -.55646287, -.31832995, -.38001544, .08867623, -.37803567, -.26193733, -.42639324, -.55165045, .12705299, -.54559852, -.35882153, -.22168002, -.24825043, .04932021, -.24772101, -.16923986, -.6888711, -1.191829, .25390767, -1.1341642, -.62229157, -.25067882, -.29078606, .15589837, -.28972126, -.26958907, 3.265403, 1.5807553, -1.6408632, 1.4501572, 3.2708351, .56486373, .45419056, -.21051909, .45061071, .51215681, -.37352746, -.47202432, .18797241, -.46774257, -.37433152, -.27755529, -.32002637, .05003166, -.31894761, -.19754133, -.49857145, -.67428638, .10578841, -.66415091, -.37466314, .28115665, .24908246, -.11190598, .24847442, .26057136, .1589048, .14792772, -.05963129, .14780147, .14440849, -.47405353, -.64409933, .17490553, -.63412198, -.42838024, -.13721991, -.14771917, .06807197, -.14758543, -.13686031, .6298221, .49558253, -.25459055, .4908683, .58672693, .71120398, .53979997, -.48343931, .53301877, .78786796, .34151436, .29531036, -.15310071, .29427292, .32931262, -.05270446, -.05400628, .01059308, -.05400092, -.03889696, -.40095972, -.51656558, .18547566, -.51108099, -.39069645, -.4825293, -.64925046, .12278168, -.63981687, -.38524497, -.40415788, -.51307116, .11465483, -.50823475, -.3345863, -.51995196, -.73782877, .19427069, -.72297937, -.47183255, -.2727901, -.31298492, .04365442, -.31200154, -.18659721, -.61114354, -.93441405, .16903524, -.90691829, -.50168514, -.05718684, -.05888843, .02756893, -.05887999, -.05649552, .19846387, .18235099, -.05154158, .18213327, .15953289, .27316878, .24263868, -.11302719, .24207159, .25646318, .79524934, .61537976, -.08505513, .60868768, .47560424, -.64619972, -1.1533024, .5537232, -1.0912406, -.77330725, -.06110944, -.06323229, .06123938, -.06322, -.0770476, -.25456872, -.29095935, .06078663, -.29009543, -.19898304, .80642094, .60885258, -.22094136, .60091152, .65989809, -.07770532, -.08078349, .02742688, -.08076317, -.06918882, -.39200663, -.50803439, .26059399, -.50238694, -.43104943, -.41608515, -.54343058, .19780547, -.53702654, -.4091453, .01959221, .01939402, -.01500015, .01939369, .02258209, -.4843194, -.70996538, .58947512, -.69294681, -.65150797, .27704727, .24549705, -.12354784, .24489998, .26668032, -.18512321, -.20297368, .03896519, -.2026873, -.1387425, -.58340675, -.95305195, .54431923, -.91584025, -.71824982, -.05064422, -.0519641, .02320251, -.05195837, -.04918978, -.10498592, -.11048641, .02597161, -.1104384, -.08303547, .03076093, .03037519, -.0029039, .03037439, .01764697, -.27453419, -.320173, .09908578, -.31891446, -.24626994, -.6515159, -1.0879259, .28282864, -1.0416812, -.62153817, 1.1185769, .77445081, -.42916624, .75727466, 1.0240687, -.29643247, -.34584272, .05465022, -.34447659, -.2125647, -.43005446, -.56105373, .14764261, -.55449628, -.37939902, 1.3035537, .86413849, -.53615763, .84026778, 1.2214062, -.00727818, -.00730541, .00444327, -.0073054, -.00777904, .50568017, .42080919, -.07849208, .41845109, .34240169, .13657359, .12810776, -.06811048, .12802037, .13645594, .27213105, .24419565, -.04711691, .24371883, .1910972, -.14401073, -.15511006, .04904375, -.15496764, -.12670714, -.37686308, -.47572429, .16942939, -.47144855, -.36374355, .49380072, .4177612, -.03477605, .41582054, .25692392, -.28516746, -.33369409, .08630964, -.33232458, -.24122913, .97391875, .69658602, -.40726979, .6837152, .91759819, -.21114652, -.23343958, .02756059, -.23304809, -.13494666, -.29165038, -.34397952, .10471634, -.34242316, -.26116993, -.58799905, -.82637479, .06098265, -.81063597, -.34806726, -.35016862, -.43149749, .13948816, -.4283766, -.32461899, -.24855748, -.28638194, .11620649, -.28542645, -.24305507, -.200873, -.22581347, .1416515, -.22529878, -.22526727, -.34760689, -.43057069, .17667238, -.42730057, -.34950909, .27784106, .24623086, -.11950815, .24563322, .26424501, -.46968014, -.63421204, .16478695, -.62477722, -.41736792, -.42899731, -.5617414, .16536614, -.55499416, -.39336457, 1.4741272, .92062396, -1.2549725, .88747771, 1.7602649, -.71867437, -1.3147704, .28797293, -1.238103, -.66754723, -.23630516, -.26771612, .06438934, -.26702239, -.19301755, -.69865357, -1.095912, .08057587, -1.0597512, -.42846917, -.20400243, -.22783466, .07890274, -.22737177, -.18726829, -.43507294, -.57736139, .2047588, -.5697285, -.42638205, .15163145, .14294262, -.01358769, .1428597, .08549054, -.18178759, -.20127684, .10274721, -.20092933, -.18936927, -.03970462, -.04048841, .01449916, -.04048583, -.03575622, .82309233, .62042315, -.20085387, .61223751, .64804093, -.08206623, -.08566274, .04166731, -.08563648, -.08248687, .23351298, .2094973, -.16347416, .20908661, .26123642, .15860602, .14748292, -.07042477, .14735304, .15245146, 1.6272688, 1.0189635, -.52624399, .98267852, 1.4072738, -.22717082, -.25504722, .04845067, -.25447862, -.17100611, .28653685, .25667722, -.036564, .25615987, .18175299, -.06460075, -.06706285, .08656299, -.06704721, -.08973168, -.62309338, -.94821141, .13582043, -.92091239, -.47246227, .80073602, .61230895, -.13591818, .60502432, .55859291, .54252045, .43717936, -.26000679, .43380193, .53491195, .10315753, .09825575, -.04769827, .09821694, .10050281, .24287792, .21804105, -.11237509, .21761873, .23667845, -.60679496, -1.017633, .52159417, -.97366697, -.72691264, -.51011918, -.72644897, .24094299, -.71153491, -.50052894, -.43564899, -.5752175, .17956829, -.56787922, -.40848649, .92055114, .68129428, -.17295236, .67111579, .66427938, -.25796805, -.29608321, .06963428, -.29514817, -.21005272, -.25954779, -.30800237, .3510023, -.30650352, -.3616248, -.59309259, -.91584086, .24492653, -.88764721, -.55646383, -.32028489, -.39380116, .26357164, -.39101263, -.37815269, -.40280123, -.51869574, .17653327, -.51320867, -.38548964, .84240279, .63857918, -.1315783, .63048471, .57159, -.28482944, -.33538536, .11730721, -.33389774, -.26699809, -.26469685, -.29909258, .02193167, -.29834988, -.14538951, -.16829622, -.18504933, .10711601, -.18477188, -.18239421, -.68122663, -1.181775, .28440964, -1.124054, -.64148403, -.04533664, -.04639939, .02243329, -.04639524, -.04517941, .29240118, .25983222, -.06324136, .25922929, .22113788, .46460339, .386555, -.15627043, .3843845, .40709007, -.03342123, -.03395251, .00861708, -.0339511, -.02680063, -.58233764, -.97883278, .74133018, -.93618291, -.79517698, -.3064705, -.37392751, .28431409, -.37147234, -.37658982, -.04459337, -.04551063, .0082021, -.04550749, -.03195203, -.36942726, -.4525769, .07394099, -.44948329, -.27226451, .48085019, .38595972, -.834553, .38286876, .72806111, -.54557937, -.75687435, .0868044, -.74352401, -.37247392, .48304522, .39320996, -.38772464, .39044886, .56560034, -.24937674, -.28868329, .14594659, -.28765513, -.26281205, -.18936532, -.21054859, .10276849, -.21015454, -.19460932, -.39239613, -.49923999, .15489548, -.49444712, -.36266534, .64937485, .51498667, -.13699943, .51040089, .48705713, -.4322005, -.56615195, .15731694, -.55933261, -.38879918, -.20355937, -.22802606, .09965492, -.2275372, -.20213289, -.21615618, -.24310274, .08121952, -.24254441, -.19652082, .07510881, .07273854, -.01211125, .07272608, .05150708, -.71129699, -1.2136775, .17291108, -1.1577944, -.55930871, .6737645, .53227367, -.12282293, .52737612, .48132885, -.29373897, -.34934204, .14356277, -.34759832, -.29151774, -.42744692, -.5608199, .1788832, -.55398534, -.40282955, -.39712056, -.52312548, .35588397, -.51656221, -.48238566, -.23751271, -.27111622, .09811775, -.27032661, -.22286939, -.03277917, -.03329781, .00965973, -.03329644, -.02748297, .26410406, .23514991, -.12046309, .23462228, .25614038, -.03434575, -.03491003, .00925617, -.03490848, -.02795133, .13494873, .12713604, -.0381914, .12706071, .11162918, .13203413, .124881, -.02372015, .12481645, .09386563, -.04551417, -.04654707, .0164027, -.04654316, -.04080809, -.05219991, -.05359129, .02212956, -.05358511, -.04940612, -.30252488, -.36302665, .16540026, -.36102338, -.3116708, -.51426378, -.75157197, .34771465, -.73383667, -.56868916, -.29887443, -.35190646, .0796393, -.35034647, -.24231389, -.09053879, -.09499873, .05072437, -.09496213, -.09403843, -.0300005, -.03044045, .01005493, -.03043937, -.02625561, 1.6115429, 1.0243185, -.36370126, .99008196, 1.2361927, -.156591, -.16938555, .0400831, -.16921153, -.12526843, 1.811829, 1.0941374, -.63649492, 1.0490886, 1.610719, -.49368734, -.6757864, .14772967, -.66480961, -.41603886, -.02370091, -.02395868, .00473214, -.02395822, -.0174531, .04561786, .04461905, -.02129833, .0446154, .04458771, -.26417627, -.30595708, .09429969, -.30486051, -.23610723, -.0931778, -.09753532, .02606962, -.09750137, -.07678267, .28507257, .25241947, -.1046605, .25179795, .25718239, .28034666, .24551492, -.28948403, .24479617, .35701116, .53782825, .44234603, -.09356962, .4395423, .37828346, -.61897765, -.97253054, .21661137, -.94021132, -.54956668, .78421678, .60406353, -.11669902, .5972591, .52358816, -.03882953, -.03957842, .01413856, -.03957601, -.03493439, -.06523687, -.06717864, .00964069, -.06716901, -.04345517, -.21282534, -.23992597, .1078811, -.23935247, -.21379982, .90192707, .66502038, -.23618664, .65483939, .72701392, .38244456, .3281245, -.1068623, .32684464, .31501446, .18015634, .16623594, -.06756239, .1660569, .16368593, -.36356599, -.4638294, .30871312, -.45927525, -.43376103, -.09210566, -.09668124, .04745514, -.09664337, -.0930312, .17131159, .15900884, -.04825369, .15886175, .1414853, .49760355, .41055199, -.14611893, .40803251, .41671053, -.26615826, -.30743391, .07708907, -.3063715, -.22187118, -.3927741, -.49119506, .09098666, -.48712552, -.30392363, -.09436583, -.09907181, .04037083, -.09903271, -.08958647, -.46225941, -.62276812, .17801784, -.61364244, -.42372915, -.68894344, -1.1023655, .11421352, -1.0627932, -.47683876, .54551863, .44161588, -.1962092, .43834684, .4887906, -.45635762, -.61845001, .2243287, -.60902965, -.45377631, .51392807, .42380904, -.11608231, .42119474, .39433643, -.49514556, -.65991554, .08047553, -.6509263, -.3404499, -.4747132, -.64891854, .19645604, -.63846945, -.4457103, -.26195285, -.29994651, .05379271, -.29903144, -.19471522, -.6243963, -.99875786, .24995553, -.96295355, -.57979055, -.40910507, -.53396084, .22267832, -.52769928, -.4208486, -.2342998, -.26726459, .10501295, -.26649427, -.22591179, 2.4407724, 1.317305, -1.1861326, 1.237361, 2.4177196, .48137182, .39179562, -.40147968, .38904091, .57088894, .88347144, .63016669, -.98224625, .61833459, 1.1531305, -.37748634, -.47241194, .12786077, -.46847326, -.33153033, .6029886, .47870953, -.23536225, .4744856, .55521561, .25692875, .2299286, -.09565444, .22945687, .23287356, -.02006736, -.02023643, .00185917, -.02023619, -.01144046, -.10153493, -.10651411, .01952647, -.10647343, -.07384054, 1.0620669, .75307903, -.27944874, .73844545, .85745625, .30155225, .26708188, -.06531001, .2664271, .22816287, .17414172, .16255392, -.01972152, .16242552, .10615131, .04052029, .03973302, -.01811988, .03973047, .03904003, .0995454, .09467985, -.08338736, .09464023, .11822905, -.1098009, -.11547485, .01617159, -.11542601, -.0730575, -.44427463, -.6062158, .32152264, -.59656536, -.50255261, -.33979962, -.40986904, .08038145, -.40747774, -.26477513, -.6619722, -.98266748, .05866829, -.95756575, -.37185274, .04999817, .04877268, -.02928264, .04876768, .05270472, -.1508781, -.16430411, .10638183, -.16410528, -.16919335, .43989814, .37692724, -.0381013, .37543202, .24522121, .33284499, .28780745, -.18836734, .28679605, .34687517, .19602769, .18000773, -.06084173, .17978985, .16722023, -.4337603, -.57396928, .19590909, -.56653304, -.41930309, .00823044, .00819827, -.00273524, .00819824, .00718275, .89286471, .65491122, -.31419723, .64454243, .79420855, -.485029, -.66434467, .17236992, -.6535117, -.43285486, -.19591362, -.22008743, .16508003, -.21959164, -.23314061, .29846968, .2648503, -.06051499, .26422096, .22091802, -.51177164, -.7090097, .14101934, -.69660593, -.4195854, -.08107079, -.08478746, .06715827, -.08475907, -.09592963, -.51330833, -.7044032, .11384153, -.6927808, -.39146756, -.28434784, -.34314381, .3405642, -.34113181, -.38046054, -.22041142, -.25004037, .12217904, -.24937866, -.22812084, -.28288225, -.33456338, .15166649, -.33299857, -.28954118, -.38045734, -.48755831, .24374344, -.48259472, -.41322979, .02184406, .02163048, -.00460415, .02163014, .0163788, .55876591, .45226093, -.16342586, .44890758, .46730833, -.08268958, -.08625577, .03425598, -.08623014, -.07766451, -.24595302, -.28107306, .07941274, -.28024022, -.21258935, -.20771709, -.23236015, .07678811, -.23187411, -.18782618, .07956144, .07648132, -.05316748, .07646146, .08763827, -.11617647, -.12358576, .05869661, -.12350707, -.11658064, .69686488, .5196206, -1.1872426, .51223505, 1.0486298, -.58188967, -.86594781, .17081948, -.84355226, -.48724743, 2.0124807, 1.144415, -1.4286583, 1.0858262, 2.2619028, .59690036, .47855196, -.15696886, .47467906, .4818173, .36272796, .31308576, -.1075188, .31195833, .30471383, .03595038, .03534871, -.01187403, .03534703, .03130966, -.22580188, -.25143769, .02816139, -.25095373, -.14213895, -.38006128, -.47956806, .15642695, -.47527259, -.356191, 1.1166041, .76410384, -.64917324, .74608095, 1.1741665, .20199822, .18591811, -.03661377, .18570506, .14403118, -.32867868, -.4062999, .25813875, -.40327202, -.38206925, .05677936, .0553442, -.01411033, .05533815, .04497619, -.36806787, -.454488, .1005, -.45113609, -.30085043, -.53506292, -.79438171, .32265847, -.77407627, -.56954441, .19071785, .17381953, -.17391407, .17357042, .23301424, -.51589241, -.74151215, .25824814, -.72549233, -.51609362, -.03413597, -.03468197, .00768145, -.03468051, -.02615969, .08910428, .08519312, -.07159331, .08516452, .1043678, .35987379, .30913411, -.16000503, .30794728, .34606262, .18489821, .17040005, -.06371003, .17021083, .16331813, 1.3405019, .88402, -.50635538, .8589904, 1.2208813, -.46237474, -.60429991, .08655541, -.59714239, -.3332505, .4514692, .38508298, -.04198612, .38346423, .25770965, .41235874, .34998624, -.11971637, .34842228, .34401548, -.30686678, -.36928716, .16563904, -.36718543, -.31479717, 1.0163954, .70515236, -.86009015, .68968476, 1.2112481, -.24796447, -.28380914, .0814219, -.28294869, -.21553446, .24538016, .22206756, -.04780098, .22169915, .17921812, -.4291345, -.58654611, .43946985, -.57710826, -.54498178, -.39186361, -.51057574, .30062526, -.5046651, -.45196879, .79404903, .60254896, -.2020656, .59496774, .6339753, -.36717171, -.44859111, .07036081, -.44560604, -.26670618, -.62796841, -.97958516, .17653188, -.94803646, -.51829408, -.40685157, -.52591145, .18066974, -.52018042, -.39107718, .31378064, .2751345, -.1068019, .27434394, .27602839, -.5145653, -.72052957, .16563167, -.70709631, -.44430867, -.44366138, -.57130426, .08146556, -.56526133, -.31771357, -.09743412, -.10210125, .02230239, -.102064, -.0750933, -.67463913, -1.1652336, .2955002, -1.1091912, -.64552085, -.0532977, -.05477754, .02666406, -.0547707, -.05330784, .01125144, .0111872, -.0069488, .01118714, .01207217, 1.0424593, .7658664, -.08546767, .75386482, .57058019, -.23966601, -.27400878, .10024656, -.27319153, -.22582436, -.15102731, -.16293533, .04024455, -.16277902, -.12244734, .10883711, .10360373, -.03484788, .10356181, .09381093, -.63749651, -1.0657947, .34067459, -1.0202847, -.65179114, .21462438, .19252866, -.32449832, .19215043, .31036079, .28543484, .25359926, -.07780585, .25300912, .23317684, .60037273, .47535329, -.27759935, .47106133, .58492043, -.64629577, -1.0650438, .26333326, -1.0220094, -.6036698, -.24043518, -.272045, .05163505, -.27135449, -.18140818, -.43766527, -.5607036, .07881634, -.55500896, -.31139393, -.10886067, -.1144656, .01680504, -.11441753, -.07357617, -.21659505, -.24163923, .04517702, -.24115776, -.16183839, .24558099, .21864978, -.21619087, .21815888, .29654159, .87538756, .6420736, -.36843874, .63190621, .82654279, .03268513, .03214741, -.02171152, .03214594, .03593136, -.33085539, -.39571874, .07053734, -.39361288, -.24902435, -.54252751, -.80913275, .30893409, -.78798062, -.56656071, -.29883582, -.34835188, .04910994, -.34699085, -.20623145, .82533579, .60997673, -.43779671, .60078017, .84175935, -.08115594, -.08467064, .04121902, -.08464528, -.08158108, -.30067698, -.35725161, .11424508, -.35548796, -.27438221, .06741546, .06518607, -.04474214, .06517379, .07408926, 1.003046, .72197825, -.25434616, .70913157, .79989373, -.58070163, -.84229962, .11654776, -.82319219, -.42836436, .75923582, .58481682, -.15124806, .5782288, .55867306, .0059764, .0059584, -.00334034, .00595839, .0062025, -.53090015, -.75600972, .17492552, -.74049255, -.46199395, -.22335222, -.25544049, .17958825, -.25467492, -.26167535, -.22948451, -.25824195, .05233589, -.25764301, -.17664938, .30963181, .27345875, -.06687207, .27275659, .23405719, 1.0611246, .74180213, -.46722051, .72619033, 1.0170951, -.29408863, -.34962585, .13988706, -.34788828, -.28923754, -.25860882, -.30081882, .14020602, -.29967581, -.26568138, -.22592201, -.25446235, .06302462, -.25386314, -.18598836, -.3826994, -.47233224, .07239276, -.4688642, -.27678777, .01947673, .01928047, -.01518198, .01928014, .02258379, -.38497259, -.48883332, .17038615, -.48421616, -.36963631, -.08148694, -.08518986, .05985012, -.08516183, -.09263114, -.04295891, -.04403539, .06160084, -.0440309, -.06103436, -.01471251, -.0148122, .00320525, -.01481209, -.01115378, .71449982, .53710627, -.69745866, .52988413, .89299886, .08013108, .07729919, -.02108105, .07728251, .06469063, .5593455, .44200533, -.53719308, .43794786, .69530214, -.29161723, -.34587494, .13500442, -.34420219, -.28422882, -.3444663, -.41820437, .09269602, -.41559328, -.28019574, .81332359, .62275131, -.11332632, .61541416, .53124621, -.23053501, -.26431372, .16104974, -.2634919, -.25772384, -.61349953, -.9545587, .20593769, -.92416238, -.53719435, .9104401, .6520594, -.66452249, .64010651, 1.032795, -.05516897, -.05661534, .01231837, -.05660902, -.04216878, -.56883995, -.87662871, .33321132, -.84988566, -.59966676, -.36478423, -.45367681, .13740888, -.45010064, -.33192424, -.1586423, -.17112781, .02675512, -.17096423, -.11043115, -.38205142, -.4887402, .22432994, -.48383445, -.40307602, .49535731, .41246085, -.08944291, .41016421, .35275325, -.06313745, -.06522226, .03054947, -.06521079, -.0624505, .34982979, .30320269, -.10692491, .30217114, .29689815, -.67251333, -1.1316017, .2367678, -1.0821006, -.59829882, -.59172716, -.97634716, .54039043, -.93670332, -.72331402, 1.8266434, 1.0903129, -.82764403, 1.0433883, 1.7676396, -.24588016, -.28664541, .23477248, -.28552426, -.3050526, -.5845798, -.88896881, .22408002, -.86346038, -.53502439, .13148771, .12328602, -.09816614, .12320082, .15028675, 2.4346548, 1.3699725, -.41157278, 1.2972916, 1.6960962, .36246503, .31062852, -.17737731, .30939885, .35987645, 1.3994869, .91006275, -.55827647, .88256762, 1.2979929, -.45624974, -.60016264, .1132157, -.59270962, -.36122736, -.25496413, -.29439606, .10658785, -.29338385, -.24019574, -.05767819, -.05933659, .01916141, -.05932864, -.05032999, -.80431809, -1.602386, .2093638, -1.4822075, -.64703695, 1.5617118, 1.0233385, -.18272086, .99348606, .96236533, -.70968552, -1.3600232, .44467442, -1.2686575, -.76512902, .64399969, .50980783, -.15969945, .50519804, .50976292, -.42577082, -.56001156, .19633848, -.55306239, -.4144407, .19852298, .18141046, -.09500672, .18116502, .19564494, -.01755235, -.01770992, .00953801, -.01770969, -.01804622, .71490024, .54777169, -.30852084, .54135133, .68066767, .25055792, .22421576, -.11747822, .22375532, .24524559, .7455487, .56404977, -.37980282, .55679912, .7502052, -.46599585, -.64242384, .27075063, -.63151757, -.48991551, 1.2948213, .83888233, -1.1669167, .81310832, 1.5757834, .37068888, .31372161, -.33695531, .31227059, .45241863, -.40780079, -.51476393, .09005722, -.51013837, -.31056193, .04838708, .04727737, -.02046467, .04727313, .04576124, -.65958483, -1.0877235, .22545378, -1.04365, -.5810448, -.41448109, -.51966116, .06413362, -.51525789, -.28035506, -.53221661, -.77934505, .27260226, -.76076586, -.53651117, .37895608, .32426337, -.13780978, .32295415, .34079714, -.35423027, -.44100622, .17977977, -.4374971, -.35599786, .43251987, .36024553, -.26019905, .35824609, .46002624, -.1780144, -.19759107, .14782681, -.19723303, -.21081321, -.00010377, -.00010378, .00002836, -.00010378, -.00008485, -.15775022, -.17083021, .04249013, -.17064969, -.12835694, -.05827104, -.06000977, .02430356, -.06000112, -.05485318, 1.1849863, .83572134, -.14128063, .818976, .73481794, -.59052793, -.96984829, .52299476, -.93117582, -.71450083, .9399917, .68377155, -.28694805, .67236428, .7974322, -.44002698, -.57087568, .10634001, -.56447783, -.34532533, -.21863606, -.24528179, .0624941, -.24474199, -.1814558, .56326566, .46109889, -.08372362, .45803496, .37592526, -.07591432, -.07896422, .03725001, -.0789438, -.07543992, -.77818641, -1.6795659, .42244103, -1.5246549, -.79981177, -.04399159, -.04503607, .03189906, -.04503194, -.04979462, -.1002894, -.10618355, .09715338, -.10612585, -.12502571, -.46154278, -.65298739, .47775225, -.64006615, -.58823684, .19297036, .17688747, -.08435038, .17666441, .18451545, 1.2567799, .84235571, -.50274465, .82029379, 1.1667164, .23807226, .21413629, -.110251, .2137361, .23206521, -.63972256, -.9226105, .04888754, -.90231089, -.34203496, -.65083021, -1.0839922, .27791095, -1.0383617, -.61748113, .01714389, .01700946, -.00427506, .01700929, .01359556, -.1753322, -.19645065, .33425428, -.1960278, -.2739114, 1.1513607, .79169637, -.43119065, .77348673, 1.0456204, -.48785477, -.68179512, .24456376, -.66922912, -.48827865, .21072881, .19254487, -.05959303, .19228378, .17427073, .35612601, .30303134, -.3278876, .30171888, .43650323, -.27023169, -.3144702, .10075437, -.31326871, -.24505043, .61318693, .48210992, -.3274334, .47749362, .62677681, .41111143, .33301644, -1.8253585, .33056576, .85133226, -.19481353, -.21503613, .04602194, -.21468694, -.15173218, -.03987817, -.04063046, .0094143, -.04062809, -.03105247, -.10009869, -.10514249, .027462, -.10510015, -.08194824, -.11716349, -.12448007, .04615095, -.12440397, -.10820942, -.17640093, -.1928184, .04341165, -.19256414, -.13927698, -.73754475, -1.344323, .22748136, -1.2668483, -.62784271, -.06202451, -.06398783, .02451098, -.06397748, -.05734634, -.21830102, -.24652744, .09873847, -.24592095, -.21112644, -.42028158, -.55096001, .20057009, -.54428635, -.41380172, .27692872, .24786499, -.05178603, .24735786, .19952295, -.16056965, -.17558293, .09551896, -.17534935, -.17014355, -.06538395, -.06758339, .02707714, -.06757106, -.0614033, .40472269, .34596206, -.08711496, .34454716, .30559479, -.01948248, -.01970221, .0312953, -.01970179, -.02874744, -.74044391, -1.4313084, .33547729, -1.332702, -.71651588, -.00959026, -.00963341, .00254421, -.00963338, -.00776392, .58290382, .46866275, -.16430017, .46496644, .48152696, .78990971, .5990838, -.21558183, .59151686, .64555366, -.60878353, -.904121, .11544082, -.88097363, -.44066146, -.19234382, -.2135101, .07997263, -.21312274, -.18087392, .09349877, .08945988, -.04175847, .08943082, .09004552, -.56760591, -.82023065, .13154508, -.80199044, -.43927128, -.18688935, -.20644692, .06830505, -.20610648, -.16835162, .13621984, .12805562, -.04984456, .12797412, .12275603, 1.0490177, .72713028, -.68918444, .71110319, 1.1489744, -.45100013, -.59470485, .13184149, -.58718889, -.37711905, .13526372, .12645504, -.12005451, .12635952, .16377856, -.28818669, -.33167944, .03350251, -.33058978, -.17720872, -.13060375, -.1398183, .0524589, -.13971005, -.12140973, .9378045, .67753716, -.3788192, .66574952, .87343154, .27098326, .24004014, -.15183279, .23945297, .28146658, -.33485349, -.3970462, .04412781, -.39513215, -.21469273, .6194375, .49775346, -.10398783, .49380734, .43052909, -.14296602, -.15368801, .04171745, -.15355413, -.11947338, .43258663, .35935961, -.30280431, .35730782, .48392651, .37175276, .31861271, -.14411522, .31735271, .34151995, -.32665016, -.38884006, .06387642, -.38687864, -.23887944, -.42561232, -.55795914, .18142126, -.55119973, -.40356688, -.35105423, -.42195308, .05378071, -.41958271, -.23666551, -.02320392, -.02345492, .00534224, -.02345447, -.01791811, -.33682582, -.40497783, .0758356, -.4026951, -.25816932, -.12414077, -.13332723, .11586673, -.13321404, -.1528525, 2.3019877, 1.257505, -1.3917948, 1.1840291, 2.4524702, -.17247345, -.18734391, .02840135, -.18713052, -.11910715, .08731105, .08419405, -.01168084, .08417551, .05626188, -.26263879, -.30489683, .11180706, -.30376866, -.24892718, -.2910695, -.35171965, .29755042, -.34962839, -.36942645, -.72868997, -1.3252187, .2462431, -1.2493896, -.63947939, -.12607099, -.13517712, .08419329, -.13506761, -.13883936, -.303988, -.36124323, .1053936, -.35945659, -.269062, -.4509924, -.60030839, .16495918, -.59220241, -.40636377, .34727781, .30690118, -.02535243, .30612116, .18286666, -.64879747, -.98327508, .09287628, -.95550747, -.42761313, .06005547, .05833297, -.02946512, .05832474, .05967803, .11741206, .11047067, -.14296951, .11040233, .15796697, -.08041936, -.08379401, .03396093, -.08377041, -.07601692, 1.7225341, 1.03418, -1.1239065, .99064126, 1.8823424, -.10868496, -.11435385, .01896727, -.11430459, -.07652287, -.31637263, -.37839743, .10091835, -.37638371, -.2723533, -.20938853, -.23213658, .0367331, -.23172556, -.14768321, -.28102192, -.32840365, .09088428, -.32707863, -.24303364, -.13782043, -.14790602, .04587562, -.14778313, -.12034084, .10434784, .09932503, -.04931338, .09928476, .10240486, .45772778, .38254781, -.13504668, .380503, .38392184, -.11546231, -.12233721, .03505027, -.12226903, -.09776887, -.44973591, -.58508369, .09599035, -.57838802, -.33862907, .16888733, .15759416, -.02645707, .15746842, .11470666, .32593828, .28649726, -.06498227, .28570446, .2399009, .27186575, .24233951, -.08641709, .24180647, .23376503, .12746131, .1202375, -.04891426, .12016931, .11670087, -.5525436, -.79779884, .16088526, -.78013652, -.4614165, -.33745452, -.41627007, .19449844, -.41322893, -.353828, -.38523263, -.47686709, .07595916, -.47326717, -.2825002, -.29919216, -.35416709, .10080245, -.35249308, -.26230134, -.32859982, -.39187088, .06583404, -.38985297, -.24225443, 1.2230258, .85610896, -.14322376, .83822182, .7538856, -.59484282, -.91957581, .24273238, -.89112381, -.55588811, .22316516, .20054443, -.20153153, .20016315, .27177443, -.34353237, -.42417631, .17430392, -.42104902, -.34521593, 1.0013204, .70813496, -.49237704, .69416568, .99576753, 1.286023, .85588024, -.52633007, .83267972, 1.2029896, -.14232183, -.15297857, .0427016, -.15284572, -.12004362, -.11923524, -.12690099, .05092533, -.12681891, -.11313345, .07967895, .07688418, -.02053429, .07686785, .06388501, -.5240686, -.76737404, .30816235, -.74908509, -.55317424, -.57784358, -.86110674, .1843253, -.83868528, -.49744512, -.32958216, -.40011504, .13174724, -.39761812, -.30589072, .41448584, .34574843, -.33455967, .343861, .48622915, -.32944976, -.41067335, .33465253, -.40736804, -.41725431, -.09503026, -.09919597, .012917, -.09916555, -.06156092, -.42105309, -.55299201, .20696821, -.54620281, -.41866737, -.07923867, -.08247432, .03034594, -.08245231, -.07249949, -.16577435, -.17985874, .03469311, -.17965957, -.12400407, .19949934, .1827653, -.06902931, .18253172, .17646103, -.43920686, -.57872277, .16003694, -.57144777, -.39524175, -.56513879, -.84885229, .24699657, -.82588278, -.54035235, -.06286303, -.06491442, .02858863, -.06490327, -.06090758, .92549746, .67323857, -.32473992, .6620081, .82244219, -.38988726, -.47979843, .05636151, -.47637231, -.2578083, .09979014, .09573364, -.01384403, .09570617, .06508626, .09280064, .0889795, -.0279896, .08895329, .07841086, -.46107866, -.59994216, .07899674, -.59306763, -.32264856, .83347527, .60020541, -1.0995866, .58955563, 1.1517236, .27905983, .24569371, -.19753739, .24503095, .31334636, -.63810006, -1.0087097, .18285623, -.97429886, -.5300365, -.17291354, -.18879898, .04598416, -.18855612, -.14009805, -.51416831, -.73501209, .24166843, -.71959983, -.50367861, -.11603496, -.12331911, .05205844, -.12324295, -.11191791, .25114639, .22198601, -.33394605, .22142343, .34795258, -.35430121, -.44161092, .18647538, -.43805958, -.36041173, -.4297934, -.56245513, .16054818, -.55572832, -.38998834, -.24832551, -.28509038, .09585265, -.28418665, -.22780274, -.5430595, -.8236341, .38944718, -.80029361, -.61243189, .14951981, .14066735, -.02096909, .14058006, .09787438, -.26030761, -.30529244, .19969441, -.30400333, -.3002317, -.41187027, -.5222738, .09534316, -.51739668, -.31862522, .40355256, .33678618, -.40298382, .33495712, .5082054, -.75255175, -1.3894944, .21360879, -1.3060837, -.62312324, -.35507276, -.43263695, .08326328, -.42983496, -.27587102, -.72634868, -1.3135867, .24178343, -1.2397681, -.63423315, 1.1376892, .77830075, -.56460273, .75991464, 1.1348542, .0124268, .01235574, -.00318039, .01235567, .00994053, -.17977795, -.19706609, .04822297, -.19678947, -.14607826, .13164445, .12436625, -.02962392, .12429923, .10088484, 1.6590308, 1.0177654, -.82102101, .97836656, 1.6533484, .35423886, .30348345, -.21771826, .30227719, .37946561, -.39745053, -.50183363, .1115254, -.49731392, -.327836, .16236895, .15037561, -.09838355, .15022813, .17310893, .6958186, .53635626, -.29431717, .53034734, .6580808, -.46773645, -.6351434, .19230175, -.62534201, -.43819951, .10162678, .09719379, -.0235417, .09716157, .0786372, 1.2254236, .83616209, -.33996754, .81614444, 1.0069625, -.44736095, -.58481213, .11337566, -.57787362, -.35668813, -.53040638, -.77530138, .27230976, -.75698926, -.53510239, -.20596997, -.22932212, .05814066, -.22888187, -.17023123, .52440326, .4238883, -.29085357, .42070618, .54284818, -.27039535, -.31848645, .18037432, -.31706852, -.29766953, -.18413097, -.20127687, .03093094, -.20101119, -.12800461, .2078039, .18889883, -.11508173, .1886127, .21500469, -.55328036, -.78200973, .11006953, -.76662156, -.4069389, -.31123454, -.37880878, .22941672, -.37638232, -.3542231, -.65927093, -.99075659, .0725532, -.96387989, -.39805047, .07618853, .07372323, -.01368779, .07370993, .05416444, -.32168303, -.39510162, .24521041, -.39233234, -.37023295, -.52044113, -.72706987, .1447913, -.71369831, -.42806058, -.19292174, -.21699692, .20331068, -.21649757, -.24735319, -.37437819, -.47321524, .1859494, -.46891375, -.37354989, .58338252, .47340146, -.10114556, .46997579, .40985278, -.31178488, -.3671897, .05737334, -.36555753, -.22343443, -.44979931, -.62005397, .35883752, -.60953178, -.52559974, .29013402, .25421375, -.21161293, .25347515, .32904591, -.0471581, -.04825397, .01517686, -.04824973, -.04071692, -.39545673, -.49608618, .09505087, -.49186199, -.30978568, .54435985, .45148952, -.05282739, .44886723, .31517645, .13502896, .12765483, -.02143779, .12758775, .09212014, -.3240423, -.3860241, .07033396, -.38406021, -.24535759, .0219324, .02171037, -.00612701, .02170999, .01806413, -.13135208, -.1397574, .02259516, -.13966782, -.09203926, .35984601, .3131645, -.06318754, .31215909, .25388182, -.53692255, -.78844182, .26544966, -.76937333, -.53490725, .99283801, .71110543, -.33171189, .69807369, .86799243, -.30811339, -.36535786, .08606506, -.36359554, -.25376166, .35941228, .30921429, -.14533974, .30805106, .33486267, .46119255, .38419514, -.15408706, .38206689, .40319974, .25617752, .22887855, -.11355209, .22839493, .24609477, .3881024, .33229798, -.10916489, .33096708, .32038232, -.01142538, -.01148719, .00325243, -.01148713, -.00946949, -.0663644, -.06831127, .00741754, -.06830176, -.04027665, -.31479598, -.3845116, .23897448, -.38195885, -.36180949, .13188749, .12507852, -.01495072, .12501997, .08042043, .05560787, .05414142, -.02479536, .05413498, .05352512, .030057, .02968142, -.00338286, .02968064, .01828388, -.60764607, -.92798542, .17422059, -.90082532, -.50482821, -.49611384, -.65425635, .06163571, -.64598206, -.31189496, .19595611, .17969821, -.07121758, .17947373, .17618879, -.53300603, -.79124424, .33222942, -.77102963, -.57364618, .21233509, .19291969, -.10206777, .19262435, .20956595, -.12690115, -.1343304, .01431673, -.13425796, -.07725649, -.32844644, -.40427048, .22379228, -.40137809, -.36413974, -.14290203, -.15448587, .07820742, -.15432956, -.14727134, .79360616, .58955236, -.48783917, .58096063, .8501696, -.02949369, -.02992309, .01081226, -.02992205, -.0265951, .27831796, .24559747, -.16801173, .24495834, .29635848, 1.0478477, .76214648, -.12083589, .7494232, .64260005, .06339373, .06158523, -.0181729, .06157663, .05266421, -.5938279, -.89957497, .18744172, -.87422318, -.50941588, .03644298, .03580721, -.01562572, .03580536, .0346231, -.49944896, -.6882761, .15428926, -.67661922, -.42538546, -.68855705, -1.1334562, .15684956, -1.0878507, -.52982329, -.08804256, -.09199457, .02906246, -.09196501, -.07666242, 1.9829382, 1.1470288, -1.0173005, 1.0916852, 2.0000117, .16729735, .15551127, -.04810313, .15537303, .13912136, -.6912127, -1.1040963, .10905673, -1.0647441, -.47058199, -.65126541, -1.1420625, .44827384, -1.0841523, -.72448568, -.18475545, -.20375577, .06541737, -.20343072, -.16467937, -.07713194, -.07963294, .00526849, -.07961942, -.03972479, .01740949, .01725609, -.0109489, .01725586, .01879278, 1.2196292, .85291889, -.15144619, .83500453, .7666221, -.22496394, -.25705245, .16083384, -.25629232, -.25344151, -.36823714, -.46294364, .17993716, -.45892631, -.36542816, 1.2520815, .81943768, -1.1127505, .7953967, 1.5166929, .5370179, .42882249, -.44677811, .42522593, .63635551, -.45893868, -.62841097, .26653623, -.6181842, -.48242728, 2.0020663, 1.154226, -1.0311665, 1.0978758, 2.021957, -.66655028, -1.1886375, .42913662, -1.1248503, -.72515437, -.5154665, -.75240451, .33467992, -.73476249, -.56236746, .11044802, .10446565, -.09872336, .10441168, .13404643, 2.1970641, 1.2481317, -.72708268, 1.1840148, 1.9146957, -.25675981, -.2990706, .15898926, -.29791395, -.27572996, -.25669536, -.29556425, .08661654, -.29458722, -.22515881, .52513525, .4277973, -.19081609, .42481538, .47213092, .15974061, .14921456, -.03568551, .14909907, .12211926, -.52570614, -.79242904, .4633627, -.77061806, -.63505653, .80623824, .58389749, -1.1584851, .57388804, 1.1462581, .03130321, .03083991, -.01157539, .03083876, .02830834, -.10999839, -.11631162, .03812945, -.11625126, -.09735414, -.46938615, -.62540527, .12257532, -.61690292, -.37800528, -.45977529, -.62819148, .25115588, -.61810743, -.47353804, -.24400514, -.29017483, .63139896, -.28872754, -.42206299, -.22238072, -.25076942, .07736622, -.25016715, -.197057, .41225613, .35139209, -.09092106, .34990208, .31381684, .90104234, .65879176, -.33084962, .64814686, .81292475, 1.4268219, .9417433, -.29915977, .91518567, 1.0679664, -.01131892, -.01138296, .0052341, -.0113829, -.01102793, -.26064096, -.29777716, .04913562, -.29689842, -.18829434, -.35225204, -.43891739, .19332433, -.43539782, -.3633634, .27755578, .24944605, -.03488256, .24897266, .17516458, -.05249628, -.05408881, .06457515, -.05408076, -.07086811, .15270366, .14295055, -.03751237, .14284682, .12049466, 1.6640434, 1.0233537, -.74645815, .98412553, 1.6049257, .40173966, .34399464, -.08248412, .34261792, .29860467, -.2012955, -.22591292, .12425093, -.22541249, -.21593975, -.55241944, -.81052705, .20869867, -.79100738, -.50314813, 1.2167787, .81596409, -.64037158, .79464724, 1.2377371, .31859384, .2793104, -.0957355, .2785059, .26885983, .33521642, .29137558, -.12189482, .29042371, .30145462, .35923737, .31063323, -.10219573, .30954184, .29767469, .49244921, .3958823, -.63755836, .39275613, .67622457, 1.0662749, .74466625, -.46536687, .72890881, 1.0190323, .23051376, .20778465, -.11628489, .20741193, .23119707, -.05407944, -.05548359, .01328741, -.05547751, -.04267546, -.62813954, -.98581439, .18994331, -.95321309, -.53119677, -.18373719, -.2011591, .03627741, -.20088423, -.13479904, .18184522, .16675393, -.12985588, .1665455, .20478515, -.31872585, -.37518492, .04704902, -.37352689, -.21222916, .84887233, .62383422, -.43685389, .61407755, .85707136, -.05261579, -.05387151, .00796703, -.05386652, -.03533347, -.50035039, -.71049219, .26736812, -.69613862, -.51155936, -.46632367, -.61629176, .1065549, -.60837729, -.35919155, -.41396762, -.52929026, .11631992, -.52400002, -.34161659, .56533161, .45487973, -.20191777, .45131692, .50536329, -.25961398, -.30166258, .12862217, -.30053261, -.25882168, .14486225, .13424498, -.22657748, .13411544, .21186167, -.56682674, -.86925212, .32130125, -.84331965, -.59103657, .5047258, .41021238, -.29671218, .40728788, .53271157, -.43155757, -.55417099, .09413043, -.5484369, -.32729987, .34146008, .29564578, -.1397251, .29462552, .31939499, .59808647, .48391487, -.09662502, .48031482, .41040803, .2006377, .183359, -.08645239, .18311139, .1909314, .44366264, .36673917, -.32881307, .36453234, .50585757, -.35790142, -.43681098, .08310658, -.43393424, -.27716013, -.49074253, -.68009252, .1985023, -.66817166, -.45726466, .20408678, .18766665, -.03758255, .18744678, .14629023, .92820989, .65798031, -.82939554, .64517405, 1.1264053, -.14206865, -.15283617, .047763, -.15270031, -.12446275, -.17969653, -.19767623, .06598571, -.19737695, -.16212616, -.47137633, -.61977806, .0862388, -.61210679, -.33714968, -.28911174, -.34384457, .16312479, -.34212796, -.30099582, -.00763281, -.00766442, .00752714, -.0076644, -.00957215, .34143269, .29614602, -.12301585, .29514894, .30610265, 2.0719664, 1.2126712, -.52023762, 1.1565606, 1.6468943, -.11800533, -.12555996, .05344356, -.12547942, -.11417636, -.66888109, -1.1786054, .37739535, -1.1178522, -.69637225, .00530837, .0052956, -.00113352, .00529559, .00399755, .15362842, .1433758, -.05533638, .14326187, .13771924, .42707403, .35920849, -.15986646, .35742182, .38779115, -.46487744, -.65646177, .43587838, -.64361114, -.57326763, -.01626688, -.01640278, .00924814, -.01640259, -.01697843, -.027476, -.02784189, .00868304, -.02784108, -.0235796, .19189844, .17681613, -.04846485, .17661883, .15282694, .22330594, .20058569, -.20863098, .2002013, .27504459, .11559231, .10934324, -.06731977, .10928697, .12162145, -.47747168, -.62350706, .06552056, -.61616792, -.31028988, .8575602, .61127476, -1.2773277, .5997524, 1.2339205, -.24769378, -.28838884, .20749059, -.28727965, -.29418433, -.16802838, -.18300456, .04553388, -.18278242, -.13699666, .15586551, .14451023, -.11872882, .14437251, .17934753, -.39223346, -.50201694, .1843519, -.49695755, -.38422796, .80113557, .59491977, -.45929526, .58622787, .83851595, -.24191424, -.27667143, .09486526, -.27584213, -.22309338, .18432121, .16997179, -.0607232, .16978585, .16039042, -.40278614, -.52507026, .24440944, -.51896897, -.42963435, .19255907, .17757771, -.04252925, .17738371, .14664994, -.0972408, -.10219865, .03820438, -.10215654, -.08973187, -.30184289, -.35995233, .12973145, -.35809935, -.28699813, -.80655346, -1.6474722, .23707035, -1.5153139, -.67565426, -.36549402, -.45446948, .13440814, -.45089353, -.32991751, -.35756411, -.45140667, .25876731, -.44734612, -.40446637, .47443587, .39805103, -.0802688, .39601394, .33060589, -.64139492, -1.0346158, .22190249, -.99622053, -.56730211, -.35327017, -.4485241, .33766234, -.4442919, -.43843867, .38580316, .32347057, -.43729991, .32180248, .50681211, -.45169795, -.60091255, .1608026, -.5928297, -.40334168, .99548762, .72054504, -.2191243, .7081499, .75729325, 1.8464371, 1.1114614, -.59910169, 1.0651319, 1.5985756, .39118858, .33428279, -.1169012, .33290991, .32951392, -.26737891, -.31403027, .17241748, -.31268067, -.29104169, -.35472347, -.43250975, .08609581, -.42968906, -.2787815, .20292213, .18425357, -.15632118, .18396786, .2343701, .38315112, .3261751, -.17731209, .3247703, .37339587, -.4203798, -.53885631, .11049479, -.5333593, -.33927498, -.39280184, -.50479736, .20418445, -.49954177, -.39792378, .01409337, .01399707, -.00585487, .01399697, .01324928, -.6652952, -1.0134974, .08156506, -.98417555, -.41640983, .34348687, .29084513, -.60061687, .28950793, .52137387, .09977508, .09541015, -.02804863, .09537833, .08234969, .32918421, .28875075, -.07066353, .28792585, .24833301, -.49353903, -.6871202, .20734724, -.67473867, -.46571878, .77392484, .60155546, -.08642675, .59523764, .46956088, .11597648, .10966911, -.06949822, .10961197, .12319163, -.22418407, -.24900933, .02464014, -.24855216, -.13529889, .0048323, .00481904, -.00792244, .00481903, .00717903, 1.5612954, 1.0050419, -.31845894, .97326169, 1.157936, -.04439821, -.04534558, .0116988, -.04534221, -.03586197, -.18287636, -.20228267, .09051079, -.20194015, -.182256, .79991917, .59627529, -.39894571, .58778217, .79924268, .00045295, .00045286, -.00012532, .00045286, .00037187, -.35045702, -.43580879, .18862591, -.43237702, -.3591702, .48168833, .40506154, -.06181568, .40304207, .30611667, 1.2102909, .82323981, -.41739621, .803211, 1.0693487, -.59017082, -.91634263, .27345193, -.88743255, -.57538096, -.37675981, -.47045792, .12095176, -.46661229, -.32503025, .06803516, .06595983, -.01939384, .06594928, .056414, -.06959904, -.07232338, .05983358, -.07230561, -.08337973, .21772388, .1987227, -.05156152, .19844678, .16971593, 1.6833678, 1.0531665, -.41182571, 1.0155263, 1.3264794, -.34527398, -.42174351, .11413824, -.4189433, -.30078969, -.62314999, -.96597584, .1733497, -.93571986, -.51252229, .6459985, .5037073, -.31753546, .49854781, .64233524, .81444581, .60869635, -.31055794, .60017873, .74410178, -.4908851, -.63379759, .03898724, -.62695296, -.26585044, .62883787, .49981679, -.15887697, .49545104, .5008674, -.47123649, -.64525963, .2157823, -.63475768, -.45762303, -.43045432, -.56726321, .18859397, -.56012565, -.41191156, -.27800518, -.32605338, .11807445, -.32467635, -.2632877, .02531747, .02500971, -.01037265, .02500908, .02369118, .8807169, .65205874, -.24272019, .64234114, .72210916, -.47195945, -.64065297, .1776242, -.63078898, -.42931939, .49944805, .41097781, -.16469959, .40838569, .43474479, 1.5756966, .961067, -1.4644167, .92300166, 1.9373732, -.62905627, -1.0322172, .31250029, -.99119942, -.62770146, -.43233827, -.55683313, .10072474, -.55093416, -.33517466, 1.2574772, .8430771, -.49561225, .82102893, 1.1616022, -.48191348, -.65985959, .18026216, -.64912206, -.43747936, .96451145, .70037123, -.24978434, .68855868, .77458662, .10390185, .09900718, -.04141969, .09896877, .0963447, .17782342, .1633702, -.12549832, .16317469, .199472, .90103943, .64142578, -.9021328, .62924252, 1.1356975, -.31685644, -.37539119, .06613533, -.37359927, -.23680791, -.36576202, -.45473746, .13299164, -.45116409, -.32891512, .3946375, .33626288, -.13179614, .33483111, .34496614, -.05564079, -.05737795, .05191923, -.05736891, -.06850384, .07746079, .07480482, -.0207498, .07478964, .06291235, -.62763543, -.9961985, .21906113, -.96162467, -.55676262, -.67538326, -1.2113217, .40482453, -1.1450707, -.71746238, -.19995235, -.22180501, .05561306, -.22140782, -.16444472, .03704984, .03639979, -.01443181, .03639789, .03409112, -.51650857, -.76312406, .39772971, -.74408523, -.59647333, .98171505, .70792313, -.2820108, .6954651, .81612286, -.2277101, -.25742923, .07554275, -.25678472, -.19860757, -.6677642, -1.1054215, .21255838, -1.0599649, -.57444902, .82422176, .61613989, -.27973166, .60753116, .724358, .25536475, .22807412, -.12009092, .22758927, .25020003, .13012242, .12202695, -.10400311, .12194308, .15214588, .09729097, .0929002, -.04630879, .09286719, .09570754, .05400697, .05259462, -.0289588, .05258847, .05528026, .02411581, .02383889, -.00908, .02383836, .02194016, -.49513117, -.69291152, .22291771, -.68003738, -.4781216, -.46304413, -.61997017, .15285491, -.61125577, -.40319771, -.18833279, -.20618262, .02966943, -.20590112, -.12815347, -.5643813, -.85531534, .28315697, -.83116451, -.56502478, -.08363191, -.08715286, .02552147, -.08712817, -.07094034, -.47398851, -.65328525, .23517562, -.64221102, -.47277297, -.26479649, -.30521694, .07162969, -.30419273, -.21576575, -.19257033, -.21268103, .05290569, -.21233169, -.15772616, -.42206694, -.53104639, .06193518, -.52640571, -.28048524, .27418477, .24533224, -.05768892, .24482746, .20546428, -.32017836, -.38448403, .10816775, -.38234583, -.28095531, -.11235979, -.11823478, .01483804, -.11818361, -.07209018, .0987543, .09404778, -.06959045, .09401042, .11072114, -.01475371, -.0148639, .00745724, -.01486376, -.01480711, -.31418685, -.38182471, .20098822, -.37941624, -.34108205, .11799586, .11146733, -.07163686, .11140716, .12588289, -.30637716, -.3637908, .09558214, -.36200816, -.26180213, -.10448745, -.11077222, .0847169, -.11070926, -.12275602, 1.2126604, .82725729, -.37262864, .8074287, 1.0310068, -.39751424, -.50920053, .1695837, -.50403422, -.37702762, .41730243, .35889083, -.04510874, .35753432, .25045566, -.73638278, -1.3570324, .25051513, -1.2760582, -.6476749, .55540527, .45719388, -.06897275, .45432127, .3491209, -.30721199, -.36229287, .0687354, -.36065586, -.23497893, .10505872, .10057482, -.01463721, .10054293, .06862002, -.45382873, -.60844735, .18506012, -.5998169, -.42400951, .39661504, .33831796, -.11781938, .336897, .33342259, -.69147439, -1.1808634, .21853097, -1.1263227, -.59342395, -.24741436, -.28045005, .04610236, -.27971718, -.17804686, -.36931264, -.45432927, .08596562, -.45109528, -.28622949, 1.3455919, .89213672, -.41397432, .86750981, 1.1444848, -.47951866, -.66313969, .22918427, -.65166375, -.47236235, .71520118, .54505314, -.38833921, .53840534, .73513296, -.25160521, -.28897301, .0883052, -.28805159, -.22360689, -.21586978, -.24025429, .03882649, -.23979626, -.15352553, 1.9366852, 1.1229873, -1.1507855, 1.0692654, 2.0513864, -.54191503, -.81867924, .37498983, -.79590578, -.60390778, -.60797965, -.93124681, .18049629, -.90361689, -.51100536, .35254522, .30358918, -.15896092, .30246118, .34060421, -.24892482, -.28657929, .10995939, -.28563373, -.23885421, -.73517526, -1.2292916, .10907361, -1.176769, -.49035486, -.09636889, -.10089282, .0205596, -.10085744, -.07255035, -.38028061, -.49216014, .32033143, -.4867466, -.45249381, -.18871952, -.20901105, .07789747, -.20864818, -.1770363, -.06614495, -.06841276, .02905101, -.0683998, -.06334732, -.62411409, -.97774934, .19561035, -.94566456, -.53413365, .27120071, .24281427, -.05949607, .24232028, .20607879, .85585921, .61733359, -.8366515, .60648742, 1.0701872, -.16357957, -.17802555, .05246843, -.17781323, -.1410789, -.17076048, -.18878456, .15029066, -.18846812, -.20617955, .52263905, .42910139, -.12966468, .42633288, .41376314, .08575312, .08269529, -.01334224, .08267713, .05811026, -.14597352, -.15759015, .05691445, -.15743625, -.13435904, -.12458284, -.13295752, .05161702, -.13286377, -.11701632, .11494773, .10876673, -.06680556, .10871137, .1208596, -.04256321, -.04346356, .01520077, -.04346039, -.03804709, -.45536737, -.58326447, .0570685, -.57735027, -.28711117, .47626078, .39404241, -.17708947, .39169372, .43149006, -.24311822, -.27871269, .10466917, -.27784737, -.23129235, 1.3476211, .87277805, -.85701703, .8459194, 1.4601082, -.37467502, -.46905263, .13720983, -.4651302, -.33773409, -.07708257, -.08018609, .03357444, -.08016527, -.07361794, -.01385604, -.01394893, .00470857, -.01394883, -.01218239, -.72719396, -1.3517217, .29532086, -1.2688687, -.67848703, .44571038, .37514843, -.10875349, .37329763, .3509077, -.57534299, -.86862449, .23022732, -.84453497, -.53417083, -.0754074, -.07835789, .03140045, -.07833865, -.07094655, .75644486, .57398438, -.29853542, .5667599, .69907988, -.6168851, -.94901454, .17024164, -.92029119, -.50602051, -.46962782, -.64565932, .24080845, -.63488224, -.47359064, .72610874, .56301499, -.16076249, .55698784, .55344273, -.10814219, -.11418864, .03518046, -.11413233, -.09370741, .46426286, .38453431, -.20407356, .38226845, .44474889, -.31314903, -.38903031, .44926615, -.38599444, -.44498491, -.16918239, -.18372589, .03236222, -.1835178, -.1228173, .01922199, .0190669, -.00221987, .01906669, .01179374, .69393246, .54025406, -.19213669, .5346523, .56984696, -.47386179, -.65599758, .2572133, -.64457328, -.48701491, .1456625, .13616929, -.06689435, .13606627, .14159187, -.70347527, -1.3807153, .55747473, -1.2813738, -.82019595, .00383646, .00382933, -.00148007, .00382933, .00351878, -.1768471, -.19414626, .06286135, -.19386472, -.15783495, -.13496417, -.14390135, .02406649, -.1438028, -.09571057, .37122856, .32016044, -.09463934, .31899469, .29657063, .60928212, .48199407, -.25714196, .47761034, .57581097, -.41880282, -.56645291, .42755189, -.55793354, -.53130757, -.42053034, -.55369854, .22244575, -.54677554, -.42849879, -.15715324, -.17157183, .09775847, -.17135169, -.16902218, -.09228049, -.09672915, .03634801, -.09669343, -.08522692, -.08995605, -.09397528, .02353244, -.09394536, -.07248574, -.44885439, -.58736729, .11330178, -.58034539, -.35740385, -.30551624, -.37255546, .28556142, -.37012293, -.37635647, -.03486108, -.03547902, .01599897, -.03547719, -.03387931, -.2946841, -.35200734, .16882458, -.35016057, -.30836118, .13931681, .13093625, -.043177, .1308523, .11878543, -.19643866, -.21786169, .06304702, -.21747313, -.16945309, .97520508, .69987126, -.35556831, .68719635, .87777185, -.17457684, -.19174755, .07274891, -.19146657, -.16428954, -.20695989, -.23150806, .07894116, -.23102399, -.18910454, .09175883, .0878384, -.0436685, .08781049, .09026055, -.6726609, -1.1472366, .26916505, -1.0944988, -.62452094, -.62009308, -.98610435, .24679913, -.95160491, -.57468403, .9143014, .67645561, -.18494444, .66632846, .67621274, -.40823923, -.51398966, .0825203, -.50947217, -.30186082, .49533274, .39542199, -.86503165, .39209712, .75153986, -.41646708, -.57351884, .65089757, -.56384747, -.60893088, -.24832842, -.28228688, .05344114, -.28151545, -.18749348, -.4291716, -.56977636, .23074298, -.56222093, -.43968348, -.52430276, -.75504356, .23433078, -.73856158, -.50505795, -.35502192, -.43176704, .07773553, -.42902312, -.26960004, .73259343, .57037824, -.12427138, .56446619, .51094683, -.17483804, -.19012333, .02844008, -.18990093, -.12024792, -.47873773, -.65338446, .17767818, -.6429686, -.4334641, -.42915684, -.55172088, .10159999, -.54596001, -.33449162, .07254078, .07037383, -.00953335, .07036304, .04646722, .13886356, .1304756, -.04616793, .13039122, .12120364, 1.9186054, 1.103383, -1.5492848, 1.049048, 2.2510105, .81907795, .58317424, -1.9232965, .57210785, 1.3716466, -.44373902, -.58942003, .17882664, -.58157592, -.41295794, .132741, .12487617, -.05473605, .12479856, .12448142, .16258569, .15136781, -.04905618, .15123894, .13739243, .33106334, .28830953, -.11710154, .28739283, .29498839, .12174071, .11518179, -.04300579, .11512293, .10842836, .18150841, .16802615, -.04268629, .16785944, .1411575, -.55181879, -.78094168, .11503991, -.76546234, -.41224668, .31092362, .27182326, -.14438697, .2710067, .30335779, .4898463, .40123648, -.24767545, .39858616, .49167434, .04020691, .03953763, -.00461499, .03953577, .02461883, .69779258, .53039763, -.52893557, .52380457, .80160759, -.41938765, -.528942, .07014561, -.52422331, -.2911302, 1.5500093, .99414196, -.37744285, .96219521, 1.2195041, -.23120537, -.26211582, .08002466, -.26142923, -.20452665, -.5337862, -.75033499, .13270693, -.73602772, -.42288223, -.34890203, -.42568049, .10060014, -.42288671, -.29041019, .09510716, .09097446, -.03856102, .09094454, .0886887, -.42043796, -.53892978, .11036636, -.5334321, -.33917476, -.12595244, -.13532881, .10828799, -.13521259, -.15089487, -.31032226, -.37071943, .11203737, -.36877261, -.27840237, .16780569, .15577563, -.05594822, .15563205, .14660312, -.31007558, -.3713279, .12483464, -.36932432, -.28846962, .78557461, .5899677, -.33984865, .58198177, .74856607, 1.0796956, .75859235, -.34035392, .74306646, .92580842, .27211903, .24110835, -.14370344, .24052108, .27712242, -.52540352, -.73146819, .1256489, -.71828911, -.41088935, -.60747742, -.97426243, .32098258, -.9389528, -.61876239, -.43523416, -.56928385, .14331067, -.56250104, -.3786618, -.66214695, -1.0529658, .14597953, -1.0161294, -.50397645, -.37668723, -.47345942, .14901598, -.46935893, -.34839737, .27174319, .24340092, -.05638588, .24290944, .20269322, .0586777, .05722555, -.00890276, .05721956, .03943062, .27677671, .24694797, -.06897282, .24641357, .21944331, .0637317, .06189966, -.01870783, .06189089, .05336478, 1.0814839, .75717338, -.38058322, .74136982, .96199595, -.65943831, -1.0712433, .19220718, -1.0303401, -.55087024, -.18011189, -.19751596, .0493431, -.19723615, -.14738289, .46231409, .37982102, -.33361411, .3773866, .5224558, -.56942431, -.85763161, .24175842, -.83411749, -.53921405, -.35493969, -.44571691, .2330656, -.44188734, -.38869215, -.37534646, -.48492178, .33926643, -.47965973, -.45724101, -.41212714, -.53947528, .22608188, -.53301102, -.42506244, -.89109482, -1.8088793, .10306442, -1.6661471, -.54701034, .84612011, .63633926, -.17695167, .62780994, .63277537, -.12382645, -.13164325, .03240452, -.13156107, -.0997901, 1.1076252, .76777951, -.44561598, .75085943, 1.0302093, .3311406, .2893973, -.08957051, .28852346, .26981948, .02920011, .02877719, -.01654502, .02877617, .03044309, .07314809, .0706297, -.03411092, .07061526, .0714677, -.35913427, -.43718768, .07348821, -.43438211, -.26663703, -.18609667, -.20641976, .09821248, -.20605065, -.18947764, .50919209, .4142026, -.26402946, .41127427, .51540492, -.26690924, -.30841311, .07685443, -.30734196, -.22206257, .02042216, .02021503, -.01102855, .02021468, .02095321, .7002997, .53833717, -.31546173, .53217977, .67636561, 1.2941374, .88132159, -.23467786, .86000984, .92289924, .00143183, .00143077, -.00093378, .00143077, .00156442, .80324755, .60017028, -.3506458, .59175704, .76771346, -.34282415, -.4202402, .13739525, -.41735056, -.31845507, .17602685, .16229011, -.08993897, .16211168, .17730129, -.18038496, -.19597926, .02026541, -.19575488, -.10966347, -.30741981, -.36447461, .08698474, -.36271998, -.25428003, -.07797062, -.08103614, .02503701, -.08101606, -.06727053, .80370036, .60024571, -.3553498, .59180636, .77142102, .49751879, .41508697, -.07680567, .41282555, .3362643, -.12394241, -.13270282, .08092548, -.13259972, -.13547268, .0907716, .087107, -.0276548, .08708235, .07695441, -.58551063, -.89305963, .23048889, -.8670732, -.54065039, -.4436628, -.58751169, .16649328, -.57985969, -.40319108, -.01064029, -.01069679, .00486865, -.01069674, -.01033035, -.76349743, -1.3671158, .14976747, -1.2927466, -.55892588, -.41942955, -.54623956, .17243998, -.53993799, -.3929422, .07188648, .06969326, -.0125059, .06968211, .05056071, -.45634065, -.62180242, .25193005, -.6119925, -.47166041, .66568185, .5216652, -.19801412, .51653357, .55986914, -.04302486, -.04399902, .02521296, -.04399534, -.04536256, -.59939806, -.92172055, .2130805, -.89387717, -.5349766, -.46198986, -.61219946, .12241772, -.60418739, -.37386349, -.44136021, -.58987474, .21532139, -.58168434, -.43775843, .15531067, .14510439, -.04349201, .14499271, .12802084, -.1605713, -.17470648, .05934997, -.17449939, -.14518735, .45124764, .38064244, -.08599328, .37881183, .327171, -.28769159, -.33737083, .08922817, -.33594827, -.2453553, -.30543375, -.35768158, .05171439, -.35619939, -.21289158, -.00282118, -.00282495, .0008457, -.00282495, -.00237886, .04404652, .04315387, -.01374418, .04315085, .03764067, -.66277922, -1.0501904, .13883223, -1.0140043, -.49592883, .94359123, .67929441, -.41216658, .66721909, .90203527, -.60937317, -.98748869, .35184524, -.95015357, -.63931679, -.35004111, -.42969838, .12236166, -.42670244, -.31067369, -.17253268, -.18766663, .03247046, -.18744569, -.12457199, .56866536, .4582866, -.17765109, .45474887, .48615021, -.64104987, -.98195742, .11824463, -.95281519, -.45976054, .13859401, .13062588, -.0288178, .13054959, .10344907, .13036798, .12305608, -.0368677, .12298778, .10781338, -.22676671, -.25854605, .13248042, -.25780633, -.2388435, .371507, .32034478, -.09523099, .31917562, .29733596, 1.2071602, .81655811, -.51291364, .7961247, 1.1434083, .89070081, .66413745, -.16685752, .65469612, .64211551, -.60394234, -.96084765, .30641235, -.92716896, -.60688873, -.26604872, -.30950626, .11235654, -.30832857, -.25148779, .65899032, .52076457, -.14448362, .51598551, .50065155, -.17951486, -.19802609, .08409235, -.19770856, -.17565578, .68945354, .53699955, -.19838414, .53145064, .57347653, .01497978, .01488627, -.00158129, .01488618, .00891971, -.65161336, -1.0159802, .13055012, -.98332859, -.48039198, .3362121, .29120925, -.15401533, .29020943, .32654287, -.37880467, -.48944216, .31617826, -.48412663, -.44936325, .63868806, .51567573, -.06375307, .51176294, .37328131, .06884034, .06676215, -.01600538, .06675169, .05333276, -.17402133, -.19051874, .05593966, -.1902585, -.15019366, -.1912367, -.21227567, .08358483, -.21189074, -.18285212, -.43253467, -.55538081, .09223564, -.54963788, -.32557936, .1682158, .15649153, -.04134298, .15635548, .13275629, -.6224555, -1.0180922, .32847661, -.97814722, -.63374862, -.53997585, -.76271418, .13218644, -.7477607, -.42558717, -.63427137, -1.0088441, .2064307, -.97352075, -.54969042, .13276369, .12501016, -.04742027, .12493475, .11868182, -.42174769, -.54921003, .16462506, -.5428784, -.38833851, -.24126988, -.27460897, .07270986, -.27384373, -.20380265, .17335348, .16131178, -.03141992, .16117251, .12360425, .4376146, .36594902, -.18691447, .36400544, .41522693, -.59768424, -.90289008, .17116733, -.87777946, -.49636158, -.40429612, -.53254623, .30793577, -.52586762, -.46518935, .43090041, .36636087, -.07523678, .36475822, .30343896, .62725403, .48691579, -.4924925, .48174928, .72907496, -.40588037, -.52052606, .14833886, -.51519516, -.36561753, -.03740417, -.03810963, .01568498, -.03810741, -.03527373, .27306715, .24349892, -.08080338, .2429667, .22926239, -.49496985, -.67615602, .13869254, -.6653144, -.40808146, -.79113899, -1.4054818, .10558115, -1.3310049, -.50937855, -.43097213, -.55555191, .10576207, -.54962668, -.33995344, -.4032534, -.5112142, .11204773, -.50645073, -.33153525, -.33314549, -.40137054, .08986394, -.39905799, -.27120297, .2407433, .2169849, -.08291416, .21659496, .21261262, .24101098, .21640297, -.11760103, .21598518, .23905891, .20000383, .1830665, -.07461323, .18282781, .18140148, -.22538443, -.25428686, .07188698, -.25367093, -.1940183, -.32149179, -.39624663, .27840685, -.39337475, -.38608527, .87040729, .62890561, -.68543035, .6179705, 1.0126968, -.09850354, -.10349707, .03284711, -.1034549, -.08606177, -.13904173, -.15016113, .08736364, -.1500131, -.15004344, 1.8567607, 1.0760962, -1.6345595, 1.0245247, 2.2420615, .25420233, .22854457, -.06799885, .22811392, .20636223, -.42601637, -.55519167, .15490018, -.54875438, -.38309942, -.42006046, -.54070736, .12484348, -.53500515, -.35318845, -.34038517, -.41888298, .1670363, -.4158917, -.33826784, .10732772, .10202788, -.0504268, .10198429, .10512477, 2.4165453, 1.2773864, -2.1690413, 1.1947914, 2.9369456, .58770343, .45938875, -.60368314, .45477576, .74711106, .22404849, .20314341, -.08197069, .20281894, .20189438, .06774159, .06578282, -.01213391, .06577339, .04811131, -.05276523, -.05416643, .01965723, -.05416023, -.04783539, -.05982267, -.06179001, .04541919, -.06177923, -.06875965, -.09655933, -.10173287, .06111632, -.1016867, -.10445403, .29990152, .26387987, -.11665314, .26316113, .27582137, -.28520689, -.33843405, .16472851, -.33678811, -.29925374, -.22646097, -.25959206, .18367603, -.25878722, -.26608664, -.43394393, -.55488155, .0799881, -.54933148, -.31115316, -.13630458, -.14645735, .05782735, -.14633144, -.1290411, -.61471548, -.98815853, .29978608, -.95200201, -.60962568, .27042842, .2433076, -.03873781, .24285529, .17827477, -.3037132, -.3548468, .04833258, -.35341891, -.20736356, 1.3275166, .89183862, -.30062782, .86874653, 1.0194823, -.12083708, -.12842762, .03783723, -.12834821, -.10338319, .17329023, .16132223, -.02974094, .16118461, .12133264, -.55179382, -.87702595, .62383453, -.8464111, -.72424308, -.66512486, -1.1011503, .21960267, -1.0558538, -.5791948, -.30685317, -.36060847, .05895314, -.35904713, -.22308278, -.33302732, -.39716754, .05925522, -.39512139, -.23599644, .23219186, .20987025, -.08413126, .20951333, .20855813, -.35602639, -.43601762, .09821201, -.43304672, -.29200234, -.14141661, -.15399593, .17806271, -.1538097, -.19239832, -.09296937, -.09735512, .02855205, -.09732065, -.07902825, -.4456744, -.58277989, .11773478, -.57585032, -.36029374, 3.1329873, 1.621228, -.46042711, 1.5096314, 2.0830645, -.2042655, -.22627432, .04202093, -.22587992, -.15192477, -.06201938, -.06392066, .01862458, -.06391094, -.05232675, .34632572, .29817015, -.18601059, .29705915, .35468737, .21401773, .19464961, -.08608469, .194358, .19904524, .45136307, .37960871, -.1031863, .3777189, .34772402, .37285458, .31822787, -.18611474, .31690065, .3726461, -.49299048, -.66634587, .11428475, -.65636839, -.381562, -.41513381, -.520888, .06491106, -.51644384, -.2817788, -.37195651, -.46926504, .18495104, -.46506769, -.37127044, -.18813731, -.20902544, .10218763, -.20863978, -.1934013, -.42736786, -.58745043, .51011007, -.57765619, -.57117064, -.49915342, -.6604927, .06368884, -.65193616, -.31660698, 1.3670951, .91160504, -.30307787, .88712478, 1.0424628, -.49474038, -.7113154, .36275486, -.6959238, -.56208153, .7613852, .58098624, -.22289997, .57396562, .63696605, -.17319968, -.19279796, .22909499, -.1924292, -.23954103, .45265479, .378838, -.13576636, .37684438, .38175565, .93930293, .68862464, -.21360169, .67768683, .72235166, .22161701, .20016359, -.13135934, .19981818, .23454835, .15032335, .14023016, -.06996913, .14011732, .14677873, .3406974, .29533657, -.13054502, .29433411, .31177597, -.16307222, -.17810303, .07541958, -.17787248, -.1588881, -.54862673, -.79377698, .17620597, -.77600914, -.47337085, -.32634377, -.3857118, .04692816, -.38392179, -.21541274, -.15373157, -.16730443, .08605123, -.16710499, -.15962629, .9011882, .66456837, -.23643424, .65440352, .72687063, -.34509771, -.42555341, .16069105, -.42245448, -.33700417, -.16367701, -.17758625, .03848037, -.17738952, -.12727649, -.56470257, -.89463205, .4988797, -.86382843, -.68268724, .20397399, .18495038, -.1729023, .18465524, .24321673, -.3193625, -.38720281, .16127484, -.38481872, -.32042138, -.56406387, -.92260115, .72246827, -.88640048, -.77179468, .58923877, .46784371, -.28158811, .46371946, .58041993, -.59126872, -.86740855, .12090897, -.84653375, -.43888707, -.21570205, -.24209371, .07172638, -.24155697, -.18828071, -.52204454, -.74049644, .18677028, -.72562754, -.46692912, -.28620727, -.34438183, .28781731, -.3424245, -.36127347, -.24656188, -.2814314, .07253135, -.28061238, -.20660264, -.67681799, -1.1496091, .24645424, -1.0975441, -.60893372, -.26112484, -.3008458, .07808969, -.2998428, -.22000879, -.27114812, -.31363221, .07156776, -.31252748, -.21913926, .54582258, .45257873, -.05252811, .44994244, .31514343, .48766246, .4031505, -.15344342, .40072711, .41789994, -.24193248, -.280044, .18522885, -.27904766, -.27885322, -.21380309, -.24358292, .20279659, -.24289395, -.26467091, .59744826, .49250182, -.03553001, .48945219, .29381592, -.05153952, -.05300573, .04300642, -.05299877, -.06113379, -.43004264, -.59907074, .6310609, -.5882379, -.61570796, -.26585761, -.31380878, .22782518, -.31237523, -.31815833, .28391941, .25156111, -.10242141, .25094826, .25464607, -.00320243, -.00320713, .00070621, -.00320713, -.00243766, -.63603531, -1.0387713, .27203655, -.99825208, -.60377237, .25766098, .23140991, -.06735573, .23096518, .20757129, -.45820457, -.59541584, .08024045, -.58866089, -.3229838, -.18203541, -.19956372, .04409411, -.19928289, -.14296864, -.02065128, -.02085557, .00614934, -.02085524, -.0173747, .01775183, .01759911, -.00752808, .0175989, .01680352, -.30643849, -.36765483, .1481102, -.36563012, -.30299389, -.081806, -.08524442, .03003035, -.08522034, -.07379953, -.35109893, -.44246114, .28372612, -.43854089, -.41203057, .29228106, .25830425, -.10052206, .25764797, .25800666, -.12973689, -.13987802, .12660355, -.13974606, -.16213158, -.35944159, -.44852369, .17236722, -.44487993, -.35447078, -.19235849, -.21056665, .02480166, -.21027986, -.12243657, .3134934, .27464565, -.11503931, .27384613, .28277718, .24534764, .22013787, -.1090143, .21970717, .2358807, .06643198, .06432928, -.03325946, .06431819, .06646095, .67429179, .50146604, -1.718607, .4942113, 1.1604705, -.56591225, -.83989574, .20500954, -.81846328, -.50827735, -.56831985, -.85025465, .22302449, -.82768488, -.52423105, -.53897792, -.75946483, .12838518, -.74478013, -.42094848, -.37473684, -.46835206, .12996716, -.46449282, -.33172037, -.30393718, -.36528954, .1697736, -.36323935, -.31537162, -.72871779, -1.1633648, .07100675, -1.121995, -.42248969, .73993752, .56423112, -.28858573, .55737846, .68113257, -.63001589, -.92832045, .07789064, -.90547362, -.39543286, -.49481042, -.70976714, .34837384, -.69460179, -.55460579, -.12128416, -.12906781, .04379504, -.12898462, -.10881473, -.23925667, -.26926298, .03771911, -.26863752, -.16284453, -.28141339, -.33034739, .11180667, -.3289365, -.26065281, -.58607202, -.8867257, .20466395, -.86188206, -.51998535, .61486753, .49307432, -.12233617, .48909245, .45225426, .03891069, .03825868, -.00637663, .03825686, .02682788, -.07801938, -.08098829, .01887476, -.08096947, -.06124991, -.26574199, -.30695533, .07809122, -.30589447, -.22259609, .55197529, .44772379, -.16106236, .44447072, .46126918, .08014856, .0772757, -.02407156, .07725855, .0676252, .53949228, .43100368, -.42056321, .42740402, .62557192, .31646791, .27733569, -.10418963, .27653203, .27532012, -.38349065, -.49156583, .23031385, -.48655163, -.40764914, -.11154803, -.11815096, .04400122, -.11808586, -.10307172, -.33397972, -.40069318, .07436371, -.39848681, -.25504124, -.34494433, -.41725684, .07966411, -.41474851, -.26664303, -.04882811, -.05004658, .02132962, -.05004152, -.04667858, -.66432154, -1.0115412, .08200189, -.98233962, -.41674478, .52050265, .43235813, -.06925066, .42988738, .33478546, -.74032013, -1.3684431, .24557522, -1.2860082, -.64568081, 1.2339346, .82646407, -.59570105, .80474385, 1.219591, .19545939, .18091742, -.02399317, .18073731, .12238933, .24345009, .2190794, -.08809054, .21867369, .21857126, -.30556093, -.3698442, .21518371, -.36760659, -.34251401, .87359409, .6485596, -.23214682, .63906773, .70762641, -.24616913, -.27982425, .05720681, -.2790599, -.19068431, .56084516, .4533764, -.16931747, .44997509, .47403009, 1.4051818, .92171756, -.41174286, .89495768, 1.175909, -.37948801, -.48217879, .19474988, -.47760011, -.38279633, -.19345345, -.21595798, .11683694, -.21552271, -.20602553, -.13327704, -.14214321, .02763418, -.14204499, -.09938688, -.19513424, -.2178728, .1104413, -.21743226, -.20336498, -.45336283, -.61008216, .20274556, -.60121035, -.43680847, .19905702, .18149646, -.1180615, .18123871, .21071612, .31701275, .27459232, -.24571319, .27365014, .36689121, .21517695, .19551065, -.09133669, .19521163, .20374592, -.31500546, -.37694124, .10656824, -.37492464, -.27654426, -.23886428, -.27613613, .1915309, -.27517089, -.27959136, -.11233747, -.119213, .05476638, -.11914292, -.11139468, -.65407609, -1.0550305, .18964903, -1.0158838, -.54543842, .23118901, .20950059, -.06747548, .20916214, .1932132, -.1629926, -.1762519, .02808787, -.17607234, -.11427771, .79802628, .60927836, -.14947944, .60194532, .57528354, .07555839, .07326083, -.00813483, .07324919, .04528782, -.29706245, -.35368369, .13760561, -.35189589, -.28959244, -.72628919, -1.1778543, .08714156, -1.1331839, -.45132718, -.59367952, -.92112343, .25838665, -.89215596, -.56684989, -.20404943, -.22927129, .1208015, -.2287531, -.21586937, -.52120876, -.75620574, .27790989, -.73902735, -.53249942, .05033043, .04909361, -.02844995, .04908854, .05243134, -.29237643, -.35807637, .47522164, -.35563591, -.43311541, .33116746, .28590579, -.21937196, .28487922, .36372136, -.41170629, -.5238152, .1055138, -.51878584, -.32948685, -.63828799, -.99745234, .15843317, -.965077, -.50540145, -.10852217, -.1145968, .0345321, -.11454016, -.0933462, -.62646586, -1.0304966, .33150961, -.98915117, -.63842073, .29006217, .2571871, -.08128721, .2565679, .23915427, -.20755921, -.23202555, .07356903, -.23154608, -.18507013, -.45843701, -.61452581, .17006626, -.6058187, -.41502013, -.57597609, -.85161759, .16821868, -.83029147, -.481472, .04791798, .04670435, -.05588205, .04669922, .06354769, 1.1140451, .77362432, -.39965379, .75674035, .99733217, .35442451, .30496469, -.16100425, .30381952, .34327192, -.30706359, -.3659546, .11018847, -.36408372, -.2749208, .01808864, .0179398, -.00431744, .0179396, .01413696, -.60604805, -.9519488, .25558281, -.92035188, -.57260955, -.47452351, -.65396514, .23265321, -.64288539, -.47143104, .03411148, .03356251, -.01259434, .03356103, .03083204, -.07142736, -.07441505, .08533555, -.07439423, -.09549114, -.13154852, -.14018265, .02747933, -.14008828, -.09834132, -.62578576, -.88953038, .04548333, -.87145497, -.32903684, -.54757952, -.84248913, .44234536, -.81697698, -.64253278, .1637329, .15304981, -.02654703, .15293374, .11248793, -.4752366, -.63874586, .13538532, -.62953183, -.39397964, .01884909, .01868321, -.00573015, .01868297, .01596831, -.1200169, -.12775865, .04966883, -.12767549, -.11268504, -.55066135, -.76724507, .087634, -.75335539, -.37597354, -.23388905, -.26350406, .04859864, -.26288086, -.17453852, .16733075, .15538363, -.05492886, .15524162, .14543224, -.24782997, -.28972217, .2529601, -.28854769, -.31438602, -.26174758, -.3045396, .12880019, -.30337895, -.26035781, -.71588996, -1.2542213, .20860676, -1.1908268, -.59797584, 1.1727991, .80654265, -.37037706, .7880042, 1.0062528, -.33457229, -.4067131, .12284605, -.40414026, -.30184945, -.00193528, -.00193703, .00053265, -.00193703, -.00158606, -.12463975, -.13330898, .06790085, -.13320858, -.12825455, -.22502702, -.25179013, .04124696, -.25126096, -.16105112, -.43691789, -.58198797, .21613564, -.57409059, -.4353635, -.32437967, -.38294517, .04671202, -.38119255, -.21421767, .0610175, .05930711, -.02091476, .05929912, .05380185, -.52215097, -.72854958, .13774574, -.71524927, -.42192324, -.18028465, -.19698008, .03506657, -.1967228, -.13160738, -.56020464, -.81533228, .16414995, -.79650289, -.46880049, .07701309, .07456865, -.01046854, .07455572, .04989019, -.4750142, -.65555976, .23728386, -.64435686, -.47486533, -.37174818, -.46250316, .11951458, -.45884551, -.32086045, -.14379597, -.15490357, .05053412, -.15476073, -.12785058, -.33433065, -.40662203, .12589755, -.40403667, -.3041818, .43777177, .36727412, -.15315095, .36539361, .3886408, -.42384435, -.54687488, .12396355, -.54099947, -.35446955, 2.3286877, 1.266299, -1.4264423, 1.1912351, 2.4917372, -.10755589, -.116195, .70570879, -.11607948, -.2536927, -.32505471, -.38866237, .08022933, -.38660108, -.2568968, .6430193, .50937731, -.15644778, .50479796, .50576542, -.02916294, -.02958909, .01222266, -.02958805, -.02749705, -.14202469, -.15306323, .0586341, -.1529204, -.13324042, -.49993967, -.67956219, .11535547, -.66900637, -.38633833, .50595567, .41368356, -.21097591, .41090154, .47624373, -.44157422, -.57764708, .12804833, -.57075842, -.36824522, .1977206, .18065707, -.09933826, .18041203, .19803873, -.56356418, -.83113681, .19258517, -.81059027, -.49641687, 1.0006511, .69854209, -.78505558, .68372653, 1.1627828, 1.2057068, .82210315, -.39678269, .80234749, 1.0487904, .24652153, .22211218, -.07101267, .22171024, .20512811, -.04790089, -.04915003, .03641648, -.0491446, -.05508141, .15522884, .14495182, -.04703418, .14483852, .13135989, .07175052, .06957892, -.01177297, .06956797, .04949052, .54797755, .4387557, -.33223197, .43516301, .58434004, -.30887057, -.3727549, .17603496, -.37056818, -.32264677, -.45451581, -.60069191, .13085035, -.59297729, -.37812404, .77121364, .57993385, -.373342, .57215398, .76294884, -.31715249, -.37584449, .06644612, -.37404464, -.23732598, -.02251018, -.02274116, .00426729, -.02274076, -.01629222, .86506483, .64873029, -.166787, .63986126, .62964607, .27920442, .24757064, -.1098991, .24697501, .25780395, -.16780749, -.18289662, .04934262, -.18267082, -.14059125, -.42845453, -.55207963, .10960382, -.54621033, -.3426797, .02776211, .02740527, -.00827402, .0274045, .02336417, .14395688, .13526741, -.03436767, .13518006, .11251617, .3819375, .32415477, -.22152545, .32270561, .40130947, -.20414445, -.23017274, .1519752, -.22962123, -.23310914, -.42852011, -.57253543, .27074448, -.56460271, -.46328049, -.28122228, -.32706559, .07105758, -.32582573, -.22399928, .77587467, .58943555, -.23157891, .58208049, .65328705, -.21408721, -.24228755, .1325768, -.24167033, -.22991095, -.42270633, -.5491531, .15197741, -.54293455, -.37870018, -.32252737, -.39730027, .26610493, -.3944361, -.38112902, .14527998, .13575976, -.07214054, .13565588, .14494625, -.30306188, -.35596113, .06347804, -.35443015, -.22676292, .78586715, .59766323, -.19976323, .59026271, .62721236, -.40255526, -.51028533, .11332277, -.50553393, -.33240387, -.15995616, -.17365697, .04924995, -.17346164, -.13608573, .02366448, .02340901, -.00600155, .02340855, .01887248, -.55138361, -.81593512, .24152275, -.79541699, -.52759246, .26282695, .23557989, -.06906473, .23511023, .21210067, -.46382619, -.63459868, .24090026, -.62432279, -.46974187, -.27765198, -.32380274, .09043777, -.32253025, -.24069134, -.25639371, -.2954045, .09055007, -.2944192, -.22833781, -.7448588, -1.3224353, .17011573, -1.252506, -.57364181, -.64967696, -1.0348946, .17338872, -.99843094, -.52700563, -.56631178, -.92534445, .69228997, -.88918071, -.76291545, 1.1090896, .74963186, -1.0368868, .73079915, 1.3663591, 1.0910584, .74952844, -.68464578, .73220369, 1.1768758, -.42938471, -.55158796, .09903492, -.54586356, -.33177004, -.61135726, -.92674886, .14990638, -.90054882, -.48211068, -.46009899, -.6280147, .24467719, -.61799632, -.4696511, .30668884, .2693635, -.11258485, .26860894, .27667418, .0195704, .01937981, -.01069719, .0193795, .02016042, -.10546512, -.11103137, .02661959, -.11098243, -.08397494, .81530195, .60637084, -.37528177, .59760197, .7931247, -.189364, -.20871692, .05116993, -.2083879, -.15424575, .77752047, .58711835, -.2940486, .57946865, .70842019, .43963306, .37255515, -.07923969, .37085871, .31288481, 1.1103624, .76321561, -.58380289, .74562605, 1.1291247, -.10208709, -.10731007, .0266489, -.10726556, -.08220224, -.29090748, -.33895313, .05949824, -.33763678, -.21594739, -.45835551, -.60551112, .1210955, -.59775789, -.37055639, -.34599044, -.42026402, .09118512, -.41762664, -.27948643, -.0164071, -.01657064, .04143263, -.01657037, -.02815002, .26081024, .23418477, -.06243106, .23373279, .20402967, -.60770311, -.96990944, .30261078, -.93545769, -.6068748, -.55443466, -.79473823, .13854266, -.77782203, -.43998522, .37219421, .32009456, -.11269455, .31888459, .31488892, -.17241024, -.190336, .12382657, -.19002598, -.19453152, -.12420242, -.13145783, .01669931, -.13138724, -.08016712, -.26109642, -.31959136, 1.1518632, -.31742495, -.53952417, -.24023407, -.27136395, .04665643, -.27069363, -.17528182, -.35782071, -.43620289, .07974605, -.43336357, -.27333173, -.26774043, -.31200026, .11632177, -.31078653, -.25548945, -.04456046, -.04549267, .00956196, -.04548942, -.03361182, .49812955, .41154842, -.13410754, .40905847, .40524961, -.3289724, -.39793901, .11643419, -.39554666, -.29318594, -.0815082, -.08483096, .02386864, -.08480839, -.06819513, -.51891927, -.73602425, .19577587, -.72124959, -.47242142, -.21719685, -.24376479, .06774354, -.24322459, -.18558163, .76571451, .58865994, -.15398813, .58193013, .56521932, .4376258, .37165203, -.0715995, .37000322, .3015657, -.25937774, -.292798, .02421402, -.29208242, -.14824752, .0352206, .0346677, -.00775126, .03466626, .02679159, -.16637039, -.18048157, .03326114, -.18028235, -.12256687, -.59109533, -.89118856, .18194713, -.86663372, -.50284031, -.18898344, -.20749119, .03729979, -.20718963, -.1386313, .02497347, .02466619, -.01292686, .02466556, .0252635, -.38914559, -.49490244, .16359863, -.49016719, -.36729185, -.46840968, -.62844631, .14603499, -.61948898, -.40017155, .4877303, .39793513, -.31740591, .39520248, .53251865, .29130866, .25850627, -.07324233, .25789241, .23165036, .22166568, .20114086, -.08244524, .20082472, .20084645, 2.9151703, 1.4835375, -1.2322409, 1.3764449, 2.7564566, -.70920357, -1.2739795, .27735089, -1.2039408, -.6534321, -.32750475, -.39863738, .15298162, -.39608222, -.3201608, -.14402642, -.15481446, .03892847, -.15467992, -.1173259, .38918005, .33111505, -.16254333, .32967869, .36652204, -.21949453, -.24508302, .04323825, -.24458705, -.16090956, .41702782, .35051293, -.20191108, .3487554, .41257864, -.43528291, -.57853342, .21153592, -.57080205, -.43117389, .36872555, .31084288, -.44941036, .30933727, .49624161, .27868132, .24719459, -.10826872, .24660338, .25620223, -.4355134, -.55827797, .08336106, -.55258096, -.31622686, .26096066, .23215072, -.14285506, .23162207, .2689626, -.62632795, -.99641748, .22888971, -.96149863, -.56418295, -.33556505, -.40664182, .10646655, -.4041511, -.28835813, .30085296, .26298602, -.18970776, .26219454, .3250433, -.54939152, -.84099645, .40271441, -.81611374, -.62411367, .38021192, .32812647, -.07458243, .32694241, .2783381, 1.7252034, 1.0676948, -.46538082, 1.0277966, 1.4044503, -.19943526, -.22237773, .08409164, -.2219389, -.18842082, -.23917223, -.27312948, .09523011, -.27232878, -.22168787, -.05133649, -.05276053, .03569616, -.05275394, -.05730176, -.44571787, -.625897, .55096848, -.61403325, -.60268764, .07902772, .07631622, -.01778952, .07630072, .06056909, -.48695547, -.66943809, .17997538, -.65826864, -.44029173, -.5015471, -.69896654, .18581227, -.68629642, -.4538468, -.36894206, -.46120792, .14823186, -.45740031, -.34300145, 1.1919129, .80877467, -.51160041, .78885357, 1.1327915, -.1832353, -.2018709, .06410404, -.20155561, -.16267141, .17691426, .16462548, -.02669745, .16448336, .11867024, -.35743235, -.45470307, .32569601, -.45034197, -.43659295, -.60044702, -.94377322, .27752394, -.91235823, -.5849157, -.16844988, -.185647, .12942661, -.18535495, -.194386, -.51190636, -.69445151, .09151857, -.68380167, -.3633346, -.3966205, -.49924595, .10322674, -.49486679, -.31904909, -.16643226, -.1838773, .17485578, -.18357315, -.2131711, -.42483516, -.54021187, .08073315, -.53504938, -.30773314, .27024082, .2429945, -.04119511, .24253769, .18188317, -.02732081, -.02770222, .01377701, -.02770133, -.02739832, -.64574301, -1.0066211, .139991, -.97429942, -.48874596, -.15692684, -.17371656, .3280044, -.17341778, -.25279474, -.3044152, -.36912754, .23781199, -.36685174, -.35323642, -.34371398, -.42078217, .12841466, -.41792556, -.3118983, 1.6382384, 1.0091422, -.80651337, .97071305, 1.629791, .32333333, .28196211, -.12773934, .28108315, .29891787, -.6486216, -1.1799054, .62609594, -1.1123358, -.80764015, -.05268509, -.05407984, .01937159, -.05407369, -.04755435, -.65649156, -1.0278427, .12953118, -.99420396, -.48152725, -.49644253, -.67568219, .12540798, -.66509895, -.39539488, -.42369386, -.56064885, .23639241, -.5533852, -.43946331, -.31568126, -.37433512, .07090762, -.3725293, -.24177246, -.03604488, -.0367347, .0239648, -.0367325, -.03963665, 1.7779317, 1.0780795, -.6589181, 1.0343903, 1.609029, -.22416269, -.25456814, .11412351, -.25388299, -.22551595, -.29931665, -.34529826, .02814393, -.34412575, -.17148474, -.4639905, -.62394085, .16580432, -.61491038, -.41484068, 1.0202515, .74670774, -.1177282, .73471942, .6258088, .31428151, .27060095, -.40244129, .26959364, .42998839, .43546456, .36427333, -.19055585, .36234588, .41653609, .0530618, .05177225, -.01680511, .05176703, .04556994, .37512674, .32097724, -.14977056, .31968081, .34801997, -.33165414, -.40802138, .2035771, -.40511567, -.35512119, -.27099835, -.31105942, .04712533, -.31007614, -.19057792, .84549607, .63445801, -.19512218, .62582196, .65341125, .52953109, .42744625, -.28889301, .42419612, .5451508, -.35787252, -.44242206, .13101812, -.43912261, -.32255666, 1.565082, .99618567, -.44049465, .96309072, 1.2922551, .01590784, .01579678, -.002703, .01579666, .0111011, -.19789672, -.22062798, .08844495, -.22019384, -.19063095, -.49807721, -.66188378, .07169645, -.65304871, -.32888218, -.51127417, -.70449968, .12768509, -.69257559, -.4056573, .23609158, .21258804, -.10623156, .21219892, .22793701, -.62344177, -.92780618, .09841196, -.903808, -.42451192, -.00219294, -.00219531, .00092301, -.00219531, -.00207061, -.30067078, -.35935201, .14702875, -.35745532, -.29844999, .8594222, .64902826, -.13141685, .64057786, .579026, .12380921, .11709195, -.0402474, .11703125, .10725674, -.10546415, -.11144036, .04804157, -.11138395, -.10223955, .18980596, .17448034, -.06963094, .17427439, .1711922, .33915942, .29019959, -.33561519, .28902735, .42582039, -.47809611, -.63421765, .0954486, -.62585506, -.35205457, .46050232, .37626187, -.46494908, .37371435, .58205811, -.19188464, -.21328153, .09022851, -.21288476, -.18799721, -.14004254, -.15082998, .06105184, -.15069164, -.13378772, -.63847208, -.94753507, .07803487, -.92336221, -.39920948, .95378281, .66766463, -1.0455829, .65371749, 1.2390699, -.20426911, -.22687891, .05168475, -.22646273, -.16277933, -.31442982, -.37939876, .15159173, -.37717711, -.31063543, .54623381, .44410214, -.1547877, .4409466, .45203757, -.21514947, -.24273071, .10401452, -.24214313, -.21274932, -.35426764, -.44264986, .20194656, -.43901117, -.37009209, .82616424, .61806297, -.26609819, .60947213, .71351247, -.22787564, -.25728937, .06914327, -.25665846, -.19292651, -.44612431, -.58219534, .1109507, -.57537538, -.35347384, -.50342186, -.68985899, .12921207, -.67857699, -.40308726, -.40225981, -.52014785, .19960342, -.51446514, -.40123957, .3748698, .32022487, -.16829833, .31890384, .36165147, -.03682105, -.03745628, .0081431, -.03745445, -.02805459, -.11224373, -.11921681, .06233209, -.11914466, -.11623992, .48933125, .40309301, -.1825126, .4005789, .44378871, .50617895, .41662813, -.14577638, .41400756, .42115482, -.68286009, -1.1935643, .29826066, -1.1337193, -.65277444, .26372656, .23429089, -.14764108, .23374485, .27385141, -.30292479, -.35960796, .10358983, -.35785057, -.26689407, -.47864969, -.70247932, .65971775, -.6855383, -.67113194, -.8591855, -1.828234, .17816862, -1.6653902, -.64073487, .63037315, .4976202, -.21686082, .49301243, .5565047, .31491042, .27564262, -.11882244, .27482942, .28670427, -.05953758, -.0612827, .0175488, -.06127418, -.04992138, -.02611477, -.02646331, .01329718, -.02646253, -.02627367, -.03845548, -.03924331, .02589129, -.03924062, -.04246522, -.54115058, -.88743131, 1.0351439, -.85225139, -.84636104, .43871747, .36637039, -.19874796, .36439484, .42452263, -.32518622, -.39204624, .1120159, -.38977106, -.28720455, .08669957, .08301252, -.0657326, .08298639, .0996051, -.52946363, -.7424546, .13539611, -.72849602, -.42341816, -.35463884, -.44294099, .197771, -.43931257, -.36778025, .05956428, .05767069, -.08298128, .05766066, .08381607, .27637345, .24603888, -.08481906, .24548546, .23487602, .10126586, .0965923, -.04171717, .09655637, .09493441, -.20165523, -.22350769, .04867788, -.22311385, -.15819529, -.59301261, -.9032179, .20418431, -.87710891, -.52367286, 1.0002739, .70795258, -.48261024, .69404949, .9884502, .68971676, .53373595, -.26524847, .52793335, .6319385, .26733013, .2406546, -.04028707, .24021194, .17923817, -.09247594, -.09661992, .01933908, -.09658899, -.0691578, 3.1534746, 1.6498702, -.33316187, 1.5398841, 1.8782554, -.03687639, -.03759705, .02397922, -.03759471, -.04025198, .16865744, .15532297, -.14458957, .15514749, .20186421, -.0629505, -.06490254, .01824187, -.06489246, -.05248469, -.04566691, -.04670114, .01568647, -.04669724, -.04029515, -.30024899, -.35187102, .06147214, -.35039921, -.22295839, .44713673, .37417976, -.15072949, .37220829, .39207545, -.38964399, -.48801251, .10174088, -.48391521, -.31377655, -.20806832, -.23193291, .05856947, -.23147779, -.17180576, -.80197519, -1.728815, .33003233, -1.5698303, -.75157003, -.22493557, -.25485809, .09607418, -.25419673, -.2134278, .61567023, .48534926, -.27956948, .48080332, .59621837, .67565472, .53953802, -.07108595, .53501365, .40187205, -.22402695, -.2529698, .07977056, -.25234843, -.20005883, -.58713112, -.87147522, .15294644, -.84922579, -.47243985, -.2097378, -.2336, .05164782, -.23314857, -.16563235, .19383372, .17561329, -.28216284, .17532839, .27677668, -.30775953, -.37072754, .16836223, -.36859513, -.31712652, -.55845233, -.82821557, .22547442, -.80715832, -.5200357, -.48173993, -.65274949, .14501692, -.64281641, -.4067785, -.20631742, -.23034376, .07037134, -.22987856, -.18162092, .01722956, .01709981, -.00284339, .01709964, .01190706, -.50259861, -.71746511, .28297405, -.70253704, -.52288525, -.43860781, -.58692132, .23285178, -.57870299, -.44745987, -.49294772, -.75400097, .94856672, -.73177275, -.77250246, -.2956642, -.34372594, .04664959, -.34242972, -.20129134, .75824791, .56477418, -.63159017, .55668761, .89886803, -.16455147, -.17953845, .06385487, -.1793113, -.15121999, -.06715729, -.06937811, .01888228, -.06936587, -.05543154, -.25611633, -.29248375, .05512596, -.29162611, -.19338386, -.4484982, -.6017206, .20663079, -.59314527, -.43643088, .49001226, .40718898, -.10974037, .40487174, .37491841, .26582446, .23732234, -.09021163, .23681431, .23361146, .06417361, .06214931, -.0424689, .06213867, .07045924, -.7154646, -1.2402209, .19080603, -1.1798076, -.58022904, 1.0394541, .74139814, -.26787516, .7274744, .83340808, -.39417377, -.51589875, .32166883, -.50972365, -.46409278, -.61776147, -.89675706, .0719622, -.8763298, -.38012405, -.43892263, -.58650386, .22408423, -.57837098, -.44198318, -.54239803, -.80619127, .29432686, -.78546692, -.55739795, -.27040424, -.30848465, .03359927, -.30759395, -.17000523, .57419404, .46268639, -.16543964, .45911074, .47781778, -.68581634, -1.135315, .17172741, -1.0886275, -.54462188, -.34139566, -.42360091, .21612927, -.42033238, -.36933448, .0853953, .0824384, -.01043778, .08242134, .05339517, -.21619342, -.2416878, .05326242, -.24118797, -.17075703, -.44157444, -.56401782, .06743461, -.5584264, -.29737668, -.54566286, -.76580672, .10804706, -.75133917, -.40071037, -.04885488, -.05010196, .0258448, -.05009666, -.04978208, -.52937813, -.72281265, .08020824, -.71125816, -.35557154, -.15359523, -.16708456, .0831097, -.16688739, -.15769299, .281392, .25203696, -.04275163, .25152781, .18917717, .32510889, .28270529, -.15110887, .28178711, .31729206, .20049988, .1832802, -.08451732, .18303411, .18940931, -.36695035, -.45313792, .10320753, -.44979389, -.30291352, .24205785, .21883404, -.0590665, .21846343, .19057672, -.09088204, -.09561142, .07783583, -.09557042, -.10873981, -.25150964, -.28558731, .045075, -.28482024, -.17865904, -.00952394, -.00956779, .00330535, -.00956775, -.00843258, .67717919, .51789168, -.51667663, .511736, .77962425, .17864499, .16455835, -.08882114, .16437347, .17831013, -.51061737, -.70687969, .14149135, -.69456938, -.41942118, -.28657751, -.34044444, .1665885, -.33876688, -.30133743, -.28221276, -.33334084, .14577777, -.33180557, -.28529328, -.42132649, -.54541981, .14204046, -.53940876, -.36945356, .44669922, .37958304, -.05846924, .37791122, .28575638, -.51843687, -.7084093, .09629695, -.69703059, -.37268744, .45617133, .38087787, -.14702021, .37882003, .39405273, .07299621, .07070188, -.0146483, .07068986, .05384424, .58596406, .47540614, -.09861585, .47195975, .40760506, .16315184, .15127378, -.08181999, .15112982, .16331439, -.46449785, -.61387484, .10993518, -.60599177, -.36200233, .19590249, .18100889, -.02932253, .18082041, .13105002, .2810031, .24973033, -.08613577, .24915188, .23871438, -.32960657, -.3937932, .06943555, -.39172308, -.24709722, -.10210757, -.10728008, .02449268, -.10723643, -.07993324, 1.2668389, .83885135, -.6987135, .81555408, 1.3089527, -.6118378, -.89520819, .0882217, -.87395637, -.40422764, .28569954, .24990732, -.2725118, .24916265, .35433289, -.23296601, -.2679531, .1772762, -.26708079, -.26797145, -.49168361, -.67846887, .17956065, -.66688454, -.44279652, -.43464789, -.57365231, .18103311, -.56635612, -.40896648, -.49266584, -.69301951, .25528938, -.67975126, -.49856588, -.24159749, -.27477112, .06863202, -.27401445, -.20010005, .57495002, .46345077, -.16091507, .45988025, .473837, -.18558717, -.20350099, .03850485, -.20321329, -.13842476, -.28784884, -.34272358, .17726758, -.34099062, -.30855275, -.42518782, -.57472746, .37366669, -.56611923, -.51312755, .71594311, .55700096, -.15451504, .55119351, .54106893, -.53498212, -.78679833, .27983439, -.76761996, -.54308759, 1.2211648, .81159155, -.83263031, .78944466, 1.3541816, -.39157239, -.50049687, .1798729, -.49550727, -.38066237, -.25771982, -.29547854, .06597874, -.29455997, -.20617842, .08135206, .07857934, -.01324417, .07856359, .05596682, .33362239, .29226352, -.07023612, .29141197, .2500539, -.13737328, -.14905414, .15702344, -.14888882, -.18096712, -.54291883, -.8808448, .8979184, -.84738204, -.80893239, -.01555449, -.0156845, .01329394, -.01568431, -.01859795, -.38549884, -.49459904, .22669162, -.48951636, -.40691516, -.04629879, -.04735416, .01486959, -.04735015, -.03994748, .47226516, .3981615, -.06173938, .3962348, .30198684, .87022528, .64867769, -.20340832, .63943767, .67538907, -.21432724, -.23950269, .05541127, -.23901104, -.17202608, -.64035317, -.9763625, .11206724, -.94799889, -.45128331, .76228245, .56808727, -.59220036, .55998289, .88289726, -.09002458, -.09426775, .03667102, -.09423443, -.08407981, .25452787, .22714058, -.13257364, .22665071, .25801956, .17830097, .16453833, -.07262131, .16436151, .16652029, -.2825473, -.33145422, .10482735, -.33005048, -.25579711, -.06221518, -.06415457, .02096438, -.0641445, -.05454667, -.56131494, -.82533879, .1898616, -.80524424, -.49275017, -.48135059, -.6330343, .07334239, -.62518623, -.32391871, .09367239, .08847607, -.46591083, .08842806, .20145838, .10862107, .10318687, -.05201347, .10314159, .10706758, .33147718, .28637689, -.20703543, .28535854, .35699378, -.30722738, -.36423445, .08729372, -.36248165, -.2544745, -.4464405, -.58938251, .14713627, -.58187114, -.38853097, -.3595744, -.43830994, .0764879, -.43545891, -.2704374, -.47142656, -.64148963, .18875409, -.63145648, -.43777553, .24541312, .2193413, -.15494364, .21888083, .26525674, -.58105231, -.8517778, .13736909, -.83135845, -.45267151, .30260782, .26488207, -.16305991, .26410097, .31025051, .0110551, .01100583, -.00084519, .01100579, .00591159, .55766006, .44579524, -.31282394, .44209253, .5794594, 1.9648421, 1.1338703, -1.1671211, 1.078703, 2.080976, .63151996, .49431858, -.31861049, .48940976, .63341461, -.00529967, -.00531398, .00302975, -.00531397, -.00554172, 1.5962708, 1.0010143, -.58776838, .9655851, 1.441506, .26608829, .23716281, -.10363647, .23664013, .24483004, -.48514944, -.66757355, .18890618, -.65637103, -.44635021, -.6358893, -.99466112, .16524883, -.96224017, -.51126234, -.2331373, -.26443297, .07716899, -.26373501, -.20318834, -.14935425, -.15984336, .01727818, -.1597207, -.0916898, .54322304, .43989854, -.19956951, .43665203, .49018519, -.0810468, -.08489645, .09067803, -.08486599, -.10600702, -.12204413, -.1296683, .03339678, -.12958898, -.09982886, -.67868636, -1.0744986, .11370098, -1.0376058, -.47138687, .19493357, .1792266, -.05507847, .17901596, .16116165, -.51870631, -.74207038, .22827026, -.72644398, -.49709661, -.23973607, -.27482379, .11680039, -.27397107, -.23767328, -.09872373, -.1036863, .03006509, -.10364474, -.08368453, .02495051, .02466855, -.00597504, .02466801, .01952135, .42384999, .36061221, -.08212641, .3590479, .30901465, -.15758965, -.17049964, .03890342, -.17032359, -.12455402, .59322598, .4858421, -.05397439, .48262808, .33616516, -.2563769, -.2964207, .10952121, -.29538267, -.2432738, -.4295476, -.54556631, .07142896, -.5404029, -.29760643, -.21958413, -.24341005, .02487112, -.24298009, -.1338574, -.04369004, -.04461727, .01269149, -.04461399, -.03645602, -.41874456, -.53823887, .12305241, -.5326267, -.35075685, .08686166, .08333116, -.04195716, .08330726, .08586789, -.36585313, -.44874397, .0834805, -.44563985, -.28167148, .11738607, .11131056, -.03890136, .11125819, .1023472, .35560178, .30706947, -.12216902, .30597027, .3137904, -.5001129, -.68949032, .15398961, -.67778162, -.42548656, -.10989825, -.11711279, .11600216, -.11703392, -.14098055, .4155222, .35125894, -.14542226, .3496118, .36893494, .40291287, .34473955, -.08477213, .34334647, .30192688, .50625566, .40947481, -.3731945, .40641881, .57619348, 1.0466268, .73464619, -.45180424, .71952893, .99660106, .26278628, .23239288, -.2228496, .23180878, .31338803, 1.7372719, 1.0744682, -.44852277, 1.0342114, 1.3937451, .16804624, .15619421, -.04693619, .15605505, .13839863, -.53752217, -.76754263, .1661654, -.75154682, -.45791808, .26624036, .23623799, -.15168422, .23567611, .27808191, -.41351894, -.5389088, .19659927, -.53265997, -.40663139, .34152217, .29540574, -.1498275, .29437223, .32695384, -.21282338, -.2392076, .08820191, -.23866394, -.19991662, -.31649299, -.38506154, .19778463, -.38260458, -.34091824, -.31911672, -.37587714, .04794976, -.37420349, -.21374953, -.63312167, -.96191132, .11690475, -.93442706, -.45423316, .43790732, .36528248, -.21563707, .36328821, .435685, -.52274944, -.78805245, .48544747, -.76635138, -.64256904, .43509123, .36497234, -.16228704, .36310054, .39460098, -.18794604, -.20805059, .0773634, -.20769289, -.17614783, -.23528413, -.26922367, .12199881, -.26841067, -.23815349, -.06893757, -.0714488, .03501924, -.07143356, -.06930261, .63560786, .49760006, -.30028077, .49266523, .62370422, -.62637435, -1.0223308, .30532748, -.98255517, -.6210901, -.30282195, -.36667935, .23495172, -.36445139, -.3505859, .50248074, .41563777, -.11690826, .41315421, .38937794, -.28604093, -.33368086, .07229241, -.33236472, -.22785559, -.22829199, -.25807182, .07373359, -.25742632, -.19734475, -.34891329, -.43526124, .21662708, -.43173433, -.37502417, -.22221942, -.24911494, .05207149, -.24857382, -.17260949, .30981925, .26856423, -.27955636, .26765239, .37720032, -.49456353, -.73670042, .63630577, -.71755689, -.67771434, -.26229629, -.30278254, .08375827, -.30174529, -.2258815, -.71632293, -1.2291807, .17229669, -1.1714199, -.56127394, .34154982, .30050952, -.04139624, .29969031, .2129608, .40727218, .34399589, -.17999362, .3423667, .39085788, .29875967, .26253723, -.13319591, .26180772, .28755545, -.45451117, -.60090033, .13199155, -.59316343, -.37921754, -.15765517, -.17200332, .08940932, -.17178602, -.16441562, -.18737951, -.20661345, .05759028, -.20628502, -.15932153, -.54151616, -.75482553, .10101945, -.74112589, -.38983959, .6651935, .49731305, -1.5474206, .49036965, 1.1104818, -.17299421, -.18933473, .05700241, -.18907791, -.15054353, .16132823, .15041734, -.04274356, .15029447, .13054908, .05094474, .04957028, -.06186615, .0495641, .0684795, 1.1153546, .77050647, -.47416692, .75321395, 1.0566449, .53865389, .44629203, -.06102288, .44367111, .32838308, .62185488, .50062682, -.0916739, .49672481, .41388969, 1.9581085, 1.1624729, -.55199188, 1.11142, 1.6176283, -.58435992, -.85176758, .11996326, -.83194145, -.4343232, -.49004157, -.69481161, .30752332, -.68089287, -.52859692, -.51441607, -.68946586, .06744246, -.67970639, -.32925382, -.38732235, -.49348365, .17910101, -.4886905, -.37736161, .14886954, .13826206, -.13712314, .13813622, .18249494, .09452706, .0902796, -.055915, .09024781, .09997472, -.15180546, -.16290956, .02109803, -.16277432, -.09907153, -.33392116, -.4061755, .12774464, -.40358964, -.30541254, .05084907, .04963439, -.02011871, .04962956, .04703257, .61427892, .47335157, -.8091448, .46803555, .84839055, .24274327, .21785063, -.11626167, .21742618, .23928767, .34508271, .29991148, -.09760403, .29892987, .28539611, -.50345497, -.68080084, .09757147, -.67057633, -.36707773, .39094818, .33256386, -.15846872, .33111825, .36453338, -.47564646, -.65682294, .23756413, -.64555746, -.47547366, -.43167621, -.55455928, .09503768, -.54880177, -.32840821, -.25949473, -.29454994, .03433652, -.2937632, -.16660235, -.42367156, -.54572744, .11877438, -.5399414, -.34935781, 2.0599325, 1.2169396, -.42155479, 1.1625164, 1.5294314, .54481395, .43884998, -.2566489, .435447, .53409923, .10119038, .09684596, -.02091624, .09681488, .07538137, -.1659091, -.18089615, .05603981, -.18067085, -.14557575, -.30496663, -.35659426, .04862747, -.35514469, -.20835572, .0622492, .0606153, -.00962284, .06060815, .04209207, -.41547887, -.54296427, .20320623, -.53653718, -.41243448, -.51611985, -.72804946, .18522928, -.71388374, -.46211165, -.06014845, -.06200558, .02530336, -.06199603, -.05678308, -.34475253, -.42606263, .17467911, -.42289495, -.34628097, -.64888003, -1.1024683, .34623735, -1.0524864, -.66309778, -.32206743, -.37928227, .04416306, -.37759727, -.20924781, 1.3792933, .9000614, -.56238908, .87329777, 1.2886254, -.56508561, -.80608492, .10943776, -.78937982, -.41191591, -.31537858, -.39182458, .4253564, -.38876515, -.43901813, .65138603, .51238252, -.19751333, .50749525, .55135895, -.21618638, -.24094113, .04258046, -.24046981, -.15847678, -.37262516, -.45418704, .0573607, -.4512348, -.25161098, .36262864, .31224063, -.12775718, .31107892, .32268579, .57799027, .46468136, -.17640708, .46101422, .49030052, -.5556686, -.82697831, .24725136, -.80558398, -.53448247, -.16644817, -.18401825, .18451181, -.18370976, -.21703881, -.54039333, -.76743451, .14469157, -.75192128, -.43883144, .44948898, .3741224, -.19910448, .37203039, .43170099, -.14057355, -.15093678, .04156937, -.15080958, -.11799679, -.58037643, -.87051895, .19566406, -.84712209, -.5089247, -.6227822, -.95735035, .15617349, -.92847585, -.49480783, -.57804723, -.82733256, .09670195, -.80986804, -.40129519, .78448866, .58944179, -.33672365, .58149008, .74557668, 1.054146, .74435402, -.34479284, .72954213, .91508885, -.34208617, -.40985682, .05801577, -.40763371, -.23856992, .25856674, .23084893, -.11230974, .23035499, .24671615, -.68810825, -1.1657844, .21064479, -1.113482, -.58429398, .62564676, .50140734, -.10983529, .49733552, .44137741, -.42905605, -.57230462, .25804445, -.56446446, -.45630041, -.02524752, -.02554976, .00666823, -.02554916, -.0204092, -.51515661, -.7777138, .55681303, -.75615134, -.66609982, .37998884, .32840472, -.067694, .32724257, .26938533, -.03708866, -.03776797, .01298699, -.0377659, -.03293621, .15859075, .14863505, -.0233522, .14853098, .10551264, .15149813, .14148303, -.05629751, .14137279, .13722859, -.2374756, -.27021291, .08110957, -.26946325, -.20914461, -.16377675, -.17747129, .03366691, -.17728068, -.12178092, -.40330466, -.50351353, .06974952, -.49940434, -.28310393, -.47998837, -.65494177, .17318064, -.64451623, -.43052356, -.5687609, -.80815922, .09701883, -.79177286, -.39741888, -.5474604, -.80926025, .25159329, -.78901937, -.53228573, .36179061, .311102, -.14281246, .30992376, .33437738, .07301298, .07053646, -.03005509, .07052247, .06843045, -.54009147, -.75365861, .10532974, -.73989159, -.39461345, -.07667632, -.07981353, .0401393, -.07979214, -.07785875, -.52343237, -.73890811, .16773808, -.7244704, -.45129543, -.40856945, -.52653791, .16097394, -.52093341, -.37737441, .52423996, .42917274, -.14830522, .42632233, .43359296, -.36437603, -.45830694, .19866664, -.45431343, -.37504627, .06421078, .06229403, -.02512568, .0622845, .05917268, -.17963938, -.19752144, .06356216, -.19722529, -.16008252, .01168468, .01162184, -.00298217, .01162178, .00933825, .01270297, .01262402, -.00567896, .01262394, .01223779, .12822104, .12126438, -.03041667, .12120151, .10000462, .34992171, .30594363, -.05573344, .30502576, .23898054, -.18220258, -.2012022, .08142686, -.20087264, -.17551015, -.51643924, -.73663542, .22456911, -.72137604, -.49295373, -.13668587, -.14635447, .03722035, -.14624059, -.1116227, -.08592909, -.08959026, .02273354, -.08956428, -.06950123, -.29890749, -.35627346, .13731366, -.3544498, -.2905845, -.14127667, -.15344908, .1393806, -.15327452, -.17719756, -.08596702, -.08951136, .01715288, -.08948702, -.06329124, -.17241445, -.19288784, .34314038, -.19248367, -.27324342, -.10304256, -.10825622, .02254455, -.10821227, -.07822909, .23801067, .21452616, -.09067178, .21414079, .21738605, .00781653, .00778987, -.00120038, .00778985, .00527383, .45498075, .37550619, -.29374233, .37320943, .49544356, -.30898377, -.36656602, .08595257, -.36478792, -.25412852, 1.3919557, .93074907, -.23987551, .90608786, .97593806, .90259427, .66739667, -.20993602, .65736604, .69935986, .86892751, .65294884, -.14804341, .64414622, .60691619, -.27612326, -.32454883, .1382021, -.32314074, -.27621687, -.6634974, -1.1259087, .2863091, -1.0750947, -.63170531, -.13891881, -.14945591, .05751103, -.14932285, -.1304471, .56019835, .45185643, -.19152775, .4483963, .49353177, -.64258415, -1.1112944, .44130738, -1.0576033, -.71429411, -.49223171, -.69701834, .28999517, -.68315682, -.51990019, -.06630194, -.06856965, .02792265, -.06855672, -.06261519, .95455463, .69116295, -.30250445, .67929908, .81995077, -.44260523, -.57963155, .12921138, -.5726631, -.36993147, -.57961396, -.8695938, .19844934, -.84619337, -.51088024, .39122666, .33156949, -.20012735, .3300616, .39421315, .08841621, .08509843, -.01697395, .08507768, .06426269, -.26051347, -.3008352, .09023165, -.29979934, -.23050645, -.18984637, -.21023619, .07363499, -.20987196, -.1744374, -.1977214, -.22011883, .08009159, -.21969695, -.18432097, -.59209368, -.86580004, .11361261, -.84531004, -.43027468, 1.0007412, .72745756, -.17853491, .71526918, .70979383, -.19851116, -.22191649, .10527669, -.2214577, -.20244669, -.2998424, -.34861962, .04191862, -.34730313, -.19606843, -.23239053, -.26236909, .05883541, -.26172644, -.18522597, 1.3247754, .90085441, -.20449846, .8789053, .8953679, -.07615355, -.07884554, .01222015, -.07882968, -.05213895, -.35850781, -.43313761, .05580867, -.43056679, -.24298324, -.16909033, -.18442839, .04974666, -.18419685, -.14169151, .25692835, .23019802, -.08599227, .22973564, .22475248, -.48906897, -.65652377, .1046771, -.64713167, -.36858752, -.10909284, -.11484912, .02026746, -.11479852, -.0784285, .0486299, .04746228, -.03015713, .04745761, .05224872, -.52512392, -.76920343, .30500905, -.75083593, -.5520208, -.02634513, -.02675419, .04700672, -.02675313, -.04025906, -.37580779, -.48457198, .31869806, -.47939288, -.44817435, .45408324, .38201788, -.09643806, .38012303, .34133682, .16371874, .15235593, -.04922592, .15222463, .13818902, .01009116, .01004427, -.00255849, .01004423, .00804696, .74603482, .56862893, -.27543584, .56170049, .67430474, -.22530933, -.25282642, .04992479, -.2522678, -.17177826, -.54387407, -.77710046, .15291264, -.76084916, -.44890733, .5275074, .43433477, -.10276098, .43161257, .38527584, -.05335427, -.05465682, .00867738, -.05465152, -.0366932, -.39039911, -.4915102, .11784698, -.48719165, -.32995549, -.18714887, -.20426998, .02362404, -.20400933, -.11828223, .3187253, .27982556, -.08532863, .27903696, .25881291, .12342615, .11646371, -.06042813, .1163983, .1225635, -.57222779, -.84842244, .18480835, -.82687967, -.49464827, .93255535, .67231233, -.42919888, .66046383, .90715035, .45855083, .37478395, -.47297595, .37225421, .58373358, .3395952, .29600141, -.0894222, .29507223, .27424127, .13959118, .13104366, -.05065634, .13095649, .1254469, .03360636, .03312423, -.0049253, .03312307, .02232383, .00180669, .00180514, -.00057417, .00180514, .00155338, -.32231295, -.38924918, .12868142, -.38694878, -.29902015, -.63662885, -1.04481, .28445515, -1.0032658, -.6132047, -.31414915, -.38190875, .20377712, -.37949137, -.34262502, .20454735, .18679783, -.08010264, .18654155, .18854782, -.3243895, -.38470337, .05731274, -.38284517, -.22933565, -.23104776, -.26402797, .13061165, -.26324615, -.24069763, .10205012, .09755886, -.02480805, .09752593, .08024474, -.07631875, -.07914865, .01805655, -.07913117, -.05947152, .27159428, .24281548, -.06699882, .24230851, .21460811, -.26951922, -.31386735, .1067351, -.31265676, -.24936696, -.01261613, -.01268603, .00182045, -.01268596, -.0083372, -.57893745, -.86150815, .17777217, -.83923332, -.49209885, .24501166, .21950425, -.12662078, .21906274, .2477248, .45667656, .37687392, -.28649241, .37456678, .49255363, -.07951973, -.08237394, .00984906, -.08235687, -.04994111, .06942818, .06716607, -.03072466, .06715379, .06665962, .79464256, .59417293, -.37102405, .58588489, .77670941, -.07309122, -.07630684, .10873895, -.07628327, -.10512722, -.27563222, -.31881566, .06273292, -.31769282, -.21202895, .17641173, .1643809, -.02272453, .1642443, .11225178, -.29277417, -.35056993, .19670598, -.34868067, -.32307575, .69660075, .53600357, -.31559827, .52991679, .67407905, 1.0327953, .74571352, -.17910779, .73269197, .72564519, -.39980428, -.49586405, .06023685, -.49205284, -.26803759, -.59287685, -.91220485, .2342961, -.88457847, -.54816084, .27674917, .24756534, -.0547607, .2470537, .20318449, -.17734954, -.19375534, .03964697, -.1935028, -.1356126, .0558028, .05430399, -.02862857, .05429728, .05628343, -.11720558, -.12416229, .03029124, -.12409352, -.09406207, .51045502, .41547288, -.25090773, .4125521, .50755877, .0747963, .07216217, -.03538748, .07214671, .07343109, -.42009588, -.56549866, .37571022, -.5572574, -.50994885, -.57154547, -.8812774, .32309047, -.85432632, -.59541335, -.26265359, -.30331547, .08464909, -.30227065, -.22688528, 1.8542891, 1.1343047, -.36603667, 1.0898937, 1.3603056, .17316308, .16018471, -.06810967, .16002279, .15985141, -.57386658, -.85162255, .1830963, -.82990081, -.4940571, -.27591827, -.31915467, .06229918, -.31803025, -.21168549, -.52559745, -.7623008, .25837044, -.74501665, -.52262852, -.13829099, -.14848161, .04722347, -.14835658, -.12178446, .0830565, .07987642, -.03392164, .07985613, .07763985, 1.2875637, .85976724, -.46793907, .83683432, 1.1576721, -.69746722, -1.1603542, .15792818, -1.1117194, -.53560639, -.20963124, -.23636886, .12325868, -.23580212, -.22126862, -.16887024, -.18536799, .0900327, -.18509983, -.1725224, .02403166, .02376895, -.00595373, .02376847, .01901643, -.48195017, -.63325837, .07103345, -.62545807, -.32074931, .31232972, .27525572, -.07414351, .2745246, .24365571, .1673552, .155558, -.04825875, .15541955, .13930333, -.62837383, -1.0043814, .23556385, -.96848532, -.57085385, .2660056, .23771925, -.08215224, .23721919, .22653935, -.67000496, -1.1240995, .23703154, -1.0754592, -.5970317, .61591255, .48971449, -.18441502, .48544991, .51914435, .03259064, .03199139, -.06210725, .03198955, .050908, -.50043132, -.72604011, .38463098, -.70954942, -.57754754, .18283235, .16856457, -.06639599, .16837925, .16434606, -.15025921, -.16169425, .03152725, -.16154937, -.11249488, -.31241386, -.3780408, .1783969, -.37575979, -.32655723, 1.303822, .86084416, -.60888903, .83660576, 1.2744855, .69195681, .52797272, -.48035167, .5215896, .77193801, 1.261634, .84300644, -.53901197, .82059233, 1.1971955, -.35212988, -.43131017, .10782961, -.42836703, -.29903677, -.27241679, -.32385492, .25784259, -.3222458, -.33699035, .16284675, .15181856, -.04018553, .15169421, .12869232, -.43131531, -.57213497, .21730541, -.56459337, -.43241102, .5068062, .41628461, -.16187428, .41361066, .43647954, -.41792042, -.55391493, .27432955, -.54665519, -.45761114, -.33688825, -.41594368, .20329602, -.41287909, -.35868251, -.59286939, -.87463123, .12900077, -.85297499, -.44927624, -.26509378, -.30409919, .05431984, -.30314626, -.19690761, .110943, .10576846, -.02226059, .10572826, .08183181, -.40357001, -.52012977, .17796044, -.51459058, -.38701733, .55572376, .45209093, -.130598, .44889726, .43207733, .22159764, .20188713, -.0544899, .20159543, .17491435, .51081102, .40964654, -.53803045, .40633965, .65481576, -.20711017, -.23205584, .08816765, -.23155637, -.19629717, .07329426, .07115667, -.00700367, .07114629, .04221809, .1190697, .11262297, -.05389371, .11256483, .11518348, -.02651643, -.02685975, .00900583, -.02685901, -.02330923, .46224268, .38664271, -.11878693, .38459507, .37026522, -.30832079, -.36700403, .10118452, -.36515374, -.26794762, .59328448, .46800323, -.36463604, .4636433, .6355336, -.65286707, -1.0805997, .25421176, -1.0361892, -.60065494, .150074, .1397441, -.09089028, .13962572, .15997525, -.12434117, -.13281068, .0583834, -.13271461, -.12176331, 1.1347334, .78499853, -.39354633, .76751259, 1.004472, .06335567, .06159726, -.01410533, .06158913, .04837951, .04946144, .04837481, -.01150543, .04837083, .03832558, -.50081414, -.73378689, .44749073, -.7162414, -.60774641, -.06709695, -.06921612, .01282192, -.06920497, -.04869258, -.08395361, -.08776157, .04641813, -.0877328, -.08681581, .00709072, .00706405, -.00633969, .00706404, .00860649, -.01384978, -.01393683, .00266246, -.01393674, -.01007085, -.31333024, -.37345682, .09410699, -.37154563, -.26437405, .3459756, .30014247, -.10917801, .29913459, .29676912, .05033621, .04904892, -.04126522, .04904343, .05935515, .27297642, .23839854, -.44293958, .23767122, .40414907, -.22933082, -.27152466, .85380151, -.27023816, -.44782045, -.35040168, -.41739729, .03751391, -.41527542, -.20962909, .28805578, .25385397, -.14204666, .25317931, .28672886, -.65490533, -1.0599143, .19490193, -1.0200478, -.5508936, -.47018372, -.61418078, .07468916, -.60693471, -.32082947, -.47721825, -.63924909, .12138493, -.63023495, -.38095729, 1.3476126, .88016734, -.65872221, .85410151, 1.3374805, -.40137402, -.50502353, .09267038, -.50060927, -.3102343, -.11566665, -.12280419, .04637906, -.12273083, -.10746228, -.64272384, -1.0352977, .21481796, -.99709771, -.56197432, 1.1198415, .78055866, -.33657388, .76386521, .94509292, -.37840693, -.47789095, .16625793, -.47357901, -.36244616, .35985366, .31101251, -.10441355, .30991237, .30015546, -.51498973, -.74001592, .26070601, -.72405173, -.51712166, -.4990457, -.68787284, .15597986, -.67620687, -.42670368, -.36024144, -.4345239, .05036177, -.4319889, -.23556248, .10090429, .09583676, -.09734933, .09579437, .12562056, .10500037, .1005026, -.01522613, .1004705, .06950249, -.55590106, -.80661548, .16621952, -.78828286, -.46834836, .97445552, .71012257, -.20075028, .69840821, .72510918, .07514112, .07271582, -.01493122, .07270277, .05524507, -.47107749, -.65198934, .26838357, -.64065111, -.49202844, .4069781, .35245994, -.03370757, .35124777, .22351148, -.49908369, -.72063411, .36333215, -.70467725, -.56566615, .79057675, .59611118, -.27347639, .58826455, .69921805, .08300378, .07991925, -.02564544, .07990015, .07069879, 1.3209475, .88013486, -.40927206, .85640889, 1.1261711, 1.1385706, .77137101, -.77741171, .75222023, 1.2631851, -.14866611, -.16067507, .05542297, -.16051359, -.13480767, -.44572032, -.58061113, .1066508, -.5739016, -.34863661, 1.2907402, .84279895, -.93782602, .81780937, 1.4619863, 1.0002664, .6747233, -2.5314396, .65760149, 1.7174192, .16224712, .1507751, -.06376113, .15064005, .14973155, -.58306357, -.88826504, .23450017, -.86256129, -.54225262, -.60546947, -.94470352, .2370439, -.91424776, -.55806026, -.04588784, -.04702499, .03300025, -.04702029, -.05179813, -.12428197, -.13234103, .03921224, -.132254, -.1065997, -.25465265, -.29114693, .06175708, -.29027839, -.20008032, -.22189215, -.24960362, .06676593, -.24902841, -.18733672, -.04215724, -.04303719, .01460919, -.04303412, -.03730784, -.46370116, -.61126413, .10478294, -.60355598, -.35584892, -.1524219, -.16487794, .04980965, -.1647085, -.1322755, 1.0631753, .75853504, -.22129347, .74431333, .79384572, .55206403, .44506498, -.22111313, .44164051, .51271318, -.11179798, -.11844282, .04470382, -.11837704, -.10377215, -.28236901, -.3243892, .03560427, -.32335101, -.17839748, -.62694557, -1.1149174, .68460729, -1.0556368, -.81341166, .01335705, .0132603, -.01529862, .01326018, .01760764, .04115702, .04034471, -.01850457, .04034204, .03972516, .01838351, .01821034, -.01302698, .01821006, .02064953, .26479015, .23667301, -.08394001, .23617666, .22747529, .48889433, .4011329, -.22931042, .39852767, .4785874, .5222803, .43058076, -.10359255, .4279173, .38375608, -.30676865, -.3580404, .04235269, -.35661899, -.19976113, -.34268654, -.41891825, .12481144, -.41611461, -.30833737, -.07302125, -.0755844, .01610214, -.07556941, -.05558241, -.53696253, -.74382336, .0957976, -.73081965, -.38085313, -.42031073, -.54401294, .14415932, -.53802518, -.37068461, -.01591942, -.01604737, .00779645, -.0160472, -.01580983, -.0188094, -.01896496, .0026473, -.01896475, -.0123271, .70188734, .54645815, -.17523172, .54079296, .55683413, -.3441711, -.41329873, .06069805, -.41100009, -.2431744, -.04686378, -.0479702, .01831092, -.04796584, -.04316565, -.56945387, -.80345967, .08467915, -.78780703, -.38010874, .82247946, .62664704, -.128373, .61898959, .55793629, .10768572, .10302446, -.01375552, .10299085, .06832942, -.19258597, -.21414592, .09032336, -.21374456, -.18852102, -.32378256, -.40978659, .61736445, -.4060211, -.50585515, .46677348, .39278085, -.07630821, .39083757, .3215668, .05401344, .05258224, -.03271933, .05257593, .05758102, -.22367683, -.25427639, .12370828, -.253581, -.23132554, -.44651825, -.61106296, .32816171, -.6011534, -.5076902, -.48923259, -.68118483, .22278358, -.66890378, -.47422158, -.39463212, -.51350542, .2746272, -.50761948, -.44060843, .65042399, .51832042, -.10674184, .51389442, .44866197, -.48063527, -.6859908, .40332796, -.67173158, -.57118028, .21558589, .1973213, -.04111851, .19706381, .15635173, 1.2116469, .8244019, -.40966174, .80437457, 1.063496, -.29438491, -.36331022, .58922179, -.36064427, -.46742646, -.20520111, -.22818804, .05463765, -.22775983, -.16632613, .35596893, .30277928, -.33753765, .30146157, .44061452, .08897616, .08515727, -.05836642, .08512997, .09740475, 1.4483664, .95547149, -.26974832, .92846127, 1.0421139, .04825085, .04712187, -.02522913, .04711747, .04897571, -.20903291, -.23002077, .02022173, -.2296702, -.12089988, -.5890277, -.89836948, .21952511, -.87223592, -.53406635, -.29072761, -.34975442, .25196987, -.34777063, -.34923443, .31366216, .27510212, -.10497666, .27431477, .27437782, -.49735208, -.65677986, .06244199, -.64839273, -.31377009, -.00493755, -.00495056, .00428246, -.00495055, -.00593265, -.14535234, -.15625504, .03659025, -.15611888, -.11563247, -.5964309, -.90336615, .18057337, -.87792773, -.50458537, -.00992831, -.00998084, .00820446, -.00998079, -.01173843, -.05324062, -.05451998, .00769293, -.05451486, -.03519946, .74723262, .58871995, -.06104652, .58317891, .40850826, .92386917, .66813996, -.41115462, .65658666, .88869357, .4894384, .40733204, -.10135246, .40505181, .36482685, .59609854, .48339414, -.08819533, .47987366, .3972256, -.23882443, -.26915205, .04202611, -.26851201, -.16861733, .40116282, .33785748, -.24326036, .33620229, .42780668, .0479421, .04685654, -.01956438, .04685244, .0448033, .53941314, .43976727, -.14773511, .43672479, .44135249, 3.8526804, 1.8217191, -.75647537, 1.6619172, 2.8213064, -.12455221, -.13244019, .03175268, -.132357, -.09950336, -.52318843, -.72541264, .12008382, -.71265968, -.40359296, .13619695, .12835979, -.03341989, .12828468, .10742943, -.09062037, -.09500845, .04362382, -.09497306, -.08948189, -.22329489, -.25168974, .0727166, -.25108967, -.19355618, .67370954, .53136698, -.13281006, .52641064, .49400967, -.20243394, -.22276238, .02616932, -.22242277, -.12896238, -.27365042, -.32240267, .16586027, -.32096284, -.29177956, -.05991093, -.06182501, .03502458, -.06181482, -.06311584, .07493902, .07205309, -.08161657, .07203458, .09714224, -.57627448, -.84764461, .15470794, -.82696848, -.46838228, .09873071, .09432918, -.03659185, .09429649, .08935242, .27590214, .24526493, -.09739294, .24469949, .24567212, -.38698872, -.49057608, .15557606, -.4860064, -.35985134, -.06259506, -.06461343, .02669906, -.06460259, -.05936567, -.06550517, -.06768315, .02414352, -.06767108, -.05917349, -.55225301, -.80145349, .17567744, -.7832224, -.47497861, -.00714523, -.00717403, .01000028, -.00717401, -.0100699, 1.2602841, .82671822, -.98172356, .80272251, 1.4610061, 1.043912, .73341473, -.44646877, .71840001, .99094516, -.43132456, -.5662489, .16893532, -.55931775, -.39760601, .39438992, .33470387, -.17201905, .33320649, .37683629, -.50414255, -.67732771, .0836691, -.66758313, -.34906041, 1.8470935, 1.1320365, -.35763665, 1.0880446, 1.3463251, .6694033, .51885462, -.3132809, .51328419, .65480684, -.2755584, -.31846568, .06013792, -.31735681, -.20902677, -.53109785, -.70632029, .04370179, -.69684025, -.29104452, -.38016339, -.48416495, .20549193, -.47947802, -.39017112, -.21644843, -.24806102, .26047917, -.24729436, -.29007076, .22464717, .204938, -.04238525, .20465029, .16233627, .18255798, .16745986, -.12147509, .16725206, .20080427, .18834064, .17271266, -.09791501, .17249686, .19080473, -.35425951, -.4428542, .20514244, -.43919807, -.37202848, .21969688, .1999514, -.0650006, .19965615, .18444422, .122713, .11616948, -.03648803, .11611136, .10319386, -.42723475, -.55833711, .1626259, -.5517272, -.39010748, -.02451718, -.02479725, .00557298, -.02479671, -.0188518, -.04687689, -.04802464, .02506269, -.04801996, -.04793563, .05305057, .05167392, -.03107604, .05166797, .05592577, -.31050077, -.37292577, .13922555, -.37084803, -.29942733, .20887052, .1890275, -.17334826, .18871394, .24730596, .12160078, .11432671, -.12128972, .11425424, .15307663, -.4786629, -.6404824, .11557347, -.63151775, -.37553397, .69538074, .5308133, -.45327777, .52441604, .75964948, .07554328, .07283333, -.03894072, .07281713, .07631476, -.16002451, -.17249543, .02306356, -.17233363, -.10570847, .28745241, .25362713, -.13105163, .25296582, .27874138, -.31900993, -.38422716, .12564022, -.38202034, -.29461557, .15846756, .14444768, -.75377929, .14424131, .33577754, .67802328, .53342129, -.14224838, .52834012, .50760066, .32227808, .27988621, -.17800649, .27896053, .33315203, -.689705, -1.2063613, .27705579, -1.1457302, -.64117216, .50862172, .41457705, -.23910062, .41170299, .4982724, -.55756118, -.81008919, .16580611, -.79154937, -.46889096, .6659468, .51830268, -.27094785, .51291508, .6217249, .54504791, .4418793, -.18302942, .43865311, .47731683, -.23168171, -.26098984, .05206213, -.26037367, -.17746463, 1.5564676, .98481622, -.55095472, .95125094, 1.3872094, -.21817516, -.24439497, .05716511, -.24387114, -.1758965, -.11225338, -.1190164, .04839388, -.11894854, -.10684144, .79514812, .59562841, -.34278122, .58742223, .75679984, -.21647274, -.24183736, .0502126, -.24134324, -.16757776, -.35997872, -.44684088, .14337273, -.44338005, -.33369529, .40854687, .34382458, -.21996117, .34212582, .4187485, -.1530492, -.16604881, .06557914, -.16586503, -.14537374, -.14413865, -.15581035, .07238166, -.15565302, -.14434657, -.09408929, -.09840609, .02053462, -.09837309, -.07137273, -.39301475, -.48727188, .06827468, -.48353887, -.27629252, -.24605572, -.28276665, .10912952, -.28185731, -.23641755, -.74467796, -1.2573597, .10835057, -1.2016485, -.49347603, -.4022203, -.52233619, .22385208, -.5164387, -.4168435, .06682166, .06472335, -.02944639, .06471237, .06406668, .57766322, .46671261, -.13758116, .46319305, .45114152, -.01968855, -.01987486, .00607468, -.01987457, -.01676204, -.72534761, -1.3803908, .35614986, -1.2895402, -.72097197, -.39755281, -.50932555, .17015997, -.50415182, -.37747861, .05541468, .0540372, -.01466541, .05403149, .04482545, -.33090587, -.40446483, .16434529, -.40176137, -.33016579, -.0854305, -.08925077, .03581858, -.08922231, -.08056037, -.20923584, -.23549068, .11068174, -.23494313, -.2132027, -.38497634, -.48980343, .18049086, -.48510088, -.37680596, -.55067069, -.77949325, .11744861, -.76402275, -.41452806, .3514565, .30426126, -.11196786, .30320938, .30242813, -.36442407, -.45596798, .1683269, -.45217357, -.35492169, .55862248, .45711991, -.09137459, .45407064, .38491433, .98757975, .71248778, -.26417743, .69998509, .80172117, -.17833263, -.19639535, .07713576, -.196091, -.16992181, -.01980995, -.02000314, .0075547, -.02000282, -.01809969, .01791458, .01776767, -.00452259, .01776747, .01426517, .12051318, .11439804, -.02599857, .11434635, .09106458, -.57040743, -.83976402, .17023686, -.81918687, -.48026911, -.48418655, -.65617892, .13978045, -.64618233, -.40318153, -.41376686, -.53658243, .17206738, -.53058805, -.3891168, -.39736418, -.52230491, .33561927, -.51585445, -.47324363, .789415, .61140354, -.08671464, .60479997, .47633342, -.45273112, -.61077915, .21682458, -.6017464, -.44627895, .04048982, .0397188, -.01513165, .03971635, .03674537, -.63470698, -.9674859, .11984384, -.93941626, -.45877254, .2618683, .2330883, -.13239143, .23256256, .26283624, .19377173, .17770167, -.07757214, .17747988, .17993081, .58723259, .47367768, -.13114675, .47005153, .44888588, .69307845, .53813346, -.219424, .53243351, .59514982, -.57764781, -.86068256, .18440667, -.83828911, -.49740593, -.26782449, -.31198634, .1139541, -.31077833, -.2537972, -.70868634, -1.1711819, .1297819, -1.1233345, -.50704995, .4606641, .38328251, -.16715777, .38113069, .41397594, -.19014589, -.20787589, .02417353, -.20760079, -.12046142, -.37788839, -.4836057, .24762906, -.478736, -.41354195, -.17801827, -.19425086, .03434979, -.19400454, -.12960679, -.48308859, -.65038326, .12323755, -.64089631, -.38601917, .25848821, .23234614, -.06074086, .23190649, .2009698, .11192558, .10615829, -.05454158, .10610878, .11096997, 2.2103467, 1.2399104, -.96744817, 1.1734462, 2.1144277, .54133925, .44631372, -.07756959, .44355424, .35690572, -.32947276, -.39838731, .11327762, -.39600213, -.29080668, -.06956448, -.07214855, .03847715, -.07213256, -.07194534, .34574032, .29872866, -.1467757, .2976678, .32738698, -.36442537, -.44325897, .06336404, -.44043841, -.25626936, -.52417636, -.76654556, .30147977, -.7483973, -.54922168, -.10294317, -.1082127, .02503518, -.10816776, -.08095778, -.44853287, -.60675929, .24784799, -.59762437, -.46373298, .54811133, .43721149, -.40008915, .43350971, .62178672, -.77339733, -1.4128057, .15830115, -1.3308055, -.57425723, .00311698, .00311258, -.00065575, .00311257, .00233568, .16546273, .15367022, -.05901408, .1535303, .14784115, 1.0782845, .74165035, -.72184466, .72461628, 1.1884479, -.14325199, -.15333407, .02454582, -.15321592, -.10024659, -.54106483, -.74855613, .0879214, -.7355701, -.37199839, -.01554362, -.01565892, .00462261, -.01565877, -.01307195, .23435681, .21389756, -.02870592, .21360038, .14663992, -.21589488, -.24409962, .11654564, -.24348735, -.22148122, -.40602043, -.51951841, .13874424, -.51429434, -.35764068, .01460532, .0145034, -.0053337, .01450328, .01315306, .47378981, .39536301, -.11230566, .39321344, .36943187, .17730636, .1633511, -.09257247, .16316828, .17988164, .58137418, .47440216, -.07731488, .4711487, .37388226, -.43695412, -.55995752, .0805111, -.55425701, -.31327025, .62747558, .50448334, -.09127002, .50050337, .41576756, -.37398313, -.47031284, .16050385, -.46622059, -.35541833, -.38488016, -.48811777, .16465811, -.48355422, -.36538837, .16882954, .15590683, -.10322184, .15574218, .18053697, -.05819763, -.05994739, .02620706, -.05993863, -.05620215, -.00378748, -.00379413, .00093389, -.00379412, -.00299233, -.45740353, -.60989175, .15335998, -.60155781, -.40035663, .96274755, .69683538, -.28652439, .68484684, .80985166, .05958472, .05779674, -.04800426, .0577878, .0698543, -.61316876, -.97866302, .28179435, -.94389586, -.59617547, -.21870465, -.24783391, .12138522, -.24718931, -.22644911, 1.2191264, .82944004, -.39078432, .80928401, 1.0512069, .19790549, .18076257, -.1024348, .18051548, .20020015, -.3915342, -.49898009, .16549726, -.49412317, -.37021448, -.05989271, -.06170904, .02243475, -.06169987, -.05439592, -.60835317, -.9374616, .19454908, -.90887105, -.52415159, .93726962, .66527905, -.73159374, .65242844, 1.0872841, -.77961717, -1.3707204, .10873488, -1.3005904, -.50939407, .51118936, .41853336, -.180392, .41575656, .45513157, .10664256, .10189676, -.01941382, .10186158, .07614956, .54394214, .44253993, -.15439524, .43941602, .45039107, -.04468064, -.04568047, .01682746, -.04567674, -.04065329, .42232032, .35761426, -.11465577, .35597103, .3445376, -.11373807, -.12003518, .0216566, -.1199771, -.08244114, -.24970214, -.28577578, .07665105, -.28491036, -.21222549, .14967316, .13887169, -.14929294, .13874192, .18841655, -.04416694, -.04517034, .02105742, -.04516655, -.04347203, .09550975, .09136204, -.03706601, .09133203, .08777425, -.60345573, -.90964065, .15374561, -.88460156, -.4819935, -.39335361, -.4858555, .05967075, -.48226216, -.26431345, .91188654, .67179381, -.22367346, .66145241, .71918731, .0893321, .08542113, -.06841059, .08539261, .10297287, 1.0542231, .74207457, -.38557647, .72704413, .94987954, -.80140281, -1.4468496, .10861552, -1.3659914, -.51865018, -.65661096, -1.0909152, .25248002, -1.045425, -.60157682, .77179132, .59281922, -.15014697, .58599761, .56344143, -.07764923, -.08065276, .02253154, -.08063341, -.06476868, -.06175517, -.06377033, .03294705, -.06375937, -.06310509, .50650259, .41570612, -.16991997, .41301447, .44341725, -.40926117, -.52588389, .14652362, -.52041418, -.36613921, -.45927482, -.61604101, .17002452, -.60727483, -.41549163, 1.0567886, .74734019, -.3202118, .73259505, .89429581, -.11140128, -.11790377, .03960864, -.11784055, -.09943366, -.30337178, -.36215487, .13026612, -.36026837, -.2883615, -.42253305, -.55498618, .20169408, -.54816798, -.41605253, -.25977024, -.30503888, .21535438, -.30373086, -.3074592, .32950947, .28807868, -.09057868, .28721359, .26993794, -.18003178, -.19723229, .04531631, -.19695886, -.14321691, .09805314, .09330175, -.08653726, .09326339, .1185001, -.49089533, -.70725054, .399791, -.69177447, -.57758194, 1.1664585, .8161681, -.21232685, .79907572, .83289675, -.4644781, -.64735139, .34389256, -.63561204, -.52941278, -.41856481, -.55305757, .25163428, -.54596576, -.44508375, 1.1278749, .7967161, -.19805737, .78089615, .79575792, .34566979, .29986766, -.1102072, .29886025, .29752327, -.37267293, -.46647729, .14254855, -.4625815, -.34083917, .24961853, .22378361, -.10251373, .22333903, .23376988, .53624914, .43791335, -.14162413, .43493246, .43347777, .02897433, .02856922, -.01272993, .02856828, .027752, .08015478, .07737286, -.01771104, .07735678, .06105356, -.50476571, -.70753251, .19691235, -.69426216, -.46468738, -.40522231, -.52445365, .19283833, -.51868373, -.39859944, -.30219412, -.35872948, .10546732, -.35697701, -.26806492, -.35942658, -.45131409, .21023945, -.44743922, -.37872287, .26996379, .24234186, -.04851345, .24187193, .19194099, .4646472, .38552663, -.18330676, .38329676, .42935683, -.3275455, -.38444346, .03295657, -.38280459, -.19194278, -.55860279, -.78929956, .10141245, -.77379405, -.39851299, -.05774895, -.05942333, .02039347, -.05941524, -.05142841, -.08416668, -.08876627, .21614889, -.0887244, -.14521823, -.51076446, -.69909851, .11233086, -.6877496, -.38843958, -.50295582, -.68588962, .11774145, -.67501102, -.39054674, -.15478959, -.16820163, .07018808, -.16800822, -.14982776, .23271758, .20738762, -.3068774, .20692933, .32152723, -.37941033, -.46960824, .08548247, -.46606675, -.29087638, -.25435962, -.29035462, .05680228, -.28950863, -.19443034, .06588453, .06368361, -.05917427, .06367135, .08008969, .01837002, .01819873, -.01193611, .01819846, .02004645, -.40509825, -.51115711, .09388126, -.50657893, -.3135041, .39800708, .33995085, -.1050213, .33854642, .32163477, -.07725479, -.08029924, .02749215, -.08027925, -.06897576, -.20637628, -.22811815, .0325346, -.22773717, -.14046399, .08154315, .07840933, -.04072179, .07838927, .08150995, 1.1910859, .80960517, -.48571352, .78983713, 1.1128384, .26456618, .23553114, -.12012076, .23500149, .25619594, .23971249, .21576538, -.09755645, .21536754, .22381495, .12466272, .11807848, -.02929845, .11802056, .09692801, -.04478352, -.04579575, .01802714, -.04579193, -.04166114, .08461206, .08145068, -.02316046, .081431, .06921718, -.11222889, -.11827756, .01927437, -.11822326, -.0785971, .66826592, .5290729, -.11819708, .52429317, .47261967, -.02497361, -.02526647, .00606328, -.0252659, -.01962908, -.18560142, -.20481407, .06635467, -.20448324, -.16596685, -.42062705, -.55511035, .23495048, -.54805336, -.43644907, .37335652, .32316837, -.06983945, .32204863, .26902507, .44395122, .37075775, -.18027585, .36875953, .41420248, -.10149399, -.10627658, .01402168, -.10623904, -.06610539, 1.6776906, 1.0774226, -.19261374, 1.0429959, 1.0273387, -.03187361, -.03248491, .06531512, -.03248296, -.05100766, .06182835, .06003111, -.02647815, .0600224, .05871706, -.48307609, -.64353785, .09701343, -.63479909, -.35642185, -.81096394, -1.6544539, .22537601, -1.5221645, -.66677645, -.4026664, -.51871387, .17880383, -.51321067, -.38704892, -.06926005, -.07178871, .03438955, -.07177333, -.06909936, -.66360562, -1.0288145, .10497055, -.9965726, -.45217429, -.33803354, -.41156213, .11995102, -.40891704, -.30152119, .22568917, .19695072, -2.1495738, .19634307, .60274637, -.10028386, -.10594532, .06968719, -.10589208, -.1119133, -.33326482, -.40322095, .10587404, -.4007912, -.2865054, .01988369, .0196859, -.01143858, .01968557, .02083525, -.17025897, -.1869918, .08834197, -.1867182, -.17237424, .23507155, .21421042, -.03318566, .2139024, .15421509, -.28474643, -.33233788, .07686481, -.33101849, -.2318594, -.58720124, -.87273312, .15584735, -.85030475, -.47544591, -.61495582, -.98260761, .27888785, -.9475382, -.59527248, -.56243197, -.80025237, .10867358, -.78390244, -.40966732, -.14077564, -.15085131, .03234317, -.15073124, -.10863152, -.18260914, -.20079369, .05591265, -.20049242, -.15507021, -.24439112, -.29069365, .62906119, -.28924033, -.42198587, -.73811111, -1.2279392, .10035927, -1.176477, -.47820082, -.50644645, -.72439785, .27553577, -.70915905, -.52090479, -.17399597, -.19079487, .06462178, -.19052501, -.15757806, -.44498495, -.60721357, .31775135, -.59754437, -.5011134, .07172271, .06957196, -.01082252, .06956122, .04810873, .21509852, .19535678, -.09567971, .19505536, .20687511, .02863796, .02827191, -.00613238, .02827113, .02158645, .25546167, .22796332, -.12927557, .22747127, .25648737, -.34061627, -.41792931, .14965998, -.4150289, -.32625373, .77469004, .57754495, -.51279666, .56932591, .85063591, .39144017, .32691917, -.49215888, .32515813, .53229866, .59615035, .45419211, -1.6874646, .4486407, 1.0624914, -.17837085, -.19626745, .07154096, -.19596873, -.16573371, -.1003708, -.10577087, .04640926, -.10572247, -.09778746, -.09795612, -.1029221, .03435635, -.10288016, -.08703623, .09295039, .08865096, -.08461053, .08861783, .11349732, -.4072643, -.54113581, .3577372, -.53391891, -.49141559, .65382402, .50566575, -.41751741, .5001435, .70937429, -.5575895, -.85145524, .34610208, -.82654647, -.59926805, -.10217966, -.10730779, .02252941, -.10726492, -.07777433, -.06366886, -.06577556, .02907765, -.06576394, -.06177525, -.43525928, -.57286957, .16729571, -.56572687, -.39872208, -.49811105, -.67619761, .11554628, -.6657818, -.38560806, .50090974, .40769452, -.29216005, .4048278, .52729857, .86268364, .61965343, -.9182124, .60848892, 1.1097507, -.62052198, -.92951709, .11244186, -.90469252, -.44240917, -.06257593, -.06445174, .01429789, -.06444237, -.04819909, -.34703233, -.42965766, .176219, -.42640866, -.34882494, -.05892985, -.06083489, .04422308, -.06082463, -.0674709, -.24691258, -.28168847, .06957238, -.28087497, -.20394721, -.36903059, -.45514355, .09453386, -.45182378, -.29528907, -.18309023, -.20412071, .16476016, -.20371905, -.22270887, -.44482225, -.61975687, .4830332, -.60853947, -.57604975, -.08058226, -.08362613, .01368654, -.08360697, -.05622561, .20211563, .18364076, -.15093069, .18335982, .23103039, -.26383763, -.30228513, .05257534, -.30135479, -.19416094, .50169006, .41084605, -.20709964, .4081262, .47064499, .85690669, .62910114, -.42150416, .619198, .85224863, -.67448662, -1.1321169, .2257037, -1.0830488, -.58998158, -.24488697, -.28097606, .10361773, -.28009299, -.23163195, -.39807196, -.49524433, .06909688, -.4913284, -.27977175, -.33216003, -.39639229, .06221035, -.39433499, -.2394395, -.38177713, -.48617498, .19811154, -.48147219, -.38653296, -.08027696, -.08357483, .02877727, -.08355226, -.07184896, -.36011292, -.4494137, .1704529, -.4457589, -.35359322, .22393373, .20272089, -.09636476, .20238664, .21300792, .01812136, .01797578, -.00342167, .01797558, .01309834, 1.0445171, .75843336, -.13225875, .74563807, .66083825, -.22269522, -.25013243, .05856105, -.24957055, -.17975744, -.60386461, -.91304686, .15964353, -.88754515, -.48830011, .10351565, .09820456, -.09771299, .09815917, .12793758, .18780321, .17260011, -.07782076, .17239528, .17640484, .39839468, .33369914, -.35895544, .3319591, .48480363, -.56902707, -.872537, .31107061, -.84651874, -.58620782, .52082414, .42577496, -.16874438, .42290727, .45069269, -.27582253, -.32232201, .10543888, -.32102181, -.25221065, .13055037, .12300944, -.04868599, .12293689, .1183941, -.70347537, -1.2040031, .1943892, -1.1479507, -.57729789, .31150776, .27687318, -.03738351, .27623316, .19358986, -.26786344, -.30662368, .04423454, -.30569231, -.18515671, -.10166485, -.10788655, .12161541, -.10782314, -.13597323, -.28141867, -.32648367, .06218693, -.32528622, -.2143606, .12675404, .11969532, -.04304958, .11962985, .11142283, .00564854, .00563403, -.00124235, .00563403, .00429585, .70315729, .55232744, -.11447213, .54699757, .48373952, -.57315138, -.83876186, .14921006, -.81883073, -.46109342, -.32012522, -.38622687, .13072175, -.38396798, -.29923051, .19846144, .18343456, -.02536435, .18324517, .12595111, .40129512, .33990812, -.16938496, .33835163, .37926625, -.22856924, -.25983375, .10393876, -.25912335, -.22145273, -.01674834, -.01690274, .01757409, -.0169025, -.02144283, .451725, .37640179, -.17925774, .37432235, .41823341, -.5069588, -.73016766, .30740562, -.7142168, -.54062448, .14639697, .13762086, -.02806901, .13753324, .10635889, .54156343, .43020691, -.53963023, .42643087, .68151431, -.00369693, -.00370369, .00164843, -.00370369, -.00355845, -.00518422, -.0051979, .00293264, -.0051979, -.00540197, .52562602, .42180305, -.41413477, .41841804, .61165772, -.34805066, -.41861733, .0591539, -.41624897, -.24290294, .19213086, .17635487, -.07498533, .17613929, .17690231, .59949237, .46575827, -.68085713, .4608489, .78804516, -.269149, -.31443131, .12642314, -.31316769, -.26360119, -.08055403, -.08380109, .02383641, -.08377928, -.06763141, -.52710152, -.74389095, .15786241, -.72937786, -.44432329, .23318428, .21130044, -.06324005, .21095881, .19016923, -.347374, -.41668089, .05385617, -.41439143, -.23511844, .73367753, .56669864, -.17585896, .56044855, .57420678, .17500619, .16226928, -.04652948, .16211496, .14178219, .94605452, .68612388, -.30550686, .67446351, .81776358, .50546688, .41903062, -.09826981, .4165844, .36893103, -.18998405, -.20998685, .06278385, -.20963655, -.16548961, .37311908, .31743209, -.22857165, .31605411, .39925383, -.01912069, -.01932781, .02543713, -.01932743, -.02649527, .31556855, .27535671, -.14827811, .27450587, .30909939, .39197774, .33229297, -.19381106, .33078654, .39052046, -.6211055, -.94356796, .13609918, -.91661946, -.47177916, -.39929942, -.51206168, .16883709, -.50681948, -.37759979, -.50640822, -.68089631, .08212162, -.6710497, -.34793357, -.05687068, -.05829852, .00664011, -.05829255, -.03502091, -.14211899, -.15451163, .14617386, -.15433177, -.1807457, -.20880173, -.23566553, .13577928, -.23509118, -.22791726, -.12352715, -.13063606, .01541625, -.13056792, -.07777581, -.43868933, -.59652185, .33072572, -.58723422, -.50304176, -.29153569, -.3398282, .05973137, -.33850118, -.21654026, .13964675, .13118796, -.04536704, .13110264, .12095134, -.03966402, -.04042777, .01176078, -.04042532, -.0333237, .75850883, .58647238, -.12878309, .58005447, .52917993, .15005071, .14060256, -.03747029, .14050349, .11905046, -.68233406, -1.0671377, .09382966, -1.0323789, -.44373267, -.27654892, -.3235601, .10951834, -.32223473, -.25587052, -.28516153, -.33071434, .05497475, -.32950686, -.2075511, -.26369445, -.30841731, .15767347, -.30715932, -.27989612, .3169408, .27673987, -.13613017, .27589314, .30128688, 1.0952246, .78043927, -.18254339, .76570135, .75939459, .13669411, .12921327, -.01984136, .12914508, .0905108, .330727, .28661029, -.16907958, .28563349, .33318605, -.63230002, -.9027777, .04523618, -.88397517, -.33071515, -.52766834, -.77382029, .29878069, -.75523288, -.55000698, -.05007151, -.05137913, .02586399, -.05137344, -.05061769, -.42531462, -.5499931, .12801344, -.54398146, -.35911653, -.1297289, -.13839983, .03563857, -.13830332, -.10625301, -.21443397, -.24183356, .10423078, -.24125174, -.2124244, .46625586, .38202951, -.3615271, .3795137, .53968434, 1.2041013, .79553721, -1.1263728, .7732085, 1.4836999, -.26296011, -.30456318, .09809341, -.30347089, -.23849715, -.31697151, -.37666494, .07536004, -.37480244, -.24740237, -.22314465, -.2540796, .13911348, -.25336724, -.24017293, -.31576921, -.38059817, .14030666, -.37839529, -.30358662, -.35073082, -.4215313, .05400701, -.4191653, -.23685142, -.09403073, -.09858561, .03256135, -.09854885, -.08319374, -.27935476, -.32542194, .08138768, -.3241617, -.23332805, -.62213469, -.92903391, .1052494, -.90459631, -.43351702, -.14938662, -.16149883, .05493428, -.16133536, -.1348442, -.20664992, -.23418287, .19152947, -.23357339, -.25385089, -.26586532, -.30991069, .12496911, -.30870023, -.26044659, -.25807377, -.29778868, .09331687, -.29677423, -.23164662, -.30314598, -.36319764, .15247232, -.36122789, -.30374435, .24775518, .22381456, -.05283603, .22342979, .18649558, -.24843365, -.28577432, .1066353, -.28484257, -.23611157, -.70001612, -1.1721137, .16366661, -1.1217738, -.5433363, -.16368619, -.1785629, .06550496, -.1783379, -.15197638, -.22438792, -.25222303, .0580311, -.25164911, -.18012055, 1.4120916, .91321611, -.61659021, .88493049, 1.3497421, -.08394263, -.08770191, .04174102, -.08767387, -.08378882, .11246524, .10698612, -.0304348, .10694165, .09165279, .73968257, .56947986, -.19038664, .56304099, .59281486, 1.4090884, .91290803, -.5933184, .88485893, 1.3306528, -.2440235, -.28366336, .21559238, -.28259501, -.29501374, -.24924191, -.28846526, .14492164, -.28744088, -.26210086, -.24698227, -.28058286, .05372172, -.27982347, -.18714167, -.45857664, -.62671937, .25786659, -.61664209, -.47688791, -.61800719, -1.0276645, .41359248, -.98467025, -.68107755, -.39285108, -.49992802, .15444424, -.4951199, -.36259282, -.40121812, -.53012827, .35290152, -.52333129, -.48433762, -.54848998, -.78129082, .13547929, -.76522807, -.43359084, -.42025715, -.56786194, .4070682, -.55937626, -.52389284, .34029902, .29960747, -.04043193, .29879914, .21077801, -.80333773, -1.5357323, .16225583, -1.433301, -.59384834, .35708367, .31125712, -.05966209, .31028061, .24779325, -.5847827, -.85951985, .13601524, -.83863343, -.45310849, -.40549831, -.53574142, .32356278, -.52887632, -.473866, -.40787468, -.51196956, .0756231, -.50758728, -.29303038, .0808268, .07791694, -.02345714, .07789948, .06742257, .11103542, .10540773, -.04950461, .10536021, .10687257, -.15895282, -.17356782, .09076858, -.1733442, -.16615013, -.48207555, -.64863346, .1236818, -.63920946, -.38594196, -.41828669, -.54416709, .17141096, -.53793991, -.39144633, -.25512486, -.2982931, .20198933, -.29708165, -.29736372, -.37029916, -.46148307, .13034527, -.45777687, -.32941516, .47744139, .39992459, -.08417699, .39784011, .33730376, -.00934437, -.00938289, .00143207, -.00938286, -.00630035, -.02772804, -.02810658, .0100532, -.02810572, -.02491098, -.10725828, -.11332995, .04162304, -.1132727, -.09856933, -.59832789, -.92792556, .24138858, -.89880156, -.55702549, -.57759115, -.85775157, .17569523, -.83579705, -.4894147, -.33794661, -.40552683, .06817076, -.40328937, -.24971317, -.62978867, -1.0370275, .32123178, -.99525298, -.6339856, -.68597933, -1.1991312, .28782311, -1.1389871, -.64703221, -.49037436, -.67011574, .15054169, -.65934682, -.41678694, .55890967, .45229089, -.16472336, .44893128, .46862216, .32741952, .28625396, -.09524658, .28539446, .27333558, -.35087844, -.43207793, .13403453, -.42897309, -.32076479, 1.5813168, .97846186, -.93921735, .94187025, 1.6747293, -.44018906, -.55989131, .06126661, -.55452844, -.28741589, .06129037, .05954432, -.02349401, .05953603, .05609497, -.46163541, -.60840753, .10801341, -.60074747, -.35840053, -.29875723, -.36047311, .2278336, -.3583632, -.34389686, 1.4552584, .95668254, -.2900742, .92919281, 1.0710419, .53780487, .43727525, -.17474037, .43416999, .46582655, .41170242, .34757772, -.16990823, .34592261, .38619243, -.12477915, -.13336909, .06188318, -.13327062, -.12444064, -.35026659, -.42755531, .09928534, -.42473541, -.28989286, -.49730549, -.6883825, .17444435, -.67640159, -.44188691, -.20168938, -.22264205, .03508153, -.22227998, -.14184854, -.3716121, -.4675208, .17101449, -.46343851, -.36147717, .10483886, .09985598, -.04200895, .09981653, .09738053, -.31658804, -.37002846, .03532148, -.36853229, -.19202272, -.47864818, -.68117839, .39635932, -.66724558, -.5663053, -.62571462, -1.0136703, .28378283, -.97539099, -.60569814, -.43625711, -.56745388, .1219175, -.56096812, -.35935776, -.3768037, -.50466399, .80072945, -.49755497, -.61035434, 1.0621417, .75963392, -.20403967, .74559242, .77215265, .0328903, .03226835, -.07481728, .03226639, .05449908, -.17185771, -.18674733, .03037659, -.18653262, -.12151663, .0236511, .02340173, -.00486029, .02340129, .01758457, -.43862113, -.57065469, .11743041, -.56412149, -.35617482, .46269548, .38383737, -.19158832, .38161295, .43450674, .18951731, .17559938, -.02694152, .17542923, .12461872, -.32747899, -.41462936, .5704933, -.41080661, -.49645796, .25758844, .23049773, -.09449579, .23002404, .23232632, .31758568, .27759082, -.12377705, .2767544, .2922788, -.34218485, -.42648063, .24580193, -.423053, -.38611109, -.4088183, -.51638855, .09005913, -.51172227, -.3110805, -.80521678, -1.4050351, .07860527, -1.335001, -.46712786, -.8546913, -2.0223329, .29883109, -1.7923761, -.75862086, .69311103, .53298743, -.33765129, .52690642, .6871233, 1.1947123, .81219341, -.47164122, .7923775, 1.1042214, -.40009891, -.49501237, .0551297, -.49129354, -.26036552, -.4081933, -.521855, .12978439, -.5166433, -.35101693, -.45795604, -.64026731, .40870837, -.62843877, -.55551659, .08164061, .07866174, -.02459797, .07864363, .06895735, -.04035683, -.04125175, .03510488, -.04124844, -.04853747, .14532344, .13313101, -.87268265, .13296079, .33280197, -.50026008, -.68636627, .13933804, -.67505498, -.41162063, .57392939, .47021874, -.06886095, .46711995, .35664815, -.73827282, -1.4743277, .4215619, -1.3630265, -.77168792, -.58281782, -.84274163, .1075697, -.82393788, -.41808238, -.00065633, -.00065654, .00029299, -.00065654, -.00063199, .75288704, .57253124, -.28254898, .56543741, .68421794, -.29174285, -.34598048, .13379398, -.34430968, -.28345819, -.01213181, -.01219526, .00148818, -.0121952, -.00759473, 1.1875734, .80992775, -.44442331, .79048795, 1.0782412, -.59310681, -.94491404, .35995501, -.91160125, -.63267598, -.49983984, -.69911699, .2045385, -.68616942, -.46754376, -.43655652, -.55970174, .08213568, -.55398313, -.31517198, .06577544, .06384116, -.01799947, .06383169, .0538029, .65614772, .51896186, -.14355175, .51423367, .49813522, -.73470229, -1.2324181, .11317359, -1.1791277, -.4962105, -.45860398, -.61939807, .20045514, -.61016967, -.43850473, -.35747689, -.4564202, .36142831, -.45190998, -.45204607, .56119242, .44767566, -.33020406, .4438875, .59248679, .63886023, .49972097, -.29988187, .49473085, .6255528, .22006193, .19891531, -.12866661, .19857732, .23184367, -.70226265, -1.2038878, .20010291, -1.1475115, -.58222946, .31365132, .27515623, -.10312727, .27437149, .27275073, -.25744216, -.29712234, .09625626, -.29610719, -.23367169, .2909643, .25914074, -.05412012, .25856219, .20926152, 1.448869, .96127786, -.22405255, .93483027, .97981942, -.63537241, -.98650244, .1514761, -.95538216, -.49637542, .06547446, .06338746, -.03991762, .06337638, .06994868, -.45136775, -.59744329, .14350211, -.58968686, -.38813527, -.18090053, -.19645099, .01893559, -.1962285, -.10741448, -.01422981, -.01433352, .00801671, -.0143334, -.01480726, -.28676242, -.33361277, .06176315, -.33234288, -.2165715, -.03810031, -.0389361, .05062011, -.03893305, -.05277198, -.45690859, -.60877016, .15199966, -.60049491, -.39888137, .49643102, .41044933, -.13213891, .4079852, .40233967, -.52586306, -.76036553, .24477965, -.74340229, -.51347213, -.5924395, -.87061468, .12222478, -.8494784, -.44105467, .28472938, .25311973, -.07550306, .25253648, .23047281, -.80915386, -1.5112437, .13010558, -1.4172483, -.5543653, -.34930171, -.42981181, .13533621, -.42674549, -.32083505, .27165529, .24119811, -.1222478, .24063059, .26228239, -.591751, -.94386109, .3716657, -.91042169, -.63848911, .48929003, .40475457, -.1440689, .40233778, .41012004, -.3686661, -.47023772, .27450567, -.46562852, -.42100046, .0078351, .00780773, -.00146312, .00780771, .00564243, 1.2654177, .83530349, -.77888165, .8117597, 1.356198, .39521216, .3377571, -.10694825, .33637183, .32207333, -.49057537, -.67009995, .14870434, -.65936082, -.4151978, -.19877268, -.22288743, .12935537, -.22240111, -.21702475, -.58216871, -.87924513, .21055823, -.85481939, -.52259668, -.2297186, -.25718772, .03643411, -.25664167, -.15666675, -.31661211, -.37751449, .08802402, -.37557404, -.26035269, -.27206636, -.32236391, .22499123, -.32082303, -.32174744, .16440459, .15357079, -.02835786, .15345192, .11530384, .00103929, .0010388, -.00021298, .0010388, .00077199, -.33083111, -.39558536, .06980408, -.39348639, -.24814632, -.12046646, -.12864033, .07287372, -.12854797, -.12836435, -.43725155, -.55670313, .06651499, -.55132732, -.29408356, -.3054157, -.35349905, .02859342, -.35224275, -.17472684, 1.1598261, .80217503, -.33297464, .78428477, .96399688, -.59378871, -.8659557, .10641497, -.84574523, -.42179251, .05247017, .05130234, -.00809786, .051298, .03546024, .70684525, .55549519, -.1072906, .55015624, .47505816, .31151861, .27466035, -.07308972, .27393582, .24207582, -.6991559, -1.3535436, .53619384, -1.2598869, -.80630612, .03458053, .0339866, -.0205769, .0339849, .03664582, .82682948, .60682106, -.56819092, .59724861, .919289, -.10284804, -.10861681, .0539691, -.10856291, -.10451752, -.3197203, -.38921434, .18637731, -.38671619, -.33650213, .97145615, .70037602, -.30919677, .68803492, .83567443, .0025278, .00252482, -.0006883, .00252482, .00206426, .05788055, .05636685, -.01664403, .05636025, .04813392, -.52883627, -.73940217, .1293742, -.7257381, -.41671588, -.39248162, -.48165016, .04845533, -.47830192, -.24622761, -.3925012, -.51354987, .33019403, -.50741698, -.46683176, -.56031347, -.81448204, .16065483, -.79579414, -.46550959, .22330768, .2037657, -.04331321, .20348115, .1628618, 1.2671633, .85776025, -.33976017, .83637302, 1.029491, -.43456787, -.5717868, .1681824, -.56467313, -.39900217, -.24206258, -.28093407, .21175835, -.27989831, -.29168132, -.42873818, -.5629535, .1780476, -.55605376, -.40301091, -.49242361, -.6598997, .09536759, -.65056734, -.35895184, .13989783, .13073676, -.09689245, .13063687, .1559483, .7407564, .55949554, -.42875698, .55221846, .77779296, -.18645751, -.20665062, .09067891, -.2062869, -.18474187, -.55840691, -.85765763, .36963806, -.8318906, -.61315379, .31715448, .27514663, -.21852665, .27422302, .35293281, -.7165565, -1.2868527, .25484644, -1.2161667, -.63964128, .974585, .69060403, -.56893569, .67713489, 1.0262288, -.32192358, -.38577559, .09508929, -.38367856, -.27011937, -.5998119, -.89087792, .13017601, -.86805931, -.45414761, .43858688, .3659991, -.20787794, .3640099, .43084054, -.15953623, -.17482537, .12207043, -.17458157, -.18384551, -.25385373, -.2911425, .07588293, -.29023302, -.21385221, -.39446492, -.49894205, .12492114, -.49438067, -.33876165, .0306346, .03018139, -.01370242, .03018027, .02951779, 1.4738252, .93933028, -.68459262, .90830075, 1.4380855, -.29050831, -.34106826, .08722709, -.33960921, -.24509409, .59850856, .47340936, -.29846146, .46909894, .59797954, 2.4104501, 1.2709452, -2.3575449, 1.1881433, 3.0145935, -.67469976, -1.0052526, .05320747, -.97910221, -.36453668, -.46940231, -.66813162, .46465258, -.65445295, -.58940833, -.27271976, -.32287399, .2127947, -.32134546, -.3163307, -.35825387, -.45985633, .41275096, -.45511323, -.47318753, .18800499, .17256188, -.08955579, .17235077, .18499251, .15566192, .1440027, -.15870237, .14385733, .19739041, -.39539076, -.49323855, .07964831, -.48924201, -.29202489, .59827041, .48136068, -.12866286, .47758885, .4516057, .00012764, .00012763, -.00005284, .00012763, .00011986, -.60613341, -.91044242, .14108794, -.88580433, -.46977018, .14661279, .13790178, -.02540357, .13781558, .10298078, 1.1334289, .79676324, -.22650754, .78050387, .83489861, -.2907386, -.33234446, .02116708, -.33135568, -.15295562, .37710646, .3241227, -.1058066, .32288766, .31104524, -.02883914, -.02924234, .0090557, -.0292414, -.0246967, -.02005801, -.02024287, .00414231, -.02024259, -.01493767, .23177615, .21016051, -.06218017, .20982518, .1883388, .76446302, .58331524, -.21613315, .57626475, .6321519, -.48101958, -.66892298, .24911215, -.65695167, -.48668744, -.04201194, -.04284543, .00963797, -.04284267, -.03240313, .18774025, .17117493, -.18893547, .17093174, .23703879, .74734106, .56677162, -.33648461, .55961035, .72167938, -.6591305, -1.0723949, .19621188, -1.0311942, -.55449721, -.22167818, -.24704873, .03470137, -.24656593, -.15052461, .04388406, .04306384, -.00668581, .04306129, .02953016, -.22977463, -.26124438, .1006082, -.2605284, -.21983112, -.51127357, -.75846885, .45884498, -.73915675, -.62134702, -.19452091, -.21545657, .06160036, -.21508181, -.16705082, .58082574, .4560683, -.53736887, .45165396, .71306875, .28466945, .2499898, -.2065418, .24928803, .32228485, .14022023, .13136471, -.06636631, .13127158, .13767857, -.39441849, -.54777294, 1.1885606, -.53804669, -.71777547, -.2854344, -.33754261, .14041345, -.33596604, -.28389023, -.10232612, -.10792736, .04591567, -.10787629, -.09870094, -.22298031, -.24819432, .03019943, -.24772022, -.14427373, -.49189513, -.65191499, .07435375, -.64337513, -.33013581, .54129734, .44473221, -.09421088, .44188313, .38077428, -.3141839, -.38136968, .19219353, -.37899305, -.33603064, .52910353, .42971918, -.21126421, .42663465, .49088423, -.62464995, -.97954638, .19663399, -.94726566, -.53536996, .75256547, .56658394, -.4322483, .55904583, .78816526, -.55772974, -.84573248, .31387839, -.82178593, -.58015808, .15164157, .14298332, -.01310932, .14290099, .08447903, .0153214, .01520807, -.00617892, .01520793, .01426198, .47089409, .38773578, -.25429813, .38530659, .48314024, -.05675135, -.0582369, .00969293, -.05823042, -.03967155, .11061595, .10520062, -.03643206, .10515646, .09624609, .01416898, .01406766, -.00848756, .01406754, .01504862, -.24161691, -.27095853, .02734499, -.27036622, -.1472496, .01455121, .0144392, -.0134194, .01443906, .01784516, .46859083, .3934604, -.08443875, .39146497, .33346719, -.22719214, -.25977519, .15469994, -.25899916, -.25182697, .15358846, .14319541, -.06368345, .14307831, .1442972, .3556438, .31156832, -.04197952, .31066111, .21980252, .17859891, .16500587, -.0621345, .16483366, .15826084, -.37956082, -.48827711, .27626347, -.48315254, -.43016864, .3731618, .31932929, -.15510458, .31804123, .35087276, -.18786051, -.208419, .0925445, -.20804484, -.18693209, .81327041, .60721746, -.32707028, .59866332, .75633409, -.16706276, -.18441847, .15832612, -.18411855, -.20675084, .94132863, .70605769, -.08417635, .69641767, .53035606, -.33784023, -.41811617, .21561216, -.41496577, -.366473, -.13640498, -.14617173, .04176048, -.14605529, -.11582935, 1.6127625, 1.014966, -.48695071, .97957604, 1.3631761, -.53208943, -.78188964, .28847348, -.76291209, -.54664039, 1.6146371, 1.0290688, -.32997947, .99507393, 1.1982725, -.77581268, -1.3487554, .10245997, -1.2823816, -.49777452, -.49310456, -.7287983, .57941269, -.71058407, -.65558954, .1963589, .18089863, -.0410606, .18069602, .14684262, -.69517518, -1.2632614, .3566579, -1.1911621, -.7011702, -.03665689, -.03735259, .01946688, -.03735039, -.03740066, -.09244805, -.09707926, .04940959, -.09704061, -.09452476, -.31164636, -.3733888, .12230389, -.37136336, -.28747371, -.1985375, -.22173589, .09819529, -.22128522, -.19781926, -.26318965, -.31195439, .29793548, -.31045717, -.34559168, -.34121537, -.41643027, .12159344, -.41368879, -.30478887, -.30756931, -.37637527, .30765907, -.37383066, -.38755074, -.19443444, -.21632326, .08733718, -.21591349, -.18761109, -.54927006, -.77451596, .11179131, -.75947913, -.40707082, -.13259001, -.14222483, .05905857, -.14210826, -.1275787, .13708588, .12851652, -.07184424, .12842731, .13925233, -.12015573, -.12784866, .04628493, -.12776663, -.11015043, -.36949224, -.44524532, .0395459, -.44267477, -.22102804, .70993199, .54609802, -.27478998, .53988256, .6518607, .77662021, .58105767, -.43460627, .5729868, .80633304, -.54946963, -.91417902, 1.0649076, -.87585537, -.86313045, .02407643, .02380893, -.0068007, .02380844, .01990318, .29569801, .25968919, -.1517248, .25896081, .29825962, -.368871, -.46224996, .16047575, -.45835003, -.35215145, .52276536, .42167726, -.33247035, .41844923, .56641164, -.44749152, -.63940798, .72845226, -.62603375, -.66323419, -.65579296, -1.0719928, .2150347, -1.0300301, -.56975833, -.6022482, -.93903725, .24527004, -.90885475, -.56243868, .4680247, .38561959, -.25765354, .38321946, .48328267, .16268144, .15218796, -.02493842, .15207525, .10969622, .19373071, .17705278, -.11399762, .17681387, .20453811, .19253084, .17717772, -.05471559, .17697395, .15948282, -.47507919, -.64150947, .15042388, -.63196539, -.40796816, .30893445, .26958626, -.17485314, .26875407, .3219675, .95742478, .68410067, -.48450958, .67138558, .96127408, -.00020088, -.0002009, .00004746, -.0002009, -.00015646, -.41655101, -.53772901, .14433722, -.5319297, -.36862227, .69049373, .5340279, -.26978312, .52819607, .63599653, -.19829589, -.2207681, .07851276, -.22034462, -.18345627, -.34670537, -.41593531, .05499794, -.41364655, -.23646445, -.37843404, -.47587802, .14570374, -.47173978, -.34686491, -.08398264, -.08753776, .02584999, -.08751269, -.07144248, .76964305, .57764319, -.41079793, .56979036, .78658498, .03622165, .03556509, -.02337097, .03556311, .03943493, -.26755896, -.31635395, .23388636, -.31487911, -.322323, -.01255189, -.0126362, .01056077, -.01263611, -.01492959, -.30845422, -.36666675, .09509106, -.36484664, -.26253288, 1.338161, .87983412, -.56482266, .85457017, 1.2646964, -.33926235, -.41223079, .10806819, -.40963487, -.29192172, -.15645295, -.16877968, .03016566, -.16861799, -.1138772, -.20904858, -.23396862, .0756621, -.23347476, -.18770144, -.44183262, -.59607991, .26353094, -.58726416, -.46858932, .19758775, .18025388, -.11825369, .18000086, .20979167, -.36086085, -.44873655, .14915824, -.44520369, -.33867691, -.02459151, -.02489064, .00947921, -.02489003, -.02254884, -.70225898, -1.1268567, .10123357, -1.0859291, -.46392707, .16521037, .15188618, -.2088498, .15170734, .22506755, 1.1967308, .81044147, -.5290354, .79027901, 1.1486011, .14631725, .13723089, -.03995947, .13713693, .11960433, -.07734385, -.08035544, .02459876, -.0803359, -.06651684, -.64371163, -1.0402404, .22002504, -1.0013503, -.56705903, 1.5524088, .97495273, -.70290097, .94065939, 1.5019153, -.28060654, -.32433074, .05227474, -.32319997, -.20191681, -.40252318, -.52402258, .23730785, -.51799455, -.42524703, .19208406, .17463573, -.21253742, .17437205, .25031258, -.44132255, -.56914823, .0885403, -.56305679, -.32550755, .84461867, .6380791, -.14874639, .62979241, .59648464, .43705352, .37012395, -.08664179, .36842511, .32107677, -.41079452, -.52282583, .10842605, -.51779244, -.33199966, -.09970087, -.10475503, .02981724, -.10471235, -.08400371, -.30064167, -.3554778, .09212965, -.35382014, -.25537356, -.85525691, -1.8855153, .219699, -1.7025483, -.68498925, 1.1113579, .77408623, -.36683635, .7574659, .96769112, -.44689844, -.59398737, .17145775, -.58604801, -.40913654, .20610637, .18756321, -.10950147, .18728566, .21031856, .55131358, .44116271, -.32611823, .43753094, .58308807, -.17439685, -.19111203, .05991796, -.19084547, -.15389391, -.013729, -.0138198, .00449467, -.0138197, -.01192162, -.63042134, -.99667387, .20170184, -.96265864, -.54325102, -.62553683, -.9774335, .18596994, -.9457211, -.52600859, -.28148494, -.3432292, .54867406, -.34098958, -.44301481, .17822118, .16438191, -.07745754, .16420303, .17008687, -.36264389, -.44273912, .075674, -.43981411, -.27100615, -.08051297, -.08340306, .00892393, -.08338577, -.04872733, -.45501394, -.63376352, .40062633, -.6223134, -.54946449, -.18714207, -.20608581, .05220646, -.20576681, -.15406324, .43589437, .36399211, -.20999187, .36202815, .43052495, -.21860384, -.24612779, .07998934, -.24555183, -.19699683, .63163106, .47671587, -1.5831303, .47048265, 1.0809971, .27460516, .2445488, -.08665917, .24400198, .23555228, .01103839, .01098239, -.00276905, .01098235, .00877117, -.46884904, -.63417799, .17350826, -.6246366, -.42410371, -.60840711, -.91799413, .1460026, -.89260785, -.47635023, .27226217, .24193171, -.11211278, .24137013, .25520347, .56206722, .45804978, -.10865281, .45486822, .40946409, 2.2574775, 1.2763903, -.66359112, 1.2097591, 1.8911493, .45320571, .37170034, -.42998167, .36927644, .56107841, .42725895, .36167879, -.10665048, .36001042, .33894174, .00697976, .00695695, -.00202444, .00695693, .00582111, -.70044707, -1.2553482, .30065116, -1.1868559, -.66570401, -.48982143, -.67466904, .17847675, -.66327803, -.4407873, .15351535, .14273853, -.09234347, .14261257, .16327258, -.43391792, -.57738764, .22288376, -.56960922, -.43783237, -.54102287, -.75076049, .0933284, -.73749592, -.37945332, -.63054991, -.95239523, .11130689, -.92592675, -.44565317, -.04260425, -.04347693, .01139051, -.04347395, -.0345801, .26530286, .23776463, -.06493007, .23728936, .20908357, -.51412507, -.72472348, .18861556, -.71067954, -.46371203, .34446129, .29870085, -.11665038, .29769178, .30250484, -.29797033, -.34568092, .03933844, -.3444133, -.19116032, -.60360127, -.9037539, .139343, -.87967138, -.46652166, .40768739, .34950269, -.06766524, .34812523, .28228213, -.37466846, -.4792952, .26222624, -.47448427, -.41911526, -.46921854, -.64741377, .26058549, -.63636552, -.48593351, -.56433279, -.85554398, .2847436, -.83134645, -.56604572, -.08634594, -.09071815, .09333165, -.09068127, -.11164714, -.02003637, -.02024106, .01041608, -.02024071, -.0202982, .59132009, .47419447, -.16713741, .47036531, .48893333, -.46173172, -.5978794, .06874143, -.59127716, -.30832542, -.58402034, -.85039333, .11854149, -.83070586, -.43243294, -.55914576, -.8353297, .24877737, -.8133109, -.53781178, .44547946, .36764891, -.34860404, .36539922, .51721676, -.26127152, -.30681979, .20622582, -.30550317, -.30421857, -.61504732, -.97835053, .26432744, -.9440826, -.58478528, .08355641, .08052772, -.01918686, .08050943, .06446606, -.40578931, -.53826007, .35378452, -.53116637, -.48841614, -.35961484, -.43178716, .04249367, -.42938916, -.22233602, -.38258441, -.47359501, .08030352, -.47001936, -.28646597, .89314566, .66428211, -.18076181, .65467732, .66068395, .27105607, .24028062, -.14248256, .23969994, .2756153, -.40391258, -.50923, .09366305, -.504702, -.31264946, -.23916345, -.27116805, .06147544, -.27045649, -.1915904, -.33892144, -.41893695, .20154034, -.41581661, -.35908452, .15639155, .1463535, -.03254967, .14624621, .11677084, .29300078, .25715597, -.17167031, .2564276, .30890214, -.05759414, -.05909465, .0082698, -.05908813, -.03799799, .4806042, .39766338, -.16403827, .39529483, .42317185, .81670299, .60790134, -.3583561, .59915753, .78191167, .30851868, .27094305, -.10821653, .27018287, .27413354, .57166398, .45582386, -.29121752, .45195147, .57523202, -.4046238, -.53201139, .29259045, -.52542633, -.45757715, -.24679736, -.2798083, .0476481, -.2790747, -.1797155, .79474976, .59957038, -.25654982, .59170708, .68689049, -.20744948, -.23045703, .04637853, -.23003268, -.15863191, .21771334, .19694262, -.13002563, .19661302, .23099877, .78607735, .60277702, -.13957481, .59575277, .55665896, -.61240994, -.96393736, .24113132, -.9316551, -.56553049, -.34004814, -.42724245, .33384104, -.42355466, -.42581097, -.18712246, -.20885844, .15076754, -.20843865, -.21937976, .15013306, .14052878, -.04365754, .14042647, .12531815, -.06555559, -.06780034, .03087027, -.06778753, -.06425841, -.45532588, -.6032533, .13688155, -.59536894, -.38430249, -.47866281, -.62154923, .05551102, -.61453651, -.29409627, .10379618, .0992905, -.01897395, .09925791, .0742193, .27525161, .24445907, -.10746921, .24388656, .25346885, .44000184, .36911396, -.14780521, .36722222, .38536853, -.08764775, -.09186995, .05454247, -.09183606, -.0942791, .39856408, .34084917, -.09559651, .33946304, .3120011, -.28915418, -.34830523, .27694204, -.34630242, -.35910872, -.54668736, -.81965483, .31385788, -.79766835, -.57246249, -.13214671, -.14110555, .03451977, -.14100441, -.10643151, -.05303343, -.0543188, .00855113, -.05431361, -.03636785, .37518581, .32519639, -.06085479, .32409083, .25779383, -.20416909, -.2255121, .0333895, -.22514098, -.14067167, -.73453935, -1.3261482, .21807897, -1.252033, -.6173877, -.51285193, -.69944573, .1009299, -.68834599, -.37584716, -.34356943, -.41990334, .12127341, -.41709935, -.30592024, -.61185903, -1.0170268, .4461753, -.97454363, -.69387209, -.74680096, -1.3323688, .17349841, -1.2607571, -.57842236, .70162212, .55215776, -.10661961, .54691156, .47172752, .52578771, .42595277, -.25362418, .42282123, .51953384, .05380708, .05250817, -.01411749, .05250294, .04339991, .60789505, .48050614, -.27229875, .47610578, .586018, -.03696114, -.03765362, .01627638, -.03765146, -.03542905, .06786725, .06552571, -.06338565, .06551225, .08358221, -.24636214, -.28486146, .15119768, -.28386295, -.26377949, 1.5507848, .96230871, -1.010033, .9267362, 1.6936469, -.64427637, -1.112392, .42573289, -1.0589588, -.70702896, .40112431, .33692308, -.28696759, .33522086, .45200191, .22752738, .20598175, -.08452806, .20564237, .20607853, -.41029188, -.51805874, .08653263, -.51339204, -.30770313, -.3352269, -.40292353, .07774257, -.4006604, -.25949094, -.09823975, -.10297479, .021997, -.10293677, -.07516044, -.45906155, -.6389501, .36820685, -.62745478, -.53738792, .54875732, .4442739, -.18633969, .44098771, .48235339, -.46390271, -.61090183, .10182795, -.60325493, -.352574, -.13586222, -.14521798, .03140487, -.1451107, -.10505292, 1.5325827, .95475011, -.98943472, .92001987, 1.6688667, -.0180165, -.01817654, .00704904, -.01817631, -.01660225, .1074245, .10219496, -.04359798, .10215255, .10020768, .91324351, .66341484, -.38068255, .65225386, .85951881, -.13804802, -.14753983, .02729999, -.14743116, -.10133302, .09347746, .08949071, -.03700553, .08946238, .08647757, -.50931142, -.72863446, .26424161, -.71329046, -.51562347, -.53793659, -.76080839, .13943669, -.74578287, -.43213862, -.25884982, -.29723551, .06959389, -.2962904, -.21049039, .86831329, .63220778, -.52265542, .62172045, .92370391, -.65285423, -1.0173435, .12767231, -.98472881, -.47744101, -.45934698, -.6418679, .39489684, -.63004719, -.55029867, -.23191228, -.26444189, .11144756, -.26368404, -.22886674, .09519918, .09137385, -.01806198, .09134824, .06892137, 1.6758455, 1.0134619, -1.1410758, .97196346, 1.8575371, -.21193295, -.23870482, .10506008, -.23814276, -.21132695, .16828151, .15522648, -.1214123, .1550579, .19016117, .49347086, .40570005, -.19050999, .40311803, .45271365, -.31551801, -.38082435, .14918844, -.37858735, -.30969759, -.30187324, -.37396933, .54845442, -.37112573, -.46409468, -.46016208, -.61586466, .15922752, -.60723147, -.40702703, -.08661744, -.09036911, .02450479, -.09034204, -.07164137, -.25151268, -.28898407, .09061437, -.28805721, -.22548394, -.04191402, -.04290011, .04338401, -.04289625, -.05341863, .08469815, .08157622, -.02018716, .08155704, .06616338, -.31034085, -.37216383, .1313238, -.37012469, -.29355114, -.45803461, -.62017743, .21375366, -.61078472, -.44762402, .49980632, .4166992, -.07721613, .41441121, .33789402, -.56384813, -.81737021, .1460957, -.79888631, -.4528947, -.48061948, -.6559582, .17221889, -.64550075, -.43010171, .14620871, .13680497, -.05692722, .13670426, .13451338, .26422407, .23781698, -.04497363, .23737809, .18449201, -.43463765, -.59962418, .47955395, -.58939942, -.56585791, -.07744555, -.08062791, .03843585, -.08060612, -.07725379, .54920956, .44158076, -.26428657, .43809866, .54224275, -.58678218, -.89783355, .23639882, -.87132354, -.54602146, -.27075858, -.31760637, .14700409, -.31626226, -.27829664, -.62999685, -1.0615455, .40474533, -1.0148667, -.68490373, -.45134316, -.59439733, .12701407, -.58695388, -.37264776, .05554217, .05405862, -.02821365, .05405202, .05583566, -.58017052, -.89710684, .29732825, -.86932041, -.58495954, -.08213309, -.0853622, .0165121, -.08534104, -.06062097, -.17602733, -.19292472, .05629284, -.19265484, -.15166351, 1.8124182, 1.1240987, -.29446015, 1.0824607, 1.2460184, -.46757378, -.61606444, .09686109, -.60832329, -.34857258, -.70077091, -1.2435629, .27604516, -1.1779104, -.64722321, -.1823987, -.20009761, .04608985, -.19981187, -.14528683, .15408466, .14388699, -.0497265, .14377461, .13316156, -.51644298, -.7288862, .18606273, -.71466167, -.46299686, -.14773155, -.15945679, .05062292, -.15930187, -.13024906, .08229583, .07941547, -.01553589, .07939868, .05948041, .69703697, .52883327, -.57770487, .5221705, .8249277, -.04851095, -.04963147, .01148373, -.04962715, -.0378092, .24278042, .21941664, -.05953089, .21904267, .19145493, .671777, .52784301, -.16253492, .52276247, .52740266, -.15617841, -.17052382, .10367119, -.17030455, -.17164982, 1.5544976, .96906503, -.8655973, .93391329, 1.611296, -.28513785, -.3342719, .09440154, -.33286791, -.24852664, -.46089739, -.60530758, .10034894, -.59787735, -.34934169, 1.3867149, .93965444, -.1596063, .91634674, .84986798, .99046183, .70838601, -.35652627, .69529365, .88769888, -.08002395, -.08323765, .02434802, -.08321615, -.06781273, -.40573327, -.51545943, .11362931, -.51056997, -.33445206, -.40648123, -.52178853, .15049556, -.5164044, -.3677434, .66919291, .51936908, -.29608372, .51384969, .64246439, .39119646, .33692167, -.06846835, .33567223, .27569987, -.44122326, -.59962437, .3120213, -.59032278, -.49527189, -.13558433, -.1446097, .02421351, -.14450965, -.09619864, .0099352, .00988846, -.00324443, .00988842, .00862, -.42082174, -.53340542, .07930414, -.52844146, -.30397701, .96329528, .67781139, -.80426813, .66405317, 1.1428342, -.0708706, -.07339878, .02347869, -.07338375, -.06178438, -.32322952, -.4044075, .4388475, -.40104347, -.45094324, -.05908515, -.06087455, .02471536, -.06086552, -.05567385, -.06013292, -.0621644, .05487635, -.06215297, -.07348747, .47440157, .39775455, -.083663, .3957034, .3351855, -.47880308, -.63947157, .11047014, -.63063467, -.36999534, -.39057774, -.49590363, .15135669, -.49122338, -.35876951, .11513068, .10932827, -.03507222, .10927956, .09760194, -.02055911, -.02077991, .01319937, -.02077952, -.02234587, .27033978, .24057006, -.10481223, .24002518, .24836322, -.43174396, -.5558757, .10088222, -.55000281, -.33504185, -.28981713, -.34109702, .09986907, -.33959278, -.25599788, .49827704, .41348828, -.10395794, .41110027, .37234295, -.66452107, -1.0741235, .17103461, -1.033928, -.53257058, .86372263, .64400865, -.21357962, .63485223, .68303999, -.57246645, -.81588755, .09712925, -.79906265, -.39929453, -.25150833, -.28811492, .07642183, -.28723019, -.21303488, 1.1257878, .77787497, -.43700417, .76043632, 1.0346883, .08991045, .08629892, -.02843603, .08627475, .0771803, -.49263698, -.68520543, .20655261, -.67292912, -.46455617, -.09048578, -.09431884, .01431767, -.09429178, -.06166248, .15430815, .14356173, -.08180471, .14343712, .15734829, .97131033, .70646202, -.22186017, .69466674, .74806921, .18003708, .16590468, -.07972372, .16572004, .17289422, -.29781107, -.3528204, .10849739, -.35113661, -.2679849, -.21547121, -.24222419, .08081257, -.24167209, -.19577736, -.42192978, -.54243744, .11643098, -.53677288, -.34609312, .33540017, .29160407, -.11927025, .29065466, .29938467, -.44351758, -.57901057, .11739654, -.57220895, -.35878614, .16268658, .15236957, -.02106035, .15226062, .10368907, .28590306, .25449007, -.06539078, .25391638, .22028996, .23972163, .21592341, -.09129711, .21553052, .21892759, -.06197495, -.06390928, .02185816, -.06389922, -.05516861, -.6571649, -1.0257757, .12369826, -.99264783, -.47451226, -.07585836, -.07859974, .0152187, -.07858323, -.05595061, -.53839137, -.73995489, .08017422, -.727629, -.35954532, -.39484051, -.49202145, .07777106, -.48807333, -.2894435, .12160171, .11546501, -.02293981, .11541343, .08786847, -.33319858, -.42175107, .49249551, -.41787197, -.47820362, .12191667, .11533611, -.04328711, .11527694, .10876894, -.26129947, -.30723369, .21850026, -.30589492, -.3101604, .08817333, .08467038, -.0299148, .0846472, .07748129, .81469793, .60845971, -.31873043, .59990492, .75072737, .40253592, .34314298, -.10928505, .34168986, .32839763, -.47822963, -.66079171, .23024887, -.64941592, -.47224441, -.48937212, -.65862684, .11032834, -.6490406, -.37525963, .04390026, .04301507, -.01346779, .04301209, .03730384, -.51180504, -.71021291, .14550164, -.69766505, -.42400306, .69894703, .54186216, -.21977156, .53605376, .59882051, -.60590729, -.95447584, .26523247, -.92239875, -.57963733, -.28623331, -.33707983, .11342964, -.33558246, -.26489004, -.43329208, -.55524493, .08603306, -.549594, -.31848254, -.34106626, -.41442309, .10358315, -.41181335, -.28884546, -.34568306, -.42566848, .15087844, -.4226105, -.33037293, -.42486998, -.56263495, .23547429, -.5553061, -.43970547, -.75007176, -1.3815232, .21532873, -1.2992251, -.6234178, -.48305465, -.67351797, .25326371, -.6612743, -.49075548, -.4925107, -.6685222, .12619137, -.65823188, -.39412169, .03483665, .03426099, -.0135819, .0342594, .03206425, -.19559532, -.21772783, .08660362, -.21731139, -.18782828, -.35443248, -.43511509, .11098173, -.43207961, -.30323745, -.38942924, -.47511672, .0417335, -.4719991, -.2330544, -.3169427, -.3911817, .32732977, -.38830899, -.40363827, .87763202, .63066908, -.78726522, .61933602, 1.0664127, -.17403822, -.1918899, .10340688, -.1915853, -.18434141, -.6464664, -1.0192215, .15955964, -.9848451, -.51091461, -.65026946, -1.094346, .31035396, -1.0464465, -.6402624, -.60132335, -.96744638, .36099189, -.93192504, -.63911821, -.2453341, -.27893539, .05957132, -.2781709, -.19283876, -.00191244, -.00191422, .00075416, -.00191422, -.00176694, .36734483, .31925054, -.05931416, .31820521, .25202603, .22426428, .20539334, -.02796272, .20512909, .14115942, -.17674076, -.19368182, .05387904, -.19341163, -.1498676, -.13031518, -.13912861, .03784719, -.13902935, -.10873045, -.44782118, -.60051686, .20683888, -.59198702, -.43613788, -.00159905, -.00160024, .00040897, -.00160024, -.00127884, .41485687, .3471336, -.2760776, .34530268, .45633724, -.18260258, -.20092326, .05929216, -.20061747, -.15812979, -.11701754, -.1239598, .03056328, -.1238912, -.09424189, .1495302, .13983215, -.05168332, .13972741, .13221459, .20380671, .18589445, -.09405106, .18563252, .19843132, -.13218807, -.14162562, .0524459, -.14151343, -.1223795, .41633297, .35056555, -.18295125, .34884422, .39879435, -.40341564, -.51561001, .14153119, -.51047173, -.35847803, -.01089955, -.01096055, .00642133, -.0109605, -.01151218, -.27456939, -.31871107, .07790851, -.31753356, -.22732108, -.23174712, -.2617172, .06128696, -.26107315, -.18741697, .71778654, .56038029, -.12906297, .55469721, .51043536, .09040699, .08684762, -.02246169, .08682428, .07160755, -.42823472, -.57659012, .32392831, -.56817405, -.49160265, -.73344797, -1.2893331, .17694924, -1.2234043, -.57527094, .19918849, .18194076, -.09690683, .18169226, .19738052, -.31398027, -.38360774, .24614757, -.38105488, -.36476242, -.43606549, -.55891246, .08221844, -.55321494, -.31504135, -.07099877, -.07359873, .02893663, -.07358286, -.06632234, -.00646293, -.00648357, .00279196, -.00648356, -.00615553, -.51680267, -.73973336, .23720371, -.72411136, -.50226586, -.51801861, -.73542479, .20179385, -.72058524, -.47666092, -.31510981, -.37479678, .08222015, -.3729238, -.25369429, -.29745244, -.35137603, .09614113, -.34975579, -.25719239, -.7350391, -1.336973, .23001115, -1.2604332, -.62873348, .45611517, .38510575, -.07446771, .38327377, .31408632, .50450701, .41745884, -.11098301, .41497349, .3837134, -.54620251, -.77488586, .13042447, -.75931257, -.42693866, .1362107, .12821241, -.04075766, .12813419, .11478555, -.30235082, -.35349385, .05179581, -.35205906, -.21156751, -.3467653, -.43121179, .20520569, -.42781666, -.36680075, -.09358901, -.09788313, .02144084, -.0978503, -.07215069, -.5109863, -.71815973, .1875663, -.70447986, -.46096481, .23676848, .21228508, -.15500948, .21186412, .25902718, .20057903, .18446754, -.04245899, .18425215, .15061107, -.29042894, -.33880521, .06405475, -.33746858, -.22108216, -.61377622, -.96433791, .23168023, -.93229385, -.55887287, 1.9333925, 1.1448055, -.65698359, 1.0940393, 1.6998406, .62427481, .48959503, -.31924866, .4848092, .62898009, -.2687731, -.31553849, .16220444, -.31418928, -.28616825, .1688125, .15653835, -.06146817, .15638978, .15187857, 1.5577789, 1.0099456, -.2602146, .97901267, 1.0809139, .34211411, .29468124, -.19859652, .29359004, .35956814, -.37676295, -.46575044, .08665975, -.46227877, -.29084477, -.04356825, -.04456409, .02476282, -.0445603, -.04546984, .54015646, .43791248, -.1967464, .43471516, .48602505, -.22783589, -.25506306, .03873162, -.25452215, -.15901814, 1.6325194, 1.0312477, -.39506806, .99585434, 1.2817585, -.3395014, -.41625668, .14967692, -.41338841, -.32555372, -.5985588, -.92194884, .22020632, -.8938893, -.54036989, .78260351, .58753605, -.35527209, .57956426, .75780632, .40960714, .34094308, -.41757968, .33903753, .51939942, -.30710287, -.36661182, .11817014, -.36470194, -.28142877, -.17108852, -.18604524, .03381223, -.18582762, -.12555919, .11350844, .10731254, -.08557291, .10725621, .130159, 1.2408357, .7831263, -3.6426137, .75614678, 2.2385007, -.21783895, -.24568367, .09213761, -.24509219, -.20602156, .35676019, .30760557, -.13237542, .30648176, .32299567, -.47339603, -.65544184, .25993722, -.6440178, -.48840777, .99117112, .71254419, -.29305528, .6997705, .83194052, -.26696039, -.30860822, .07857154, -.30752986, -.2237328, -.51142055, -.74194832, .32302645, -.72510054, -.55285106, -.1879375, -.20968483, .14143173, -.20926642, -.21537795, -.33121455, -.40057121, .10942298, -.39816807, -.28848226, -.05952037, -.06115745, .0101589, -.06114995, -.0415977, .2214726, .20056696, -.10145905, .20023871, .21510654, .82994407, .61060408, -.50085881, .60112256, .88365144, .65665325, .50334461, -.59829855, .49746269, .80205973, .39092314, .33477803, -.10168134, .33344053, .31440155, .04051729, .03977174, -.01095703, .03976946, .0330117, .43090563, .35541749, -.46982053, .3532297, .55878161, .54113558, .44306617, -.11419461, .44012757, .40590954, .32541581, .28493424, -.0890398, .28409788, .26617289, .16749253, .15455772, -.12037301, .15439145, .18902388, -.4913407, -.6389941, .04688347, -.63170005, -.28288185, -.17514395, -.19160083, .04955168, -.19134353, -.1448637, .36564359, .31353362, -.15904747, .31230171, .34905261, -.62117094, -.96637706, .18616163, -.93562098, -.52373806, -.08114134, -.08447644, .02653013, -.0844536, -.07042895, .18348311, .1698388, -.03959452, .1696699, .13866039, -.1807133, -.19767585, .03826057, -.19741091, -.13570231, 1.6634134, 1.0265519, -.67645138, .98775055, 1.5527051, -.07647688, -.07923264, .01391425, -.07921609, -.05459884, .11829654, .11159352, -.08867616, .11153026, .1353922, 1.2923946, .8523698, -.67641718, .82824634, 1.312235, -.24728027, -.28598105, .1483619, -.28497583, -.2627708, -.21988658, -.25062573, .16645027, -.24991198, -.252486, -.2755918, -.31879509, .06308192, -.31767107, -.21240064, -.41555938, -.5461046, .23334534, -.53937065, -.4319483, -.46232233, -.63073909, .23301535, -.62070869, -.46355517, 1.0525976, .74403674, -.33602878, .72931862, .90638017, -.27406865, -.32789422, .32204228, -.32614366, -.36437944, .24627717, .22025092, -.14244988, .21979366, .2585315, -.49882646, -.67117749, .09412654, -.66142541, -.36047932, -.757155, -1.2849575, .09964465, -1.2269459, -.48523396, .01601422, .01588458, -.00985738, .01588441, .01716331, -.04840384, -.04964864, .02969185, -.04964331, -.0518174, .7899999, .60188253, -.17742938, .59452606, .60502019, .05872464, .05722597, -.01179111, .05721959, .04332533, .26990213, .23861572, -.18437104, .23801312, .29948732, -.21574816, -.24002871, .03790984, -.23957432, -.1522505, .08911037, .08538963, -.04426576, .08536375, .088917, -.17054948, -.18884314, .17185955, -.18851678, -.21542767, -.42724009, -.5588158, .16613186, -.55215875, -.39289422, -.53907287, -.73960392, .07661012, -.72741674, -.35443535, -.12371115, -.13191876, .04904969, -.13182807, -.11450593, .26584066, .23718158, -.09554028, .23666799, .2381331, -.07193602, -.07471814, .04147278, -.07470021, -.0754331, -.16794376, -.18242318, .03513074, -.1822154, -.12560733, .51446722, .4240492, -.11827354, .42142039, .39707968, .18001221, .16650009, -.05070766, .16633125, .14867427, -.1651066, -.18166399, .13222778, -.18138776, -.19317927, -.4040671, -.50783038, .08478384, -.50343544, -.30251716, -.35656546, -.43438462, .08002697, -.43157594, -.27301194, -.46168852, -.60815213, .10651153, -.60052466, -.35675899, .75767365, .57522385, -.28807777, .56801151, .6915677, .03096169, .03049283, -.01560224, .03049165, .03104241, -.60133479, -.99043463, .46627864, -.95049615, -.69604298, -.70618049, -1.2061333, .18489381, -1.1503995, -.56919525, .24609655, .22195569, -.06527636, .22156185, .19921972, -.52063409, -.77721393, .43550804, -.75680191, -.61805974, -.58453743, -.85844221, .13471332, -.8376708, -.45153186, .12094395, .11458282, -.03583559, .11452709, .10158688, .02002306, .01982647, -.00959622, .01982615, .01974227, .91966288, .6663239, -.39775707, .654931, .87626421, -.38085913, -.4691169, .070183, -.46573763, -.27306344, .05913795, .05757364, -.0155936, .05756674, .04777892, .25105429, .22456662, -.12004839, .22410201, .24734732, .19938372, .18269231, -.06796318, .18245978, .17548003, .18622686, .17193903, -.04823291, .17175657, .14956135, -.41397735, -.53665434, .16968061, -.53067629, -.3874406, .04709547, .0461403, -.00810289, .04613707, .03300218, -.19518562, -.21806268, .11519254, -.21761688, -.20627662, .29378722, .25870416, -.12913736, .25800816, .28143789, .01902191, .0188538, -.00554078, .01885355, .0158868, -.40164753, -.51436671, .15502383, -.50915843, -.36844518, .64695473, .52158013, -.06206705, .51756806, .37314672, .12682621, .12003312, -.02927752, .11997251, .09802287, -.19410383, -.21635595, .101727, -.21593179, -.19717181, -.67811503, -1.0999621, .15124977, -1.0582101, -.51813606, -.46257479, -.60401555, .08429428, -.59690919, -.33041823, -.3608694, -.46488093, .42992296, -.45994804, -.48199247, -.65122871, -1.0610844, .21954844, -1.0200803, -.5710522, -.67258585, -1.1766601, .33936915, -1.1174798, -.67463044, -.08720266, -.09116938, .0350974, -.09113932, -.08111879, -.00509289, -.00510486, .00119871, -.00510485, -.00396178, .45291532, .38054444, -.1065549, .37862873, .35227283, -.08207081, -.08518451, .01227092, -.08516483, -.05488179, -.24891045, -.29268088, .32299783, -.29140477, -.34206236, -.20663337, -.23348496, .1590604, -.23290514, -.23859664, .57358388, .45987294, -.21555813, .45615226, .52151015, .45636142, .37899664, -.20081928, .37682578, .43733853, -.20636515, -.22662807, .01883135, -.22629705, -.11705629, 1.1532973, .79180972, -.44832937, .77345009, 1.0604819, -.54038446, -.75598549, .110033, -.74196735, -.40054645, .34928336, .29803513, -.31908381, .2967882, .42700227, -.40210016, -.5032936, .07752103, -.49909166, -.29266627, -.25093777, -.30070727, .69736222, -.29907283, -.44450176, -.30426825, -.35877733, .07382058, -.35715861, -.2390967, -.14970123, -.16509879, .35249769, -.16483534, -.25092601, .02307411, .02283149, -.00577354, .02283107, .01831923, -.41932088, -.54145072, .13788425, -.53559902, -.36465252, -.34474458, -.42026974, .10748187, -.41753365, -.29452356, -.55799517, -.82395329, .21253264, -.80345531, -.50961105, .12961953, .12247884, -.03238179, .12241332, .10285465, -.33018576, -.39064385, .04471248, -.38880923, -.21362815, .73731356, .54577692, -1.0140553, .53763244, 1.0330754, -.18154748, -.20014871, .07311945, -.19983167, -.16892001, -.42498663, -.55452806, .16297509, -.54803939, -.38901581, -.00600484, -.0060217, .00158229, -.00602169, -.00485035, .61450549, .49157276, -.13907971, .48751452, .47182589, -.04702735, -.04815478, .02034566, -.04815028, -.04481268, -.16008101, -.17544448, .12013535, -.17519914, -.18328495, -.51264618, -.67570017, .04680861, -.66718712, -.29084644, -.22284727, -.24995451, .05288025, -.2494064, -.17382519, .1777406, .16335742, -.12044423, .16316371, .19669641, -.1437142, -.15404958, .02850149, -.15392582, -.10559232, -.24474757, -.28229458, .13943231, -.28133846, -.25562897, -.78642972, -1.4467791, .14614317, -1.3609128, -.56542644, -.19407858, -.21476424, .05819234, -.21439754, -.16366294, -.64387251, -1.048366, .23861404, -1.0079661, -.58269584, .29829784, .26117414, -.17942885, .26040684, .31725428, 1.4900327, .92632316, -1.3171175, .89233917, 1.8016982, .45972549, .37377608, -.61421176, .37112074, .63794284, -.2861039, -.33632444, .1046803, -.33486287, -.25781855, .14937027, .13895727, -.10718929, .13883641, .16848836, .19463101, .17693388, -.19324726, .17666618, .24463719, .79355468, .60572762, -.15788247, .59842521, .58367695, .31042585, .27243172, -.1086875, .27165932, .27566087, .04135138, .04049242, -.02863879, .04048945, .04609512, -.32145068, -.38395426, .08396824, -.38194144, -.25889554, -.73562767, -1.4450777, .39204252, -1.3408506, -.75143789, -.36532791, -.44937262, .09336057, -.44617764, -.29209205, -.39892618, -.50704603, .1318741, -.50221789, -.34752938, -.32060474, -.38784896, .14354275, -.38551527, -.30901795, -.1765428, -.19355136, .05657903, -.19327871, -.15221654, 2.3394378, 1.3473676, -.30483287, 1.2813555, 1.4943016, -.31096282, -.37087833, .10283438, -.36896617, -.27093291, 1.0859783, .75577531, -.45440743, .739474, 1.0233855, .19720267, .18057479, -.07989068, .18034148, .18384447, -.3246465, -.38443762, .0533124, -.38261275, -.22398893, -.35286254, -.44059746, .20400798, -.43699738, -.37036456, -.11130243, -.11825382, .06964829, -.11818152, -.1199453, -.06994831, -.07243064, .02493993, -.07241596, -.06249231, -.07509116, -.0781089, .04074936, -.0780887, -.07716899, 1.166492, .82525978, -.14316975, .80901539, .730379, -.58856584, -.87216233, .14631541, -.850078, -.46626919, -.15170571, -.16421673, .05562899, -.16404499, -.13680806, -.23642523, -.26953091, .09431982, -.26876095, -.21928396, 1.2246902, .82709598, -.48183993, .80623267, 1.1306506, -.31617484, -.37923159, .11402568, -.37714942, -.28354963, .61648186, .48125335, -.43749454, .47636965, .69281042, -.64138809, -1.0544577, .27300116, -1.0122425, -.60787193, .00472718, .00471616, -.00215465, .00471616, .00458357, -.61747777, -.97556422, .23622717, -.94236336, -.56476464, -.31496282, -.3808278, .16217289, -.37854867, -.31805992, -.37219955, -.47069992, .1978299, -.46640289, -.37986085, -.71138226, -1.2460676, .21902671, -1.1831298, -.6052169, 1.0772525, .76792309, -.20551361, .75345346, .78133124, -.1475719, -.15801087, .02016759, -.15788791, -.0957702, -.0727345, -.07519354, .01205448, -.07517969, -.0503369, -.08809982, -.09235631, .05365101, -.09232205, -.09408477, -.18005295, -.19752633, .05116633, -.19724419, -.1491437, -.38072892, -.48875079, .25433663, -.48370594, -.41933091, -.36413263, -.46052622, .23616567, -.45631989, -.39712021, -.68556971, -1.1161577, .14429661, -1.0731609, -.51380279, -.71979819, -1.214295, .14099908, -1.1606648, -.52669103, .13541721, .12781347, -.02750881, .12774236, .1002959, -.19155512, -.21398675, .13296114, -.21355002, -.21368831, -.02946115, -.02991134, .0167019, -.0299102, -.03072075, .07547686, .07294779, -.02053261, .07293367, .06161701, -.18542571, -.20554424, .09615491, -.2051812, -.18769258, -.180983, -.19856682, .04954349, -.19828258, -.1480576, .20548708, .18394425, -.55711593, .18356875, .36100638, .30564407, .27130693, -.04864899, .27066583, .20869495, -.4335402, -.55447739, .08104884, -.5489223, -.31232867, .00480665, .00479632, -.00090624, .00479632, .00347259, -.47371878, -.64231774, .16830858, -.63250006, -.42272619, .78206513, .5938595, -.22169969, .58642411, .64728216, -.24252746, -.29054001, .90449951, -.28896615, -.47386365, .33614965, .29324886, -.09098586, .29233972, .27396164, -.02459471, -.02489137, .00878931, -.02489077, -.02198988, -.32686367, -.40010855, .19120171, -.3973953, -.34441735, .45452702, .38874174, -.03322338, .38716258, .23944057, -.61526369, -.92187408, .12080582, -.89722331, -.45055396, -.32979795, -.40438668, .18921242, -.40159837, -.34526974, .01276038, .01267508, -.01062279, .01267499, .01512395, .67025524, .53061827, -.11573048, .5258223, .47023982, .01231046, .0122366, -.00530102, .01223653, .0117124, -.53343753, -.76247714, .17972208, -.74649829, -.46766284, .79134069, .60363712, -.16613213, .59632443, .59256619, .1153121, .10893029, -.08634822, .10887146, .13193025, -.16037794, -.17487406, .07385238, -.17465601, -.15603712, .9654928, .69826557, -.28863239, .68619382, .81337542, -.06134382, -.06330359, .02897981, -.06329316, -.06019435, .00244078, .00243787, -.00102986, .00243787, .00230651, 1.5691233, .98842673, -.5897572, .95409789, 1.4267213, .04228714, .0414951, -.00917155, .04149263, .0320108, 1.3228095, .90357051, -.17791923, .88205697, .85391732, -.01503735, -.01515156, .00743688, -.01515142, -.01498262, .5965217, .48228649, -.1026045, .4786732, .41797436, .06534403, .06314579, -.06755126, .06313346, .08324506, -.49513241, -.70830816, .33087258, -.693397, -.54539501, -.4677422, -.65885271, .39645944, -.64613953, -.55771709, -.20531295, -.22935246, .07626127, -.22888449, -.18594688, .33563435, .29252514, -.09882365, .29160579, .28132472, .31064422, .27186077, -.1343201, .27105662, .29595966, -.55097263, -.7914575, .15102473, -.77441451, -.45093372, -.55340313, -.78297871, .11190365, -.76748207, -.40924731, -.29572207, -.35195959, .14044925, -.35018791, -.29069594, 1.0988318, .77682481, -.23706795, .76147012, .83033837, -.28297883, -.33497381, .15739575, -.33339057, -.29320878, -.35137446, -.43606491, .17272374, -.43269435, -.34938759, .12066639, .11377046, -.08228424, .11370482, .1338155, -.44701492, -.58502391, .11740855, -.57802441, -.36068209, -.30824166, -.36985169, .14184369, -.36781286, -.29982941, 1.2625632, .85442377, -.35283047, .83309177, 1.0400019, -.61868489, -.94808588, .15795341, -.9198961, -.49449967, .29443171, .26202895, -.05259633, .26143623, .20892234, -.27616623, -.32253796, .10147059, -.32124646, -.24921286, -.40471255, -.5251753, .20886682, -.51927976, -.40900718, .33381072, .28756209, -.23980506, .28649889, .37667168, -.09207871, -.09583497, .0090507, -.09580943, -.05353982, .56006342, .45844305, -.08799057, .45539449, .38075608, -.58850091, -.85505713, .10766838, -.83548634, -.42092444, -.18128359, -.19814108, .03465984, -.19788023, -.13158039, -.31121101, -.37485349, .15347266, -.3726993, -.30978256, -.45361014, -.59288488, .10104785, -.58585906, -.34645023, -.01900502, -.0191797, .00622152, -.01917943, -.01650268, .52994269, .43020798, -.21359841, .42710669, .49320629, -.21196157, -.24338567, .34360046, -.24261218, -.3137131, -.25544256, -.29826036, .18707452, -.29706989, -.29009732, -.48657066, -.68175257, .26214621, -.66899595, -.49883296, -.42367461, -.53713506, .07560392, -.53212753, -.30052439, .98389218, .71258108, -.23523613, .70036802, .76938376, .47483615, .39254505, -.18996527, .39018529, .44082267, -.1376024, -.14743101, .03818127, -.14731411, -.11307783, .21915281, .19975787, -.05652117, .19947229, .17575664, -.34172702, -.41941311, .14731614, -.41649423, -.32524677, -.49610192, -.67810347, .13786304, -.66718982, -.40788702, -.16061155, -.17489035, .0640399, -.17467908, -.14894002, -.035485, -.03613234, .01785704, -.03613037, -.03556119, -.10011507, -.10571042, .0649818, -.10565833, -.1092128, -.04909337, -.05051213, .07267563, -.0505053, -.07049444, -.54435295, -.76508557, .11316441, -.7505084, -.4062877, -.11677946, -.12383066, .03591921, -.12375975, -.09931844, -.65726608, -1.0940232, .25523702, -1.0480806, -.60416009, -.29905577, -.35263585, .08481753, -.35104457, -.24755593, -.19437406, -.21352226, .03118789, -.21320842, -.13307532, -.27081395, -.31241964, .06270018, -.31135865, -.20951427, .15849984, .14778562, -.04899389, .14766503, .13502366, -.26566333, -.30965233, .12526537, -.30844405, -.26052021, -.68532103, -1.1922166, .27796429, -1.1334119, -.63914938, -.10471729, -.11043262, .03724848, -.11038066, -.09348138, .00803161, .00800338, -.00126996, .00800336, .00547195, -.07886452, -.08222875, .04562021, -.08220484, -.08279108, -.67807343, -1.1186664, .18148905, -1.0732677, -.55056841, -.17595583, -.19625729, .2342868, -.19586783, -.24389059, -.18978248, -.21062799, .08775934, -.21024721, -.18490353, -.23427545, -.27119856, .24041235, -.27023282, -.29772373, .08337657, .07982728, -.09072793, .07980211, .10804874, -.61638855, -.95161513, .17947302, -.92234774, -.51472994, .20711321, .18931154, -.06572243, .18905694, .17798623, -.3158705, -.38265762, .17068702, -.3803213, -.32415263, -.13189491, -.140452, .0244726, -.14035955, -.09478117, -.16764576, -.18354498, .07563673, -.18329408, -.16200035, -.74333211, -1.3062087, .15845589, -1.2395043, -.55945873, -.04221584, -.04305493, .009424, -.04305215, -.03226552, -.72568875, -1.1692499, .08157792, -1.1260602, -.44126669, 1.77338, 1.061003, -.98213706, 1.0157412, 1.8348557, .36294902, .31489956, -.07387521, .31384364, .26899239, -.16160544, -.17445902, .02511073, -.17428883, -.10946294, -.70185702, -1.1708789, .15445141, -1.1212862, -.53387517, .52140835, .42384374, -.22667406, .42082704, .49765602, -.59259514, -.90874925, .2250736, -.88164116, -.54070067, -.40948553, -.52396608, .12972269, -.51869615, -.35170161, .20816448, .18841311, -.17581014, .18810139, .24791095, .20215826, .18342302, -.17387828, .18313418, .24222526, .11115793, .10565635, -.03894939, .10561099, .09873486, -.04123664, -.04213836, .02615007, -.04213508, -.04463647, -.50670895, -.6690676, .05365911, -.66052978, -.30203936, .15720202, .14634125, -.0650782, .14621632, .14761391, -.1834838, -.20188296, .05681243, -.20157602, -.15639502, .44790692, .37157338, -.24828478, .36942029, .46357344, -.49986366, -.69590579, .18716349, -.68336807, -.45392568, .03891738, .03824744, -.00816765, .03824552, .02913878, -.55877496, -.7915482, .10588122, -.77577269, -.40436565, -.39515345, -.48937289, .06294872, -.48566269, -.26988753, .90903762, .66431873, -.31404331, .65355199, .80363915, .23699414, .21462184, -.05905524, .21427054, .1878976, -.22644866, -.25608388, .08060168, -.25543944, -.20219537, -.51409536, -.72513605, .19086976, -.71103345, -.4655341, -.09390425, -.09808598, .01622865, -.09805496, -.06590135, -.18293775, -.20044297, .04035424, -.20016426, -.13926499, .30686752, .26943475, -.11489929, .26867629, .2786654, .25941202, .23225778, -.08495427, .2317852, .22528476, -.29289941, -.33915755, .04087848, -.33794516, -.19141997, -.55640335, -.82344801, .22498141, -.80273028, -.51838453, -.23501333, -.26804386, .10169991, -.2672728, -.22396416, .80660885, .61166026, -.18348059, .60392645, .62036702, .63597057, .50273699, -.1890479, .49813604, .53475965, -.17831489, -.19376152, .02258637, -.19353881, -.11282809, .15788542, .14683688, -.07146351, .14670816, .15273297, .31437664, .27629039, -.08785822, .27552393, .25896295, -.02119928, -.02142054, .00801789, -.02142015, -.01931572, -.213974, -.24075384, .0907402, -.24019679, -.20254301, .57300032, .4618039, -.16673832, .45824071, .4784006, -.69990914, -1.2024454, .20969585, -1.1456999, -.59006663, -.43663688, -.57937163, .19843595, -.5717182, -.42295782, -.6999281, -1.1796357, .17473638, -1.1277224, -.55527322, -.33628019, -.40642213, .0943844, -.40400116, -.27740286, .09676137, .09286071, -.01635389, .09283451, .0674039, 1.8018275, 1.1002365, -.48487958, 1.0568529, 1.4656494, -.1943912, -.21310284, .02600456, -.21280316, -.12525957, -.17430367, -.19142964, .07306846, -.19114968, -.16435806, .26648034, .23882517, -.0625431, .23834798, .20709992, -.08958401, -.0935379, .02193978, -.09350883, -.07061675, -.39875508, -.51947359, .26043558, -.513467, -.43589403, .51016929, .41311266, -.33056636, .4100625, .55621038, -.16540808, -.18191671, .12555404, -.1816426, -.19010405, .50464921, .40235926, -.79250121, .39893887, .739043, -.32848361, -.39668106, .11034615, -.394338, -.28769889, .21190257, .19356919, -.05856727, .19330527, .17390783, .61856884, .48325688, -.4108685, .47838328, .6799907, -.12318035, -.13091587, .03237189, -.13083497, -.09940929, -.16718999, -.18387022, .11490442, -.18359337, -.18589274, -.00552738, -.00554152, .00133074, -.00554152, -.00433233, -.34750055, -.42763568, .14151549, -.42458214, -.32452513, -.34545728, -.4196014, .09219207, -.41696914, -.2802232, -.49934896, -.69915736, .21022035, -.68612969, -.47152459, 1.0062373, .71246557, -.45343421, .6985066, .97195996, -.40626462, -.5176477, .12244208, -.51261747, -.34318337, -.42870959, -.56598503, .20357239, -.55877089, -.42139731, 1.1220376, .80928424, -.09607301, .79506088, .62308708, -.57000283, -.84169848, .17929395, -.82075725, -.48840851, -.57962635, -.9324093, .48360729, -.8981939, -.68750051, -.34757552, -.43013201, .17133745, -.42689337, -.34593424, -.40116626, -.51722287, .18855829, -.5116987, -.39298395, -.1318524, -.14315117, .23189101, -.14299002, -.2005226, .34696024, .30208288, -.08187864, .30111914, .27013862, .68635505, .53431463, -.21049749, .52877116, .5831651, .53415328, .43106998, -.272978, .4277847, .53805889, -.55241711, -.80281608, .17929285, -.78441849, -.47830957, -.15357511, -.16710791, .08543382, -.16690944, -.15913553, -.37272554, -.46913947, .16937978, -.46502656, -.36104108, -.11396473, -.12090322, .04674349, -.12083286, -.10668353, -.16232168, -.17592145, .03673375, -.1757318, -.12462814, .3351197, .29115699, -.12639674, .29019958, .30506233, -.68757701, -1.1034464, .12006062, -1.0633468, -.4841996, .28062883, .24683379, -.20418777, .24615772, .31801048, -.63868948, -1.0709972, .34581798, -1.0247459, -.65587191, -.58877059, -.91706114, .29009841, -.88772079, -.58589868, .81611024, .61280088, -.25217023, .60449659, .69514247, -.05579265, -.05736679, .02123494, -.05735938, -.05094228, .13043956, .12285477, -.05233093, .12278132, .12120923, -.20919899, -.2352261, .10393811, -.2346879, -.20875714, -.56744871, -.81155064, .11068618, -.79449026, -.41462824, -.1940966, -.21434157, .04919301, -.21399033, -.15475917, .44182534, .36408877, -.40500544, .36182622, .54075104, -.01865539, -.01882854, .00787443, -.01882827, -.01763137, -.08065021, -.08465838, .13779541, -.08462519, -.1214764, .43433084, .36925957, -.07083523, .36764328, .29897868, -.33521405, -.41214582, .18289228, -.40922816, -.34510925, -.12262503, -.13071836, .05044404, -.1306294, -.11490335, .23473909, .21374147, -.0364345, .21342897, .15894171, -.33774469, -.41738767, .20562881, -.41428549, -.3606592, -.36903476, -.46565002, .19791216, -.46147956, -.37775684, .06340986, .06144898, -.03875127, .06143887, .0677969, .33058378, .28722357, -.14068763, .28627944, .31329226, -.26984463, -.31387478, .09954822, -.31268285, -.24383555, .18696495, .17099738, -.13956152, .17077045, .21368401, -.52960263, -.7515304, .16771962, -.73640445, -.45481842, -.28316653, -.334515, .14281789, -.33297169, -.28398724, .36771133, .31898127, -.06732474, .3179093, .26307095, -.02603472, -.02636435, .00855866, -.02636365, -.02263848, .12908829, .12155656, -.05880958, .12148337, .12514608, -.24843362, -.28399314, .07459121, -.28314787, -.2095943, .29605613, .25933735, -.18357246, .25858099, .31807427, .53914806, .43730331, -.19476862, .43412486, .48378792, -.40364205, -.51834327, .16088398, -.51297832, -.37426441, -.21349457, -.24323462, .20531619, -.2425465, -.26550678, .51045144, .41854975, -.16824595, .41581371, .44425039, .0641572, .06226, -.02314806, .06225065, .05754555, 1.0415381, .76123549, -.10527893, .74890682, .61128058, .49465947, .41079497, -.1055044, .40844152, .37236691, .39576095, .33863294, -.09758524, .3372652, .31267513, -.30237268, -.37541857, .58287022, -.37250493, -.47412805, .31545764, .27616088, -.11590711, .27534789, .28466936, -.61214837, -1.0049153, .39043097, -.96491339, -.66388963, -.34251752, -.43626109, .4745376, -.43203465, -.48108528, .4715008, .38702078, -.29953, .3845176, .51067555, .46184264, .38043816, -.290303, .37806466, .49845183, .25935317, .23285363, -.06588961, .23240341, .20695537, -.35230193, -.43826698, .18310789, -.43480406, -.35688013, -.32328653, -.38029361, .04067316, -.37862702, -.20409752, -.13313177, -.14309375, .07244864, -.14296964, -.13694343, .33611667, .29069772, -.17158709, .28967912, .3384529, -.30067393, -.35833911, .13036976, -.35650718, -.28672538, -.09645221, -.10094237, .01903377, -.10090755, -.07074999, .06671792, .06454695, -.04173267, .06453518, .07188921, .6182557, .49486798, -.12857452, .49080423, .46150214, .17507007, .16115999, -.11280864, .16097604, .19051627, -.15839997, -.17079417, .02584927, -.17063272, -.10905933, -.25464138, -.30430441, .5528601, -.30270031, -.41543308, .8334476, .61380438, -.46533053, .60433542, .86466799, -.57173845, -.81511966, .0986911, -.79827964, -.401083, .20398599, .18794113, -.02996711, .18773108, .13561004, -.47896225, -.63114888, .08014446, -.62321102, -.33253347, -.08587928, -.09012595, .07993469, -.09009097, -.10564462, -.11145971, -.1181655, .05063144, -.1180983, -.1079515, -.05762836, -.0593631, .02864716, -.0593544, -.0575168, -.39564628, -.50560667, .16467577, -.50057398, -.37218422, -.8186431, -1.5612468, .13726219, -1.4578464, -.56875258, -.4298262, -.56849767, .20837131, -.56115667, -.42541999, -.29717354, -.34824523, .06655057, -.34678971, -.22737045, -.2663489, -.30960182, .10678396, -.30843645, -.24744534, .62238915, .4899456, -.27428963, .48530168, .59674365, -.46663198, -.60878868, .07689304, -.60167196, -.32232106, 1.08491, .75534841, -.45134348, .73909341, 1.0204104, .26931269, .24231221, -.03990889, .24186205, .17955787, .47043431, .39382938, -.09807516, .39176342, .35144902, -.00905558, -.0090941, .00243494, -.00909407, -.00736406, .20377738, .18745498, -.0363535, .18723738, .14453157, .62720037, .50051111, -.133264, .49628922, .47153994, .41297257, .34729489, -.2110996, .34556443, .41602549, -.58715294, -.89322081, .21747192, -.86754487, -.53126584, -.50533386, -.71893342, .25540897, -.70425374, -.50715531, -.14009154, -.1512005, .07686636, -.15105385, -.14449851, -.59694963, -.94176184, .30421971, -.90990987, -.60075525, -.39574995, -.49862122, .10815252, -.49421175, -.3235709, -.02203916, -.0222661, .00521286, -.02226571, -.01717245, -.5643388, -.84952657, .25781957, -.82629313, -.54761487, -.46143087, -.59850049, .0722647, -.59180533, -.31336933, .06867264, .06640179, -.03857597, .06638928, .07139012, 1.4069938, .91911624, -.46391089, .89191944, 1.2246622, .01437706, .01427343, -.00812206, .01427331, .01497427, -.24825838, -.28976038, .23058706, -.28860956, -.30518107, -.45187503, -.58313209, .07457827, -.57685962, -.31229114, .25773194, .23150697, -.06631236, .23106325, .20653183, -.52978301, -.73966925, .12414029, -.72611493, -.41150925, -.58921908, -.91838301, .29081526, -.8889123, -.58667862, .25824659, .23058882, -.11231133, .2300964, .24651362, .40403531, .34235158, -.15679228, .34079063, .37130526, .27361868, .24458212, -.06414271, .24406985, .21256394, -.10496889, -.11072481, .03798771, -.11067224, -.0942464, .09818183, .09312006, -.15636528, .09307659, .14445886, -.52659025, -.77067499, .29419098, -.75235543, -.54643058, -.17248065, -.19014623, .10983932, -.18984525, -.18696323, .65251306, .50119818, -.57530002, .49543065, .78831708, -.23637986, -.27195111, .16012657, -.27106246, -.26156007, -.22305026, -.25038868, .05559303, -.24983171, -.17685551, .4107871, .34630393, -.18930093, .34462669, .39976562, .2216956, .20296372, -.03198751, .20270035, .14650132, -.54044385, -.77070257, .15552789, -.75475731, -.44955187, .15455827, .14435313, -.04740392, .14424093, .13132364, -.2975832, -.34559306, .04196399, -.34430789, -.19515268, -.30919006, -.36357347, .05707774, -.36198757, -.22181076, .1470479, .13773376, -.04671594, .13763552, .12641664, -.27668337, -.32180148, .08112549, -.32058084, -.23158894, -.34043974, -.42537637, .27778143, -.42187937, -.4008094, .98571709, .72132124, -.15599688, .70972918, .67176416, -.53744887, -.77628212, .20199067, -.75906314, -.48866572, .76475491, .58244415, -.23356688, .57530701, .64887633, .4292717, .36394447, -.09307895, .36229654, .32492415, -.20931072, -.23535541, .10360539, -.23481677, -.20860839, -.55941465, -.8232608, .19772633, -.8031278, -.49833424, -.78218099, -1.4146044, .13373406, -1.3351006, -.54696833, -.39557156, -.50125184, .12896442, -.49659865, -.34301782, .55608386, .4539049, -.10853815, .45080137, .40640995, .00168945, .00168803, -.0008074, .00168803, .00166419, -.63501826, -1.036189, .27290696, -.99591278, -.60377113, .74239142, .54687025, -1.1635979, .53844638, 1.086508, -.20609582, -.23159291, .11227057, -.23106861, -.21206944, .38679794, .32601357, -.31028056, .32443082, .45281168, -.15855635, -.17295887, .08414102, -.17274116, -.16173413, -.27333304, -.32138804, .1525336, -.3199873, -.28352624, -.44275803, -.58484206, .15931926, -.57735932, -.39677447, -.02067804, -.02090629, .016071, -.02090587, -.02395321, -.12558298, -.13447685, .07401916, -.13437197, -.1326616, .16734546, .15439342, -.12396971, .15422656, .19077633, -.21300708, -.23931334, .08510621, -.23877333, -.19766348, -.58182647, -.85676257, .14576395, -.83574557, -.46212099, -.18692859, -.20567212, .04893615, -.20535946, -.15066201, -.4993853, -.67374138, .09900201, -.66377543, -.36687251, -.58389203, -.90928901, .30932041, -.88022178, -.59525249, -.18699099, -.20657095, .06832535, -.20622992, -.16842934, -.50695147, -.71397244, .20763442, -.70020786, -.4743374, -.04559305, -.04668013, .02485613, -.04667581, -.04692672, .21231924, .19457061, -.04049855, .19432371, .15398652, -.36578368, -.46398373, .24873611, -.45963919, -.40526506, .33809673, .29409674, -.10778097, .29314608, .29099443, .57700922, .45883265, -.309139, .4548408, .59044996, .00642141, .00640259, -.0014665, .00640258, .00494528, -.69472872, -1.2290276, .28823549, -1.1648157, -.65283383, -.70671288, -1.2777091, .30036925, -1.2059735, -.66945876, .21664136, .19702405, -.07857647, .19672851, .19465628, .02260057, .02233772, -.01714393, .02233721, .02596927, -.4978844, -.6832303, .14528112, -.67195796, -.41606904, .9373839, .69029883, -.18226697, .67964474, .68421247, -.15536107, -.1676527, .03298504, -.16749081, -.11677337, .0753751, .07282344, -.02287026, .07280904, .06381444, -.48360754, -.66005986, .16400979, -.64953463, -.42490838, .17651917, .1645224, -.02184892, .16438664, .1108361, .14902537, .13901636, -.07521762, .13890443, .14949385, -.11372673, -.12063143, .04645204, -.12056161, -.10631306, .38962092, .32846824, -.28859996, .32687783, .44415743, -.13831529, -.14874468, .05677358, -.14861375, -.12951068, .45014415, .37964011, -.08873034, .3778103, .33006676, -.59932926, -.88869049, .12781384, -.8661144, -.45114168, -.07285928, -.07618779, .15321854, -.07616245, -.11760804, .76961802, .57911231, -.36943314, .57137871, .7592278, .66658241, .5152085, -.36793387, .50955464, .68892057, -.62358675, -.97685879, .19677698, -.94481243, -.53489189, -.58088849, -.90231318, .31211268, -.87379199, -.59498906, .10412954, .09960377, -.01871541, .099571, .07403875, -.23137148, -.26715256, .2316752, -.26623412, -.29163729, -.0382953, -.03912356, .04295741, -.03912058, -.05013254, -.54583794, -.7822518, .15643182, -.76562044, -.45341322, -.62053932, -.92182829, .09946152, -.89819597, -.42469248, -.64636966, -.9678868, .08069936, -.94208274, -.40702462, -.24688153, -.28801846, .2355242, -.28688146, -.30620639, -.27727563, -.32345202, .09267822, -.32217641, -.2424434, .23571931, .21441825, -.03915749, .21409801, .16325947, .02579881, .02546094, -.01766667, .0254602, .02865022, .01018719, .01013478, -.00596942, .01013474, .01074048, -.23096241, -.26423235, .14006962, -.26343648, -.24631197, -.71367779, -1.1606493, .10338586, -1.1161336, -.47224261, .31282919, .27725536, -.04603387, .27658309, .20808495, -.05945849, -.06112264, .0119089, -.06111488, -.04383051, .51297607, .4271129, -.06779652, .42473358, .32921317, .00025261, .00025258, -.00020794, .00025258, .00029828, -.3127226, -.37298985, .09843749, -.37106606, -.26802154, -.00170261, -.00170402, .00066826, -.00170402, -.00157061, 1.1611366, .79812769, -.40803169, .77973498, 1.0323577, -.59119608, -.88733313, .1703966, -.8634081, -.49202217, -.02362601, -.023929, .02083461, -.02392835, -.02854514, .05530985, .05393895, -.01449093, .05393329, .04459064, .47259754, .38931982, -.24069738, .38689234, .47551194, -.33479564, -.41306924, .20857697, -.41004602, -.36026216, -.21943083, -.24744835, .08621337, -.24685385, -.20248832, .57101126, .46007865, -.17379503, .45652008, .48393337, -.0316426, -.03215089, .01463176, -.03214953, -.03082882, -.2881194, -.33455702, .05396576, -.33331514, -.20769742, 1.2161216, .816381, -.62139287, .79516325, 1.2249455, .18269367, .16919124, -.03852079, .16902511, .1370011, .14266762, .1341986, -.03132067, .13411488, .10843529, -.00524903, -.00526237, .00190546, -.00526237, -.00471768, .75192761, .57366542, -.24827375, .56672404, .6547934, -.20089528, -.22412975, .0826315, -.22368296, -.18823702, .34601415, .29494433, -.36799881, .29369444, .44499457, -.10867453, -.11453236, .02495986, -.11447976, -.08385119, .28694097, .25478952, -.07838203, .25419079, .23457256, .427035, .3673767, -.03670304, .36599389, .23743951, -.62148672, -.9681708, .1885892, -.93717387, -.52618303, -.00869881, -.00873551, .00312224, -.00873548, -.00778883, .07610759, .07323409, -.05970733, .07321602, .08843778, -.00509814, -.00511164, .00345547, -.00511163, -.00564227, .28586233, .2547403, -.05935707, .25417708, .21327443, 1.6615841, 1.0644756, -.22420563, 1.0300949, 1.0737596, -.11622361, -.12359196, .05572119, -.12351416, -.11460749, -.47749766, -.67181146, .32901169, -.65893501, -.53136703, -.19254828, -.2121792, .04394746, -.21184626, -.14825671, -.04649595, -.04755493, .01426885, -.04755091, -.03951388, -.07931842, -.08260539, .03410218, -.08258269, -.07542583, -.26884138, -.31519171, .15172867, -.31386657, -.27991744, -.24944187, -.2824923, .0407766, -.28176471, -.17184092, -.40601813, -.52475388, .18290599, -.51904222, -.39214763, .45282614, .37853673, -.14522169, .37651843, .39051838, .01715587, .01697844, -.05316215, .01697813, .03151273, .34733492, .30333315, -.06454921, .3024075, .24973108, .02556932, .02523941, -.01655107, .0252387, .0278675, -.1494024, -.16187134, .06915062, -.16169812, -.14560638, -.26773939, -.31135008, .10467388, -.31017154, -.24665937, -.35702969, -.44172636, .13711975, -.43840783, -.32697375, -.01508935, -.01520375, .00711999, -.01520361, -.01480074, -.27394964, -.31595297, .05636073, -.31488397, -.20375863, -.10874203, -.11488613, .03671461, -.11482831, -.09540136, .76481258, .58966962, -.13679373, .58307459, .54291946, -.3530344, -.43827726, .16826872, -.43487874, -.34744746, -.64654178, -1.0535779, .23292136, -1.0128438, -.57962107, -.13580059, -.14604153, .06581002, -.14591295, -.13439253, .35804975, .31001552, -.09546595, .30894596, .29034994, -.18155178, -.19938011, .05251883, -.19908883, -.15128017, -.45439126, -.62707997, .33824226, -.61636569, -.51884695, .15608272, .14581403, -.04227721, .14570154, .12723755, -.46485105, -.63744583, .24797994, -.62697558, -.47499757, -.45553411, -.5845954, .06002834, -.57857639, -.29206267, -.54320935, -.79196175, .21592063, -.77350635, -.50321418, -.48736189, -.67165321, .18788473, -.66027432, -.44689779, -.56800422, -.82241252, .13509182, -.80393212, -.44339153, -.11162201, -.11845271, .05756639, -.11838309, -.11278021, -.04907169, -.05018343, .00885214, -.05017923, -.03493387, -.10962828, -.11590109, .03819445, -.11584131, -.0971908, -.45160058, -.58885072, .0985034, -.58199558, -.34250223, -.1994024, -.22374977, .13241529, -.22325561, -.21918439, -.22905152, -.26273431, .17412391, -.26191188, -.26338129, -.10781419, -.11381191, .03456585, -.11375634, -.09297004, -.30423076, -.36129752, .10179414, -.35952395, -.26610498, -.1425758, -.15224961, .0189258, -.15214031, -.09163442, 1.9216935, 1.1866063, -.20976514, 1.1418559, 1.1571168, -.13575323, -.14470404, .02217588, -.14460576, -.0934983, 1.1687913, .81092704, -.28073579, .79314467, .91537822, .38176342, .32608969, -.14618068, .32474321, .34927664, -.2598243, -.29725508, .05464092, -.2963596, -.19467156, -.5464075, -.77583871, .13201835, -.76017113, -.42877804, -.61671174, -1.0006056, .32406862, -.96258745, -.62701386, -.42496381, -.56190555, .22665969, -.5546644, -.4342129, -.00255548, -.00255854, .00071623, -.00255854, -.00210705, .34223009, .29781075, -.09495459, .29685356, .28122944, -.45673818, -.58402781, .05310595, -.57818627, -.28086822, .12762718, .12045632, -.04446452, .12038922, .11314707, -.32207242, -.39951794, .34140655, -.39644283, -.41374838, .44372967, .37334388, -.1152856, .37149414, .35673632, .19218058, .17660794, -.06536837, .17639793, .16902031, -.14463536, -.15745123, .14423191, -.15726224, -.18205954, -.35681123, -.43234864, .06492199, -.42970297, -.25474144, -.78585143, -1.3684292, .09378862, -1.3007048, -.4874765, -.43056416, -.5679701, .19280781, -.56077272, -.41502742, -.1194873, -.12628985, .0183943, -.12622535, -.08068366, 1.1504472, .78712309, -.51432053, .76854013, 1.1083215, .66994874, .51588221, -.41716434, .51005709, .72078672, -.50174162, -.74091841, .49762731, -.72248226, -.63042219, .0980341, .09337897, -.0712195, .09334215, .11103531, -.30095346, -.36594052, .28942734, -.36361946, -.37427379, -.28916199, -.34238757, .13404999, -.340764, -.28196361, -.31635819, -.39324606, .42212845, -.39016088, -.43881109, .01227257, .01219951, -.00506124, .01219944, .0115094, 2.3768308, 1.3307905, -.56859495, 1.2590067, 1.8589876, -.21238201, -.24031481, .13972587, -.23970439, -.23272734, -.0683085, -.07075601, .032727, -.0707414, -.06734343, -.67175986, -1.0412262, .09493018, -1.0086275, -.44084658, .04463719, .04369266, -.01844834, .04368933, .04189161, -.28367342, -.33030346, .0703631, -.32903186, -.22456259, .20751412, .18880873, -.10576337, .18852821, .20884313, -.39639779, -.53145541, .5463898, -.5239165, -.55581681, -.53396651, -.76610369, .19014519, -.74971475, -.47684928, -.41388794, -.52473636, .0911924, -.51984373, -.3149571, -.0474799, -.04858814, .0149372, -.04858383, -.0406855, .01555976, .01544743, -.00437587, .0154473, .01284399, -.54760283, -.84791733, .48049955, -.82149155, -.6605182, -.20115182, -.22518278, .10467438, -.22470551, -.20384783, -.63784704, -.95934541, .09561186, -.93321814, -.42689881, .90776996, .66918714, -.22617176, .6589283, .71968093, -.06315845, -.06515324, .0208039, -.06514274, -.05495567, -.23762773, -.27339367, .15373728, -.27249999, -.25894119, -.50295249, -.69954311, .17494849, -.68701101, -.44565424, .01552274, .01541147, -.00418046, .01541134, .01262981, 2.1068331, 1.1889219, -1.2133041, 1.1264521, 2.2084453, .47868198, .39622289, -.16575858, .39387229, .42351298, -.02986399, -.03032427, .01615749, -.03032309, -.0306596, -.20453409, -.22636955, .03872599, -.22598184, -.14797487, -.14510921, -.15728345, .09104008, -.15711344, -.15651316, .70931453, .54673599, -.25286811, .54060879, .63367599, -.53000475, -.74513956, .14089154, -.73091807, -.42936319, -.21910342, -.24687749, .0826378, -.24629237, -.19945076, -.41493285, -.52361045, .07768675, -.51891737, -.29907322, 2.6560511, 1.3993556, -1.105995, 1.3079768, 2.498918, -.41589553, -.54146745, .18302736, -.53523562, -.39857021, -.5526323, -.80926377, .20181019, -.78996847, -.49767811, -.13207272, -.14097686, .03313644, -.14087689, -.10495118, .14448753, .13515265, -.06544272, .13505222, .13980328, -.85325759, -1.7623394, .16079813, -1.6167939, -.61634485, .76115922, .57533086, -.33446264, .56788681, .72908173, -.4445706, -.6065932, .31952327, -.59693944, -.50173145, .05289442, .05153665, -.02874207, .05153084, .0543821, -.17820591, -.19853626, .19416859, -.1981506, -.23103852, -.4801718, -.67039242, .27251422, -.65810878, -.50088438, .7304052, .55833536, -.28785848, .55167589, .67470239, -.16887215, -.18469715, .06495133, -.18445039, -.15473125, .35410875, .30570854, -.12846339, .30461071, .31819564, .19684382, .18046651, -.07068492, .18023976, .17627881, -.20643774, -.23348809, .17055485, -.23289913, -.24405671, 1.22551, .8353436, -.35199394, .81523741, 1.0187469, .17923756, .16578231, -.0525377, .16561417, .15000982, .01548457, .01536218, -.01038154, .01536202, .0170751, -.19320256, -.2148948, .0900355, -.21448979, -.18872228, .32956715, .28787909, -.09663489, .28700342, .27585694, -.45938766, -.62492575, .23072715, -.61516994, -.46007551, -.02945698, -.02988319, .01034191, -.02988217, -.02618197, -.67370006, -1.1813745, .34180682, -1.121476, -.67698851, -.02907156, -.02947386, .00775848, -.02947293, -.02358203, -.38428138, -.47793117, .09063364, -.47416337, -.29913877, -.23046223, -.26119584, .08058798, -.26051489, -.20456591, -.12846248, -.13685096, .03186268, -.13675974, -.10169236, -.30992245, -.36335987, .04867032, -.36183198, -.21066874, .22387009, .20364682, -.05894499, .20334289, .18078249, -.17917948, -.19985379, .20268227, -.19945716, -.23521992, -.21841171, -.24833161, .15119244, -.24765074, -.24342806, .4118637, .34607627, -.22690728, .34433546, .42539771, .20921569, .19135775, -.05644292, .1911041, .17032406, -.04141178, -.04225313, .01331006, -.04225028, -.03573984, -.08967166, -.09381787, .032207, -.09378593, -.08030888, -.43040966, -.57519442, .26278401, -.56721212, -.46004218, -.35010686, -.43150226, .14059672, -.42837577, -.32543841, -.45224038, -.61066644, .22306877, -.60158155, -.45019687, -.15280789, -.16560823, .05946739, -.16542975, -.14056163, .22920489, .20747095, -.08083996, .20712815, .20403341, -.02695281, -.02729756, .00709777, -.02729683, -.02176641, -.48806489, -.66592024, .15134011, -.6553242, -.41621053, -.07485465, -.07759823, .01909723, -.07758147, -.05981535, -.55354816, -.81424305, .21356234, -.79437836, -.50771714, -.52719084, -.76911913, .2772692, -.75113379, -.53615346, .05684705, .05526936, -.03355884, .05526206, .06008291, 1.7973129, 1.1092567, -.36345079, 1.06734, 1.329151, -.29913733, -.36026582, .2095762, -.35819823, -.33473752, .84441039, .63750804, -.15314645, .62919077, .60221008, 1.5300133, .9606923, -.79434177, .92687173, 1.5493253, -.35610485, -.467774, .79408433, -.46202371, -.58616174, .82406803, .61953257, -.22184624, .61120781, .67040318, -.33473208, -.42123435, .39786289, -.41754776, -.4467378, -.59704681, -.89013644, .1428792, -.86690615, -.46702334, -.27033676, -.31698804, .1460948, -.31565307, -.27743313, 1.0258857, .7403491, -.19262469, .72738144, .74013901, 1.1604516, .81467254, -.19669616, .79792351, .80914553, .71885488, .54399465, -.50294544, .5370146, .80404022, .05144662, .0500942, -.04484664, .05008827, .06191909, .47392482, .39353593, -.1494817, .39127892, .40645485, .22266008, .20231271, -.06938075, .20200337, .19018864, .25539674, .2288861, -.08805858, .22842855, .22563724, -.19568251, -.2165339, .05437877, -.21616435, -.16088707, .86800737, .63454643, -.44857999, .6242839, .8776181, -.44093685, -.57926714, .14407138, -.572141, -.38263688, -.38796266, -.48874054, .12624104, -.48442371, -.33620446, .54666874, .44328732, -.17675284, .44005735, .47273195, 2.0300788, 1.1682836, -.96824133, 1.1108888, 1.998388, .20015608, .18332403, -.06902249, .18308848, .17684227, .6704618, .53159956, -.10716473, .52685744, .45843382, -.44458745, -.58919121, .16678779, -.58147544, -.40398901, .54446718, .43989513, -.22082431, .436578, .50777747, .33144135, .28713208, -.17030141, .28614888, .33446746, .39694643, .34039606, -.08209858, .33905965, .29576253, -.42074543, -.5470025, .16075656, -.54077417, -.3846619, -.34132884, -.41326123, .08979717, -.41075309, -.2755579, .27126712, .24182145, -.08746021, .24129014, .23435718, .44037707, .37447891, -.06255576, .37284401, .28950022, -.14644983, -.15791575, .04864516, -.1577663, -.12778576, .83887112, .62380912, -.30053485, .61477927, .75065164, -.58971609, -.84195736, .07898515, -.82442391, -.38014896, -.14693144, -.15819566, .04001161, -.15805189, -.11999096, -.35444119, -.4312898, .08034526, -.42853408, -.27228656, .0737336, .07125403, -.02561239, .07124013, .06530358, -.14687879, -.15771931, .02953682, -.1575861, -.10841864, -.14879663, -.16058595, .04713587, -.16043045, -.12779756, .255008, .22848792, -.09093051, .22802936, .22783254, .52932208, .43116877, -.17994595, .42816069, .46544749, -.57678802, -.83528755, .11985366, -.81649906, -.43043204, -.43909753, -.55885675, .06365748, -.55347575, -.29062556, .59572477, .47490671, -.21164208, .47086457, .53158712, 1.3566666, .89996404, -.38104577, .8751849, 1.1193978, .23076888, .20661165, -.21673278, .20619121, .28473205, -.34028239, -.4117036, .08954949, -.40922324, -.27474134, -.37062089, -.45756657, .09456789, -.4541971, -.29617234, .38295285, .32751843, -.13106841, .32618755, .3374993, -.37335462, -.47661172, .25405495, -.47190847, -.41374577, -.15304894, -.16668687, .09593084, -.16648462, -.16502496, .1042071, .09911783, -.05736882, .09907642, .10760526, -.46824434, -.62851306, .14796752, -.61952704, -.40183444, .5037424, .41082186, -.25088311, .4079888, .50308281, .84808535, .63314877, -.23483142, .62422333, .6964476, 1.0502609, .7772032, -.06052008, .76558315, .51110244, -.53151373, -.76676609, .21629309, -.74987, -.49625002, .02620452, .02584242, -.02552688, .02584158, .03272855, .2398854, .21542703, -.12027352, .21501237, .24010574, -.22643811, -.25247045, .03030234, -.25197283, -.1459268, .1166085, .11048453, -.04729675, .11043096, .10875283, 1.3431452, .89781391, -.32261633, .87398692, 1.0519314, -.00187006, -.00187161, .000327, -.00187161, -.00131753, -.15164755, -.16445306, .06738007, -.16427307, -.14579549, .08269046, .07945194, -.04361586, .0794308, .08417732, .08617637, .08305152, -.0150427, .08303264, .06067978, .2798524, .25006393, -.05532456, .24953681, .20540075, -.30467726, -.36042436, .08464232, -.3587339, -.25047586, .30195525, .26443918, -.15980555, .26366505, .30772941, 1.340299, .89487285, -.34074742, .87098951, 1.0697657, -.26049778, -.3020933, .1130195, -.30099117, -.24846419, .0397316, .03898097, -.01635773, .03897861, .03723989, -.34632342, -.41654823, .06160529, -.41419106, -.24539775, -.37410872, -.45578874, .0546393, -.45283957, -.2482239, -.04034842, -.04111172, .0087849, -.04110931, -.03058252, -.12428565, -.13264089, .05264014, -.13254735, -.11759703, -.72785825, -1.2666293, .17219649, -1.2040833, -.56717355, 1.8408131, 1.1261187, -.38746129, 1.0820371, 1.3796192, -.18881786, -.20840084, .05869633, -.20806299, -.16115447, .06242098, .06068176, -.0164772, .06067368, .05044965, .41261605, .34419064, -.34676838, .34231182, .49059213, .60428656, .48029853, -.21858193, .47610295, .54247123, -.30322308, -.36506293, .18549386, -.36297539, -.32431075, .1572132, .1467182, -.04614981, .14660154, .13164144, -.39806354, -.51019956, .1704672, -.50499905, -.37802908, -.2302522, -.26219035, .10869935, -.26145448, -.22588541, -.05024085, -.05158971, .03198843, -.05158368, -.05445599, -.55766118, -.84608885, .31656254, -.82207079, -.58175945, -.24070252, -.2759872, .11441098, -.27512835, -.23667533, -.16040658, -.17378822, .03903075, -.1736024, -.12617125, -.06634171, -.06855248, .02223805, -.06854021, -.05806307, 1.3592493, .8944937, -.48455987, .86891532, 1.2142979, -.28906615, -.34194426, .12870891, -.34034118, -.27810643, -.50352365, -.69691907, .15762218, -.68479707, -.43075371, -.69471901, -1.0704718, .06720278, -1.0378355, -.40180178, .21847797, .19887323, -.06684954, .19858055, .18548747, -.5428572, -.75471105, .0941741, -.74122646, -.3814558, .03577835, .03513084, -.02541775, .03512889, .04022251, .21380327, .19363341, -.13368382, .1933169, .23034521, -.32240633, -.39064823, .14593547, -.3882585, -.31188847, .66465513, .52295291, -.16608129, .5179753, .52744981, -.32430575, -.39326332, .14356266, -.39083764, -.31140597, .05393036, .05264785, -.01205061, .05264277, .04123207, -.0028317, -.00283571, .00140141, -.00283571, -.00282204, -.02135293, -.02156446, .00476595, -.02156411, -.01631917, .10786111, .10313359, -.01531064, .10309907, .07088991, -.47964118, -.64280246, .11783585, -.63370878, -.37848336, -.39842251, -.51601229, .22492566, -.51030478, -.41487657, -.09905477, -.10351316, .01158226, -.10347973, -.06102737, -.24547459, -.27872479, .0546228, -.27797657, -.18741558, .10888075, .10361494, -.03673675, .10357251, .09550168, -.66853058, -1.0972597, .19254359, -1.0536153, -.55624639, -.26737067, -.31576114, .22301942, -.31430952, -.3171028, 1.0645332, .73086408, -.85099415, .71391715, 1.2447773, .22606207, .20453712, -.09427344, .20419621, .21279345, -.43314942, -.58895264, .36564343, -.57978648, -.51576802, -.23247676, -.25948378, .02658345, -.25896213, -.14216744, .48348128, .39798279, -.20933574, .39548186, .4608337, .17081161, .15847915, -.05211926, .15833091, .14488419, -.51725932, -.74111587, .2395372, -.72537996, -.50420429, 1.1637011, .7996095, -.40572604, .78114865, 1.0319261, .517248, .42450814, -.14397092, .42175838, .42550122, .20377275, .18713122, -.04431389, .18690503, .15439055, .37960426, .31476553, -.95803217, .31293262, .65116455, .26374504, .23715653, -.04998972, .2367108, .19087972, .16509569, .15369065, -.04393403, .15355947, .13379324, -.14878344, -.16056319, .04689619, -.16040793, -.12757304, .03112964, .03070085, -.0062502, .03069987, .02296628, -.45146616, -.6190492, .3128399, -.60888544, -.50334703, .01026683, .01021352, -.00610921, .01021347, .01088001, -.03831364, -.0390543, .01605932, -.03905191, -.03612612, .24916831, .2203365, -.34282994, .21978215, .3491656, .20605202, .18741517, -.11593127, .18713473, .21431939, .26738299, .23812242, -.10704603, .23759018, .24828817, -.07107709, -.07356866, .0197543, -.0735541, -.05844091, .23730441, .21182058, -.22739701, .21136564, .29476469, -.27485574, -.31636297, .04916292, -.31532239, -.1951158, -.19505071, -.21275145, .01592398, -.21248413, -.10660859, .70056918, .54467763, -.18947516, .53896875, .57081421, 1.6429994, 1.0053109, -.95644829, .96598995, 1.7284445, -.46441552, -.63262118, .21761309, -.62265912, -.45447446, .14443729, .13599906, -.02424701, .13591696, .10038811, -.52960941, -.79336663, .39957719, -.77217395, -.60745488, -.33390194, -.4038831, .10318464, -.4014562, -.28442056, -.2285471, -.25905302, .0867362, -.25837651, -.20847818, 1.2125627, .7984311, -1.1857801, .77566244, 1.5164014, -.32860078, -.40410853, .21625493, -.40124137, -.36011765, -.21919949, -.24554758, .05514477, -.24502109, -.17434298, .39846564, .33805359, -.16176033, .33653529, .37173027, .14472573, .13684479, -.01196691, .13677331, .07943914, -.62022414, -.92676789, .10887495, -.90231422, -.43754068, -.14261973, -.1536374, .05400271, -.1534957, -.12999748, -.01461438, -.01471576, .0041704, -.01471564, -.01212242, .99225736, .70501776, -.44703681, .69147821, .95838641, -.48755881, -.66838696, .16829922, -.65742882, -.43091212, -.3777599, -.48123749, .2179296, -.47656828, -.3962105, .20800236, .18925086, -.10391383, .18896962, .20794411, -.19079329, -.213611, .16107615, -.21315735, -.22719345, .31904245, .27589917, -.26252013, .2749309, .37667186, .04010878, .0393186, -.02236594, .039316, .04159413, -.02494808, -.02525158, .00845639, -.02525096, -.02191609, .8212072, .60966564, -.38077433, .60074282, .80081903, -.24368044, -.27772481, .07283286, -.2769348, -.2052735, .66968971, .52729017, -.15116308, .5223009, .51373718, -.22175179, -.25047303, .08820703, -.24985487, -.2054735, -.38644071, -.47499015, .05802841, -.47163706, -.25878879, .01919507, .01902635, -.00490186, .01902611, .01534347, -.3713334, -.4571303, .08430312, -.45385478, -.28540871, .14357274, .13569087, -.01381273, .13561879, .08288664, -.13841049, -.1481505, .03228135, -.14803637, -.10734288, .87551684, .66655617, -.08041144, .65836644, .49769004, .91127172, .66035816, -.42523081, .64907921, .89053331, -.30803484, -.37574199, .27045591, -.3732811, -.37162825, -.00678639, -.00681114, .00619686, -.00681113, -.00829519, -.27461572, -.32156385, .12059118, -.32023279, -.26298568, -.27504152, -.31881524, .07147225, -.31765917, -.22113356, .73670468, .57617649, -.09651916, .57041651, .47142231, -.47160338, -.6449074, .20866342, -.63449845, -.45276903, .01841131, .01823494, -.0149963, .01823466, .02166346, -.5864559, -.87238967, .15950373, -.84987263, -.47872986, -.23419911, -.26584045, .07806246, -.26513025, -.20458835, -.06042102, -.06234982, .03249908, -.06233956, -.06190976, -.56688868, -.98333402, 1.2357693, -.93532088, -.92609242, -.64334619, -.99313137, .12726082, -.96260133, -.47228562, -.37870995, -.50850668, .81436117, -.50121973, -.61586685, -.72441698, -1.1832351, .09617001, -1.1370623, -.46560286, -.22634773, -.25477515, .0594121, -.25418177, -.18259368, .42793116, .35498325, -.35874136, .35292514, .50837762, .47199579, .39193388, -.15444486, .38968604, .40978862, 1.1985705, .83253909, -.22061912, .81439502, .85901372, .23502298, .2116479, -.10906943, .21126127, .22925451, -.39761407, -.50587964, .1393689, -.50102296, -.35321552, -.30317936, -.36865385, .27304678, -.36631514, -.36888312, .52891415, .4286696, -.23649281, .42553087, .50957264, .09077196, .08692412, -.04414515, .08689695, .08993709, -.14416059, -.1568803, .14318278, -.15669352, -.18121937, .73647886, .57278216, -.12516194, .56679404, .51397376, -.30020097, -.35901216, .15278503, -.35710415, -.3019801, -.30970783, -.36488812, .0616491, -.36325833, -.22783496, -.13090644, -.14142637, .14714733, -.14128564, -.17148842, 1.7228459, 1.0583109, -.58431917, 1.0175577, 1.5137622, -.22877864, -.25919887, .08362009, -.25852681, -.20609013, -.82510806, -1.6126582, .1515493, -1.4979969, -.59092886, -.64003893, -1.0073362, .1692274, -.97361338, -.51757245, -.13130595, -.14057566, .05050397, -.1404667, -.12031177, -.18244628, -.19973106, .03812658, -.19945858, -.13640887, .02164936, .0214168, -.01169166, .02141638, .02221257, .50690309, .41969105, -.10328319, .41720801, .37581131, 1.0020303, .7351515, -.12375838, .72352927, .62871736]  # noqa:E501

invgauss_resids = np.asarray(invgauss).astype(float).reshape(-1, 5)

wfs_resids = [-1.168096, -1.274198, -22.17336, -1.276003, -3.11599, 1.11769, 1.074522, 93.39722, 1.074787, 4.886437, .7295976, .715076, 143.1204, .7151231, 4.239254, .6471395, .6355711, 124.1729, .6356048, 3.732567, .5949094, .5789607, 24.55698, .5790298, 2.056012, -.8578523, -.8829973, -123.7017, -.8831246, -4.498492, .9996619, .9733517, 207.696, .9734635, 5.92077, -.3647809, -.3685094, -82.85051, -.3685159, -2.225631, -.5218114, -.5276356, -268.2977, -.5276466, -4.180369, -.9659918, -.9815653, -1084.813, -.981608, -10.04078, .3903325, .3878348, 390.8879, .3878375, 3.905176, -.1136672, -.1140306, -24.22441, -.1140308, -.6789552, 1.404348, 1.344308, 166.2025, 1.344715, 6.894916, .6979978, .6888638, 444.2878, .6888834, 6.004232, -.4536614, -.4585339, -171.4895, -.4585427, -3.280201, -.1426753, -.1432245, -34.60201, -.1432249, -.8897463, 4.041986, 3.678221, 839.28, 3.683146, 23.93493, -.4076838, -.4104721, -420.7155, -.4104753, -4.119822, 1.037925, 1.021274, 1152.838, 1.021318, 10.74897, 1.002495, .9780589, 268.3886, .9781554, 6.461147, -1.810334, -1.851575, -4981.573, -1.851736, -25.3685, -1.028229, -1.038076, -6328.413, -1.038092, -18.84335, -.3727405, -.3743742, -1096.784, -.3743754, -5.341272, .5779432, .5697695, 164.1083, .5697884, 3.798688, 1.083387, 1.055122, 294.6827, 1.055241, 7.019516, .2389214, .2379634, 227.0207, .237964, 2.348868, -.6575496, -.6669395, -330.597, -.6669623, -5.228599, -1.223007, -1.27265, -208.9083, -1.273003, -6.785854, .5404838, .534834, 319.6869, .5348437, 4.536944, -2.227986, -2.295954, -5036.329, -2.296313, -29.24016, .2379562, .2370335, 247.2598, .2370341, 2.410178, 1.05744, 1.030792, 298.8007, 1.030901, 6.939011, .3025656, .3017648, 2051.827, .3017652, 5.726993, -.1662367, -.1664337, -2143.633, -.1664338, -3.898237, .9615754, .9505365, 2399.173, .9505573, 13.04196, .6036977, .5925143, 84.08839, .5925481, 3.12938, -.4469533, -.4512659, -221.0249, -.451273, -3.534449, .9504169, .9381722, 1602.909, .9381981, 11.31303, -1.58407, -1.647805, -602.1467, -1.648254, -11.47494, -.5808498, -.5975259, -27.5484, -.5976085, -2.102526, -.6490194, -.6557381, -799.9641, -.6557499, -6.958708, .6957488, .6903502, 2190.347, .6903571, 10.19701, .1750624, .174529, 150.309, .1745293, 1.663886, .1572418, .1562937, 12.33672, .1562946, .6731502, -.6408126, -.6436554, -9244.279, -.6436575, -15.59954, 1.101677, 1.092417, 10778.35, 1.09243, 23.56244, -.4992968, -.5028596, -835.3172, -.5028639, -5.927292, -.9280973, -1.02178, -6.907707, -1.023576, -1.812064, .6339129, .6277187, 744.4614, .6277287, 6.688065, -.6707486, -.6785607, -647.0199, -.6785761, -6.627439, -1.38237, -1.427934, -602.4287, -1.428195, -10.48056, -1.459774, -1.554047, -125.0777, -1.555148, -6.435521, -1.093153, -1.111322, -1629.418, -1.111374, -12.48719, -.3837357, -.3857544, -717.1755, -.3857562, -4.726757, -.5606073, -.5670648, -326.075, -.5670773, -4.679632, .8169871, .7887753, 38.50973, .7889313, 2.951211, 1.275712, 1.265811, 24735.07, 1.265823, 34.27201, .0862263, .0861666, 766.7436, .0861666, 1.786392, .3344287, .3328024, 485.5152, .3328038, 3.786779, -1.345582, -1.471176, -36.61779, -1.473379, -4.047349, .4774571, .4752944, 2502.141, .475296, 8.29329, .349272, .3477617, 824.9081, .3477628, 4.651336, -.5002936, -.5066125, -158.1673, -.506626, -3.408177, -1.247884, -1.411017, -12.7456, -1.415246, -2.707506, -1.673559, -1.700277, -10051.77, -1.70035, -30.4211, .3986639, .3972206, 2398.038, .3972214, 7.250311, 1.482003, 1.444616, 1148.828, 1.444769, 13.61396, .0587717, .0587566, 3267.75, .0587566, 2.243168, .4706421, .4689196, 4507.782, .4689206, 9.994969, -1.157463, -1.186371, -642.0396, -1.186495, -9.510254]  # noqa:E501
wfs_resids = np.asarray(wfs_resids).astype(float).reshape(-1, 5)
