.\"
.\" @(#)ssync.man,v 1.10 2011/09/02 00:45:47 kim Exp
.\"
.Dd September 1, 2011
.Dt SSYNC 8
.Os
.Sh NAME
.Nm ssync
.Nd distribute files to a set of hosts
.Sh SYNOPSIS
.Nm
.Op Fl ARScgrsvyz
.Op Fl D Ar destdir
.Op Fl f Ar hostfile
.Op Fl h Ar host
.Op Ar files or directories
.Sh DESCRIPTION
The
.Nm
command invokes 
.Xr rsync 1
in an intelligent manner.  Usually
.Nm
is invoked from the master distribution host.
.Pp
Invoking the command without any arguments will distribute the current 
working directory to all hosts in the netgroup for the platform you are
running
.Nm
on.  The name of the group is ``dist-os-rel-arch''
where
.Ar os , rel
and
.Ar arch
are derived from the output of
.Xr osname 1 .
.Pp
If files or directories are specified on the command line, those directories
will be distributed instead of the current directory.  Any file or directory
names are first converted to absolute pathnames on the local machine
before being distributed.
.Pp
The options are:
.Bl -tag -width MMM
.It Fl A
Distribute worldwide by first distributing to ``dist-os-rel-arch-masters''
and then running the same
.Nm
command on each of them.
.It Fl D
The following argument is used as the destination directory.
This causes relocation of the directory that's being distributed,
so care is advised when using this option.
.It Fl R
Remove extraneous files.
.It Fl S
Use
.Xr srsh 1
to create connections to remote hosts.
.It Fl c
Leave out the
.Ar rel
component from the netgroup name. This can be used to distribute files
common to different releases of an operating system. See also
.Fl g .
.It Fl f
The following argument specifies a file listing the hosts or netgroups
to use in place of the default netgroup.
.It Fl g
Leave out the
.Ar arch
component from the netgroup name. This can be used to distribute files
common to different architectures of an operating system. See also
.Fl c .
.It Fl h
The following argument specifies a host or netgroup
to use in place of the default netgroup.
.It Fl r
Convenience alias for
.Fl R .
.It Fl s
Convenience alias for
.Fl S .
.It Fl v
Dummy run -- do not really update or install the files, just print
what would happen.
.It Fl y
Run
.Xr rsync 1
in younger mode.  Do not update remote copies that are
younger than the master copy, but issue a warning message instead.
.It Fl z
Use compression on the transferred data (good for slow links).
.El
.Sh SEE ALSO
.Xr osname 1 ,
.Xr rsync 1 ,
.Xr sdist 1 ,
.Xr srsh 1 ,
.Xr uname 1
.Sh HISTORY
.Nm
was created as a drop-in replacement for
.Xr sdist 1
and thus has switches similar to
.Xr rdist 1
rather than
.Xr rsync 1 .
.Sh AUTHORS
Kimmo Suominen <kim@tac.nyc.ny.us>
