/* # skkinput (Simple Kana-Kanji Input)
 * draw.h
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef draw_h
#define draw_h

#include "FontMgr.h"

enum {
	MODELINE_NOTHING = 0,
	MODELINE_HANKAKU,
	MODELINE_ZENKAKU,
	MODELINE_KATAKANA,
	MODELINE_KANA,
} ;

#define NUMBER_OF_MODELINE				(4)
#define NUMBER_OF_MODELINE_JISYO		(2)
#define NUMBER_OF_MODELINE_OVERTHESPOT	(2)

/*
 * ץȥ
 */
int		skkwin_jputchar (Display*, Window, struct skkinputManagedFont**, GC, int, int, int, int) ;
void	skkwin_jerase (Display*, Window, GC, int, int, int, int, int) ;
int		skkwin_jputMyChar (Display*, Window, struct skkinputManagedFont**, GC, GC, int, int, struct myChar, int, int, int) ;
int		skkwin_jputstring (Display*, Window, struct skkinputManagedFont**, GC, int, int, const struct myChar *) ;
void	skkwin_jdiffputstring (Display*, Window, struct skkinputManagedFont**, GC, GC, int, int, int, struct myChar*, struct myChar*, int, int) ;
void	skkinputDrawCursor (Display*, Window, GC, GC, int, int, int, int, int, int) ;
void	OTSW_CalcTopPositionOfBuffer (struct skkinputManagedFont**, struct myChar*, int, int, int, struct myChar**, int*) ;
void	OTSW_FullDrawTopBufferTopLine (Display*, Window, struct skkinputManagedFont**, GC, GC, struct myChar*, int, int, int, int, int, int, int, int, int) ;
int		skkinput_GetLineNum (struct skkinputManagedFont**, struct myChar*, unsigned int, int, int, int*) ;
int		skkinput_FindStartLine (struct skkinputManagedFont**, struct myChar*, int, unsigned int) ;
void	XChangeWMNormalHints (Display*, Window, XSizeHints*) ;
void	XGetRectangleOfWindow (Display*, Window, XRectangle*) ;
int		skkinput_GetModelineNumber (struct SKKInputNode*) ;
int		skkwin_jputCharString (Display*, Window, struct skkinputManagedFont**, GC, int, int, unsigned char*) ;
int		skkwin_charTextWidth (struct skkinputManagedFont**, unsigned char*, int) ;
int		myCharTextWidth (struct skkinputManagedFont**, const struct myChar*, int) ;
int		getWidthOfModeLine (struct skkinputManagedFont**, struct SKKInputNode*, int, int) ;
int		GetModeLineText (struct SKKInputNode*, int, int, struct myChar*) ;
void	fullDrawModeLine (Display*, Window, struct skkinputManagedFont**, GC, struct SKKInputNode*, int, int, int, int) ;
int		getMaxLengthOfModeline (struct skkinputManagedFont**) ;

#endif
