/* # skkinput (Simple Kana-Kanji Input)
 * KinputP.h --- Kinput Protocol
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef KinputP_h
#define KinputP_h

#include "Kinput.h"
#include "attrs.h"
#include <X11/CoreP.h>

enum {
  WINDOW_TYPE_SEPARATE = 0,
  WINDOW_TYPE_OVERTHESPOT,
  WINDOW_TYPE_OFFTHESPOT,
} ;

enum {
  EVENT_NO_SHORINASHI = 0,
  EVENT_HA_INPUTONLY,
  EVENT_HA_FOCUS_KARA,
} ;

typedef struct {
  Boolean enable_kinput1 ;		/* Kinput Protocol ̤ɤ */

  XtCallbackList setupInputWindowCallback ;
  XtCallbackList serverCloseCallback ;

  Atom convAtom ;			/* _JAPANESE_CONVERSION */
  Atom oldConvAtom ;			/* JAPANESE_CONVERSION */
  Atom ctextAtom ;			/* COMPOUND TEXT */
  Atom convStringAtom ;
  Atom convNotifyAtom ;
  Atom convEndAtom ;
  Atom convAttrAtom ;

  /* ġ */
  struct ConvAttrsMesg camsg ;

  XDestroyWindowEvent *destroyWindowEvent ;

  int jisyo_dirty ;

  /* Kinput Protocol ǽƤ륯饤ȤΥꥹȡ*/
  struct KinputClient	*client_list ;
} KinputPart ;

/* դ뤤󤹤󤹡 */
typedef struct _KinputRec {
  CorePart 	core ;
  KinputPart	kinput ;
} KinputRec ;

/* New fields for the My widget class record */
typedef struct {
  int dummy ;
} KinputClassPart ;

/* դ뤯餹 */
typedef struct _KinputClassRec {
  CoreClassPart		core_class ;
  KinputClassPart	kinput_class ;
} KinputClassRec ;

/* 餹ݤ󤿡 */
extern KinputClassRec kinputClassRec ;

#endif
