/*
 * testlibusb.c
 *
 *  Test suite program
 */

#include <stdio.h>
#include <usb.h>

int main(void)
{
  struct usb_bus *bus;
  struct usb_device *dev;

  usb_init();

  usb_find_busses();

  usb_find_devices();

  printf("bus/device  idVendor/idProduct\n");
  for (bus = usb_busses; bus; bus = bus->next) {
    for (dev = bus->devices; dev; dev = dev->next)
      printf("%s/%s     %04X/%04X\n", bus->dirname, dev->filename,
	dev->descriptor.idVendor, dev->descriptor.idProduct);
  }

  return 0;
}

