# run this with the command "perl Setup.pl" to set up PilotManager.

use Config;
use strict;

BEGIN
{
    use Cwd;
    my ($PWD);
    $PWD = Cwd::cwd();

    unshift(@INC, "$PWD/lib/perl5/$Config::Config{archname}/$]");
    unshift(@INC, "$PWD/lib/perl5/$Config::Config{archname}");
    unshift(@INC, "$PWD/lib/perl5");
    unshift(@INC, "$PWD");
}

require 5.003;

package Setup;

$| = 1;


sub complain
{
    my ($mod, $err) = @_;

    print qq|
	You do not have the correct version of the $mod module
	installed.

        Error details:
-----------------------------------------------------------------------------
$err-----------------------------------------------------------------------------
	    \n|;
    exit;
}

my $CONDUITDIR;

while ($_ = shift)
{
    if ($_ eq '-conduitdir')
    {
        $CONDUITDIR = shift;
    }
    else
    {
        print "Usage: $0 [-conduitdir <dir>]\n";
    }
}

print "Configuring PilotManager...";

eval "use Tk;";
&complain("Tk", $@) if ($@);

eval "use PDA::Pilot;";
&complain("PDA::Pilot", $@) if ($@);

eval "use Data::Dumper;";
&complain("Data::Dumper", $@) if ($@);









if (open(OFD, ">PilotManager")) {
  # Write our new perl exec binary
  #
  print OFD "#!$Config::Config{'perlpath'}\n";
  print OFD '
package PilotMgr;
our $BASEDIR;
our $CONDUITDIR;

# This begin block tracks down the actual location of the
# PilotManager code and puts it into @INC
#
BEGIN
{
    use Config;
    use File::Basename;
    use Cwd;
';
  print OFD qq|    \$CONDUITDIR = "$CONDUITDIR";\n| if $CONDUITDIR;
  print OFD q%
    my ($full);
    my ($cwd);

    $cwd = Cwd::cwd();
    $full = $0;
    while (-l $full)
    {
	$BASEDIR = dirname($full);
	$full = readlink $full;
	($full !~ m|^/|) and $full = $BASEDIR . "/" . $full;
    }
    $BASEDIR = dirname($full);

    $BASEDIR = "$cwd"
	if (!$BASEDIR || $BASEDIR eq "./" || $BASEDIR eq ".");

    $BASEDIR = "$cwd/$BASEDIR"
	unless ($BASEDIR =~ m|^/|);

    # I'd like to do: 'use lib $BASEDIR' but for some reason 
    # 'use lib' doesn't grok variables.
    #
    unshift(@INC, $BASEDIR . "/lib/perl5/$Config::Config{archname}/$]");
    unshift(@INC, $BASEDIR . "/lib/perl5/$Config::Config{archname}");
    unshift(@INC, $BASEDIR . "/lib/perl5");
    unshift(@INC, $BASEDIR);
    unshift(@INC, $CONDUITDIR) if defined $CONDUITDIR;
}

use PilotMgr;

PilotMgr::main();
%;
  close(OFD);
}
else
{
    print "\nError: Unable to write to PilotManager\n";
    exit;
}










chmod(0755, "PilotManager");

$SIG{'INT'} = \&bail;

print "done.\n";
print qq|
PilotManager will now test your system to make sure
that all your conduits will function properly.

Press ^C at any time to abort the tests.

Press <RETURN> to continue.
|;
<STDIN>;

my ($name, $file);
foreach $file (<lib/test/*.t>)
{
    ($name = $file) =~ s|lib/test/(.*)\.t$|$1|;

    print ">> $name <<\n";

    do $file;
}

sub bail
{
    print "Aborting tests\n";
    print "Your installation is complete, but not fully tested.\n";

    &done;
}

&done; 

sub done
{
    print qq|
Your PilotManager installation is complete.  You can invoke it 
by typing 'PilotManager' at your shell prompt.

To ask questions or report bugs, see http://pilotmanager.sourceforge.net/ .
|; 
    exit;
}
